export default {
  translation: {
    common: {
      confirm: 'Подтвердить',
      back: 'Назад',
      noResults: 'Результатов нет.',
      selectPlaceholder: 'выберите значение',
      selectAll: 'Выбрать все',
      delete: 'Удалить',
      deleteModalTitle: 'Вы уверены, что хотите удалить этот элемент?',
      ok: 'Ок',
      cancel: 'Отмена',
      yes: 'Да',
      no: 'Нет',
      total: 'Всего',
      rename: 'Переименовать',
      name: 'Название',
      save: 'Сохранить',
      namePlaceholder: 'Введите название',
      next: 'Далее',
      create: 'Создать',
      edit: 'Редактировать',
      upload: 'Загрузить',
      english: 'Английский',
      portugueseBr: 'Португальский (Бразилия)',
      chinese: 'Китайский упрощенный',
      traditionalChinese: 'Китайский традиционный',
      russian: 'Русский',
      language: 'Язык',
      languageMessage: 'Пожалуйста, укажите ваш язык!',
      languagePlaceholder: 'выберите ваш язык',
      copy: 'Копировать',
      copied: 'Скопировано',
      comingSoon: 'Скоро будет',
      download: 'Скачать',
      close: 'Закрыть',
      preview: 'Предпросмотр',
      move: 'Переместить',
      warn: 'Предупреждение',
      action: 'Действие',
      s: 'С',
      pleaseSelect: 'Пожалуйста, выберите',
      pleaseInput: 'Пожалуйста, введите',
      submit: 'Отправить',
      clear: 'Очистить',
      embedIntoSite: 'Встроить на веб-страницу',
      previousPage: 'Назад',
      nextPage: 'Вперед',
      add: 'Добавить',
      remove: 'Удалить',
      search: 'Поиск',
      noDataFound: 'Данные не найдены.',
      noData: 'Нет данных',
      promptPlaceholder: `Введите текст или используйте / для быстрой вставки переменных.`,
      mcp: {
        namePlaceholder: 'Мой MCP Сервер',
        nameRequired:
          'Длина должна быть от 1 до 64 символов и может содержать только буквы, цифры, дефисы и подчеркивания.',
        urlPlaceholder: 'https://api.example.com/v1/mcp',
        tokenPlaceholder: 'например, eyJhbGciOiJIUzI1Ni...',
      },
    },
    login: {
      loginTitle: 'Войдите в свою учетную запись',
      signUpTitle: 'Создать учетную запись',
      login: 'Войти',
      signUp: 'Зарегистрироваться',
      loginDescription: 'Мы рады снова видеть вас!',
      registerDescription: 'Рады приветствовать вас на борту!',
      emailLabel: 'Email',
      emailPlaceholder: 'Введите email',
      passwordLabel: 'Пароль',
      passwordPlaceholder: 'Введите пароль',
      rememberMe: 'Запомнить меня',
      signInTip: 'Нет учетной записи?',
      signUpTip: 'Уже есть учетная запись?',
      nicknameLabel: 'Никнейм',
      nicknamePlaceholder: 'Введите никнейм',
      register: 'Создать учетную запись',
      continue: 'Продолжить',
      title: 'Ведущий RAG-движок для контекста LLM',
      start: 'Давайте начнем',
      description:
        'Зарегистрируйтесь бесплатно, чтобы изучить передовые RAG-технологии. Создавайте базы знаний и ИИ для развития вашего бизнеса.',
      review: 'на основе 500+ отзывов',
    },
    header: {
      knowledgeBase: 'Датасет',
      chat: 'Чат',
      register: 'Регистрация',
      signin: 'Войти',
      home: 'Главная',
      setting: 'Настройки пользователя',
      logout: 'Выйти',
      fileManager: 'Управление файлами',
      flow: 'Агент',
      search: 'Поиск',
      welcome: 'Добро пожаловать в',
      dataset: 'Датасет',
    },
    knowledgeList: {
      welcome: 'С возвращением',
      description: 'Какие базы знаний вы будете использовать сегодня?',
      createKnowledgeBase: 'Создать Датасет',
      name: 'Название',
      namePlaceholder: 'Пожалуйста, введите название.',
      doc: 'Документы',
      searchKnowledgePlaceholder: 'Поиск',
      noMoreData: `Это всё. Больше ничего нет.`,
    },
    knowledgeDetails: {
      localUpload: 'Локальная загрузка',
      fileSize: 'Размер файла',
      fileType: 'Тип файла',
      uploadedBy: 'Загружено',
      notGenerated: 'Не сгенерировано',
      generatedOn: 'Сгенерировано ',
      subbarFiles: 'Файлы',
      generateKnowledgeGraph:
        'Это извлечет сущности и отношения из всех ваших документов в этом наборе данных. Процесс может занять некоторое время.',
      generateRaptor:
        'Выполняет рекурсивную кластеризацию и суммаризацию фрагментов документов для построения иерархической древовидной структуры, обеспечивая более осознанное извлечение контекста в длинных документах.',
      generate: 'Сгенерировать',
      raptor: 'RAPTOR',
      processingType: 'Тип обработки',
      dataPipeline: 'Пайплайн обработки',
      operations: 'Операции',
      taskId: 'ID задачи',
      duration: 'Продолжительность',
      details: 'Детали',
      status: 'Статус',
      task: 'Задача',
      startDate: 'Дата начала',
      source: 'Источник',
      fileName: 'Имя файла',
      datasetLogs: 'Датасет',
      fileLogs: 'Файл',
      overview: 'Логи',
      success: 'Успешно',
      failed: 'Неудача',
      completed: 'Завершено',
      datasetLog: 'Лог Датасета',
      created: 'Создано',
      learnMore: 'Введение во встроенный пайплайн',
      general: 'Общие',
      chunkMethodTab: 'Метод чанкинга',
      testResults: 'Результаты теста',
      testSetting: 'Настройки теста',
      retrievalTesting: 'Тестирование извлечения',
      retrievalTestingDescription:
        'Проведите тест извлечения, чтобы проверить, может ли RAGFlow восстановить целевой контент для LLM.',
      Parse: 'Парсинг',
      dataset: 'Датасет',
      testing: 'Тестирование извлечения',
      files: 'файлы',
      configuration: 'Конфигурация',
      knowledgeGraph: 'Граф знаний',
      name: 'Название',
      namePlaceholder: 'Пожалуйста, введите название!',
      doc: 'Документы',
      datasetDescription:
        'Пожалуйста, дождитесь завершения парсинга ваших файлов, прежде чем начинать чат с ИИ.',
      addFile: 'Добавить файл',
      searchFiles: 'Поиск по вашим файлам',
      localFiles: 'Локальные файлы',
      emptyFiles: 'Создать пустой файл',
      webCrawl: 'Веб-краулинг',
      chunkNumber: 'Количество чанков',
      uploadDate: 'Дата загрузки',
      chunkMethod: 'Метод чанкинга',
      enabled: 'Включено',
      disabled: 'Выключено',
      action: 'Действие',
      parsingStatus: 'Статус парсинга',
      parsingStatusTip:
        'Время парсинга документа варьируется в зависимости от нескольких факторов. Включение таких функций, как Граф знаний, RAPTOR, Автоизвлечение вопросов или Автоизвлечение ключевых слов, значительно увеличит время обработки. Если индикатор выполнения завис, обратитесь к этим двум FAQ: https://ragflow.io/docs/dev/faq#why-does-my-document-parsing-stall-at-under-one-percent.',
      processBeginAt: 'Начало в',
      processDuration: 'Продолжительность',
      progressMsg: 'Прогресс',
      noTestResultsForRuned:
        'Релевантные результаты не найдены. Попробуйте изменить запрос или параметры.',
      noTestResultsForNotRuned:
        'Тест еще не проводился. Результаты появятся здесь.',
      testingDescription:
        'Проведите тест извлечения, чтобы проверить, может ли RAGFlow восстановить целевой контент для LLM. Если вы изменили настройки по умолчанию, такие как вес ключевого слова или порог схожести, для достижения оптимальных результатов, имейте в виду, что эти изменения не будут сохранены автоматически. Вы должны применить их в настройках вашего чат-ассистента или в настройках компонента Retrieval агента.',
      similarityThreshold: 'Порог схожести',
      similarityThresholdTip:
        'RAGFlow использует либо комбинацию взвешенной схожести по ключевым словам и взвешенного косинусного сходства векторов, либо комбинацию взвешенной схожести по ключевым словам и взвешенного reranking-счета при извлечении. Этот параметр устанавливает порог для схожести между пользовательским запросом и чанками. Любой чанк с оценкой схожести ниже этого порога будет исключен из результатов. По умолчанию порог установлен на 0.2. Это означает, что будут извлекаться только чанки с комбинированной оценкой схожести 20 или выше.',
      vectorSimilarityWeight: 'Вес векторной схожести',
      vectorSimilarityWeightTip:
        'Это устанавливает вес векторной схожести в комбинированной оценке схожести, используемой либо с косинусным сходством векторов, либо с reranking-счетом. Сумма двух весов должна быть равна 1.0.',
      keywordSimilarityWeight: 'Вес схожести по ключевым словам',
      keywordSimilarityWeightTip:
        'Это устанавливает вес схожести по ключевым словам в комбинированной оценке схожести, используемой либо с косинусным сходством векторов, либо с reranking-счетом. Сумма двух весов должна быть равна 1.0.',
      testText: 'Тестовый текст',
      testTextPlaceholder: 'Введите ваш вопрос здесь!',
      testingLabel: 'Запустить',
      similarity: 'Комбинированная схожесть',
      termSimilarity: 'Схожесть терминов',
      vectorSimilarity: 'Векторная схожесть',
      hits: 'Результаты',
      view: 'Просмотр',
      filesSelected: 'Файлов выбрано',
      upload: 'Загрузить',
      run: 'Парсить',
      runningStatus0: 'ОЖИДАНИЕ',
      runningStatus1: 'ПАРСИНГ',
      runningStatus2: 'ОТМЕНЕНО',
      runningStatus3: 'УСПЕХ',
      runningStatus4: 'НЕУДАЧА',
      pageRanges: 'Диапазон страниц',
      pageRangesTip:
        'Диапазон страниц для парсинга; страницы вне этого диапазона обрабатываться не будут.',
      fromPlaceholder: 'от',
      fromMessage: 'Отсутствует номер начальной страницы',
      toPlaceholder: 'до',
      toMessage: 'Отсутствует номер конечной страницы (исключительно)',
      layoutRecognize: 'PDF парсер',
      layoutRecognizeTip:
        'Используйте визуальную модель для анализа макета PDF для эффективного определения заголовков документов, текстовых блоков, изображений и таблиц. Если выбран наивный вариант, будет извлекаться только простой текст из PDF. Обратите внимание, что эта опция в настоящее время работает ТОЛЬКО для PDF-документов.',
      taskPageSize: 'Размер страницы задачи',
      taskPageSizeMessage: 'Пожалуйста, введите размер страницы задачи!',
      taskPageSizeTip: `Во время распознавания макета PDF-файл разбивается на части и обрабатывается параллельно для увеличения скорости обработки. Этот параметр устанавливает размер каждой части. Больший размер части снижает вероятность разделения непрерывного текста между страницами.`,
      addPage: 'Добавить страницу',
      greaterThan: 'Текущее значение должно быть больше, чем "до"!',
      greaterThanPrevious:
        'Текущее значение должно быть больше предыдущего значения "до"!',
      selectFiles: 'Выбрать файлы',
      changeSpecificCategory: 'Изменить конкретную категорию',
      uploadTitle: 'Перетащите ваш файл сюда для загрузки',
      uploadDescription:
        'Поддерживает одиночную или пакетную загрузку файлов. Для локально развернутого RAGFlow: общий ограничение размера файлов за одну загрузку составляет 1 ГБ, с ограничением пакетной загрузки в 32 файла. Нет ограничения на общее количество файлов на аккаунт. Для demo.ragflow.io общий ограничение размера файлов за одну загрузку составляет 10 МБ, каждый файл не должен превышать 10 МБ, максимум 128 файлов на аккаунт.',
      chunk: 'Чанк',
      bulk: 'Пакетно',
      cancel: 'Отмена',
      close: 'Закрыть',
      rerankModel: 'Rerank модель',
      rerankPlaceholder: 'Пожалуйста, выберите',
      rerankTip: `Опционально. Если оставить пустым, RAGFlow будет использовать комбинацию взвешенной схожести по ключевым словам и взвешенного косинусного сходства векторов; если выбрана rerank модель, взвешенный reranking счет заменит взвешенное косинусное сходство векторов. Имейте в виду, что использование rerank модели значительно увеличит время отклика системы. Если вы хотите использовать rerank модель, убедитесь, что вы используете SaaS reranker; если вы предпочитаете локально развернутую rerank модель, убедитесь, что вы запускаете RAGFlow с помощью docker-compose-gpu.yml.`,
      topK: 'Топ-K',
      topKTip: `Используется вместе с Rerank моделью, эта настройка определяет количество текстовых чанков, которые будут отправлены в указанную rerank модель.`,
      delimiter: `Разделитель текста`,
      delimiterTip:
        'Разделитель может состоять из одного или нескольких специальных символов. Если это несколько символов, убедитесь, что они заключены в обратные кавычки (``). Например, если вы настроите разделители так: \\n`##`;, то ваш текст будет разделен по переводам строк, двойным символам решетки (##) и точкам с запятой.',
      html4excel: 'Excel в HTML',
      html4excelTip: `Используется с методом чанкинга General. Когда отключено, электронные таблицы (XLSX или XLS (Excel 97-2003)) в базе знаний будут разобраны в пары ключ-значение. Когда включено, они будут разобраны в HTML таблицы, разделяя каждые 12 строк, если исходная таблица имеет более 12 строк. Подробности см. на https://ragflow.io/docs/dev/enable_excel2html.`,
      autoKeywords: 'Авто-ключевые слова',
      autoKeywordsTip: `Автоматически извлекает N ключевых слов для каждого чанка, чтобы повысить их рейтинг для запросов, содержащих эти ключевые слова. Имейте в виду, что дополнительные токены будут потребляться чат-моделью, указанной в 'Системных настройках модели'. Вы можете проверить или обновить добавленные ключевые слова для чанка из списка чанков. Подробности см. на https://ragflow.io/docs/dev/autokeyword_autoquestion.`,
      autoQuestions: 'Авто-вопросы',
      autoQuestionsTip: `Автоматически извлекает N вопросов для каждого чанка, чтобы повысить их рейтинг для запросов, содержащих эти вопросы. Вы можете проверить или обновить добавленные вопросы для чанка из списка чанков. Эта функция не нарушит процесс чанкинга в случае ошибки, за исключением того, что может добавить пустой результат в исходный чанк. Имейте в виду, что дополнительные токены будут потребляться LLM, указанной в 'Системных настройках модели'. Подробности см. на https://ragflow.io/docs/dev/autokeyword_autoquestion.`,
      redo: 'Вы хотите очистить существующие {{chunkNum}} чанков?',
      setMetaData: 'Установить Метаданные',
      pleaseInputJson: 'Пожалуйста, введите JSON',
      documentMetaTips: `<p>Метаданные представлены в формате Json (они не доступны для поиска). Они будут добавлены в промпт для LLM, если какие-либо чанки этого документа включены в промпт.</p>
<p>Примеры:</p>
<b>Метаданные:</b><br>
<code>
  {
      "Автор": "Алекс Доусон",
      "Дата": "2024-11-12"
  }
</code><br>
<b>Промпт будет:</b><br>
<p>Документ: имя_документа</p>
<p>Автор: Алекс Доусон</p>
<p>Дата: 2024-11-12</p>
<p>Релевантные фрагменты следующие:</p>
<ul>
<li>  Здесь содержимое чанка....</li>
<li>  Здесь содержимое чанка....</li>
</ul>
`,
      metaData: 'Метаданные',
      deleteDocumentConfirmContent:
        'Документ связан с графом знаний. После удаления связанная информация об узлах и отношениях будет удалена, но граф не будет обновлен немедленно. Действие обновления графа выполняется в процессе парсинга нового документа, который несет задачу извлечения графа знаний.',
      plainText: 'Наивный',
      reRankModelWaring: 'Re-rank модель очень требовательна ко времени.',
    },
    knowledgeConfiguration: {
      imageTableContextWindow: 'Окно контекста изображения и таблицы',
      imageTableContextWindowTip:
        'Захватывает N токенов текста выше и ниже изображения и таблицы, чтобы дать более богатый контекст.',
      generationScopeTip:
        'Определяет, генерируется ли RAPTOR для всего набора данных или для одного файла.',
      scopeDataset: 'Датасет',
      generationScope: 'Область генерации',
      scopeSingleFile: 'Один файл',
      autoParse: 'Авто-парсинг',
      rebuildTip:
        'Повторно загружает файлы из связанного источника данных и снова их парсит.',
      baseInfo: 'Основная информация',
      globalIndex: 'Глобальный индекс',
      dataSource: 'Источник данных',
      linkSourceSetTip:
        'Управление связью источника данных с этим набором данных',
      linkDataSource: 'Связать источник данных',
      tocExtraction: 'Улучшение оглавлением',
      tocExtractionTip:
        ' Для существующих чанков генерирует иерархическое оглавление (одна директория на файл). При запросах, когда активировано Улучшение оглавлением, система будет использовать большую модель для определения, какие элементы оглавления релевантны вопросу пользователя, тем самым идентифицируя релевантные чанки.',
      deleteGenerateModalContent: `
        <p>Удаление сгенерированных результатов <strong class='text-text-primary'>{{type}}</strong>
        удалит все производные сущности и отношения из этого набора данных.
        Ваши исходные файлы останутся нетронутыми.<p>
        <br/>
        Вы хотите продолжить?
      `,
      extractRaptor: 'Извлечь Raptor',
      extractKnowledgeGraph: 'Извлечь Граф знаний',
      filterPlaceholder: 'пожалуйста, введите фильтр',
      fileFilterTip: '',
      fileFilter: 'Фильтр файлов',
      setDefaultTip: '',
      setDefault: 'Установить по умолчанию',
      editLinkDataPipeline: 'Редактировать пайплайн обработки',
      linkPipelineSetTip:
        'Управление связью пайплайна обработки с этим набором данных',
      default: 'По умолчанию',
      dataPipeline: 'Пайплайн обработки',
      linkDataPipeline: 'Связать пайплайн обработки',
      enableAutoGenerate: 'Включить авто-генерацию',
      teamPlaceholder: 'Пожалуйста, выберите команду.',
      dataFlowPlaceholder: 'Пожалуйста, выберите пайплайн.',
      buildItFromScratch: 'Построить с нуля',
      dataFlow: 'Пайплайн',
      parseType: 'Тип парсинга',
      manualSetup: 'Выбрать пайплайн',
      builtIn: 'Встроенный',
      titleDescription:
        'Обновите конфигурацию вашей базы знаний здесь, особенно метод чанкинга.',
      name: 'Название базы знаний',
      photo: 'Фото базы знаний',
      photoTip: 'Вы можете загрузить изображение до 4 МБ.',
      description: 'Описание',
      language: 'Язык документа',
      languageMessage: 'Пожалуйста, укажите ваш язык!',
      languagePlaceholder: 'Пожалуйста, укажите ваш язык!',
      permissions: 'Права доступа',
      embeddingModel: 'Модель эмбеддингов',
      chunkTokenNumber: 'Рекомендуемый размер чанка',
      chunkTokenNumberMessage: 'Требуется количество токенов чанка для текста',
      embeddingModelTip:
        'Модель эмбеддингов по умолчанию для базы знаний. После того как в базе знаний появились чанки, при смене модели эмбеддингов система случайным образом выбирает несколько чанков для проверки совместимости, заново кодирует их новой моделью эмбеддингов и вычисляет косинусное сходство между новыми и старыми векторами. Переключение возможно только если среднее сходство по выборке ≥ 0.9. В противном случае необходимо удалить все чанки в базе знаний, чтобы изменить модель.',
      permissionsTip:
        "Если установлено значение 'Команда', все члены вашей команды смогут управлять базой знаний.",
      chunkTokenNumberTip:
        'Это своего рода устанавливает порог токенов для создания чанка. Сегмент с меньшим количеством токенов, чем этот порог, будет объединен со следующими сегментами до тех пор, пока количество токенов не превысит порог, после чего будет создан чанк. Новый чанк не создается, если не встречен разделитель, даже если порог превышен.',
      chunkMethod: 'Метод чанкинга',
      chunkMethodTip: 'Смотрите подсказки справа.',
      upload: 'Загрузить',
      english: 'Английский',
      chinese: 'Китайский',
      portugueseBr: 'Португальский (Бразилия)',
      embeddingModelPlaceholder: 'Пожалуйста, выберите модель эмбеддингов.',
      chunkMethodPlaceholder: 'Пожалуйста, выберите метод чанкинга.',
      save: 'Сохранить',
      me: 'Только я',
      team: 'Команда',
      cancel: 'Отмена',
      methodTitle: 'Описание метода чанкинга',
      methodExamples: 'Примеры',
      methodExamplesDescription:
        'Для наглядности предоставлены следующие скриншоты.',
      dialogueExamplesTitle: 'просмотр',
      methodEmpty:
        'Здесь будет отображено визуальное объяснение категорий базы знаний',
      book: `<p>Поддерживаемые форматы файлов: <b>DOCX</b>, <b>PDF</b>, <b>TXT</b>.</p><p>
      Для каждой книги в PDF, пожалуйста, установите <i>диапазон страниц</i>, чтобы удалить нежелательную информацию и сократить время анализа.</p>`,
      laws: `<p>Поддерживаемые форматы файлов: <b>DOCX</b>, <b>PDF</b>, <b>TXT</b>.</p><p>
      Юридические документы обычно следуют строгому формату написания. Мы используем особенности текста для определения точек разделения.
      </p><p>
      Чанк имеет гранулярность, соответствующую 'СТАТЬЕ', обеспечивая включение всего текста верхнего уровня в чанк.
      </p>`,
      manual: `<p>Поддерживается только <b>PDF</b>.</p><p>
      Мы предполагаем, что руководство имеет иерархическую структуру разделов, используя заголовки самых низких разделов в качестве базовой единицы для чанкинга документов. Поэтому рисунки и таблицы в одном разделе не будут разделены, что может привести к большему размеру чанков.
      </p>`,
      naive: `<p>Поддерживаемые форматы файлов: <b>MD, MDX, DOCX, XLSX, XLS (Excel 97-2003), PPTX, PDF, TXT, JPEG, JPG, PNG, TIF, GIF, CSV, JSON, EML, HTML</b>.</p>
      <p>Этот метод разбивает файлы 'наивным' способом: </p>
      <p>
      <li>Использует модель визуального обнаружения для разделения текстов на меньшие сегменты.</li>
      <li>Затем объединяет соседние сегменты до тех пор, пока количество токенов не превысит порог, указанный в 'Количестве токенов чанка для текста', после чего создается чанк.</li></p>`,
      paper: `<p>Поддерживается только <b>PDF</b> файл.</p><p>
      Статьи будут разделены по разделам, таким как <i>аннотация, 1.1, 1.2</i>. </p><p>
      Этот подход позволяет LLM более эффективно суммировать статью и предоставлять более полные, понятные ответы.
      Однако это также увеличивает контекст для разговоров с ИИ и добавляет вычислительные затраты для LLM. Поэтому во время разговора рассмотрите возможность уменьшения значения '<b>topN</b>'.</p>`,
      presentation: `<p>Поддерживаемые форматы файлов: <b>PDF</b>, <b>PPTX</b>.</p><p>
      Каждая страница в слайдах рассматривается как чанк, с сохранением ее уменьшенного изображения.</p><p>
      <i>Этот метод чанкинга автоматически применяется ко всем загруженным PPT файлам, поэтому вам не нужно указывать его вручную.</i></p>`,
      qa: `
      <p>
      Этот метод чанкинга поддерживает форматы файлов <b>XLSX</b> и <b>CSV/TXT</b>.
    </p>
    <li>
      Если файл в формате <b>XLSX</b> или <b>XLS (Excel 97-2003)</b>, он должен содержать два столбца без заголовков: один для вопросов, другой для ответов, причем столбец с вопросами предшествует столбцу с ответами. Несколько листов
      допустимы, при условии, что столбцы правильно структурированы.
    </li>
    <li>
      Если файл в формате <b>CSV/TXT</b>, он должен быть закодирован в UTF-8 с TAB в качестве разделителя для разделения вопросов и ответов.
    </li>
    <p>
      <i>
        Строки текста, не следующие приведенным выше правилам, будут проигнорированы, и
        каждая пара Вопрос-Ответ будет считаться отдельным чанком.
      </i>
    </p>
      `,
      resume: `<p>Поддерживаемые форматы файлов: <b>DOCX</b>, <b>PDF</b>, <b>TXT</b>.
      </p><p>
      Резюме различных форм анализируются и организуются в структурированные данные для облегчения поиска кандидатов для рекрутеров.
      </p>
      `,
      table: `<p>Поддерживаемые форматы файлов: <b>XLSX</b> и <b>CSV/TXT</b>.</p><p>
      Вот некоторые предварительные условия и советы:
      <ul>
    <li>Для CSV или TXT файла, разделитель между столбцами должен быть <em><b>TAB</b></em>.</li>
    <li>Первая строка должна быть заголовками столбцов.</li>
    <li>Заголовки столбцов должны быть содержательными терминами, чтобы помочь вашему LLM в понимании.
    Хорошей практикой является размещение синонимов через косую черту <i>'/'</i> и перечисление значений с использованием скобок, например: <i>'Пол/Секс (мужской, женский)'</i>.<p>
    Вот несколько примеров заголовков:<ol>
        <li>поставщик/вендор<b>'TAB'</b>Цвет (Желтый, Синий, Коричневый)<b>'TAB'</b>Пол/Секс (мужской, женский)<b>'TAB'</b>размер (M, L, XL, XXL)</li>
        </ol>
        </p>
    </li>
    <li>Каждая строка в таблице будет рассматриваться как чанк.</li>
    </ul>`,
      picture: `
    <p>Поддерживаются файлы изображений, поддержка видео скоро появится.</p><p>
    Этот метод использует модель OCR для извлечения текстов из изображений.
    </p><p>
    Если текст, извлеченный моделью OCR, считается недостаточным, указанная визуальная LLM будет использована для предоставления описания изображения.
    </p>`,
      one: `
    <p>Поддерживаемые форматы файлов: <b>DOCX, XLSX, XLS (Excel 97-2003), PDF, TXT</b>.
    </p><p>
    Этот метод рассматривает каждый документ целиком как один чанк.
    </p><p>
    Применимо, когда вы требуете, чтобы LLM суммировал весь документ, при условии, что он может обработать такой объем контекста.
    </p>`,
      knowledgeGraph: `<p>Поддерживаемые форматы файлов: <b>DOCX, EXCEL, PPT, IMAGE, PDF, TXT, MD, JSON, EML</b>

<p>Этот подход разбивает файлы, используя 'наивный'/'Общий' метод. Он разделяет документ на сегменты, а затем объединяет соседние сегменты до тех пор, пока количество токенов не превысит порог, указанный в 'Количестве токенов чанка для текста', после чего создается чанк.</p>
<p>Затем чанки передаются в LLM для извлечения сущностей и отношений для графа знаний и ментальной карты.</p>
<p>Убедитесь, что вы установили <b>Типы сущностей</b>.</p>`,
      tag: `<p>База знаний, использующая метод чанкинга 'Тег', функционирует как набор тегов. Другие базы знаний используют ее для тегирования своих чанков, и запросы к этим базам знаний также тегируются с использованием этого набора тегов.</p>
<p>Набор тегов <b>НЕ</b> будет напрямую участвовать в процессе RAG (Retrieval-Augmented Generation).</p>
<p>Каждый чанк в этой базе знаний является независимой парой описание-тег.</p>
<p>Поддерживаемые форматы файлов включают <b>XLSX</b> и <b>CSV/TXT</b>:</p>
<p>Если файл в формате <b>XLSX</b>, он должен содержать два столбца без заголовков: один для описаний тегов, другой для имен тегов, причем столбец с описанием предшествует столбцу с тегом. Несколько листов допустимы, при условии, что столбцы правильно структурированы.</p>
<p>Если файл в формате <b>CSV/TXT</b>, он должен быть закодирован в UTF-8 с TAB в качестве разделителя для разделения описаний и тегов.</p>
<p>В столбце Тег <b>запятая</b> используется для разделения тегов.</p>
<i>Строки текста, не следующие приведенным выше правилам, будут проигнорированы.</i>
`,
      useRaptor: 'RAPTOR',
      useRaptorTip:
        'RAPTOR может использоваться для многошаговых вопросно-ответных задач. Перейдите на страницу Файлы, нажмите Сгенерировать > RAPTOR, чтобы включить его. Подробности см. на https://ragflow.io/docs/dev/enable_raptor.',
      prompt: 'Промпт',
      promptTip:
        'Используйте системный промпт, чтобы описать задачу для LLM, указать, как она должна отвечать, и очертить другие различные требования. Системный промпт часто используется вместе с ключами (переменными), которые служат различными входными данными для LLM. Используйте прямую косую черту `/` или кнопку (x), чтобы показать ключи для использования.',
      promptMessage: 'Промпт обязателен',
      promptText: `Пожалуйста, суммируйте следующие параграфы. Будьте внимательны с числами, не выдумывайте. Параграфы следующие:
      {cluster_content}
Выше приведено содержимое, которое вам нужно суммировать.`,
      maxToken: 'Макс. токенов',
      maxTokenTip:
        'Максимальное количество токенов на генерируемый суммаризированный чанк.',
      maxTokenMessage: 'Макс. токенов обязательно',
      threshold: 'Порог',
      thresholdTip:
        'В RAPTOR чанки кластеризуются по их семантическому сходству. Параметр Порог устанавливает минимальное сходство, необходимое для группировки чанков вместе. Более высокий Порог означает меньше чанков в каждом кластере, а более низкий - больше.',
      thresholdMessage: 'Порог обязателен',
      maxCluster: 'Макс. кластеров',
      maxClusterTip: 'Максимальное количество создаваемых кластеров.',
      maxClusterMessage: 'Макс. кластеров обязательно',
      randomSeed: 'Случайное начальное число',
      randomSeedMessage: 'Случайное начальное число обязательно',
      entityTypes: 'Типы сущностей',
      vietnamese: 'Вьетнамский',
      pageRank: 'Page rank',
      pageRankTip: `Вы можете назначить более высокий балл PageRank определенным базам знаний во время извлечения. Соответствующий балл добавляется к комбинированным оценкам схожести извлеченных чанков из этих баз знаний, повышая их рейтинг. Подробности см. на https://ragflow.io/docs/dev/set_page_rank.`,
      tagName: 'Тег',
      frequency: 'Частота',
      searchTags: 'Поиск тегов',
      tagCloud: 'Облако',
      tagTable: 'Таблица',
      tagSet: 'Наборы тегов',
      tagSetTip: `
     <p> Выберите одну или несколько баз знаний тегов для автоматического тегирования чанков в вашей базе знаний. Подробности см. на https://ragflow.io/docs/dev/use_tag_sets.</p>
<p>Пользовательский запрос также будет автоматически тегирован.</p>
Эта функция автоматического тегирования улучшает извлечение, добавляя еще один уровень предметно-ориентированных знаний к существующему набору данных.
<p>Разница между авто-тегом и авто-ключевым словом:</p>
<ul>
  <li>База знаний тегов - это определенный пользователем закрытый набор, тогда как ключевые слова, извлеченные LLM, можно рассматривать как открытый набор.</li>
  <li>Вы должны загрузить наборы тегов в указанных форматах перед запуском функции авто-тегирования.</li>
  <li>Функция авто-ключевых слов зависит от LLM и потребляет значительное количество токенов.</li>
</ul>
      `,
      topnTags: 'Топ-N Тегов',
      tags: 'Теги',
      addTag: 'Добавить тег',
      useGraphRag: 'Граф знаний',
      useGraphRagTip:
        'Строит граф знаний поверх чанков файлов текущей базы знаний для улучшения многошагового вопросно-ответа, включающего вложенную логику. Подробности см. на https://ragflow.io/docs/dev/construct_knowledge_graph.',
      graphRagMethod: 'Метод',
      graphRagMethodTip: `
      Light: (По умолчанию) Использует промпты, предоставленные github.com/HKUDS/LightRAG, для извлечения сущностей и отношений. Этот вариант потребляет меньше токенов, памяти и вычислительных ресурсов.</br>
      General: Использует промпты, предоставленные github.com/microsoft/graphrag, для извлечения сущностей и отношений`,
      resolution: 'Разрешение сущностей',
      resolutionTip: `Переключатель дедубликации сущностей. Когда включен, LLM будет объединять похожие сущности - например, '2025' и 'год 2025', или 'IT' и 'Информационные технологии' - для построения более точного графа`,
      community: 'Отчеты сообществ',
      communityTip:
        'В графе знаний сообщество - это кластер сущностей, связанных отношениями. Вы можете поручить LLM генерировать аннотацию для каждого сообщества, известную как отчет сообщества. Более подробная информация здесь: https://www.microsoft.com/en-us/research/blog/graphrag-improving-global-search-via-dynamic-community-selection/',
      theDocumentBeingParsedCannotBeDeleted:
        'Документ, который в данный момент парсится, не может быть удален',
      paddleocrOptions: 'Параметры PaddleOCR',
      paddleocrApiUrl: 'URL API PaddleOCR',
      paddleocrApiUrlTip: 'URL конечной точки API сервиса PaddleOCR',
      paddleocrApiUrlPlaceholder:
        'Например: https://paddleocr-server.com/layout-parsing',
      paddleocrAccessToken: 'Токен доступа AI Studio',
      paddleocrAccessTokenTip: 'Токен доступа к API PaddleOCR (необязательно)',
      paddleocrAccessTokenPlaceholder: 'Ваш токен AI Studio (необязательно)',
      paddleocrAlgorithm: 'Алгоритм PaddleOCR',
      paddleocrAlgorithmTip: 'Алгоритм, используемый для обработки PaddleOCR',
      paddleocrSelectAlgorithm: 'Выбрать алгоритм',
      paddleocrModelNamePlaceholder: 'Например: paddleocr-среда-1',
    },
    chunk: {
      chunk: 'Чанк',
      bulk: 'Пакетно',
      selectAll: 'Выбрать все',
      enabledSelected: 'Включить выбранные',
      disabledSelected: 'Выключить выбранные',
      deleteSelected: 'Удалить выбранные',
      search: 'Поиск',
      all: 'Все',
      enabled: 'Включено',
      disabled: 'Выключено',
      keyword: 'Ключевое слово',
      function: 'Функция',
      chunkMessage: 'Пожалуйста, введите значение!',
      full: 'Полный текст',
      ellipse: 'Сокращение',
      graph: 'Граф знаний',
      mind: 'Ментальная карта',
      question: 'Вопрос',
      questionTip: `Если есть заданные вопросы, эмбеддинг чанка будет основан на них.`,
      chunkResult: 'Результат чанка',
      chunkResultTip: `Просмотр сегментов чанков, используемых для эмбеддинга и извлечения.`,
      enable: 'Включить',
      disable: 'Выключить',
      delete: 'Удалить',
    },
    chat: {
      messagePlaceholder: 'Введите ваше сообщение здесь...',
      exit: 'Выход',
      multipleModels: 'Несколько моделей',
      applyModelConfigs: 'Применить настройки моделей',
      conversations: 'Диалоги',
      chatApps: 'Чат-приложения',
      newConversation: 'Новый диалог',
      createAssistant: 'Создать ассистента',
      assistantSetting: 'Настройки ассистента',
      promptEngine: 'Промпт-движок',
      modelSetting: 'Настройки модели',
      chat: 'Чат',
      newChat: 'Новый чат',
      send: 'Отправить',
      sendPlaceholder: 'Сообщение ассистенту...',
      chatConfiguration: 'Конфигурация чата',
      chatConfigurationDescription:
        ' Настройте чат-ассистента для ваших выбранных наборов данных (баз знаний) здесь! 💕',
      assistantName: 'Имя ассистента',
      assistantNameMessage: 'Имя ассистента обязательно',
      namePlaceholder: 'например, Резюме Джарвис',
      assistantAvatar: 'Аватар ассистента',
      language: 'Язык',
      emptyResponse: 'Пустой ответ',
      emptyResponseTip: `Установите это как ответ, если по вашему запросу не найдено результатов из баз знаний, или оставьте это поле пустым, чтобы позволить LLM импровизировать, когда ничего не найдено.`,
      emptyResponseMessage: `Пустой ответ будет срабатывать, когда ничего релевантного не извлечено из баз знаний. Вы должны очистить поле 'Пустой ответ', если не выбрана ни одна база знаний.`,
      setAnOpener: 'Приветственное сообщение',
      setAnOpenerInitial: `Привет! Я ваш ассистент. Чем могу помочь?`,
      setAnOpenerTip: 'Установите приветственное сообщение для пользователей.',
      knowledgeBases: 'Датасеты',
      knowledgeBasesMessage: 'Пожалуйста, выберите',
      knowledgeBasesTip:
        'Выберите наборы данных для связи с этим чат-ассистентом. Пустая база знаний не появится в выпадающем списке.',
      system: 'Системный промпт',
      systemInitialValue: `Вы - интеллектуальный ассистент. Пожалуйста, обобщите содержание базы знаний, чтобы ответить на вопрос. Пожалуйста, перечислите данные в базе знаний и ответьте подробно. Когда все содержимое базы знаний не релевантно вопросу, ваш ответ должен включать фразу "Ответ, который вы ищете, не найден в базе знаний!" Ответы должны учитывать историю чата.
      Вот база знаний:
      {knowledge}
      Выше приведена база знаний.`,
      systemMessage: 'Пожалуйста, введите!',
      systemTip:
        'Ваши промпты или инструкции для LLM, включая, но не ограничиваясь, его ролью, желаемой длиной, тоном и языком ответов. Если ваша модель имеет нативную поддержку рассуждений, вы можете добавить //no_thinking в промпт, чтобы остановить рассуждения.',
      topN: 'Топ N',
      topNTip: `Не все чанки с оценкой схожести выше 'порога схожести' будут отправлены в LLM. Это выбирает 'Топ N' чанков из извлеченных.`,
      variable: 'Переменная',
      variableTip: `Используется вместе с API управления чат-ассистентами RAGFlow, переменные могут помочь разработать более гибкие стратегии системных промптов. Определенные переменные будут использоваться 'Системным промптом' как часть промптов для LLM. {knowledge} - зарезервированная специальная переменная, представляющая чанки, извлеченные из указанных баз знаний, и все переменные должны быть заключены в фигурные скобки {} в 'Системном промпте'. Подробности см. на https://ragflow.io/docs/dev/set_chat_variables.`,
      add: 'Добавить',
      key: 'Ключ',
      optional: 'Опционально',
      operation: 'Операция',
      model: 'Модель',
      modelTip: 'Большая языковая чат-модель',
      modelMessage: 'Пожалуйста, выберите!',
      modelEnabledTools: 'Включенные инструменты',
      modelEnabledToolsTip:
        'Пожалуйста, выберите один или несколько инструментов для использования чат-моделью. Не действует для моделей, не поддерживающих вызов инструментов.',
      freedom: 'Креативность',
      improvise: 'Импровизировать',
      precise: 'Точно',
      balance: 'Баланс',
      custom: 'Пользовательский',
      freedomTip: `Ярлык для настроек 'Температура', 'Top P', 'Штраф за присутствие' и 'Штраф за частоту', указывающий уровень свободы модели. Этот параметр имеет три варианта: Выберите 'Импровизировать' для получения более творческих ответов; выберите 'Точно' (по умолчанию) для получения более консервативных ответов; 'Баланс' - это золотая середина между 'Импровизировать' и 'Точно'.`,
      temperature: 'Температура',
      temperatureMessage: 'Температура обязательна',
      temperatureTip: `Этот параметр контролирует случайность предсказаний модели. Более низкая температура приводит к более консервативным ответам, а более высокая температура дает более творческие и разнообразные ответы.`,
      topP: 'Top P',
      topPMessage: 'Top P обязателен',
      topPTip:
        'Также известный как "ядерная выборка", этот параметр устанавливает порог для выбора меньшего набора наиболее вероятных слов для выборки, отсекая менее вероятные.',
      presencePenalty: 'Штраф за присутствие',
      presencePenaltyMessage: 'Штраф за присутствие обязателен',
      presencePenaltyTip:
        'Это препятствует повторению моделью одной и той же информации, штрафуя слова, которые уже появились в разговоре.',
      frequencyPenalty: 'Штраф за частоту',
      frequencyPenaltyMessage: 'Штраф за частоту обязателен',
      frequencyPenaltyTip:
        'Подобно штрафу за присутствие, это снижает тенденцию модели часто повторять одни и те же слова.',
      maxTokens: 'Макс. токенов',
      maxTokensMessage: 'Макс. токенов обязательно',
      maxTokensTip: `Максимальный размер контекста mодель; недопустимое или неверное значение приведёт к ошибке. По умолчанию 512.`,
      maxTokensInvalidMessage:
        'Пожалуйста, введите действительное число для Макс. Токенов.',
      maxTokensMinMessage: 'Макс. Токенов не может быть меньше 0.',
      quote: 'Показать цитату',
      quoteTip: 'Отображать ли исходный текст в качестве ссылки.',
      selfRag: 'Self-RAG',
      selfRagTip:
        'Пожалуйста, обратитесь к: https://huggingface.co/papers/2310.11511',
      overview: 'ID чата',
      pv: 'Количество сообщений',
      uv: 'Количество активных пользователей',
      speed: 'Скорость вывода токенов',
      tokens: 'Потреблено токенов',
      round: 'Количество взаимодействий в сессии',
      thumbUp: 'Удовлетворенность клиентов',
      preview: 'Предпросмотр',
      embedded: 'Встроенный',
      serviceApiEndpoint: 'Конечная точка сервисного API',
      apiKey: 'API KEY',
      apiReference: 'Документация API',
      dateRange: 'Диапазон дат:',
      backendServiceApi: 'API Сервер',
      createNewKey: 'Создать новый ключ',
      created: 'Создано',
      action: 'Действие',
      embedModalTitle: 'Встроить на веб-страницу',
      comingSoon: 'Скоро будет',
      fullScreenTitle: 'Полное встраивание',
      fullScreenDescription:
        'Встройте следующий iframe на ваш веб-сайт в желаемом месте',
      partialTitle: 'Частичное встраивание',
      extensionTitle: 'Расширение Chrome',
      tokenError: 'Пожалуйста, сначала создайте API ключ.',
      betaError:
        'Пожалуйста, сначала получите RAGFlow API ключ на странице Системных настроек.',
      searching: 'Поиск...',
      parsing: 'Парсинг',
      uploading: 'Загрузка',
      uploadFailed: 'Ошибка загрузки',
      regenerate: 'Перегенерировать',
      read: 'Прочитать содержимое',
      tts: 'Текст в речь',
      ttsTip:
        'Убедитесь, что вы выбрали модель TTS на странице Настройки, прежде чем включать этот переключатель для воспроизведения текста в виде аудио.',
      relatedQuestion: 'Связанный вопрос',
      answerTitle: 'R',
      multiTurn: 'Многошаговая оптимизация',
      multiTurnTip:
        'Это оптимизирует пользовательские запросы с использованием контекста в многораундовом разговоре. Когда включено, будет потреблять дополнительные токены LLM.',
      howUseId: 'Как использовать ID чата?',
      description: 'Описание ассистента',
      descriptionPlaceholder: 'например, Чат-ассистент для резюме.',
      useKnowledgeGraph: 'Использовать граф знаний',
      useKnowledgeGraphTip:
        'Использовать ли граф(ы) знаний в указанных базах знаний во время извлечения для многошагового вопросно-ответа. Когда включено, это будет включать итеративные поиски по сущностям, отношениям и чанкам отчетов сообществ, значительно увеличивая время извлечения.',
      keyword: 'Анализ ключевых слов',
      keywordTip: `Использовать LLM для анализа вопросов пользователя, извлечения ключевых слов, которые будут подчеркнуты во время вычисления релевантности. Хорошо работает с длинными запросами, но увеличит время ответа.`,
      languageTip:
        'Позволяет переписывать предложения на указанном языке или по умолчанию на языке последнего вопроса, если не выбрано.',
      avatarHidden: 'Скрыть аватар',
      locale: 'Локаль',
      selectLanguage: 'Выберите язык',
      reasoning: 'Рассуждение',
      reasoningTip: `Включать ли рабочий процесс рассуждений во время вопросно-ответа, как в моделях типа Deepseek-R1 или OpenAI o1. Когда включено, это позволяет модели получать доступ к внешним знаниям и решать сложные вопросы шаг за шагом, используя такие методы, как цепочка рассуждений. Этот подход улучшает способность модели предоставлять точные ответы, разбивая проблемы на управляемые шаги, улучшая производительность на задачах, требующих логического мышления и многошагового подхода.`,
      tavilyApiKeyTip:
        'Если здесь правильно установлен API ключ, для дополнения извлечения из базы знаний будут использоваться веб-поиски на основе Tavily.',
      tavilyApiKeyMessage: 'Пожалуйста, введите ваш Tavily API Key',
      tavilyApiKeyHelp: 'Как его получить?',
      crossLanguage: 'Кросс-языковой поиск',
      crossLanguageTip: `Выберите один или несколько языков для кросс-языкового поиска. Если язык не выбран, система выполняет поиск с исходным запросом.`,
      createChat: 'Создать чат',
      metadata: 'Метаданные',
      metadataTip:
        'Фильтрация по метаданным - это процесс использования атрибутов метаданных (таких как теги, категории или права доступа) для уточнения и контроля извлечения релевантной информации в системе.',
      conditions: 'Условия',
      addCondition: 'Добавить условие',
      meta: {
        disabled: 'Выключено',
        auto: 'Автоматически',
        manual: 'Вручную',
      },
      cancel: 'Отмена',
      chatSetting: 'Настройки чата',
      tocEnhance: 'Улучшение оглавлением',
      tocEnhanceTip: ` Во время парсинга документа была сгенерирована информация оглавления (см. опцию 'Включить извлечение оглавления' в методе General). Это позволяет большой модели возвращать элементы оглавления, релевантные запросу пользователя, тем самым используя эти элементы для извлечения связанных чанков и применения весов к этим чанкам в процессе сортировки. Этот подход получен из имитации поведенческой логики того, как люди ищут знания в книгах.`,
    },
    setting: {
      edit: 'Редактировать',
      cropTip:
        'Перетащите область выбора, чтобы выбрать позицию обрезки изображения, и прокрутите для увеличения/уменьшения',
      cropImage: 'Обрезать изображение',
      selectModelPlaceholder: 'Выберите модель',
      configureModelTitle: 'Настроить модель',
      confluenceIsCloudTip:
        'Отметьте, если это экземпляр Confluence Cloud, снимите для Confluence Server/Data Center',
      confluenceWikiBaseUrlTip:
        'Базовый URL вашего экземпляра Confluence (например, https://your-domain.atlassian.net/wiki)',
      confluenceSpaceKeyTip:
        'Необязательно: Укажите ключ пространства для синхронизации только определенного пространства. Оставьте пустым для синхронизации всех доступных пространств. Для нескольких пространств разделите запятыми (например, DEV,DOCS,HR)',
      s3PrefixTip: `Укажите путь к папке в вашем S3 бакете для получения файлов.
Пример: general/v2/`,
      S3CompatibleEndpointUrlTip: `Требуется для S3 совместимого Storage Box. Укажите URL конечной точки, совместимой с S3.
Пример: https://fsn1.your-objectstorage.com`,
      S3CompatibleAddressingStyleTip: `Требуется для S3 совместимого Storage Box. Укажите стиль адресации, совместимый с S3.
Пример: Virtual Hosted Style`,
      addDataSourceModalTitle: 'Создайте ваш коннектор {{name}}',
      deleteSourceModalTitle: 'Удалить источник данных',
      deleteSourceModalContent: `
      <p>Вы уверены, что хотите удалить эту ссылку на источник данных?</p>`,
      deleteSourceModalConfirmText: 'Подтвердить',
      errorMsg: 'Сообщение об ошибке',
      newDocs: 'Новые документы',
      timeStarted: 'Время начала',
      log: 'Лог',
      connectorNameTip: 'Укажите понятное имя для коннектора',
      confluenceDescription:
        'Интегрируйте ваше рабочее пространство Confluence для поиска документации.',
      s3Description:
        'Подключитесь к вашему AWS S3 бакету для импорта и синхронизации хранимых файлов.',
      oci_storageDescription:
        'Подключите бакет Oracle Cloud Object Storage для импорта и синхронизации файлов.',
      r2Description:
        'Подключите ваш бакет Cloudflare R2 для импорта и синхронизации файлов.',
      google_cloud_storageDescription:
        'Подключите бакет Google Cloud Storage для импорта и синхронизации файлов.',
      discordDescription:
        'Свяжите ваш Discord сервер для доступа и анализа данных чата.',
      notionDescription:
        'Синхронизируйте страницы и базы данных из Notion для извлечения знаний.',
      boxDescription:
        'Подключите ваш диск Box для синхронизации файлов и папок.',
      bitbucketDescription:
        'Подключите Bitbucket для синхронизации содержимого PR.',
      zendeskDescription:
        'Подключите Zendesk для синхронизации тикетов, статей и другого контента.',
      bitbucketTopWorkspaceTip:
        'Рабочее пространство Bitbucket для индексации (например, "atlassian" из https://bitbucket.org/atlassian/workspace )',
      bitbucketWorkspaceTip:
        'Этот коннектор проиндексирует все репозитории в рабочем пространстве.',
      bitbucketProjectsTip:
        'Ключи проектов через запятую, например: PROJ1,PROJ2',
      bitbucketRepositorySlugsTip:
        'Слоги репозиториев через запятую, например: repo-one,repo-two',
      githubDescription:
        'Подключите GitHub для синхронизации содержимого Pull Request и Issue для поиска.',
      airtableDescription:
        'Подключите Airtable и синхронизируйте файлы из указанной таблицы в заданном рабочем пространстве.',
      gitlabDescription:
        'Подключите GitLab для синхронизации репозиториев, задач, merge requests и связанной документации.',
      asanaDescription:
        'Подключите Asana и синхронизируйте файлы из рабочего пространства.',
      imapDescription:
        'Подключите почтовый ящик IMAP для синхронизации писем из указанных почтовых ящиков (mailboxes) с целью поиска и анализа знаний.',
      google_driveDescription:
        'Подключите ваш Google Drive через OAuth и синхронизируйте определенные папки или диски.',
      gmailDescription:
        'Подключите ваш Gmail / Google Workspace аккаунт для синхронизации писем и их метаданных, чтобы построить корпоративную почтовую базу знаний и поиск с учетом прав доступа.',
      google_driveTokenTip:
        'Загрузите JSON токена OAuth, сгенерированный из помощника OAuth или Google Cloud Console. Вы также можете загрузить client_secret JSON из "установленного" или "веб" приложения. Если это ваша первая синхронизация, откроется окно браузера для завершения согласия OAuth. Если JSON уже содержит токен обновления, он будет автоматически повторно использован.',
      google_drivePrimaryAdminTip:
        'Адрес электронной почты, который имеет доступ к содержимому Диска, которое синхронизируется.',
      google_driveMyDriveEmailsTip:
        'Электронные почты через запятую, чье содержимое "Мой диск" должно индексироваться (включите основного администратора).',
      google_driveSharedFoldersTip:
        'Ссылки на папки Google Drive через запятую для обхода.',
      gmailPrimaryAdminTip:
        'Основной административный email с доступом к Gmail / Workspace, используется для перечисления пользователей домена и как аккаунт синхронизации по умолчанию.',
      gmailTokenTip:
        'Загрузите OAuth JSON, сгенерированный в Google Console. Если он содержит только учетные данные клиента, выполните одноразовое подтверждение в браузере, чтобы получить долгоживущие токены обновления.',
      jiraDescription:
        'Подключите ваше рабочее пространство Jira для синхронизации задач, комментариев и вложений.',
      jiraBaseUrlTip:
        'Базовый URL вашего сайта Jira (например, https://your-domain.atlassian.net).',
      jiraProjectKeyTip:
        'Опционально: ограничьте синхронизацию одним ключом проекта (например, ENG).',
      jiraJqlTip:
        'Опциональный фильтр JQL. Оставьте пустым, чтобы полагаться на фильтры проекта/времени.',
      jiraBatchSizeTip:
        'Максимальное количество задач, запрашиваемых из Jira за пакет.',
      jiraCommentsTip:
        'Включить комментарии Jira в сгенерированный markdown документ.',
      jiraAttachmentsTip:
        'Загружать вложения как отдельные документы во время синхронизации.',
      jiraAttachmentSizeTip:
        'Вложения размером больше этого количества байт будут пропущены.',
      jiraLabelsTip:
        'Метки, которые должны быть пропущены при индексации (через запятую).',
      jiraBlacklistTip:
        'Комментарии, автор которых соответствует этим записям, будут игнорироваться.',
      jiraScopedTokenTip:
        'Включите это при использовании ограниченных токенов Atlassian (api.atlassian.com).',
      jiraEmailTip: 'Email, связанный с учетной записью/API токеном Jira.',
      jiraTokenTip:
        'API токен, сгенерированный из https://id.atlassian.com/manage-profile/security/api-tokens.',
      jiraPasswordTip: 'Опциональный пароль для сред Jira Server/Data Center.',
      availableSourcesDescription: 'Выберите источник данных для добавления',
      availableSources: 'Доступные источники',
      datasourceDescription:
        'Управляйте вашими источниками данных и подключениями',
      save: 'Сохранить',
      search: 'Поиск',
      availableModels: 'Доступные модели',
      profile: 'Профиль',
      avatar: 'Аватар',
      avatarTip: 'Это будет отображаться в вашем профиле.',
      profileDescription: 'Обновите ваше фото и личные данные здесь.',
      maxTokens: 'Макс. Токенов',
      maxTokensMessage: 'Макс. Токенов обязательно',
      maxTokensTip: `Максимальный размер контекста mодель; недопустимое или неверное значение приведёт к ошибке. По умолчанию 512.`,
      maxTokensInvalidMessage:
        'Пожалуйста, введите действительное число для Макс. Токенов.',
      maxTokensMinMessage: 'Макс. Токенов не может быть меньше 0.',
      password: 'Пароль',
      passwordDescription:
        'Пожалуйста, введите ваш текущий пароль, чтобы изменить ваш пароль.',
      model: 'Провайдеры моделей',
      systemModelDescription:
        'Пожалуйста, завершите эти настройки перед началом',
      dataSources: 'Источники данных',
      team: 'Команда',
      system: 'Система',
      logout: 'Выйти',
      api: 'API',
      username: 'Имя',
      usernameMessage: 'Пожалуйста, введите ваше имя!',
      photo: 'Ваше фото',
      photoDescription: 'Это будет отображаться в вашем профиле.',
      colorSchema: 'Цветовая схема',
      colorSchemaMessage: 'Пожалуйста, выберите вашу цветовую схему!',
      colorSchemaPlaceholder: 'выберите вашу цветовую схему',
      bright: 'Светлая',
      dark: 'Темная',
      timezone: 'Часовой пояс',
      timezoneMessage: 'Пожалуйста, укажите ваш часовой пояс!',
      timezonePlaceholder: 'выберите ваш часовой пояс',
      email: 'Email',
      emailDescription: 'После регистрации Email нельзя изменить.',
      currentPassword: 'Текущий пароль',
      currentPasswordMessage: 'Пожалуйста, введите ваш пароль!',
      newPassword: 'Новый пароль',
      changePassword: 'Изменить пароль',
      newPasswordMessage: 'Пожалуйста, введите ваш пароль!',
      newPasswordDescription:
        'Ваш новый пароль должен быть длиннее 8 символов.',
      confirmPassword: 'Подтвердите новый пароль',
      confirmPasswordMessage: 'Пожалуйста, подтвердите ваш пароль!',
      confirmPasswordNonMatchMessage:
        'Введенные вами новые пароли не совпадают!',
      cancel: 'Отмена',
      addedModels: 'Добавленные модели',
      modelsToBeAdded: 'Модели для добавления',
      addTheModel: 'Добавить',
      apiKey: 'API-Ключ',
      apiKeyMessage: 'Пожалуйста, введите API ключ',
      apiKeyTip:
        'API ключ можно получить, зарегистрировавшись у соответствующего поставщика LLM.',
      showMoreModels: 'Показать модели',
      hideModels: 'Скрыть модели',
      baseUrl: 'Базовый-Url',
      baseUrlTip:
        'Если ваш API ключ от OpenAI, просто проигнорируйте это. Любые другие промежуточные провайдеры дадут этот базовый url вместе с API ключом.',
      tongyiBaseUrlTip:
        'Для китайских пользователей не нужно заполнять или используйте https://dashscope.aliyuncs.com/compatible-mode/v1. Для международных пользователей используйте https://dashscope-intl.aliyuncs.com/compatible-mode/v1',
      tongyiBaseUrlPlaceholder:
        '(Только для международных пользователей, см. подсказку)',
      minimaxBaseUrlTip:
        'Только для международных пользователей: используйте https://api.minimax.io/v1.',
      minimaxBaseUrlPlaceholder:
        '(Только для международных пользователей, введите https://api.minimax.io/v1)',
      modify: 'Изменить',
      systemModelSettings: 'Установить модели по умолчанию',
      chatModel: 'LLM',
      chatModelTip: 'LLM по умолчанию для каждой новой созданной базы знаний.',
      embeddingModel: 'Эмбеддинг',
      embeddingModelTip:
        'Модель эмбеддингов по умолчанию для каждой новой созданной базы знаний. Если вы не можете найти модель эмбеддингов в выпадающем списке, проверьте, используете ли вы облегченную версию RAGFlow (которая не включает модели эмбеддингов) или проверьте https://ragflow.io/docs/dev/supported_models, чтобы узнать, поддерживает ли ваш провайдер моделей эту модель.',
      img2txtModel: 'VLM',
      img2txtModelTip:
        'VLM по умолчанию для каждой новой созданной базы знаний. Она описывает изображение или видео. Если вы не можете найти модель в выпадающем списке, проверьте https://ragflow.io/docs/dev/supported_models, чтобы узнать, поддерживает ли ваш провайдер моделей эту модель.',
      sequence2txtModel: 'ASR',
      sequence2txtModelTip:
        'Модель ASR по умолчанию для каждой новой созданной базы знаний. Используйте эту модель для преобразования голоса в соответствующий текст.',
      rerankModel: 'Rerank',
      rerankModelTip: `Модель rerank по умолчанию для переранжирования чанков. Если вы не можете найти модель в выпадающем списке, проверьте https://ragflow.io/docs/dev/supported_models, чтобы узнать, поддерживает ли ваш провайдер моделей эту модель.`,
      ttsModel: 'TTS',
      ttsModelTip:
        'Модель преобразования текста в речь по умолчанию. Если вы не можете найти модель в выпадающем списке, проверьте https://ragflow.io/docs/dev/supported_models, чтобы узнать, поддерживает ли ваш провайдер моделей эту модель.',
      workspace: 'рабочее пространство',
      upgrade: 'Обновить',
      addLlmTitle: 'Добавить LLM',
      editLlmTitle: 'Редактировать модель {{name}}',
      editModel: 'Редактировать модель',
      modelName: 'Название модели',
      modelID: 'ID модели',
      modelUid: 'UID модели',
      modelNameMessage: 'Пожалуйста, введите название вашей модели!',
      modelType: 'Тип модели',
      modelTypeMessage: 'Пожалуйста, введите тип вашей модели!',
      addLlmBaseUrl: 'Базовый url',
      baseUrlNameMessage: 'Пожалуйста, введите ваш базовый url!',
      vision: 'Поддерживает ли Vision?',
      ollamaLink: 'Как интегрировать {{name}}',
      FishAudioLink: 'Как использовать FishAudio',
      TencentCloudLink: 'Как использовать TencentCloud ASR',
      volcModelNameMessage: 'Пожалуйста, введите название вашей модели!',
      addEndpointID: 'EndpointID модели',
      endpointIDMessage: 'Пожалуйста, введите EndpointID модели',
      addArkApiKey: 'VOLC ARK_API_KEY',
      ArkApiKeyMessage: 'Пожалуйста, введите ваш ARK_API_KEY',
      bedrockModelNameMessage: 'Пожалуйста, введите название вашей модели!',
      addBedrockEngineAK: 'ACCESS KEY',
      bedrockAKMessage: 'Пожалуйста, введите ваш ACCESS KEY',
      addBedrockSK: 'SECRET KEY',
      bedrockSKMessage: 'Пожалуйста, введите ваш SECRET KEY',
      bedrockRegion: 'AWS Регион',
      bedrockRegionMessage: 'Пожалуйста, выберите!',
      'us-east-2': 'US East (Огайо)',
      'us-east-1': 'US East (Северная Вирджиния)',
      'us-west-1': 'US West (Северная Калифорния)',
      'us-west-2': 'US West (Орегон)',
      'af-south-1': 'Африка (Кейптаун)',
      'ap-east-1': 'Азия-Тихоокеанский регион (Гонконг)',
      'ap-south-2': 'Азия-Тихоокеанский регион (Хайдарабад)',
      'ap-southeast-3': 'Азия-Тихоокеанский регион (Джакарта)',
      'ap-southeast-5': 'Азия-Тихоокеанский регион (Малайзия)',
      'ap-southeast-4': 'Азия-Тихоокеанский регион (Мельбурн)',
      'ap-south-1': 'Азия-Тихоокеанский регион (Мумбаи)',
      'ap-northeast-3': 'Азия-Тихоокеанский регион (Осака)',
      'ap-northeast-2': 'Азия-Тихоокеанский регион (Сеул)',
      'ap-southeast-1': 'Азия-Тихоокеанский регион (Сингапур)',
      'ap-southeast-2': 'Азия-Тихоокеанский регион (Сидней)',
      'ap-east-2': 'Азия-Тихоокеанский регион (Тайбэй)',
      'ap-southeast-7': 'Азия-Тихоокеанский регион (Таиланд)',
      'ap-northeast-1': 'Азия-Тихоокеанский регион (Токио)',
      'ca-central-1': 'Канада (Центральная)',
      'ca-west-1': 'Канада Запад (Калгари)',
      'eu-central-1': 'Европа (Франкфурт)',
      'eu-west-1': 'Европа (Ирландия)',
      'eu-west-2': 'Европа (Лондон)',
      'eu-south-1': 'Европа (Милан)',
      'eu-west-3': 'Европа (Париж)',
      'eu-south-2': 'Европа (Испания)',
      'eu-north-1': 'Европа (Стокгольм)',
      'eu-central-2': 'Европа (Цюрих)',
      'il-central-1': 'Израиль (Тель-Авив)',
      'mx-central-1': 'Мексика (Центральная)',
      'me-south-1': 'Ближний Восток (Бахрейн)',
      'me-central-1': 'Ближний Восток (ОАЭ)',
      'sa-east-1': 'Южная Америка (Сан-Паулу)',
      'us-gov-east-1': 'AWS GovCloud (US-East)',
      'us-gov-west-1': 'AWS GovCloud (US-West)',
      addTencentCloudSID: 'TencentCloud Secret ID',
      TencentCloudSIDMessage: 'Пожалуйста, введите ваш Secret ID',
      addTencentCloudSK: 'TencentCloud Secret Key',
      TencentCloudSKMessage: 'Пожалуйста, введите ваш Secret Key',
      SparkModelNameMessage: 'Пожалуйста, выберите модель Spark',
      addSparkAPIPassword: 'Spark APIPassword',
      SparkAPIPasswordMessage: 'пожалуйста, введите ваш APIPassword',
      addSparkAPPID: 'Spark APP ID',
      SparkAPPIDMessage: 'пожалуйста, введите ваш APP ID',
      addSparkAPISecret: 'Spark APISecret',
      SparkAPISecretMessage: 'пожалуйста, введите ваш APISecret',
      addSparkAPIKey: 'Spark APIKey',
      SparkAPIKeyMessage: 'пожалуйста, введите ваш APIKey',
      yiyanModelNameMessage: 'Пожалуйста, введите название модели',
      addyiyanAK: 'yiyan API KEY',
      yiyanAKMessage: 'Пожалуйста, введите ваш API KEY',
      addyiyanSK: 'yiyan Secret KEY',
      yiyanSKMessage: 'Пожалуйста, введите ваш Secret KEY',
      FishAudioModelNameMessage:
        'Пожалуйста, дайте вашей модели синтеза речи название',
      addFishAudioAK: 'Fish Audio API KEY',
      addFishAudioAKMessage: 'Пожалуйста, введите ваш API KEY',
      addFishAudioRefID: 'FishAudio Reference ID',
      addFishAudioRefIDMessage:
        'Пожалуйста, введите Reference ID (оставьте пустым для использования модели по умолчанию).',
      GoogleModelIDMessage: 'Пожалуйста, введите ваш ID модели!',
      addGoogleProjectID: 'Project ID',
      GoogleProjectIDMessage: 'Пожалуйста, введите ваш Project ID',
      addGoogleServiceAccountKey:
        'Service Account Key(Оставьте пустым, если используете Application Default Credentials)',
      GoogleServiceAccountKeyMessage:
        'Пожалуйста, введите Google Cloud Service Account Key в формате base64',
      addGoogleRegion: 'Google Cloud Region',
      GoogleRegionMessage: 'Пожалуйста, введите Google Cloud Region',
      modelProvidersWarn: `Пожалуйста, сначала добавьте как модель эмбеддингов, так и LLM в <b>Настройки > Провайдеры моделей</b>. Затем установите их в 'Установить модели по умолчанию'.`,
      apiVersion: 'API-Версия',
      apiVersionMessage: 'Пожалуйста, введите версию API',
      add: 'Добавить',
      updateDate: 'Дата',
      role: 'Статус',
      invite: 'Пригласить участника',
      agree: 'Принять',
      refuse: 'Отклонить',
      teamMembers: 'Участники команды',
      joinedTeams: 'Присоединенные команды',
      sureDelete: 'Вы уверены, что хотите удалить этого участника?',
      quit: 'Выйти',
      sureQuit:
        'Вы уверены, что хотите выйти из команды, к которой присоединились?',
      secretKey: 'Секретный ключ',
      publicKey: 'Публичный ключ',
      secretKeyMessage: 'Пожалуйста, введите секретный ключ',
      publicKeyMessage: 'Пожалуйста, введите публичный ключ',
      hostMessage: 'Пожалуйста, введите хост',
      configuration: 'Конфигурация',
      langfuseDescription:
        'Трассировки, оценки, управление промптами и метрики для отладки и улучшения вашего LLM приложения.',
      viewLangfuseSDocumentation: 'Посмотреть документацию Langfuse',
      view: 'Просмотр',
      modelsToBeAddedTooltip:
        'Если ваш провайдер моделей не указан, но заявляет о "совместимости с OpenAI-API", выберите карточку OpenAI-API-compatible, чтобы добавить соответствующие модели. ',
      mcp: 'MCP',
      paddleocr: {
        apiUrl: 'URL API PaddleOCR',
        apiUrlPlaceholder:
          'Например: https://paddleocr-server.com/layout-parsing',
        accessToken: 'Токен доступа AI Studio',
        accessTokenPlaceholder: 'Ваш токен AI Studio (необязательно)',
        algorithm: 'Алгоритм PaddleOCR',
        selectAlgorithm: 'Выбрать алгоритм',
        modelNamePlaceholder: 'Например: paddleocr-from-env-1',
        modelNameRequired: 'Имя модели является обязательным',
        apiUrlRequired: 'URL API PaddleOCR является обязательным',
      },
    },
    message: {
      registered: 'Зарегистрирован!',
      logout: 'выход',
      logged: 'вошел в систему!',
      pleaseSelectChunk: 'Пожалуйста, выберите чанк!',
      registerDisabled: 'Регистрация пользователей отключена',
      modified: 'Изменено',
      created: 'Создано',
      deleted: 'Удалено',
      renamed: 'Переименовано',
      operated: 'Выполнено',
      updated: 'Обновлено',
      uploaded: 'Загружено',
      200: 'Сервер успешно возвращает запрошенные данные.',
      201: 'Данные успешно созданы или изменены.',
      202: 'Запрос был поставлен в очередь в фоновом режиме (асинхронная задача).',
      204: 'Данные успешно удалены.',
      400: 'В отправленном запросе была ошибка, и сервер не создал и не изменил данные.',
      401: 'Пожалуйста, войдите снова.',
      403: 'Пользователь авторизован, но доступ запрещен.',
      404: 'Запрос был сделан для несуществующей записи, и сервер не выполнил операцию.',
      406: 'Запрашиваемый формат недоступен.',
      410: 'Запрошенный ресурс был окончательно удален и больше не будет доступен.',
      413: 'Общий размер файлов, загружаемых за один раз, слишком велик.',
      422: 'При создании объекта произошла ошибка валидации.',
      500: 'Произошла ошибка сервера, пожалуйста, проверьте сервер.',
      502: 'Ошибка шлюза.',
      503: 'Сервис недоступен, сервер временно перегружен или находится на техническом обслуживании.',
      504: 'Таймаут шлюза.',
      requestError: 'Ошибка запроса',
      networkAnomalyDescription:
        'В вашей сети есть аномалия, и вы не можете подключиться к серверу.',
      networkAnomaly: 'сетевая аномалия',
      hint: 'подсказка',
    },
    fileManager: {
      files: 'Файлы',
      name: 'Название',
      uploadDate: 'Дата загрузки',
      knowledgeBase: 'Датасет',
      size: 'Размер',
      action: 'Действие',
      addToKnowledge: 'Связать с Базой Знаний',
      pleaseSelect: 'Пожалуйста, выберите',
      newFolder: 'Новая папка',
      file: 'Файл',
      uploadFile: 'Загрузить файл',
      parseOnCreation: 'Парсить при создании',
      directory: 'Директория',
      uploadTitle: 'Перетащите ваш файл сюда для загрузки',
      uploadDescription:
        'Поддерживает одиночную или пакетную загрузку файлов. Для локально развернутого RAGFlow: общий ограничение размера файлов за одну загрузку составляет 1 ГБ, с ограничением пакетной загрузки в 32 файла. Нет ограничения на общее количество файлов на аккаунт. Для demo.ragflow.io общий ограничение размера файлов за одну загрузку составляет 10 МБ, каждый файл не должен превышать 10 МБ, максимум 128 файлов на аккаунт.',
      local: 'Локальные загрузки',
      s3: 'S3 загрузки',
      preview: 'Предпросмотр',
      fileError: 'Ошибка файла',
      uploadLimit:
        'Каждый файл не должен превышать 10 МБ, и общее количество файлов не должно превышать 128.',
      destinationFolder: 'Целевая папка',
      pleaseUploadAtLeastOneFile: 'Пожалуйста, загрузите хотя бы один файл',
    },
    flow: {
      downloadFileTypeTip: 'Тип файла для скачивания',
      downloadFileType: 'Тип скачиваемого файла',
      formatTypeError: 'Ошибка формата или типа',
      variableNameMessage:
        'Имя переменной может содержать только буквы и подчеркивания',
      variableDescription: 'Описание переменной',
      defaultValue: 'Значение по умолчанию',
      conversationVariable: 'Переменная диалога',
      recommended: 'Рекомендуемые',
      customerSupport: 'Поддержка клиентов',
      marketing: 'Маркетинг',
      consumerApp: 'Потребительские приложения',
      other: 'Другое',
      ingestionPipeline: 'Пайплайн обработки',
      agents: 'Агенты',
      days: 'Дни',
      beginInput: 'Начальный ввод',
      ref: 'Переменная',
      stockCode: 'Код акции',
      apiKeyPlaceholder:
        'YOUR_API_KEY (полученный с https://serpapi.com/manage-api-key)',
      flowStart: 'Старт',
      flowNum: 'N',
      test: 'Тест',
      extractDepth: 'Глубина извлечения',
      format: 'Формат',
      basic: 'базовый',
      advanced: 'продвинутый',
      general: 'общий',
      searchDepth: 'Глубина поиска',
      tavilyTopic: 'Тема Tavily',
      maxResults: 'Макс. результатов',
      includeAnswer: 'Включать ответ',
      includeRawContent: 'Включать исходное содержимое',
      includeImages: 'Включать изображения',
      includeImageDescriptions: 'Включать описания изображений',
      includeDomains: 'Включать домены',
      ExcludeDomains: 'Исключать домены',
      Days: 'Дни',
      comma: 'Запятая',
      semicolon: 'Точка с запятой',
      period: 'Точка',
      lineBreak: 'Разрыв строки',
      tab: 'Табуляция',
      space: 'Пробел',
      delimiters: 'Разделители',
      merge: 'Объединить',
      split: 'Разделить',
      script: 'Скрипт',
      iterationItemDescription:
        'Представляет текущий элемент в итерации, который может быть использован и обработан на последующих шагах.',
      guidingQuestion: 'Направляющий вопрос',
      onFailure: 'При неудаче',
      userPromptDefaultValue: 'Это заказ, который вам нужно отправить агенту.',
      search: 'Поиск',
      communication: 'Коммуникация',
      developer: 'Разработчик',
      typeCommandORsearch: 'Введите команду или поиск...',
      builtIn: 'Встроенный',
      ExceptionDefaultValue: 'Значение по умолчанию при исключении',
      exceptionMethod: 'Метод обработки исключений',
      maxRounds: 'Макс. раундов рефлексии',
      delayAfterError: 'Задержка после ошибки',
      maxRetries: 'Макс. попыток повтора',
      advancedSettings: 'Расширенные настройки',
      addTools: 'Добавить инструменты',
      sysPromptDefaultValue: `
      <role>
        Вы - полезный ассистент, ИИ-ассистент, специализирующийся на решении проблем для пользователя.
        Если предоставлена конкретная область, адаптируйте вашу экспертизу к этой области; в противном случае действуйте как универсал.
      </role>
      <instructions>
        1. Поймите запрос пользователя.
        2. Разбейте его на логические подзадачи.
        3. Выполните каждую подзадачу шаг за шагом, рассуждая прозрачно.
        4. Проверьте точность и согласованность.
        5. Четко обобщите окончательный результат.
      </instructions>`,
      singleLineText: 'Однострочный текст',
      multimodalModels: 'Мультимодальные модели',
      textOnlyModels: 'Только текстовые модели',
      allModels: 'Все модели',
      codeExecDescription:
        'Напишите вашу пользовательскую логику на Python или Javascript.',
      stringTransformDescription:
        'Изменяет текстовое содержимое. В настоящее время поддерживает: Разделение или объединение текста.',
      foundation: 'Основа',
      tools: 'Инструменты',
      dataManipulation: 'Манипуляция данными',
      flow: 'Поток',
      dialog: 'Диалог',
      cite: 'Цитировать',
      citeTip: 'Подсказка цитирования',
      name: 'Название',
      nameMessage: 'Пожалуйста, введите название',
      description: 'Описание',
      descriptionMessage: 'Это агент для конкретной задачи.',
      examples: 'Примеры',
      to: 'Кому',
      msg: 'Сообщения',
      msgTip:
        'Выводит содержимое переменной вышестоящего компонента или введенный вами текст.',
      messagePlaceholder: `Пожалуйста, введите содержимое вашего сообщения, используйте '/' для быстрой вставки переменных.`,
      messageMsg: 'Пожалуйста, введите сообщение или удалите это поле.',
      addField: 'Добавить опцию',
      addMessage: 'Добавить сообщение',
      loop: 'Цикл',
      loopTip:
        'Цикл - это верхний предел количества циклов текущего компонента, когда количество циклов превышает значение цикла, это означает, что компонент не может выполнить текущую задачу, пожалуйста, повторно оптимизируйте агента',
      yes: 'Да',
      no: 'Нет',
      key: 'Ключ',
      componentId: 'ID компонента',
      add: 'Добавить',
      operation: 'операция',
      run: 'Запустить',
      save: 'Сохранить',
      title: 'ID:',
      beginDescription: 'Здесь начинается поток.',
      answerDescription: `Компонент, который служит интерфейсом между человеком и ботом, получает пользовательские вводы и отображает ответы агента.`,
      retrievalDescription: `Компонент, который извлекает информацию из указанных баз знаний (датасетов). Убедитесь, что выбранные вами базы знаний используют одну и ту же модель эмбеддингов.`,
      generateDescription: `Компонент, который побуждает LLM генерировать ответы. Убедитесь, что промпт установлен правильно.`,
      categorizeDescription: `Компонент, который использует LLM для классификации пользовательских вводов в предопределенные категории. Убедитесь, что вы указали название, описание и примеры для каждой категории, вместе с соответствующим следующим компонентом.`,
      relevantDescription: `Компонент, который использует LLM для оценки, релевантен ли вывод вышестоящего компонента последнему запросу пользователя. Убедитесь, что вы указали следующий компонент для каждого результата оценки.`,
      rewriteQuestionDescription: `Компонент, который переписывает пользовательский запрос из компонента Взаимодействие, на основе контекста предыдущих диалогов.`,
      messageDescription:
        'Этот компонент возвращает окончательный вывод данных рабочего процесса вместе с предопределенным содержимым сообщения. ',
      keywordDescription: `Компонент, который извлекает топ N результатов поиска из ввода пользователя. Убедитесь, что значение TopN установлено правильно перед использованием.`,
      switchDescription: `Компонент, который оценивает условия на основе вывода предыдущих компонентов и направляет поток выполнения соответственно. Он позволяет сложную логику ветвления, определяя случаи и указывая действия для каждого случая или действие по умолчанию, если условия не выполнены.`,
      wikipediaDescription: `Компонент, который выполняет поиск на wikipedia.org, используя TopN для указания количества результатов поиска. Он дополняет существующие базы знаний.`,
      promptText: `Пожалуйста, обобщите следующие параграфы. Будьте внимательны с числами, не выдумывайте. Параграфы следующие:
        {input}
  Выше приведено содержимое, которое вам нужно обобщить.`,
      createGraph: 'Создать агента',
      createFromTemplates: 'Создать из шаблона',
      retrieval: 'Извлечение',
      generate: 'Генерация',
      answer: 'Взаимодействие',
      categorize: 'Классификация',
      relevant: 'Релевантность',
      rewriteQuestion: 'Переписать',
      rewrite: 'Переписать',
      begin: 'Начало',
      message: 'Сообщение',
      blank: 'Пустой',
      createFromNothing: 'Создайте вашего агента с нуля',
      addItem: 'Добавить элемент',
      addSubItem: 'Добавить подэлемент',
      nameRequiredMsg: 'Название обязательно',
      nameRepeatedMsg: 'Название не может повторяться',
      keywordExtract: 'Ключевое слово',
      keywordExtractDescription: `Компонент, который извлекает ключевые слова из пользовательского запроса, с Top N, указывающим количество извлекаемых ключевых слов.`,
      baidu: 'Baidu',
      baiduDescription: `Компонент, который выполняет поиск на baidu.com, используя TopN для указания количества результатов поиска. Он дополняет существующие базы знаний.`,
      duckDuckGo: 'DuckDuckGo',
      duckDuckGoDescription:
        'Компонент, который выполняет поиск на duckduckgo.com, позволяя вам указать количество результатов поиска с помощью TopN. Он дополняет существующие базы знаний.',
      searXNG: 'SearXNG',
      searXNGDescription:
        'Компонент, который выполняет поиск через ваш предоставленный URL экземпляра SearXNG. Укажите TopN и URL экземпляра.',
      pdfGenerator: 'Генератор документов',
      pDFGenerator: 'Генератор документов',
      pdfGeneratorDescription: `Компонент, который генерирует документы (PDF, DOCX, TXT) из содержимого в формате markdown с настраиваемым стилем, изображениями и таблицами. Поддерживает: **жирный**, *курсив*, # заголовки, - списки, таблицы с синтаксисом |.`,
      pDFGeneratorDescription: `Компонент, который генерирует документы (PDF, DOCX, TXT) из содержимого в формате markdown с настраиваемым стилем, изображениями и таблицами. Поддерживает: **жирный**, *курсив*, # заголовки, - списки, таблицы с синтаксисом |.`,
      subtitle: 'Подзаголовок',
      logoImage: 'Изображение логотипа',
      logoPosition: 'Позиция логотипа',
      logoWidth: 'Ширина логотипа',
      logoHeight: 'Высота логотипа',
      fontFamily: 'Семейство шрифтов',
      fontSize: 'Размер шрифта',
      titleFontSize: 'Размер шрифта заголовка',
      pageSize: 'Размер страницы',
      orientation: 'Ориентация',
      marginTop: 'Верхний отступ',
      marginBottom: 'Нижний отступ',
      filename: 'Имя файла',
      outputDirectory: 'Выходной каталог',
      addPageNumbers: 'Добавить номера страниц',
      addTimestamp: 'Добавить временную метку',
      watermarkText: 'Текст водяного знака',
      channel: 'Канал',
      channelTip: `Выполняет текстовый поиск или поиск новостей на входе компонента`,
      text: 'Текст',
      news: 'Новости',
      messageHistoryWindowSize: 'Размер окна истории сообщений',
      messageHistoryWindowSizeTip:
        'Размер окна истории разговоров, видимый LLM. Больше - лучше, но учитывайте максимальный лимит токенов LLM.',
      wikipedia: 'Wikipedia',
      pubMed: 'PubMed',
      pubMedDescription:
        'Компонент, который выполняет поиск на https://pubmed.ncbi.nlm.nih.gov/, позволяя вам указать количество результатов поиска с помощью TopN. Он дополняет существующие базы знаний.',
      email: 'Email',
      emailTip:
        'E-mail - обязательное поле. Вы должны ввести адрес электронной почты здесь.',
      arXiv: 'ArXiv',
      arXivDescription:
        'Компонент, который выполняет поиск на https://arxiv.org/, позволяя вам указать количество результатов поиска с помощью TopN. Он дополняет существующие базы знаний.',
      sortBy: 'Сортировать по',
      submittedDate: 'Дата отправки',
      lastUpdatedDate: 'Дата последнего обновления',
      relevance: 'Релевантность',
      google: 'Google',
      googleDescription:
        'Компонент, который выполняет поиск на https://www.google.com/, позволяя вам указать количество результатов поиска с помощью TopN. Он дополняет существующие базы знаний. Обратите внимание, что для этого требуется API ключ от serpapi.com.',
      bing: 'Bing',
      bingDescription:
        'Компонент, который выполняет поиск на https://www.bing.com/, позволяя вам указать количество результатов поиска с помощью TopN. Он дополняет существующие базы знаний. Обратите внимание, что для этого требуется API ключ от microsoft.com.',
      apiKey: 'API KEY',
      country: 'Страна и регион',
      language: 'Язык',
      googleScholar: 'Google Scholar',
      googleScholarDescription:
        'Компонент, который выполняет поиск на https://scholar.google.com/. Вы можете использовать Top N для указания количества результатов поиска.',
      yearLow: 'Год от',
      yearHigh: 'Год до',
      patents: 'Патенты',
      data: 'Данные',
      deepL: 'DeepL',
      deepLDescription:
        'Компонент, который получает более специализированные переводы с https://www.deepl.com/.',
      authKey: 'Ключ авторизации',
      sourceLang: 'Исходный язык',
      targetLang: 'Целевой язык',
      gitHub: 'GitHub',
      gitHubDescription:
        'Компонент, который ищет репозитории на https://github.com/. Вы можете использовать Top N для указания количества результатов поиска.',
      baiduFanyi: 'BaiduFanyi',
      baiduFanyiDescription:
        'Компонент, который получает специализированные переводы с https://fanyi.baidu.com/.',
      appid: 'App ID',
      secretKey: 'Секретный ключ',
      domain: 'Домен',
      transType: 'Тип перевода',
      baiduSecretKeyOptions: {
        translate: 'Общий перевод',
        fieldtranslate: 'Тематический перевод',
      },
      baiduDomainOptions: {
        it: 'Информационные технологии',
        finance: 'Финансы и экономика',
        machinery: 'Машиностроение',
        senimed: 'Биомедицина',
        novel: 'Онлайн литература',
        academic: 'Академические статьи',
        aerospace: 'Аэрокосмическая отрасль',
        wiki: 'Гуманитарные и социальные науки',
        news: 'Новости и информация',
        law: 'Законы и нормативы',
        contract: 'Договоры',
      },
      baiduSourceLangOptions: {
        auto: 'Автоопределение',
        zh: 'Китайский',
        en: 'Английский',
        yue: 'Кантонский',
        wyw: 'Классический китайский',
        jp: 'Японский',
        kor: 'Корейский',
        fra: 'Французский',
        spa: 'Испанский',
        th: 'Тайский',
        ara: 'Арабский',
        ru: 'Русский',
        pt: 'Португальский',
        de: 'Немецкий',
        it: 'Итальянский',
        el: 'Греческий',
        nl: 'Нидерландский',
        pl: 'Польский',
        bul: 'Болгарский',
        est: 'Эстонский',
        dan: 'Датский',
        fin: 'Финский',
        cs: 'Чешский',
        rom: 'Румынский',
        slo: 'Словенский',
        swe: 'Шведский',
        hu: 'Венгерский',
        cht: 'Традиционный китайский',
        vie: 'Вьетнамский',
      },
      qWeather: 'QWeather',
      qWeatherDescription:
        'Компонент, который получает информацию о погоде, такую как температура и качество воздуха, с https://www.qweather.com/.',
      lang: 'Язык',
      type: 'Тип',
      webApiKey: 'Web API ключ',
      userType: 'Тип пользователя',
      timePeriod: 'Период времени',
      qWeatherLangOptions: {
        zh: 'Китайский упрощенный',
        'zh-hant': 'Китайский традиционный',
        en: 'Английский',
        de: 'Немецкий',
        es: 'Испанский',
        fr: 'Французский',
        it: 'Итальянский',
        ja: 'Японский',
        ko: 'Корейский',
        ru: 'Русский',
        hi: 'Хинди',
        th: 'Тайский',
        ar: 'Арабский',
        pt: 'Португальский',
        bn: 'Бенгальский',
        ms: 'Малайский',
        nl: 'Нидерландский',
        el: 'Греческий',
        la: 'Латинский',
        sv: 'Шведский',
        id: 'Индонезийский',
        pl: 'Польский',
        tr: 'Турецкий',
        cs: 'Чешский',
        et: 'Эстонский',
        vi: 'Вьетнамский',
        fil: 'Филиппинский',
        fi: 'Финский',
        he: 'Иврит',
        is: 'Исландский',
        nb: 'Норвежский',
      },
      qWeatherTypeOptions: {
        weather: 'Прогноз погоды',
        indices: 'Погодный индекс жизни',
        airquality: 'Качество воздуха',
      },
      qWeatherUserTypeOptions: {
        free: 'Бесплатный подписчик',
        paid: 'Платный подписчик',
      },
      qWeatherTimePeriodOptions: {
        now: 'Сейчас',
        '3d': '3 дня',
        '7d': '7 дней',
        '10d': '10 дней',
        '15d': '15 дней',
        '30d': '30 дней',
      },
      publish: 'API',
      exeSQL: 'Выполнить SQL',
      exeSQLDescription:
        'Компонент, который выполняет SQL запросы к реляционной базе данных, поддерживая запросы из MySQL, PostgreSQL или MariaDB.',
      dbType: 'Тип базы данных',
      database: 'База данных',
      username: 'Имя пользователя',
      host: 'Хост',
      port: 'Порт',
      password: 'Пароль',
      switch: 'Переключатель',
      logicalOperator: 'Логический оператор',
      switchOperatorOptions: {
        equal: 'Равно',
        notEqual: 'Не равно',
        gt: 'Больше чем',
        ge: 'Больше или равно',
        lt: 'Меньше чем',
        le: 'Меньше или равно',
        contains: 'Содержит',
        notContains: 'Не содержит',
        startWith: 'Начинается с',
        endWith: 'Заканчивается на',
        empty: 'Пусто',
        notEmpty: 'Не пусто',
      },
      switchLogicOperatorOptions: {
        and: 'И',
        or: 'ИЛИ',
      },
      operator: 'Оператор',
      value: 'Значение',
      useTemplate: 'Использовать',
      wenCai: 'WenCai',
      queryType: 'Тип запроса',
      wenCaiDescription:
        'Компонент, который получает финансовую информацию, включая цены акций и новости о финансировании, с широкого спектра финансовых веб-сайтов.',
      wenCaiQueryTypeOptions: {
        stock: 'акции',
        zhishu: 'индекс',
        fund: 'фонд',
        hkstock: 'Гонконгские акции',
        usstock: 'Американский фондовый рынок',
        threeboard: 'Новый внебиржевой рынок',
        conbond: 'Конвертируемые облигации',
        insurance: 'страхование',
        futures: 'фьючерсы',
        lccp: 'Финансирование',
        foreign_exchange: 'Иностранная валюта',
      },
      akShare: 'AkShare',
      akShareDescription:
        'Компонент, который получает новости об акциях с https://www.eastmoney.com/.',
      yahooFinance: 'YahooFinance',
      yahooFinanceDescription:
        'Компонент, который запрашивает информацию о публично торгуемой компании, используя ее тикер.',
      crawler: 'Веб-краулер',
      crawlerDescription:
        'Компонент, который сканирует HTML исходный код с указанного URL.',
      proxy: 'Прокси',
      crawlerResultOptions: {
        html: 'Html',
        markdown: 'Markdown',
        content: 'Содержимое',
      },
      extractType: 'Тип извлечения',
      info: 'Информация',
      history: 'История',
      financials: 'Финансы',
      balanceSheet: 'Балансовый отчет',
      cashFlowStatement: 'Отчет о движении денежных средств',
      jin10: 'Jin10',
      jin10Description:
        'Компонент, который получает финансовую информацию с платформы Jin10 Open Platform, включая обновления новостей, календари, котировки и ссылки.',
      flashType: 'Тип вспышки',
      filter: 'Фильтр',
      contain: 'Содержит',
      calendarType: 'Тип календаря',
      calendarDatashape: 'Форма данных календаря',
      symbolsDatatype: 'Тип данных символов',
      symbolsType: 'Тип символов',
      jin10TypeOptions: {
        flash: 'Быстрые новости',
        calendar: 'Календарь',
        symbols: 'котировки',
        news: 'ссылки',
      },
      jin10FlashTypeOptions: {
        '1': 'Рыночные новости',
        '2': ' Новости фьючерсов',
        '3': 'Новости США-Гонконг',
        '4': 'Новости акций Китая',
        '5': 'Новости товаров и форекс',
      },
      jin10CalendarTypeOptions: {
        cj: 'Календарь макроэкономических данных',
        qh: ' Календарь фьючерсов',
        hk: 'Календарь фондового рынка Гонконга',
        us: 'Календарь фондового рынка США',
      },
      jin10CalendarDatashapeOptions: {
        data: 'Данные',
        event: ' Событие',
        holiday: 'Праздник',
      },
      jin10SymbolsTypeOptions: {
        GOODS: 'Котировки товаров',
        FOREX: ' Форекс котировки',
        FUTURE: 'Котировки международного рынка',
        CRYPTO: 'Криптовалютные котировки',
      },
      jin10SymbolsDatatypeOptions: {
        symbols: 'Список товаров',
        quotes: ' Последние рыночные котировки',
      },
      concentrator: 'Концентратор',
      concentratorDescription:
        'Компонент, который получает вывод от вышестоящего компонента и передает его как вход для нижестоящих компонентов.',
      tuShare: 'TuShare',
      tuShareDescription:
        'Компонент, который получает краткие финансовые новости с основных финансовых веб-сайтов, помогая отраслевым и количественным исследованиям.',
      tuShareSrcOptions: {
        sina: 'Sina',
        wallstreetcn: 'wallstreetcn',
        '10jqka': 'Straight flush',
        eastmoney: 'Eastmoney',
        yuncaijing: 'YUNCAIJING',
        fenghuang: 'FENGHUANG',
        jinrongjie: 'JRJ',
      },
      token: 'Токен',
      src: 'Источник',
      startDate: 'Дата начала',
      endDate: 'Дата окончания',
      keyword: 'Ключевое слово',
      note: 'Примечание',
      noteDescription: 'Примечание',
      notePlaceholder: 'Пожалуйста, введите примечание',
      invoke: 'HTTP Запрос',
      invokeDescription: `Компонент, способный вызывать удаленные сервисы, используя выводы других компонентов или константы как входы.`,
      url: 'Url',
      method: 'Метод',
      timeout: 'Таймаут',
      headers: 'Заголовки',
      cleanHtml: 'Очистить HTML',
      cleanHtmlTip:
        'Если ответ в формате HTML и нужен только основной контент, пожалуйста, включите это.',
      invalidUrl:
        'Должен быть действительный URL или URL с заполнителями переменных в формате {variable_name} или {component@variable}',
      reference: 'Ссылка',
      input: 'Ввод',
      output: 'Вывод',
      parameter: 'Параметр',
      howUseId: 'Как использовать ID агента?',
      content: 'Содержимое',
      operationResults: 'Результаты операций',
      autosaved: 'Автосохранено',
      optional: 'Опционально',
      pasteFileLink: 'Вставить ссылку на файл',
      testRun: 'Тестовый запуск',
      template: 'Шаблон',
      templateDescription:
        'Компонент, который форматирует вывод других компонентов.1. Поддерживает шаблоны Jinja2, сначала преобразует вход в объект, а затем рендерит шаблон, 2. Одновременно сохраняет исходный метод использования замены строки {parameter}',
      emailComponent: 'Email',
      emailDescription: 'Отправить email на указанный адрес.',
      smtpServer: 'SMTP Сервер',
      smtpPort: 'SMTP Порт',
      senderEmail: 'Email отправителя',
      authCode: 'Код авторизации',
      senderName: 'Имя отправителя',
      toEmail: 'Email получателя',
      ccEmail: 'Email копии',
      emailSubject: 'Тема',
      emailContent: 'Содержимое',
      smtpServerRequired: 'Пожалуйста, введите адрес SMTP сервера',
      senderEmailRequired: 'Пожалуйста, введите email отправителя',
      authCodeRequired: 'Пожалуйста, введите код авторизации',
      toEmailRequired: 'Пожалуйста, введите email получателя',
      emailContentRequired: 'Пожалуйста, введите содержимое email',
      emailSentSuccess: 'Email успешно отправлен',
      emailSentFailed: 'Не удалось отправить email',
      dynamicParameters: 'Динамические параметры',
      jsonFormatTip:
        'Вышестоящий компонент должен предоставить JSON строку в следующем формате:',
      toEmailTip: 'to_email: Email получателя (Обязательно)',
      ccEmailTip: 'cc_email: Email копии (Опционально)',
      subjectTip: 'subject: Тема email (Опционально)',
      contentTip: 'content: Содержимое email (Опционально)',
      jsonUploadTypeErrorMessage: 'Пожалуйста, загрузите json файл',
      jsonUploadContentErrorMessage: 'Ошибка json файла',
      iteration: 'Итерация',
      iterationDescription: `Циклический компонент, который итерируется по входному массиву и выполняет определенную логику для каждого элемента.`,
      delimiterTip: `
Этот разделитель используется для разделения входного текста на несколько текстовых частей, каждая из которых будет выполняться как входной элемент каждой итерации.`,
      delimiterOptions: {
        comma: 'Запятая',
        lineBreak: 'Разрыв строки',
        tab: 'Табуляция',
        underline: 'Подчеркивание',
        diagonal: 'Косая черта',
        minus: 'Тире',
        semicolon: 'Точка с запятой',
      },
      addVariable: 'Добавить переменную',
      variableSettings: 'Настройки переменных',
      systemPrompt: 'Системный промпт',
      userPrompt: 'Пользовательский промпт',
      addCategory: 'Добавить категорию',
      categoryName: 'Название категории',
      nextStep: 'Следующий шаг',
      variableExtractDescription:
        'Извлечь информацию пользователя в глобальную переменную на протяжении всего разговора',
      variableExtract: 'Переменные',
      variables: 'Переменные',
      variablesTip: `Установите четкую json ключевую переменную со значением пусто. например.
      {
        "UserCode":"",
        "NumberPhone":""
      }`,
      datatype: 'MIME тип HTTP запроса',
      insertVariableTip: `Введите / Вставьте переменные`,
      historyVersion: 'История версий',
      version: {
        created: 'Создано',
        details: 'Детали версии',
        dsl: 'DSL',
        download: 'Скачать',
        version: 'Версия',
        select: 'Версия не выбрана',
      },
      setting: 'Настройки',
      settings: {
        agentSetting: 'Настройки агента',
        title: 'заголовок',
        description: 'описание',
        upload: 'Загрузить',
        photo: 'Фото',
        permissions: 'Права доступа',
        permissionsTip:
          'Вы можете установить права доступа участников команды здесь.',
        me: 'я',
        team: 'Команда',
      },
      noMoreData: 'Больше нет данных',
      searchAgentPlaceholder: 'Поиск агента',
      footer: {
        profile: 'Все права защищены @ React',
      },
      layout: {
        file: 'файл',
        knowledge: 'знания',
        chat: 'чат',
      },
      prompt: 'Промпт',
      promptTip:
        'Используйте системный промпт, чтобы описать задачу для LLM, указать, как она должна отвечать, и очертить другие различные требования. Системный промпт часто используется вместе с ключами (переменными), которые служат различными входными данными для LLM. Используйте прямую косую черту `/` или кнопку (x), чтобы показать ключи для использования.',
      promptMessage: 'Промпт обязателен',
      infor: 'Информационный запуск',
      knowledgeBasesTip:
        'Выберите базы знаний для связи с этим чат-ассистентом, или выберите переменные, содержащие ID баз знаний ниже.',
      knowledgeBaseVars: 'Переменные базы знаний',
      code: 'Код',
      codeDescription:
        'Позволяет разработчикам писать пользовательскую логику на Python.',
      dataOperations: 'Операции с данными',
      dataOperationsDescription:
        'Выполнять различные операции над объектом Data.',
      listOperations: 'Операции со списками',
      listOperationsDescription: 'Выполнять операции над списком.',
      variableAssigner: 'Назначитель переменных',
      variableAssignerDescription:
        'Этот компонент выполняет операции над объектами Data, включая извлечение, фильтрацию и редактирование ключей и значений в Data.',
      variableAggregator: 'Агрегатор переменных',
      variableAggregatorDescription: `Этот процесс агрегирует переменные из нескольких ветвей в одну переменную для достижения единой конфигурации для нижестоящих узлов.

Узел агрегации переменных (изначально узел назначения переменных) - это важный узел в рабочем процессе. Он отвечает за интеграцию выходных результатов разных ветвей, гарантируя, что независимо от того, какая ветвь выполнена, ее результат может быть ссылочно доступен через единую переменную. Это чрезвычайно полезно в сценариях с несколькими ветвями, так как он отображает переменные с той же функцией в разных ветвях на одну выходную переменную, избегая избыточных определений в нижестоящих узлах.`,
      inputVariables: 'Входные переменные',
      runningHintText: 'выполняется...🕞',
      openingSwitch: 'Переключатель приветствия',
      openingCopy: 'Приветственное сообщение',
      openingSwitchTip:
        'Ваши пользователи увидят это приветственное сообщение в начале.',
      modeTip: 'Режим определяет, как инициируется рабочий процесс.',
      mode: 'Режим',
      conversational: 'Диалоговый',
      task: 'Задача',
      beginInputTip:
        'Параметры ввода, определённые здесь, могут быть доступны компонентам в последующем рабочем процессе.',
      query: 'Переменные запроса',
      queryRequired: 'Запрос обязателен',
      queryTip: 'Выберите переменную, которую хотите использовать',
      agent: 'Агент',
      addAgent: 'Добавить агента',
      agentDescription:
        'Строит компоненты агентов, оснащенные рассуждениями, использованием инструментов и многопользовательским взаимодействием. ',
      maxRecords: 'Макс. записей',
      createAgent: 'Поток агента',
      stringTransform: 'Обработка текста',
      userFillUp: 'Ожидание ответа',
      userFillUpDescription: `Приостанавливает рабочий процесс и ждет сообщение пользователя перед продолжением.`,
      codeExec: 'Код',
      tavilySearch: 'Поиск Tavily',
      tavilySearchDescription: 'Результаты поиска через сервис Tavily.',
      tavilyExtract: 'Извлечение Tavily',
      tavilyExtractDescription: 'Извлечение Tavily',
      log: 'Лог',
      management: 'Управление',
      import: 'Импорт',
      export: 'Экспорт',
      seconds: 'Секунды',
      subject: 'Тема',
      tag: 'Тег',
      tagPlaceholder: 'Пожалуйста, введите тег',
      descriptionPlaceholder: 'Пожалуйста, введите описание',
      line: 'Однострочный текст',
      paragraph: 'Текст абзаца',
      options: 'Выпадающие опции',
      file: 'Загрузка файла',
      integer: 'Число',
      boolean: 'Булево значение',

      logTimeline: {
        begin: 'Готов к началу',
        agent: 'Агент думает',
        userFillUp: 'Ожидание вас',
        retrieval: 'Поиск знаний',
        message: 'Агент говорит',
        awaitResponse: 'Ожидание вас',
        switch: 'Выбор лучшего пути',
        iteration: 'Пакетная обработка',
        categorize: 'Классификация информации',
        code: 'Запуск быстрого скрипта',
        textProcessing: 'Упорядочивание текста',
        tavilySearch: 'Поиск в вебе',
        tavilyExtract: 'Чтение страницы',
        exeSQL: 'Запрос к базе данных',
        google: 'Поиск в вебе',
        wikipedia: 'Поиск в Wikipedia',
        googleScholar: 'Академический поиск',
        gitHub: 'Поиск в GitHub',
        email: 'Отправка email',
        httpRequest: 'Вызов API',
        wenCai: 'Запрос финансовых данных',
      },
      goto: 'Ветка неудачи',
      comment: 'Значение по умолчанию',
      sqlStatement: 'SQL Запрос',
      sqlStatementTip:
        'Напишите ваш SQL запрос здесь. Вы можете использовать переменные, чистый SQL или смешивать оба, используя синтаксис переменных.',
      frameworkPrompts: 'Фреймворк',
      release: 'Опубликовать',
      createFromBlank: 'Создать с чистого листа',
      createFromTemplate: 'Создать из шаблона',
      importJsonFile: 'Импортировать JSON файл',
      ceateAgent: 'Поток агента',
      createPipeline: 'Пайплайн обработки',
      chooseAgentType: 'Выберите тип агента',
      parser: 'Парсер',
      parserDescription:
        'Извлекает исходный текст и структуру из файлов для последующей обработки.',
      tokenizer: 'Индексатор',
      tokenizerRequired: 'Пожалуйста, сначала добавьте узел Индексатора',
      tokenizerDescription:
        'Преобразует текст в требуемую структуру данных (например, векторные эмбеддинги для поиска по эмбеддингам) в зависимости от выбранного метода поиска.',
      splitter: 'Токен',
      splitterDescription:
        'Разделяет текст на чанки по длине токена с опциональными разделителями и перекрытием.',
      hierarchicalMergerDescription:
        'Разделяет документы на разделы по иерархии заголовков с regex правилами для более точного контроля.',
      hierarchicalMerger: 'Заголовок',
      extractor: 'Трансформер',
      extractorDescription:
        'Использует LLM для извлечения структурированных инсайтов из чанков документов - таких как резюме, классификации и т.д.',
      outputFormat: 'Формат вывода',
      fileFormats: 'Тип файла',
      fileFormatOptions: {
        pdf: 'PDF',
        spreadsheet: 'Электронная таблица',
        image: 'Изображение',
        email: 'Email',
        'text&markdown': 'Текст и разметка',
        word: 'Word',
        slides: 'PPTX',
        audio: 'Аудио',
        video: 'Видео',
      },
      fields: 'Поле',
      addParser: 'Добавить парсер',
      hierarchy: 'Иерархия',
      regularExpressions: 'Регулярные выражения',
      overlappedPercent: 'Процент перекрытия (%)',
      searchMethod: 'Метод поиска',
      searchMethodTip: `Определяет, как можно искать контент — по полному тексту, эмбеддингам или обоим способам.
Индексатор будет хранить контент в соответствующих структурах данных для выбранных методов.`,
      // file: 'Файл',
      parserMethod: 'PDF парсер',
      // systemPrompt: 'Системный Промпт',
      systemPromptPlaceholder:
        'Введите системный промпт для анализа изображений, если пусто, будет использовано системное значение по умолчанию',
      exportJson: 'Экспортировать JSON',
      viewResult: 'Просмотреть результат',
      running: 'Выполняется',
      summary: 'Резюме',
      keywords: 'Ключевые слова',
      questions: 'Вопросы',
      metadata: 'Метаданные',
      fieldName: 'Назначение результата',
      prompts: {
        system: {
          keywords: `Роль
Вы - анализатор текста.

Задача
Извлеките самые важные ключевые слова/фразы из данного фрагмента текстового содержимого.

Требования
- Обобщите текстовое содержимое и дайте топ 5 важных ключевых слов/фраз.
- Ключевые слова ДОЛЖНЫ быть на том же языке, что и данный фрагмент текстового содержимого.
- Ключевые слова разделены АНГЛИЙСКОЙ ЗАПЯТОЙ.
- Выводите ТОЛЬКО ключевые слова.`,
          questions: `Роль
Вы - анализатор текста.

Задача
Предложите 3 вопроса о данном фрагменте текстового содержимого.

Требования
- Поймите и обобщите текстовое содержимое и предложите топ 3 важных вопроса.
- Вопросы НЕ ДОЛЖНЫ иметь перекрывающихся значений.
- Вопросы ДОЛЖНЫ охватывать основное содержание текста как можно больше.
- Вопросы ДОЛЖНЫ быть на том же языке, что и данный фрагмент текстового содержимого.
- Один вопрос на строку.
- Выводите ТОЛЬКО вопросы.`,
          summary: `Действуйте как точный суммаризатор. Ваша задача - создать резюме предоставленного содержимого, которое является одновременно кратким и верным оригиналу.

Ключевые инструкции:
1. Точность: Строго основывайте резюме на предоставленной информации. Не вводите новые факты, выводы или интерпретации, которые явно не указаны.
2. Язык: Напишите резюме на том же языке, что и исходный текст.
3. Объективность: Представьте ключевые моменты без предвзятости, сохраняя первоначальный замысел и тон содержимого. Не редактируйте.
4. Краткость: Сосредоточьтесь на самых важных идеях, опуская незначительные детали и лишнее.`,
          metadata: `Извлеките важную структурированную информацию из данного содержимого. Выводите ТОЛЬКО действительную JSON строку без дополнительного текста. Если важная структурированная информация не найдена, выведите пустой JSON объект: {}.

Важная структурированная информация может включать: имена, даты, местоположения, события, ключевые факты, числовые данные или другие извлекаемые сущности.`,
        },
        user: {
          keywords: `Текстовое содержимое
[Вставьте текст здесь]`,
          questions: `Текстовое содержимое
[Вставьте текст здесь]`,
          summary: `Текст для обобщения:
[Вставьте текст здесь]`,
          metadata: `Содержимое: [ВСТАВЬТЕ СОДЕРЖИМОЕ ЗДЕСЬ]`,
        },
      },
      cancel: 'Отмена',
      swicthPromptMessage:
        'Промпт изменится. Пожалуйста, подтвердите, отказаться от существующего промпта?',
      tokenizerSearchMethodOptions: {
        full_text: 'Полный текст',
        embedding: 'Эмбеддинг',
      },
      filenameEmbeddingWeight: 'Вес эмбеддинга имени файла',
      tokenizerFieldsOptions: {
        text: 'Обработанный текст',
        keywords: 'Ключевые слова',
        questions: 'Вопросы',
        summary: 'Расширенный контекст',
      },
      imageParseMethodOptions: {
        ocr: 'OCR',
      },
      structuredOutput: {
        configuration: 'Конфигурация',
        structuredOutput: 'Структурированный вывод',
      },
      operations: 'Операции',
      operationsOptions: {
        selectKeys: 'Выбрать ключи',
        literalEval: 'Литеральная оценка',
        combine: 'Объединить',
        filterValues: 'Фильтровать значения',
        appendOrUpdate: 'Добавить или обновить',
        removeKeys: 'Удалить ключи',
        renameKeys: 'Переименовать ключи',
      },
      ListOperationsOptions: {
        topN: 'Топ N',
        head: 'Начало',
        tail: 'Конец',
        sort: 'Сортировать',
        filter: 'Фильтр',
        dropDuplicates: 'Удалить дубликаты',
      },
      sortMethod: 'Метод сортировки',
      SortMethodOptions: {
        asc: 'По возрастанию',
        desc: 'По убыванию',
      },
      variableAssignerLogicalOperatorOptions: {
        overwrite: 'Перезаписано',
        clear: 'Очистить',
        set: 'Установить',
        '+=': 'Добавить',
        '-=': 'Вычесть',
        '*=': 'Умножить',
        '/=': 'Разделить',
        append: 'Добавить',
        extend: 'Расширить',
        removeFirst: 'Удалить первый',
        removeLast: 'Удалить последний',
      },
    },
    llmTools: {
      bad_calculator: {
        name: 'Калькулятор',
        description:
          'Инструмент для вычисления суммы двух чисел (даст неправильный ответ)',
        params: {
          a: 'Первое число',
          b: 'Второе число',
        },
      },
    },
    modal: {
      okText: 'Подтвердить',
      cancelText: 'Отмена',
    },
    mcp: {
      export: 'Экспорт',
      import: 'Импорт',
      url: 'URL',
      serverType: 'Тип сервера',
      addMCP: 'Добавить MCP',
      editMCP: 'Редактировать MCP',
      toolsAvailable: 'доступные инструменты',
      mcpServers: 'MCP серверы',
      customizeTheListOfMcpServers: 'Настроить список MCP серверов',
      cachedTools: 'кэшированные инструменты',
      bulkManage: 'Пакетное управление',
      exitBulkManage: 'Выйти из пакетного управления',
      selected: 'Выбрано',
    },
    search: {
      searchApps: 'Поисковые приложения',
      createSearch: 'Создать поиск',
      searchGreeting: 'Чем я могу вам помочь сегодня？',
      profile: 'Скрыть профиль',
      locale: 'Локаль',
      embedCode: 'Код для встраивания',
      id: 'ID',
      copySuccess: 'Успешно скопировано',
      welcomeBack: 'С возвращением',
      searchSettings: 'Настройки поиска',
      name: 'Название',
      avatar: 'Аватар',
      description: 'Описание',
      datasets: 'Датасеты',
      rerankModel: 'Rerank Модель',
      AISummary: 'ИИ-резюме',
      enableWebSearch: 'Включить веб-поиск',
      enableRelatedSearch: 'Включить связанный поиск',
      showQueryMindmap: 'Показать ментальную карту запроса',
      embedApp: 'Встроить приложение',
      relatedSearch: 'Связанный поиск',
      descriptionValue: 'Вы - интеллектуальный ассистент.',
      okText: 'Сохранить',
      cancelText: 'Отмена',
      chooseDataset: 'Пожалуйста, сначала выберите датасет',
    },
    language: {
      english: 'Английский',
      chinese: 'Китайский',
      spanish: 'Испанский',
      french: 'Французский',
      german: 'Немецкий',
      japanese: 'Японский',
      korean: 'Корейский',
      vietnamese: 'Вьетнамский',
      russian: 'Русский',
    },
    pagination: {
      total: 'Всего {{total}}',
      page: '{{page}} /Страница',
    },
    dataflowParser: {
      result: 'Результат',
      parseSummary: 'Сводка парсинга',
      parseSummaryTip: 'Парсер：deepdoc',
      parserMethod: 'Метод парсинга',
      outputFormat: 'Формат вывода',
      rerunFromCurrentStep: 'Перезапустить с текущего шага',
      rerunFromCurrentStepTip: 'Обнаружены изменения. Нажмите для перезапуска.',
      confirmRerun: 'Подтвердить перезапуск процесса',
      confirmRerunModalContent: `
      <p class="text-sm text-text-disabled font-medium mb-2">
        Вы собираетесь перезапустить процесс, начиная с шага <span class="text-text-secondary">{{step}}</span>.
      </p>
      <p class="text-sm mb-3 text-text-disabled">Это:</p><br />
      <ul class="list-disc list-inside space-y-1 text-sm text-text-secondary">
        <li>• Перезапишет существующие результаты с текущего шага и далее</li>
        <li>• Создаст новую запись в логе для отслеживания</li>
        <li>• Предыдущие шаги останутся неизменными</li>
      </ul>`,
      changeStepModalTitle: 'Предупреждение о смене шага',
      changeStepModalContent: `
      <p>В настоящее время вы редактируете результаты этого этапа.</p>
      <p>Если вы переключитесь на более поздний этап, ваши изменения будут потеряны. </p>
      <p>Чтобы сохранить их, пожалуйста, нажмите Перезапустить, чтобы повторно запустить текущий этап.</p> `,
      changeStepModalConfirmText: 'Все равно переключить',
      changeStepModalCancelText: 'Отмена',
      unlinkPipelineModalTitle: 'Отвязать пайплайн обработки',
      unlinkPipelineModalConfirmText: 'Отвязать',
      unlinkPipelineModalContent: `
      <p>После отвязки этот Датасет больше не будет подключен к текущему пайплайну обработки.</p>
      <p>Файлы, которые уже парсятся, продолжат до завершения</p>
      <p>Файлы, которые еще не парсились, больше не будут обрабатываться</p> <br/>
      <p>Вы уверены, что хотите продолжить?</p> `,
      unlinkSourceModalTitle: 'Отвязать источник данных',
      unlinkSourceModalContent: `
      <p>Вы уверены, что хотите отвязать этот источник данных？</p>`,
      unlinkSourceModalConfirmText: 'Отвязать',
    },
    datasetOverview: {
      downloadTip: 'Файлы загружаются из источников данных. ',
      processingTip: 'Файлы обрабатываются пайплайном обработки.',
      totalFiles: 'Всего файлов',
      downloading: 'Загрузка',
      downloadSuccessTip: 'Всего успешных загрузок',
      downloadFailedTip: 'Всего неудачных загрузок',
      processingSuccessTip: 'Всего успешно обработанных файлов',
      processingFailedTip: 'Всего неудачных обработок',
      processing: 'Обработка',
    },
    admin: {
      loginTitle: 'Административная консоль',
      title: 'RAGFlow',
      confirm: 'Подтвердить',
      close: 'Закрыть',
      yes: 'Да',
      no: 'Нет',
      delete: 'Удалить',
      cancel: 'Отмена',
      reset: 'Сбросить',
      import: 'Импорт',
      description: 'Описание',
      noDescription: 'Нет описания',

      resourceType: {
        dataset: 'Датасет',
        chat: 'Чат',
        agent: 'Агент',
        search: 'Поиск',
        file: 'Файл',
        team: 'Команда',
        memory: 'Память',
      },

      permissionType: {
        enable: 'Включить',
        read: 'Чтение',
        write: 'Запись',
        share: 'Поделиться',
      },

      serviceStatus: 'Статус сервиса',
      userManagement: 'Управление пользователями',
      registrationWhitelist: 'Белый список регистрации',
      roles: 'Роли',
      monitoring: 'Мониторинг',

      back: 'Назад',
      active: 'Активный',
      inactive: 'Неактивный',
      enable: 'Включить',
      disable: 'Выключить',
      all: 'Все',
      actions: 'Действия',
      newUser: 'Новый пользователь',
      email: 'Email',
      name: 'Имя',
      nickname: 'Никнейм',
      status: 'Статус',
      id: 'ID',
      serviceType: 'Тип сервиса',
      host: 'Хост',
      port: 'Порт',

      role: 'Роль',
      user: 'Пользователь',
      superuser: 'Суперпользователь',

      createTime: 'Время создания',
      lastLoginTime: 'Время последнего входа',
      lastUpdateTime: 'Время последнего обновления',

      isAnonymous: 'Анонимный',
      isSuperuser: 'Суперпользователь',

      deleteUser: 'Удалить пользователя',
      deleteUserConfirmation:
        'Вы уверены, что хотите удалить этого пользователя?',

      createNewUser: 'Создать нового пользователя',
      changePassword: 'Изменить пароль',
      newPassword: 'Новый пароль',
      confirmNewPassword: 'Подтвердите новый пароль',
      password: 'Пароль',
      confirmPassword: 'Подтвердите пароль',

      invalidEmail:
        'Пожалуйста, введите действительный адрес электронной почты!',
      passwordRequired: 'Пожалуйста, введите ваш пароль!',
      passwordMinLength: 'Пароль должен быть длиннее 8 символов.',
      confirmPasswordRequired: 'Пожалуйста, подтвердите ваш пароль!',
      confirmPasswordDoNotMatch: 'Введенные вами пароли не совпадают!',

      read: 'Чтение',
      write: 'Запись',
      share: 'Поделиться',
      create: 'Создать',

      extraInfo: 'Дополнительная информация',
      serviceDetail: `Детали сервиса {{name}}`,
      taskExecutorDetail: 'Детали исполнителя задачи',

      whitelistManagement: 'Управление белым списком',
      exportAsExcel: 'Экспорт в Excel',
      importFromExcel: 'Импорт из Excel',
      createEmail: 'Создать email',
      deleteEmail: 'Удалить email',
      editEmail: 'Редактировать email',
      deleteWhitelistEmailConfirmation:
        'Вы уверены, что хотите удалить этот email из белого списка? Это действие нельзя отменить.',

      importWhitelist: 'Импорт белого списка (Excel)',
      importSelectExcelFile: 'Excel файл (.xlsx)',
      importOverwriteExistingEmails: 'Перезаписать существующие emails',
      importInvalidExcelFile: 'Пожалуйста, выберите действительный Excel файл',
      importFileRequired: 'Пожалуйста, выберите файл для импорта',
      importFileTips:
        'Файл должен содержать один заголовочный столбец с именем <code>email</code>.',

      chunkNum: 'Чанки',
      docNum: 'Документы',
      tokenNum: 'Использовано токенов',
      language: 'Язык',
      createDate: 'Дата создания',
      updateDate: 'Дата обновления',
      permission: 'Права доступа',

      agentTitle: 'Название агента',
      canvasCategory: 'Категория канваса',

      newRole: 'Новая роль',
      addNewRole: 'Добавить новую роль',
      roleName: 'Название роли',
      roleNameRequired: 'Название роли обязательно',
      resources: 'Ресурсы',

      editRoleDescription: 'Редактировать описание роли',
      deleteRole: 'Удалить роль',
      deleteRoleConfirmation:
        'Вы уверены, что хотите удалить эту роль? Это действие нельзя отменить.',

      alive: 'Активен',
      timeout: 'Таймаут',
      fail: 'Неудача',
    },
  },
};
