import type { Translation } from '../translation-keys.ts';

export const en: Translation = {
  collapse: 'Collapse',
  expand: 'Expand',

  fieldDescriptionPlaceholder: 'Describe the purpose of this field',
  fieldDelete: 'Delete field',
  fieldDescription: 'Description',
  fieldDescriptionTooltip: 'Add context about what this field represents',
  fieldNameLabel: 'Field Name',
  fieldNamePlaceholder: 'e.g. firstName, age, isActive',
  fieldNameTooltip: 'Use camelCase for better readability (e.g., firstName)',
  fieldRequiredLabel: 'Required Field',
  fieldType: 'Field Type',
  fieldTypeExample: 'Example:',
  fieldTypeTooltipString: 'string: Text',
  fieldTypeTooltipNumber: 'number: Numeric',
  fieldTypeTooltipBoolean: 'boolean: True/false',
  fieldTypeTooltipObject: 'object: Nested JSON',
  fieldTypeTooltipArray: 'array: Lists of values',
  fieldAddNewButton: 'Add Field',
  fieldAddNewBadge: 'Schema Builder',
  fieldAddNewCancel: 'Cancel',
  fieldAddNewConfirm: 'Add Field',
  fieldAddNewDescription: 'Create a new field for your JSON schema',
  fieldAddNewLabel: 'Add New Field',

  fieldTypeTextLabel: 'Text',
  fieldTypeTextDescription: 'For text values like names, descriptions, etc.',
  fieldTypeNumberLabel: 'Number',
  fieldTypeNumberDescription: 'For decimal or whole numbers',
  fieldTypeBooleanLabel: 'Yes/No',
  fieldTypeBooleanDescription: 'For true/false values',
  fieldTypeObjectLabel: 'Group',
  fieldTypeObjectDescription: 'For grouping related fields together',
  fieldTypeArrayLabel: 'List',
  fieldTypeArrayDescription: 'For collections of items',

  propertyDescriptionPlaceholder: 'Add description...',
  propertyDescriptionButton: 'Add description...',
  propertyRequired: 'Required',
  propertyOptional: 'Optional',
  propertyDelete: 'Delete field',

  schemaEditorTitle: 'JSON Schema Editor',
  schemaEditorToggleFullscreen: 'Toggle fullscreen',
  schemaEditorEditModeVisual: 'Visual',
  schemaEditorEditModeJson: 'JSON',

  arrayMinimumLabel: 'Minimum Items',
  arrayMinimumPlaceholder: 'No minimum',
  arrayMaximumLabel: 'Maximum Items',
  arrayMaximumPlaceholder: 'No maximum',
  arrayForceUniqueItemsLabel: 'Force unique items',
  arrayItemTypeLabel: 'Item Type',
  arrayValidationErrorMinMax: "'minItems' cannot be greater than 'maxItems'.",
  arrayValidationErrorContainsMinMax:
    "'minContains' cannot be greater than 'maxContains'.",

  booleanAllowFalseLabel: 'Allow false value',
  booleanAllowTrueLabel: 'Allow true value',
  booleanNeitherWarning: 'Warning: You must allow at least one value.',

  numberMinimumLabel: 'Minimum Value',
  numberMinimumPlaceholder: 'No minimum',
  numberMaximumLabel: 'Maximum Value',
  numberMaximumPlaceholder: 'No maximum',
  numberExclusiveMinimumLabel: 'Exclusive Minimum',
  numberExclusiveMinimumPlaceholder: 'No exclusive min',
  numberExclusiveMaximumLabel: 'Exclusive Maximum',
  numberExclusiveMaximumPlaceholder: 'No exclusive max',
  numberMultipleOfLabel: 'Multiple Of',
  numberMultipleOfPlaceholder: 'Any',
  numberAllowedValuesEnumLabel: 'Allowed Values (enum)',
  numberAllowedValuesEnumNone: 'No restricted values set',
  numberAllowedValuesEnumAddLabel: 'Add',
  numberAllowedValuesEnumAddPlaceholder: 'Add allowed value...',
  numberValidationErrorMinMax: 'Minimum and maximum values must be consistent.',
  numberValidationErrorBothExclusiveAndInclusiveMin:
    "Both 'exclusiveMinimum' and 'minimum' cannot be set at the same time.",
  numberValidationErrorBothExclusiveAndInclusiveMax:
    "Both 'exclusiveMaximum' and 'maximum' cannot be set at the same time.",
  numberValidationErrorEnumOutOfRange:
    'Enum values must be within the defined range.',

  objectPropertiesNone: 'No properties defined',
  objectValidationErrorMinMax:
    "'minProperties' cannot be greater than 'maxProperties'.",

  stringMinimumLengthLabel: 'Minimum Length',
  stringMinimumLengthPlaceholder: 'No minimum',
  stringMaximumLengthLabel: 'Maximum Length',
  stringMaximumLengthPlaceholder: 'No maximum',
  stringPatternLabel: 'Pattern (regex)',
  stringPatternPlaceholder: '^[a-zA-Z]+$',
  stringFormatLabel: 'Format',
  stringFormatNone: 'None',
  stringFormatDateTime: 'Date-Time',
  stringFormatDate: 'Date',
  stringFormatTime: 'Time',
  stringFormatEmail: 'Email',
  stringFormatUri: 'URI',
  stringFormatUuid: 'UUID',
  stringFormatHostname: 'Hostname',
  stringFormatIpv4: 'IPv4 Address',
  stringFormatIpv6: 'IPv6 Address',
  stringAllowedValuesEnumLabel: 'Allowed Values (enum)',
  stringAllowedValuesEnumNone: 'No restricted values set',
  stringAllowedValuesEnumAddPlaceholder: 'Add allowed value...',
  stringValidationErrorLengthRange:
    "'Minimum Length' cannot be greater than 'Maximum Length'.",

  schemaTypeArray: 'List',
  schemaTypeBoolean: 'Yes/No',
  schemaTypeNumber: 'Number',
  schemaTypeObject: 'Object',
  schemaTypeString: 'Text',
  schemaTypeNull: 'Empty',

  inferrerTitle: 'Infer JSON Schema',
  inferrerDescription:
    'Paste your JSON document below to generate a schema from it.',
  inferrerCancel: 'Cancel',
  inferrerGenerate: 'Generate Schema',
  inferrerErrorInvalidJson: 'Invalid JSON format. Please check your input.',

  validatorTitle: 'Validate JSON',
  validatorDescription:
    'Paste your JSON document to validate against the current schema. Validation occurs automatically as you type.',
  validatorCurrentSchema: 'Current Schema:',
  validatorContent: 'Your JSON:',
  validatorValid: 'JSON is valid according to the schema!',
  validatorErrorInvalidSyntax: 'Invalid JSON syntax',
  validatorErrorSchemaValidation: 'Schema validation error',
  validatorErrorCount: '{count} validation errors detected',
  validatorErrorPathRoot: 'Root',
  validatorErrorLocationLineAndColumn: 'Line {line}, Col {column}',
  validatorErrorLocationLineOnly: 'Line {line}',

  visualizerDownloadTitle: 'Download Schema',
  visualizerDownloadFileName: 'schema.json',
  visualizerSource: 'JSON Schema Source',

  visualEditorNoFieldsHint1: 'No fields defined yet',
  visualEditorNoFieldsHint2: 'Add your first field to get started',

  typeValidationErrorNegativeLength: 'Length values cannot be negative.',
  typeValidationErrorIntValue: 'Value must be an integer.',
  typeValidationErrorPositive: 'Value must be positive.',
};
