
# install.packages("MSToolkit", repos="http://R-Forge.R-project.org")
# install.packages("Rweibo", repos="http://R-Forge.R-project.org")
# install.packages("Rwordseg", repos="http://R-Forge.R-project.org")
# install.packages("wordcloud")
# install.packages("googleVis")
# install.packages("sqldf")

setwd("E:\\Demo\\ChinaR\\Drug")

# Drug
library(MSToolkit)
generateData( replicateN = 5, subjects = 100, treatDoses = c(0, 5, 10, 50, 100),
	treatPeriod = c(0:7) * 24,
	genParNames = "E0,ED50,EMAX", genParMean = c(2,50,10), genParVCov = c(.5,30,10), 
	respEqn = "E0 + ((DOSE * EMAX)/(DOSE + ED50))",  respVCov = 2, 
)
 
 

# Word cloud
library(Rweibo)
library(Rwordseg)
library(wordcloud)
text1 <- web.search.content("~H7N9", page = 25, combinewith = NULL)
old.ctype <- Sys.getlocale("LC_CTYPE")
Sys.setlocale(category = "LC_CTYPE", locale = "chs")
words1 <- segmentCN(text1$Weibo)
words1[[1]]
table1 <- table(unlist(words1))
wordsDf1 <- data.frame(WORD = names(table1), FREQ = as.vector(table1), stringsAsFactors = FALSE)
wordsDf1 <- wordsDf1[grep("[\u4e00-\u9fa5]", wordsDf1$WORD), ]
wordsDf1 <- wordsDf1[wordsDf1$FREQ > 3, ]
wordsDf1 <- wordsDf1[nchar(wordsDf1$WORD) > 1, ]
wordsDf1 <- wordsDf1[wordsDf1$WORD != "", ]
windows()
wordcloud(wordsDf1$WORD, wordsDf1$FREQ, col = rainbow(length(wordsDf1$FREQ)))
Sys.setlocale(category = "LC_CTYPE", locale = old.ctype)



# Vis
library(googleVis)
library(sqldf)
registerApp(app_name = "rweibodemo", "yourkey", "yoursecret") 
roauth1 <- createOAuth("rweibodemo", "rdemo")
repDf0 <- analysis.getReposts(roauth1, "3578225848330623", count = 1000)
repDf0$followers_count <- as.numeric(repDf0$followers_count)
repDf0$Nchar <- nchar(repDf0$text)
repDf0$Nname <- nchar(repDf0$screen_name)
repDf0$Time <- substr(repDf0$created_at, 9, 13)
repDf0$Province1 <- as.vector(sapply(repDf0$location, FUN = function(X) strsplit(X, split = " ")[[1]][1]))
xlim1 <- mean(repDf0$followers_count) + sd(repDf0$followers_count)
repDf1 <- repDf0[repDf0$followers_count < xlim1,]
repDf_motion <- sqldf("select Province1, Time, count(Nchar) as 'Count', sum(Nchar) as 'Nchar', sum(followers_count) as 'Nfollowers' from repDf1 group by Province1, Time")
Encoding(repDf_motion$Province1) <- "UTF-8"
repDf_motion$Time <- as.numeric(as.factor(repDf_motion$Time)) + Sys.Date()
M1 <- gvisMotionChart(repDf_motion, idvar="Province1", timevar="Time",
	xvar = "Nfollowers", yvar = "Nchar", colorvar = "", 
	sizevar = "") 
Sys.setlocale(category = "LC_CTYPE", locale = "chs")
plot(M1)
Sys.setlocale(category = "LC_CTYPE", locale = old.ctype)


