package schema

import (
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/entsql"
	"entgo.io/ent/schema"
	"entgo.io/ent/schema/edge"
	"entgo.io/ent/schema/field"
	"github.com/google/uuid"

	"github.com/chaitin/MonkeyCode/backend/consts"
)

// Admin holds the schema definition for the Admin entity.
type Admin struct {
	ent.Schema
}

func (Admin) Annotations() []schema.Annotation {
	return []schema.Annotation{
		entsql.Annotation{
			Table: "admins",
		},
	}
}

// Fields of the Admin.
func (Admin) Fields() []ent.Field {
	return []ent.Field{
		field.UUID("id", uuid.UUID{}),
		field.String("username").Unique(),
		field.String("password"),
		field.String("status").GoType(consts.AdminStatus("")),
		field.Time("last_active_at").Default(time.Now),
		field.Time("created_at").Default(time.Now),
		field.Time("updated_at").Default(time.Now).UpdateDefault(time.Now),
	}
}

// Edges of the Admin.
func (Admin) Edges() []ent.Edge {
	return []ent.Edge{
		edge.To("login_histories", AdminLoginHistory.Type),
		edge.To("myusergroups", UserGroup.Type),
		edge.To("aiemployees", AIEmployee.Type),
		edge.From("usergroups", UserGroup.Type).Ref("admins").Through("user_group_admins", UserGroupAdmin.Type),
		edge.From("roles", Role.Type).Ref("admins").Through("admin_roles", AdminRole.Type),
	}
}
