// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanning"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/workspace"
	"github.com/chaitin/MonkeyCode/backend/db/workspacefile"
	"github.com/google/uuid"
)

// WorkspaceUpdate is the builder for updating Workspace entities.
type WorkspaceUpdate struct {
	config
	hooks     []Hook
	mutation  *WorkspaceMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the WorkspaceUpdate builder.
func (wu *WorkspaceUpdate) Where(ps ...predicate.Workspace) *WorkspaceUpdate {
	wu.mutation.Where(ps...)
	return wu
}

// SetUserID sets the "user_id" field.
func (wu *WorkspaceUpdate) SetUserID(u uuid.UUID) *WorkspaceUpdate {
	wu.mutation.SetUserID(u)
	return wu
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (wu *WorkspaceUpdate) SetNillableUserID(u *uuid.UUID) *WorkspaceUpdate {
	if u != nil {
		wu.SetUserID(*u)
	}
	return wu
}

// SetName sets the "name" field.
func (wu *WorkspaceUpdate) SetName(s string) *WorkspaceUpdate {
	wu.mutation.SetName(s)
	return wu
}

// SetNillableName sets the "name" field if the given value is not nil.
func (wu *WorkspaceUpdate) SetNillableName(s *string) *WorkspaceUpdate {
	if s != nil {
		wu.SetName(*s)
	}
	return wu
}

// ClearName clears the value of the "name" field.
func (wu *WorkspaceUpdate) ClearName() *WorkspaceUpdate {
	wu.mutation.ClearName()
	return wu
}

// SetDescription sets the "description" field.
func (wu *WorkspaceUpdate) SetDescription(s string) *WorkspaceUpdate {
	wu.mutation.SetDescription(s)
	return wu
}

// SetNillableDescription sets the "description" field if the given value is not nil.
func (wu *WorkspaceUpdate) SetNillableDescription(s *string) *WorkspaceUpdate {
	if s != nil {
		wu.SetDescription(*s)
	}
	return wu
}

// ClearDescription clears the value of the "description" field.
func (wu *WorkspaceUpdate) ClearDescription() *WorkspaceUpdate {
	wu.mutation.ClearDescription()
	return wu
}

// SetRootPath sets the "root_path" field.
func (wu *WorkspaceUpdate) SetRootPath(s string) *WorkspaceUpdate {
	wu.mutation.SetRootPath(s)
	return wu
}

// SetNillableRootPath sets the "root_path" field if the given value is not nil.
func (wu *WorkspaceUpdate) SetNillableRootPath(s *string) *WorkspaceUpdate {
	if s != nil {
		wu.SetRootPath(*s)
	}
	return wu
}

// SetSettings sets the "settings" field.
func (wu *WorkspaceUpdate) SetSettings(m map[string]interface{}) *WorkspaceUpdate {
	wu.mutation.SetSettings(m)
	return wu
}

// ClearSettings clears the value of the "settings" field.
func (wu *WorkspaceUpdate) ClearSettings() *WorkspaceUpdate {
	wu.mutation.ClearSettings()
	return wu
}

// SetLastAccessedAt sets the "last_accessed_at" field.
func (wu *WorkspaceUpdate) SetLastAccessedAt(t time.Time) *WorkspaceUpdate {
	wu.mutation.SetLastAccessedAt(t)
	return wu
}

// SetNillableLastAccessedAt sets the "last_accessed_at" field if the given value is not nil.
func (wu *WorkspaceUpdate) SetNillableLastAccessedAt(t *time.Time) *WorkspaceUpdate {
	if t != nil {
		wu.SetLastAccessedAt(*t)
	}
	return wu
}

// SetUpdatedAt sets the "updated_at" field.
func (wu *WorkspaceUpdate) SetUpdatedAt(t time.Time) *WorkspaceUpdate {
	wu.mutation.SetUpdatedAt(t)
	return wu
}

// SetOwnerID sets the "owner" edge to the User entity by ID.
func (wu *WorkspaceUpdate) SetOwnerID(id uuid.UUID) *WorkspaceUpdate {
	wu.mutation.SetOwnerID(id)
	return wu
}

// SetOwner sets the "owner" edge to the User entity.
func (wu *WorkspaceUpdate) SetOwner(u *User) *WorkspaceUpdate {
	return wu.SetOwnerID(u.ID)
}

// AddFileIDs adds the "files" edge to the WorkspaceFile entity by IDs.
func (wu *WorkspaceUpdate) AddFileIDs(ids ...uuid.UUID) *WorkspaceUpdate {
	wu.mutation.AddFileIDs(ids...)
	return wu
}

// AddFiles adds the "files" edges to the WorkspaceFile entity.
func (wu *WorkspaceUpdate) AddFiles(w ...*WorkspaceFile) *WorkspaceUpdate {
	ids := make([]uuid.UUID, len(w))
	for i := range w {
		ids[i] = w[i].ID
	}
	return wu.AddFileIDs(ids...)
}

// AddSecurityScanningIDs adds the "security_scannings" edge to the SecurityScanning entity by IDs.
func (wu *WorkspaceUpdate) AddSecurityScanningIDs(ids ...uuid.UUID) *WorkspaceUpdate {
	wu.mutation.AddSecurityScanningIDs(ids...)
	return wu
}

// AddSecurityScannings adds the "security_scannings" edges to the SecurityScanning entity.
func (wu *WorkspaceUpdate) AddSecurityScannings(s ...*SecurityScanning) *WorkspaceUpdate {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return wu.AddSecurityScanningIDs(ids...)
}

// Mutation returns the WorkspaceMutation object of the builder.
func (wu *WorkspaceUpdate) Mutation() *WorkspaceMutation {
	return wu.mutation
}

// ClearOwner clears the "owner" edge to the User entity.
func (wu *WorkspaceUpdate) ClearOwner() *WorkspaceUpdate {
	wu.mutation.ClearOwner()
	return wu
}

// ClearFiles clears all "files" edges to the WorkspaceFile entity.
func (wu *WorkspaceUpdate) ClearFiles() *WorkspaceUpdate {
	wu.mutation.ClearFiles()
	return wu
}

// RemoveFileIDs removes the "files" edge to WorkspaceFile entities by IDs.
func (wu *WorkspaceUpdate) RemoveFileIDs(ids ...uuid.UUID) *WorkspaceUpdate {
	wu.mutation.RemoveFileIDs(ids...)
	return wu
}

// RemoveFiles removes "files" edges to WorkspaceFile entities.
func (wu *WorkspaceUpdate) RemoveFiles(w ...*WorkspaceFile) *WorkspaceUpdate {
	ids := make([]uuid.UUID, len(w))
	for i := range w {
		ids[i] = w[i].ID
	}
	return wu.RemoveFileIDs(ids...)
}

// ClearSecurityScannings clears all "security_scannings" edges to the SecurityScanning entity.
func (wu *WorkspaceUpdate) ClearSecurityScannings() *WorkspaceUpdate {
	wu.mutation.ClearSecurityScannings()
	return wu
}

// RemoveSecurityScanningIDs removes the "security_scannings" edge to SecurityScanning entities by IDs.
func (wu *WorkspaceUpdate) RemoveSecurityScanningIDs(ids ...uuid.UUID) *WorkspaceUpdate {
	wu.mutation.RemoveSecurityScanningIDs(ids...)
	return wu
}

// RemoveSecurityScannings removes "security_scannings" edges to SecurityScanning entities.
func (wu *WorkspaceUpdate) RemoveSecurityScannings(s ...*SecurityScanning) *WorkspaceUpdate {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return wu.RemoveSecurityScanningIDs(ids...)
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (wu *WorkspaceUpdate) Save(ctx context.Context) (int, error) {
	wu.defaults()
	return withHooks(ctx, wu.sqlSave, wu.mutation, wu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (wu *WorkspaceUpdate) SaveX(ctx context.Context) int {
	affected, err := wu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (wu *WorkspaceUpdate) Exec(ctx context.Context) error {
	_, err := wu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (wu *WorkspaceUpdate) ExecX(ctx context.Context) {
	if err := wu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (wu *WorkspaceUpdate) defaults() {
	if _, ok := wu.mutation.UpdatedAt(); !ok {
		v := workspace.UpdateDefaultUpdatedAt()
		wu.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (wu *WorkspaceUpdate) check() error {
	if v, ok := wu.mutation.RootPath(); ok {
		if err := workspace.RootPathValidator(v); err != nil {
			return &ValidationError{Name: "root_path", err: fmt.Errorf(`db: validator failed for field "Workspace.root_path": %w`, err)}
		}
	}
	if wu.mutation.OwnerCleared() && len(wu.mutation.OwnerIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "Workspace.owner"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (wu *WorkspaceUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *WorkspaceUpdate {
	wu.modifiers = append(wu.modifiers, modifiers...)
	return wu
}

func (wu *WorkspaceUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := wu.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(workspace.Table, workspace.Columns, sqlgraph.NewFieldSpec(workspace.FieldID, field.TypeUUID))
	if ps := wu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := wu.mutation.Name(); ok {
		_spec.SetField(workspace.FieldName, field.TypeString, value)
	}
	if wu.mutation.NameCleared() {
		_spec.ClearField(workspace.FieldName, field.TypeString)
	}
	if value, ok := wu.mutation.Description(); ok {
		_spec.SetField(workspace.FieldDescription, field.TypeString, value)
	}
	if wu.mutation.DescriptionCleared() {
		_spec.ClearField(workspace.FieldDescription, field.TypeString)
	}
	if value, ok := wu.mutation.RootPath(); ok {
		_spec.SetField(workspace.FieldRootPath, field.TypeString, value)
	}
	if value, ok := wu.mutation.Settings(); ok {
		_spec.SetField(workspace.FieldSettings, field.TypeJSON, value)
	}
	if wu.mutation.SettingsCleared() {
		_spec.ClearField(workspace.FieldSettings, field.TypeJSON)
	}
	if value, ok := wu.mutation.LastAccessedAt(); ok {
		_spec.SetField(workspace.FieldLastAccessedAt, field.TypeTime, value)
	}
	if value, ok := wu.mutation.UpdatedAt(); ok {
		_spec.SetField(workspace.FieldUpdatedAt, field.TypeTime, value)
	}
	if wu.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspace.OwnerTable,
			Columns: []string{workspace.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wu.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspace.OwnerTable,
			Columns: []string{workspace.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if wu.mutation.FilesCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspace.FilesTable,
			Columns: []string{workspace.FilesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wu.mutation.RemovedFilesIDs(); len(nodes) > 0 && !wu.mutation.FilesCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspace.FilesTable,
			Columns: []string{workspace.FilesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wu.mutation.FilesIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspace.FilesTable,
			Columns: []string{workspace.FilesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if wu.mutation.SecurityScanningsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspace.SecurityScanningsTable,
			Columns: []string{workspace.SecurityScanningsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wu.mutation.RemovedSecurityScanningsIDs(); len(nodes) > 0 && !wu.mutation.SecurityScanningsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspace.SecurityScanningsTable,
			Columns: []string{workspace.SecurityScanningsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wu.mutation.SecurityScanningsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspace.SecurityScanningsTable,
			Columns: []string{workspace.SecurityScanningsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(wu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, wu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{workspace.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	wu.mutation.done = true
	return n, nil
}

// WorkspaceUpdateOne is the builder for updating a single Workspace entity.
type WorkspaceUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *WorkspaceMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetUserID sets the "user_id" field.
func (wuo *WorkspaceUpdateOne) SetUserID(u uuid.UUID) *WorkspaceUpdateOne {
	wuo.mutation.SetUserID(u)
	return wuo
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (wuo *WorkspaceUpdateOne) SetNillableUserID(u *uuid.UUID) *WorkspaceUpdateOne {
	if u != nil {
		wuo.SetUserID(*u)
	}
	return wuo
}

// SetName sets the "name" field.
func (wuo *WorkspaceUpdateOne) SetName(s string) *WorkspaceUpdateOne {
	wuo.mutation.SetName(s)
	return wuo
}

// SetNillableName sets the "name" field if the given value is not nil.
func (wuo *WorkspaceUpdateOne) SetNillableName(s *string) *WorkspaceUpdateOne {
	if s != nil {
		wuo.SetName(*s)
	}
	return wuo
}

// ClearName clears the value of the "name" field.
func (wuo *WorkspaceUpdateOne) ClearName() *WorkspaceUpdateOne {
	wuo.mutation.ClearName()
	return wuo
}

// SetDescription sets the "description" field.
func (wuo *WorkspaceUpdateOne) SetDescription(s string) *WorkspaceUpdateOne {
	wuo.mutation.SetDescription(s)
	return wuo
}

// SetNillableDescription sets the "description" field if the given value is not nil.
func (wuo *WorkspaceUpdateOne) SetNillableDescription(s *string) *WorkspaceUpdateOne {
	if s != nil {
		wuo.SetDescription(*s)
	}
	return wuo
}

// ClearDescription clears the value of the "description" field.
func (wuo *WorkspaceUpdateOne) ClearDescription() *WorkspaceUpdateOne {
	wuo.mutation.ClearDescription()
	return wuo
}

// SetRootPath sets the "root_path" field.
func (wuo *WorkspaceUpdateOne) SetRootPath(s string) *WorkspaceUpdateOne {
	wuo.mutation.SetRootPath(s)
	return wuo
}

// SetNillableRootPath sets the "root_path" field if the given value is not nil.
func (wuo *WorkspaceUpdateOne) SetNillableRootPath(s *string) *WorkspaceUpdateOne {
	if s != nil {
		wuo.SetRootPath(*s)
	}
	return wuo
}

// SetSettings sets the "settings" field.
func (wuo *WorkspaceUpdateOne) SetSettings(m map[string]interface{}) *WorkspaceUpdateOne {
	wuo.mutation.SetSettings(m)
	return wuo
}

// ClearSettings clears the value of the "settings" field.
func (wuo *WorkspaceUpdateOne) ClearSettings() *WorkspaceUpdateOne {
	wuo.mutation.ClearSettings()
	return wuo
}

// SetLastAccessedAt sets the "last_accessed_at" field.
func (wuo *WorkspaceUpdateOne) SetLastAccessedAt(t time.Time) *WorkspaceUpdateOne {
	wuo.mutation.SetLastAccessedAt(t)
	return wuo
}

// SetNillableLastAccessedAt sets the "last_accessed_at" field if the given value is not nil.
func (wuo *WorkspaceUpdateOne) SetNillableLastAccessedAt(t *time.Time) *WorkspaceUpdateOne {
	if t != nil {
		wuo.SetLastAccessedAt(*t)
	}
	return wuo
}

// SetUpdatedAt sets the "updated_at" field.
func (wuo *WorkspaceUpdateOne) SetUpdatedAt(t time.Time) *WorkspaceUpdateOne {
	wuo.mutation.SetUpdatedAt(t)
	return wuo
}

// SetOwnerID sets the "owner" edge to the User entity by ID.
func (wuo *WorkspaceUpdateOne) SetOwnerID(id uuid.UUID) *WorkspaceUpdateOne {
	wuo.mutation.SetOwnerID(id)
	return wuo
}

// SetOwner sets the "owner" edge to the User entity.
func (wuo *WorkspaceUpdateOne) SetOwner(u *User) *WorkspaceUpdateOne {
	return wuo.SetOwnerID(u.ID)
}

// AddFileIDs adds the "files" edge to the WorkspaceFile entity by IDs.
func (wuo *WorkspaceUpdateOne) AddFileIDs(ids ...uuid.UUID) *WorkspaceUpdateOne {
	wuo.mutation.AddFileIDs(ids...)
	return wuo
}

// AddFiles adds the "files" edges to the WorkspaceFile entity.
func (wuo *WorkspaceUpdateOne) AddFiles(w ...*WorkspaceFile) *WorkspaceUpdateOne {
	ids := make([]uuid.UUID, len(w))
	for i := range w {
		ids[i] = w[i].ID
	}
	return wuo.AddFileIDs(ids...)
}

// AddSecurityScanningIDs adds the "security_scannings" edge to the SecurityScanning entity by IDs.
func (wuo *WorkspaceUpdateOne) AddSecurityScanningIDs(ids ...uuid.UUID) *WorkspaceUpdateOne {
	wuo.mutation.AddSecurityScanningIDs(ids...)
	return wuo
}

// AddSecurityScannings adds the "security_scannings" edges to the SecurityScanning entity.
func (wuo *WorkspaceUpdateOne) AddSecurityScannings(s ...*SecurityScanning) *WorkspaceUpdateOne {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return wuo.AddSecurityScanningIDs(ids...)
}

// Mutation returns the WorkspaceMutation object of the builder.
func (wuo *WorkspaceUpdateOne) Mutation() *WorkspaceMutation {
	return wuo.mutation
}

// ClearOwner clears the "owner" edge to the User entity.
func (wuo *WorkspaceUpdateOne) ClearOwner() *WorkspaceUpdateOne {
	wuo.mutation.ClearOwner()
	return wuo
}

// ClearFiles clears all "files" edges to the WorkspaceFile entity.
func (wuo *WorkspaceUpdateOne) ClearFiles() *WorkspaceUpdateOne {
	wuo.mutation.ClearFiles()
	return wuo
}

// RemoveFileIDs removes the "files" edge to WorkspaceFile entities by IDs.
func (wuo *WorkspaceUpdateOne) RemoveFileIDs(ids ...uuid.UUID) *WorkspaceUpdateOne {
	wuo.mutation.RemoveFileIDs(ids...)
	return wuo
}

// RemoveFiles removes "files" edges to WorkspaceFile entities.
func (wuo *WorkspaceUpdateOne) RemoveFiles(w ...*WorkspaceFile) *WorkspaceUpdateOne {
	ids := make([]uuid.UUID, len(w))
	for i := range w {
		ids[i] = w[i].ID
	}
	return wuo.RemoveFileIDs(ids...)
}

// ClearSecurityScannings clears all "security_scannings" edges to the SecurityScanning entity.
func (wuo *WorkspaceUpdateOne) ClearSecurityScannings() *WorkspaceUpdateOne {
	wuo.mutation.ClearSecurityScannings()
	return wuo
}

// RemoveSecurityScanningIDs removes the "security_scannings" edge to SecurityScanning entities by IDs.
func (wuo *WorkspaceUpdateOne) RemoveSecurityScanningIDs(ids ...uuid.UUID) *WorkspaceUpdateOne {
	wuo.mutation.RemoveSecurityScanningIDs(ids...)
	return wuo
}

// RemoveSecurityScannings removes "security_scannings" edges to SecurityScanning entities.
func (wuo *WorkspaceUpdateOne) RemoveSecurityScannings(s ...*SecurityScanning) *WorkspaceUpdateOne {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return wuo.RemoveSecurityScanningIDs(ids...)
}

// Where appends a list predicates to the WorkspaceUpdate builder.
func (wuo *WorkspaceUpdateOne) Where(ps ...predicate.Workspace) *WorkspaceUpdateOne {
	wuo.mutation.Where(ps...)
	return wuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (wuo *WorkspaceUpdateOne) Select(field string, fields ...string) *WorkspaceUpdateOne {
	wuo.fields = append([]string{field}, fields...)
	return wuo
}

// Save executes the query and returns the updated Workspace entity.
func (wuo *WorkspaceUpdateOne) Save(ctx context.Context) (*Workspace, error) {
	wuo.defaults()
	return withHooks(ctx, wuo.sqlSave, wuo.mutation, wuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (wuo *WorkspaceUpdateOne) SaveX(ctx context.Context) *Workspace {
	node, err := wuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (wuo *WorkspaceUpdateOne) Exec(ctx context.Context) error {
	_, err := wuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (wuo *WorkspaceUpdateOne) ExecX(ctx context.Context) {
	if err := wuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (wuo *WorkspaceUpdateOne) defaults() {
	if _, ok := wuo.mutation.UpdatedAt(); !ok {
		v := workspace.UpdateDefaultUpdatedAt()
		wuo.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (wuo *WorkspaceUpdateOne) check() error {
	if v, ok := wuo.mutation.RootPath(); ok {
		if err := workspace.RootPathValidator(v); err != nil {
			return &ValidationError{Name: "root_path", err: fmt.Errorf(`db: validator failed for field "Workspace.root_path": %w`, err)}
		}
	}
	if wuo.mutation.OwnerCleared() && len(wuo.mutation.OwnerIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "Workspace.owner"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (wuo *WorkspaceUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *WorkspaceUpdateOne {
	wuo.modifiers = append(wuo.modifiers, modifiers...)
	return wuo
}

func (wuo *WorkspaceUpdateOne) sqlSave(ctx context.Context) (_node *Workspace, err error) {
	if err := wuo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(workspace.Table, workspace.Columns, sqlgraph.NewFieldSpec(workspace.FieldID, field.TypeUUID))
	id, ok := wuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "Workspace.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := wuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, workspace.FieldID)
		for _, f := range fields {
			if !workspace.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != workspace.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := wuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := wuo.mutation.Name(); ok {
		_spec.SetField(workspace.FieldName, field.TypeString, value)
	}
	if wuo.mutation.NameCleared() {
		_spec.ClearField(workspace.FieldName, field.TypeString)
	}
	if value, ok := wuo.mutation.Description(); ok {
		_spec.SetField(workspace.FieldDescription, field.TypeString, value)
	}
	if wuo.mutation.DescriptionCleared() {
		_spec.ClearField(workspace.FieldDescription, field.TypeString)
	}
	if value, ok := wuo.mutation.RootPath(); ok {
		_spec.SetField(workspace.FieldRootPath, field.TypeString, value)
	}
	if value, ok := wuo.mutation.Settings(); ok {
		_spec.SetField(workspace.FieldSettings, field.TypeJSON, value)
	}
	if wuo.mutation.SettingsCleared() {
		_spec.ClearField(workspace.FieldSettings, field.TypeJSON)
	}
	if value, ok := wuo.mutation.LastAccessedAt(); ok {
		_spec.SetField(workspace.FieldLastAccessedAt, field.TypeTime, value)
	}
	if value, ok := wuo.mutation.UpdatedAt(); ok {
		_spec.SetField(workspace.FieldUpdatedAt, field.TypeTime, value)
	}
	if wuo.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspace.OwnerTable,
			Columns: []string{workspace.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wuo.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspace.OwnerTable,
			Columns: []string{workspace.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if wuo.mutation.FilesCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspace.FilesTable,
			Columns: []string{workspace.FilesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wuo.mutation.RemovedFilesIDs(); len(nodes) > 0 && !wuo.mutation.FilesCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspace.FilesTable,
			Columns: []string{workspace.FilesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wuo.mutation.FilesIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspace.FilesTable,
			Columns: []string{workspace.FilesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if wuo.mutation.SecurityScanningsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspace.SecurityScanningsTable,
			Columns: []string{workspace.SecurityScanningsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wuo.mutation.RemovedSecurityScanningsIDs(); len(nodes) > 0 && !wuo.mutation.SecurityScanningsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspace.SecurityScanningsTable,
			Columns: []string{workspace.SecurityScanningsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wuo.mutation.SecurityScanningsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspace.SecurityScanningsTable,
			Columns: []string{workspace.SecurityScanningsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(wuo.modifiers...)
	_node = &Workspace{config: wuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, wuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{workspace.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	wuo.mutation.done = true
	return _node, nil
}
