// Code generated by ent, DO NOT EDIT.

package workspace

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the workspace type in the database.
	Label = "workspace"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldUserID holds the string denoting the user_id field in the database.
	FieldUserID = "user_id"
	// FieldName holds the string denoting the name field in the database.
	FieldName = "name"
	// FieldDescription holds the string denoting the description field in the database.
	FieldDescription = "description"
	// FieldRootPath holds the string denoting the root_path field in the database.
	FieldRootPath = "root_path"
	// FieldSettings holds the string denoting the settings field in the database.
	FieldSettings = "settings"
	// FieldLastAccessedAt holds the string denoting the last_accessed_at field in the database.
	FieldLastAccessedAt = "last_accessed_at"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// FieldUpdatedAt holds the string denoting the updated_at field in the database.
	FieldUpdatedAt = "updated_at"
	// EdgeOwner holds the string denoting the owner edge name in mutations.
	EdgeOwner = "owner"
	// EdgeFiles holds the string denoting the files edge name in mutations.
	EdgeFiles = "files"
	// EdgeSecurityScannings holds the string denoting the security_scannings edge name in mutations.
	EdgeSecurityScannings = "security_scannings"
	// Table holds the table name of the workspace in the database.
	Table = "workspaces"
	// OwnerTable is the table that holds the owner relation/edge.
	OwnerTable = "workspaces"
	// OwnerInverseTable is the table name for the User entity.
	// It exists in this package in order to avoid circular dependency with the "user" package.
	OwnerInverseTable = "users"
	// OwnerColumn is the table column denoting the owner relation/edge.
	OwnerColumn = "user_id"
	// FilesTable is the table that holds the files relation/edge.
	FilesTable = "workspace_files"
	// FilesInverseTable is the table name for the WorkspaceFile entity.
	// It exists in this package in order to avoid circular dependency with the "workspacefile" package.
	FilesInverseTable = "workspace_files"
	// FilesColumn is the table column denoting the files relation/edge.
	FilesColumn = "workspace_id"
	// SecurityScanningsTable is the table that holds the security_scannings relation/edge.
	SecurityScanningsTable = "security_scannings"
	// SecurityScanningsInverseTable is the table name for the SecurityScanning entity.
	// It exists in this package in order to avoid circular dependency with the "securityscanning" package.
	SecurityScanningsInverseTable = "security_scannings"
	// SecurityScanningsColumn is the table column denoting the security_scannings relation/edge.
	SecurityScanningsColumn = "workspace_id"
)

// Columns holds all SQL columns for workspace fields.
var Columns = []string{
	FieldID,
	FieldUserID,
	FieldName,
	FieldDescription,
	FieldRootPath,
	FieldSettings,
	FieldLastAccessedAt,
	FieldCreatedAt,
	FieldUpdatedAt,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// RootPathValidator is a validator for the "root_path" field. It is called by the builders before save.
	RootPathValidator func(string) error
	// DefaultLastAccessedAt holds the default value on creation for the "last_accessed_at" field.
	DefaultLastAccessedAt func() time.Time
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
	// DefaultUpdatedAt holds the default value on creation for the "updated_at" field.
	DefaultUpdatedAt func() time.Time
	// UpdateDefaultUpdatedAt holds the default value on update for the "updated_at" field.
	UpdateDefaultUpdatedAt func() time.Time
)

// OrderOption defines the ordering options for the Workspace queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByUserID orders the results by the user_id field.
func ByUserID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUserID, opts...).ToFunc()
}

// ByName orders the results by the name field.
func ByName(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldName, opts...).ToFunc()
}

// ByDescription orders the results by the description field.
func ByDescription(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldDescription, opts...).ToFunc()
}

// ByRootPath orders the results by the root_path field.
func ByRootPath(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldRootPath, opts...).ToFunc()
}

// ByLastAccessedAt orders the results by the last_accessed_at field.
func ByLastAccessedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldLastAccessedAt, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByUpdatedAt orders the results by the updated_at field.
func ByUpdatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUpdatedAt, opts...).ToFunc()
}

// ByOwnerField orders the results by owner field.
func ByOwnerField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newOwnerStep(), sql.OrderByField(field, opts...))
	}
}

// ByFilesCount orders the results by files count.
func ByFilesCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newFilesStep(), opts...)
	}
}

// ByFiles orders the results by files terms.
func ByFiles(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newFilesStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// BySecurityScanningsCount orders the results by security_scannings count.
func BySecurityScanningsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newSecurityScanningsStep(), opts...)
	}
}

// BySecurityScannings orders the results by security_scannings terms.
func BySecurityScannings(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newSecurityScanningsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}
func newOwnerStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(OwnerInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, OwnerTable, OwnerColumn),
	)
}
func newFilesStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(FilesInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, FilesTable, FilesColumn),
	)
}
func newSecurityScanningsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(SecurityScanningsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, SecurityScanningsTable, SecurityScanningsColumn),
	)
}
