// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/userloginhistory"
	"github.com/google/uuid"
)

// UserLoginHistoryUpdate is the builder for updating UserLoginHistory entities.
type UserLoginHistoryUpdate struct {
	config
	hooks     []Hook
	mutation  *UserLoginHistoryMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the UserLoginHistoryUpdate builder.
func (ulhu *UserLoginHistoryUpdate) Where(ps ...predicate.UserLoginHistory) *UserLoginHistoryUpdate {
	ulhu.mutation.Where(ps...)
	return ulhu
}

// SetUserID sets the "user_id" field.
func (ulhu *UserLoginHistoryUpdate) SetUserID(u uuid.UUID) *UserLoginHistoryUpdate {
	ulhu.mutation.SetUserID(u)
	return ulhu
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (ulhu *UserLoginHistoryUpdate) SetNillableUserID(u *uuid.UUID) *UserLoginHistoryUpdate {
	if u != nil {
		ulhu.SetUserID(*u)
	}
	return ulhu
}

// ClearUserID clears the value of the "user_id" field.
func (ulhu *UserLoginHistoryUpdate) ClearUserID() *UserLoginHistoryUpdate {
	ulhu.mutation.ClearUserID()
	return ulhu
}

// SetIP sets the "ip" field.
func (ulhu *UserLoginHistoryUpdate) SetIP(s string) *UserLoginHistoryUpdate {
	ulhu.mutation.SetIP(s)
	return ulhu
}

// SetNillableIP sets the "ip" field if the given value is not nil.
func (ulhu *UserLoginHistoryUpdate) SetNillableIP(s *string) *UserLoginHistoryUpdate {
	if s != nil {
		ulhu.SetIP(*s)
	}
	return ulhu
}

// SetCountry sets the "country" field.
func (ulhu *UserLoginHistoryUpdate) SetCountry(s string) *UserLoginHistoryUpdate {
	ulhu.mutation.SetCountry(s)
	return ulhu
}

// SetNillableCountry sets the "country" field if the given value is not nil.
func (ulhu *UserLoginHistoryUpdate) SetNillableCountry(s *string) *UserLoginHistoryUpdate {
	if s != nil {
		ulhu.SetCountry(*s)
	}
	return ulhu
}

// SetProvince sets the "province" field.
func (ulhu *UserLoginHistoryUpdate) SetProvince(s string) *UserLoginHistoryUpdate {
	ulhu.mutation.SetProvince(s)
	return ulhu
}

// SetNillableProvince sets the "province" field if the given value is not nil.
func (ulhu *UserLoginHistoryUpdate) SetNillableProvince(s *string) *UserLoginHistoryUpdate {
	if s != nil {
		ulhu.SetProvince(*s)
	}
	return ulhu
}

// SetCity sets the "city" field.
func (ulhu *UserLoginHistoryUpdate) SetCity(s string) *UserLoginHistoryUpdate {
	ulhu.mutation.SetCity(s)
	return ulhu
}

// SetNillableCity sets the "city" field if the given value is not nil.
func (ulhu *UserLoginHistoryUpdate) SetNillableCity(s *string) *UserLoginHistoryUpdate {
	if s != nil {
		ulhu.SetCity(*s)
	}
	return ulhu
}

// SetIsp sets the "isp" field.
func (ulhu *UserLoginHistoryUpdate) SetIsp(s string) *UserLoginHistoryUpdate {
	ulhu.mutation.SetIsp(s)
	return ulhu
}

// SetNillableIsp sets the "isp" field if the given value is not nil.
func (ulhu *UserLoginHistoryUpdate) SetNillableIsp(s *string) *UserLoginHistoryUpdate {
	if s != nil {
		ulhu.SetIsp(*s)
	}
	return ulhu
}

// ClearIsp clears the value of the "isp" field.
func (ulhu *UserLoginHistoryUpdate) ClearIsp() *UserLoginHistoryUpdate {
	ulhu.mutation.ClearIsp()
	return ulhu
}

// SetAsn sets the "asn" field.
func (ulhu *UserLoginHistoryUpdate) SetAsn(s string) *UserLoginHistoryUpdate {
	ulhu.mutation.SetAsn(s)
	return ulhu
}

// SetNillableAsn sets the "asn" field if the given value is not nil.
func (ulhu *UserLoginHistoryUpdate) SetNillableAsn(s *string) *UserLoginHistoryUpdate {
	if s != nil {
		ulhu.SetAsn(*s)
	}
	return ulhu
}

// ClearAsn clears the value of the "asn" field.
func (ulhu *UserLoginHistoryUpdate) ClearAsn() *UserLoginHistoryUpdate {
	ulhu.mutation.ClearAsn()
	return ulhu
}

// SetClientVersion sets the "client_version" field.
func (ulhu *UserLoginHistoryUpdate) SetClientVersion(s string) *UserLoginHistoryUpdate {
	ulhu.mutation.SetClientVersion(s)
	return ulhu
}

// SetNillableClientVersion sets the "client_version" field if the given value is not nil.
func (ulhu *UserLoginHistoryUpdate) SetNillableClientVersion(s *string) *UserLoginHistoryUpdate {
	if s != nil {
		ulhu.SetClientVersion(*s)
	}
	return ulhu
}

// ClearClientVersion clears the value of the "client_version" field.
func (ulhu *UserLoginHistoryUpdate) ClearClientVersion() *UserLoginHistoryUpdate {
	ulhu.mutation.ClearClientVersion()
	return ulhu
}

// SetOsType sets the "os_type" field.
func (ulhu *UserLoginHistoryUpdate) SetOsType(ct consts.OSType) *UserLoginHistoryUpdate {
	ulhu.mutation.SetOsType(ct)
	return ulhu
}

// SetNillableOsType sets the "os_type" field if the given value is not nil.
func (ulhu *UserLoginHistoryUpdate) SetNillableOsType(ct *consts.OSType) *UserLoginHistoryUpdate {
	if ct != nil {
		ulhu.SetOsType(*ct)
	}
	return ulhu
}

// ClearOsType clears the value of the "os_type" field.
func (ulhu *UserLoginHistoryUpdate) ClearOsType() *UserLoginHistoryUpdate {
	ulhu.mutation.ClearOsType()
	return ulhu
}

// SetOsRelease sets the "os_release" field.
func (ulhu *UserLoginHistoryUpdate) SetOsRelease(cr consts.OSRelease) *UserLoginHistoryUpdate {
	ulhu.mutation.SetOsRelease(cr)
	return ulhu
}

// SetNillableOsRelease sets the "os_release" field if the given value is not nil.
func (ulhu *UserLoginHistoryUpdate) SetNillableOsRelease(cr *consts.OSRelease) *UserLoginHistoryUpdate {
	if cr != nil {
		ulhu.SetOsRelease(*cr)
	}
	return ulhu
}

// ClearOsRelease clears the value of the "os_release" field.
func (ulhu *UserLoginHistoryUpdate) ClearOsRelease() *UserLoginHistoryUpdate {
	ulhu.mutation.ClearOsRelease()
	return ulhu
}

// SetHostname sets the "hostname" field.
func (ulhu *UserLoginHistoryUpdate) SetHostname(s string) *UserLoginHistoryUpdate {
	ulhu.mutation.SetHostname(s)
	return ulhu
}

// SetNillableHostname sets the "hostname" field if the given value is not nil.
func (ulhu *UserLoginHistoryUpdate) SetNillableHostname(s *string) *UserLoginHistoryUpdate {
	if s != nil {
		ulhu.SetHostname(*s)
	}
	return ulhu
}

// ClearHostname clears the value of the "hostname" field.
func (ulhu *UserLoginHistoryUpdate) ClearHostname() *UserLoginHistoryUpdate {
	ulhu.mutation.ClearHostname()
	return ulhu
}

// SetClientID sets the "client_id" field.
func (ulhu *UserLoginHistoryUpdate) SetClientID(s string) *UserLoginHistoryUpdate {
	ulhu.mutation.SetClientID(s)
	return ulhu
}

// SetNillableClientID sets the "client_id" field if the given value is not nil.
func (ulhu *UserLoginHistoryUpdate) SetNillableClientID(s *string) *UserLoginHistoryUpdate {
	if s != nil {
		ulhu.SetClientID(*s)
	}
	return ulhu
}

// ClearClientID clears the value of the "client_id" field.
func (ulhu *UserLoginHistoryUpdate) ClearClientID() *UserLoginHistoryUpdate {
	ulhu.mutation.ClearClientID()
	return ulhu
}

// SetCreatedAt sets the "created_at" field.
func (ulhu *UserLoginHistoryUpdate) SetCreatedAt(t time.Time) *UserLoginHistoryUpdate {
	ulhu.mutation.SetCreatedAt(t)
	return ulhu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ulhu *UserLoginHistoryUpdate) SetNillableCreatedAt(t *time.Time) *UserLoginHistoryUpdate {
	if t != nil {
		ulhu.SetCreatedAt(*t)
	}
	return ulhu
}

// SetOwnerID sets the "owner" edge to the User entity by ID.
func (ulhu *UserLoginHistoryUpdate) SetOwnerID(id uuid.UUID) *UserLoginHistoryUpdate {
	ulhu.mutation.SetOwnerID(id)
	return ulhu
}

// SetNillableOwnerID sets the "owner" edge to the User entity by ID if the given value is not nil.
func (ulhu *UserLoginHistoryUpdate) SetNillableOwnerID(id *uuid.UUID) *UserLoginHistoryUpdate {
	if id != nil {
		ulhu = ulhu.SetOwnerID(*id)
	}
	return ulhu
}

// SetOwner sets the "owner" edge to the User entity.
func (ulhu *UserLoginHistoryUpdate) SetOwner(u *User) *UserLoginHistoryUpdate {
	return ulhu.SetOwnerID(u.ID)
}

// Mutation returns the UserLoginHistoryMutation object of the builder.
func (ulhu *UserLoginHistoryUpdate) Mutation() *UserLoginHistoryMutation {
	return ulhu.mutation
}

// ClearOwner clears the "owner" edge to the User entity.
func (ulhu *UserLoginHistoryUpdate) ClearOwner() *UserLoginHistoryUpdate {
	ulhu.mutation.ClearOwner()
	return ulhu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (ulhu *UserLoginHistoryUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, ulhu.sqlSave, ulhu.mutation, ulhu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (ulhu *UserLoginHistoryUpdate) SaveX(ctx context.Context) int {
	affected, err := ulhu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (ulhu *UserLoginHistoryUpdate) Exec(ctx context.Context) error {
	_, err := ulhu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ulhu *UserLoginHistoryUpdate) ExecX(ctx context.Context) {
	if err := ulhu.Exec(ctx); err != nil {
		panic(err)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (ulhu *UserLoginHistoryUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *UserLoginHistoryUpdate {
	ulhu.modifiers = append(ulhu.modifiers, modifiers...)
	return ulhu
}

func (ulhu *UserLoginHistoryUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(userloginhistory.Table, userloginhistory.Columns, sqlgraph.NewFieldSpec(userloginhistory.FieldID, field.TypeUUID))
	if ps := ulhu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := ulhu.mutation.IP(); ok {
		_spec.SetField(userloginhistory.FieldIP, field.TypeString, value)
	}
	if value, ok := ulhu.mutation.Country(); ok {
		_spec.SetField(userloginhistory.FieldCountry, field.TypeString, value)
	}
	if value, ok := ulhu.mutation.Province(); ok {
		_spec.SetField(userloginhistory.FieldProvince, field.TypeString, value)
	}
	if value, ok := ulhu.mutation.City(); ok {
		_spec.SetField(userloginhistory.FieldCity, field.TypeString, value)
	}
	if value, ok := ulhu.mutation.Isp(); ok {
		_spec.SetField(userloginhistory.FieldIsp, field.TypeString, value)
	}
	if ulhu.mutation.IspCleared() {
		_spec.ClearField(userloginhistory.FieldIsp, field.TypeString)
	}
	if value, ok := ulhu.mutation.Asn(); ok {
		_spec.SetField(userloginhistory.FieldAsn, field.TypeString, value)
	}
	if ulhu.mutation.AsnCleared() {
		_spec.ClearField(userloginhistory.FieldAsn, field.TypeString)
	}
	if value, ok := ulhu.mutation.ClientVersion(); ok {
		_spec.SetField(userloginhistory.FieldClientVersion, field.TypeString, value)
	}
	if ulhu.mutation.ClientVersionCleared() {
		_spec.ClearField(userloginhistory.FieldClientVersion, field.TypeString)
	}
	if value, ok := ulhu.mutation.OsType(); ok {
		_spec.SetField(userloginhistory.FieldOsType, field.TypeString, value)
	}
	if ulhu.mutation.OsTypeCleared() {
		_spec.ClearField(userloginhistory.FieldOsType, field.TypeString)
	}
	if value, ok := ulhu.mutation.OsRelease(); ok {
		_spec.SetField(userloginhistory.FieldOsRelease, field.TypeString, value)
	}
	if ulhu.mutation.OsReleaseCleared() {
		_spec.ClearField(userloginhistory.FieldOsRelease, field.TypeString)
	}
	if value, ok := ulhu.mutation.Hostname(); ok {
		_spec.SetField(userloginhistory.FieldHostname, field.TypeString, value)
	}
	if ulhu.mutation.HostnameCleared() {
		_spec.ClearField(userloginhistory.FieldHostname, field.TypeString)
	}
	if value, ok := ulhu.mutation.ClientID(); ok {
		_spec.SetField(userloginhistory.FieldClientID, field.TypeString, value)
	}
	if ulhu.mutation.ClientIDCleared() {
		_spec.ClearField(userloginhistory.FieldClientID, field.TypeString)
	}
	if value, ok := ulhu.mutation.CreatedAt(); ok {
		_spec.SetField(userloginhistory.FieldCreatedAt, field.TypeTime, value)
	}
	if ulhu.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   userloginhistory.OwnerTable,
			Columns: []string{userloginhistory.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ulhu.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   userloginhistory.OwnerTable,
			Columns: []string{userloginhistory.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(ulhu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, ulhu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{userloginhistory.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	ulhu.mutation.done = true
	return n, nil
}

// UserLoginHistoryUpdateOne is the builder for updating a single UserLoginHistory entity.
type UserLoginHistoryUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *UserLoginHistoryMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetUserID sets the "user_id" field.
func (ulhuo *UserLoginHistoryUpdateOne) SetUserID(u uuid.UUID) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.SetUserID(u)
	return ulhuo
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (ulhuo *UserLoginHistoryUpdateOne) SetNillableUserID(u *uuid.UUID) *UserLoginHistoryUpdateOne {
	if u != nil {
		ulhuo.SetUserID(*u)
	}
	return ulhuo
}

// ClearUserID clears the value of the "user_id" field.
func (ulhuo *UserLoginHistoryUpdateOne) ClearUserID() *UserLoginHistoryUpdateOne {
	ulhuo.mutation.ClearUserID()
	return ulhuo
}

// SetIP sets the "ip" field.
func (ulhuo *UserLoginHistoryUpdateOne) SetIP(s string) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.SetIP(s)
	return ulhuo
}

// SetNillableIP sets the "ip" field if the given value is not nil.
func (ulhuo *UserLoginHistoryUpdateOne) SetNillableIP(s *string) *UserLoginHistoryUpdateOne {
	if s != nil {
		ulhuo.SetIP(*s)
	}
	return ulhuo
}

// SetCountry sets the "country" field.
func (ulhuo *UserLoginHistoryUpdateOne) SetCountry(s string) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.SetCountry(s)
	return ulhuo
}

// SetNillableCountry sets the "country" field if the given value is not nil.
func (ulhuo *UserLoginHistoryUpdateOne) SetNillableCountry(s *string) *UserLoginHistoryUpdateOne {
	if s != nil {
		ulhuo.SetCountry(*s)
	}
	return ulhuo
}

// SetProvince sets the "province" field.
func (ulhuo *UserLoginHistoryUpdateOne) SetProvince(s string) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.SetProvince(s)
	return ulhuo
}

// SetNillableProvince sets the "province" field if the given value is not nil.
func (ulhuo *UserLoginHistoryUpdateOne) SetNillableProvince(s *string) *UserLoginHistoryUpdateOne {
	if s != nil {
		ulhuo.SetProvince(*s)
	}
	return ulhuo
}

// SetCity sets the "city" field.
func (ulhuo *UserLoginHistoryUpdateOne) SetCity(s string) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.SetCity(s)
	return ulhuo
}

// SetNillableCity sets the "city" field if the given value is not nil.
func (ulhuo *UserLoginHistoryUpdateOne) SetNillableCity(s *string) *UserLoginHistoryUpdateOne {
	if s != nil {
		ulhuo.SetCity(*s)
	}
	return ulhuo
}

// SetIsp sets the "isp" field.
func (ulhuo *UserLoginHistoryUpdateOne) SetIsp(s string) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.SetIsp(s)
	return ulhuo
}

// SetNillableIsp sets the "isp" field if the given value is not nil.
func (ulhuo *UserLoginHistoryUpdateOne) SetNillableIsp(s *string) *UserLoginHistoryUpdateOne {
	if s != nil {
		ulhuo.SetIsp(*s)
	}
	return ulhuo
}

// ClearIsp clears the value of the "isp" field.
func (ulhuo *UserLoginHistoryUpdateOne) ClearIsp() *UserLoginHistoryUpdateOne {
	ulhuo.mutation.ClearIsp()
	return ulhuo
}

// SetAsn sets the "asn" field.
func (ulhuo *UserLoginHistoryUpdateOne) SetAsn(s string) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.SetAsn(s)
	return ulhuo
}

// SetNillableAsn sets the "asn" field if the given value is not nil.
func (ulhuo *UserLoginHistoryUpdateOne) SetNillableAsn(s *string) *UserLoginHistoryUpdateOne {
	if s != nil {
		ulhuo.SetAsn(*s)
	}
	return ulhuo
}

// ClearAsn clears the value of the "asn" field.
func (ulhuo *UserLoginHistoryUpdateOne) ClearAsn() *UserLoginHistoryUpdateOne {
	ulhuo.mutation.ClearAsn()
	return ulhuo
}

// SetClientVersion sets the "client_version" field.
func (ulhuo *UserLoginHistoryUpdateOne) SetClientVersion(s string) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.SetClientVersion(s)
	return ulhuo
}

// SetNillableClientVersion sets the "client_version" field if the given value is not nil.
func (ulhuo *UserLoginHistoryUpdateOne) SetNillableClientVersion(s *string) *UserLoginHistoryUpdateOne {
	if s != nil {
		ulhuo.SetClientVersion(*s)
	}
	return ulhuo
}

// ClearClientVersion clears the value of the "client_version" field.
func (ulhuo *UserLoginHistoryUpdateOne) ClearClientVersion() *UserLoginHistoryUpdateOne {
	ulhuo.mutation.ClearClientVersion()
	return ulhuo
}

// SetOsType sets the "os_type" field.
func (ulhuo *UserLoginHistoryUpdateOne) SetOsType(ct consts.OSType) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.SetOsType(ct)
	return ulhuo
}

// SetNillableOsType sets the "os_type" field if the given value is not nil.
func (ulhuo *UserLoginHistoryUpdateOne) SetNillableOsType(ct *consts.OSType) *UserLoginHistoryUpdateOne {
	if ct != nil {
		ulhuo.SetOsType(*ct)
	}
	return ulhuo
}

// ClearOsType clears the value of the "os_type" field.
func (ulhuo *UserLoginHistoryUpdateOne) ClearOsType() *UserLoginHistoryUpdateOne {
	ulhuo.mutation.ClearOsType()
	return ulhuo
}

// SetOsRelease sets the "os_release" field.
func (ulhuo *UserLoginHistoryUpdateOne) SetOsRelease(cr consts.OSRelease) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.SetOsRelease(cr)
	return ulhuo
}

// SetNillableOsRelease sets the "os_release" field if the given value is not nil.
func (ulhuo *UserLoginHistoryUpdateOne) SetNillableOsRelease(cr *consts.OSRelease) *UserLoginHistoryUpdateOne {
	if cr != nil {
		ulhuo.SetOsRelease(*cr)
	}
	return ulhuo
}

// ClearOsRelease clears the value of the "os_release" field.
func (ulhuo *UserLoginHistoryUpdateOne) ClearOsRelease() *UserLoginHistoryUpdateOne {
	ulhuo.mutation.ClearOsRelease()
	return ulhuo
}

// SetHostname sets the "hostname" field.
func (ulhuo *UserLoginHistoryUpdateOne) SetHostname(s string) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.SetHostname(s)
	return ulhuo
}

// SetNillableHostname sets the "hostname" field if the given value is not nil.
func (ulhuo *UserLoginHistoryUpdateOne) SetNillableHostname(s *string) *UserLoginHistoryUpdateOne {
	if s != nil {
		ulhuo.SetHostname(*s)
	}
	return ulhuo
}

// ClearHostname clears the value of the "hostname" field.
func (ulhuo *UserLoginHistoryUpdateOne) ClearHostname() *UserLoginHistoryUpdateOne {
	ulhuo.mutation.ClearHostname()
	return ulhuo
}

// SetClientID sets the "client_id" field.
func (ulhuo *UserLoginHistoryUpdateOne) SetClientID(s string) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.SetClientID(s)
	return ulhuo
}

// SetNillableClientID sets the "client_id" field if the given value is not nil.
func (ulhuo *UserLoginHistoryUpdateOne) SetNillableClientID(s *string) *UserLoginHistoryUpdateOne {
	if s != nil {
		ulhuo.SetClientID(*s)
	}
	return ulhuo
}

// ClearClientID clears the value of the "client_id" field.
func (ulhuo *UserLoginHistoryUpdateOne) ClearClientID() *UserLoginHistoryUpdateOne {
	ulhuo.mutation.ClearClientID()
	return ulhuo
}

// SetCreatedAt sets the "created_at" field.
func (ulhuo *UserLoginHistoryUpdateOne) SetCreatedAt(t time.Time) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.SetCreatedAt(t)
	return ulhuo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ulhuo *UserLoginHistoryUpdateOne) SetNillableCreatedAt(t *time.Time) *UserLoginHistoryUpdateOne {
	if t != nil {
		ulhuo.SetCreatedAt(*t)
	}
	return ulhuo
}

// SetOwnerID sets the "owner" edge to the User entity by ID.
func (ulhuo *UserLoginHistoryUpdateOne) SetOwnerID(id uuid.UUID) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.SetOwnerID(id)
	return ulhuo
}

// SetNillableOwnerID sets the "owner" edge to the User entity by ID if the given value is not nil.
func (ulhuo *UserLoginHistoryUpdateOne) SetNillableOwnerID(id *uuid.UUID) *UserLoginHistoryUpdateOne {
	if id != nil {
		ulhuo = ulhuo.SetOwnerID(*id)
	}
	return ulhuo
}

// SetOwner sets the "owner" edge to the User entity.
func (ulhuo *UserLoginHistoryUpdateOne) SetOwner(u *User) *UserLoginHistoryUpdateOne {
	return ulhuo.SetOwnerID(u.ID)
}

// Mutation returns the UserLoginHistoryMutation object of the builder.
func (ulhuo *UserLoginHistoryUpdateOne) Mutation() *UserLoginHistoryMutation {
	return ulhuo.mutation
}

// ClearOwner clears the "owner" edge to the User entity.
func (ulhuo *UserLoginHistoryUpdateOne) ClearOwner() *UserLoginHistoryUpdateOne {
	ulhuo.mutation.ClearOwner()
	return ulhuo
}

// Where appends a list predicates to the UserLoginHistoryUpdate builder.
func (ulhuo *UserLoginHistoryUpdateOne) Where(ps ...predicate.UserLoginHistory) *UserLoginHistoryUpdateOne {
	ulhuo.mutation.Where(ps...)
	return ulhuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (ulhuo *UserLoginHistoryUpdateOne) Select(field string, fields ...string) *UserLoginHistoryUpdateOne {
	ulhuo.fields = append([]string{field}, fields...)
	return ulhuo
}

// Save executes the query and returns the updated UserLoginHistory entity.
func (ulhuo *UserLoginHistoryUpdateOne) Save(ctx context.Context) (*UserLoginHistory, error) {
	return withHooks(ctx, ulhuo.sqlSave, ulhuo.mutation, ulhuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (ulhuo *UserLoginHistoryUpdateOne) SaveX(ctx context.Context) *UserLoginHistory {
	node, err := ulhuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (ulhuo *UserLoginHistoryUpdateOne) Exec(ctx context.Context) error {
	_, err := ulhuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ulhuo *UserLoginHistoryUpdateOne) ExecX(ctx context.Context) {
	if err := ulhuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (ulhuo *UserLoginHistoryUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *UserLoginHistoryUpdateOne {
	ulhuo.modifiers = append(ulhuo.modifiers, modifiers...)
	return ulhuo
}

func (ulhuo *UserLoginHistoryUpdateOne) sqlSave(ctx context.Context) (_node *UserLoginHistory, err error) {
	_spec := sqlgraph.NewUpdateSpec(userloginhistory.Table, userloginhistory.Columns, sqlgraph.NewFieldSpec(userloginhistory.FieldID, field.TypeUUID))
	id, ok := ulhuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "UserLoginHistory.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := ulhuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, userloginhistory.FieldID)
		for _, f := range fields {
			if !userloginhistory.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != userloginhistory.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := ulhuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := ulhuo.mutation.IP(); ok {
		_spec.SetField(userloginhistory.FieldIP, field.TypeString, value)
	}
	if value, ok := ulhuo.mutation.Country(); ok {
		_spec.SetField(userloginhistory.FieldCountry, field.TypeString, value)
	}
	if value, ok := ulhuo.mutation.Province(); ok {
		_spec.SetField(userloginhistory.FieldProvince, field.TypeString, value)
	}
	if value, ok := ulhuo.mutation.City(); ok {
		_spec.SetField(userloginhistory.FieldCity, field.TypeString, value)
	}
	if value, ok := ulhuo.mutation.Isp(); ok {
		_spec.SetField(userloginhistory.FieldIsp, field.TypeString, value)
	}
	if ulhuo.mutation.IspCleared() {
		_spec.ClearField(userloginhistory.FieldIsp, field.TypeString)
	}
	if value, ok := ulhuo.mutation.Asn(); ok {
		_spec.SetField(userloginhistory.FieldAsn, field.TypeString, value)
	}
	if ulhuo.mutation.AsnCleared() {
		_spec.ClearField(userloginhistory.FieldAsn, field.TypeString)
	}
	if value, ok := ulhuo.mutation.ClientVersion(); ok {
		_spec.SetField(userloginhistory.FieldClientVersion, field.TypeString, value)
	}
	if ulhuo.mutation.ClientVersionCleared() {
		_spec.ClearField(userloginhistory.FieldClientVersion, field.TypeString)
	}
	if value, ok := ulhuo.mutation.OsType(); ok {
		_spec.SetField(userloginhistory.FieldOsType, field.TypeString, value)
	}
	if ulhuo.mutation.OsTypeCleared() {
		_spec.ClearField(userloginhistory.FieldOsType, field.TypeString)
	}
	if value, ok := ulhuo.mutation.OsRelease(); ok {
		_spec.SetField(userloginhistory.FieldOsRelease, field.TypeString, value)
	}
	if ulhuo.mutation.OsReleaseCleared() {
		_spec.ClearField(userloginhistory.FieldOsRelease, field.TypeString)
	}
	if value, ok := ulhuo.mutation.Hostname(); ok {
		_spec.SetField(userloginhistory.FieldHostname, field.TypeString, value)
	}
	if ulhuo.mutation.HostnameCleared() {
		_spec.ClearField(userloginhistory.FieldHostname, field.TypeString)
	}
	if value, ok := ulhuo.mutation.ClientID(); ok {
		_spec.SetField(userloginhistory.FieldClientID, field.TypeString, value)
	}
	if ulhuo.mutation.ClientIDCleared() {
		_spec.ClearField(userloginhistory.FieldClientID, field.TypeString)
	}
	if value, ok := ulhuo.mutation.CreatedAt(); ok {
		_spec.SetField(userloginhistory.FieldCreatedAt, field.TypeTime, value)
	}
	if ulhuo.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   userloginhistory.OwnerTable,
			Columns: []string{userloginhistory.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ulhuo.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   userloginhistory.OwnerTable,
			Columns: []string{userloginhistory.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(ulhuo.modifiers...)
	_node = &UserLoginHistory{config: ulhuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, ulhuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{userloginhistory.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	ulhuo.mutation.done = true
	return _node, nil
}
