// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/userloginhistory"
	"github.com/google/uuid"
)

// UserLoginHistoryCreate is the builder for creating a UserLoginHistory entity.
type UserLoginHistoryCreate struct {
	config
	mutation *UserLoginHistoryMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetUserID sets the "user_id" field.
func (ulhc *UserLoginHistoryCreate) SetUserID(u uuid.UUID) *UserLoginHistoryCreate {
	ulhc.mutation.SetUserID(u)
	return ulhc
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (ulhc *UserLoginHistoryCreate) SetNillableUserID(u *uuid.UUID) *UserLoginHistoryCreate {
	if u != nil {
		ulhc.SetUserID(*u)
	}
	return ulhc
}

// SetIP sets the "ip" field.
func (ulhc *UserLoginHistoryCreate) SetIP(s string) *UserLoginHistoryCreate {
	ulhc.mutation.SetIP(s)
	return ulhc
}

// SetCountry sets the "country" field.
func (ulhc *UserLoginHistoryCreate) SetCountry(s string) *UserLoginHistoryCreate {
	ulhc.mutation.SetCountry(s)
	return ulhc
}

// SetProvince sets the "province" field.
func (ulhc *UserLoginHistoryCreate) SetProvince(s string) *UserLoginHistoryCreate {
	ulhc.mutation.SetProvince(s)
	return ulhc
}

// SetCity sets the "city" field.
func (ulhc *UserLoginHistoryCreate) SetCity(s string) *UserLoginHistoryCreate {
	ulhc.mutation.SetCity(s)
	return ulhc
}

// SetIsp sets the "isp" field.
func (ulhc *UserLoginHistoryCreate) SetIsp(s string) *UserLoginHistoryCreate {
	ulhc.mutation.SetIsp(s)
	return ulhc
}

// SetNillableIsp sets the "isp" field if the given value is not nil.
func (ulhc *UserLoginHistoryCreate) SetNillableIsp(s *string) *UserLoginHistoryCreate {
	if s != nil {
		ulhc.SetIsp(*s)
	}
	return ulhc
}

// SetAsn sets the "asn" field.
func (ulhc *UserLoginHistoryCreate) SetAsn(s string) *UserLoginHistoryCreate {
	ulhc.mutation.SetAsn(s)
	return ulhc
}

// SetNillableAsn sets the "asn" field if the given value is not nil.
func (ulhc *UserLoginHistoryCreate) SetNillableAsn(s *string) *UserLoginHistoryCreate {
	if s != nil {
		ulhc.SetAsn(*s)
	}
	return ulhc
}

// SetClientVersion sets the "client_version" field.
func (ulhc *UserLoginHistoryCreate) SetClientVersion(s string) *UserLoginHistoryCreate {
	ulhc.mutation.SetClientVersion(s)
	return ulhc
}

// SetNillableClientVersion sets the "client_version" field if the given value is not nil.
func (ulhc *UserLoginHistoryCreate) SetNillableClientVersion(s *string) *UserLoginHistoryCreate {
	if s != nil {
		ulhc.SetClientVersion(*s)
	}
	return ulhc
}

// SetOsType sets the "os_type" field.
func (ulhc *UserLoginHistoryCreate) SetOsType(ct consts.OSType) *UserLoginHistoryCreate {
	ulhc.mutation.SetOsType(ct)
	return ulhc
}

// SetNillableOsType sets the "os_type" field if the given value is not nil.
func (ulhc *UserLoginHistoryCreate) SetNillableOsType(ct *consts.OSType) *UserLoginHistoryCreate {
	if ct != nil {
		ulhc.SetOsType(*ct)
	}
	return ulhc
}

// SetOsRelease sets the "os_release" field.
func (ulhc *UserLoginHistoryCreate) SetOsRelease(cr consts.OSRelease) *UserLoginHistoryCreate {
	ulhc.mutation.SetOsRelease(cr)
	return ulhc
}

// SetNillableOsRelease sets the "os_release" field if the given value is not nil.
func (ulhc *UserLoginHistoryCreate) SetNillableOsRelease(cr *consts.OSRelease) *UserLoginHistoryCreate {
	if cr != nil {
		ulhc.SetOsRelease(*cr)
	}
	return ulhc
}

// SetHostname sets the "hostname" field.
func (ulhc *UserLoginHistoryCreate) SetHostname(s string) *UserLoginHistoryCreate {
	ulhc.mutation.SetHostname(s)
	return ulhc
}

// SetNillableHostname sets the "hostname" field if the given value is not nil.
func (ulhc *UserLoginHistoryCreate) SetNillableHostname(s *string) *UserLoginHistoryCreate {
	if s != nil {
		ulhc.SetHostname(*s)
	}
	return ulhc
}

// SetClientID sets the "client_id" field.
func (ulhc *UserLoginHistoryCreate) SetClientID(s string) *UserLoginHistoryCreate {
	ulhc.mutation.SetClientID(s)
	return ulhc
}

// SetNillableClientID sets the "client_id" field if the given value is not nil.
func (ulhc *UserLoginHistoryCreate) SetNillableClientID(s *string) *UserLoginHistoryCreate {
	if s != nil {
		ulhc.SetClientID(*s)
	}
	return ulhc
}

// SetCreatedAt sets the "created_at" field.
func (ulhc *UserLoginHistoryCreate) SetCreatedAt(t time.Time) *UserLoginHistoryCreate {
	ulhc.mutation.SetCreatedAt(t)
	return ulhc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ulhc *UserLoginHistoryCreate) SetNillableCreatedAt(t *time.Time) *UserLoginHistoryCreate {
	if t != nil {
		ulhc.SetCreatedAt(*t)
	}
	return ulhc
}

// SetID sets the "id" field.
func (ulhc *UserLoginHistoryCreate) SetID(u uuid.UUID) *UserLoginHistoryCreate {
	ulhc.mutation.SetID(u)
	return ulhc
}

// SetOwnerID sets the "owner" edge to the User entity by ID.
func (ulhc *UserLoginHistoryCreate) SetOwnerID(id uuid.UUID) *UserLoginHistoryCreate {
	ulhc.mutation.SetOwnerID(id)
	return ulhc
}

// SetNillableOwnerID sets the "owner" edge to the User entity by ID if the given value is not nil.
func (ulhc *UserLoginHistoryCreate) SetNillableOwnerID(id *uuid.UUID) *UserLoginHistoryCreate {
	if id != nil {
		ulhc = ulhc.SetOwnerID(*id)
	}
	return ulhc
}

// SetOwner sets the "owner" edge to the User entity.
func (ulhc *UserLoginHistoryCreate) SetOwner(u *User) *UserLoginHistoryCreate {
	return ulhc.SetOwnerID(u.ID)
}

// Mutation returns the UserLoginHistoryMutation object of the builder.
func (ulhc *UserLoginHistoryCreate) Mutation() *UserLoginHistoryMutation {
	return ulhc.mutation
}

// Save creates the UserLoginHistory in the database.
func (ulhc *UserLoginHistoryCreate) Save(ctx context.Context) (*UserLoginHistory, error) {
	ulhc.defaults()
	return withHooks(ctx, ulhc.sqlSave, ulhc.mutation, ulhc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (ulhc *UserLoginHistoryCreate) SaveX(ctx context.Context) *UserLoginHistory {
	v, err := ulhc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (ulhc *UserLoginHistoryCreate) Exec(ctx context.Context) error {
	_, err := ulhc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ulhc *UserLoginHistoryCreate) ExecX(ctx context.Context) {
	if err := ulhc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (ulhc *UserLoginHistoryCreate) defaults() {
	if _, ok := ulhc.mutation.CreatedAt(); !ok {
		v := userloginhistory.DefaultCreatedAt()
		ulhc.mutation.SetCreatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ulhc *UserLoginHistoryCreate) check() error {
	if _, ok := ulhc.mutation.IP(); !ok {
		return &ValidationError{Name: "ip", err: errors.New(`db: missing required field "UserLoginHistory.ip"`)}
	}
	if _, ok := ulhc.mutation.Country(); !ok {
		return &ValidationError{Name: "country", err: errors.New(`db: missing required field "UserLoginHistory.country"`)}
	}
	if _, ok := ulhc.mutation.Province(); !ok {
		return &ValidationError{Name: "province", err: errors.New(`db: missing required field "UserLoginHistory.province"`)}
	}
	if _, ok := ulhc.mutation.City(); !ok {
		return &ValidationError{Name: "city", err: errors.New(`db: missing required field "UserLoginHistory.city"`)}
	}
	if _, ok := ulhc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "UserLoginHistory.created_at"`)}
	}
	return nil
}

func (ulhc *UserLoginHistoryCreate) sqlSave(ctx context.Context) (*UserLoginHistory, error) {
	if err := ulhc.check(); err != nil {
		return nil, err
	}
	_node, _spec := ulhc.createSpec()
	if err := sqlgraph.CreateNode(ctx, ulhc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	ulhc.mutation.id = &_node.ID
	ulhc.mutation.done = true
	return _node, nil
}

func (ulhc *UserLoginHistoryCreate) createSpec() (*UserLoginHistory, *sqlgraph.CreateSpec) {
	var (
		_node = &UserLoginHistory{config: ulhc.config}
		_spec = sqlgraph.NewCreateSpec(userloginhistory.Table, sqlgraph.NewFieldSpec(userloginhistory.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = ulhc.conflict
	if id, ok := ulhc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := ulhc.mutation.IP(); ok {
		_spec.SetField(userloginhistory.FieldIP, field.TypeString, value)
		_node.IP = value
	}
	if value, ok := ulhc.mutation.Country(); ok {
		_spec.SetField(userloginhistory.FieldCountry, field.TypeString, value)
		_node.Country = value
	}
	if value, ok := ulhc.mutation.Province(); ok {
		_spec.SetField(userloginhistory.FieldProvince, field.TypeString, value)
		_node.Province = value
	}
	if value, ok := ulhc.mutation.City(); ok {
		_spec.SetField(userloginhistory.FieldCity, field.TypeString, value)
		_node.City = value
	}
	if value, ok := ulhc.mutation.Isp(); ok {
		_spec.SetField(userloginhistory.FieldIsp, field.TypeString, value)
		_node.Isp = value
	}
	if value, ok := ulhc.mutation.Asn(); ok {
		_spec.SetField(userloginhistory.FieldAsn, field.TypeString, value)
		_node.Asn = value
	}
	if value, ok := ulhc.mutation.ClientVersion(); ok {
		_spec.SetField(userloginhistory.FieldClientVersion, field.TypeString, value)
		_node.ClientVersion = value
	}
	if value, ok := ulhc.mutation.OsType(); ok {
		_spec.SetField(userloginhistory.FieldOsType, field.TypeString, value)
		_node.OsType = value
	}
	if value, ok := ulhc.mutation.OsRelease(); ok {
		_spec.SetField(userloginhistory.FieldOsRelease, field.TypeString, value)
		_node.OsRelease = value
	}
	if value, ok := ulhc.mutation.Hostname(); ok {
		_spec.SetField(userloginhistory.FieldHostname, field.TypeString, value)
		_node.Hostname = value
	}
	if value, ok := ulhc.mutation.ClientID(); ok {
		_spec.SetField(userloginhistory.FieldClientID, field.TypeString, value)
		_node.ClientID = value
	}
	if value, ok := ulhc.mutation.CreatedAt(); ok {
		_spec.SetField(userloginhistory.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if nodes := ulhc.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   userloginhistory.OwnerTable,
			Columns: []string{userloginhistory.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.UserID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.UserLoginHistory.Create().
//		SetUserID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.UserLoginHistoryUpsert) {
//			SetUserID(v+v).
//		}).
//		Exec(ctx)
func (ulhc *UserLoginHistoryCreate) OnConflict(opts ...sql.ConflictOption) *UserLoginHistoryUpsertOne {
	ulhc.conflict = opts
	return &UserLoginHistoryUpsertOne{
		create: ulhc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.UserLoginHistory.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (ulhc *UserLoginHistoryCreate) OnConflictColumns(columns ...string) *UserLoginHistoryUpsertOne {
	ulhc.conflict = append(ulhc.conflict, sql.ConflictColumns(columns...))
	return &UserLoginHistoryUpsertOne{
		create: ulhc,
	}
}

type (
	// UserLoginHistoryUpsertOne is the builder for "upsert"-ing
	//  one UserLoginHistory node.
	UserLoginHistoryUpsertOne struct {
		create *UserLoginHistoryCreate
	}

	// UserLoginHistoryUpsert is the "OnConflict" setter.
	UserLoginHistoryUpsert struct {
		*sql.UpdateSet
	}
)

// SetUserID sets the "user_id" field.
func (u *UserLoginHistoryUpsert) SetUserID(v uuid.UUID) *UserLoginHistoryUpsert {
	u.Set(userloginhistory.FieldUserID, v)
	return u
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *UserLoginHistoryUpsert) UpdateUserID() *UserLoginHistoryUpsert {
	u.SetExcluded(userloginhistory.FieldUserID)
	return u
}

// ClearUserID clears the value of the "user_id" field.
func (u *UserLoginHistoryUpsert) ClearUserID() *UserLoginHistoryUpsert {
	u.SetNull(userloginhistory.FieldUserID)
	return u
}

// SetIP sets the "ip" field.
func (u *UserLoginHistoryUpsert) SetIP(v string) *UserLoginHistoryUpsert {
	u.Set(userloginhistory.FieldIP, v)
	return u
}

// UpdateIP sets the "ip" field to the value that was provided on create.
func (u *UserLoginHistoryUpsert) UpdateIP() *UserLoginHistoryUpsert {
	u.SetExcluded(userloginhistory.FieldIP)
	return u
}

// SetCountry sets the "country" field.
func (u *UserLoginHistoryUpsert) SetCountry(v string) *UserLoginHistoryUpsert {
	u.Set(userloginhistory.FieldCountry, v)
	return u
}

// UpdateCountry sets the "country" field to the value that was provided on create.
func (u *UserLoginHistoryUpsert) UpdateCountry() *UserLoginHistoryUpsert {
	u.SetExcluded(userloginhistory.FieldCountry)
	return u
}

// SetProvince sets the "province" field.
func (u *UserLoginHistoryUpsert) SetProvince(v string) *UserLoginHistoryUpsert {
	u.Set(userloginhistory.FieldProvince, v)
	return u
}

// UpdateProvince sets the "province" field to the value that was provided on create.
func (u *UserLoginHistoryUpsert) UpdateProvince() *UserLoginHistoryUpsert {
	u.SetExcluded(userloginhistory.FieldProvince)
	return u
}

// SetCity sets the "city" field.
func (u *UserLoginHistoryUpsert) SetCity(v string) *UserLoginHistoryUpsert {
	u.Set(userloginhistory.FieldCity, v)
	return u
}

// UpdateCity sets the "city" field to the value that was provided on create.
func (u *UserLoginHistoryUpsert) UpdateCity() *UserLoginHistoryUpsert {
	u.SetExcluded(userloginhistory.FieldCity)
	return u
}

// SetIsp sets the "isp" field.
func (u *UserLoginHistoryUpsert) SetIsp(v string) *UserLoginHistoryUpsert {
	u.Set(userloginhistory.FieldIsp, v)
	return u
}

// UpdateIsp sets the "isp" field to the value that was provided on create.
func (u *UserLoginHistoryUpsert) UpdateIsp() *UserLoginHistoryUpsert {
	u.SetExcluded(userloginhistory.FieldIsp)
	return u
}

// ClearIsp clears the value of the "isp" field.
func (u *UserLoginHistoryUpsert) ClearIsp() *UserLoginHistoryUpsert {
	u.SetNull(userloginhistory.FieldIsp)
	return u
}

// SetAsn sets the "asn" field.
func (u *UserLoginHistoryUpsert) SetAsn(v string) *UserLoginHistoryUpsert {
	u.Set(userloginhistory.FieldAsn, v)
	return u
}

// UpdateAsn sets the "asn" field to the value that was provided on create.
func (u *UserLoginHistoryUpsert) UpdateAsn() *UserLoginHistoryUpsert {
	u.SetExcluded(userloginhistory.FieldAsn)
	return u
}

// ClearAsn clears the value of the "asn" field.
func (u *UserLoginHistoryUpsert) ClearAsn() *UserLoginHistoryUpsert {
	u.SetNull(userloginhistory.FieldAsn)
	return u
}

// SetClientVersion sets the "client_version" field.
func (u *UserLoginHistoryUpsert) SetClientVersion(v string) *UserLoginHistoryUpsert {
	u.Set(userloginhistory.FieldClientVersion, v)
	return u
}

// UpdateClientVersion sets the "client_version" field to the value that was provided on create.
func (u *UserLoginHistoryUpsert) UpdateClientVersion() *UserLoginHistoryUpsert {
	u.SetExcluded(userloginhistory.FieldClientVersion)
	return u
}

// ClearClientVersion clears the value of the "client_version" field.
func (u *UserLoginHistoryUpsert) ClearClientVersion() *UserLoginHistoryUpsert {
	u.SetNull(userloginhistory.FieldClientVersion)
	return u
}

// SetOsType sets the "os_type" field.
func (u *UserLoginHistoryUpsert) SetOsType(v consts.OSType) *UserLoginHistoryUpsert {
	u.Set(userloginhistory.FieldOsType, v)
	return u
}

// UpdateOsType sets the "os_type" field to the value that was provided on create.
func (u *UserLoginHistoryUpsert) UpdateOsType() *UserLoginHistoryUpsert {
	u.SetExcluded(userloginhistory.FieldOsType)
	return u
}

// ClearOsType clears the value of the "os_type" field.
func (u *UserLoginHistoryUpsert) ClearOsType() *UserLoginHistoryUpsert {
	u.SetNull(userloginhistory.FieldOsType)
	return u
}

// SetOsRelease sets the "os_release" field.
func (u *UserLoginHistoryUpsert) SetOsRelease(v consts.OSRelease) *UserLoginHistoryUpsert {
	u.Set(userloginhistory.FieldOsRelease, v)
	return u
}

// UpdateOsRelease sets the "os_release" field to the value that was provided on create.
func (u *UserLoginHistoryUpsert) UpdateOsRelease() *UserLoginHistoryUpsert {
	u.SetExcluded(userloginhistory.FieldOsRelease)
	return u
}

// ClearOsRelease clears the value of the "os_release" field.
func (u *UserLoginHistoryUpsert) ClearOsRelease() *UserLoginHistoryUpsert {
	u.SetNull(userloginhistory.FieldOsRelease)
	return u
}

// SetHostname sets the "hostname" field.
func (u *UserLoginHistoryUpsert) SetHostname(v string) *UserLoginHistoryUpsert {
	u.Set(userloginhistory.FieldHostname, v)
	return u
}

// UpdateHostname sets the "hostname" field to the value that was provided on create.
func (u *UserLoginHistoryUpsert) UpdateHostname() *UserLoginHistoryUpsert {
	u.SetExcluded(userloginhistory.FieldHostname)
	return u
}

// ClearHostname clears the value of the "hostname" field.
func (u *UserLoginHistoryUpsert) ClearHostname() *UserLoginHistoryUpsert {
	u.SetNull(userloginhistory.FieldHostname)
	return u
}

// SetClientID sets the "client_id" field.
func (u *UserLoginHistoryUpsert) SetClientID(v string) *UserLoginHistoryUpsert {
	u.Set(userloginhistory.FieldClientID, v)
	return u
}

// UpdateClientID sets the "client_id" field to the value that was provided on create.
func (u *UserLoginHistoryUpsert) UpdateClientID() *UserLoginHistoryUpsert {
	u.SetExcluded(userloginhistory.FieldClientID)
	return u
}

// ClearClientID clears the value of the "client_id" field.
func (u *UserLoginHistoryUpsert) ClearClientID() *UserLoginHistoryUpsert {
	u.SetNull(userloginhistory.FieldClientID)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *UserLoginHistoryUpsert) SetCreatedAt(v time.Time) *UserLoginHistoryUpsert {
	u.Set(userloginhistory.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *UserLoginHistoryUpsert) UpdateCreatedAt() *UserLoginHistoryUpsert {
	u.SetExcluded(userloginhistory.FieldCreatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.UserLoginHistory.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(userloginhistory.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *UserLoginHistoryUpsertOne) UpdateNewValues() *UserLoginHistoryUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(userloginhistory.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.UserLoginHistory.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *UserLoginHistoryUpsertOne) Ignore() *UserLoginHistoryUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *UserLoginHistoryUpsertOne) DoNothing() *UserLoginHistoryUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the UserLoginHistoryCreate.OnConflict
// documentation for more info.
func (u *UserLoginHistoryUpsertOne) Update(set func(*UserLoginHistoryUpsert)) *UserLoginHistoryUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&UserLoginHistoryUpsert{UpdateSet: update})
	}))
	return u
}

// SetUserID sets the "user_id" field.
func (u *UserLoginHistoryUpsertOne) SetUserID(v uuid.UUID) *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertOne) UpdateUserID() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateUserID()
	})
}

// ClearUserID clears the value of the "user_id" field.
func (u *UserLoginHistoryUpsertOne) ClearUserID() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearUserID()
	})
}

// SetIP sets the "ip" field.
func (u *UserLoginHistoryUpsertOne) SetIP(v string) *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetIP(v)
	})
}

// UpdateIP sets the "ip" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertOne) UpdateIP() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateIP()
	})
}

// SetCountry sets the "country" field.
func (u *UserLoginHistoryUpsertOne) SetCountry(v string) *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetCountry(v)
	})
}

// UpdateCountry sets the "country" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertOne) UpdateCountry() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateCountry()
	})
}

// SetProvince sets the "province" field.
func (u *UserLoginHistoryUpsertOne) SetProvince(v string) *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetProvince(v)
	})
}

// UpdateProvince sets the "province" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertOne) UpdateProvince() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateProvince()
	})
}

// SetCity sets the "city" field.
func (u *UserLoginHistoryUpsertOne) SetCity(v string) *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetCity(v)
	})
}

// UpdateCity sets the "city" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertOne) UpdateCity() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateCity()
	})
}

// SetIsp sets the "isp" field.
func (u *UserLoginHistoryUpsertOne) SetIsp(v string) *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetIsp(v)
	})
}

// UpdateIsp sets the "isp" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertOne) UpdateIsp() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateIsp()
	})
}

// ClearIsp clears the value of the "isp" field.
func (u *UserLoginHistoryUpsertOne) ClearIsp() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearIsp()
	})
}

// SetAsn sets the "asn" field.
func (u *UserLoginHistoryUpsertOne) SetAsn(v string) *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetAsn(v)
	})
}

// UpdateAsn sets the "asn" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertOne) UpdateAsn() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateAsn()
	})
}

// ClearAsn clears the value of the "asn" field.
func (u *UserLoginHistoryUpsertOne) ClearAsn() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearAsn()
	})
}

// SetClientVersion sets the "client_version" field.
func (u *UserLoginHistoryUpsertOne) SetClientVersion(v string) *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetClientVersion(v)
	})
}

// UpdateClientVersion sets the "client_version" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertOne) UpdateClientVersion() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateClientVersion()
	})
}

// ClearClientVersion clears the value of the "client_version" field.
func (u *UserLoginHistoryUpsertOne) ClearClientVersion() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearClientVersion()
	})
}

// SetOsType sets the "os_type" field.
func (u *UserLoginHistoryUpsertOne) SetOsType(v consts.OSType) *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetOsType(v)
	})
}

// UpdateOsType sets the "os_type" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertOne) UpdateOsType() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateOsType()
	})
}

// ClearOsType clears the value of the "os_type" field.
func (u *UserLoginHistoryUpsertOne) ClearOsType() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearOsType()
	})
}

// SetOsRelease sets the "os_release" field.
func (u *UserLoginHistoryUpsertOne) SetOsRelease(v consts.OSRelease) *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetOsRelease(v)
	})
}

// UpdateOsRelease sets the "os_release" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertOne) UpdateOsRelease() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateOsRelease()
	})
}

// ClearOsRelease clears the value of the "os_release" field.
func (u *UserLoginHistoryUpsertOne) ClearOsRelease() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearOsRelease()
	})
}

// SetHostname sets the "hostname" field.
func (u *UserLoginHistoryUpsertOne) SetHostname(v string) *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetHostname(v)
	})
}

// UpdateHostname sets the "hostname" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertOne) UpdateHostname() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateHostname()
	})
}

// ClearHostname clears the value of the "hostname" field.
func (u *UserLoginHistoryUpsertOne) ClearHostname() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearHostname()
	})
}

// SetClientID sets the "client_id" field.
func (u *UserLoginHistoryUpsertOne) SetClientID(v string) *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetClientID(v)
	})
}

// UpdateClientID sets the "client_id" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertOne) UpdateClientID() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateClientID()
	})
}

// ClearClientID clears the value of the "client_id" field.
func (u *UserLoginHistoryUpsertOne) ClearClientID() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearClientID()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *UserLoginHistoryUpsertOne) SetCreatedAt(v time.Time) *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertOne) UpdateCreatedAt() *UserLoginHistoryUpsertOne {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateCreatedAt()
	})
}

// Exec executes the query.
func (u *UserLoginHistoryUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for UserLoginHistoryCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *UserLoginHistoryUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *UserLoginHistoryUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: UserLoginHistoryUpsertOne.ID is not supported by MySQL driver. Use UserLoginHistoryUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *UserLoginHistoryUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// UserLoginHistoryCreateBulk is the builder for creating many UserLoginHistory entities in bulk.
type UserLoginHistoryCreateBulk struct {
	config
	err      error
	builders []*UserLoginHistoryCreate
	conflict []sql.ConflictOption
}

// Save creates the UserLoginHistory entities in the database.
func (ulhcb *UserLoginHistoryCreateBulk) Save(ctx context.Context) ([]*UserLoginHistory, error) {
	if ulhcb.err != nil {
		return nil, ulhcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(ulhcb.builders))
	nodes := make([]*UserLoginHistory, len(ulhcb.builders))
	mutators := make([]Mutator, len(ulhcb.builders))
	for i := range ulhcb.builders {
		func(i int, root context.Context) {
			builder := ulhcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*UserLoginHistoryMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, ulhcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = ulhcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, ulhcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, ulhcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (ulhcb *UserLoginHistoryCreateBulk) SaveX(ctx context.Context) []*UserLoginHistory {
	v, err := ulhcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (ulhcb *UserLoginHistoryCreateBulk) Exec(ctx context.Context) error {
	_, err := ulhcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ulhcb *UserLoginHistoryCreateBulk) ExecX(ctx context.Context) {
	if err := ulhcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.UserLoginHistory.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.UserLoginHistoryUpsert) {
//			SetUserID(v+v).
//		}).
//		Exec(ctx)
func (ulhcb *UserLoginHistoryCreateBulk) OnConflict(opts ...sql.ConflictOption) *UserLoginHistoryUpsertBulk {
	ulhcb.conflict = opts
	return &UserLoginHistoryUpsertBulk{
		create: ulhcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.UserLoginHistory.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (ulhcb *UserLoginHistoryCreateBulk) OnConflictColumns(columns ...string) *UserLoginHistoryUpsertBulk {
	ulhcb.conflict = append(ulhcb.conflict, sql.ConflictColumns(columns...))
	return &UserLoginHistoryUpsertBulk{
		create: ulhcb,
	}
}

// UserLoginHistoryUpsertBulk is the builder for "upsert"-ing
// a bulk of UserLoginHistory nodes.
type UserLoginHistoryUpsertBulk struct {
	create *UserLoginHistoryCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.UserLoginHistory.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(userloginhistory.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *UserLoginHistoryUpsertBulk) UpdateNewValues() *UserLoginHistoryUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(userloginhistory.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.UserLoginHistory.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *UserLoginHistoryUpsertBulk) Ignore() *UserLoginHistoryUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *UserLoginHistoryUpsertBulk) DoNothing() *UserLoginHistoryUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the UserLoginHistoryCreateBulk.OnConflict
// documentation for more info.
func (u *UserLoginHistoryUpsertBulk) Update(set func(*UserLoginHistoryUpsert)) *UserLoginHistoryUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&UserLoginHistoryUpsert{UpdateSet: update})
	}))
	return u
}

// SetUserID sets the "user_id" field.
func (u *UserLoginHistoryUpsertBulk) SetUserID(v uuid.UUID) *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertBulk) UpdateUserID() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateUserID()
	})
}

// ClearUserID clears the value of the "user_id" field.
func (u *UserLoginHistoryUpsertBulk) ClearUserID() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearUserID()
	})
}

// SetIP sets the "ip" field.
func (u *UserLoginHistoryUpsertBulk) SetIP(v string) *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetIP(v)
	})
}

// UpdateIP sets the "ip" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertBulk) UpdateIP() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateIP()
	})
}

// SetCountry sets the "country" field.
func (u *UserLoginHistoryUpsertBulk) SetCountry(v string) *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetCountry(v)
	})
}

// UpdateCountry sets the "country" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertBulk) UpdateCountry() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateCountry()
	})
}

// SetProvince sets the "province" field.
func (u *UserLoginHistoryUpsertBulk) SetProvince(v string) *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetProvince(v)
	})
}

// UpdateProvince sets the "province" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertBulk) UpdateProvince() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateProvince()
	})
}

// SetCity sets the "city" field.
func (u *UserLoginHistoryUpsertBulk) SetCity(v string) *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetCity(v)
	})
}

// UpdateCity sets the "city" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertBulk) UpdateCity() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateCity()
	})
}

// SetIsp sets the "isp" field.
func (u *UserLoginHistoryUpsertBulk) SetIsp(v string) *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetIsp(v)
	})
}

// UpdateIsp sets the "isp" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertBulk) UpdateIsp() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateIsp()
	})
}

// ClearIsp clears the value of the "isp" field.
func (u *UserLoginHistoryUpsertBulk) ClearIsp() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearIsp()
	})
}

// SetAsn sets the "asn" field.
func (u *UserLoginHistoryUpsertBulk) SetAsn(v string) *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetAsn(v)
	})
}

// UpdateAsn sets the "asn" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertBulk) UpdateAsn() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateAsn()
	})
}

// ClearAsn clears the value of the "asn" field.
func (u *UserLoginHistoryUpsertBulk) ClearAsn() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearAsn()
	})
}

// SetClientVersion sets the "client_version" field.
func (u *UserLoginHistoryUpsertBulk) SetClientVersion(v string) *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetClientVersion(v)
	})
}

// UpdateClientVersion sets the "client_version" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertBulk) UpdateClientVersion() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateClientVersion()
	})
}

// ClearClientVersion clears the value of the "client_version" field.
func (u *UserLoginHistoryUpsertBulk) ClearClientVersion() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearClientVersion()
	})
}

// SetOsType sets the "os_type" field.
func (u *UserLoginHistoryUpsertBulk) SetOsType(v consts.OSType) *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetOsType(v)
	})
}

// UpdateOsType sets the "os_type" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertBulk) UpdateOsType() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateOsType()
	})
}

// ClearOsType clears the value of the "os_type" field.
func (u *UserLoginHistoryUpsertBulk) ClearOsType() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearOsType()
	})
}

// SetOsRelease sets the "os_release" field.
func (u *UserLoginHistoryUpsertBulk) SetOsRelease(v consts.OSRelease) *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetOsRelease(v)
	})
}

// UpdateOsRelease sets the "os_release" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertBulk) UpdateOsRelease() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateOsRelease()
	})
}

// ClearOsRelease clears the value of the "os_release" field.
func (u *UserLoginHistoryUpsertBulk) ClearOsRelease() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearOsRelease()
	})
}

// SetHostname sets the "hostname" field.
func (u *UserLoginHistoryUpsertBulk) SetHostname(v string) *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetHostname(v)
	})
}

// UpdateHostname sets the "hostname" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertBulk) UpdateHostname() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateHostname()
	})
}

// ClearHostname clears the value of the "hostname" field.
func (u *UserLoginHistoryUpsertBulk) ClearHostname() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearHostname()
	})
}

// SetClientID sets the "client_id" field.
func (u *UserLoginHistoryUpsertBulk) SetClientID(v string) *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetClientID(v)
	})
}

// UpdateClientID sets the "client_id" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertBulk) UpdateClientID() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateClientID()
	})
}

// ClearClientID clears the value of the "client_id" field.
func (u *UserLoginHistoryUpsertBulk) ClearClientID() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.ClearClientID()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *UserLoginHistoryUpsertBulk) SetCreatedAt(v time.Time) *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *UserLoginHistoryUpsertBulk) UpdateCreatedAt() *UserLoginHistoryUpsertBulk {
	return u.Update(func(s *UserLoginHistoryUpsert) {
		s.UpdateCreatedAt()
	})
}

// Exec executes the query.
func (u *UserLoginHistoryUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the UserLoginHistoryCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for UserLoginHistoryCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *UserLoginHistoryUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
