// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/useridentity"
)

// UserIdentityDelete is the builder for deleting a UserIdentity entity.
type UserIdentityDelete struct {
	config
	hooks    []Hook
	mutation *UserIdentityMutation
}

// Where appends a list predicates to the UserIdentityDelete builder.
func (uid *UserIdentityDelete) Where(ps ...predicate.UserIdentity) *UserIdentityDelete {
	uid.mutation.Where(ps...)
	return uid
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (uid *UserIdentityDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, uid.sqlExec, uid.mutation, uid.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (uid *UserIdentityDelete) ExecX(ctx context.Context) int {
	n, err := uid.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (uid *UserIdentityDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(useridentity.Table, sqlgraph.NewFieldSpec(useridentity.FieldID, field.TypeUUID))
	if ps := uid.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, uid.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	uid.mutation.done = true
	return affected, err
}

// UserIdentityDeleteOne is the builder for deleting a single UserIdentity entity.
type UserIdentityDeleteOne struct {
	uid *UserIdentityDelete
}

// Where appends a list predicates to the UserIdentityDelete builder.
func (uido *UserIdentityDeleteOne) Where(ps ...predicate.UserIdentity) *UserIdentityDeleteOne {
	uido.uid.mutation.Where(ps...)
	return uido
}

// Exec executes the deletion query.
func (uido *UserIdentityDeleteOne) Exec(ctx context.Context) error {
	n, err := uido.uid.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{useridentity.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (uido *UserIdentityDeleteOne) ExecX(ctx context.Context) {
	if err := uido.Exec(ctx); err != nil {
		panic(err)
	}
}
