// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/useridentity"
	"github.com/google/uuid"
)

// UserIdentityCreate is the builder for creating a UserIdentity entity.
type UserIdentityCreate struct {
	config
	mutation *UserIdentityMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetDeletedAt sets the "deleted_at" field.
func (uic *UserIdentityCreate) SetDeletedAt(t time.Time) *UserIdentityCreate {
	uic.mutation.SetDeletedAt(t)
	return uic
}

// SetNillableDeletedAt sets the "deleted_at" field if the given value is not nil.
func (uic *UserIdentityCreate) SetNillableDeletedAt(t *time.Time) *UserIdentityCreate {
	if t != nil {
		uic.SetDeletedAt(*t)
	}
	return uic
}

// SetUserID sets the "user_id" field.
func (uic *UserIdentityCreate) SetUserID(u uuid.UUID) *UserIdentityCreate {
	uic.mutation.SetUserID(u)
	return uic
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (uic *UserIdentityCreate) SetNillableUserID(u *uuid.UUID) *UserIdentityCreate {
	if u != nil {
		uic.SetUserID(*u)
	}
	return uic
}

// SetPlatform sets the "platform" field.
func (uic *UserIdentityCreate) SetPlatform(cp consts.UserPlatform) *UserIdentityCreate {
	uic.mutation.SetPlatform(cp)
	return uic
}

// SetNillablePlatform sets the "platform" field if the given value is not nil.
func (uic *UserIdentityCreate) SetNillablePlatform(cp *consts.UserPlatform) *UserIdentityCreate {
	if cp != nil {
		uic.SetPlatform(*cp)
	}
	return uic
}

// SetIdentityID sets the "identity_id" field.
func (uic *UserIdentityCreate) SetIdentityID(s string) *UserIdentityCreate {
	uic.mutation.SetIdentityID(s)
	return uic
}

// SetUnionID sets the "union_id" field.
func (uic *UserIdentityCreate) SetUnionID(s string) *UserIdentityCreate {
	uic.mutation.SetUnionID(s)
	return uic
}

// SetNillableUnionID sets the "union_id" field if the given value is not nil.
func (uic *UserIdentityCreate) SetNillableUnionID(s *string) *UserIdentityCreate {
	if s != nil {
		uic.SetUnionID(*s)
	}
	return uic
}

// SetNickname sets the "nickname" field.
func (uic *UserIdentityCreate) SetNickname(s string) *UserIdentityCreate {
	uic.mutation.SetNickname(s)
	return uic
}

// SetNillableNickname sets the "nickname" field if the given value is not nil.
func (uic *UserIdentityCreate) SetNillableNickname(s *string) *UserIdentityCreate {
	if s != nil {
		uic.SetNickname(*s)
	}
	return uic
}

// SetEmail sets the "email" field.
func (uic *UserIdentityCreate) SetEmail(s string) *UserIdentityCreate {
	uic.mutation.SetEmail(s)
	return uic
}

// SetNillableEmail sets the "email" field if the given value is not nil.
func (uic *UserIdentityCreate) SetNillableEmail(s *string) *UserIdentityCreate {
	if s != nil {
		uic.SetEmail(*s)
	}
	return uic
}

// SetAvatarURL sets the "avatar_url" field.
func (uic *UserIdentityCreate) SetAvatarURL(s string) *UserIdentityCreate {
	uic.mutation.SetAvatarURL(s)
	return uic
}

// SetNillableAvatarURL sets the "avatar_url" field if the given value is not nil.
func (uic *UserIdentityCreate) SetNillableAvatarURL(s *string) *UserIdentityCreate {
	if s != nil {
		uic.SetAvatarURL(*s)
	}
	return uic
}

// SetCreatedAt sets the "created_at" field.
func (uic *UserIdentityCreate) SetCreatedAt(t time.Time) *UserIdentityCreate {
	uic.mutation.SetCreatedAt(t)
	return uic
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (uic *UserIdentityCreate) SetNillableCreatedAt(t *time.Time) *UserIdentityCreate {
	if t != nil {
		uic.SetCreatedAt(*t)
	}
	return uic
}

// SetID sets the "id" field.
func (uic *UserIdentityCreate) SetID(u uuid.UUID) *UserIdentityCreate {
	uic.mutation.SetID(u)
	return uic
}

// SetUser sets the "user" edge to the User entity.
func (uic *UserIdentityCreate) SetUser(u *User) *UserIdentityCreate {
	return uic.SetUserID(u.ID)
}

// Mutation returns the UserIdentityMutation object of the builder.
func (uic *UserIdentityCreate) Mutation() *UserIdentityMutation {
	return uic.mutation
}

// Save creates the UserIdentity in the database.
func (uic *UserIdentityCreate) Save(ctx context.Context) (*UserIdentity, error) {
	if err := uic.defaults(); err != nil {
		return nil, err
	}
	return withHooks(ctx, uic.sqlSave, uic.mutation, uic.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (uic *UserIdentityCreate) SaveX(ctx context.Context) *UserIdentity {
	v, err := uic.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (uic *UserIdentityCreate) Exec(ctx context.Context) error {
	_, err := uic.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uic *UserIdentityCreate) ExecX(ctx context.Context) {
	if err := uic.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (uic *UserIdentityCreate) defaults() error {
	if _, ok := uic.mutation.Platform(); !ok {
		v := useridentity.DefaultPlatform
		uic.mutation.SetPlatform(v)
	}
	if _, ok := uic.mutation.CreatedAt(); !ok {
		if useridentity.DefaultCreatedAt == nil {
			return fmt.Errorf("db: uninitialized useridentity.DefaultCreatedAt (forgotten import db/runtime?)")
		}
		v := useridentity.DefaultCreatedAt()
		uic.mutation.SetCreatedAt(v)
	}
	return nil
}

// check runs all checks and user-defined validators on the builder.
func (uic *UserIdentityCreate) check() error {
	if _, ok := uic.mutation.Platform(); !ok {
		return &ValidationError{Name: "platform", err: errors.New(`db: missing required field "UserIdentity.platform"`)}
	}
	if _, ok := uic.mutation.IdentityID(); !ok {
		return &ValidationError{Name: "identity_id", err: errors.New(`db: missing required field "UserIdentity.identity_id"`)}
	}
	if _, ok := uic.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "UserIdentity.created_at"`)}
	}
	return nil
}

func (uic *UserIdentityCreate) sqlSave(ctx context.Context) (*UserIdentity, error) {
	if err := uic.check(); err != nil {
		return nil, err
	}
	_node, _spec := uic.createSpec()
	if err := sqlgraph.CreateNode(ctx, uic.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	uic.mutation.id = &_node.ID
	uic.mutation.done = true
	return _node, nil
}

func (uic *UserIdentityCreate) createSpec() (*UserIdentity, *sqlgraph.CreateSpec) {
	var (
		_node = &UserIdentity{config: uic.config}
		_spec = sqlgraph.NewCreateSpec(useridentity.Table, sqlgraph.NewFieldSpec(useridentity.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = uic.conflict
	if id, ok := uic.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := uic.mutation.DeletedAt(); ok {
		_spec.SetField(useridentity.FieldDeletedAt, field.TypeTime, value)
		_node.DeletedAt = value
	}
	if value, ok := uic.mutation.Platform(); ok {
		_spec.SetField(useridentity.FieldPlatform, field.TypeString, value)
		_node.Platform = value
	}
	if value, ok := uic.mutation.IdentityID(); ok {
		_spec.SetField(useridentity.FieldIdentityID, field.TypeString, value)
		_node.IdentityID = value
	}
	if value, ok := uic.mutation.UnionID(); ok {
		_spec.SetField(useridentity.FieldUnionID, field.TypeString, value)
		_node.UnionID = value
	}
	if value, ok := uic.mutation.Nickname(); ok {
		_spec.SetField(useridentity.FieldNickname, field.TypeString, value)
		_node.Nickname = value
	}
	if value, ok := uic.mutation.Email(); ok {
		_spec.SetField(useridentity.FieldEmail, field.TypeString, value)
		_node.Email = value
	}
	if value, ok := uic.mutation.AvatarURL(); ok {
		_spec.SetField(useridentity.FieldAvatarURL, field.TypeString, value)
		_node.AvatarURL = value
	}
	if value, ok := uic.mutation.CreatedAt(); ok {
		_spec.SetField(useridentity.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if nodes := uic.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   useridentity.UserTable,
			Columns: []string{useridentity.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.UserID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.UserIdentity.Create().
//		SetDeletedAt(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.UserIdentityUpsert) {
//			SetDeletedAt(v+v).
//		}).
//		Exec(ctx)
func (uic *UserIdentityCreate) OnConflict(opts ...sql.ConflictOption) *UserIdentityUpsertOne {
	uic.conflict = opts
	return &UserIdentityUpsertOne{
		create: uic,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.UserIdentity.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (uic *UserIdentityCreate) OnConflictColumns(columns ...string) *UserIdentityUpsertOne {
	uic.conflict = append(uic.conflict, sql.ConflictColumns(columns...))
	return &UserIdentityUpsertOne{
		create: uic,
	}
}

type (
	// UserIdentityUpsertOne is the builder for "upsert"-ing
	//  one UserIdentity node.
	UserIdentityUpsertOne struct {
		create *UserIdentityCreate
	}

	// UserIdentityUpsert is the "OnConflict" setter.
	UserIdentityUpsert struct {
		*sql.UpdateSet
	}
)

// SetDeletedAt sets the "deleted_at" field.
func (u *UserIdentityUpsert) SetDeletedAt(v time.Time) *UserIdentityUpsert {
	u.Set(useridentity.FieldDeletedAt, v)
	return u
}

// UpdateDeletedAt sets the "deleted_at" field to the value that was provided on create.
func (u *UserIdentityUpsert) UpdateDeletedAt() *UserIdentityUpsert {
	u.SetExcluded(useridentity.FieldDeletedAt)
	return u
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (u *UserIdentityUpsert) ClearDeletedAt() *UserIdentityUpsert {
	u.SetNull(useridentity.FieldDeletedAt)
	return u
}

// SetUserID sets the "user_id" field.
func (u *UserIdentityUpsert) SetUserID(v uuid.UUID) *UserIdentityUpsert {
	u.Set(useridentity.FieldUserID, v)
	return u
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *UserIdentityUpsert) UpdateUserID() *UserIdentityUpsert {
	u.SetExcluded(useridentity.FieldUserID)
	return u
}

// ClearUserID clears the value of the "user_id" field.
func (u *UserIdentityUpsert) ClearUserID() *UserIdentityUpsert {
	u.SetNull(useridentity.FieldUserID)
	return u
}

// SetPlatform sets the "platform" field.
func (u *UserIdentityUpsert) SetPlatform(v consts.UserPlatform) *UserIdentityUpsert {
	u.Set(useridentity.FieldPlatform, v)
	return u
}

// UpdatePlatform sets the "platform" field to the value that was provided on create.
func (u *UserIdentityUpsert) UpdatePlatform() *UserIdentityUpsert {
	u.SetExcluded(useridentity.FieldPlatform)
	return u
}

// SetIdentityID sets the "identity_id" field.
func (u *UserIdentityUpsert) SetIdentityID(v string) *UserIdentityUpsert {
	u.Set(useridentity.FieldIdentityID, v)
	return u
}

// UpdateIdentityID sets the "identity_id" field to the value that was provided on create.
func (u *UserIdentityUpsert) UpdateIdentityID() *UserIdentityUpsert {
	u.SetExcluded(useridentity.FieldIdentityID)
	return u
}

// SetUnionID sets the "union_id" field.
func (u *UserIdentityUpsert) SetUnionID(v string) *UserIdentityUpsert {
	u.Set(useridentity.FieldUnionID, v)
	return u
}

// UpdateUnionID sets the "union_id" field to the value that was provided on create.
func (u *UserIdentityUpsert) UpdateUnionID() *UserIdentityUpsert {
	u.SetExcluded(useridentity.FieldUnionID)
	return u
}

// ClearUnionID clears the value of the "union_id" field.
func (u *UserIdentityUpsert) ClearUnionID() *UserIdentityUpsert {
	u.SetNull(useridentity.FieldUnionID)
	return u
}

// SetNickname sets the "nickname" field.
func (u *UserIdentityUpsert) SetNickname(v string) *UserIdentityUpsert {
	u.Set(useridentity.FieldNickname, v)
	return u
}

// UpdateNickname sets the "nickname" field to the value that was provided on create.
func (u *UserIdentityUpsert) UpdateNickname() *UserIdentityUpsert {
	u.SetExcluded(useridentity.FieldNickname)
	return u
}

// ClearNickname clears the value of the "nickname" field.
func (u *UserIdentityUpsert) ClearNickname() *UserIdentityUpsert {
	u.SetNull(useridentity.FieldNickname)
	return u
}

// SetEmail sets the "email" field.
func (u *UserIdentityUpsert) SetEmail(v string) *UserIdentityUpsert {
	u.Set(useridentity.FieldEmail, v)
	return u
}

// UpdateEmail sets the "email" field to the value that was provided on create.
func (u *UserIdentityUpsert) UpdateEmail() *UserIdentityUpsert {
	u.SetExcluded(useridentity.FieldEmail)
	return u
}

// ClearEmail clears the value of the "email" field.
func (u *UserIdentityUpsert) ClearEmail() *UserIdentityUpsert {
	u.SetNull(useridentity.FieldEmail)
	return u
}

// SetAvatarURL sets the "avatar_url" field.
func (u *UserIdentityUpsert) SetAvatarURL(v string) *UserIdentityUpsert {
	u.Set(useridentity.FieldAvatarURL, v)
	return u
}

// UpdateAvatarURL sets the "avatar_url" field to the value that was provided on create.
func (u *UserIdentityUpsert) UpdateAvatarURL() *UserIdentityUpsert {
	u.SetExcluded(useridentity.FieldAvatarURL)
	return u
}

// ClearAvatarURL clears the value of the "avatar_url" field.
func (u *UserIdentityUpsert) ClearAvatarURL() *UserIdentityUpsert {
	u.SetNull(useridentity.FieldAvatarURL)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *UserIdentityUpsert) SetCreatedAt(v time.Time) *UserIdentityUpsert {
	u.Set(useridentity.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *UserIdentityUpsert) UpdateCreatedAt() *UserIdentityUpsert {
	u.SetExcluded(useridentity.FieldCreatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.UserIdentity.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(useridentity.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *UserIdentityUpsertOne) UpdateNewValues() *UserIdentityUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(useridentity.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.UserIdentity.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *UserIdentityUpsertOne) Ignore() *UserIdentityUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *UserIdentityUpsertOne) DoNothing() *UserIdentityUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the UserIdentityCreate.OnConflict
// documentation for more info.
func (u *UserIdentityUpsertOne) Update(set func(*UserIdentityUpsert)) *UserIdentityUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&UserIdentityUpsert{UpdateSet: update})
	}))
	return u
}

// SetDeletedAt sets the "deleted_at" field.
func (u *UserIdentityUpsertOne) SetDeletedAt(v time.Time) *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetDeletedAt(v)
	})
}

// UpdateDeletedAt sets the "deleted_at" field to the value that was provided on create.
func (u *UserIdentityUpsertOne) UpdateDeletedAt() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateDeletedAt()
	})
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (u *UserIdentityUpsertOne) ClearDeletedAt() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.ClearDeletedAt()
	})
}

// SetUserID sets the "user_id" field.
func (u *UserIdentityUpsertOne) SetUserID(v uuid.UUID) *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *UserIdentityUpsertOne) UpdateUserID() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateUserID()
	})
}

// ClearUserID clears the value of the "user_id" field.
func (u *UserIdentityUpsertOne) ClearUserID() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.ClearUserID()
	})
}

// SetPlatform sets the "platform" field.
func (u *UserIdentityUpsertOne) SetPlatform(v consts.UserPlatform) *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetPlatform(v)
	})
}

// UpdatePlatform sets the "platform" field to the value that was provided on create.
func (u *UserIdentityUpsertOne) UpdatePlatform() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdatePlatform()
	})
}

// SetIdentityID sets the "identity_id" field.
func (u *UserIdentityUpsertOne) SetIdentityID(v string) *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetIdentityID(v)
	})
}

// UpdateIdentityID sets the "identity_id" field to the value that was provided on create.
func (u *UserIdentityUpsertOne) UpdateIdentityID() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateIdentityID()
	})
}

// SetUnionID sets the "union_id" field.
func (u *UserIdentityUpsertOne) SetUnionID(v string) *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetUnionID(v)
	})
}

// UpdateUnionID sets the "union_id" field to the value that was provided on create.
func (u *UserIdentityUpsertOne) UpdateUnionID() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateUnionID()
	})
}

// ClearUnionID clears the value of the "union_id" field.
func (u *UserIdentityUpsertOne) ClearUnionID() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.ClearUnionID()
	})
}

// SetNickname sets the "nickname" field.
func (u *UserIdentityUpsertOne) SetNickname(v string) *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetNickname(v)
	})
}

// UpdateNickname sets the "nickname" field to the value that was provided on create.
func (u *UserIdentityUpsertOne) UpdateNickname() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateNickname()
	})
}

// ClearNickname clears the value of the "nickname" field.
func (u *UserIdentityUpsertOne) ClearNickname() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.ClearNickname()
	})
}

// SetEmail sets the "email" field.
func (u *UserIdentityUpsertOne) SetEmail(v string) *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetEmail(v)
	})
}

// UpdateEmail sets the "email" field to the value that was provided on create.
func (u *UserIdentityUpsertOne) UpdateEmail() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateEmail()
	})
}

// ClearEmail clears the value of the "email" field.
func (u *UserIdentityUpsertOne) ClearEmail() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.ClearEmail()
	})
}

// SetAvatarURL sets the "avatar_url" field.
func (u *UserIdentityUpsertOne) SetAvatarURL(v string) *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetAvatarURL(v)
	})
}

// UpdateAvatarURL sets the "avatar_url" field to the value that was provided on create.
func (u *UserIdentityUpsertOne) UpdateAvatarURL() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateAvatarURL()
	})
}

// ClearAvatarURL clears the value of the "avatar_url" field.
func (u *UserIdentityUpsertOne) ClearAvatarURL() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.ClearAvatarURL()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *UserIdentityUpsertOne) SetCreatedAt(v time.Time) *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *UserIdentityUpsertOne) UpdateCreatedAt() *UserIdentityUpsertOne {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateCreatedAt()
	})
}

// Exec executes the query.
func (u *UserIdentityUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for UserIdentityCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *UserIdentityUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *UserIdentityUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: UserIdentityUpsertOne.ID is not supported by MySQL driver. Use UserIdentityUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *UserIdentityUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// UserIdentityCreateBulk is the builder for creating many UserIdentity entities in bulk.
type UserIdentityCreateBulk struct {
	config
	err      error
	builders []*UserIdentityCreate
	conflict []sql.ConflictOption
}

// Save creates the UserIdentity entities in the database.
func (uicb *UserIdentityCreateBulk) Save(ctx context.Context) ([]*UserIdentity, error) {
	if uicb.err != nil {
		return nil, uicb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(uicb.builders))
	nodes := make([]*UserIdentity, len(uicb.builders))
	mutators := make([]Mutator, len(uicb.builders))
	for i := range uicb.builders {
		func(i int, root context.Context) {
			builder := uicb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*UserIdentityMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, uicb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = uicb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, uicb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, uicb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (uicb *UserIdentityCreateBulk) SaveX(ctx context.Context) []*UserIdentity {
	v, err := uicb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (uicb *UserIdentityCreateBulk) Exec(ctx context.Context) error {
	_, err := uicb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uicb *UserIdentityCreateBulk) ExecX(ctx context.Context) {
	if err := uicb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.UserIdentity.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.UserIdentityUpsert) {
//			SetDeletedAt(v+v).
//		}).
//		Exec(ctx)
func (uicb *UserIdentityCreateBulk) OnConflict(opts ...sql.ConflictOption) *UserIdentityUpsertBulk {
	uicb.conflict = opts
	return &UserIdentityUpsertBulk{
		create: uicb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.UserIdentity.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (uicb *UserIdentityCreateBulk) OnConflictColumns(columns ...string) *UserIdentityUpsertBulk {
	uicb.conflict = append(uicb.conflict, sql.ConflictColumns(columns...))
	return &UserIdentityUpsertBulk{
		create: uicb,
	}
}

// UserIdentityUpsertBulk is the builder for "upsert"-ing
// a bulk of UserIdentity nodes.
type UserIdentityUpsertBulk struct {
	create *UserIdentityCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.UserIdentity.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(useridentity.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *UserIdentityUpsertBulk) UpdateNewValues() *UserIdentityUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(useridentity.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.UserIdentity.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *UserIdentityUpsertBulk) Ignore() *UserIdentityUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *UserIdentityUpsertBulk) DoNothing() *UserIdentityUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the UserIdentityCreateBulk.OnConflict
// documentation for more info.
func (u *UserIdentityUpsertBulk) Update(set func(*UserIdentityUpsert)) *UserIdentityUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&UserIdentityUpsert{UpdateSet: update})
	}))
	return u
}

// SetDeletedAt sets the "deleted_at" field.
func (u *UserIdentityUpsertBulk) SetDeletedAt(v time.Time) *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetDeletedAt(v)
	})
}

// UpdateDeletedAt sets the "deleted_at" field to the value that was provided on create.
func (u *UserIdentityUpsertBulk) UpdateDeletedAt() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateDeletedAt()
	})
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (u *UserIdentityUpsertBulk) ClearDeletedAt() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.ClearDeletedAt()
	})
}

// SetUserID sets the "user_id" field.
func (u *UserIdentityUpsertBulk) SetUserID(v uuid.UUID) *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *UserIdentityUpsertBulk) UpdateUserID() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateUserID()
	})
}

// ClearUserID clears the value of the "user_id" field.
func (u *UserIdentityUpsertBulk) ClearUserID() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.ClearUserID()
	})
}

// SetPlatform sets the "platform" field.
func (u *UserIdentityUpsertBulk) SetPlatform(v consts.UserPlatform) *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetPlatform(v)
	})
}

// UpdatePlatform sets the "platform" field to the value that was provided on create.
func (u *UserIdentityUpsertBulk) UpdatePlatform() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdatePlatform()
	})
}

// SetIdentityID sets the "identity_id" field.
func (u *UserIdentityUpsertBulk) SetIdentityID(v string) *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetIdentityID(v)
	})
}

// UpdateIdentityID sets the "identity_id" field to the value that was provided on create.
func (u *UserIdentityUpsertBulk) UpdateIdentityID() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateIdentityID()
	})
}

// SetUnionID sets the "union_id" field.
func (u *UserIdentityUpsertBulk) SetUnionID(v string) *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetUnionID(v)
	})
}

// UpdateUnionID sets the "union_id" field to the value that was provided on create.
func (u *UserIdentityUpsertBulk) UpdateUnionID() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateUnionID()
	})
}

// ClearUnionID clears the value of the "union_id" field.
func (u *UserIdentityUpsertBulk) ClearUnionID() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.ClearUnionID()
	})
}

// SetNickname sets the "nickname" field.
func (u *UserIdentityUpsertBulk) SetNickname(v string) *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetNickname(v)
	})
}

// UpdateNickname sets the "nickname" field to the value that was provided on create.
func (u *UserIdentityUpsertBulk) UpdateNickname() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateNickname()
	})
}

// ClearNickname clears the value of the "nickname" field.
func (u *UserIdentityUpsertBulk) ClearNickname() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.ClearNickname()
	})
}

// SetEmail sets the "email" field.
func (u *UserIdentityUpsertBulk) SetEmail(v string) *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetEmail(v)
	})
}

// UpdateEmail sets the "email" field to the value that was provided on create.
func (u *UserIdentityUpsertBulk) UpdateEmail() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateEmail()
	})
}

// ClearEmail clears the value of the "email" field.
func (u *UserIdentityUpsertBulk) ClearEmail() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.ClearEmail()
	})
}

// SetAvatarURL sets the "avatar_url" field.
func (u *UserIdentityUpsertBulk) SetAvatarURL(v string) *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetAvatarURL(v)
	})
}

// UpdateAvatarURL sets the "avatar_url" field to the value that was provided on create.
func (u *UserIdentityUpsertBulk) UpdateAvatarURL() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateAvatarURL()
	})
}

// ClearAvatarURL clears the value of the "avatar_url" field.
func (u *UserIdentityUpsertBulk) ClearAvatarURL() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.ClearAvatarURL()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *UserIdentityUpsertBulk) SetCreatedAt(v time.Time) *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *UserIdentityUpsertBulk) UpdateCreatedAt() *UserIdentityUpsertBulk {
	return u.Update(func(s *UserIdentityUpsert) {
		s.UpdateCreatedAt()
	})
}

// Exec executes the query.
func (u *UserIdentityUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the UserIdentityCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for UserIdentityCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *UserIdentityUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
