// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/usergroup"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupuser"
	"github.com/google/uuid"
)

// UserGroupUserUpdate is the builder for updating UserGroupUser entities.
type UserGroupUserUpdate struct {
	config
	hooks     []Hook
	mutation  *UserGroupUserMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the UserGroupUserUpdate builder.
func (uguu *UserGroupUserUpdate) Where(ps ...predicate.UserGroupUser) *UserGroupUserUpdate {
	uguu.mutation.Where(ps...)
	return uguu
}

// SetUserGroupID sets the "user_group_id" field.
func (uguu *UserGroupUserUpdate) SetUserGroupID(u uuid.UUID) *UserGroupUserUpdate {
	uguu.mutation.SetUserGroupID(u)
	return uguu
}

// SetNillableUserGroupID sets the "user_group_id" field if the given value is not nil.
func (uguu *UserGroupUserUpdate) SetNillableUserGroupID(u *uuid.UUID) *UserGroupUserUpdate {
	if u != nil {
		uguu.SetUserGroupID(*u)
	}
	return uguu
}

// SetUserID sets the "user_id" field.
func (uguu *UserGroupUserUpdate) SetUserID(u uuid.UUID) *UserGroupUserUpdate {
	uguu.mutation.SetUserID(u)
	return uguu
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (uguu *UserGroupUserUpdate) SetNillableUserID(u *uuid.UUID) *UserGroupUserUpdate {
	if u != nil {
		uguu.SetUserID(*u)
	}
	return uguu
}

// SetUserGroup sets the "user_group" edge to the UserGroup entity.
func (uguu *UserGroupUserUpdate) SetUserGroup(u *UserGroup) *UserGroupUserUpdate {
	return uguu.SetUserGroupID(u.ID)
}

// SetUser sets the "user" edge to the User entity.
func (uguu *UserGroupUserUpdate) SetUser(u *User) *UserGroupUserUpdate {
	return uguu.SetUserID(u.ID)
}

// Mutation returns the UserGroupUserMutation object of the builder.
func (uguu *UserGroupUserUpdate) Mutation() *UserGroupUserMutation {
	return uguu.mutation
}

// ClearUserGroup clears the "user_group" edge to the UserGroup entity.
func (uguu *UserGroupUserUpdate) ClearUserGroup() *UserGroupUserUpdate {
	uguu.mutation.ClearUserGroup()
	return uguu
}

// ClearUser clears the "user" edge to the User entity.
func (uguu *UserGroupUserUpdate) ClearUser() *UserGroupUserUpdate {
	uguu.mutation.ClearUser()
	return uguu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (uguu *UserGroupUserUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, uguu.sqlSave, uguu.mutation, uguu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (uguu *UserGroupUserUpdate) SaveX(ctx context.Context) int {
	affected, err := uguu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (uguu *UserGroupUserUpdate) Exec(ctx context.Context) error {
	_, err := uguu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uguu *UserGroupUserUpdate) ExecX(ctx context.Context) {
	if err := uguu.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (uguu *UserGroupUserUpdate) check() error {
	if uguu.mutation.UserGroupCleared() && len(uguu.mutation.UserGroupIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "UserGroupUser.user_group"`)
	}
	if uguu.mutation.UserCleared() && len(uguu.mutation.UserIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "UserGroupUser.user"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (uguu *UserGroupUserUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *UserGroupUserUpdate {
	uguu.modifiers = append(uguu.modifiers, modifiers...)
	return uguu
}

func (uguu *UserGroupUserUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := uguu.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(usergroupuser.Table, usergroupuser.Columns, sqlgraph.NewFieldSpec(usergroupuser.FieldID, field.TypeUUID))
	if ps := uguu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if uguu.mutation.UserGroupCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupuser.UserGroupTable,
			Columns: []string{usergroupuser.UserGroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroup.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguu.mutation.UserGroupIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupuser.UserGroupTable,
			Columns: []string{usergroupuser.UserGroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroup.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if uguu.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupuser.UserTable,
			Columns: []string{usergroupuser.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguu.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupuser.UserTable,
			Columns: []string{usergroupuser.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(uguu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, uguu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{usergroupuser.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	uguu.mutation.done = true
	return n, nil
}

// UserGroupUserUpdateOne is the builder for updating a single UserGroupUser entity.
type UserGroupUserUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *UserGroupUserMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetUserGroupID sets the "user_group_id" field.
func (uguuo *UserGroupUserUpdateOne) SetUserGroupID(u uuid.UUID) *UserGroupUserUpdateOne {
	uguuo.mutation.SetUserGroupID(u)
	return uguuo
}

// SetNillableUserGroupID sets the "user_group_id" field if the given value is not nil.
func (uguuo *UserGroupUserUpdateOne) SetNillableUserGroupID(u *uuid.UUID) *UserGroupUserUpdateOne {
	if u != nil {
		uguuo.SetUserGroupID(*u)
	}
	return uguuo
}

// SetUserID sets the "user_id" field.
func (uguuo *UserGroupUserUpdateOne) SetUserID(u uuid.UUID) *UserGroupUserUpdateOne {
	uguuo.mutation.SetUserID(u)
	return uguuo
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (uguuo *UserGroupUserUpdateOne) SetNillableUserID(u *uuid.UUID) *UserGroupUserUpdateOne {
	if u != nil {
		uguuo.SetUserID(*u)
	}
	return uguuo
}

// SetUserGroup sets the "user_group" edge to the UserGroup entity.
func (uguuo *UserGroupUserUpdateOne) SetUserGroup(u *UserGroup) *UserGroupUserUpdateOne {
	return uguuo.SetUserGroupID(u.ID)
}

// SetUser sets the "user" edge to the User entity.
func (uguuo *UserGroupUserUpdateOne) SetUser(u *User) *UserGroupUserUpdateOne {
	return uguuo.SetUserID(u.ID)
}

// Mutation returns the UserGroupUserMutation object of the builder.
func (uguuo *UserGroupUserUpdateOne) Mutation() *UserGroupUserMutation {
	return uguuo.mutation
}

// ClearUserGroup clears the "user_group" edge to the UserGroup entity.
func (uguuo *UserGroupUserUpdateOne) ClearUserGroup() *UserGroupUserUpdateOne {
	uguuo.mutation.ClearUserGroup()
	return uguuo
}

// ClearUser clears the "user" edge to the User entity.
func (uguuo *UserGroupUserUpdateOne) ClearUser() *UserGroupUserUpdateOne {
	uguuo.mutation.ClearUser()
	return uguuo
}

// Where appends a list predicates to the UserGroupUserUpdate builder.
func (uguuo *UserGroupUserUpdateOne) Where(ps ...predicate.UserGroupUser) *UserGroupUserUpdateOne {
	uguuo.mutation.Where(ps...)
	return uguuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (uguuo *UserGroupUserUpdateOne) Select(field string, fields ...string) *UserGroupUserUpdateOne {
	uguuo.fields = append([]string{field}, fields...)
	return uguuo
}

// Save executes the query and returns the updated UserGroupUser entity.
func (uguuo *UserGroupUserUpdateOne) Save(ctx context.Context) (*UserGroupUser, error) {
	return withHooks(ctx, uguuo.sqlSave, uguuo.mutation, uguuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (uguuo *UserGroupUserUpdateOne) SaveX(ctx context.Context) *UserGroupUser {
	node, err := uguuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (uguuo *UserGroupUserUpdateOne) Exec(ctx context.Context) error {
	_, err := uguuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uguuo *UserGroupUserUpdateOne) ExecX(ctx context.Context) {
	if err := uguuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (uguuo *UserGroupUserUpdateOne) check() error {
	if uguuo.mutation.UserGroupCleared() && len(uguuo.mutation.UserGroupIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "UserGroupUser.user_group"`)
	}
	if uguuo.mutation.UserCleared() && len(uguuo.mutation.UserIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "UserGroupUser.user"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (uguuo *UserGroupUserUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *UserGroupUserUpdateOne {
	uguuo.modifiers = append(uguuo.modifiers, modifiers...)
	return uguuo
}

func (uguuo *UserGroupUserUpdateOne) sqlSave(ctx context.Context) (_node *UserGroupUser, err error) {
	if err := uguuo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(usergroupuser.Table, usergroupuser.Columns, sqlgraph.NewFieldSpec(usergroupuser.FieldID, field.TypeUUID))
	id, ok := uguuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "UserGroupUser.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := uguuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, usergroupuser.FieldID)
		for _, f := range fields {
			if !usergroupuser.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != usergroupuser.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := uguuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if uguuo.mutation.UserGroupCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupuser.UserGroupTable,
			Columns: []string{usergroupuser.UserGroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroup.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguuo.mutation.UserGroupIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupuser.UserGroupTable,
			Columns: []string{usergroupuser.UserGroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroup.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if uguuo.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupuser.UserTable,
			Columns: []string{usergroupuser.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguuo.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupuser.UserTable,
			Columns: []string{usergroupuser.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(uguuo.modifiers...)
	_node = &UserGroupUser{config: uguuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, uguuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{usergroupuser.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	uguuo.mutation.done = true
	return _node, nil
}
