// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/usergroup"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupuser"
	"github.com/google/uuid"
)

// UserGroupUser is the model entity for the UserGroupUser schema.
type UserGroupUser struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// UserGroupID holds the value of the "user_group_id" field.
	UserGroupID uuid.UUID `json:"user_group_id,omitempty"`
	// UserID holds the value of the "user_id" field.
	UserID uuid.UUID `json:"user_id,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the UserGroupUserQuery when eager-loading is set.
	Edges        UserGroupUserEdges `json:"edges"`
	selectValues sql.SelectValues
}

// UserGroupUserEdges holds the relations/edges for other nodes in the graph.
type UserGroupUserEdges struct {
	// UserGroup holds the value of the user_group edge.
	UserGroup *UserGroup `json:"user_group,omitempty"`
	// User holds the value of the user edge.
	User *User `json:"user,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [2]bool
}

// UserGroupOrErr returns the UserGroup value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e UserGroupUserEdges) UserGroupOrErr() (*UserGroup, error) {
	if e.UserGroup != nil {
		return e.UserGroup, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: usergroup.Label}
	}
	return nil, &NotLoadedError{edge: "user_group"}
}

// UserOrErr returns the User value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e UserGroupUserEdges) UserOrErr() (*User, error) {
	if e.User != nil {
		return e.User, nil
	} else if e.loadedTypes[1] {
		return nil, &NotFoundError{label: user.Label}
	}
	return nil, &NotLoadedError{edge: "user"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*UserGroupUser) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case usergroupuser.FieldID, usergroupuser.FieldUserGroupID, usergroupuser.FieldUserID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the UserGroupUser fields.
func (ugu *UserGroupUser) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case usergroupuser.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				ugu.ID = *value
			}
		case usergroupuser.FieldUserGroupID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field user_group_id", values[i])
			} else if value != nil {
				ugu.UserGroupID = *value
			}
		case usergroupuser.FieldUserID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field user_id", values[i])
			} else if value != nil {
				ugu.UserID = *value
			}
		default:
			ugu.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the UserGroupUser.
// This includes values selected through modifiers, order, etc.
func (ugu *UserGroupUser) Value(name string) (ent.Value, error) {
	return ugu.selectValues.Get(name)
}

// QueryUserGroup queries the "user_group" edge of the UserGroupUser entity.
func (ugu *UserGroupUser) QueryUserGroup() *UserGroupQuery {
	return NewUserGroupUserClient(ugu.config).QueryUserGroup(ugu)
}

// QueryUser queries the "user" edge of the UserGroupUser entity.
func (ugu *UserGroupUser) QueryUser() *UserQuery {
	return NewUserGroupUserClient(ugu.config).QueryUser(ugu)
}

// Update returns a builder for updating this UserGroupUser.
// Note that you need to call UserGroupUser.Unwrap() before calling this method if this UserGroupUser
// was returned from a transaction, and the transaction was committed or rolled back.
func (ugu *UserGroupUser) Update() *UserGroupUserUpdateOne {
	return NewUserGroupUserClient(ugu.config).UpdateOne(ugu)
}

// Unwrap unwraps the UserGroupUser entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (ugu *UserGroupUser) Unwrap() *UserGroupUser {
	_tx, ok := ugu.config.driver.(*txDriver)
	if !ok {
		panic("db: UserGroupUser is not a transactional entity")
	}
	ugu.config.driver = _tx.drv
	return ugu
}

// String implements the fmt.Stringer.
func (ugu *UserGroupUser) String() string {
	var builder strings.Builder
	builder.WriteString("UserGroupUser(")
	builder.WriteString(fmt.Sprintf("id=%v, ", ugu.ID))
	builder.WriteString("user_group_id=")
	builder.WriteString(fmt.Sprintf("%v", ugu.UserGroupID))
	builder.WriteString(", ")
	builder.WriteString("user_id=")
	builder.WriteString(fmt.Sprintf("%v", ugu.UserID))
	builder.WriteByte(')')
	return builder.String()
}

// UserGroupUsers is a parsable slice of UserGroupUser.
type UserGroupUsers []*UserGroupUser
