// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/usergroup"
	"github.com/google/uuid"
)

// UserGroup is the model entity for the UserGroup schema.
type UserGroup struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// AdminID holds the value of the "admin_id" field.
	AdminID uuid.UUID `json:"admin_id,omitempty"`
	// Name holds the value of the "name" field.
	Name string `json:"name,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the UserGroupQuery when eager-loading is set.
	Edges        UserGroupEdges `json:"edges"`
	selectValues sql.SelectValues
}

// UserGroupEdges holds the relations/edges for other nodes in the graph.
type UserGroupEdges struct {
	// Owner holds the value of the owner edge.
	Owner *Admin `json:"owner,omitempty"`
	// Users holds the value of the users edge.
	Users []*User `json:"users,omitempty"`
	// Admins holds the value of the admins edge.
	Admins []*Admin `json:"admins,omitempty"`
	// UserGroups holds the value of the user_groups edge.
	UserGroups []*UserGroupUser `json:"user_groups,omitempty"`
	// UserGroupAdmins holds the value of the user_group_admins edge.
	UserGroupAdmins []*UserGroupAdmin `json:"user_group_admins,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [5]bool
}

// OwnerOrErr returns the Owner value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e UserGroupEdges) OwnerOrErr() (*Admin, error) {
	if e.Owner != nil {
		return e.Owner, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: admin.Label}
	}
	return nil, &NotLoadedError{edge: "owner"}
}

// UsersOrErr returns the Users value or an error if the edge
// was not loaded in eager-loading.
func (e UserGroupEdges) UsersOrErr() ([]*User, error) {
	if e.loadedTypes[1] {
		return e.Users, nil
	}
	return nil, &NotLoadedError{edge: "users"}
}

// AdminsOrErr returns the Admins value or an error if the edge
// was not loaded in eager-loading.
func (e UserGroupEdges) AdminsOrErr() ([]*Admin, error) {
	if e.loadedTypes[2] {
		return e.Admins, nil
	}
	return nil, &NotLoadedError{edge: "admins"}
}

// UserGroupsOrErr returns the UserGroups value or an error if the edge
// was not loaded in eager-loading.
func (e UserGroupEdges) UserGroupsOrErr() ([]*UserGroupUser, error) {
	if e.loadedTypes[3] {
		return e.UserGroups, nil
	}
	return nil, &NotLoadedError{edge: "user_groups"}
}

// UserGroupAdminsOrErr returns the UserGroupAdmins value or an error if the edge
// was not loaded in eager-loading.
func (e UserGroupEdges) UserGroupAdminsOrErr() ([]*UserGroupAdmin, error) {
	if e.loadedTypes[4] {
		return e.UserGroupAdmins, nil
	}
	return nil, &NotLoadedError{edge: "user_group_admins"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*UserGroup) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case usergroup.FieldName:
			values[i] = new(sql.NullString)
		case usergroup.FieldCreatedAt:
			values[i] = new(sql.NullTime)
		case usergroup.FieldID, usergroup.FieldAdminID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the UserGroup fields.
func (ug *UserGroup) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case usergroup.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				ug.ID = *value
			}
		case usergroup.FieldAdminID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field admin_id", values[i])
			} else if value != nil {
				ug.AdminID = *value
			}
		case usergroup.FieldName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field name", values[i])
			} else if value.Valid {
				ug.Name = value.String
			}
		case usergroup.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				ug.CreatedAt = value.Time
			}
		default:
			ug.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the UserGroup.
// This includes values selected through modifiers, order, etc.
func (ug *UserGroup) Value(name string) (ent.Value, error) {
	return ug.selectValues.Get(name)
}

// QueryOwner queries the "owner" edge of the UserGroup entity.
func (ug *UserGroup) QueryOwner() *AdminQuery {
	return NewUserGroupClient(ug.config).QueryOwner(ug)
}

// QueryUsers queries the "users" edge of the UserGroup entity.
func (ug *UserGroup) QueryUsers() *UserQuery {
	return NewUserGroupClient(ug.config).QueryUsers(ug)
}

// QueryAdmins queries the "admins" edge of the UserGroup entity.
func (ug *UserGroup) QueryAdmins() *AdminQuery {
	return NewUserGroupClient(ug.config).QueryAdmins(ug)
}

// QueryUserGroups queries the "user_groups" edge of the UserGroup entity.
func (ug *UserGroup) QueryUserGroups() *UserGroupUserQuery {
	return NewUserGroupClient(ug.config).QueryUserGroups(ug)
}

// QueryUserGroupAdmins queries the "user_group_admins" edge of the UserGroup entity.
func (ug *UserGroup) QueryUserGroupAdmins() *UserGroupAdminQuery {
	return NewUserGroupClient(ug.config).QueryUserGroupAdmins(ug)
}

// Update returns a builder for updating this UserGroup.
// Note that you need to call UserGroup.Unwrap() before calling this method if this UserGroup
// was returned from a transaction, and the transaction was committed or rolled back.
func (ug *UserGroup) Update() *UserGroupUpdateOne {
	return NewUserGroupClient(ug.config).UpdateOne(ug)
}

// Unwrap unwraps the UserGroup entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (ug *UserGroup) Unwrap() *UserGroup {
	_tx, ok := ug.config.driver.(*txDriver)
	if !ok {
		panic("db: UserGroup is not a transactional entity")
	}
	ug.config.driver = _tx.drv
	return ug
}

// String implements the fmt.Stringer.
func (ug *UserGroup) String() string {
	var builder strings.Builder
	builder.WriteString("UserGroup(")
	builder.WriteString(fmt.Sprintf("id=%v, ", ug.ID))
	builder.WriteString("admin_id=")
	builder.WriteString(fmt.Sprintf("%v", ug.AdminID))
	builder.WriteString(", ")
	builder.WriteString("name=")
	builder.WriteString(ug.Name)
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(ug.CreatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// UserGroups is a parsable slice of UserGroup.
type UserGroups []*UserGroup
