// Code generated by ent, DO NOT EDIT.

package user

import (
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"github.com/chaitin/MonkeyCode/backend/consts"
)

const (
	// Label holds the string label denoting the user type in the database.
	Label = "user"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldDeletedAt holds the string denoting the deleted_at field in the database.
	FieldDeletedAt = "deleted_at"
	// FieldUsername holds the string denoting the username field in the database.
	FieldUsername = "username"
	// FieldPassword holds the string denoting the password field in the database.
	FieldPassword = "password"
	// FieldEmail holds the string denoting the email field in the database.
	FieldEmail = "email"
	// FieldAvatarURL holds the string denoting the avatar_url field in the database.
	FieldAvatarURL = "avatar_url"
	// FieldPlatform holds the string denoting the platform field in the database.
	FieldPlatform = "platform"
	// FieldStatus holds the string denoting the status field in the database.
	FieldStatus = "status"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// FieldUpdatedAt holds the string denoting the updated_at field in the database.
	FieldUpdatedAt = "updated_at"
	// EdgeLoginHistories holds the string denoting the login_histories edge name in mutations.
	EdgeLoginHistories = "login_histories"
	// EdgeModels holds the string denoting the models edge name in mutations.
	EdgeModels = "models"
	// EdgeTasks holds the string denoting the tasks edge name in mutations.
	EdgeTasks = "tasks"
	// EdgeIdentities holds the string denoting the identities edge name in mutations.
	EdgeIdentities = "identities"
	// EdgeWorkspaces holds the string denoting the workspaces edge name in mutations.
	EdgeWorkspaces = "workspaces"
	// EdgeWorkspaceFiles holds the string denoting the workspace_files edge name in mutations.
	EdgeWorkspaceFiles = "workspace_files"
	// EdgeAPIKeys holds the string denoting the api_keys edge name in mutations.
	EdgeAPIKeys = "api_keys"
	// EdgeSecurityScannings holds the string denoting the security_scannings edge name in mutations.
	EdgeSecurityScannings = "security_scannings"
	// EdgeAiemployees holds the string denoting the aiemployees edge name in mutations.
	EdgeAiemployees = "aiemployees"
	// EdgeGroups holds the string denoting the groups edge name in mutations.
	EdgeGroups = "groups"
	// EdgeUserGroups holds the string denoting the user_groups edge name in mutations.
	EdgeUserGroups = "user_groups"
	// Table holds the table name of the user in the database.
	Table = "users"
	// LoginHistoriesTable is the table that holds the login_histories relation/edge.
	LoginHistoriesTable = "user_login_histories"
	// LoginHistoriesInverseTable is the table name for the UserLoginHistory entity.
	// It exists in this package in order to avoid circular dependency with the "userloginhistory" package.
	LoginHistoriesInverseTable = "user_login_histories"
	// LoginHistoriesColumn is the table column denoting the login_histories relation/edge.
	LoginHistoriesColumn = "user_id"
	// ModelsTable is the table that holds the models relation/edge.
	ModelsTable = "models"
	// ModelsInverseTable is the table name for the Model entity.
	// It exists in this package in order to avoid circular dependency with the "model" package.
	ModelsInverseTable = "models"
	// ModelsColumn is the table column denoting the models relation/edge.
	ModelsColumn = "user_id"
	// TasksTable is the table that holds the tasks relation/edge.
	TasksTable = "tasks"
	// TasksInverseTable is the table name for the Task entity.
	// It exists in this package in order to avoid circular dependency with the "task" package.
	TasksInverseTable = "tasks"
	// TasksColumn is the table column denoting the tasks relation/edge.
	TasksColumn = "user_id"
	// IdentitiesTable is the table that holds the identities relation/edge.
	IdentitiesTable = "user_identities"
	// IdentitiesInverseTable is the table name for the UserIdentity entity.
	// It exists in this package in order to avoid circular dependency with the "useridentity" package.
	IdentitiesInverseTable = "user_identities"
	// IdentitiesColumn is the table column denoting the identities relation/edge.
	IdentitiesColumn = "user_id"
	// WorkspacesTable is the table that holds the workspaces relation/edge.
	WorkspacesTable = "workspaces"
	// WorkspacesInverseTable is the table name for the Workspace entity.
	// It exists in this package in order to avoid circular dependency with the "workspace" package.
	WorkspacesInverseTable = "workspaces"
	// WorkspacesColumn is the table column denoting the workspaces relation/edge.
	WorkspacesColumn = "user_id"
	// WorkspaceFilesTable is the table that holds the workspace_files relation/edge.
	WorkspaceFilesTable = "workspace_files"
	// WorkspaceFilesInverseTable is the table name for the WorkspaceFile entity.
	// It exists in this package in order to avoid circular dependency with the "workspacefile" package.
	WorkspaceFilesInverseTable = "workspace_files"
	// WorkspaceFilesColumn is the table column denoting the workspace_files relation/edge.
	WorkspaceFilesColumn = "user_id"
	// APIKeysTable is the table that holds the api_keys relation/edge.
	APIKeysTable = "api_keys"
	// APIKeysInverseTable is the table name for the ApiKey entity.
	// It exists in this package in order to avoid circular dependency with the "apikey" package.
	APIKeysInverseTable = "api_keys"
	// APIKeysColumn is the table column denoting the api_keys relation/edge.
	APIKeysColumn = "user_id"
	// SecurityScanningsTable is the table that holds the security_scannings relation/edge.
	SecurityScanningsTable = "security_scannings"
	// SecurityScanningsInverseTable is the table name for the SecurityScanning entity.
	// It exists in this package in order to avoid circular dependency with the "securityscanning" package.
	SecurityScanningsInverseTable = "security_scannings"
	// SecurityScanningsColumn is the table column denoting the security_scannings relation/edge.
	SecurityScanningsColumn = "user_id"
	// AiemployeesTable is the table that holds the aiemployees relation/edge.
	AiemployeesTable = "ai_employees"
	// AiemployeesInverseTable is the table name for the AIEmployee entity.
	// It exists in this package in order to avoid circular dependency with the "aiemployee" package.
	AiemployeesInverseTable = "ai_employees"
	// AiemployeesColumn is the table column denoting the aiemployees relation/edge.
	AiemployeesColumn = "user_id"
	// GroupsTable is the table that holds the groups relation/edge. The primary key declared below.
	GroupsTable = "user_group_users"
	// GroupsInverseTable is the table name for the UserGroup entity.
	// It exists in this package in order to avoid circular dependency with the "usergroup" package.
	GroupsInverseTable = "user_groups"
	// UserGroupsTable is the table that holds the user_groups relation/edge.
	UserGroupsTable = "user_group_users"
	// UserGroupsInverseTable is the table name for the UserGroupUser entity.
	// It exists in this package in order to avoid circular dependency with the "usergroupuser" package.
	UserGroupsInverseTable = "user_group_users"
	// UserGroupsColumn is the table column denoting the user_groups relation/edge.
	UserGroupsColumn = "user_id"
)

// Columns holds all SQL columns for user fields.
var Columns = []string{
	FieldID,
	FieldDeletedAt,
	FieldUsername,
	FieldPassword,
	FieldEmail,
	FieldAvatarURL,
	FieldPlatform,
	FieldStatus,
	FieldCreatedAt,
	FieldUpdatedAt,
}

var (
	// GroupsPrimaryKey and GroupsColumn2 are the table columns denoting the
	// primary key for the groups relation (M2M).
	GroupsPrimaryKey = []string{"user_group_id", "user_id"}
)

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

// Note that the variables below are initialized by the runtime
// package on the initialization of the application. Therefore,
// it should be imported in the main as follows:
//
//	import _ "github.com/chaitin/MonkeyCode/backend/db/runtime"
var (
	Hooks        [1]ent.Hook
	Interceptors [1]ent.Interceptor
	// DefaultPlatform holds the default value on creation for the "platform" field.
	DefaultPlatform consts.UserPlatform
	// DefaultStatus holds the default value on creation for the "status" field.
	DefaultStatus consts.UserStatus
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
	// DefaultUpdatedAt holds the default value on creation for the "updated_at" field.
	DefaultUpdatedAt func() time.Time
)

// OrderOption defines the ordering options for the User queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByDeletedAt orders the results by the deleted_at field.
func ByDeletedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldDeletedAt, opts...).ToFunc()
}

// ByUsername orders the results by the username field.
func ByUsername(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUsername, opts...).ToFunc()
}

// ByPassword orders the results by the password field.
func ByPassword(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldPassword, opts...).ToFunc()
}

// ByEmail orders the results by the email field.
func ByEmail(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldEmail, opts...).ToFunc()
}

// ByAvatarURL orders the results by the avatar_url field.
func ByAvatarURL(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAvatarURL, opts...).ToFunc()
}

// ByPlatform orders the results by the platform field.
func ByPlatform(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldPlatform, opts...).ToFunc()
}

// ByStatus orders the results by the status field.
func ByStatus(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldStatus, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByUpdatedAt orders the results by the updated_at field.
func ByUpdatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUpdatedAt, opts...).ToFunc()
}

// ByLoginHistoriesCount orders the results by login_histories count.
func ByLoginHistoriesCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newLoginHistoriesStep(), opts...)
	}
}

// ByLoginHistories orders the results by login_histories terms.
func ByLoginHistories(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newLoginHistoriesStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByModelsCount orders the results by models count.
func ByModelsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newModelsStep(), opts...)
	}
}

// ByModels orders the results by models terms.
func ByModels(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newModelsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByTasksCount orders the results by tasks count.
func ByTasksCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newTasksStep(), opts...)
	}
}

// ByTasks orders the results by tasks terms.
func ByTasks(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newTasksStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByIdentitiesCount orders the results by identities count.
func ByIdentitiesCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newIdentitiesStep(), opts...)
	}
}

// ByIdentities orders the results by identities terms.
func ByIdentities(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newIdentitiesStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByWorkspacesCount orders the results by workspaces count.
func ByWorkspacesCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newWorkspacesStep(), opts...)
	}
}

// ByWorkspaces orders the results by workspaces terms.
func ByWorkspaces(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newWorkspacesStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByWorkspaceFilesCount orders the results by workspace_files count.
func ByWorkspaceFilesCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newWorkspaceFilesStep(), opts...)
	}
}

// ByWorkspaceFiles orders the results by workspace_files terms.
func ByWorkspaceFiles(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newWorkspaceFilesStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByAPIKeysCount orders the results by api_keys count.
func ByAPIKeysCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newAPIKeysStep(), opts...)
	}
}

// ByAPIKeys orders the results by api_keys terms.
func ByAPIKeys(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newAPIKeysStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// BySecurityScanningsCount orders the results by security_scannings count.
func BySecurityScanningsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newSecurityScanningsStep(), opts...)
	}
}

// BySecurityScannings orders the results by security_scannings terms.
func BySecurityScannings(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newSecurityScanningsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByAiemployeesCount orders the results by aiemployees count.
func ByAiemployeesCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newAiemployeesStep(), opts...)
	}
}

// ByAiemployees orders the results by aiemployees terms.
func ByAiemployees(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newAiemployeesStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByGroupsCount orders the results by groups count.
func ByGroupsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newGroupsStep(), opts...)
	}
}

// ByGroups orders the results by groups terms.
func ByGroups(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newGroupsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByUserGroupsCount orders the results by user_groups count.
func ByUserGroupsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newUserGroupsStep(), opts...)
	}
}

// ByUserGroups orders the results by user_groups terms.
func ByUserGroups(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newUserGroupsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}
func newLoginHistoriesStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(LoginHistoriesInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, LoginHistoriesTable, LoginHistoriesColumn),
	)
}
func newModelsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(ModelsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, ModelsTable, ModelsColumn),
	)
}
func newTasksStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(TasksInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, TasksTable, TasksColumn),
	)
}
func newIdentitiesStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(IdentitiesInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, IdentitiesTable, IdentitiesColumn),
	)
}
func newWorkspacesStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(WorkspacesInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, WorkspacesTable, WorkspacesColumn),
	)
}
func newWorkspaceFilesStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(WorkspaceFilesInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, WorkspaceFilesTable, WorkspaceFilesColumn),
	)
}
func newAPIKeysStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(APIKeysInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, APIKeysTable, APIKeysColumn),
	)
}
func newSecurityScanningsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(SecurityScanningsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, SecurityScanningsTable, SecurityScanningsColumn),
	)
}
func newAiemployeesStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(AiemployeesInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, AiemployeesTable, AiemployeesColumn),
	)
}
func newGroupsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(GroupsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2M, true, GroupsTable, GroupsPrimaryKey...),
	)
}
func newUserGroupsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(UserGroupsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, true, UserGroupsTable, UserGroupsColumn),
	)
}
