// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/taskrecord"
)

// TaskRecordDelete is the builder for deleting a TaskRecord entity.
type TaskRecordDelete struct {
	config
	hooks    []Hook
	mutation *TaskRecordMutation
}

// Where appends a list predicates to the TaskRecordDelete builder.
func (trd *TaskRecordDelete) Where(ps ...predicate.TaskRecord) *TaskRecordDelete {
	trd.mutation.Where(ps...)
	return trd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (trd *TaskRecordDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, trd.sqlExec, trd.mutation, trd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (trd *TaskRecordDelete) ExecX(ctx context.Context) int {
	n, err := trd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (trd *TaskRecordDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(taskrecord.Table, sqlgraph.NewFieldSpec(taskrecord.FieldID, field.TypeUUID))
	if ps := trd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, trd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	trd.mutation.done = true
	return affected, err
}

// TaskRecordDeleteOne is the builder for deleting a single TaskRecord entity.
type TaskRecordDeleteOne struct {
	trd *TaskRecordDelete
}

// Where appends a list predicates to the TaskRecordDelete builder.
func (trdo *TaskRecordDeleteOne) Where(ps ...predicate.TaskRecord) *TaskRecordDeleteOne {
	trdo.trd.mutation.Where(ps...)
	return trdo
}

// Exec executes the deletion query.
func (trdo *TaskRecordDeleteOne) Exec(ctx context.Context) error {
	n, err := trdo.trd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{taskrecord.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (trdo *TaskRecordDeleteOne) ExecX(ctx context.Context) {
	if err := trdo.Exec(ctx); err != nil {
		panic(err)
	}
}
