// Code generated by ent, DO NOT EDIT.

package taskrecord

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the taskrecord type in the database.
	Label = "task_record"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldTaskID holds the string denoting the task_id field in the database.
	FieldTaskID = "task_id"
	// FieldPrompt holds the string denoting the prompt field in the database.
	FieldPrompt = "prompt"
	// FieldRole holds the string denoting the role field in the database.
	FieldRole = "role"
	// FieldCompletion holds the string denoting the completion field in the database.
	FieldCompletion = "completion"
	// FieldOutputTokens holds the string denoting the output_tokens field in the database.
	FieldOutputTokens = "output_tokens"
	// FieldCodeLines holds the string denoting the code_lines field in the database.
	FieldCodeLines = "code_lines"
	// FieldCode holds the string denoting the code field in the database.
	FieldCode = "code"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// FieldUpdatedAt holds the string denoting the updated_at field in the database.
	FieldUpdatedAt = "updated_at"
	// EdgeTask holds the string denoting the task edge name in mutations.
	EdgeTask = "task"
	// Table holds the table name of the taskrecord in the database.
	Table = "task_records"
	// TaskTable is the table that holds the task relation/edge.
	TaskTable = "task_records"
	// TaskInverseTable is the table name for the Task entity.
	// It exists in this package in order to avoid circular dependency with the "task" package.
	TaskInverseTable = "tasks"
	// TaskColumn is the table column denoting the task relation/edge.
	TaskColumn = "task_id"
)

// Columns holds all SQL columns for taskrecord fields.
var Columns = []string{
	FieldID,
	FieldTaskID,
	FieldPrompt,
	FieldRole,
	FieldCompletion,
	FieldOutputTokens,
	FieldCodeLines,
	FieldCode,
	FieldCreatedAt,
	FieldUpdatedAt,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultOutputTokens holds the default value on creation for the "output_tokens" field.
	DefaultOutputTokens int64
	// DefaultCodeLines holds the default value on creation for the "code_lines" field.
	DefaultCodeLines int64
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
	// DefaultUpdatedAt holds the default value on creation for the "updated_at" field.
	DefaultUpdatedAt func() time.Time
	// UpdateDefaultUpdatedAt holds the default value on update for the "updated_at" field.
	UpdateDefaultUpdatedAt func() time.Time
)

// OrderOption defines the ordering options for the TaskRecord queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByTaskID orders the results by the task_id field.
func ByTaskID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldTaskID, opts...).ToFunc()
}

// ByPrompt orders the results by the prompt field.
func ByPrompt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldPrompt, opts...).ToFunc()
}

// ByRole orders the results by the role field.
func ByRole(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldRole, opts...).ToFunc()
}

// ByCompletion orders the results by the completion field.
func ByCompletion(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCompletion, opts...).ToFunc()
}

// ByOutputTokens orders the results by the output_tokens field.
func ByOutputTokens(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOutputTokens, opts...).ToFunc()
}

// ByCodeLines orders the results by the code_lines field.
func ByCodeLines(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCodeLines, opts...).ToFunc()
}

// ByCode orders the results by the code field.
func ByCode(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCode, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByUpdatedAt orders the results by the updated_at field.
func ByUpdatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUpdatedAt, opts...).ToFunc()
}

// ByTaskField orders the results by task field.
func ByTaskField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newTaskStep(), sql.OrderByField(field, opts...))
	}
}
func newTaskStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(TaskInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, TaskTable, TaskColumn),
	)
}
