// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/task"
	"github.com/chaitin/MonkeyCode/backend/db/taskrecord"
	"github.com/google/uuid"
)

// TaskRecord is the model entity for the TaskRecord schema.
type TaskRecord struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// TaskID holds the value of the "task_id" field.
	TaskID uuid.UUID `json:"task_id,omitempty"`
	// Prompt holds the value of the "prompt" field.
	Prompt string `json:"prompt,omitempty"`
	// Role holds the value of the "role" field.
	Role consts.ChatRole `json:"role,omitempty"`
	// Completion holds the value of the "completion" field.
	Completion string `json:"completion,omitempty"`
	// OutputTokens holds the value of the "output_tokens" field.
	OutputTokens int64 `json:"output_tokens,omitempty"`
	// CodeLines holds the value of the "code_lines" field.
	CodeLines int64 `json:"code_lines,omitempty"`
	// Code holds the value of the "code" field.
	Code string `json:"code,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the TaskRecordQuery when eager-loading is set.
	Edges        TaskRecordEdges `json:"edges"`
	selectValues sql.SelectValues
}

// TaskRecordEdges holds the relations/edges for other nodes in the graph.
type TaskRecordEdges struct {
	// Task holds the value of the task edge.
	Task *Task `json:"task,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [1]bool
}

// TaskOrErr returns the Task value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e TaskRecordEdges) TaskOrErr() (*Task, error) {
	if e.Task != nil {
		return e.Task, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: task.Label}
	}
	return nil, &NotLoadedError{edge: "task"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*TaskRecord) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case taskrecord.FieldOutputTokens, taskrecord.FieldCodeLines:
			values[i] = new(sql.NullInt64)
		case taskrecord.FieldPrompt, taskrecord.FieldRole, taskrecord.FieldCompletion, taskrecord.FieldCode:
			values[i] = new(sql.NullString)
		case taskrecord.FieldCreatedAt, taskrecord.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		case taskrecord.FieldID, taskrecord.FieldTaskID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the TaskRecord fields.
func (tr *TaskRecord) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case taskrecord.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				tr.ID = *value
			}
		case taskrecord.FieldTaskID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field task_id", values[i])
			} else if value != nil {
				tr.TaskID = *value
			}
		case taskrecord.FieldPrompt:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field prompt", values[i])
			} else if value.Valid {
				tr.Prompt = value.String
			}
		case taskrecord.FieldRole:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field role", values[i])
			} else if value.Valid {
				tr.Role = consts.ChatRole(value.String)
			}
		case taskrecord.FieldCompletion:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field completion", values[i])
			} else if value.Valid {
				tr.Completion = value.String
			}
		case taskrecord.FieldOutputTokens:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field output_tokens", values[i])
			} else if value.Valid {
				tr.OutputTokens = value.Int64
			}
		case taskrecord.FieldCodeLines:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field code_lines", values[i])
			} else if value.Valid {
				tr.CodeLines = value.Int64
			}
		case taskrecord.FieldCode:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field code", values[i])
			} else if value.Valid {
				tr.Code = value.String
			}
		case taskrecord.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				tr.CreatedAt = value.Time
			}
		case taskrecord.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				tr.UpdatedAt = value.Time
			}
		default:
			tr.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the TaskRecord.
// This includes values selected through modifiers, order, etc.
func (tr *TaskRecord) Value(name string) (ent.Value, error) {
	return tr.selectValues.Get(name)
}

// QueryTask queries the "task" edge of the TaskRecord entity.
func (tr *TaskRecord) QueryTask() *TaskQuery {
	return NewTaskRecordClient(tr.config).QueryTask(tr)
}

// Update returns a builder for updating this TaskRecord.
// Note that you need to call TaskRecord.Unwrap() before calling this method if this TaskRecord
// was returned from a transaction, and the transaction was committed or rolled back.
func (tr *TaskRecord) Update() *TaskRecordUpdateOne {
	return NewTaskRecordClient(tr.config).UpdateOne(tr)
}

// Unwrap unwraps the TaskRecord entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (tr *TaskRecord) Unwrap() *TaskRecord {
	_tx, ok := tr.config.driver.(*txDriver)
	if !ok {
		panic("db: TaskRecord is not a transactional entity")
	}
	tr.config.driver = _tx.drv
	return tr
}

// String implements the fmt.Stringer.
func (tr *TaskRecord) String() string {
	var builder strings.Builder
	builder.WriteString("TaskRecord(")
	builder.WriteString(fmt.Sprintf("id=%v, ", tr.ID))
	builder.WriteString("task_id=")
	builder.WriteString(fmt.Sprintf("%v", tr.TaskID))
	builder.WriteString(", ")
	builder.WriteString("prompt=")
	builder.WriteString(tr.Prompt)
	builder.WriteString(", ")
	builder.WriteString("role=")
	builder.WriteString(fmt.Sprintf("%v", tr.Role))
	builder.WriteString(", ")
	builder.WriteString("completion=")
	builder.WriteString(tr.Completion)
	builder.WriteString(", ")
	builder.WriteString("output_tokens=")
	builder.WriteString(fmt.Sprintf("%v", tr.OutputTokens))
	builder.WriteString(", ")
	builder.WriteString("code_lines=")
	builder.WriteString(fmt.Sprintf("%v", tr.CodeLines))
	builder.WriteString(", ")
	builder.WriteString("code=")
	builder.WriteString(tr.Code)
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(tr.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(tr.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// TaskRecords is a parsable slice of TaskRecord.
type TaskRecords []*TaskRecord
