// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/model"
	"github.com/chaitin/MonkeyCode/backend/db/task"
	"github.com/chaitin/MonkeyCode/backend/db/taskrecord"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/google/uuid"
)

// TaskCreate is the builder for creating a Task entity.
type TaskCreate struct {
	config
	mutation *TaskMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetTaskID sets the "task_id" field.
func (tc *TaskCreate) SetTaskID(s string) *TaskCreate {
	tc.mutation.SetTaskID(s)
	return tc
}

// SetUserID sets the "user_id" field.
func (tc *TaskCreate) SetUserID(u uuid.UUID) *TaskCreate {
	tc.mutation.SetUserID(u)
	return tc
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (tc *TaskCreate) SetNillableUserID(u *uuid.UUID) *TaskCreate {
	if u != nil {
		tc.SetUserID(*u)
	}
	return tc
}

// SetModelID sets the "model_id" field.
func (tc *TaskCreate) SetModelID(u uuid.UUID) *TaskCreate {
	tc.mutation.SetModelID(u)
	return tc
}

// SetNillableModelID sets the "model_id" field if the given value is not nil.
func (tc *TaskCreate) SetNillableModelID(u *uuid.UUID) *TaskCreate {
	if u != nil {
		tc.SetModelID(*u)
	}
	return tc
}

// SetRequestID sets the "request_id" field.
func (tc *TaskCreate) SetRequestID(s string) *TaskCreate {
	tc.mutation.SetRequestID(s)
	return tc
}

// SetNillableRequestID sets the "request_id" field if the given value is not nil.
func (tc *TaskCreate) SetNillableRequestID(s *string) *TaskCreate {
	if s != nil {
		tc.SetRequestID(*s)
	}
	return tc
}

// SetModelType sets the "model_type" field.
func (tc *TaskCreate) SetModelType(ct consts.ModelType) *TaskCreate {
	tc.mutation.SetModelType(ct)
	return tc
}

// SetIsAccept sets the "is_accept" field.
func (tc *TaskCreate) SetIsAccept(b bool) *TaskCreate {
	tc.mutation.SetIsAccept(b)
	return tc
}

// SetNillableIsAccept sets the "is_accept" field if the given value is not nil.
func (tc *TaskCreate) SetNillableIsAccept(b *bool) *TaskCreate {
	if b != nil {
		tc.SetIsAccept(*b)
	}
	return tc
}

// SetProgramLanguage sets the "program_language" field.
func (tc *TaskCreate) SetProgramLanguage(s string) *TaskCreate {
	tc.mutation.SetProgramLanguage(s)
	return tc
}

// SetNillableProgramLanguage sets the "program_language" field if the given value is not nil.
func (tc *TaskCreate) SetNillableProgramLanguage(s *string) *TaskCreate {
	if s != nil {
		tc.SetProgramLanguage(*s)
	}
	return tc
}

// SetWorkMode sets the "work_mode" field.
func (tc *TaskCreate) SetWorkMode(s string) *TaskCreate {
	tc.mutation.SetWorkMode(s)
	return tc
}

// SetNillableWorkMode sets the "work_mode" field if the given value is not nil.
func (tc *TaskCreate) SetNillableWorkMode(s *string) *TaskCreate {
	if s != nil {
		tc.SetWorkMode(*s)
	}
	return tc
}

// SetPrompt sets the "prompt" field.
func (tc *TaskCreate) SetPrompt(s string) *TaskCreate {
	tc.mutation.SetPrompt(s)
	return tc
}

// SetNillablePrompt sets the "prompt" field if the given value is not nil.
func (tc *TaskCreate) SetNillablePrompt(s *string) *TaskCreate {
	if s != nil {
		tc.SetPrompt(*s)
	}
	return tc
}

// SetCompletion sets the "completion" field.
func (tc *TaskCreate) SetCompletion(s string) *TaskCreate {
	tc.mutation.SetCompletion(s)
	return tc
}

// SetNillableCompletion sets the "completion" field if the given value is not nil.
func (tc *TaskCreate) SetNillableCompletion(s *string) *TaskCreate {
	if s != nil {
		tc.SetCompletion(*s)
	}
	return tc
}

// SetCodeLines sets the "code_lines" field.
func (tc *TaskCreate) SetCodeLines(i int64) *TaskCreate {
	tc.mutation.SetCodeLines(i)
	return tc
}

// SetNillableCodeLines sets the "code_lines" field if the given value is not nil.
func (tc *TaskCreate) SetNillableCodeLines(i *int64) *TaskCreate {
	if i != nil {
		tc.SetCodeLines(*i)
	}
	return tc
}

// SetInputTokens sets the "input_tokens" field.
func (tc *TaskCreate) SetInputTokens(i int64) *TaskCreate {
	tc.mutation.SetInputTokens(i)
	return tc
}

// SetNillableInputTokens sets the "input_tokens" field if the given value is not nil.
func (tc *TaskCreate) SetNillableInputTokens(i *int64) *TaskCreate {
	if i != nil {
		tc.SetInputTokens(*i)
	}
	return tc
}

// SetOutputTokens sets the "output_tokens" field.
func (tc *TaskCreate) SetOutputTokens(i int64) *TaskCreate {
	tc.mutation.SetOutputTokens(i)
	return tc
}

// SetNillableOutputTokens sets the "output_tokens" field if the given value is not nil.
func (tc *TaskCreate) SetNillableOutputTokens(i *int64) *TaskCreate {
	if i != nil {
		tc.SetOutputTokens(*i)
	}
	return tc
}

// SetIsSuggested sets the "is_suggested" field.
func (tc *TaskCreate) SetIsSuggested(b bool) *TaskCreate {
	tc.mutation.SetIsSuggested(b)
	return tc
}

// SetNillableIsSuggested sets the "is_suggested" field if the given value is not nil.
func (tc *TaskCreate) SetNillableIsSuggested(b *bool) *TaskCreate {
	if b != nil {
		tc.SetIsSuggested(*b)
	}
	return tc
}

// SetSourceCode sets the "source_code" field.
func (tc *TaskCreate) SetSourceCode(s string) *TaskCreate {
	tc.mutation.SetSourceCode(s)
	return tc
}

// SetNillableSourceCode sets the "source_code" field if the given value is not nil.
func (tc *TaskCreate) SetNillableSourceCode(s *string) *TaskCreate {
	if s != nil {
		tc.SetSourceCode(*s)
	}
	return tc
}

// SetCursorPosition sets the "cursor_position" field.
func (tc *TaskCreate) SetCursorPosition(m map[string]interface{}) *TaskCreate {
	tc.mutation.SetCursorPosition(m)
	return tc
}

// SetUserInput sets the "user_input" field.
func (tc *TaskCreate) SetUserInput(s string) *TaskCreate {
	tc.mutation.SetUserInput(s)
	return tc
}

// SetNillableUserInput sets the "user_input" field if the given value is not nil.
func (tc *TaskCreate) SetNillableUserInput(s *string) *TaskCreate {
	if s != nil {
		tc.SetUserInput(*s)
	}
	return tc
}

// SetCreatedAt sets the "created_at" field.
func (tc *TaskCreate) SetCreatedAt(t time.Time) *TaskCreate {
	tc.mutation.SetCreatedAt(t)
	return tc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (tc *TaskCreate) SetNillableCreatedAt(t *time.Time) *TaskCreate {
	if t != nil {
		tc.SetCreatedAt(*t)
	}
	return tc
}

// SetUpdatedAt sets the "updated_at" field.
func (tc *TaskCreate) SetUpdatedAt(t time.Time) *TaskCreate {
	tc.mutation.SetUpdatedAt(t)
	return tc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (tc *TaskCreate) SetNillableUpdatedAt(t *time.Time) *TaskCreate {
	if t != nil {
		tc.SetUpdatedAt(*t)
	}
	return tc
}

// SetID sets the "id" field.
func (tc *TaskCreate) SetID(u uuid.UUID) *TaskCreate {
	tc.mutation.SetID(u)
	return tc
}

// AddTaskRecordIDs adds the "task_records" edge to the TaskRecord entity by IDs.
func (tc *TaskCreate) AddTaskRecordIDs(ids ...uuid.UUID) *TaskCreate {
	tc.mutation.AddTaskRecordIDs(ids...)
	return tc
}

// AddTaskRecords adds the "task_records" edges to the TaskRecord entity.
func (tc *TaskCreate) AddTaskRecords(t ...*TaskRecord) *TaskCreate {
	ids := make([]uuid.UUID, len(t))
	for i := range t {
		ids[i] = t[i].ID
	}
	return tc.AddTaskRecordIDs(ids...)
}

// SetUser sets the "user" edge to the User entity.
func (tc *TaskCreate) SetUser(u *User) *TaskCreate {
	return tc.SetUserID(u.ID)
}

// SetModel sets the "model" edge to the Model entity.
func (tc *TaskCreate) SetModel(m *Model) *TaskCreate {
	return tc.SetModelID(m.ID)
}

// Mutation returns the TaskMutation object of the builder.
func (tc *TaskCreate) Mutation() *TaskMutation {
	return tc.mutation
}

// Save creates the Task in the database.
func (tc *TaskCreate) Save(ctx context.Context) (*Task, error) {
	tc.defaults()
	return withHooks(ctx, tc.sqlSave, tc.mutation, tc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (tc *TaskCreate) SaveX(ctx context.Context) *Task {
	v, err := tc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (tc *TaskCreate) Exec(ctx context.Context) error {
	_, err := tc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (tc *TaskCreate) ExecX(ctx context.Context) {
	if err := tc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (tc *TaskCreate) defaults() {
	if _, ok := tc.mutation.IsAccept(); !ok {
		v := task.DefaultIsAccept
		tc.mutation.SetIsAccept(v)
	}
	if _, ok := tc.mutation.IsSuggested(); !ok {
		v := task.DefaultIsSuggested
		tc.mutation.SetIsSuggested(v)
	}
	if _, ok := tc.mutation.CreatedAt(); !ok {
		v := task.DefaultCreatedAt()
		tc.mutation.SetCreatedAt(v)
	}
	if _, ok := tc.mutation.UpdatedAt(); !ok {
		v := task.DefaultUpdatedAt()
		tc.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (tc *TaskCreate) check() error {
	if _, ok := tc.mutation.TaskID(); !ok {
		return &ValidationError{Name: "task_id", err: errors.New(`db: missing required field "Task.task_id"`)}
	}
	if _, ok := tc.mutation.ModelType(); !ok {
		return &ValidationError{Name: "model_type", err: errors.New(`db: missing required field "Task.model_type"`)}
	}
	if _, ok := tc.mutation.IsAccept(); !ok {
		return &ValidationError{Name: "is_accept", err: errors.New(`db: missing required field "Task.is_accept"`)}
	}
	if _, ok := tc.mutation.IsSuggested(); !ok {
		return &ValidationError{Name: "is_suggested", err: errors.New(`db: missing required field "Task.is_suggested"`)}
	}
	if _, ok := tc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "Task.created_at"`)}
	}
	if _, ok := tc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "Task.updated_at"`)}
	}
	return nil
}

func (tc *TaskCreate) sqlSave(ctx context.Context) (*Task, error) {
	if err := tc.check(); err != nil {
		return nil, err
	}
	_node, _spec := tc.createSpec()
	if err := sqlgraph.CreateNode(ctx, tc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	tc.mutation.id = &_node.ID
	tc.mutation.done = true
	return _node, nil
}

func (tc *TaskCreate) createSpec() (*Task, *sqlgraph.CreateSpec) {
	var (
		_node = &Task{config: tc.config}
		_spec = sqlgraph.NewCreateSpec(task.Table, sqlgraph.NewFieldSpec(task.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = tc.conflict
	if id, ok := tc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := tc.mutation.TaskID(); ok {
		_spec.SetField(task.FieldTaskID, field.TypeString, value)
		_node.TaskID = value
	}
	if value, ok := tc.mutation.RequestID(); ok {
		_spec.SetField(task.FieldRequestID, field.TypeString, value)
		_node.RequestID = value
	}
	if value, ok := tc.mutation.ModelType(); ok {
		_spec.SetField(task.FieldModelType, field.TypeString, value)
		_node.ModelType = value
	}
	if value, ok := tc.mutation.IsAccept(); ok {
		_spec.SetField(task.FieldIsAccept, field.TypeBool, value)
		_node.IsAccept = value
	}
	if value, ok := tc.mutation.ProgramLanguage(); ok {
		_spec.SetField(task.FieldProgramLanguage, field.TypeString, value)
		_node.ProgramLanguage = value
	}
	if value, ok := tc.mutation.WorkMode(); ok {
		_spec.SetField(task.FieldWorkMode, field.TypeString, value)
		_node.WorkMode = value
	}
	if value, ok := tc.mutation.Prompt(); ok {
		_spec.SetField(task.FieldPrompt, field.TypeString, value)
		_node.Prompt = value
	}
	if value, ok := tc.mutation.Completion(); ok {
		_spec.SetField(task.FieldCompletion, field.TypeString, value)
		_node.Completion = value
	}
	if value, ok := tc.mutation.CodeLines(); ok {
		_spec.SetField(task.FieldCodeLines, field.TypeInt64, value)
		_node.CodeLines = value
	}
	if value, ok := tc.mutation.InputTokens(); ok {
		_spec.SetField(task.FieldInputTokens, field.TypeInt64, value)
		_node.InputTokens = value
	}
	if value, ok := tc.mutation.OutputTokens(); ok {
		_spec.SetField(task.FieldOutputTokens, field.TypeInt64, value)
		_node.OutputTokens = value
	}
	if value, ok := tc.mutation.IsSuggested(); ok {
		_spec.SetField(task.FieldIsSuggested, field.TypeBool, value)
		_node.IsSuggested = value
	}
	if value, ok := tc.mutation.SourceCode(); ok {
		_spec.SetField(task.FieldSourceCode, field.TypeString, value)
		_node.SourceCode = value
	}
	if value, ok := tc.mutation.CursorPosition(); ok {
		_spec.SetField(task.FieldCursorPosition, field.TypeJSON, value)
		_node.CursorPosition = value
	}
	if value, ok := tc.mutation.UserInput(); ok {
		_spec.SetField(task.FieldUserInput, field.TypeString, value)
		_node.UserInput = value
	}
	if value, ok := tc.mutation.CreatedAt(); ok {
		_spec.SetField(task.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := tc.mutation.UpdatedAt(); ok {
		_spec.SetField(task.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if nodes := tc.mutation.TaskRecordsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   task.TaskRecordsTable,
			Columns: []string{task.TaskRecordsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(taskrecord.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := tc.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   task.UserTable,
			Columns: []string{task.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.UserID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := tc.mutation.ModelIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   task.ModelTable,
			Columns: []string{task.ModelColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(model.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.ModelID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Task.Create().
//		SetTaskID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.TaskUpsert) {
//			SetTaskID(v+v).
//		}).
//		Exec(ctx)
func (tc *TaskCreate) OnConflict(opts ...sql.ConflictOption) *TaskUpsertOne {
	tc.conflict = opts
	return &TaskUpsertOne{
		create: tc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Task.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (tc *TaskCreate) OnConflictColumns(columns ...string) *TaskUpsertOne {
	tc.conflict = append(tc.conflict, sql.ConflictColumns(columns...))
	return &TaskUpsertOne{
		create: tc,
	}
}

type (
	// TaskUpsertOne is the builder for "upsert"-ing
	//  one Task node.
	TaskUpsertOne struct {
		create *TaskCreate
	}

	// TaskUpsert is the "OnConflict" setter.
	TaskUpsert struct {
		*sql.UpdateSet
	}
)

// SetTaskID sets the "task_id" field.
func (u *TaskUpsert) SetTaskID(v string) *TaskUpsert {
	u.Set(task.FieldTaskID, v)
	return u
}

// UpdateTaskID sets the "task_id" field to the value that was provided on create.
func (u *TaskUpsert) UpdateTaskID() *TaskUpsert {
	u.SetExcluded(task.FieldTaskID)
	return u
}

// SetUserID sets the "user_id" field.
func (u *TaskUpsert) SetUserID(v uuid.UUID) *TaskUpsert {
	u.Set(task.FieldUserID, v)
	return u
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *TaskUpsert) UpdateUserID() *TaskUpsert {
	u.SetExcluded(task.FieldUserID)
	return u
}

// ClearUserID clears the value of the "user_id" field.
func (u *TaskUpsert) ClearUserID() *TaskUpsert {
	u.SetNull(task.FieldUserID)
	return u
}

// SetModelID sets the "model_id" field.
func (u *TaskUpsert) SetModelID(v uuid.UUID) *TaskUpsert {
	u.Set(task.FieldModelID, v)
	return u
}

// UpdateModelID sets the "model_id" field to the value that was provided on create.
func (u *TaskUpsert) UpdateModelID() *TaskUpsert {
	u.SetExcluded(task.FieldModelID)
	return u
}

// ClearModelID clears the value of the "model_id" field.
func (u *TaskUpsert) ClearModelID() *TaskUpsert {
	u.SetNull(task.FieldModelID)
	return u
}

// SetRequestID sets the "request_id" field.
func (u *TaskUpsert) SetRequestID(v string) *TaskUpsert {
	u.Set(task.FieldRequestID, v)
	return u
}

// UpdateRequestID sets the "request_id" field to the value that was provided on create.
func (u *TaskUpsert) UpdateRequestID() *TaskUpsert {
	u.SetExcluded(task.FieldRequestID)
	return u
}

// ClearRequestID clears the value of the "request_id" field.
func (u *TaskUpsert) ClearRequestID() *TaskUpsert {
	u.SetNull(task.FieldRequestID)
	return u
}

// SetModelType sets the "model_type" field.
func (u *TaskUpsert) SetModelType(v consts.ModelType) *TaskUpsert {
	u.Set(task.FieldModelType, v)
	return u
}

// UpdateModelType sets the "model_type" field to the value that was provided on create.
func (u *TaskUpsert) UpdateModelType() *TaskUpsert {
	u.SetExcluded(task.FieldModelType)
	return u
}

// SetIsAccept sets the "is_accept" field.
func (u *TaskUpsert) SetIsAccept(v bool) *TaskUpsert {
	u.Set(task.FieldIsAccept, v)
	return u
}

// UpdateIsAccept sets the "is_accept" field to the value that was provided on create.
func (u *TaskUpsert) UpdateIsAccept() *TaskUpsert {
	u.SetExcluded(task.FieldIsAccept)
	return u
}

// SetProgramLanguage sets the "program_language" field.
func (u *TaskUpsert) SetProgramLanguage(v string) *TaskUpsert {
	u.Set(task.FieldProgramLanguage, v)
	return u
}

// UpdateProgramLanguage sets the "program_language" field to the value that was provided on create.
func (u *TaskUpsert) UpdateProgramLanguage() *TaskUpsert {
	u.SetExcluded(task.FieldProgramLanguage)
	return u
}

// ClearProgramLanguage clears the value of the "program_language" field.
func (u *TaskUpsert) ClearProgramLanguage() *TaskUpsert {
	u.SetNull(task.FieldProgramLanguage)
	return u
}

// SetWorkMode sets the "work_mode" field.
func (u *TaskUpsert) SetWorkMode(v string) *TaskUpsert {
	u.Set(task.FieldWorkMode, v)
	return u
}

// UpdateWorkMode sets the "work_mode" field to the value that was provided on create.
func (u *TaskUpsert) UpdateWorkMode() *TaskUpsert {
	u.SetExcluded(task.FieldWorkMode)
	return u
}

// ClearWorkMode clears the value of the "work_mode" field.
func (u *TaskUpsert) ClearWorkMode() *TaskUpsert {
	u.SetNull(task.FieldWorkMode)
	return u
}

// SetPrompt sets the "prompt" field.
func (u *TaskUpsert) SetPrompt(v string) *TaskUpsert {
	u.Set(task.FieldPrompt, v)
	return u
}

// UpdatePrompt sets the "prompt" field to the value that was provided on create.
func (u *TaskUpsert) UpdatePrompt() *TaskUpsert {
	u.SetExcluded(task.FieldPrompt)
	return u
}

// ClearPrompt clears the value of the "prompt" field.
func (u *TaskUpsert) ClearPrompt() *TaskUpsert {
	u.SetNull(task.FieldPrompt)
	return u
}

// SetCompletion sets the "completion" field.
func (u *TaskUpsert) SetCompletion(v string) *TaskUpsert {
	u.Set(task.FieldCompletion, v)
	return u
}

// UpdateCompletion sets the "completion" field to the value that was provided on create.
func (u *TaskUpsert) UpdateCompletion() *TaskUpsert {
	u.SetExcluded(task.FieldCompletion)
	return u
}

// ClearCompletion clears the value of the "completion" field.
func (u *TaskUpsert) ClearCompletion() *TaskUpsert {
	u.SetNull(task.FieldCompletion)
	return u
}

// SetCodeLines sets the "code_lines" field.
func (u *TaskUpsert) SetCodeLines(v int64) *TaskUpsert {
	u.Set(task.FieldCodeLines, v)
	return u
}

// UpdateCodeLines sets the "code_lines" field to the value that was provided on create.
func (u *TaskUpsert) UpdateCodeLines() *TaskUpsert {
	u.SetExcluded(task.FieldCodeLines)
	return u
}

// AddCodeLines adds v to the "code_lines" field.
func (u *TaskUpsert) AddCodeLines(v int64) *TaskUpsert {
	u.Add(task.FieldCodeLines, v)
	return u
}

// ClearCodeLines clears the value of the "code_lines" field.
func (u *TaskUpsert) ClearCodeLines() *TaskUpsert {
	u.SetNull(task.FieldCodeLines)
	return u
}

// SetInputTokens sets the "input_tokens" field.
func (u *TaskUpsert) SetInputTokens(v int64) *TaskUpsert {
	u.Set(task.FieldInputTokens, v)
	return u
}

// UpdateInputTokens sets the "input_tokens" field to the value that was provided on create.
func (u *TaskUpsert) UpdateInputTokens() *TaskUpsert {
	u.SetExcluded(task.FieldInputTokens)
	return u
}

// AddInputTokens adds v to the "input_tokens" field.
func (u *TaskUpsert) AddInputTokens(v int64) *TaskUpsert {
	u.Add(task.FieldInputTokens, v)
	return u
}

// ClearInputTokens clears the value of the "input_tokens" field.
func (u *TaskUpsert) ClearInputTokens() *TaskUpsert {
	u.SetNull(task.FieldInputTokens)
	return u
}

// SetOutputTokens sets the "output_tokens" field.
func (u *TaskUpsert) SetOutputTokens(v int64) *TaskUpsert {
	u.Set(task.FieldOutputTokens, v)
	return u
}

// UpdateOutputTokens sets the "output_tokens" field to the value that was provided on create.
func (u *TaskUpsert) UpdateOutputTokens() *TaskUpsert {
	u.SetExcluded(task.FieldOutputTokens)
	return u
}

// AddOutputTokens adds v to the "output_tokens" field.
func (u *TaskUpsert) AddOutputTokens(v int64) *TaskUpsert {
	u.Add(task.FieldOutputTokens, v)
	return u
}

// ClearOutputTokens clears the value of the "output_tokens" field.
func (u *TaskUpsert) ClearOutputTokens() *TaskUpsert {
	u.SetNull(task.FieldOutputTokens)
	return u
}

// SetIsSuggested sets the "is_suggested" field.
func (u *TaskUpsert) SetIsSuggested(v bool) *TaskUpsert {
	u.Set(task.FieldIsSuggested, v)
	return u
}

// UpdateIsSuggested sets the "is_suggested" field to the value that was provided on create.
func (u *TaskUpsert) UpdateIsSuggested() *TaskUpsert {
	u.SetExcluded(task.FieldIsSuggested)
	return u
}

// SetSourceCode sets the "source_code" field.
func (u *TaskUpsert) SetSourceCode(v string) *TaskUpsert {
	u.Set(task.FieldSourceCode, v)
	return u
}

// UpdateSourceCode sets the "source_code" field to the value that was provided on create.
func (u *TaskUpsert) UpdateSourceCode() *TaskUpsert {
	u.SetExcluded(task.FieldSourceCode)
	return u
}

// ClearSourceCode clears the value of the "source_code" field.
func (u *TaskUpsert) ClearSourceCode() *TaskUpsert {
	u.SetNull(task.FieldSourceCode)
	return u
}

// SetCursorPosition sets the "cursor_position" field.
func (u *TaskUpsert) SetCursorPosition(v map[string]interface{}) *TaskUpsert {
	u.Set(task.FieldCursorPosition, v)
	return u
}

// UpdateCursorPosition sets the "cursor_position" field to the value that was provided on create.
func (u *TaskUpsert) UpdateCursorPosition() *TaskUpsert {
	u.SetExcluded(task.FieldCursorPosition)
	return u
}

// ClearCursorPosition clears the value of the "cursor_position" field.
func (u *TaskUpsert) ClearCursorPosition() *TaskUpsert {
	u.SetNull(task.FieldCursorPosition)
	return u
}

// SetUserInput sets the "user_input" field.
func (u *TaskUpsert) SetUserInput(v string) *TaskUpsert {
	u.Set(task.FieldUserInput, v)
	return u
}

// UpdateUserInput sets the "user_input" field to the value that was provided on create.
func (u *TaskUpsert) UpdateUserInput() *TaskUpsert {
	u.SetExcluded(task.FieldUserInput)
	return u
}

// ClearUserInput clears the value of the "user_input" field.
func (u *TaskUpsert) ClearUserInput() *TaskUpsert {
	u.SetNull(task.FieldUserInput)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *TaskUpsert) SetCreatedAt(v time.Time) *TaskUpsert {
	u.Set(task.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *TaskUpsert) UpdateCreatedAt() *TaskUpsert {
	u.SetExcluded(task.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *TaskUpsert) SetUpdatedAt(v time.Time) *TaskUpsert {
	u.Set(task.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *TaskUpsert) UpdateUpdatedAt() *TaskUpsert {
	u.SetExcluded(task.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.Task.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(task.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *TaskUpsertOne) UpdateNewValues() *TaskUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(task.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Task.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *TaskUpsertOne) Ignore() *TaskUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *TaskUpsertOne) DoNothing() *TaskUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the TaskCreate.OnConflict
// documentation for more info.
func (u *TaskUpsertOne) Update(set func(*TaskUpsert)) *TaskUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&TaskUpsert{UpdateSet: update})
	}))
	return u
}

// SetTaskID sets the "task_id" field.
func (u *TaskUpsertOne) SetTaskID(v string) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetTaskID(v)
	})
}

// UpdateTaskID sets the "task_id" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateTaskID() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateTaskID()
	})
}

// SetUserID sets the "user_id" field.
func (u *TaskUpsertOne) SetUserID(v uuid.UUID) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateUserID() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateUserID()
	})
}

// ClearUserID clears the value of the "user_id" field.
func (u *TaskUpsertOne) ClearUserID() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.ClearUserID()
	})
}

// SetModelID sets the "model_id" field.
func (u *TaskUpsertOne) SetModelID(v uuid.UUID) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetModelID(v)
	})
}

// UpdateModelID sets the "model_id" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateModelID() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateModelID()
	})
}

// ClearModelID clears the value of the "model_id" field.
func (u *TaskUpsertOne) ClearModelID() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.ClearModelID()
	})
}

// SetRequestID sets the "request_id" field.
func (u *TaskUpsertOne) SetRequestID(v string) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetRequestID(v)
	})
}

// UpdateRequestID sets the "request_id" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateRequestID() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateRequestID()
	})
}

// ClearRequestID clears the value of the "request_id" field.
func (u *TaskUpsertOne) ClearRequestID() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.ClearRequestID()
	})
}

// SetModelType sets the "model_type" field.
func (u *TaskUpsertOne) SetModelType(v consts.ModelType) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetModelType(v)
	})
}

// UpdateModelType sets the "model_type" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateModelType() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateModelType()
	})
}

// SetIsAccept sets the "is_accept" field.
func (u *TaskUpsertOne) SetIsAccept(v bool) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetIsAccept(v)
	})
}

// UpdateIsAccept sets the "is_accept" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateIsAccept() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateIsAccept()
	})
}

// SetProgramLanguage sets the "program_language" field.
func (u *TaskUpsertOne) SetProgramLanguage(v string) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetProgramLanguage(v)
	})
}

// UpdateProgramLanguage sets the "program_language" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateProgramLanguage() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateProgramLanguage()
	})
}

// ClearProgramLanguage clears the value of the "program_language" field.
func (u *TaskUpsertOne) ClearProgramLanguage() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.ClearProgramLanguage()
	})
}

// SetWorkMode sets the "work_mode" field.
func (u *TaskUpsertOne) SetWorkMode(v string) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetWorkMode(v)
	})
}

// UpdateWorkMode sets the "work_mode" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateWorkMode() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateWorkMode()
	})
}

// ClearWorkMode clears the value of the "work_mode" field.
func (u *TaskUpsertOne) ClearWorkMode() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.ClearWorkMode()
	})
}

// SetPrompt sets the "prompt" field.
func (u *TaskUpsertOne) SetPrompt(v string) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetPrompt(v)
	})
}

// UpdatePrompt sets the "prompt" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdatePrompt() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdatePrompt()
	})
}

// ClearPrompt clears the value of the "prompt" field.
func (u *TaskUpsertOne) ClearPrompt() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.ClearPrompt()
	})
}

// SetCompletion sets the "completion" field.
func (u *TaskUpsertOne) SetCompletion(v string) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetCompletion(v)
	})
}

// UpdateCompletion sets the "completion" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateCompletion() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateCompletion()
	})
}

// ClearCompletion clears the value of the "completion" field.
func (u *TaskUpsertOne) ClearCompletion() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.ClearCompletion()
	})
}

// SetCodeLines sets the "code_lines" field.
func (u *TaskUpsertOne) SetCodeLines(v int64) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetCodeLines(v)
	})
}

// AddCodeLines adds v to the "code_lines" field.
func (u *TaskUpsertOne) AddCodeLines(v int64) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.AddCodeLines(v)
	})
}

// UpdateCodeLines sets the "code_lines" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateCodeLines() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateCodeLines()
	})
}

// ClearCodeLines clears the value of the "code_lines" field.
func (u *TaskUpsertOne) ClearCodeLines() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.ClearCodeLines()
	})
}

// SetInputTokens sets the "input_tokens" field.
func (u *TaskUpsertOne) SetInputTokens(v int64) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetInputTokens(v)
	})
}

// AddInputTokens adds v to the "input_tokens" field.
func (u *TaskUpsertOne) AddInputTokens(v int64) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.AddInputTokens(v)
	})
}

// UpdateInputTokens sets the "input_tokens" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateInputTokens() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateInputTokens()
	})
}

// ClearInputTokens clears the value of the "input_tokens" field.
func (u *TaskUpsertOne) ClearInputTokens() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.ClearInputTokens()
	})
}

// SetOutputTokens sets the "output_tokens" field.
func (u *TaskUpsertOne) SetOutputTokens(v int64) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetOutputTokens(v)
	})
}

// AddOutputTokens adds v to the "output_tokens" field.
func (u *TaskUpsertOne) AddOutputTokens(v int64) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.AddOutputTokens(v)
	})
}

// UpdateOutputTokens sets the "output_tokens" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateOutputTokens() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateOutputTokens()
	})
}

// ClearOutputTokens clears the value of the "output_tokens" field.
func (u *TaskUpsertOne) ClearOutputTokens() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.ClearOutputTokens()
	})
}

// SetIsSuggested sets the "is_suggested" field.
func (u *TaskUpsertOne) SetIsSuggested(v bool) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetIsSuggested(v)
	})
}

// UpdateIsSuggested sets the "is_suggested" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateIsSuggested() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateIsSuggested()
	})
}

// SetSourceCode sets the "source_code" field.
func (u *TaskUpsertOne) SetSourceCode(v string) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetSourceCode(v)
	})
}

// UpdateSourceCode sets the "source_code" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateSourceCode() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateSourceCode()
	})
}

// ClearSourceCode clears the value of the "source_code" field.
func (u *TaskUpsertOne) ClearSourceCode() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.ClearSourceCode()
	})
}

// SetCursorPosition sets the "cursor_position" field.
func (u *TaskUpsertOne) SetCursorPosition(v map[string]interface{}) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetCursorPosition(v)
	})
}

// UpdateCursorPosition sets the "cursor_position" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateCursorPosition() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateCursorPosition()
	})
}

// ClearCursorPosition clears the value of the "cursor_position" field.
func (u *TaskUpsertOne) ClearCursorPosition() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.ClearCursorPosition()
	})
}

// SetUserInput sets the "user_input" field.
func (u *TaskUpsertOne) SetUserInput(v string) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetUserInput(v)
	})
}

// UpdateUserInput sets the "user_input" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateUserInput() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateUserInput()
	})
}

// ClearUserInput clears the value of the "user_input" field.
func (u *TaskUpsertOne) ClearUserInput() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.ClearUserInput()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *TaskUpsertOne) SetCreatedAt(v time.Time) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateCreatedAt() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *TaskUpsertOne) SetUpdatedAt(v time.Time) *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *TaskUpsertOne) UpdateUpdatedAt() *TaskUpsertOne {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *TaskUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for TaskCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *TaskUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *TaskUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: TaskUpsertOne.ID is not supported by MySQL driver. Use TaskUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *TaskUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// TaskCreateBulk is the builder for creating many Task entities in bulk.
type TaskCreateBulk struct {
	config
	err      error
	builders []*TaskCreate
	conflict []sql.ConflictOption
}

// Save creates the Task entities in the database.
func (tcb *TaskCreateBulk) Save(ctx context.Context) ([]*Task, error) {
	if tcb.err != nil {
		return nil, tcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(tcb.builders))
	nodes := make([]*Task, len(tcb.builders))
	mutators := make([]Mutator, len(tcb.builders))
	for i := range tcb.builders {
		func(i int, root context.Context) {
			builder := tcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*TaskMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, tcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = tcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, tcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, tcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (tcb *TaskCreateBulk) SaveX(ctx context.Context) []*Task {
	v, err := tcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (tcb *TaskCreateBulk) Exec(ctx context.Context) error {
	_, err := tcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (tcb *TaskCreateBulk) ExecX(ctx context.Context) {
	if err := tcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Task.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.TaskUpsert) {
//			SetTaskID(v+v).
//		}).
//		Exec(ctx)
func (tcb *TaskCreateBulk) OnConflict(opts ...sql.ConflictOption) *TaskUpsertBulk {
	tcb.conflict = opts
	return &TaskUpsertBulk{
		create: tcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Task.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (tcb *TaskCreateBulk) OnConflictColumns(columns ...string) *TaskUpsertBulk {
	tcb.conflict = append(tcb.conflict, sql.ConflictColumns(columns...))
	return &TaskUpsertBulk{
		create: tcb,
	}
}

// TaskUpsertBulk is the builder for "upsert"-ing
// a bulk of Task nodes.
type TaskUpsertBulk struct {
	create *TaskCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.Task.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(task.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *TaskUpsertBulk) UpdateNewValues() *TaskUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(task.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Task.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *TaskUpsertBulk) Ignore() *TaskUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *TaskUpsertBulk) DoNothing() *TaskUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the TaskCreateBulk.OnConflict
// documentation for more info.
func (u *TaskUpsertBulk) Update(set func(*TaskUpsert)) *TaskUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&TaskUpsert{UpdateSet: update})
	}))
	return u
}

// SetTaskID sets the "task_id" field.
func (u *TaskUpsertBulk) SetTaskID(v string) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetTaskID(v)
	})
}

// UpdateTaskID sets the "task_id" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateTaskID() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateTaskID()
	})
}

// SetUserID sets the "user_id" field.
func (u *TaskUpsertBulk) SetUserID(v uuid.UUID) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateUserID() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateUserID()
	})
}

// ClearUserID clears the value of the "user_id" field.
func (u *TaskUpsertBulk) ClearUserID() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.ClearUserID()
	})
}

// SetModelID sets the "model_id" field.
func (u *TaskUpsertBulk) SetModelID(v uuid.UUID) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetModelID(v)
	})
}

// UpdateModelID sets the "model_id" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateModelID() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateModelID()
	})
}

// ClearModelID clears the value of the "model_id" field.
func (u *TaskUpsertBulk) ClearModelID() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.ClearModelID()
	})
}

// SetRequestID sets the "request_id" field.
func (u *TaskUpsertBulk) SetRequestID(v string) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetRequestID(v)
	})
}

// UpdateRequestID sets the "request_id" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateRequestID() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateRequestID()
	})
}

// ClearRequestID clears the value of the "request_id" field.
func (u *TaskUpsertBulk) ClearRequestID() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.ClearRequestID()
	})
}

// SetModelType sets the "model_type" field.
func (u *TaskUpsertBulk) SetModelType(v consts.ModelType) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetModelType(v)
	})
}

// UpdateModelType sets the "model_type" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateModelType() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateModelType()
	})
}

// SetIsAccept sets the "is_accept" field.
func (u *TaskUpsertBulk) SetIsAccept(v bool) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetIsAccept(v)
	})
}

// UpdateIsAccept sets the "is_accept" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateIsAccept() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateIsAccept()
	})
}

// SetProgramLanguage sets the "program_language" field.
func (u *TaskUpsertBulk) SetProgramLanguage(v string) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetProgramLanguage(v)
	})
}

// UpdateProgramLanguage sets the "program_language" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateProgramLanguage() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateProgramLanguage()
	})
}

// ClearProgramLanguage clears the value of the "program_language" field.
func (u *TaskUpsertBulk) ClearProgramLanguage() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.ClearProgramLanguage()
	})
}

// SetWorkMode sets the "work_mode" field.
func (u *TaskUpsertBulk) SetWorkMode(v string) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetWorkMode(v)
	})
}

// UpdateWorkMode sets the "work_mode" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateWorkMode() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateWorkMode()
	})
}

// ClearWorkMode clears the value of the "work_mode" field.
func (u *TaskUpsertBulk) ClearWorkMode() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.ClearWorkMode()
	})
}

// SetPrompt sets the "prompt" field.
func (u *TaskUpsertBulk) SetPrompt(v string) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetPrompt(v)
	})
}

// UpdatePrompt sets the "prompt" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdatePrompt() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdatePrompt()
	})
}

// ClearPrompt clears the value of the "prompt" field.
func (u *TaskUpsertBulk) ClearPrompt() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.ClearPrompt()
	})
}

// SetCompletion sets the "completion" field.
func (u *TaskUpsertBulk) SetCompletion(v string) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetCompletion(v)
	})
}

// UpdateCompletion sets the "completion" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateCompletion() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateCompletion()
	})
}

// ClearCompletion clears the value of the "completion" field.
func (u *TaskUpsertBulk) ClearCompletion() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.ClearCompletion()
	})
}

// SetCodeLines sets the "code_lines" field.
func (u *TaskUpsertBulk) SetCodeLines(v int64) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetCodeLines(v)
	})
}

// AddCodeLines adds v to the "code_lines" field.
func (u *TaskUpsertBulk) AddCodeLines(v int64) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.AddCodeLines(v)
	})
}

// UpdateCodeLines sets the "code_lines" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateCodeLines() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateCodeLines()
	})
}

// ClearCodeLines clears the value of the "code_lines" field.
func (u *TaskUpsertBulk) ClearCodeLines() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.ClearCodeLines()
	})
}

// SetInputTokens sets the "input_tokens" field.
func (u *TaskUpsertBulk) SetInputTokens(v int64) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetInputTokens(v)
	})
}

// AddInputTokens adds v to the "input_tokens" field.
func (u *TaskUpsertBulk) AddInputTokens(v int64) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.AddInputTokens(v)
	})
}

// UpdateInputTokens sets the "input_tokens" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateInputTokens() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateInputTokens()
	})
}

// ClearInputTokens clears the value of the "input_tokens" field.
func (u *TaskUpsertBulk) ClearInputTokens() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.ClearInputTokens()
	})
}

// SetOutputTokens sets the "output_tokens" field.
func (u *TaskUpsertBulk) SetOutputTokens(v int64) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetOutputTokens(v)
	})
}

// AddOutputTokens adds v to the "output_tokens" field.
func (u *TaskUpsertBulk) AddOutputTokens(v int64) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.AddOutputTokens(v)
	})
}

// UpdateOutputTokens sets the "output_tokens" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateOutputTokens() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateOutputTokens()
	})
}

// ClearOutputTokens clears the value of the "output_tokens" field.
func (u *TaskUpsertBulk) ClearOutputTokens() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.ClearOutputTokens()
	})
}

// SetIsSuggested sets the "is_suggested" field.
func (u *TaskUpsertBulk) SetIsSuggested(v bool) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetIsSuggested(v)
	})
}

// UpdateIsSuggested sets the "is_suggested" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateIsSuggested() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateIsSuggested()
	})
}

// SetSourceCode sets the "source_code" field.
func (u *TaskUpsertBulk) SetSourceCode(v string) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetSourceCode(v)
	})
}

// UpdateSourceCode sets the "source_code" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateSourceCode() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateSourceCode()
	})
}

// ClearSourceCode clears the value of the "source_code" field.
func (u *TaskUpsertBulk) ClearSourceCode() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.ClearSourceCode()
	})
}

// SetCursorPosition sets the "cursor_position" field.
func (u *TaskUpsertBulk) SetCursorPosition(v map[string]interface{}) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetCursorPosition(v)
	})
}

// UpdateCursorPosition sets the "cursor_position" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateCursorPosition() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateCursorPosition()
	})
}

// ClearCursorPosition clears the value of the "cursor_position" field.
func (u *TaskUpsertBulk) ClearCursorPosition() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.ClearCursorPosition()
	})
}

// SetUserInput sets the "user_input" field.
func (u *TaskUpsertBulk) SetUserInput(v string) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetUserInput(v)
	})
}

// UpdateUserInput sets the "user_input" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateUserInput() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateUserInput()
	})
}

// ClearUserInput clears the value of the "user_input" field.
func (u *TaskUpsertBulk) ClearUserInput() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.ClearUserInput()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *TaskUpsertBulk) SetCreatedAt(v time.Time) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateCreatedAt() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *TaskUpsertBulk) SetUpdatedAt(v time.Time) *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *TaskUpsertBulk) UpdateUpdatedAt() *TaskUpsertBulk {
	return u.Update(func(s *TaskUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *TaskUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the TaskCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for TaskCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *TaskUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
