// Code generated by ent, DO NOT EDIT.

package task

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the task type in the database.
	Label = "task"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldTaskID holds the string denoting the task_id field in the database.
	FieldTaskID = "task_id"
	// FieldUserID holds the string denoting the user_id field in the database.
	FieldUserID = "user_id"
	// FieldModelID holds the string denoting the model_id field in the database.
	FieldModelID = "model_id"
	// FieldRequestID holds the string denoting the request_id field in the database.
	FieldRequestID = "request_id"
	// FieldModelType holds the string denoting the model_type field in the database.
	FieldModelType = "model_type"
	// FieldIsAccept holds the string denoting the is_accept field in the database.
	FieldIsAccept = "is_accept"
	// FieldProgramLanguage holds the string denoting the program_language field in the database.
	FieldProgramLanguage = "program_language"
	// FieldWorkMode holds the string denoting the work_mode field in the database.
	FieldWorkMode = "work_mode"
	// FieldPrompt holds the string denoting the prompt field in the database.
	FieldPrompt = "prompt"
	// FieldCompletion holds the string denoting the completion field in the database.
	FieldCompletion = "completion"
	// FieldCodeLines holds the string denoting the code_lines field in the database.
	FieldCodeLines = "code_lines"
	// FieldInputTokens holds the string denoting the input_tokens field in the database.
	FieldInputTokens = "input_tokens"
	// FieldOutputTokens holds the string denoting the output_tokens field in the database.
	FieldOutputTokens = "output_tokens"
	// FieldIsSuggested holds the string denoting the is_suggested field in the database.
	FieldIsSuggested = "is_suggested"
	// FieldSourceCode holds the string denoting the source_code field in the database.
	FieldSourceCode = "source_code"
	// FieldCursorPosition holds the string denoting the cursor_position field in the database.
	FieldCursorPosition = "cursor_position"
	// FieldUserInput holds the string denoting the user_input field in the database.
	FieldUserInput = "user_input"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// FieldUpdatedAt holds the string denoting the updated_at field in the database.
	FieldUpdatedAt = "updated_at"
	// EdgeTaskRecords holds the string denoting the task_records edge name in mutations.
	EdgeTaskRecords = "task_records"
	// EdgeUser holds the string denoting the user edge name in mutations.
	EdgeUser = "user"
	// EdgeModel holds the string denoting the model edge name in mutations.
	EdgeModel = "model"
	// Table holds the table name of the task in the database.
	Table = "tasks"
	// TaskRecordsTable is the table that holds the task_records relation/edge.
	TaskRecordsTable = "task_records"
	// TaskRecordsInverseTable is the table name for the TaskRecord entity.
	// It exists in this package in order to avoid circular dependency with the "taskrecord" package.
	TaskRecordsInverseTable = "task_records"
	// TaskRecordsColumn is the table column denoting the task_records relation/edge.
	TaskRecordsColumn = "task_id"
	// UserTable is the table that holds the user relation/edge.
	UserTable = "tasks"
	// UserInverseTable is the table name for the User entity.
	// It exists in this package in order to avoid circular dependency with the "user" package.
	UserInverseTable = "users"
	// UserColumn is the table column denoting the user relation/edge.
	UserColumn = "user_id"
	// ModelTable is the table that holds the model relation/edge.
	ModelTable = "tasks"
	// ModelInverseTable is the table name for the Model entity.
	// It exists in this package in order to avoid circular dependency with the "model" package.
	ModelInverseTable = "models"
	// ModelColumn is the table column denoting the model relation/edge.
	ModelColumn = "model_id"
)

// Columns holds all SQL columns for task fields.
var Columns = []string{
	FieldID,
	FieldTaskID,
	FieldUserID,
	FieldModelID,
	FieldRequestID,
	FieldModelType,
	FieldIsAccept,
	FieldProgramLanguage,
	FieldWorkMode,
	FieldPrompt,
	FieldCompletion,
	FieldCodeLines,
	FieldInputTokens,
	FieldOutputTokens,
	FieldIsSuggested,
	FieldSourceCode,
	FieldCursorPosition,
	FieldUserInput,
	FieldCreatedAt,
	FieldUpdatedAt,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultIsAccept holds the default value on creation for the "is_accept" field.
	DefaultIsAccept bool
	// DefaultIsSuggested holds the default value on creation for the "is_suggested" field.
	DefaultIsSuggested bool
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
	// DefaultUpdatedAt holds the default value on creation for the "updated_at" field.
	DefaultUpdatedAt func() time.Time
	// UpdateDefaultUpdatedAt holds the default value on update for the "updated_at" field.
	UpdateDefaultUpdatedAt func() time.Time
)

// OrderOption defines the ordering options for the Task queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByTaskID orders the results by the task_id field.
func ByTaskID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldTaskID, opts...).ToFunc()
}

// ByUserID orders the results by the user_id field.
func ByUserID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUserID, opts...).ToFunc()
}

// ByModelID orders the results by the model_id field.
func ByModelID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldModelID, opts...).ToFunc()
}

// ByRequestID orders the results by the request_id field.
func ByRequestID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldRequestID, opts...).ToFunc()
}

// ByModelType orders the results by the model_type field.
func ByModelType(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldModelType, opts...).ToFunc()
}

// ByIsAccept orders the results by the is_accept field.
func ByIsAccept(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldIsAccept, opts...).ToFunc()
}

// ByProgramLanguage orders the results by the program_language field.
func ByProgramLanguage(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldProgramLanguage, opts...).ToFunc()
}

// ByWorkMode orders the results by the work_mode field.
func ByWorkMode(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldWorkMode, opts...).ToFunc()
}

// ByPrompt orders the results by the prompt field.
func ByPrompt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldPrompt, opts...).ToFunc()
}

// ByCompletion orders the results by the completion field.
func ByCompletion(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCompletion, opts...).ToFunc()
}

// ByCodeLines orders the results by the code_lines field.
func ByCodeLines(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCodeLines, opts...).ToFunc()
}

// ByInputTokens orders the results by the input_tokens field.
func ByInputTokens(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldInputTokens, opts...).ToFunc()
}

// ByOutputTokens orders the results by the output_tokens field.
func ByOutputTokens(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldOutputTokens, opts...).ToFunc()
}

// ByIsSuggested orders the results by the is_suggested field.
func ByIsSuggested(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldIsSuggested, opts...).ToFunc()
}

// BySourceCode orders the results by the source_code field.
func BySourceCode(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSourceCode, opts...).ToFunc()
}

// ByUserInput orders the results by the user_input field.
func ByUserInput(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUserInput, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByUpdatedAt orders the results by the updated_at field.
func ByUpdatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUpdatedAt, opts...).ToFunc()
}

// ByTaskRecordsCount orders the results by task_records count.
func ByTaskRecordsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newTaskRecordsStep(), opts...)
	}
}

// ByTaskRecords orders the results by task_records terms.
func ByTaskRecords(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newTaskRecordsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByUserField orders the results by user field.
func ByUserField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newUserStep(), sql.OrderByField(field, opts...))
	}
}

// ByModelField orders the results by model field.
func ByModelField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newModelStep(), sql.OrderByField(field, opts...))
	}
}
func newTaskRecordsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(TaskRecordsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, TaskRecordsTable, TaskRecordsColumn),
	)
}
func newUserStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(UserInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, UserTable, UserColumn),
	)
}
func newModelStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(ModelInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, ModelTable, ModelColumn),
	)
}
