// Code generated by ent, DO NOT EDIT.

package db

import (
	"encoding/json"
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/model"
	"github.com/chaitin/MonkeyCode/backend/db/task"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/google/uuid"
)

// Task is the model entity for the Task schema.
type Task struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// TaskID holds the value of the "task_id" field.
	TaskID string `json:"task_id,omitempty"`
	// UserID holds the value of the "user_id" field.
	UserID uuid.UUID `json:"user_id,omitempty"`
	// ModelID holds the value of the "model_id" field.
	ModelID uuid.UUID `json:"model_id,omitempty"`
	// RequestID holds the value of the "request_id" field.
	RequestID string `json:"request_id,omitempty"`
	// ModelType holds the value of the "model_type" field.
	ModelType consts.ModelType `json:"model_type,omitempty"`
	// IsAccept holds the value of the "is_accept" field.
	IsAccept bool `json:"is_accept,omitempty"`
	// ProgramLanguage holds the value of the "program_language" field.
	ProgramLanguage string `json:"program_language,omitempty"`
	// WorkMode holds the value of the "work_mode" field.
	WorkMode string `json:"work_mode,omitempty"`
	// Prompt holds the value of the "prompt" field.
	Prompt string `json:"prompt,omitempty"`
	// Completion holds the value of the "completion" field.
	Completion string `json:"completion,omitempty"`
	// CodeLines holds the value of the "code_lines" field.
	CodeLines int64 `json:"code_lines,omitempty"`
	// InputTokens holds the value of the "input_tokens" field.
	InputTokens int64 `json:"input_tokens,omitempty"`
	// OutputTokens holds the value of the "output_tokens" field.
	OutputTokens int64 `json:"output_tokens,omitempty"`
	// IsSuggested holds the value of the "is_suggested" field.
	IsSuggested bool `json:"is_suggested,omitempty"`
	// SourceCode holds the value of the "source_code" field.
	SourceCode string `json:"source_code,omitempty"`
	// CursorPosition holds the value of the "cursor_position" field.
	CursorPosition map[string]interface{} `json:"cursor_position,omitempty"`
	// UserInput holds the value of the "user_input" field.
	UserInput string `json:"user_input,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the TaskQuery when eager-loading is set.
	Edges        TaskEdges `json:"edges"`
	selectValues sql.SelectValues
}

// TaskEdges holds the relations/edges for other nodes in the graph.
type TaskEdges struct {
	// TaskRecords holds the value of the task_records edge.
	TaskRecords []*TaskRecord `json:"task_records,omitempty"`
	// User holds the value of the user edge.
	User *User `json:"user,omitempty"`
	// Model holds the value of the model edge.
	Model *Model `json:"model,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [3]bool
}

// TaskRecordsOrErr returns the TaskRecords value or an error if the edge
// was not loaded in eager-loading.
func (e TaskEdges) TaskRecordsOrErr() ([]*TaskRecord, error) {
	if e.loadedTypes[0] {
		return e.TaskRecords, nil
	}
	return nil, &NotLoadedError{edge: "task_records"}
}

// UserOrErr returns the User value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e TaskEdges) UserOrErr() (*User, error) {
	if e.User != nil {
		return e.User, nil
	} else if e.loadedTypes[1] {
		return nil, &NotFoundError{label: user.Label}
	}
	return nil, &NotLoadedError{edge: "user"}
}

// ModelOrErr returns the Model value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e TaskEdges) ModelOrErr() (*Model, error) {
	if e.Model != nil {
		return e.Model, nil
	} else if e.loadedTypes[2] {
		return nil, &NotFoundError{label: model.Label}
	}
	return nil, &NotLoadedError{edge: "model"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Task) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case task.FieldCursorPosition:
			values[i] = new([]byte)
		case task.FieldIsAccept, task.FieldIsSuggested:
			values[i] = new(sql.NullBool)
		case task.FieldCodeLines, task.FieldInputTokens, task.FieldOutputTokens:
			values[i] = new(sql.NullInt64)
		case task.FieldTaskID, task.FieldRequestID, task.FieldModelType, task.FieldProgramLanguage, task.FieldWorkMode, task.FieldPrompt, task.FieldCompletion, task.FieldSourceCode, task.FieldUserInput:
			values[i] = new(sql.NullString)
		case task.FieldCreatedAt, task.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		case task.FieldID, task.FieldUserID, task.FieldModelID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Task fields.
func (t *Task) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case task.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				t.ID = *value
			}
		case task.FieldTaskID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field task_id", values[i])
			} else if value.Valid {
				t.TaskID = value.String
			}
		case task.FieldUserID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field user_id", values[i])
			} else if value != nil {
				t.UserID = *value
			}
		case task.FieldModelID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field model_id", values[i])
			} else if value != nil {
				t.ModelID = *value
			}
		case task.FieldRequestID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field request_id", values[i])
			} else if value.Valid {
				t.RequestID = value.String
			}
		case task.FieldModelType:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field model_type", values[i])
			} else if value.Valid {
				t.ModelType = consts.ModelType(value.String)
			}
		case task.FieldIsAccept:
			if value, ok := values[i].(*sql.NullBool); !ok {
				return fmt.Errorf("unexpected type %T for field is_accept", values[i])
			} else if value.Valid {
				t.IsAccept = value.Bool
			}
		case task.FieldProgramLanguage:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field program_language", values[i])
			} else if value.Valid {
				t.ProgramLanguage = value.String
			}
		case task.FieldWorkMode:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field work_mode", values[i])
			} else if value.Valid {
				t.WorkMode = value.String
			}
		case task.FieldPrompt:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field prompt", values[i])
			} else if value.Valid {
				t.Prompt = value.String
			}
		case task.FieldCompletion:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field completion", values[i])
			} else if value.Valid {
				t.Completion = value.String
			}
		case task.FieldCodeLines:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field code_lines", values[i])
			} else if value.Valid {
				t.CodeLines = value.Int64
			}
		case task.FieldInputTokens:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field input_tokens", values[i])
			} else if value.Valid {
				t.InputTokens = value.Int64
			}
		case task.FieldOutputTokens:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field output_tokens", values[i])
			} else if value.Valid {
				t.OutputTokens = value.Int64
			}
		case task.FieldIsSuggested:
			if value, ok := values[i].(*sql.NullBool); !ok {
				return fmt.Errorf("unexpected type %T for field is_suggested", values[i])
			} else if value.Valid {
				t.IsSuggested = value.Bool
			}
		case task.FieldSourceCode:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field source_code", values[i])
			} else if value.Valid {
				t.SourceCode = value.String
			}
		case task.FieldCursorPosition:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field cursor_position", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &t.CursorPosition); err != nil {
					return fmt.Errorf("unmarshal field cursor_position: %w", err)
				}
			}
		case task.FieldUserInput:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field user_input", values[i])
			} else if value.Valid {
				t.UserInput = value.String
			}
		case task.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				t.CreatedAt = value.Time
			}
		case task.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				t.UpdatedAt = value.Time
			}
		default:
			t.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the Task.
// This includes values selected through modifiers, order, etc.
func (t *Task) Value(name string) (ent.Value, error) {
	return t.selectValues.Get(name)
}

// QueryTaskRecords queries the "task_records" edge of the Task entity.
func (t *Task) QueryTaskRecords() *TaskRecordQuery {
	return NewTaskClient(t.config).QueryTaskRecords(t)
}

// QueryUser queries the "user" edge of the Task entity.
func (t *Task) QueryUser() *UserQuery {
	return NewTaskClient(t.config).QueryUser(t)
}

// QueryModel queries the "model" edge of the Task entity.
func (t *Task) QueryModel() *ModelQuery {
	return NewTaskClient(t.config).QueryModel(t)
}

// Update returns a builder for updating this Task.
// Note that you need to call Task.Unwrap() before calling this method if this Task
// was returned from a transaction, and the transaction was committed or rolled back.
func (t *Task) Update() *TaskUpdateOne {
	return NewTaskClient(t.config).UpdateOne(t)
}

// Unwrap unwraps the Task entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (t *Task) Unwrap() *Task {
	_tx, ok := t.config.driver.(*txDriver)
	if !ok {
		panic("db: Task is not a transactional entity")
	}
	t.config.driver = _tx.drv
	return t
}

// String implements the fmt.Stringer.
func (t *Task) String() string {
	var builder strings.Builder
	builder.WriteString("Task(")
	builder.WriteString(fmt.Sprintf("id=%v, ", t.ID))
	builder.WriteString("task_id=")
	builder.WriteString(t.TaskID)
	builder.WriteString(", ")
	builder.WriteString("user_id=")
	builder.WriteString(fmt.Sprintf("%v", t.UserID))
	builder.WriteString(", ")
	builder.WriteString("model_id=")
	builder.WriteString(fmt.Sprintf("%v", t.ModelID))
	builder.WriteString(", ")
	builder.WriteString("request_id=")
	builder.WriteString(t.RequestID)
	builder.WriteString(", ")
	builder.WriteString("model_type=")
	builder.WriteString(fmt.Sprintf("%v", t.ModelType))
	builder.WriteString(", ")
	builder.WriteString("is_accept=")
	builder.WriteString(fmt.Sprintf("%v", t.IsAccept))
	builder.WriteString(", ")
	builder.WriteString("program_language=")
	builder.WriteString(t.ProgramLanguage)
	builder.WriteString(", ")
	builder.WriteString("work_mode=")
	builder.WriteString(t.WorkMode)
	builder.WriteString(", ")
	builder.WriteString("prompt=")
	builder.WriteString(t.Prompt)
	builder.WriteString(", ")
	builder.WriteString("completion=")
	builder.WriteString(t.Completion)
	builder.WriteString(", ")
	builder.WriteString("code_lines=")
	builder.WriteString(fmt.Sprintf("%v", t.CodeLines))
	builder.WriteString(", ")
	builder.WriteString("input_tokens=")
	builder.WriteString(fmt.Sprintf("%v", t.InputTokens))
	builder.WriteString(", ")
	builder.WriteString("output_tokens=")
	builder.WriteString(fmt.Sprintf("%v", t.OutputTokens))
	builder.WriteString(", ")
	builder.WriteString("is_suggested=")
	builder.WriteString(fmt.Sprintf("%v", t.IsSuggested))
	builder.WriteString(", ")
	builder.WriteString("source_code=")
	builder.WriteString(t.SourceCode)
	builder.WriteString(", ")
	builder.WriteString("cursor_position=")
	builder.WriteString(fmt.Sprintf("%v", t.CursorPosition))
	builder.WriteString(", ")
	builder.WriteString("user_input=")
	builder.WriteString(t.UserInput)
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(t.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(t.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// Tasks is a parsable slice of Task.
type Tasks []*Task
