// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/setting"
	"github.com/chaitin/MonkeyCode/backend/ent/types"
	"github.com/google/uuid"
)

// SettingCreate is the builder for creating a Setting entity.
type SettingCreate struct {
	config
	mutation *SettingMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetEnableSSO sets the "enable_sso" field.
func (sc *SettingCreate) SetEnableSSO(b bool) *SettingCreate {
	sc.mutation.SetEnableSSO(b)
	return sc
}

// SetNillableEnableSSO sets the "enable_sso" field if the given value is not nil.
func (sc *SettingCreate) SetNillableEnableSSO(b *bool) *SettingCreate {
	if b != nil {
		sc.SetEnableSSO(*b)
	}
	return sc
}

// SetForceTwoFactorAuth sets the "force_two_factor_auth" field.
func (sc *SettingCreate) SetForceTwoFactorAuth(b bool) *SettingCreate {
	sc.mutation.SetForceTwoFactorAuth(b)
	return sc
}

// SetNillableForceTwoFactorAuth sets the "force_two_factor_auth" field if the given value is not nil.
func (sc *SettingCreate) SetNillableForceTwoFactorAuth(b *bool) *SettingCreate {
	if b != nil {
		sc.SetForceTwoFactorAuth(*b)
	}
	return sc
}

// SetDisablePasswordLogin sets the "disable_password_login" field.
func (sc *SettingCreate) SetDisablePasswordLogin(b bool) *SettingCreate {
	sc.mutation.SetDisablePasswordLogin(b)
	return sc
}

// SetNillableDisablePasswordLogin sets the "disable_password_login" field if the given value is not nil.
func (sc *SettingCreate) SetNillableDisablePasswordLogin(b *bool) *SettingCreate {
	if b != nil {
		sc.SetDisablePasswordLogin(*b)
	}
	return sc
}

// SetEnableAutoLogin sets the "enable_auto_login" field.
func (sc *SettingCreate) SetEnableAutoLogin(b bool) *SettingCreate {
	sc.mutation.SetEnableAutoLogin(b)
	return sc
}

// SetNillableEnableAutoLogin sets the "enable_auto_login" field if the given value is not nil.
func (sc *SettingCreate) SetNillableEnableAutoLogin(b *bool) *SettingCreate {
	if b != nil {
		sc.SetEnableAutoLogin(*b)
	}
	return sc
}

// SetDingtalkOauth sets the "dingtalk_oauth" field.
func (sc *SettingCreate) SetDingtalkOauth(to *types.DingtalkOAuth) *SettingCreate {
	sc.mutation.SetDingtalkOauth(to)
	return sc
}

// SetCustomOauth sets the "custom_oauth" field.
func (sc *SettingCreate) SetCustomOauth(to *types.CustomOAuth) *SettingCreate {
	sc.mutation.SetCustomOauth(to)
	return sc
}

// SetBaseURL sets the "base_url" field.
func (sc *SettingCreate) SetBaseURL(s string) *SettingCreate {
	sc.mutation.SetBaseURL(s)
	return sc
}

// SetNillableBaseURL sets the "base_url" field if the given value is not nil.
func (sc *SettingCreate) SetNillableBaseURL(s *string) *SettingCreate {
	if s != nil {
		sc.SetBaseURL(*s)
	}
	return sc
}

// SetCreatedAt sets the "created_at" field.
func (sc *SettingCreate) SetCreatedAt(t time.Time) *SettingCreate {
	sc.mutation.SetCreatedAt(t)
	return sc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (sc *SettingCreate) SetNillableCreatedAt(t *time.Time) *SettingCreate {
	if t != nil {
		sc.SetCreatedAt(*t)
	}
	return sc
}

// SetUpdatedAt sets the "updated_at" field.
func (sc *SettingCreate) SetUpdatedAt(t time.Time) *SettingCreate {
	sc.mutation.SetUpdatedAt(t)
	return sc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (sc *SettingCreate) SetNillableUpdatedAt(t *time.Time) *SettingCreate {
	if t != nil {
		sc.SetUpdatedAt(*t)
	}
	return sc
}

// SetID sets the "id" field.
func (sc *SettingCreate) SetID(u uuid.UUID) *SettingCreate {
	sc.mutation.SetID(u)
	return sc
}

// Mutation returns the SettingMutation object of the builder.
func (sc *SettingCreate) Mutation() *SettingMutation {
	return sc.mutation
}

// Save creates the Setting in the database.
func (sc *SettingCreate) Save(ctx context.Context) (*Setting, error) {
	sc.defaults()
	return withHooks(ctx, sc.sqlSave, sc.mutation, sc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (sc *SettingCreate) SaveX(ctx context.Context) *Setting {
	v, err := sc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (sc *SettingCreate) Exec(ctx context.Context) error {
	_, err := sc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (sc *SettingCreate) ExecX(ctx context.Context) {
	if err := sc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (sc *SettingCreate) defaults() {
	if _, ok := sc.mutation.EnableSSO(); !ok {
		v := setting.DefaultEnableSSO
		sc.mutation.SetEnableSSO(v)
	}
	if _, ok := sc.mutation.ForceTwoFactorAuth(); !ok {
		v := setting.DefaultForceTwoFactorAuth
		sc.mutation.SetForceTwoFactorAuth(v)
	}
	if _, ok := sc.mutation.DisablePasswordLogin(); !ok {
		v := setting.DefaultDisablePasswordLogin
		sc.mutation.SetDisablePasswordLogin(v)
	}
	if _, ok := sc.mutation.EnableAutoLogin(); !ok {
		v := setting.DefaultEnableAutoLogin
		sc.mutation.SetEnableAutoLogin(v)
	}
	if _, ok := sc.mutation.CreatedAt(); !ok {
		v := setting.DefaultCreatedAt()
		sc.mutation.SetCreatedAt(v)
	}
	if _, ok := sc.mutation.UpdatedAt(); !ok {
		v := setting.DefaultUpdatedAt()
		sc.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (sc *SettingCreate) check() error {
	if _, ok := sc.mutation.EnableSSO(); !ok {
		return &ValidationError{Name: "enable_sso", err: errors.New(`db: missing required field "Setting.enable_sso"`)}
	}
	if _, ok := sc.mutation.ForceTwoFactorAuth(); !ok {
		return &ValidationError{Name: "force_two_factor_auth", err: errors.New(`db: missing required field "Setting.force_two_factor_auth"`)}
	}
	if _, ok := sc.mutation.DisablePasswordLogin(); !ok {
		return &ValidationError{Name: "disable_password_login", err: errors.New(`db: missing required field "Setting.disable_password_login"`)}
	}
	if _, ok := sc.mutation.EnableAutoLogin(); !ok {
		return &ValidationError{Name: "enable_auto_login", err: errors.New(`db: missing required field "Setting.enable_auto_login"`)}
	}
	if _, ok := sc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "Setting.created_at"`)}
	}
	if _, ok := sc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "Setting.updated_at"`)}
	}
	return nil
}

func (sc *SettingCreate) sqlSave(ctx context.Context) (*Setting, error) {
	if err := sc.check(); err != nil {
		return nil, err
	}
	_node, _spec := sc.createSpec()
	if err := sqlgraph.CreateNode(ctx, sc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	sc.mutation.id = &_node.ID
	sc.mutation.done = true
	return _node, nil
}

func (sc *SettingCreate) createSpec() (*Setting, *sqlgraph.CreateSpec) {
	var (
		_node = &Setting{config: sc.config}
		_spec = sqlgraph.NewCreateSpec(setting.Table, sqlgraph.NewFieldSpec(setting.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = sc.conflict
	if id, ok := sc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := sc.mutation.EnableSSO(); ok {
		_spec.SetField(setting.FieldEnableSSO, field.TypeBool, value)
		_node.EnableSSO = value
	}
	if value, ok := sc.mutation.ForceTwoFactorAuth(); ok {
		_spec.SetField(setting.FieldForceTwoFactorAuth, field.TypeBool, value)
		_node.ForceTwoFactorAuth = value
	}
	if value, ok := sc.mutation.DisablePasswordLogin(); ok {
		_spec.SetField(setting.FieldDisablePasswordLogin, field.TypeBool, value)
		_node.DisablePasswordLogin = value
	}
	if value, ok := sc.mutation.EnableAutoLogin(); ok {
		_spec.SetField(setting.FieldEnableAutoLogin, field.TypeBool, value)
		_node.EnableAutoLogin = value
	}
	if value, ok := sc.mutation.DingtalkOauth(); ok {
		_spec.SetField(setting.FieldDingtalkOauth, field.TypeJSON, value)
		_node.DingtalkOauth = value
	}
	if value, ok := sc.mutation.CustomOauth(); ok {
		_spec.SetField(setting.FieldCustomOauth, field.TypeJSON, value)
		_node.CustomOauth = value
	}
	if value, ok := sc.mutation.BaseURL(); ok {
		_spec.SetField(setting.FieldBaseURL, field.TypeString, value)
		_node.BaseURL = value
	}
	if value, ok := sc.mutation.CreatedAt(); ok {
		_spec.SetField(setting.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := sc.mutation.UpdatedAt(); ok {
		_spec.SetField(setting.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Setting.Create().
//		SetEnableSSO(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.SettingUpsert) {
//			SetEnableSSO(v+v).
//		}).
//		Exec(ctx)
func (sc *SettingCreate) OnConflict(opts ...sql.ConflictOption) *SettingUpsertOne {
	sc.conflict = opts
	return &SettingUpsertOne{
		create: sc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Setting.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (sc *SettingCreate) OnConflictColumns(columns ...string) *SettingUpsertOne {
	sc.conflict = append(sc.conflict, sql.ConflictColumns(columns...))
	return &SettingUpsertOne{
		create: sc,
	}
}

type (
	// SettingUpsertOne is the builder for "upsert"-ing
	//  one Setting node.
	SettingUpsertOne struct {
		create *SettingCreate
	}

	// SettingUpsert is the "OnConflict" setter.
	SettingUpsert struct {
		*sql.UpdateSet
	}
)

// SetEnableSSO sets the "enable_sso" field.
func (u *SettingUpsert) SetEnableSSO(v bool) *SettingUpsert {
	u.Set(setting.FieldEnableSSO, v)
	return u
}

// UpdateEnableSSO sets the "enable_sso" field to the value that was provided on create.
func (u *SettingUpsert) UpdateEnableSSO() *SettingUpsert {
	u.SetExcluded(setting.FieldEnableSSO)
	return u
}

// SetForceTwoFactorAuth sets the "force_two_factor_auth" field.
func (u *SettingUpsert) SetForceTwoFactorAuth(v bool) *SettingUpsert {
	u.Set(setting.FieldForceTwoFactorAuth, v)
	return u
}

// UpdateForceTwoFactorAuth sets the "force_two_factor_auth" field to the value that was provided on create.
func (u *SettingUpsert) UpdateForceTwoFactorAuth() *SettingUpsert {
	u.SetExcluded(setting.FieldForceTwoFactorAuth)
	return u
}

// SetDisablePasswordLogin sets the "disable_password_login" field.
func (u *SettingUpsert) SetDisablePasswordLogin(v bool) *SettingUpsert {
	u.Set(setting.FieldDisablePasswordLogin, v)
	return u
}

// UpdateDisablePasswordLogin sets the "disable_password_login" field to the value that was provided on create.
func (u *SettingUpsert) UpdateDisablePasswordLogin() *SettingUpsert {
	u.SetExcluded(setting.FieldDisablePasswordLogin)
	return u
}

// SetEnableAutoLogin sets the "enable_auto_login" field.
func (u *SettingUpsert) SetEnableAutoLogin(v bool) *SettingUpsert {
	u.Set(setting.FieldEnableAutoLogin, v)
	return u
}

// UpdateEnableAutoLogin sets the "enable_auto_login" field to the value that was provided on create.
func (u *SettingUpsert) UpdateEnableAutoLogin() *SettingUpsert {
	u.SetExcluded(setting.FieldEnableAutoLogin)
	return u
}

// SetDingtalkOauth sets the "dingtalk_oauth" field.
func (u *SettingUpsert) SetDingtalkOauth(v *types.DingtalkOAuth) *SettingUpsert {
	u.Set(setting.FieldDingtalkOauth, v)
	return u
}

// UpdateDingtalkOauth sets the "dingtalk_oauth" field to the value that was provided on create.
func (u *SettingUpsert) UpdateDingtalkOauth() *SettingUpsert {
	u.SetExcluded(setting.FieldDingtalkOauth)
	return u
}

// ClearDingtalkOauth clears the value of the "dingtalk_oauth" field.
func (u *SettingUpsert) ClearDingtalkOauth() *SettingUpsert {
	u.SetNull(setting.FieldDingtalkOauth)
	return u
}

// SetCustomOauth sets the "custom_oauth" field.
func (u *SettingUpsert) SetCustomOauth(v *types.CustomOAuth) *SettingUpsert {
	u.Set(setting.FieldCustomOauth, v)
	return u
}

// UpdateCustomOauth sets the "custom_oauth" field to the value that was provided on create.
func (u *SettingUpsert) UpdateCustomOauth() *SettingUpsert {
	u.SetExcluded(setting.FieldCustomOauth)
	return u
}

// ClearCustomOauth clears the value of the "custom_oauth" field.
func (u *SettingUpsert) ClearCustomOauth() *SettingUpsert {
	u.SetNull(setting.FieldCustomOauth)
	return u
}

// SetBaseURL sets the "base_url" field.
func (u *SettingUpsert) SetBaseURL(v string) *SettingUpsert {
	u.Set(setting.FieldBaseURL, v)
	return u
}

// UpdateBaseURL sets the "base_url" field to the value that was provided on create.
func (u *SettingUpsert) UpdateBaseURL() *SettingUpsert {
	u.SetExcluded(setting.FieldBaseURL)
	return u
}

// ClearBaseURL clears the value of the "base_url" field.
func (u *SettingUpsert) ClearBaseURL() *SettingUpsert {
	u.SetNull(setting.FieldBaseURL)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *SettingUpsert) SetCreatedAt(v time.Time) *SettingUpsert {
	u.Set(setting.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *SettingUpsert) UpdateCreatedAt() *SettingUpsert {
	u.SetExcluded(setting.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *SettingUpsert) SetUpdatedAt(v time.Time) *SettingUpsert {
	u.Set(setting.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *SettingUpsert) UpdateUpdatedAt() *SettingUpsert {
	u.SetExcluded(setting.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.Setting.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(setting.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *SettingUpsertOne) UpdateNewValues() *SettingUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(setting.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Setting.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *SettingUpsertOne) Ignore() *SettingUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *SettingUpsertOne) DoNothing() *SettingUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the SettingCreate.OnConflict
// documentation for more info.
func (u *SettingUpsertOne) Update(set func(*SettingUpsert)) *SettingUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&SettingUpsert{UpdateSet: update})
	}))
	return u
}

// SetEnableSSO sets the "enable_sso" field.
func (u *SettingUpsertOne) SetEnableSSO(v bool) *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.SetEnableSSO(v)
	})
}

// UpdateEnableSSO sets the "enable_sso" field to the value that was provided on create.
func (u *SettingUpsertOne) UpdateEnableSSO() *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateEnableSSO()
	})
}

// SetForceTwoFactorAuth sets the "force_two_factor_auth" field.
func (u *SettingUpsertOne) SetForceTwoFactorAuth(v bool) *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.SetForceTwoFactorAuth(v)
	})
}

// UpdateForceTwoFactorAuth sets the "force_two_factor_auth" field to the value that was provided on create.
func (u *SettingUpsertOne) UpdateForceTwoFactorAuth() *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateForceTwoFactorAuth()
	})
}

// SetDisablePasswordLogin sets the "disable_password_login" field.
func (u *SettingUpsertOne) SetDisablePasswordLogin(v bool) *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.SetDisablePasswordLogin(v)
	})
}

// UpdateDisablePasswordLogin sets the "disable_password_login" field to the value that was provided on create.
func (u *SettingUpsertOne) UpdateDisablePasswordLogin() *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateDisablePasswordLogin()
	})
}

// SetEnableAutoLogin sets the "enable_auto_login" field.
func (u *SettingUpsertOne) SetEnableAutoLogin(v bool) *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.SetEnableAutoLogin(v)
	})
}

// UpdateEnableAutoLogin sets the "enable_auto_login" field to the value that was provided on create.
func (u *SettingUpsertOne) UpdateEnableAutoLogin() *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateEnableAutoLogin()
	})
}

// SetDingtalkOauth sets the "dingtalk_oauth" field.
func (u *SettingUpsertOne) SetDingtalkOauth(v *types.DingtalkOAuth) *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.SetDingtalkOauth(v)
	})
}

// UpdateDingtalkOauth sets the "dingtalk_oauth" field to the value that was provided on create.
func (u *SettingUpsertOne) UpdateDingtalkOauth() *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateDingtalkOauth()
	})
}

// ClearDingtalkOauth clears the value of the "dingtalk_oauth" field.
func (u *SettingUpsertOne) ClearDingtalkOauth() *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.ClearDingtalkOauth()
	})
}

// SetCustomOauth sets the "custom_oauth" field.
func (u *SettingUpsertOne) SetCustomOauth(v *types.CustomOAuth) *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.SetCustomOauth(v)
	})
}

// UpdateCustomOauth sets the "custom_oauth" field to the value that was provided on create.
func (u *SettingUpsertOne) UpdateCustomOauth() *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateCustomOauth()
	})
}

// ClearCustomOauth clears the value of the "custom_oauth" field.
func (u *SettingUpsertOne) ClearCustomOauth() *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.ClearCustomOauth()
	})
}

// SetBaseURL sets the "base_url" field.
func (u *SettingUpsertOne) SetBaseURL(v string) *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.SetBaseURL(v)
	})
}

// UpdateBaseURL sets the "base_url" field to the value that was provided on create.
func (u *SettingUpsertOne) UpdateBaseURL() *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateBaseURL()
	})
}

// ClearBaseURL clears the value of the "base_url" field.
func (u *SettingUpsertOne) ClearBaseURL() *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.ClearBaseURL()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *SettingUpsertOne) SetCreatedAt(v time.Time) *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *SettingUpsertOne) UpdateCreatedAt() *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *SettingUpsertOne) SetUpdatedAt(v time.Time) *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *SettingUpsertOne) UpdateUpdatedAt() *SettingUpsertOne {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *SettingUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for SettingCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *SettingUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *SettingUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: SettingUpsertOne.ID is not supported by MySQL driver. Use SettingUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *SettingUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// SettingCreateBulk is the builder for creating many Setting entities in bulk.
type SettingCreateBulk struct {
	config
	err      error
	builders []*SettingCreate
	conflict []sql.ConflictOption
}

// Save creates the Setting entities in the database.
func (scb *SettingCreateBulk) Save(ctx context.Context) ([]*Setting, error) {
	if scb.err != nil {
		return nil, scb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(scb.builders))
	nodes := make([]*Setting, len(scb.builders))
	mutators := make([]Mutator, len(scb.builders))
	for i := range scb.builders {
		func(i int, root context.Context) {
			builder := scb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*SettingMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, scb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = scb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, scb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, scb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (scb *SettingCreateBulk) SaveX(ctx context.Context) []*Setting {
	v, err := scb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (scb *SettingCreateBulk) Exec(ctx context.Context) error {
	_, err := scb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (scb *SettingCreateBulk) ExecX(ctx context.Context) {
	if err := scb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Setting.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.SettingUpsert) {
//			SetEnableSSO(v+v).
//		}).
//		Exec(ctx)
func (scb *SettingCreateBulk) OnConflict(opts ...sql.ConflictOption) *SettingUpsertBulk {
	scb.conflict = opts
	return &SettingUpsertBulk{
		create: scb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Setting.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (scb *SettingCreateBulk) OnConflictColumns(columns ...string) *SettingUpsertBulk {
	scb.conflict = append(scb.conflict, sql.ConflictColumns(columns...))
	return &SettingUpsertBulk{
		create: scb,
	}
}

// SettingUpsertBulk is the builder for "upsert"-ing
// a bulk of Setting nodes.
type SettingUpsertBulk struct {
	create *SettingCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.Setting.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(setting.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *SettingUpsertBulk) UpdateNewValues() *SettingUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(setting.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Setting.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *SettingUpsertBulk) Ignore() *SettingUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *SettingUpsertBulk) DoNothing() *SettingUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the SettingCreateBulk.OnConflict
// documentation for more info.
func (u *SettingUpsertBulk) Update(set func(*SettingUpsert)) *SettingUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&SettingUpsert{UpdateSet: update})
	}))
	return u
}

// SetEnableSSO sets the "enable_sso" field.
func (u *SettingUpsertBulk) SetEnableSSO(v bool) *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.SetEnableSSO(v)
	})
}

// UpdateEnableSSO sets the "enable_sso" field to the value that was provided on create.
func (u *SettingUpsertBulk) UpdateEnableSSO() *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateEnableSSO()
	})
}

// SetForceTwoFactorAuth sets the "force_two_factor_auth" field.
func (u *SettingUpsertBulk) SetForceTwoFactorAuth(v bool) *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.SetForceTwoFactorAuth(v)
	})
}

// UpdateForceTwoFactorAuth sets the "force_two_factor_auth" field to the value that was provided on create.
func (u *SettingUpsertBulk) UpdateForceTwoFactorAuth() *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateForceTwoFactorAuth()
	})
}

// SetDisablePasswordLogin sets the "disable_password_login" field.
func (u *SettingUpsertBulk) SetDisablePasswordLogin(v bool) *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.SetDisablePasswordLogin(v)
	})
}

// UpdateDisablePasswordLogin sets the "disable_password_login" field to the value that was provided on create.
func (u *SettingUpsertBulk) UpdateDisablePasswordLogin() *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateDisablePasswordLogin()
	})
}

// SetEnableAutoLogin sets the "enable_auto_login" field.
func (u *SettingUpsertBulk) SetEnableAutoLogin(v bool) *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.SetEnableAutoLogin(v)
	})
}

// UpdateEnableAutoLogin sets the "enable_auto_login" field to the value that was provided on create.
func (u *SettingUpsertBulk) UpdateEnableAutoLogin() *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateEnableAutoLogin()
	})
}

// SetDingtalkOauth sets the "dingtalk_oauth" field.
func (u *SettingUpsertBulk) SetDingtalkOauth(v *types.DingtalkOAuth) *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.SetDingtalkOauth(v)
	})
}

// UpdateDingtalkOauth sets the "dingtalk_oauth" field to the value that was provided on create.
func (u *SettingUpsertBulk) UpdateDingtalkOauth() *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateDingtalkOauth()
	})
}

// ClearDingtalkOauth clears the value of the "dingtalk_oauth" field.
func (u *SettingUpsertBulk) ClearDingtalkOauth() *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.ClearDingtalkOauth()
	})
}

// SetCustomOauth sets the "custom_oauth" field.
func (u *SettingUpsertBulk) SetCustomOauth(v *types.CustomOAuth) *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.SetCustomOauth(v)
	})
}

// UpdateCustomOauth sets the "custom_oauth" field to the value that was provided on create.
func (u *SettingUpsertBulk) UpdateCustomOauth() *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateCustomOauth()
	})
}

// ClearCustomOauth clears the value of the "custom_oauth" field.
func (u *SettingUpsertBulk) ClearCustomOauth() *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.ClearCustomOauth()
	})
}

// SetBaseURL sets the "base_url" field.
func (u *SettingUpsertBulk) SetBaseURL(v string) *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.SetBaseURL(v)
	})
}

// UpdateBaseURL sets the "base_url" field to the value that was provided on create.
func (u *SettingUpsertBulk) UpdateBaseURL() *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateBaseURL()
	})
}

// ClearBaseURL clears the value of the "base_url" field.
func (u *SettingUpsertBulk) ClearBaseURL() *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.ClearBaseURL()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *SettingUpsertBulk) SetCreatedAt(v time.Time) *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *SettingUpsertBulk) UpdateCreatedAt() *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *SettingUpsertBulk) SetUpdatedAt(v time.Time) *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *SettingUpsertBulk) UpdateUpdatedAt() *SettingUpsertBulk {
	return u.Update(func(s *SettingUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *SettingUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the SettingCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for SettingCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *SettingUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
