// Code generated by ent, DO NOT EDIT.

package db

import (
	"encoding/json"
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/setting"
	"github.com/chaitin/MonkeyCode/backend/ent/types"
	"github.com/google/uuid"
)

// Setting is the model entity for the Setting schema.
type Setting struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// EnableSSO holds the value of the "enable_sso" field.
	EnableSSO bool `json:"enable_sso,omitempty"`
	// ForceTwoFactorAuth holds the value of the "force_two_factor_auth" field.
	ForceTwoFactorAuth bool `json:"force_two_factor_auth,omitempty"`
	// DisablePasswordLogin holds the value of the "disable_password_login" field.
	DisablePasswordLogin bool `json:"disable_password_login,omitempty"`
	// EnableAutoLogin holds the value of the "enable_auto_login" field.
	EnableAutoLogin bool `json:"enable_auto_login,omitempty"`
	// DingtalkOauth holds the value of the "dingtalk_oauth" field.
	DingtalkOauth *types.DingtalkOAuth `json:"dingtalk_oauth,omitempty"`
	// CustomOauth holds the value of the "custom_oauth" field.
	CustomOauth *types.CustomOAuth `json:"custom_oauth,omitempty"`
	// BaseURL holds the value of the "base_url" field.
	BaseURL string `json:"base_url,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt    time.Time `json:"updated_at,omitempty"`
	selectValues sql.SelectValues
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Setting) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case setting.FieldDingtalkOauth, setting.FieldCustomOauth:
			values[i] = new([]byte)
		case setting.FieldEnableSSO, setting.FieldForceTwoFactorAuth, setting.FieldDisablePasswordLogin, setting.FieldEnableAutoLogin:
			values[i] = new(sql.NullBool)
		case setting.FieldBaseURL:
			values[i] = new(sql.NullString)
		case setting.FieldCreatedAt, setting.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		case setting.FieldID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Setting fields.
func (s *Setting) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case setting.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				s.ID = *value
			}
		case setting.FieldEnableSSO:
			if value, ok := values[i].(*sql.NullBool); !ok {
				return fmt.Errorf("unexpected type %T for field enable_sso", values[i])
			} else if value.Valid {
				s.EnableSSO = value.Bool
			}
		case setting.FieldForceTwoFactorAuth:
			if value, ok := values[i].(*sql.NullBool); !ok {
				return fmt.Errorf("unexpected type %T for field force_two_factor_auth", values[i])
			} else if value.Valid {
				s.ForceTwoFactorAuth = value.Bool
			}
		case setting.FieldDisablePasswordLogin:
			if value, ok := values[i].(*sql.NullBool); !ok {
				return fmt.Errorf("unexpected type %T for field disable_password_login", values[i])
			} else if value.Valid {
				s.DisablePasswordLogin = value.Bool
			}
		case setting.FieldEnableAutoLogin:
			if value, ok := values[i].(*sql.NullBool); !ok {
				return fmt.Errorf("unexpected type %T for field enable_auto_login", values[i])
			} else if value.Valid {
				s.EnableAutoLogin = value.Bool
			}
		case setting.FieldDingtalkOauth:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field dingtalk_oauth", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &s.DingtalkOauth); err != nil {
					return fmt.Errorf("unmarshal field dingtalk_oauth: %w", err)
				}
			}
		case setting.FieldCustomOauth:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field custom_oauth", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &s.CustomOauth); err != nil {
					return fmt.Errorf("unmarshal field custom_oauth: %w", err)
				}
			}
		case setting.FieldBaseURL:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field base_url", values[i])
			} else if value.Valid {
				s.BaseURL = value.String
			}
		case setting.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				s.CreatedAt = value.Time
			}
		case setting.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				s.UpdatedAt = value.Time
			}
		default:
			s.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the Setting.
// This includes values selected through modifiers, order, etc.
func (s *Setting) Value(name string) (ent.Value, error) {
	return s.selectValues.Get(name)
}

// Update returns a builder for updating this Setting.
// Note that you need to call Setting.Unwrap() before calling this method if this Setting
// was returned from a transaction, and the transaction was committed or rolled back.
func (s *Setting) Update() *SettingUpdateOne {
	return NewSettingClient(s.config).UpdateOne(s)
}

// Unwrap unwraps the Setting entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (s *Setting) Unwrap() *Setting {
	_tx, ok := s.config.driver.(*txDriver)
	if !ok {
		panic("db: Setting is not a transactional entity")
	}
	s.config.driver = _tx.drv
	return s
}

// String implements the fmt.Stringer.
func (s *Setting) String() string {
	var builder strings.Builder
	builder.WriteString("Setting(")
	builder.WriteString(fmt.Sprintf("id=%v, ", s.ID))
	builder.WriteString("enable_sso=")
	builder.WriteString(fmt.Sprintf("%v", s.EnableSSO))
	builder.WriteString(", ")
	builder.WriteString("force_two_factor_auth=")
	builder.WriteString(fmt.Sprintf("%v", s.ForceTwoFactorAuth))
	builder.WriteString(", ")
	builder.WriteString("disable_password_login=")
	builder.WriteString(fmt.Sprintf("%v", s.DisablePasswordLogin))
	builder.WriteString(", ")
	builder.WriteString("enable_auto_login=")
	builder.WriteString(fmt.Sprintf("%v", s.EnableAutoLogin))
	builder.WriteString(", ")
	builder.WriteString("dingtalk_oauth=")
	builder.WriteString(fmt.Sprintf("%v", s.DingtalkOauth))
	builder.WriteString(", ")
	builder.WriteString("custom_oauth=")
	builder.WriteString(fmt.Sprintf("%v", s.CustomOauth))
	builder.WriteString(", ")
	builder.WriteString("base_url=")
	builder.WriteString(s.BaseURL)
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(s.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(s.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// Settings is a parsable slice of Setting.
type Settings []*Setting
