// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent"
	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanning"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanningresult"
	"github.com/google/uuid"
)

// SecurityScanningResultQuery is the builder for querying SecurityScanningResult entities.
type SecurityScanningResultQuery struct {
	config
	ctx                  *QueryContext
	order                []securityscanningresult.OrderOption
	inters               []Interceptor
	predicates           []predicate.SecurityScanningResult
	withSecurityScanning *SecurityScanningQuery
	modifiers            []func(*sql.Selector)
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the SecurityScanningResultQuery builder.
func (ssrq *SecurityScanningResultQuery) Where(ps ...predicate.SecurityScanningResult) *SecurityScanningResultQuery {
	ssrq.predicates = append(ssrq.predicates, ps...)
	return ssrq
}

// Limit the number of records to be returned by this query.
func (ssrq *SecurityScanningResultQuery) Limit(limit int) *SecurityScanningResultQuery {
	ssrq.ctx.Limit = &limit
	return ssrq
}

// Offset to start from.
func (ssrq *SecurityScanningResultQuery) Offset(offset int) *SecurityScanningResultQuery {
	ssrq.ctx.Offset = &offset
	return ssrq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (ssrq *SecurityScanningResultQuery) Unique(unique bool) *SecurityScanningResultQuery {
	ssrq.ctx.Unique = &unique
	return ssrq
}

// Order specifies how the records should be ordered.
func (ssrq *SecurityScanningResultQuery) Order(o ...securityscanningresult.OrderOption) *SecurityScanningResultQuery {
	ssrq.order = append(ssrq.order, o...)
	return ssrq
}

// QuerySecurityScanning chains the current query on the "security_scanning" edge.
func (ssrq *SecurityScanningResultQuery) QuerySecurityScanning() *SecurityScanningQuery {
	query := (&SecurityScanningClient{config: ssrq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := ssrq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := ssrq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(securityscanningresult.Table, securityscanningresult.FieldID, selector),
			sqlgraph.To(securityscanning.Table, securityscanning.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, securityscanningresult.SecurityScanningTable, securityscanningresult.SecurityScanningColumn),
		)
		fromU = sqlgraph.SetNeighbors(ssrq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// First returns the first SecurityScanningResult entity from the query.
// Returns a *NotFoundError when no SecurityScanningResult was found.
func (ssrq *SecurityScanningResultQuery) First(ctx context.Context) (*SecurityScanningResult, error) {
	nodes, err := ssrq.Limit(1).All(setContextOp(ctx, ssrq.ctx, ent.OpQueryFirst))
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{securityscanningresult.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (ssrq *SecurityScanningResultQuery) FirstX(ctx context.Context) *SecurityScanningResult {
	node, err := ssrq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first SecurityScanningResult ID from the query.
// Returns a *NotFoundError when no SecurityScanningResult ID was found.
func (ssrq *SecurityScanningResultQuery) FirstID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = ssrq.Limit(1).IDs(setContextOp(ctx, ssrq.ctx, ent.OpQueryFirstID)); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{securityscanningresult.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (ssrq *SecurityScanningResultQuery) FirstIDX(ctx context.Context) uuid.UUID {
	id, err := ssrq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single SecurityScanningResult entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one SecurityScanningResult entity is found.
// Returns a *NotFoundError when no SecurityScanningResult entities are found.
func (ssrq *SecurityScanningResultQuery) Only(ctx context.Context) (*SecurityScanningResult, error) {
	nodes, err := ssrq.Limit(2).All(setContextOp(ctx, ssrq.ctx, ent.OpQueryOnly))
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{securityscanningresult.Label}
	default:
		return nil, &NotSingularError{securityscanningresult.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (ssrq *SecurityScanningResultQuery) OnlyX(ctx context.Context) *SecurityScanningResult {
	node, err := ssrq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only SecurityScanningResult ID in the query.
// Returns a *NotSingularError when more than one SecurityScanningResult ID is found.
// Returns a *NotFoundError when no entities are found.
func (ssrq *SecurityScanningResultQuery) OnlyID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = ssrq.Limit(2).IDs(setContextOp(ctx, ssrq.ctx, ent.OpQueryOnlyID)); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{securityscanningresult.Label}
	default:
		err = &NotSingularError{securityscanningresult.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (ssrq *SecurityScanningResultQuery) OnlyIDX(ctx context.Context) uuid.UUID {
	id, err := ssrq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of SecurityScanningResults.
func (ssrq *SecurityScanningResultQuery) All(ctx context.Context) ([]*SecurityScanningResult, error) {
	ctx = setContextOp(ctx, ssrq.ctx, ent.OpQueryAll)
	if err := ssrq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	qr := querierAll[[]*SecurityScanningResult, *SecurityScanningResultQuery]()
	return withInterceptors[[]*SecurityScanningResult](ctx, ssrq, qr, ssrq.inters)
}

// AllX is like All, but panics if an error occurs.
func (ssrq *SecurityScanningResultQuery) AllX(ctx context.Context) []*SecurityScanningResult {
	nodes, err := ssrq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of SecurityScanningResult IDs.
func (ssrq *SecurityScanningResultQuery) IDs(ctx context.Context) (ids []uuid.UUID, err error) {
	if ssrq.ctx.Unique == nil && ssrq.path != nil {
		ssrq.Unique(true)
	}
	ctx = setContextOp(ctx, ssrq.ctx, ent.OpQueryIDs)
	if err = ssrq.Select(securityscanningresult.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (ssrq *SecurityScanningResultQuery) IDsX(ctx context.Context) []uuid.UUID {
	ids, err := ssrq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (ssrq *SecurityScanningResultQuery) Count(ctx context.Context) (int, error) {
	ctx = setContextOp(ctx, ssrq.ctx, ent.OpQueryCount)
	if err := ssrq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return withInterceptors[int](ctx, ssrq, querierCount[*SecurityScanningResultQuery](), ssrq.inters)
}

// CountX is like Count, but panics if an error occurs.
func (ssrq *SecurityScanningResultQuery) CountX(ctx context.Context) int {
	count, err := ssrq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (ssrq *SecurityScanningResultQuery) Exist(ctx context.Context) (bool, error) {
	ctx = setContextOp(ctx, ssrq.ctx, ent.OpQueryExist)
	switch _, err := ssrq.FirstID(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("db: check existence: %w", err)
	default:
		return true, nil
	}
}

// ExistX is like Exist, but panics if an error occurs.
func (ssrq *SecurityScanningResultQuery) ExistX(ctx context.Context) bool {
	exist, err := ssrq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the SecurityScanningResultQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (ssrq *SecurityScanningResultQuery) Clone() *SecurityScanningResultQuery {
	if ssrq == nil {
		return nil
	}
	return &SecurityScanningResultQuery{
		config:               ssrq.config,
		ctx:                  ssrq.ctx.Clone(),
		order:                append([]securityscanningresult.OrderOption{}, ssrq.order...),
		inters:               append([]Interceptor{}, ssrq.inters...),
		predicates:           append([]predicate.SecurityScanningResult{}, ssrq.predicates...),
		withSecurityScanning: ssrq.withSecurityScanning.Clone(),
		// clone intermediate query.
		sql:       ssrq.sql.Clone(),
		path:      ssrq.path,
		modifiers: append([]func(*sql.Selector){}, ssrq.modifiers...),
	}
}

// WithSecurityScanning tells the query-builder to eager-load the nodes that are connected to
// the "security_scanning" edge. The optional arguments are used to configure the query builder of the edge.
func (ssrq *SecurityScanningResultQuery) WithSecurityScanning(opts ...func(*SecurityScanningQuery)) *SecurityScanningResultQuery {
	query := (&SecurityScanningClient{config: ssrq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	ssrq.withSecurityScanning = query
	return ssrq
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		SecurityScanningID uuid.UUID `json:"security_scanning_id,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.SecurityScanningResult.Query().
//		GroupBy(securityscanningresult.FieldSecurityScanningID).
//		Aggregate(db.Count()).
//		Scan(ctx, &v)
func (ssrq *SecurityScanningResultQuery) GroupBy(field string, fields ...string) *SecurityScanningResultGroupBy {
	ssrq.ctx.Fields = append([]string{field}, fields...)
	grbuild := &SecurityScanningResultGroupBy{build: ssrq}
	grbuild.flds = &ssrq.ctx.Fields
	grbuild.label = securityscanningresult.Label
	grbuild.scan = grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		SecurityScanningID uuid.UUID `json:"security_scanning_id,omitempty"`
//	}
//
//	client.SecurityScanningResult.Query().
//		Select(securityscanningresult.FieldSecurityScanningID).
//		Scan(ctx, &v)
func (ssrq *SecurityScanningResultQuery) Select(fields ...string) *SecurityScanningResultSelect {
	ssrq.ctx.Fields = append(ssrq.ctx.Fields, fields...)
	sbuild := &SecurityScanningResultSelect{SecurityScanningResultQuery: ssrq}
	sbuild.label = securityscanningresult.Label
	sbuild.flds, sbuild.scan = &ssrq.ctx.Fields, sbuild.Scan
	return sbuild
}

// Aggregate returns a SecurityScanningResultSelect configured with the given aggregations.
func (ssrq *SecurityScanningResultQuery) Aggregate(fns ...AggregateFunc) *SecurityScanningResultSelect {
	return ssrq.Select().Aggregate(fns...)
}

func (ssrq *SecurityScanningResultQuery) prepareQuery(ctx context.Context) error {
	for _, inter := range ssrq.inters {
		if inter == nil {
			return fmt.Errorf("db: uninitialized interceptor (forgotten import db/runtime?)")
		}
		if trv, ok := inter.(Traverser); ok {
			if err := trv.Traverse(ctx, ssrq); err != nil {
				return err
			}
		}
	}
	for _, f := range ssrq.ctx.Fields {
		if !securityscanningresult.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
		}
	}
	if ssrq.path != nil {
		prev, err := ssrq.path(ctx)
		if err != nil {
			return err
		}
		ssrq.sql = prev
	}
	return nil
}

func (ssrq *SecurityScanningResultQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*SecurityScanningResult, error) {
	var (
		nodes       = []*SecurityScanningResult{}
		_spec       = ssrq.querySpec()
		loadedTypes = [1]bool{
			ssrq.withSecurityScanning != nil,
		}
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*SecurityScanningResult).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &SecurityScanningResult{config: ssrq.config}
		nodes = append(nodes, node)
		node.Edges.loadedTypes = loadedTypes
		return node.assignValues(columns, values)
	}
	if len(ssrq.modifiers) > 0 {
		_spec.Modifiers = ssrq.modifiers
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, ssrq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	if query := ssrq.withSecurityScanning; query != nil {
		if err := ssrq.loadSecurityScanning(ctx, query, nodes, nil,
			func(n *SecurityScanningResult, e *SecurityScanning) { n.Edges.SecurityScanning = e }); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

func (ssrq *SecurityScanningResultQuery) loadSecurityScanning(ctx context.Context, query *SecurityScanningQuery, nodes []*SecurityScanningResult, init func(*SecurityScanningResult), assign func(*SecurityScanningResult, *SecurityScanning)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*SecurityScanningResult)
	for i := range nodes {
		fk := nodes[i].SecurityScanningID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(securityscanning.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "security_scanning_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}

func (ssrq *SecurityScanningResultQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := ssrq.querySpec()
	if len(ssrq.modifiers) > 0 {
		_spec.Modifiers = ssrq.modifiers
	}
	_spec.Node.Columns = ssrq.ctx.Fields
	if len(ssrq.ctx.Fields) > 0 {
		_spec.Unique = ssrq.ctx.Unique != nil && *ssrq.ctx.Unique
	}
	return sqlgraph.CountNodes(ctx, ssrq.driver, _spec)
}

func (ssrq *SecurityScanningResultQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := sqlgraph.NewQuerySpec(securityscanningresult.Table, securityscanningresult.Columns, sqlgraph.NewFieldSpec(securityscanningresult.FieldID, field.TypeUUID))
	_spec.From = ssrq.sql
	if unique := ssrq.ctx.Unique; unique != nil {
		_spec.Unique = *unique
	} else if ssrq.path != nil {
		_spec.Unique = true
	}
	if fields := ssrq.ctx.Fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, securityscanningresult.FieldID)
		for i := range fields {
			if fields[i] != securityscanningresult.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
		if ssrq.withSecurityScanning != nil {
			_spec.Node.AddColumnOnce(securityscanningresult.FieldSecurityScanningID)
		}
	}
	if ps := ssrq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := ssrq.ctx.Limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := ssrq.ctx.Offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := ssrq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (ssrq *SecurityScanningResultQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(ssrq.driver.Dialect())
	t1 := builder.Table(securityscanningresult.Table)
	columns := ssrq.ctx.Fields
	if len(columns) == 0 {
		columns = securityscanningresult.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if ssrq.sql != nil {
		selector = ssrq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if ssrq.ctx.Unique != nil && *ssrq.ctx.Unique {
		selector.Distinct()
	}
	for _, m := range ssrq.modifiers {
		m(selector)
	}
	for _, p := range ssrq.predicates {
		p(selector)
	}
	for _, p := range ssrq.order {
		p(selector)
	}
	if offset := ssrq.ctx.Offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := ssrq.ctx.Limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// ForUpdate locks the selected rows against concurrent updates, and prevent them from being
// updated, deleted or "selected ... for update" by other sessions, until the transaction is
// either committed or rolled-back.
func (ssrq *SecurityScanningResultQuery) ForUpdate(opts ...sql.LockOption) *SecurityScanningResultQuery {
	if ssrq.driver.Dialect() == dialect.Postgres {
		ssrq.Unique(false)
	}
	ssrq.modifiers = append(ssrq.modifiers, func(s *sql.Selector) {
		s.ForUpdate(opts...)
	})
	return ssrq
}

// ForShare behaves similarly to ForUpdate, except that it acquires a shared mode lock
// on any rows that are read. Other sessions can read the rows, but cannot modify them
// until your transaction commits.
func (ssrq *SecurityScanningResultQuery) ForShare(opts ...sql.LockOption) *SecurityScanningResultQuery {
	if ssrq.driver.Dialect() == dialect.Postgres {
		ssrq.Unique(false)
	}
	ssrq.modifiers = append(ssrq.modifiers, func(s *sql.Selector) {
		s.ForShare(opts...)
	})
	return ssrq
}

// Modify adds a query modifier for attaching custom logic to queries.
func (ssrq *SecurityScanningResultQuery) Modify(modifiers ...func(s *sql.Selector)) *SecurityScanningResultSelect {
	ssrq.modifiers = append(ssrq.modifiers, modifiers...)
	return ssrq.Select()
}

// SecurityScanningResultGroupBy is the group-by builder for SecurityScanningResult entities.
type SecurityScanningResultGroupBy struct {
	selector
	build *SecurityScanningResultQuery
}

// Aggregate adds the given aggregation functions to the group-by query.
func (ssrgb *SecurityScanningResultGroupBy) Aggregate(fns ...AggregateFunc) *SecurityScanningResultGroupBy {
	ssrgb.fns = append(ssrgb.fns, fns...)
	return ssrgb
}

// Scan applies the selector query and scans the result into the given value.
func (ssrgb *SecurityScanningResultGroupBy) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, ssrgb.build.ctx, ent.OpQueryGroupBy)
	if err := ssrgb.build.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*SecurityScanningResultQuery, *SecurityScanningResultGroupBy](ctx, ssrgb.build, ssrgb, ssrgb.build.inters, v)
}

func (ssrgb *SecurityScanningResultGroupBy) sqlScan(ctx context.Context, root *SecurityScanningResultQuery, v any) error {
	selector := root.sqlQuery(ctx).Select()
	aggregation := make([]string, 0, len(ssrgb.fns))
	for _, fn := range ssrgb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(*ssrgb.flds)+len(ssrgb.fns))
		for _, f := range *ssrgb.flds {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	selector.GroupBy(selector.Columns(*ssrgb.flds...)...)
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := ssrgb.build.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// SecurityScanningResultSelect is the builder for selecting fields of SecurityScanningResult entities.
type SecurityScanningResultSelect struct {
	*SecurityScanningResultQuery
	selector
}

// Aggregate adds the given aggregation functions to the selector query.
func (ssrs *SecurityScanningResultSelect) Aggregate(fns ...AggregateFunc) *SecurityScanningResultSelect {
	ssrs.fns = append(ssrs.fns, fns...)
	return ssrs
}

// Scan applies the selector query and scans the result into the given value.
func (ssrs *SecurityScanningResultSelect) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, ssrs.ctx, ent.OpQuerySelect)
	if err := ssrs.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*SecurityScanningResultQuery, *SecurityScanningResultSelect](ctx, ssrs.SecurityScanningResultQuery, ssrs, ssrs.inters, v)
}

func (ssrs *SecurityScanningResultSelect) sqlScan(ctx context.Context, root *SecurityScanningResultQuery, v any) error {
	selector := root.sqlQuery(ctx)
	aggregation := make([]string, 0, len(ssrs.fns))
	for _, fn := range ssrs.fns {
		aggregation = append(aggregation, fn(selector))
	}
	switch n := len(*ssrs.selector.flds); {
	case n == 0 && len(aggregation) > 0:
		selector.Select(aggregation...)
	case n != 0 && len(aggregation) > 0:
		selector.AppendSelect(aggregation...)
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := ssrs.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// Modify adds a query modifier for attaching custom logic to queries.
func (ssrs *SecurityScanningResultSelect) Modify(modifiers ...func(s *sql.Selector)) *SecurityScanningResultSelect {
	ssrs.modifiers = append(ssrs.modifiers, modifiers...)
	return ssrs
}
