// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanningresult"
)

// SecurityScanningResultDelete is the builder for deleting a SecurityScanningResult entity.
type SecurityScanningResultDelete struct {
	config
	hooks    []Hook
	mutation *SecurityScanningResultMutation
}

// Where appends a list predicates to the SecurityScanningResultDelete builder.
func (ssrd *SecurityScanningResultDelete) Where(ps ...predicate.SecurityScanningResult) *SecurityScanningResultDelete {
	ssrd.mutation.Where(ps...)
	return ssrd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (ssrd *SecurityScanningResultDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, ssrd.sqlExec, ssrd.mutation, ssrd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (ssrd *SecurityScanningResultDelete) ExecX(ctx context.Context) int {
	n, err := ssrd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (ssrd *SecurityScanningResultDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(securityscanningresult.Table, sqlgraph.NewFieldSpec(securityscanningresult.FieldID, field.TypeUUID))
	if ps := ssrd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, ssrd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	ssrd.mutation.done = true
	return affected, err
}

// SecurityScanningResultDeleteOne is the builder for deleting a single SecurityScanningResult entity.
type SecurityScanningResultDeleteOne struct {
	ssrd *SecurityScanningResultDelete
}

// Where appends a list predicates to the SecurityScanningResultDelete builder.
func (ssrdo *SecurityScanningResultDeleteOne) Where(ps ...predicate.SecurityScanningResult) *SecurityScanningResultDeleteOne {
	ssrdo.ssrd.mutation.Where(ps...)
	return ssrdo
}

// Exec executes the deletion query.
func (ssrdo *SecurityScanningResultDeleteOne) Exec(ctx context.Context) error {
	n, err := ssrdo.ssrd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{securityscanningresult.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (ssrdo *SecurityScanningResultDeleteOne) ExecX(ctx context.Context) {
	if err := ssrdo.Exec(ctx); err != nil {
		panic(err)
	}
}
