// Code generated by ent, DO NOT EDIT.

package db

import (
	"encoding/json"
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanning"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanningresult"
	"github.com/chaitin/MonkeyCode/backend/ent/types"
	"github.com/google/uuid"
)

// SecurityScanningResult is the model entity for the SecurityScanningResult schema.
type SecurityScanningResult struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// SecurityScanningID holds the value of the "security_scanning_id" field.
	SecurityScanningID uuid.UUID `json:"security_scanning_id,omitempty"`
	// CheckID holds the value of the "check_id" field.
	CheckID string `json:"check_id,omitempty"`
	// EngineKind holds the value of the "engine_kind" field.
	EngineKind string `json:"engine_kind,omitempty"`
	// Lines holds the value of the "lines" field.
	Lines string `json:"lines,omitempty"`
	// Path holds the value of the "path" field.
	Path string `json:"path,omitempty"`
	// Message holds the value of the "message" field.
	Message string `json:"message,omitempty"`
	// MessageZh holds the value of the "message_zh" field.
	MessageZh string `json:"message_zh,omitempty"`
	// Severity holds the value of the "severity" field.
	Severity string `json:"severity,omitempty"`
	// AbstractEn holds the value of the "abstract_en" field.
	AbstractEn string `json:"abstract_en,omitempty"`
	// AbstractZh holds the value of the "abstract_zh" field.
	AbstractZh string `json:"abstract_zh,omitempty"`
	// CategoryEn holds the value of the "category_en" field.
	CategoryEn string `json:"category_en,omitempty"`
	// CategoryZh holds the value of the "category_zh" field.
	CategoryZh string `json:"category_zh,omitempty"`
	// Confidence holds the value of the "confidence" field.
	Confidence string `json:"confidence,omitempty"`
	// Cwe holds the value of the "cwe" field.
	Cwe []interface{} `json:"cwe,omitempty"`
	// Impact holds the value of the "impact" field.
	Impact string `json:"impact,omitempty"`
	// Owasp holds the value of the "owasp" field.
	Owasp []interface{} `json:"owasp,omitempty"`
	// FileContent holds the value of the "file_content" field.
	FileContent string `json:"file_content,omitempty"`
	// StartPosition holds the value of the "start_position" field.
	StartPosition *types.Position `json:"start_position,omitempty"`
	// EndPosition holds the value of the "end_position" field.
	EndPosition *types.Position `json:"end_position,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the SecurityScanningResultQuery when eager-loading is set.
	Edges        SecurityScanningResultEdges `json:"edges"`
	selectValues sql.SelectValues
}

// SecurityScanningResultEdges holds the relations/edges for other nodes in the graph.
type SecurityScanningResultEdges struct {
	// SecurityScanning holds the value of the security_scanning edge.
	SecurityScanning *SecurityScanning `json:"security_scanning,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [1]bool
}

// SecurityScanningOrErr returns the SecurityScanning value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e SecurityScanningResultEdges) SecurityScanningOrErr() (*SecurityScanning, error) {
	if e.SecurityScanning != nil {
		return e.SecurityScanning, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: securityscanning.Label}
	}
	return nil, &NotLoadedError{edge: "security_scanning"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*SecurityScanningResult) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case securityscanningresult.FieldCwe, securityscanningresult.FieldOwasp, securityscanningresult.FieldStartPosition, securityscanningresult.FieldEndPosition:
			values[i] = new([]byte)
		case securityscanningresult.FieldCheckID, securityscanningresult.FieldEngineKind, securityscanningresult.FieldLines, securityscanningresult.FieldPath, securityscanningresult.FieldMessage, securityscanningresult.FieldMessageZh, securityscanningresult.FieldSeverity, securityscanningresult.FieldAbstractEn, securityscanningresult.FieldAbstractZh, securityscanningresult.FieldCategoryEn, securityscanningresult.FieldCategoryZh, securityscanningresult.FieldConfidence, securityscanningresult.FieldImpact, securityscanningresult.FieldFileContent:
			values[i] = new(sql.NullString)
		case securityscanningresult.FieldCreatedAt:
			values[i] = new(sql.NullTime)
		case securityscanningresult.FieldID, securityscanningresult.FieldSecurityScanningID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the SecurityScanningResult fields.
func (ssr *SecurityScanningResult) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case securityscanningresult.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				ssr.ID = *value
			}
		case securityscanningresult.FieldSecurityScanningID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field security_scanning_id", values[i])
			} else if value != nil {
				ssr.SecurityScanningID = *value
			}
		case securityscanningresult.FieldCheckID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field check_id", values[i])
			} else if value.Valid {
				ssr.CheckID = value.String
			}
		case securityscanningresult.FieldEngineKind:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field engine_kind", values[i])
			} else if value.Valid {
				ssr.EngineKind = value.String
			}
		case securityscanningresult.FieldLines:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field lines", values[i])
			} else if value.Valid {
				ssr.Lines = value.String
			}
		case securityscanningresult.FieldPath:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field path", values[i])
			} else if value.Valid {
				ssr.Path = value.String
			}
		case securityscanningresult.FieldMessage:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field message", values[i])
			} else if value.Valid {
				ssr.Message = value.String
			}
		case securityscanningresult.FieldMessageZh:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field message_zh", values[i])
			} else if value.Valid {
				ssr.MessageZh = value.String
			}
		case securityscanningresult.FieldSeverity:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field severity", values[i])
			} else if value.Valid {
				ssr.Severity = value.String
			}
		case securityscanningresult.FieldAbstractEn:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field abstract_en", values[i])
			} else if value.Valid {
				ssr.AbstractEn = value.String
			}
		case securityscanningresult.FieldAbstractZh:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field abstract_zh", values[i])
			} else if value.Valid {
				ssr.AbstractZh = value.String
			}
		case securityscanningresult.FieldCategoryEn:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field category_en", values[i])
			} else if value.Valid {
				ssr.CategoryEn = value.String
			}
		case securityscanningresult.FieldCategoryZh:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field category_zh", values[i])
			} else if value.Valid {
				ssr.CategoryZh = value.String
			}
		case securityscanningresult.FieldConfidence:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field confidence", values[i])
			} else if value.Valid {
				ssr.Confidence = value.String
			}
		case securityscanningresult.FieldCwe:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field cwe", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &ssr.Cwe); err != nil {
					return fmt.Errorf("unmarshal field cwe: %w", err)
				}
			}
		case securityscanningresult.FieldImpact:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field impact", values[i])
			} else if value.Valid {
				ssr.Impact = value.String
			}
		case securityscanningresult.FieldOwasp:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field owasp", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &ssr.Owasp); err != nil {
					return fmt.Errorf("unmarshal field owasp: %w", err)
				}
			}
		case securityscanningresult.FieldFileContent:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field file_content", values[i])
			} else if value.Valid {
				ssr.FileContent = value.String
			}
		case securityscanningresult.FieldStartPosition:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field start_position", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &ssr.StartPosition); err != nil {
					return fmt.Errorf("unmarshal field start_position: %w", err)
				}
			}
		case securityscanningresult.FieldEndPosition:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field end_position", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &ssr.EndPosition); err != nil {
					return fmt.Errorf("unmarshal field end_position: %w", err)
				}
			}
		case securityscanningresult.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				ssr.CreatedAt = value.Time
			}
		default:
			ssr.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the SecurityScanningResult.
// This includes values selected through modifiers, order, etc.
func (ssr *SecurityScanningResult) Value(name string) (ent.Value, error) {
	return ssr.selectValues.Get(name)
}

// QuerySecurityScanning queries the "security_scanning" edge of the SecurityScanningResult entity.
func (ssr *SecurityScanningResult) QuerySecurityScanning() *SecurityScanningQuery {
	return NewSecurityScanningResultClient(ssr.config).QuerySecurityScanning(ssr)
}

// Update returns a builder for updating this SecurityScanningResult.
// Note that you need to call SecurityScanningResult.Unwrap() before calling this method if this SecurityScanningResult
// was returned from a transaction, and the transaction was committed or rolled back.
func (ssr *SecurityScanningResult) Update() *SecurityScanningResultUpdateOne {
	return NewSecurityScanningResultClient(ssr.config).UpdateOne(ssr)
}

// Unwrap unwraps the SecurityScanningResult entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (ssr *SecurityScanningResult) Unwrap() *SecurityScanningResult {
	_tx, ok := ssr.config.driver.(*txDriver)
	if !ok {
		panic("db: SecurityScanningResult is not a transactional entity")
	}
	ssr.config.driver = _tx.drv
	return ssr
}

// String implements the fmt.Stringer.
func (ssr *SecurityScanningResult) String() string {
	var builder strings.Builder
	builder.WriteString("SecurityScanningResult(")
	builder.WriteString(fmt.Sprintf("id=%v, ", ssr.ID))
	builder.WriteString("security_scanning_id=")
	builder.WriteString(fmt.Sprintf("%v", ssr.SecurityScanningID))
	builder.WriteString(", ")
	builder.WriteString("check_id=")
	builder.WriteString(ssr.CheckID)
	builder.WriteString(", ")
	builder.WriteString("engine_kind=")
	builder.WriteString(ssr.EngineKind)
	builder.WriteString(", ")
	builder.WriteString("lines=")
	builder.WriteString(ssr.Lines)
	builder.WriteString(", ")
	builder.WriteString("path=")
	builder.WriteString(ssr.Path)
	builder.WriteString(", ")
	builder.WriteString("message=")
	builder.WriteString(ssr.Message)
	builder.WriteString(", ")
	builder.WriteString("message_zh=")
	builder.WriteString(ssr.MessageZh)
	builder.WriteString(", ")
	builder.WriteString("severity=")
	builder.WriteString(ssr.Severity)
	builder.WriteString(", ")
	builder.WriteString("abstract_en=")
	builder.WriteString(ssr.AbstractEn)
	builder.WriteString(", ")
	builder.WriteString("abstract_zh=")
	builder.WriteString(ssr.AbstractZh)
	builder.WriteString(", ")
	builder.WriteString("category_en=")
	builder.WriteString(ssr.CategoryEn)
	builder.WriteString(", ")
	builder.WriteString("category_zh=")
	builder.WriteString(ssr.CategoryZh)
	builder.WriteString(", ")
	builder.WriteString("confidence=")
	builder.WriteString(ssr.Confidence)
	builder.WriteString(", ")
	builder.WriteString("cwe=")
	builder.WriteString(fmt.Sprintf("%v", ssr.Cwe))
	builder.WriteString(", ")
	builder.WriteString("impact=")
	builder.WriteString(ssr.Impact)
	builder.WriteString(", ")
	builder.WriteString("owasp=")
	builder.WriteString(fmt.Sprintf("%v", ssr.Owasp))
	builder.WriteString(", ")
	builder.WriteString("file_content=")
	builder.WriteString(ssr.FileContent)
	builder.WriteString(", ")
	builder.WriteString("start_position=")
	builder.WriteString(fmt.Sprintf("%v", ssr.StartPosition))
	builder.WriteString(", ")
	builder.WriteString("end_position=")
	builder.WriteString(fmt.Sprintf("%v", ssr.EndPosition))
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(ssr.CreatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// SecurityScanningResults is a parsable slice of SecurityScanningResult.
type SecurityScanningResults []*SecurityScanningResult
