// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanning"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanningresult"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/workspace"
	"github.com/google/uuid"
)

// SecurityScanningUpdate is the builder for updating SecurityScanning entities.
type SecurityScanningUpdate struct {
	config
	hooks     []Hook
	mutation  *SecurityScanningMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the SecurityScanningUpdate builder.
func (ssu *SecurityScanningUpdate) Where(ps ...predicate.SecurityScanning) *SecurityScanningUpdate {
	ssu.mutation.Where(ps...)
	return ssu
}

// SetUserID sets the "user_id" field.
func (ssu *SecurityScanningUpdate) SetUserID(u uuid.UUID) *SecurityScanningUpdate {
	ssu.mutation.SetUserID(u)
	return ssu
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (ssu *SecurityScanningUpdate) SetNillableUserID(u *uuid.UUID) *SecurityScanningUpdate {
	if u != nil {
		ssu.SetUserID(*u)
	}
	return ssu
}

// SetWorkspaceID sets the "workspace_id" field.
func (ssu *SecurityScanningUpdate) SetWorkspaceID(u uuid.UUID) *SecurityScanningUpdate {
	ssu.mutation.SetWorkspaceID(u)
	return ssu
}

// SetNillableWorkspaceID sets the "workspace_id" field if the given value is not nil.
func (ssu *SecurityScanningUpdate) SetNillableWorkspaceID(u *uuid.UUID) *SecurityScanningUpdate {
	if u != nil {
		ssu.SetWorkspaceID(*u)
	}
	return ssu
}

// SetStatus sets the "status" field.
func (ssu *SecurityScanningUpdate) SetStatus(css consts.SecurityScanningStatus) *SecurityScanningUpdate {
	ssu.mutation.SetStatus(css)
	return ssu
}

// SetNillableStatus sets the "status" field if the given value is not nil.
func (ssu *SecurityScanningUpdate) SetNillableStatus(css *consts.SecurityScanningStatus) *SecurityScanningUpdate {
	if css != nil {
		ssu.SetStatus(*css)
	}
	return ssu
}

// SetWorkspace sets the "workspace" field.
func (ssu *SecurityScanningUpdate) SetWorkspace(s string) *SecurityScanningUpdate {
	ssu.mutation.SetWorkspace(s)
	return ssu
}

// SetNillableWorkspace sets the "workspace" field if the given value is not nil.
func (ssu *SecurityScanningUpdate) SetNillableWorkspace(s *string) *SecurityScanningUpdate {
	if s != nil {
		ssu.SetWorkspace(*s)
	}
	return ssu
}

// SetLanguage sets the "language" field.
func (ssu *SecurityScanningUpdate) SetLanguage(csl consts.SecurityScanningLanguage) *SecurityScanningUpdate {
	ssu.mutation.SetLanguage(csl)
	return ssu
}

// SetNillableLanguage sets the "language" field if the given value is not nil.
func (ssu *SecurityScanningUpdate) SetNillableLanguage(csl *consts.SecurityScanningLanguage) *SecurityScanningUpdate {
	if csl != nil {
		ssu.SetLanguage(*csl)
	}
	return ssu
}

// SetRule sets the "rule" field.
func (ssu *SecurityScanningUpdate) SetRule(s string) *SecurityScanningUpdate {
	ssu.mutation.SetRule(s)
	return ssu
}

// SetNillableRule sets the "rule" field if the given value is not nil.
func (ssu *SecurityScanningUpdate) SetNillableRule(s *string) *SecurityScanningUpdate {
	if s != nil {
		ssu.SetRule(*s)
	}
	return ssu
}

// ClearRule clears the value of the "rule" field.
func (ssu *SecurityScanningUpdate) ClearRule() *SecurityScanningUpdate {
	ssu.mutation.ClearRule()
	return ssu
}

// SetErrorMessage sets the "error_message" field.
func (ssu *SecurityScanningUpdate) SetErrorMessage(s string) *SecurityScanningUpdate {
	ssu.mutation.SetErrorMessage(s)
	return ssu
}

// SetNillableErrorMessage sets the "error_message" field if the given value is not nil.
func (ssu *SecurityScanningUpdate) SetNillableErrorMessage(s *string) *SecurityScanningUpdate {
	if s != nil {
		ssu.SetErrorMessage(*s)
	}
	return ssu
}

// ClearErrorMessage clears the value of the "error_message" field.
func (ssu *SecurityScanningUpdate) ClearErrorMessage() *SecurityScanningUpdate {
	ssu.mutation.ClearErrorMessage()
	return ssu
}

// SetCreatedAt sets the "created_at" field.
func (ssu *SecurityScanningUpdate) SetCreatedAt(t time.Time) *SecurityScanningUpdate {
	ssu.mutation.SetCreatedAt(t)
	return ssu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ssu *SecurityScanningUpdate) SetNillableCreatedAt(t *time.Time) *SecurityScanningUpdate {
	if t != nil {
		ssu.SetCreatedAt(*t)
	}
	return ssu
}

// SetUpdatedAt sets the "updated_at" field.
func (ssu *SecurityScanningUpdate) SetUpdatedAt(t time.Time) *SecurityScanningUpdate {
	ssu.mutation.SetUpdatedAt(t)
	return ssu
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (ssu *SecurityScanningUpdate) SetNillableUpdatedAt(t *time.Time) *SecurityScanningUpdate {
	if t != nil {
		ssu.SetUpdatedAt(*t)
	}
	return ssu
}

// SetUser sets the "user" edge to the User entity.
func (ssu *SecurityScanningUpdate) SetUser(u *User) *SecurityScanningUpdate {
	return ssu.SetUserID(u.ID)
}

// AddResultIDs adds the "results" edge to the SecurityScanningResult entity by IDs.
func (ssu *SecurityScanningUpdate) AddResultIDs(ids ...uuid.UUID) *SecurityScanningUpdate {
	ssu.mutation.AddResultIDs(ids...)
	return ssu
}

// AddResults adds the "results" edges to the SecurityScanningResult entity.
func (ssu *SecurityScanningUpdate) AddResults(s ...*SecurityScanningResult) *SecurityScanningUpdate {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return ssu.AddResultIDs(ids...)
}

// SetWorkspaceEdgeID sets the "workspace_edge" edge to the Workspace entity by ID.
func (ssu *SecurityScanningUpdate) SetWorkspaceEdgeID(id uuid.UUID) *SecurityScanningUpdate {
	ssu.mutation.SetWorkspaceEdgeID(id)
	return ssu
}

// SetWorkspaceEdge sets the "workspace_edge" edge to the Workspace entity.
func (ssu *SecurityScanningUpdate) SetWorkspaceEdge(w *Workspace) *SecurityScanningUpdate {
	return ssu.SetWorkspaceEdgeID(w.ID)
}

// Mutation returns the SecurityScanningMutation object of the builder.
func (ssu *SecurityScanningUpdate) Mutation() *SecurityScanningMutation {
	return ssu.mutation
}

// ClearUser clears the "user" edge to the User entity.
func (ssu *SecurityScanningUpdate) ClearUser() *SecurityScanningUpdate {
	ssu.mutation.ClearUser()
	return ssu
}

// ClearResults clears all "results" edges to the SecurityScanningResult entity.
func (ssu *SecurityScanningUpdate) ClearResults() *SecurityScanningUpdate {
	ssu.mutation.ClearResults()
	return ssu
}

// RemoveResultIDs removes the "results" edge to SecurityScanningResult entities by IDs.
func (ssu *SecurityScanningUpdate) RemoveResultIDs(ids ...uuid.UUID) *SecurityScanningUpdate {
	ssu.mutation.RemoveResultIDs(ids...)
	return ssu
}

// RemoveResults removes "results" edges to SecurityScanningResult entities.
func (ssu *SecurityScanningUpdate) RemoveResults(s ...*SecurityScanningResult) *SecurityScanningUpdate {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return ssu.RemoveResultIDs(ids...)
}

// ClearWorkspaceEdge clears the "workspace_edge" edge to the Workspace entity.
func (ssu *SecurityScanningUpdate) ClearWorkspaceEdge() *SecurityScanningUpdate {
	ssu.mutation.ClearWorkspaceEdge()
	return ssu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (ssu *SecurityScanningUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, ssu.sqlSave, ssu.mutation, ssu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (ssu *SecurityScanningUpdate) SaveX(ctx context.Context) int {
	affected, err := ssu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (ssu *SecurityScanningUpdate) Exec(ctx context.Context) error {
	_, err := ssu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ssu *SecurityScanningUpdate) ExecX(ctx context.Context) {
	if err := ssu.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ssu *SecurityScanningUpdate) check() error {
	if ssu.mutation.UserCleared() && len(ssu.mutation.UserIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "SecurityScanning.user"`)
	}
	if ssu.mutation.WorkspaceEdgeCleared() && len(ssu.mutation.WorkspaceEdgeIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "SecurityScanning.workspace_edge"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (ssu *SecurityScanningUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *SecurityScanningUpdate {
	ssu.modifiers = append(ssu.modifiers, modifiers...)
	return ssu
}

func (ssu *SecurityScanningUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := ssu.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(securityscanning.Table, securityscanning.Columns, sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID))
	if ps := ssu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := ssu.mutation.Status(); ok {
		_spec.SetField(securityscanning.FieldStatus, field.TypeString, value)
	}
	if value, ok := ssu.mutation.Workspace(); ok {
		_spec.SetField(securityscanning.FieldWorkspace, field.TypeString, value)
	}
	if value, ok := ssu.mutation.Language(); ok {
		_spec.SetField(securityscanning.FieldLanguage, field.TypeString, value)
	}
	if value, ok := ssu.mutation.Rule(); ok {
		_spec.SetField(securityscanning.FieldRule, field.TypeString, value)
	}
	if ssu.mutation.RuleCleared() {
		_spec.ClearField(securityscanning.FieldRule, field.TypeString)
	}
	if value, ok := ssu.mutation.ErrorMessage(); ok {
		_spec.SetField(securityscanning.FieldErrorMessage, field.TypeString, value)
	}
	if ssu.mutation.ErrorMessageCleared() {
		_spec.ClearField(securityscanning.FieldErrorMessage, field.TypeString)
	}
	if value, ok := ssu.mutation.CreatedAt(); ok {
		_spec.SetField(securityscanning.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := ssu.mutation.UpdatedAt(); ok {
		_spec.SetField(securityscanning.FieldUpdatedAt, field.TypeTime, value)
	}
	if ssu.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanning.UserTable,
			Columns: []string{securityscanning.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ssu.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanning.UserTable,
			Columns: []string{securityscanning.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if ssu.mutation.ResultsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   securityscanning.ResultsTable,
			Columns: []string{securityscanning.ResultsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanningresult.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ssu.mutation.RemovedResultsIDs(); len(nodes) > 0 && !ssu.mutation.ResultsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   securityscanning.ResultsTable,
			Columns: []string{securityscanning.ResultsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanningresult.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ssu.mutation.ResultsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   securityscanning.ResultsTable,
			Columns: []string{securityscanning.ResultsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanningresult.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if ssu.mutation.WorkspaceEdgeCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanning.WorkspaceEdgeTable,
			Columns: []string{securityscanning.WorkspaceEdgeColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspace.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ssu.mutation.WorkspaceEdgeIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanning.WorkspaceEdgeTable,
			Columns: []string{securityscanning.WorkspaceEdgeColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspace.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(ssu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, ssu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{securityscanning.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	ssu.mutation.done = true
	return n, nil
}

// SecurityScanningUpdateOne is the builder for updating a single SecurityScanning entity.
type SecurityScanningUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *SecurityScanningMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetUserID sets the "user_id" field.
func (ssuo *SecurityScanningUpdateOne) SetUserID(u uuid.UUID) *SecurityScanningUpdateOne {
	ssuo.mutation.SetUserID(u)
	return ssuo
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (ssuo *SecurityScanningUpdateOne) SetNillableUserID(u *uuid.UUID) *SecurityScanningUpdateOne {
	if u != nil {
		ssuo.SetUserID(*u)
	}
	return ssuo
}

// SetWorkspaceID sets the "workspace_id" field.
func (ssuo *SecurityScanningUpdateOne) SetWorkspaceID(u uuid.UUID) *SecurityScanningUpdateOne {
	ssuo.mutation.SetWorkspaceID(u)
	return ssuo
}

// SetNillableWorkspaceID sets the "workspace_id" field if the given value is not nil.
func (ssuo *SecurityScanningUpdateOne) SetNillableWorkspaceID(u *uuid.UUID) *SecurityScanningUpdateOne {
	if u != nil {
		ssuo.SetWorkspaceID(*u)
	}
	return ssuo
}

// SetStatus sets the "status" field.
func (ssuo *SecurityScanningUpdateOne) SetStatus(css consts.SecurityScanningStatus) *SecurityScanningUpdateOne {
	ssuo.mutation.SetStatus(css)
	return ssuo
}

// SetNillableStatus sets the "status" field if the given value is not nil.
func (ssuo *SecurityScanningUpdateOne) SetNillableStatus(css *consts.SecurityScanningStatus) *SecurityScanningUpdateOne {
	if css != nil {
		ssuo.SetStatus(*css)
	}
	return ssuo
}

// SetWorkspace sets the "workspace" field.
func (ssuo *SecurityScanningUpdateOne) SetWorkspace(s string) *SecurityScanningUpdateOne {
	ssuo.mutation.SetWorkspace(s)
	return ssuo
}

// SetNillableWorkspace sets the "workspace" field if the given value is not nil.
func (ssuo *SecurityScanningUpdateOne) SetNillableWorkspace(s *string) *SecurityScanningUpdateOne {
	if s != nil {
		ssuo.SetWorkspace(*s)
	}
	return ssuo
}

// SetLanguage sets the "language" field.
func (ssuo *SecurityScanningUpdateOne) SetLanguage(csl consts.SecurityScanningLanguage) *SecurityScanningUpdateOne {
	ssuo.mutation.SetLanguage(csl)
	return ssuo
}

// SetNillableLanguage sets the "language" field if the given value is not nil.
func (ssuo *SecurityScanningUpdateOne) SetNillableLanguage(csl *consts.SecurityScanningLanguage) *SecurityScanningUpdateOne {
	if csl != nil {
		ssuo.SetLanguage(*csl)
	}
	return ssuo
}

// SetRule sets the "rule" field.
func (ssuo *SecurityScanningUpdateOne) SetRule(s string) *SecurityScanningUpdateOne {
	ssuo.mutation.SetRule(s)
	return ssuo
}

// SetNillableRule sets the "rule" field if the given value is not nil.
func (ssuo *SecurityScanningUpdateOne) SetNillableRule(s *string) *SecurityScanningUpdateOne {
	if s != nil {
		ssuo.SetRule(*s)
	}
	return ssuo
}

// ClearRule clears the value of the "rule" field.
func (ssuo *SecurityScanningUpdateOne) ClearRule() *SecurityScanningUpdateOne {
	ssuo.mutation.ClearRule()
	return ssuo
}

// SetErrorMessage sets the "error_message" field.
func (ssuo *SecurityScanningUpdateOne) SetErrorMessage(s string) *SecurityScanningUpdateOne {
	ssuo.mutation.SetErrorMessage(s)
	return ssuo
}

// SetNillableErrorMessage sets the "error_message" field if the given value is not nil.
func (ssuo *SecurityScanningUpdateOne) SetNillableErrorMessage(s *string) *SecurityScanningUpdateOne {
	if s != nil {
		ssuo.SetErrorMessage(*s)
	}
	return ssuo
}

// ClearErrorMessage clears the value of the "error_message" field.
func (ssuo *SecurityScanningUpdateOne) ClearErrorMessage() *SecurityScanningUpdateOne {
	ssuo.mutation.ClearErrorMessage()
	return ssuo
}

// SetCreatedAt sets the "created_at" field.
func (ssuo *SecurityScanningUpdateOne) SetCreatedAt(t time.Time) *SecurityScanningUpdateOne {
	ssuo.mutation.SetCreatedAt(t)
	return ssuo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ssuo *SecurityScanningUpdateOne) SetNillableCreatedAt(t *time.Time) *SecurityScanningUpdateOne {
	if t != nil {
		ssuo.SetCreatedAt(*t)
	}
	return ssuo
}

// SetUpdatedAt sets the "updated_at" field.
func (ssuo *SecurityScanningUpdateOne) SetUpdatedAt(t time.Time) *SecurityScanningUpdateOne {
	ssuo.mutation.SetUpdatedAt(t)
	return ssuo
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (ssuo *SecurityScanningUpdateOne) SetNillableUpdatedAt(t *time.Time) *SecurityScanningUpdateOne {
	if t != nil {
		ssuo.SetUpdatedAt(*t)
	}
	return ssuo
}

// SetUser sets the "user" edge to the User entity.
func (ssuo *SecurityScanningUpdateOne) SetUser(u *User) *SecurityScanningUpdateOne {
	return ssuo.SetUserID(u.ID)
}

// AddResultIDs adds the "results" edge to the SecurityScanningResult entity by IDs.
func (ssuo *SecurityScanningUpdateOne) AddResultIDs(ids ...uuid.UUID) *SecurityScanningUpdateOne {
	ssuo.mutation.AddResultIDs(ids...)
	return ssuo
}

// AddResults adds the "results" edges to the SecurityScanningResult entity.
func (ssuo *SecurityScanningUpdateOne) AddResults(s ...*SecurityScanningResult) *SecurityScanningUpdateOne {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return ssuo.AddResultIDs(ids...)
}

// SetWorkspaceEdgeID sets the "workspace_edge" edge to the Workspace entity by ID.
func (ssuo *SecurityScanningUpdateOne) SetWorkspaceEdgeID(id uuid.UUID) *SecurityScanningUpdateOne {
	ssuo.mutation.SetWorkspaceEdgeID(id)
	return ssuo
}

// SetWorkspaceEdge sets the "workspace_edge" edge to the Workspace entity.
func (ssuo *SecurityScanningUpdateOne) SetWorkspaceEdge(w *Workspace) *SecurityScanningUpdateOne {
	return ssuo.SetWorkspaceEdgeID(w.ID)
}

// Mutation returns the SecurityScanningMutation object of the builder.
func (ssuo *SecurityScanningUpdateOne) Mutation() *SecurityScanningMutation {
	return ssuo.mutation
}

// ClearUser clears the "user" edge to the User entity.
func (ssuo *SecurityScanningUpdateOne) ClearUser() *SecurityScanningUpdateOne {
	ssuo.mutation.ClearUser()
	return ssuo
}

// ClearResults clears all "results" edges to the SecurityScanningResult entity.
func (ssuo *SecurityScanningUpdateOne) ClearResults() *SecurityScanningUpdateOne {
	ssuo.mutation.ClearResults()
	return ssuo
}

// RemoveResultIDs removes the "results" edge to SecurityScanningResult entities by IDs.
func (ssuo *SecurityScanningUpdateOne) RemoveResultIDs(ids ...uuid.UUID) *SecurityScanningUpdateOne {
	ssuo.mutation.RemoveResultIDs(ids...)
	return ssuo
}

// RemoveResults removes "results" edges to SecurityScanningResult entities.
func (ssuo *SecurityScanningUpdateOne) RemoveResults(s ...*SecurityScanningResult) *SecurityScanningUpdateOne {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return ssuo.RemoveResultIDs(ids...)
}

// ClearWorkspaceEdge clears the "workspace_edge" edge to the Workspace entity.
func (ssuo *SecurityScanningUpdateOne) ClearWorkspaceEdge() *SecurityScanningUpdateOne {
	ssuo.mutation.ClearWorkspaceEdge()
	return ssuo
}

// Where appends a list predicates to the SecurityScanningUpdate builder.
func (ssuo *SecurityScanningUpdateOne) Where(ps ...predicate.SecurityScanning) *SecurityScanningUpdateOne {
	ssuo.mutation.Where(ps...)
	return ssuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (ssuo *SecurityScanningUpdateOne) Select(field string, fields ...string) *SecurityScanningUpdateOne {
	ssuo.fields = append([]string{field}, fields...)
	return ssuo
}

// Save executes the query and returns the updated SecurityScanning entity.
func (ssuo *SecurityScanningUpdateOne) Save(ctx context.Context) (*SecurityScanning, error) {
	return withHooks(ctx, ssuo.sqlSave, ssuo.mutation, ssuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (ssuo *SecurityScanningUpdateOne) SaveX(ctx context.Context) *SecurityScanning {
	node, err := ssuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (ssuo *SecurityScanningUpdateOne) Exec(ctx context.Context) error {
	_, err := ssuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ssuo *SecurityScanningUpdateOne) ExecX(ctx context.Context) {
	if err := ssuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ssuo *SecurityScanningUpdateOne) check() error {
	if ssuo.mutation.UserCleared() && len(ssuo.mutation.UserIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "SecurityScanning.user"`)
	}
	if ssuo.mutation.WorkspaceEdgeCleared() && len(ssuo.mutation.WorkspaceEdgeIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "SecurityScanning.workspace_edge"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (ssuo *SecurityScanningUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *SecurityScanningUpdateOne {
	ssuo.modifiers = append(ssuo.modifiers, modifiers...)
	return ssuo
}

func (ssuo *SecurityScanningUpdateOne) sqlSave(ctx context.Context) (_node *SecurityScanning, err error) {
	if err := ssuo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(securityscanning.Table, securityscanning.Columns, sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID))
	id, ok := ssuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "SecurityScanning.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := ssuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, securityscanning.FieldID)
		for _, f := range fields {
			if !securityscanning.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != securityscanning.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := ssuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := ssuo.mutation.Status(); ok {
		_spec.SetField(securityscanning.FieldStatus, field.TypeString, value)
	}
	if value, ok := ssuo.mutation.Workspace(); ok {
		_spec.SetField(securityscanning.FieldWorkspace, field.TypeString, value)
	}
	if value, ok := ssuo.mutation.Language(); ok {
		_spec.SetField(securityscanning.FieldLanguage, field.TypeString, value)
	}
	if value, ok := ssuo.mutation.Rule(); ok {
		_spec.SetField(securityscanning.FieldRule, field.TypeString, value)
	}
	if ssuo.mutation.RuleCleared() {
		_spec.ClearField(securityscanning.FieldRule, field.TypeString)
	}
	if value, ok := ssuo.mutation.ErrorMessage(); ok {
		_spec.SetField(securityscanning.FieldErrorMessage, field.TypeString, value)
	}
	if ssuo.mutation.ErrorMessageCleared() {
		_spec.ClearField(securityscanning.FieldErrorMessage, field.TypeString)
	}
	if value, ok := ssuo.mutation.CreatedAt(); ok {
		_spec.SetField(securityscanning.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := ssuo.mutation.UpdatedAt(); ok {
		_spec.SetField(securityscanning.FieldUpdatedAt, field.TypeTime, value)
	}
	if ssuo.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanning.UserTable,
			Columns: []string{securityscanning.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ssuo.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanning.UserTable,
			Columns: []string{securityscanning.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if ssuo.mutation.ResultsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   securityscanning.ResultsTable,
			Columns: []string{securityscanning.ResultsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanningresult.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ssuo.mutation.RemovedResultsIDs(); len(nodes) > 0 && !ssuo.mutation.ResultsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   securityscanning.ResultsTable,
			Columns: []string{securityscanning.ResultsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanningresult.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ssuo.mutation.ResultsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   securityscanning.ResultsTable,
			Columns: []string{securityscanning.ResultsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanningresult.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if ssuo.mutation.WorkspaceEdgeCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanning.WorkspaceEdgeTable,
			Columns: []string{securityscanning.WorkspaceEdgeColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspace.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ssuo.mutation.WorkspaceEdgeIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanning.WorkspaceEdgeTable,
			Columns: []string{securityscanning.WorkspaceEdgeColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspace.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(ssuo.modifiers...)
	_node = &SecurityScanning{config: ssuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, ssuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{securityscanning.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	ssuo.mutation.done = true
	return _node, nil
}
