// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"database/sql/driver"
	"fmt"
	"math"

	"entgo.io/ent"
	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanning"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanningresult"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/workspace"
	"github.com/google/uuid"
)

// SecurityScanningQuery is the builder for querying SecurityScanning entities.
type SecurityScanningQuery struct {
	config
	ctx               *QueryContext
	order             []securityscanning.OrderOption
	inters            []Interceptor
	predicates        []predicate.SecurityScanning
	withUser          *UserQuery
	withResults       *SecurityScanningResultQuery
	withWorkspaceEdge *WorkspaceQuery
	modifiers         []func(*sql.Selector)
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the SecurityScanningQuery builder.
func (ssq *SecurityScanningQuery) Where(ps ...predicate.SecurityScanning) *SecurityScanningQuery {
	ssq.predicates = append(ssq.predicates, ps...)
	return ssq
}

// Limit the number of records to be returned by this query.
func (ssq *SecurityScanningQuery) Limit(limit int) *SecurityScanningQuery {
	ssq.ctx.Limit = &limit
	return ssq
}

// Offset to start from.
func (ssq *SecurityScanningQuery) Offset(offset int) *SecurityScanningQuery {
	ssq.ctx.Offset = &offset
	return ssq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (ssq *SecurityScanningQuery) Unique(unique bool) *SecurityScanningQuery {
	ssq.ctx.Unique = &unique
	return ssq
}

// Order specifies how the records should be ordered.
func (ssq *SecurityScanningQuery) Order(o ...securityscanning.OrderOption) *SecurityScanningQuery {
	ssq.order = append(ssq.order, o...)
	return ssq
}

// QueryUser chains the current query on the "user" edge.
func (ssq *SecurityScanningQuery) QueryUser() *UserQuery {
	query := (&UserClient{config: ssq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := ssq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := ssq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(securityscanning.Table, securityscanning.FieldID, selector),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, securityscanning.UserTable, securityscanning.UserColumn),
		)
		fromU = sqlgraph.SetNeighbors(ssq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// QueryResults chains the current query on the "results" edge.
func (ssq *SecurityScanningQuery) QueryResults() *SecurityScanningResultQuery {
	query := (&SecurityScanningResultClient{config: ssq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := ssq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := ssq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(securityscanning.Table, securityscanning.FieldID, selector),
			sqlgraph.To(securityscanningresult.Table, securityscanningresult.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, securityscanning.ResultsTable, securityscanning.ResultsColumn),
		)
		fromU = sqlgraph.SetNeighbors(ssq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// QueryWorkspaceEdge chains the current query on the "workspace_edge" edge.
func (ssq *SecurityScanningQuery) QueryWorkspaceEdge() *WorkspaceQuery {
	query := (&WorkspaceClient{config: ssq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := ssq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := ssq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(securityscanning.Table, securityscanning.FieldID, selector),
			sqlgraph.To(workspace.Table, workspace.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, securityscanning.WorkspaceEdgeTable, securityscanning.WorkspaceEdgeColumn),
		)
		fromU = sqlgraph.SetNeighbors(ssq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// First returns the first SecurityScanning entity from the query.
// Returns a *NotFoundError when no SecurityScanning was found.
func (ssq *SecurityScanningQuery) First(ctx context.Context) (*SecurityScanning, error) {
	nodes, err := ssq.Limit(1).All(setContextOp(ctx, ssq.ctx, ent.OpQueryFirst))
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{securityscanning.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (ssq *SecurityScanningQuery) FirstX(ctx context.Context) *SecurityScanning {
	node, err := ssq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first SecurityScanning ID from the query.
// Returns a *NotFoundError when no SecurityScanning ID was found.
func (ssq *SecurityScanningQuery) FirstID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = ssq.Limit(1).IDs(setContextOp(ctx, ssq.ctx, ent.OpQueryFirstID)); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{securityscanning.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (ssq *SecurityScanningQuery) FirstIDX(ctx context.Context) uuid.UUID {
	id, err := ssq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single SecurityScanning entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one SecurityScanning entity is found.
// Returns a *NotFoundError when no SecurityScanning entities are found.
func (ssq *SecurityScanningQuery) Only(ctx context.Context) (*SecurityScanning, error) {
	nodes, err := ssq.Limit(2).All(setContextOp(ctx, ssq.ctx, ent.OpQueryOnly))
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{securityscanning.Label}
	default:
		return nil, &NotSingularError{securityscanning.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (ssq *SecurityScanningQuery) OnlyX(ctx context.Context) *SecurityScanning {
	node, err := ssq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only SecurityScanning ID in the query.
// Returns a *NotSingularError when more than one SecurityScanning ID is found.
// Returns a *NotFoundError when no entities are found.
func (ssq *SecurityScanningQuery) OnlyID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = ssq.Limit(2).IDs(setContextOp(ctx, ssq.ctx, ent.OpQueryOnlyID)); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{securityscanning.Label}
	default:
		err = &NotSingularError{securityscanning.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (ssq *SecurityScanningQuery) OnlyIDX(ctx context.Context) uuid.UUID {
	id, err := ssq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of SecurityScannings.
func (ssq *SecurityScanningQuery) All(ctx context.Context) ([]*SecurityScanning, error) {
	ctx = setContextOp(ctx, ssq.ctx, ent.OpQueryAll)
	if err := ssq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	qr := querierAll[[]*SecurityScanning, *SecurityScanningQuery]()
	return withInterceptors[[]*SecurityScanning](ctx, ssq, qr, ssq.inters)
}

// AllX is like All, but panics if an error occurs.
func (ssq *SecurityScanningQuery) AllX(ctx context.Context) []*SecurityScanning {
	nodes, err := ssq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of SecurityScanning IDs.
func (ssq *SecurityScanningQuery) IDs(ctx context.Context) (ids []uuid.UUID, err error) {
	if ssq.ctx.Unique == nil && ssq.path != nil {
		ssq.Unique(true)
	}
	ctx = setContextOp(ctx, ssq.ctx, ent.OpQueryIDs)
	if err = ssq.Select(securityscanning.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (ssq *SecurityScanningQuery) IDsX(ctx context.Context) []uuid.UUID {
	ids, err := ssq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (ssq *SecurityScanningQuery) Count(ctx context.Context) (int, error) {
	ctx = setContextOp(ctx, ssq.ctx, ent.OpQueryCount)
	if err := ssq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return withInterceptors[int](ctx, ssq, querierCount[*SecurityScanningQuery](), ssq.inters)
}

// CountX is like Count, but panics if an error occurs.
func (ssq *SecurityScanningQuery) CountX(ctx context.Context) int {
	count, err := ssq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (ssq *SecurityScanningQuery) Exist(ctx context.Context) (bool, error) {
	ctx = setContextOp(ctx, ssq.ctx, ent.OpQueryExist)
	switch _, err := ssq.FirstID(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("db: check existence: %w", err)
	default:
		return true, nil
	}
}

// ExistX is like Exist, but panics if an error occurs.
func (ssq *SecurityScanningQuery) ExistX(ctx context.Context) bool {
	exist, err := ssq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the SecurityScanningQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (ssq *SecurityScanningQuery) Clone() *SecurityScanningQuery {
	if ssq == nil {
		return nil
	}
	return &SecurityScanningQuery{
		config:            ssq.config,
		ctx:               ssq.ctx.Clone(),
		order:             append([]securityscanning.OrderOption{}, ssq.order...),
		inters:            append([]Interceptor{}, ssq.inters...),
		predicates:        append([]predicate.SecurityScanning{}, ssq.predicates...),
		withUser:          ssq.withUser.Clone(),
		withResults:       ssq.withResults.Clone(),
		withWorkspaceEdge: ssq.withWorkspaceEdge.Clone(),
		// clone intermediate query.
		sql:       ssq.sql.Clone(),
		path:      ssq.path,
		modifiers: append([]func(*sql.Selector){}, ssq.modifiers...),
	}
}

// WithUser tells the query-builder to eager-load the nodes that are connected to
// the "user" edge. The optional arguments are used to configure the query builder of the edge.
func (ssq *SecurityScanningQuery) WithUser(opts ...func(*UserQuery)) *SecurityScanningQuery {
	query := (&UserClient{config: ssq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	ssq.withUser = query
	return ssq
}

// WithResults tells the query-builder to eager-load the nodes that are connected to
// the "results" edge. The optional arguments are used to configure the query builder of the edge.
func (ssq *SecurityScanningQuery) WithResults(opts ...func(*SecurityScanningResultQuery)) *SecurityScanningQuery {
	query := (&SecurityScanningResultClient{config: ssq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	ssq.withResults = query
	return ssq
}

// WithWorkspaceEdge tells the query-builder to eager-load the nodes that are connected to
// the "workspace_edge" edge. The optional arguments are used to configure the query builder of the edge.
func (ssq *SecurityScanningQuery) WithWorkspaceEdge(opts ...func(*WorkspaceQuery)) *SecurityScanningQuery {
	query := (&WorkspaceClient{config: ssq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	ssq.withWorkspaceEdge = query
	return ssq
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		UserID uuid.UUID `json:"user_id,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.SecurityScanning.Query().
//		GroupBy(securityscanning.FieldUserID).
//		Aggregate(db.Count()).
//		Scan(ctx, &v)
func (ssq *SecurityScanningQuery) GroupBy(field string, fields ...string) *SecurityScanningGroupBy {
	ssq.ctx.Fields = append([]string{field}, fields...)
	grbuild := &SecurityScanningGroupBy{build: ssq}
	grbuild.flds = &ssq.ctx.Fields
	grbuild.label = securityscanning.Label
	grbuild.scan = grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		UserID uuid.UUID `json:"user_id,omitempty"`
//	}
//
//	client.SecurityScanning.Query().
//		Select(securityscanning.FieldUserID).
//		Scan(ctx, &v)
func (ssq *SecurityScanningQuery) Select(fields ...string) *SecurityScanningSelect {
	ssq.ctx.Fields = append(ssq.ctx.Fields, fields...)
	sbuild := &SecurityScanningSelect{SecurityScanningQuery: ssq}
	sbuild.label = securityscanning.Label
	sbuild.flds, sbuild.scan = &ssq.ctx.Fields, sbuild.Scan
	return sbuild
}

// Aggregate returns a SecurityScanningSelect configured with the given aggregations.
func (ssq *SecurityScanningQuery) Aggregate(fns ...AggregateFunc) *SecurityScanningSelect {
	return ssq.Select().Aggregate(fns...)
}

func (ssq *SecurityScanningQuery) prepareQuery(ctx context.Context) error {
	for _, inter := range ssq.inters {
		if inter == nil {
			return fmt.Errorf("db: uninitialized interceptor (forgotten import db/runtime?)")
		}
		if trv, ok := inter.(Traverser); ok {
			if err := trv.Traverse(ctx, ssq); err != nil {
				return err
			}
		}
	}
	for _, f := range ssq.ctx.Fields {
		if !securityscanning.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
		}
	}
	if ssq.path != nil {
		prev, err := ssq.path(ctx)
		if err != nil {
			return err
		}
		ssq.sql = prev
	}
	return nil
}

func (ssq *SecurityScanningQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*SecurityScanning, error) {
	var (
		nodes       = []*SecurityScanning{}
		_spec       = ssq.querySpec()
		loadedTypes = [3]bool{
			ssq.withUser != nil,
			ssq.withResults != nil,
			ssq.withWorkspaceEdge != nil,
		}
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*SecurityScanning).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &SecurityScanning{config: ssq.config}
		nodes = append(nodes, node)
		node.Edges.loadedTypes = loadedTypes
		return node.assignValues(columns, values)
	}
	if len(ssq.modifiers) > 0 {
		_spec.Modifiers = ssq.modifiers
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, ssq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	if query := ssq.withUser; query != nil {
		if err := ssq.loadUser(ctx, query, nodes, nil,
			func(n *SecurityScanning, e *User) { n.Edges.User = e }); err != nil {
			return nil, err
		}
	}
	if query := ssq.withResults; query != nil {
		if err := ssq.loadResults(ctx, query, nodes,
			func(n *SecurityScanning) { n.Edges.Results = []*SecurityScanningResult{} },
			func(n *SecurityScanning, e *SecurityScanningResult) { n.Edges.Results = append(n.Edges.Results, e) }); err != nil {
			return nil, err
		}
	}
	if query := ssq.withWorkspaceEdge; query != nil {
		if err := ssq.loadWorkspaceEdge(ctx, query, nodes, nil,
			func(n *SecurityScanning, e *Workspace) { n.Edges.WorkspaceEdge = e }); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

func (ssq *SecurityScanningQuery) loadUser(ctx context.Context, query *UserQuery, nodes []*SecurityScanning, init func(*SecurityScanning), assign func(*SecurityScanning, *User)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*SecurityScanning)
	for i := range nodes {
		fk := nodes[i].UserID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(user.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "user_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}
func (ssq *SecurityScanningQuery) loadResults(ctx context.Context, query *SecurityScanningResultQuery, nodes []*SecurityScanning, init func(*SecurityScanning), assign func(*SecurityScanning, *SecurityScanningResult)) error {
	fks := make([]driver.Value, 0, len(nodes))
	nodeids := make(map[uuid.UUID]*SecurityScanning)
	for i := range nodes {
		fks = append(fks, nodes[i].ID)
		nodeids[nodes[i].ID] = nodes[i]
		if init != nil {
			init(nodes[i])
		}
	}
	if len(query.ctx.Fields) > 0 {
		query.ctx.AppendFieldOnce(securityscanningresult.FieldSecurityScanningID)
	}
	query.Where(predicate.SecurityScanningResult(func(s *sql.Selector) {
		s.Where(sql.InValues(s.C(securityscanning.ResultsColumn), fks...))
	}))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		fk := n.SecurityScanningID
		node, ok := nodeids[fk]
		if !ok {
			return fmt.Errorf(`unexpected referenced foreign-key "security_scanning_id" returned %v for node %v`, fk, n.ID)
		}
		assign(node, n)
	}
	return nil
}
func (ssq *SecurityScanningQuery) loadWorkspaceEdge(ctx context.Context, query *WorkspaceQuery, nodes []*SecurityScanning, init func(*SecurityScanning), assign func(*SecurityScanning, *Workspace)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*SecurityScanning)
	for i := range nodes {
		fk := nodes[i].WorkspaceID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(workspace.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "workspace_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}

func (ssq *SecurityScanningQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := ssq.querySpec()
	if len(ssq.modifiers) > 0 {
		_spec.Modifiers = ssq.modifiers
	}
	_spec.Node.Columns = ssq.ctx.Fields
	if len(ssq.ctx.Fields) > 0 {
		_spec.Unique = ssq.ctx.Unique != nil && *ssq.ctx.Unique
	}
	return sqlgraph.CountNodes(ctx, ssq.driver, _spec)
}

func (ssq *SecurityScanningQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := sqlgraph.NewQuerySpec(securityscanning.Table, securityscanning.Columns, sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID))
	_spec.From = ssq.sql
	if unique := ssq.ctx.Unique; unique != nil {
		_spec.Unique = *unique
	} else if ssq.path != nil {
		_spec.Unique = true
	}
	if fields := ssq.ctx.Fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, securityscanning.FieldID)
		for i := range fields {
			if fields[i] != securityscanning.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
		if ssq.withUser != nil {
			_spec.Node.AddColumnOnce(securityscanning.FieldUserID)
		}
		if ssq.withWorkspaceEdge != nil {
			_spec.Node.AddColumnOnce(securityscanning.FieldWorkspaceID)
		}
	}
	if ps := ssq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := ssq.ctx.Limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := ssq.ctx.Offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := ssq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (ssq *SecurityScanningQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(ssq.driver.Dialect())
	t1 := builder.Table(securityscanning.Table)
	columns := ssq.ctx.Fields
	if len(columns) == 0 {
		columns = securityscanning.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if ssq.sql != nil {
		selector = ssq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if ssq.ctx.Unique != nil && *ssq.ctx.Unique {
		selector.Distinct()
	}
	for _, m := range ssq.modifiers {
		m(selector)
	}
	for _, p := range ssq.predicates {
		p(selector)
	}
	for _, p := range ssq.order {
		p(selector)
	}
	if offset := ssq.ctx.Offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := ssq.ctx.Limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// ForUpdate locks the selected rows against concurrent updates, and prevent them from being
// updated, deleted or "selected ... for update" by other sessions, until the transaction is
// either committed or rolled-back.
func (ssq *SecurityScanningQuery) ForUpdate(opts ...sql.LockOption) *SecurityScanningQuery {
	if ssq.driver.Dialect() == dialect.Postgres {
		ssq.Unique(false)
	}
	ssq.modifiers = append(ssq.modifiers, func(s *sql.Selector) {
		s.ForUpdate(opts...)
	})
	return ssq
}

// ForShare behaves similarly to ForUpdate, except that it acquires a shared mode lock
// on any rows that are read. Other sessions can read the rows, but cannot modify them
// until your transaction commits.
func (ssq *SecurityScanningQuery) ForShare(opts ...sql.LockOption) *SecurityScanningQuery {
	if ssq.driver.Dialect() == dialect.Postgres {
		ssq.Unique(false)
	}
	ssq.modifiers = append(ssq.modifiers, func(s *sql.Selector) {
		s.ForShare(opts...)
	})
	return ssq
}

// Modify adds a query modifier for attaching custom logic to queries.
func (ssq *SecurityScanningQuery) Modify(modifiers ...func(s *sql.Selector)) *SecurityScanningSelect {
	ssq.modifiers = append(ssq.modifiers, modifiers...)
	return ssq.Select()
}

// SecurityScanningGroupBy is the group-by builder for SecurityScanning entities.
type SecurityScanningGroupBy struct {
	selector
	build *SecurityScanningQuery
}

// Aggregate adds the given aggregation functions to the group-by query.
func (ssgb *SecurityScanningGroupBy) Aggregate(fns ...AggregateFunc) *SecurityScanningGroupBy {
	ssgb.fns = append(ssgb.fns, fns...)
	return ssgb
}

// Scan applies the selector query and scans the result into the given value.
func (ssgb *SecurityScanningGroupBy) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, ssgb.build.ctx, ent.OpQueryGroupBy)
	if err := ssgb.build.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*SecurityScanningQuery, *SecurityScanningGroupBy](ctx, ssgb.build, ssgb, ssgb.build.inters, v)
}

func (ssgb *SecurityScanningGroupBy) sqlScan(ctx context.Context, root *SecurityScanningQuery, v any) error {
	selector := root.sqlQuery(ctx).Select()
	aggregation := make([]string, 0, len(ssgb.fns))
	for _, fn := range ssgb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(*ssgb.flds)+len(ssgb.fns))
		for _, f := range *ssgb.flds {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	selector.GroupBy(selector.Columns(*ssgb.flds...)...)
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := ssgb.build.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// SecurityScanningSelect is the builder for selecting fields of SecurityScanning entities.
type SecurityScanningSelect struct {
	*SecurityScanningQuery
	selector
}

// Aggregate adds the given aggregation functions to the selector query.
func (sss *SecurityScanningSelect) Aggregate(fns ...AggregateFunc) *SecurityScanningSelect {
	sss.fns = append(sss.fns, fns...)
	return sss
}

// Scan applies the selector query and scans the result into the given value.
func (sss *SecurityScanningSelect) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, sss.ctx, ent.OpQuerySelect)
	if err := sss.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*SecurityScanningQuery, *SecurityScanningSelect](ctx, sss.SecurityScanningQuery, sss, sss.inters, v)
}

func (sss *SecurityScanningSelect) sqlScan(ctx context.Context, root *SecurityScanningQuery, v any) error {
	selector := root.sqlQuery(ctx)
	aggregation := make([]string, 0, len(sss.fns))
	for _, fn := range sss.fns {
		aggregation = append(aggregation, fn(selector))
	}
	switch n := len(*sss.selector.flds); {
	case n == 0 && len(aggregation) > 0:
		selector.Select(aggregation...)
	case n != 0 && len(aggregation) > 0:
		selector.AppendSelect(aggregation...)
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := sss.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// Modify adds a query modifier for attaching custom logic to queries.
func (sss *SecurityScanningSelect) Modify(modifiers ...func(s *sql.Selector)) *SecurityScanningSelect {
	sss.modifiers = append(sss.modifiers, modifiers...)
	return sss
}
