// Code generated by ent, DO NOT EDIT.

package securityscanning

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/google/uuid"
)

// ID filters vertices based on their ID field.
func ID(id uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldID, id))
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldID, id))
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNEQ(FieldID, id))
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldIn(FieldID, ids...))
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNotIn(FieldID, ids...))
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldGT(FieldID, id))
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldGTE(FieldID, id))
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldLT(FieldID, id))
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldLTE(FieldID, id))
}

// UserID applies equality check predicate on the "user_id" field. It's identical to UserIDEQ.
func UserID(v uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldUserID, v))
}

// WorkspaceID applies equality check predicate on the "workspace_id" field. It's identical to WorkspaceIDEQ.
func WorkspaceID(v uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldWorkspaceID, v))
}

// Status applies equality check predicate on the "status" field. It's identical to StatusEQ.
func Status(v consts.SecurityScanningStatus) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldEQ(FieldStatus, vc))
}

// Workspace applies equality check predicate on the "workspace" field. It's identical to WorkspaceEQ.
func Workspace(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldWorkspace, v))
}

// Language applies equality check predicate on the "language" field. It's identical to LanguageEQ.
func Language(v consts.SecurityScanningLanguage) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldEQ(FieldLanguage, vc))
}

// Rule applies equality check predicate on the "rule" field. It's identical to RuleEQ.
func Rule(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldRule, v))
}

// ErrorMessage applies equality check predicate on the "error_message" field. It's identical to ErrorMessageEQ.
func ErrorMessage(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldErrorMessage, v))
}

// CreatedAt applies equality check predicate on the "created_at" field. It's identical to CreatedAtEQ.
func CreatedAt(v time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldCreatedAt, v))
}

// UpdatedAt applies equality check predicate on the "updated_at" field. It's identical to UpdatedAtEQ.
func UpdatedAt(v time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldUpdatedAt, v))
}

// UserIDEQ applies the EQ predicate on the "user_id" field.
func UserIDEQ(v uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldUserID, v))
}

// UserIDNEQ applies the NEQ predicate on the "user_id" field.
func UserIDNEQ(v uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNEQ(FieldUserID, v))
}

// UserIDIn applies the In predicate on the "user_id" field.
func UserIDIn(vs ...uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldIn(FieldUserID, vs...))
}

// UserIDNotIn applies the NotIn predicate on the "user_id" field.
func UserIDNotIn(vs ...uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNotIn(FieldUserID, vs...))
}

// WorkspaceIDEQ applies the EQ predicate on the "workspace_id" field.
func WorkspaceIDEQ(v uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldWorkspaceID, v))
}

// WorkspaceIDNEQ applies the NEQ predicate on the "workspace_id" field.
func WorkspaceIDNEQ(v uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNEQ(FieldWorkspaceID, v))
}

// WorkspaceIDIn applies the In predicate on the "workspace_id" field.
func WorkspaceIDIn(vs ...uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldIn(FieldWorkspaceID, vs...))
}

// WorkspaceIDNotIn applies the NotIn predicate on the "workspace_id" field.
func WorkspaceIDNotIn(vs ...uuid.UUID) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNotIn(FieldWorkspaceID, vs...))
}

// StatusEQ applies the EQ predicate on the "status" field.
func StatusEQ(v consts.SecurityScanningStatus) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldEQ(FieldStatus, vc))
}

// StatusNEQ applies the NEQ predicate on the "status" field.
func StatusNEQ(v consts.SecurityScanningStatus) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldNEQ(FieldStatus, vc))
}

// StatusIn applies the In predicate on the "status" field.
func StatusIn(vs ...consts.SecurityScanningStatus) predicate.SecurityScanning {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.SecurityScanning(sql.FieldIn(FieldStatus, v...))
}

// StatusNotIn applies the NotIn predicate on the "status" field.
func StatusNotIn(vs ...consts.SecurityScanningStatus) predicate.SecurityScanning {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.SecurityScanning(sql.FieldNotIn(FieldStatus, v...))
}

// StatusGT applies the GT predicate on the "status" field.
func StatusGT(v consts.SecurityScanningStatus) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldGT(FieldStatus, vc))
}

// StatusGTE applies the GTE predicate on the "status" field.
func StatusGTE(v consts.SecurityScanningStatus) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldGTE(FieldStatus, vc))
}

// StatusLT applies the LT predicate on the "status" field.
func StatusLT(v consts.SecurityScanningStatus) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldLT(FieldStatus, vc))
}

// StatusLTE applies the LTE predicate on the "status" field.
func StatusLTE(v consts.SecurityScanningStatus) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldLTE(FieldStatus, vc))
}

// StatusContains applies the Contains predicate on the "status" field.
func StatusContains(v consts.SecurityScanningStatus) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldContains(FieldStatus, vc))
}

// StatusHasPrefix applies the HasPrefix predicate on the "status" field.
func StatusHasPrefix(v consts.SecurityScanningStatus) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldHasPrefix(FieldStatus, vc))
}

// StatusHasSuffix applies the HasSuffix predicate on the "status" field.
func StatusHasSuffix(v consts.SecurityScanningStatus) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldHasSuffix(FieldStatus, vc))
}

// StatusEqualFold applies the EqualFold predicate on the "status" field.
func StatusEqualFold(v consts.SecurityScanningStatus) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldEqualFold(FieldStatus, vc))
}

// StatusContainsFold applies the ContainsFold predicate on the "status" field.
func StatusContainsFold(v consts.SecurityScanningStatus) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldContainsFold(FieldStatus, vc))
}

// WorkspaceEQ applies the EQ predicate on the "workspace" field.
func WorkspaceEQ(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldWorkspace, v))
}

// WorkspaceNEQ applies the NEQ predicate on the "workspace" field.
func WorkspaceNEQ(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNEQ(FieldWorkspace, v))
}

// WorkspaceIn applies the In predicate on the "workspace" field.
func WorkspaceIn(vs ...string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldIn(FieldWorkspace, vs...))
}

// WorkspaceNotIn applies the NotIn predicate on the "workspace" field.
func WorkspaceNotIn(vs ...string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNotIn(FieldWorkspace, vs...))
}

// WorkspaceGT applies the GT predicate on the "workspace" field.
func WorkspaceGT(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldGT(FieldWorkspace, v))
}

// WorkspaceGTE applies the GTE predicate on the "workspace" field.
func WorkspaceGTE(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldGTE(FieldWorkspace, v))
}

// WorkspaceLT applies the LT predicate on the "workspace" field.
func WorkspaceLT(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldLT(FieldWorkspace, v))
}

// WorkspaceLTE applies the LTE predicate on the "workspace" field.
func WorkspaceLTE(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldLTE(FieldWorkspace, v))
}

// WorkspaceContains applies the Contains predicate on the "workspace" field.
func WorkspaceContains(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldContains(FieldWorkspace, v))
}

// WorkspaceHasPrefix applies the HasPrefix predicate on the "workspace" field.
func WorkspaceHasPrefix(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldHasPrefix(FieldWorkspace, v))
}

// WorkspaceHasSuffix applies the HasSuffix predicate on the "workspace" field.
func WorkspaceHasSuffix(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldHasSuffix(FieldWorkspace, v))
}

// WorkspaceEqualFold applies the EqualFold predicate on the "workspace" field.
func WorkspaceEqualFold(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEqualFold(FieldWorkspace, v))
}

// WorkspaceContainsFold applies the ContainsFold predicate on the "workspace" field.
func WorkspaceContainsFold(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldContainsFold(FieldWorkspace, v))
}

// LanguageEQ applies the EQ predicate on the "language" field.
func LanguageEQ(v consts.SecurityScanningLanguage) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldEQ(FieldLanguage, vc))
}

// LanguageNEQ applies the NEQ predicate on the "language" field.
func LanguageNEQ(v consts.SecurityScanningLanguage) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldNEQ(FieldLanguage, vc))
}

// LanguageIn applies the In predicate on the "language" field.
func LanguageIn(vs ...consts.SecurityScanningLanguage) predicate.SecurityScanning {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.SecurityScanning(sql.FieldIn(FieldLanguage, v...))
}

// LanguageNotIn applies the NotIn predicate on the "language" field.
func LanguageNotIn(vs ...consts.SecurityScanningLanguage) predicate.SecurityScanning {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.SecurityScanning(sql.FieldNotIn(FieldLanguage, v...))
}

// LanguageGT applies the GT predicate on the "language" field.
func LanguageGT(v consts.SecurityScanningLanguage) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldGT(FieldLanguage, vc))
}

// LanguageGTE applies the GTE predicate on the "language" field.
func LanguageGTE(v consts.SecurityScanningLanguage) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldGTE(FieldLanguage, vc))
}

// LanguageLT applies the LT predicate on the "language" field.
func LanguageLT(v consts.SecurityScanningLanguage) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldLT(FieldLanguage, vc))
}

// LanguageLTE applies the LTE predicate on the "language" field.
func LanguageLTE(v consts.SecurityScanningLanguage) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldLTE(FieldLanguage, vc))
}

// LanguageContains applies the Contains predicate on the "language" field.
func LanguageContains(v consts.SecurityScanningLanguage) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldContains(FieldLanguage, vc))
}

// LanguageHasPrefix applies the HasPrefix predicate on the "language" field.
func LanguageHasPrefix(v consts.SecurityScanningLanguage) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldHasPrefix(FieldLanguage, vc))
}

// LanguageHasSuffix applies the HasSuffix predicate on the "language" field.
func LanguageHasSuffix(v consts.SecurityScanningLanguage) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldHasSuffix(FieldLanguage, vc))
}

// LanguageEqualFold applies the EqualFold predicate on the "language" field.
func LanguageEqualFold(v consts.SecurityScanningLanguage) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldEqualFold(FieldLanguage, vc))
}

// LanguageContainsFold applies the ContainsFold predicate on the "language" field.
func LanguageContainsFold(v consts.SecurityScanningLanguage) predicate.SecurityScanning {
	vc := string(v)
	return predicate.SecurityScanning(sql.FieldContainsFold(FieldLanguage, vc))
}

// RuleEQ applies the EQ predicate on the "rule" field.
func RuleEQ(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldRule, v))
}

// RuleNEQ applies the NEQ predicate on the "rule" field.
func RuleNEQ(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNEQ(FieldRule, v))
}

// RuleIn applies the In predicate on the "rule" field.
func RuleIn(vs ...string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldIn(FieldRule, vs...))
}

// RuleNotIn applies the NotIn predicate on the "rule" field.
func RuleNotIn(vs ...string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNotIn(FieldRule, vs...))
}

// RuleGT applies the GT predicate on the "rule" field.
func RuleGT(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldGT(FieldRule, v))
}

// RuleGTE applies the GTE predicate on the "rule" field.
func RuleGTE(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldGTE(FieldRule, v))
}

// RuleLT applies the LT predicate on the "rule" field.
func RuleLT(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldLT(FieldRule, v))
}

// RuleLTE applies the LTE predicate on the "rule" field.
func RuleLTE(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldLTE(FieldRule, v))
}

// RuleContains applies the Contains predicate on the "rule" field.
func RuleContains(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldContains(FieldRule, v))
}

// RuleHasPrefix applies the HasPrefix predicate on the "rule" field.
func RuleHasPrefix(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldHasPrefix(FieldRule, v))
}

// RuleHasSuffix applies the HasSuffix predicate on the "rule" field.
func RuleHasSuffix(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldHasSuffix(FieldRule, v))
}

// RuleIsNil applies the IsNil predicate on the "rule" field.
func RuleIsNil() predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldIsNull(FieldRule))
}

// RuleNotNil applies the NotNil predicate on the "rule" field.
func RuleNotNil() predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNotNull(FieldRule))
}

// RuleEqualFold applies the EqualFold predicate on the "rule" field.
func RuleEqualFold(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEqualFold(FieldRule, v))
}

// RuleContainsFold applies the ContainsFold predicate on the "rule" field.
func RuleContainsFold(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldContainsFold(FieldRule, v))
}

// ErrorMessageEQ applies the EQ predicate on the "error_message" field.
func ErrorMessageEQ(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldErrorMessage, v))
}

// ErrorMessageNEQ applies the NEQ predicate on the "error_message" field.
func ErrorMessageNEQ(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNEQ(FieldErrorMessage, v))
}

// ErrorMessageIn applies the In predicate on the "error_message" field.
func ErrorMessageIn(vs ...string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldIn(FieldErrorMessage, vs...))
}

// ErrorMessageNotIn applies the NotIn predicate on the "error_message" field.
func ErrorMessageNotIn(vs ...string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNotIn(FieldErrorMessage, vs...))
}

// ErrorMessageGT applies the GT predicate on the "error_message" field.
func ErrorMessageGT(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldGT(FieldErrorMessage, v))
}

// ErrorMessageGTE applies the GTE predicate on the "error_message" field.
func ErrorMessageGTE(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldGTE(FieldErrorMessage, v))
}

// ErrorMessageLT applies the LT predicate on the "error_message" field.
func ErrorMessageLT(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldLT(FieldErrorMessage, v))
}

// ErrorMessageLTE applies the LTE predicate on the "error_message" field.
func ErrorMessageLTE(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldLTE(FieldErrorMessage, v))
}

// ErrorMessageContains applies the Contains predicate on the "error_message" field.
func ErrorMessageContains(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldContains(FieldErrorMessage, v))
}

// ErrorMessageHasPrefix applies the HasPrefix predicate on the "error_message" field.
func ErrorMessageHasPrefix(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldHasPrefix(FieldErrorMessage, v))
}

// ErrorMessageHasSuffix applies the HasSuffix predicate on the "error_message" field.
func ErrorMessageHasSuffix(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldHasSuffix(FieldErrorMessage, v))
}

// ErrorMessageIsNil applies the IsNil predicate on the "error_message" field.
func ErrorMessageIsNil() predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldIsNull(FieldErrorMessage))
}

// ErrorMessageNotNil applies the NotNil predicate on the "error_message" field.
func ErrorMessageNotNil() predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNotNull(FieldErrorMessage))
}

// ErrorMessageEqualFold applies the EqualFold predicate on the "error_message" field.
func ErrorMessageEqualFold(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEqualFold(FieldErrorMessage, v))
}

// ErrorMessageContainsFold applies the ContainsFold predicate on the "error_message" field.
func ErrorMessageContainsFold(v string) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldContainsFold(FieldErrorMessage, v))
}

// CreatedAtEQ applies the EQ predicate on the "created_at" field.
func CreatedAtEQ(v time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldCreatedAt, v))
}

// CreatedAtNEQ applies the NEQ predicate on the "created_at" field.
func CreatedAtNEQ(v time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNEQ(FieldCreatedAt, v))
}

// CreatedAtIn applies the In predicate on the "created_at" field.
func CreatedAtIn(vs ...time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldIn(FieldCreatedAt, vs...))
}

// CreatedAtNotIn applies the NotIn predicate on the "created_at" field.
func CreatedAtNotIn(vs ...time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNotIn(FieldCreatedAt, vs...))
}

// CreatedAtGT applies the GT predicate on the "created_at" field.
func CreatedAtGT(v time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldGT(FieldCreatedAt, v))
}

// CreatedAtGTE applies the GTE predicate on the "created_at" field.
func CreatedAtGTE(v time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldGTE(FieldCreatedAt, v))
}

// CreatedAtLT applies the LT predicate on the "created_at" field.
func CreatedAtLT(v time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldLT(FieldCreatedAt, v))
}

// CreatedAtLTE applies the LTE predicate on the "created_at" field.
func CreatedAtLTE(v time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldLTE(FieldCreatedAt, v))
}

// UpdatedAtEQ applies the EQ predicate on the "updated_at" field.
func UpdatedAtEQ(v time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldEQ(FieldUpdatedAt, v))
}

// UpdatedAtNEQ applies the NEQ predicate on the "updated_at" field.
func UpdatedAtNEQ(v time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNEQ(FieldUpdatedAt, v))
}

// UpdatedAtIn applies the In predicate on the "updated_at" field.
func UpdatedAtIn(vs ...time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldIn(FieldUpdatedAt, vs...))
}

// UpdatedAtNotIn applies the NotIn predicate on the "updated_at" field.
func UpdatedAtNotIn(vs ...time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldNotIn(FieldUpdatedAt, vs...))
}

// UpdatedAtGT applies the GT predicate on the "updated_at" field.
func UpdatedAtGT(v time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldGT(FieldUpdatedAt, v))
}

// UpdatedAtGTE applies the GTE predicate on the "updated_at" field.
func UpdatedAtGTE(v time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldGTE(FieldUpdatedAt, v))
}

// UpdatedAtLT applies the LT predicate on the "updated_at" field.
func UpdatedAtLT(v time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldLT(FieldUpdatedAt, v))
}

// UpdatedAtLTE applies the LTE predicate on the "updated_at" field.
func UpdatedAtLTE(v time.Time) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.FieldLTE(FieldUpdatedAt, v))
}

// HasUser applies the HasEdge predicate on the "user" edge.
func HasUser() predicate.SecurityScanning {
	return predicate.SecurityScanning(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, UserTable, UserColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasUserWith applies the HasEdge predicate on the "user" edge with a given conditions (other predicates).
func HasUserWith(preds ...predicate.User) predicate.SecurityScanning {
	return predicate.SecurityScanning(func(s *sql.Selector) {
		step := newUserStep()
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// HasResults applies the HasEdge predicate on the "results" edge.
func HasResults() predicate.SecurityScanning {
	return predicate.SecurityScanning(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, ResultsTable, ResultsColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasResultsWith applies the HasEdge predicate on the "results" edge with a given conditions (other predicates).
func HasResultsWith(preds ...predicate.SecurityScanningResult) predicate.SecurityScanning {
	return predicate.SecurityScanning(func(s *sql.Selector) {
		step := newResultsStep()
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// HasWorkspaceEdge applies the HasEdge predicate on the "workspace_edge" edge.
func HasWorkspaceEdge() predicate.SecurityScanning {
	return predicate.SecurityScanning(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, WorkspaceEdgeTable, WorkspaceEdgeColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasWorkspaceEdgeWith applies the HasEdge predicate on the "workspace_edge" edge with a given conditions (other predicates).
func HasWorkspaceEdgeWith(preds ...predicate.Workspace) predicate.SecurityScanning {
	return predicate.SecurityScanning(func(s *sql.Selector) {
		step := newWorkspaceEdgeStep()
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.SecurityScanning) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.AndPredicates(predicates...))
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.SecurityScanning) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.OrPredicates(predicates...))
}

// Not applies the not operator on the given predicate.
func Not(p predicate.SecurityScanning) predicate.SecurityScanning {
	return predicate.SecurityScanning(sql.NotPredicates(p))
}
