// Code generated by ent, DO NOT EDIT.

package securityscanning

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the securityscanning type in the database.
	Label = "security_scanning"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldUserID holds the string denoting the user_id field in the database.
	FieldUserID = "user_id"
	// FieldWorkspaceID holds the string denoting the workspace_id field in the database.
	FieldWorkspaceID = "workspace_id"
	// FieldStatus holds the string denoting the status field in the database.
	FieldStatus = "status"
	// FieldWorkspace holds the string denoting the workspace field in the database.
	FieldWorkspace = "workspace"
	// FieldLanguage holds the string denoting the language field in the database.
	FieldLanguage = "language"
	// FieldRule holds the string denoting the rule field in the database.
	FieldRule = "rule"
	// FieldErrorMessage holds the string denoting the error_message field in the database.
	FieldErrorMessage = "error_message"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// FieldUpdatedAt holds the string denoting the updated_at field in the database.
	FieldUpdatedAt = "updated_at"
	// EdgeUser holds the string denoting the user edge name in mutations.
	EdgeUser = "user"
	// EdgeResults holds the string denoting the results edge name in mutations.
	EdgeResults = "results"
	// EdgeWorkspaceEdge holds the string denoting the workspace_edge edge name in mutations.
	EdgeWorkspaceEdge = "workspace_edge"
	// Table holds the table name of the securityscanning in the database.
	Table = "security_scannings"
	// UserTable is the table that holds the user relation/edge.
	UserTable = "security_scannings"
	// UserInverseTable is the table name for the User entity.
	// It exists in this package in order to avoid circular dependency with the "user" package.
	UserInverseTable = "users"
	// UserColumn is the table column denoting the user relation/edge.
	UserColumn = "user_id"
	// ResultsTable is the table that holds the results relation/edge.
	ResultsTable = "security_scanning_results"
	// ResultsInverseTable is the table name for the SecurityScanningResult entity.
	// It exists in this package in order to avoid circular dependency with the "securityscanningresult" package.
	ResultsInverseTable = "security_scanning_results"
	// ResultsColumn is the table column denoting the results relation/edge.
	ResultsColumn = "security_scanning_id"
	// WorkspaceEdgeTable is the table that holds the workspace_edge relation/edge.
	WorkspaceEdgeTable = "security_scannings"
	// WorkspaceEdgeInverseTable is the table name for the Workspace entity.
	// It exists in this package in order to avoid circular dependency with the "workspace" package.
	WorkspaceEdgeInverseTable = "workspaces"
	// WorkspaceEdgeColumn is the table column denoting the workspace_edge relation/edge.
	WorkspaceEdgeColumn = "workspace_id"
)

// Columns holds all SQL columns for securityscanning fields.
var Columns = []string{
	FieldID,
	FieldUserID,
	FieldWorkspaceID,
	FieldStatus,
	FieldWorkspace,
	FieldLanguage,
	FieldRule,
	FieldErrorMessage,
	FieldCreatedAt,
	FieldUpdatedAt,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
	// DefaultUpdatedAt holds the default value on creation for the "updated_at" field.
	DefaultUpdatedAt func() time.Time
)

// OrderOption defines the ordering options for the SecurityScanning queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByUserID orders the results by the user_id field.
func ByUserID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUserID, opts...).ToFunc()
}

// ByWorkspaceID orders the results by the workspace_id field.
func ByWorkspaceID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldWorkspaceID, opts...).ToFunc()
}

// ByStatus orders the results by the status field.
func ByStatus(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldStatus, opts...).ToFunc()
}

// ByWorkspace orders the results by the workspace field.
func ByWorkspace(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldWorkspace, opts...).ToFunc()
}

// ByLanguage orders the results by the language field.
func ByLanguage(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldLanguage, opts...).ToFunc()
}

// ByRule orders the results by the rule field.
func ByRule(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldRule, opts...).ToFunc()
}

// ByErrorMessage orders the results by the error_message field.
func ByErrorMessage(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldErrorMessage, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByUpdatedAt orders the results by the updated_at field.
func ByUpdatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUpdatedAt, opts...).ToFunc()
}

// ByUserField orders the results by user field.
func ByUserField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newUserStep(), sql.OrderByField(field, opts...))
	}
}

// ByResultsCount orders the results by results count.
func ByResultsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newResultsStep(), opts...)
	}
}

// ByResults orders the results by results terms.
func ByResults(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newResultsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByWorkspaceEdgeField orders the results by workspace_edge field.
func ByWorkspaceEdgeField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newWorkspaceEdgeStep(), sql.OrderByField(field, opts...))
	}
}
func newUserStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(UserInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, UserTable, UserColumn),
	)
}
func newResultsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(ResultsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, ResultsTable, ResultsColumn),
	)
}
func newWorkspaceEdgeStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(WorkspaceEdgeInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, WorkspaceEdgeTable, WorkspaceEdgeColumn),
	)
}
