// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanning"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/workspace"
	"github.com/google/uuid"
)

// SecurityScanning is the model entity for the SecurityScanning schema.
type SecurityScanning struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// UserID holds the value of the "user_id" field.
	UserID uuid.UUID `json:"user_id,omitempty"`
	// WorkspaceID holds the value of the "workspace_id" field.
	WorkspaceID uuid.UUID `json:"workspace_id,omitempty"`
	// Status holds the value of the "status" field.
	Status consts.SecurityScanningStatus `json:"status,omitempty"`
	// Workspace holds the value of the "workspace" field.
	Workspace string `json:"workspace,omitempty"`
	// Language holds the value of the "language" field.
	Language consts.SecurityScanningLanguage `json:"language,omitempty"`
	// Rule holds the value of the "rule" field.
	Rule string `json:"rule,omitempty"`
	// ErrorMessage holds the value of the "error_message" field.
	ErrorMessage string `json:"error_message,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the SecurityScanningQuery when eager-loading is set.
	Edges        SecurityScanningEdges `json:"edges"`
	selectValues sql.SelectValues
}

// SecurityScanningEdges holds the relations/edges for other nodes in the graph.
type SecurityScanningEdges struct {
	// User holds the value of the user edge.
	User *User `json:"user,omitempty"`
	// Results holds the value of the results edge.
	Results []*SecurityScanningResult `json:"results,omitempty"`
	// WorkspaceEdge holds the value of the workspace_edge edge.
	WorkspaceEdge *Workspace `json:"workspace_edge,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [3]bool
}

// UserOrErr returns the User value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e SecurityScanningEdges) UserOrErr() (*User, error) {
	if e.User != nil {
		return e.User, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: user.Label}
	}
	return nil, &NotLoadedError{edge: "user"}
}

// ResultsOrErr returns the Results value or an error if the edge
// was not loaded in eager-loading.
func (e SecurityScanningEdges) ResultsOrErr() ([]*SecurityScanningResult, error) {
	if e.loadedTypes[1] {
		return e.Results, nil
	}
	return nil, &NotLoadedError{edge: "results"}
}

// WorkspaceEdgeOrErr returns the WorkspaceEdge value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e SecurityScanningEdges) WorkspaceEdgeOrErr() (*Workspace, error) {
	if e.WorkspaceEdge != nil {
		return e.WorkspaceEdge, nil
	} else if e.loadedTypes[2] {
		return nil, &NotFoundError{label: workspace.Label}
	}
	return nil, &NotLoadedError{edge: "workspace_edge"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*SecurityScanning) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case securityscanning.FieldStatus, securityscanning.FieldWorkspace, securityscanning.FieldLanguage, securityscanning.FieldRule, securityscanning.FieldErrorMessage:
			values[i] = new(sql.NullString)
		case securityscanning.FieldCreatedAt, securityscanning.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		case securityscanning.FieldID, securityscanning.FieldUserID, securityscanning.FieldWorkspaceID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the SecurityScanning fields.
func (ss *SecurityScanning) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case securityscanning.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				ss.ID = *value
			}
		case securityscanning.FieldUserID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field user_id", values[i])
			} else if value != nil {
				ss.UserID = *value
			}
		case securityscanning.FieldWorkspaceID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field workspace_id", values[i])
			} else if value != nil {
				ss.WorkspaceID = *value
			}
		case securityscanning.FieldStatus:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field status", values[i])
			} else if value.Valid {
				ss.Status = consts.SecurityScanningStatus(value.String)
			}
		case securityscanning.FieldWorkspace:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field workspace", values[i])
			} else if value.Valid {
				ss.Workspace = value.String
			}
		case securityscanning.FieldLanguage:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field language", values[i])
			} else if value.Valid {
				ss.Language = consts.SecurityScanningLanguage(value.String)
			}
		case securityscanning.FieldRule:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field rule", values[i])
			} else if value.Valid {
				ss.Rule = value.String
			}
		case securityscanning.FieldErrorMessage:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field error_message", values[i])
			} else if value.Valid {
				ss.ErrorMessage = value.String
			}
		case securityscanning.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				ss.CreatedAt = value.Time
			}
		case securityscanning.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				ss.UpdatedAt = value.Time
			}
		default:
			ss.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the SecurityScanning.
// This includes values selected through modifiers, order, etc.
func (ss *SecurityScanning) Value(name string) (ent.Value, error) {
	return ss.selectValues.Get(name)
}

// QueryUser queries the "user" edge of the SecurityScanning entity.
func (ss *SecurityScanning) QueryUser() *UserQuery {
	return NewSecurityScanningClient(ss.config).QueryUser(ss)
}

// QueryResults queries the "results" edge of the SecurityScanning entity.
func (ss *SecurityScanning) QueryResults() *SecurityScanningResultQuery {
	return NewSecurityScanningClient(ss.config).QueryResults(ss)
}

// QueryWorkspaceEdge queries the "workspace_edge" edge of the SecurityScanning entity.
func (ss *SecurityScanning) QueryWorkspaceEdge() *WorkspaceQuery {
	return NewSecurityScanningClient(ss.config).QueryWorkspaceEdge(ss)
}

// Update returns a builder for updating this SecurityScanning.
// Note that you need to call SecurityScanning.Unwrap() before calling this method if this SecurityScanning
// was returned from a transaction, and the transaction was committed or rolled back.
func (ss *SecurityScanning) Update() *SecurityScanningUpdateOne {
	return NewSecurityScanningClient(ss.config).UpdateOne(ss)
}

// Unwrap unwraps the SecurityScanning entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (ss *SecurityScanning) Unwrap() *SecurityScanning {
	_tx, ok := ss.config.driver.(*txDriver)
	if !ok {
		panic("db: SecurityScanning is not a transactional entity")
	}
	ss.config.driver = _tx.drv
	return ss
}

// String implements the fmt.Stringer.
func (ss *SecurityScanning) String() string {
	var builder strings.Builder
	builder.WriteString("SecurityScanning(")
	builder.WriteString(fmt.Sprintf("id=%v, ", ss.ID))
	builder.WriteString("user_id=")
	builder.WriteString(fmt.Sprintf("%v", ss.UserID))
	builder.WriteString(", ")
	builder.WriteString("workspace_id=")
	builder.WriteString(fmt.Sprintf("%v", ss.WorkspaceID))
	builder.WriteString(", ")
	builder.WriteString("status=")
	builder.WriteString(fmt.Sprintf("%v", ss.Status))
	builder.WriteString(", ")
	builder.WriteString("workspace=")
	builder.WriteString(ss.Workspace)
	builder.WriteString(", ")
	builder.WriteString("language=")
	builder.WriteString(fmt.Sprintf("%v", ss.Language))
	builder.WriteString(", ")
	builder.WriteString("rule=")
	builder.WriteString(ss.Rule)
	builder.WriteString(", ")
	builder.WriteString("error_message=")
	builder.WriteString(ss.ErrorMessage)
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(ss.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(ss.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// SecurityScannings is a parsable slice of SecurityScanning.
type SecurityScannings []*SecurityScanning
