// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"sync"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/adminloginhistory"
	"github.com/chaitin/MonkeyCode/backend/db/adminrole"
	"github.com/chaitin/MonkeyCode/backend/db/aiemployee"
	"github.com/chaitin/MonkeyCode/backend/db/aitask"
	"github.com/chaitin/MonkeyCode/backend/db/apikey"
	"github.com/chaitin/MonkeyCode/backend/db/billingplan"
	"github.com/chaitin/MonkeyCode/backend/db/billingquota"
	"github.com/chaitin/MonkeyCode/backend/db/billingrecord"
	"github.com/chaitin/MonkeyCode/backend/db/billingusage"
	"github.com/chaitin/MonkeyCode/backend/db/codesnippet"
	"github.com/chaitin/MonkeyCode/backend/db/extension"
	"github.com/chaitin/MonkeyCode/backend/db/invitecode"
	"github.com/chaitin/MonkeyCode/backend/db/license"
	"github.com/chaitin/MonkeyCode/backend/db/model"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovider"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovidermodel"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/role"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanning"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanningresult"
	"github.com/chaitin/MonkeyCode/backend/db/setting"
	"github.com/chaitin/MonkeyCode/backend/db/task"
	"github.com/chaitin/MonkeyCode/backend/db/taskrecord"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/usergroup"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupadmin"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupuser"
	"github.com/chaitin/MonkeyCode/backend/db/useridentity"
	"github.com/chaitin/MonkeyCode/backend/db/userloginhistory"
	"github.com/chaitin/MonkeyCode/backend/db/workspace"
	"github.com/chaitin/MonkeyCode/backend/db/workspacefile"
	"github.com/chaitin/MonkeyCode/backend/ent/types"
	"github.com/google/uuid"
	pgvector "github.com/pgvector/pgvector-go"
)

const (
	// Operation types.
	OpCreate    = ent.OpCreate
	OpDelete    = ent.OpDelete
	OpDeleteOne = ent.OpDeleteOne
	OpUpdate    = ent.OpUpdate
	OpUpdateOne = ent.OpUpdateOne

	// Node types.
	TypeAIEmployee             = "AIEmployee"
	TypeAITask                 = "AITask"
	TypeAdmin                  = "Admin"
	TypeAdminLoginHistory      = "AdminLoginHistory"
	TypeAdminRole              = "AdminRole"
	TypeApiKey                 = "ApiKey"
	TypeBillingPlan            = "BillingPlan"
	TypeBillingQuota           = "BillingQuota"
	TypeBillingRecord          = "BillingRecord"
	TypeBillingUsage           = "BillingUsage"
	TypeCodeSnippet            = "CodeSnippet"
	TypeExtension              = "Extension"
	TypeInviteCode             = "InviteCode"
	TypeLicense                = "License"
	TypeModel                  = "Model"
	TypeModelProvider          = "ModelProvider"
	TypeModelProviderModel     = "ModelProviderModel"
	TypeRole                   = "Role"
	TypeSecurityScanning       = "SecurityScanning"
	TypeSecurityScanningResult = "SecurityScanningResult"
	TypeSetting                = "Setting"
	TypeTask                   = "Task"
	TypeTaskRecord             = "TaskRecord"
	TypeUser                   = "User"
	TypeUserGroup              = "UserGroup"
	TypeUserGroupAdmin         = "UserGroupAdmin"
	TypeUserGroupUser          = "UserGroupUser"
	TypeUserIdentity           = "UserIdentity"
	TypeUserLoginHistory       = "UserLoginHistory"
	TypeWorkspace              = "Workspace"
	TypeWorkspaceFile          = "WorkspaceFile"
)

// AIEmployeeMutation represents an operation that mutates the AIEmployee nodes in the graph.
type AIEmployeeMutation struct {
	config
	op              Op
	typ             string
	id              *uuid.UUID
	name            *string
	position        *consts.AIEmployeePosition
	repository_url  *string
	repository_user *string
	platform        *consts.RepoPlatform
	token           *string
	webhook_secret  *string
	webhook_url     *string
	created_by      *consts.CreatedBy
	parameters      **types.AIEmployeeParam
	created_at      *time.Time
	updated_at      *time.Time
	clearedFields   map[string]struct{}
	admin           *uuid.UUID
	clearedadmin    bool
	user            *uuid.UUID
	cleareduser     bool
	done            bool
	oldValue        func(context.Context) (*AIEmployee, error)
	predicates      []predicate.AIEmployee
}

var _ ent.Mutation = (*AIEmployeeMutation)(nil)

// aiemployeeOption allows management of the mutation configuration using functional options.
type aiemployeeOption func(*AIEmployeeMutation)

// newAIEmployeeMutation creates new mutation for the AIEmployee entity.
func newAIEmployeeMutation(c config, op Op, opts ...aiemployeeOption) *AIEmployeeMutation {
	m := &AIEmployeeMutation{
		config:        c,
		op:            op,
		typ:           TypeAIEmployee,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withAIEmployeeID sets the ID field of the mutation.
func withAIEmployeeID(id uuid.UUID) aiemployeeOption {
	return func(m *AIEmployeeMutation) {
		var (
			err   error
			once  sync.Once
			value *AIEmployee
		)
		m.oldValue = func(ctx context.Context) (*AIEmployee, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().AIEmployee.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withAIEmployee sets the old AIEmployee of the mutation.
func withAIEmployee(node *AIEmployee) aiemployeeOption {
	return func(m *AIEmployeeMutation) {
		m.oldValue = func(context.Context) (*AIEmployee, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m AIEmployeeMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m AIEmployeeMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of AIEmployee entities.
func (m *AIEmployeeMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *AIEmployeeMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *AIEmployeeMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().AIEmployee.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetAdminID sets the "admin_id" field.
func (m *AIEmployeeMutation) SetAdminID(u uuid.UUID) {
	m.admin = &u
}

// AdminID returns the value of the "admin_id" field in the mutation.
func (m *AIEmployeeMutation) AdminID() (r uuid.UUID, exists bool) {
	v := m.admin
	if v == nil {
		return
	}
	return *v, true
}

// OldAdminID returns the old "admin_id" field's value of the AIEmployee entity.
// If the AIEmployee object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AIEmployeeMutation) OldAdminID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAdminID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAdminID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAdminID: %w", err)
	}
	return oldValue.AdminID, nil
}

// ClearAdminID clears the value of the "admin_id" field.
func (m *AIEmployeeMutation) ClearAdminID() {
	m.admin = nil
	m.clearedFields[aiemployee.FieldAdminID] = struct{}{}
}

// AdminIDCleared returns if the "admin_id" field was cleared in this mutation.
func (m *AIEmployeeMutation) AdminIDCleared() bool {
	_, ok := m.clearedFields[aiemployee.FieldAdminID]
	return ok
}

// ResetAdminID resets all changes to the "admin_id" field.
func (m *AIEmployeeMutation) ResetAdminID() {
	m.admin = nil
	delete(m.clearedFields, aiemployee.FieldAdminID)
}

// SetUserID sets the "user_id" field.
func (m *AIEmployeeMutation) SetUserID(u uuid.UUID) {
	m.user = &u
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *AIEmployeeMutation) UserID() (r uuid.UUID, exists bool) {
	v := m.user
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the AIEmployee entity.
// If the AIEmployee object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AIEmployeeMutation) OldUserID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ClearUserID clears the value of the "user_id" field.
func (m *AIEmployeeMutation) ClearUserID() {
	m.user = nil
	m.clearedFields[aiemployee.FieldUserID] = struct{}{}
}

// UserIDCleared returns if the "user_id" field was cleared in this mutation.
func (m *AIEmployeeMutation) UserIDCleared() bool {
	_, ok := m.clearedFields[aiemployee.FieldUserID]
	return ok
}

// ResetUserID resets all changes to the "user_id" field.
func (m *AIEmployeeMutation) ResetUserID() {
	m.user = nil
	delete(m.clearedFields, aiemployee.FieldUserID)
}

// SetName sets the "name" field.
func (m *AIEmployeeMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *AIEmployeeMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the AIEmployee entity.
// If the AIEmployee object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AIEmployeeMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *AIEmployeeMutation) ResetName() {
	m.name = nil
}

// SetPosition sets the "position" field.
func (m *AIEmployeeMutation) SetPosition(cep consts.AIEmployeePosition) {
	m.position = &cep
}

// Position returns the value of the "position" field in the mutation.
func (m *AIEmployeeMutation) Position() (r consts.AIEmployeePosition, exists bool) {
	v := m.position
	if v == nil {
		return
	}
	return *v, true
}

// OldPosition returns the old "position" field's value of the AIEmployee entity.
// If the AIEmployee object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AIEmployeeMutation) OldPosition(ctx context.Context) (v consts.AIEmployeePosition, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPosition is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPosition requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPosition: %w", err)
	}
	return oldValue.Position, nil
}

// ResetPosition resets all changes to the "position" field.
func (m *AIEmployeeMutation) ResetPosition() {
	m.position = nil
}

// SetRepositoryURL sets the "repository_url" field.
func (m *AIEmployeeMutation) SetRepositoryURL(s string) {
	m.repository_url = &s
}

// RepositoryURL returns the value of the "repository_url" field in the mutation.
func (m *AIEmployeeMutation) RepositoryURL() (r string, exists bool) {
	v := m.repository_url
	if v == nil {
		return
	}
	return *v, true
}

// OldRepositoryURL returns the old "repository_url" field's value of the AIEmployee entity.
// If the AIEmployee object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AIEmployeeMutation) OldRepositoryURL(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRepositoryURL is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRepositoryURL requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRepositoryURL: %w", err)
	}
	return oldValue.RepositoryURL, nil
}

// ResetRepositoryURL resets all changes to the "repository_url" field.
func (m *AIEmployeeMutation) ResetRepositoryURL() {
	m.repository_url = nil
}

// SetRepositoryUser sets the "repository_user" field.
func (m *AIEmployeeMutation) SetRepositoryUser(s string) {
	m.repository_user = &s
}

// RepositoryUser returns the value of the "repository_user" field in the mutation.
func (m *AIEmployeeMutation) RepositoryUser() (r string, exists bool) {
	v := m.repository_user
	if v == nil {
		return
	}
	return *v, true
}

// OldRepositoryUser returns the old "repository_user" field's value of the AIEmployee entity.
// If the AIEmployee object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AIEmployeeMutation) OldRepositoryUser(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRepositoryUser is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRepositoryUser requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRepositoryUser: %w", err)
	}
	return oldValue.RepositoryUser, nil
}

// ResetRepositoryUser resets all changes to the "repository_user" field.
func (m *AIEmployeeMutation) ResetRepositoryUser() {
	m.repository_user = nil
}

// SetPlatform sets the "platform" field.
func (m *AIEmployeeMutation) SetPlatform(cp consts.RepoPlatform) {
	m.platform = &cp
}

// Platform returns the value of the "platform" field in the mutation.
func (m *AIEmployeeMutation) Platform() (r consts.RepoPlatform, exists bool) {
	v := m.platform
	if v == nil {
		return
	}
	return *v, true
}

// OldPlatform returns the old "platform" field's value of the AIEmployee entity.
// If the AIEmployee object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AIEmployeeMutation) OldPlatform(ctx context.Context) (v consts.RepoPlatform, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPlatform is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPlatform requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPlatform: %w", err)
	}
	return oldValue.Platform, nil
}

// ResetPlatform resets all changes to the "platform" field.
func (m *AIEmployeeMutation) ResetPlatform() {
	m.platform = nil
}

// SetToken sets the "token" field.
func (m *AIEmployeeMutation) SetToken(s string) {
	m.token = &s
}

// Token returns the value of the "token" field in the mutation.
func (m *AIEmployeeMutation) Token() (r string, exists bool) {
	v := m.token
	if v == nil {
		return
	}
	return *v, true
}

// OldToken returns the old "token" field's value of the AIEmployee entity.
// If the AIEmployee object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AIEmployeeMutation) OldToken(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldToken is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldToken requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldToken: %w", err)
	}
	return oldValue.Token, nil
}

// ResetToken resets all changes to the "token" field.
func (m *AIEmployeeMutation) ResetToken() {
	m.token = nil
}

// SetWebhookSecret sets the "webhook_secret" field.
func (m *AIEmployeeMutation) SetWebhookSecret(s string) {
	m.webhook_secret = &s
}

// WebhookSecret returns the value of the "webhook_secret" field in the mutation.
func (m *AIEmployeeMutation) WebhookSecret() (r string, exists bool) {
	v := m.webhook_secret
	if v == nil {
		return
	}
	return *v, true
}

// OldWebhookSecret returns the old "webhook_secret" field's value of the AIEmployee entity.
// If the AIEmployee object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AIEmployeeMutation) OldWebhookSecret(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldWebhookSecret is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldWebhookSecret requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldWebhookSecret: %w", err)
	}
	return oldValue.WebhookSecret, nil
}

// ResetWebhookSecret resets all changes to the "webhook_secret" field.
func (m *AIEmployeeMutation) ResetWebhookSecret() {
	m.webhook_secret = nil
}

// SetWebhookURL sets the "webhook_url" field.
func (m *AIEmployeeMutation) SetWebhookURL(s string) {
	m.webhook_url = &s
}

// WebhookURL returns the value of the "webhook_url" field in the mutation.
func (m *AIEmployeeMutation) WebhookURL() (r string, exists bool) {
	v := m.webhook_url
	if v == nil {
		return
	}
	return *v, true
}

// OldWebhookURL returns the old "webhook_url" field's value of the AIEmployee entity.
// If the AIEmployee object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AIEmployeeMutation) OldWebhookURL(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldWebhookURL is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldWebhookURL requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldWebhookURL: %w", err)
	}
	return oldValue.WebhookURL, nil
}

// ResetWebhookURL resets all changes to the "webhook_url" field.
func (m *AIEmployeeMutation) ResetWebhookURL() {
	m.webhook_url = nil
}

// SetCreatedBy sets the "created_by" field.
func (m *AIEmployeeMutation) SetCreatedBy(cb consts.CreatedBy) {
	m.created_by = &cb
}

// CreatedBy returns the value of the "created_by" field in the mutation.
func (m *AIEmployeeMutation) CreatedBy() (r consts.CreatedBy, exists bool) {
	v := m.created_by
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedBy returns the old "created_by" field's value of the AIEmployee entity.
// If the AIEmployee object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AIEmployeeMutation) OldCreatedBy(ctx context.Context) (v consts.CreatedBy, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedBy is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedBy requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedBy: %w", err)
	}
	return oldValue.CreatedBy, nil
}

// ResetCreatedBy resets all changes to the "created_by" field.
func (m *AIEmployeeMutation) ResetCreatedBy() {
	m.created_by = nil
}

// SetParameters sets the "parameters" field.
func (m *AIEmployeeMutation) SetParameters(tep *types.AIEmployeeParam) {
	m.parameters = &tep
}

// Parameters returns the value of the "parameters" field in the mutation.
func (m *AIEmployeeMutation) Parameters() (r *types.AIEmployeeParam, exists bool) {
	v := m.parameters
	if v == nil {
		return
	}
	return *v, true
}

// OldParameters returns the old "parameters" field's value of the AIEmployee entity.
// If the AIEmployee object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AIEmployeeMutation) OldParameters(ctx context.Context) (v *types.AIEmployeeParam, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldParameters is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldParameters requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldParameters: %w", err)
	}
	return oldValue.Parameters, nil
}

// ResetParameters resets all changes to the "parameters" field.
func (m *AIEmployeeMutation) ResetParameters() {
	m.parameters = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *AIEmployeeMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *AIEmployeeMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the AIEmployee entity.
// If the AIEmployee object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AIEmployeeMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *AIEmployeeMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *AIEmployeeMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *AIEmployeeMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the AIEmployee entity.
// If the AIEmployee object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AIEmployeeMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *AIEmployeeMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// ClearAdmin clears the "admin" edge to the Admin entity.
func (m *AIEmployeeMutation) ClearAdmin() {
	m.clearedadmin = true
	m.clearedFields[aiemployee.FieldAdminID] = struct{}{}
}

// AdminCleared reports if the "admin" edge to the Admin entity was cleared.
func (m *AIEmployeeMutation) AdminCleared() bool {
	return m.AdminIDCleared() || m.clearedadmin
}

// AdminIDs returns the "admin" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// AdminID instead. It exists only for internal usage by the builders.
func (m *AIEmployeeMutation) AdminIDs() (ids []uuid.UUID) {
	if id := m.admin; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetAdmin resets all changes to the "admin" edge.
func (m *AIEmployeeMutation) ResetAdmin() {
	m.admin = nil
	m.clearedadmin = false
}

// ClearUser clears the "user" edge to the User entity.
func (m *AIEmployeeMutation) ClearUser() {
	m.cleareduser = true
	m.clearedFields[aiemployee.FieldUserID] = struct{}{}
}

// UserCleared reports if the "user" edge to the User entity was cleared.
func (m *AIEmployeeMutation) UserCleared() bool {
	return m.UserIDCleared() || m.cleareduser
}

// UserIDs returns the "user" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserID instead. It exists only for internal usage by the builders.
func (m *AIEmployeeMutation) UserIDs() (ids []uuid.UUID) {
	if id := m.user; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUser resets all changes to the "user" edge.
func (m *AIEmployeeMutation) ResetUser() {
	m.user = nil
	m.cleareduser = false
}

// Where appends a list predicates to the AIEmployeeMutation builder.
func (m *AIEmployeeMutation) Where(ps ...predicate.AIEmployee) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the AIEmployeeMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *AIEmployeeMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.AIEmployee, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *AIEmployeeMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *AIEmployeeMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (AIEmployee).
func (m *AIEmployeeMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *AIEmployeeMutation) Fields() []string {
	fields := make([]string, 0, 14)
	if m.admin != nil {
		fields = append(fields, aiemployee.FieldAdminID)
	}
	if m.user != nil {
		fields = append(fields, aiemployee.FieldUserID)
	}
	if m.name != nil {
		fields = append(fields, aiemployee.FieldName)
	}
	if m.position != nil {
		fields = append(fields, aiemployee.FieldPosition)
	}
	if m.repository_url != nil {
		fields = append(fields, aiemployee.FieldRepositoryURL)
	}
	if m.repository_user != nil {
		fields = append(fields, aiemployee.FieldRepositoryUser)
	}
	if m.platform != nil {
		fields = append(fields, aiemployee.FieldPlatform)
	}
	if m.token != nil {
		fields = append(fields, aiemployee.FieldToken)
	}
	if m.webhook_secret != nil {
		fields = append(fields, aiemployee.FieldWebhookSecret)
	}
	if m.webhook_url != nil {
		fields = append(fields, aiemployee.FieldWebhookURL)
	}
	if m.created_by != nil {
		fields = append(fields, aiemployee.FieldCreatedBy)
	}
	if m.parameters != nil {
		fields = append(fields, aiemployee.FieldParameters)
	}
	if m.created_at != nil {
		fields = append(fields, aiemployee.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, aiemployee.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *AIEmployeeMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case aiemployee.FieldAdminID:
		return m.AdminID()
	case aiemployee.FieldUserID:
		return m.UserID()
	case aiemployee.FieldName:
		return m.Name()
	case aiemployee.FieldPosition:
		return m.Position()
	case aiemployee.FieldRepositoryURL:
		return m.RepositoryURL()
	case aiemployee.FieldRepositoryUser:
		return m.RepositoryUser()
	case aiemployee.FieldPlatform:
		return m.Platform()
	case aiemployee.FieldToken:
		return m.Token()
	case aiemployee.FieldWebhookSecret:
		return m.WebhookSecret()
	case aiemployee.FieldWebhookURL:
		return m.WebhookURL()
	case aiemployee.FieldCreatedBy:
		return m.CreatedBy()
	case aiemployee.FieldParameters:
		return m.Parameters()
	case aiemployee.FieldCreatedAt:
		return m.CreatedAt()
	case aiemployee.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *AIEmployeeMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case aiemployee.FieldAdminID:
		return m.OldAdminID(ctx)
	case aiemployee.FieldUserID:
		return m.OldUserID(ctx)
	case aiemployee.FieldName:
		return m.OldName(ctx)
	case aiemployee.FieldPosition:
		return m.OldPosition(ctx)
	case aiemployee.FieldRepositoryURL:
		return m.OldRepositoryURL(ctx)
	case aiemployee.FieldRepositoryUser:
		return m.OldRepositoryUser(ctx)
	case aiemployee.FieldPlatform:
		return m.OldPlatform(ctx)
	case aiemployee.FieldToken:
		return m.OldToken(ctx)
	case aiemployee.FieldWebhookSecret:
		return m.OldWebhookSecret(ctx)
	case aiemployee.FieldWebhookURL:
		return m.OldWebhookURL(ctx)
	case aiemployee.FieldCreatedBy:
		return m.OldCreatedBy(ctx)
	case aiemployee.FieldParameters:
		return m.OldParameters(ctx)
	case aiemployee.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case aiemployee.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown AIEmployee field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AIEmployeeMutation) SetField(name string, value ent.Value) error {
	switch name {
	case aiemployee.FieldAdminID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAdminID(v)
		return nil
	case aiemployee.FieldUserID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case aiemployee.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case aiemployee.FieldPosition:
		v, ok := value.(consts.AIEmployeePosition)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPosition(v)
		return nil
	case aiemployee.FieldRepositoryURL:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRepositoryURL(v)
		return nil
	case aiemployee.FieldRepositoryUser:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRepositoryUser(v)
		return nil
	case aiemployee.FieldPlatform:
		v, ok := value.(consts.RepoPlatform)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPlatform(v)
		return nil
	case aiemployee.FieldToken:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetToken(v)
		return nil
	case aiemployee.FieldWebhookSecret:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetWebhookSecret(v)
		return nil
	case aiemployee.FieldWebhookURL:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetWebhookURL(v)
		return nil
	case aiemployee.FieldCreatedBy:
		v, ok := value.(consts.CreatedBy)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedBy(v)
		return nil
	case aiemployee.FieldParameters:
		v, ok := value.(*types.AIEmployeeParam)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetParameters(v)
		return nil
	case aiemployee.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case aiemployee.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown AIEmployee field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *AIEmployeeMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *AIEmployeeMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AIEmployeeMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown AIEmployee numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *AIEmployeeMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(aiemployee.FieldAdminID) {
		fields = append(fields, aiemployee.FieldAdminID)
	}
	if m.FieldCleared(aiemployee.FieldUserID) {
		fields = append(fields, aiemployee.FieldUserID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *AIEmployeeMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *AIEmployeeMutation) ClearField(name string) error {
	switch name {
	case aiemployee.FieldAdminID:
		m.ClearAdminID()
		return nil
	case aiemployee.FieldUserID:
		m.ClearUserID()
		return nil
	}
	return fmt.Errorf("unknown AIEmployee nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *AIEmployeeMutation) ResetField(name string) error {
	switch name {
	case aiemployee.FieldAdminID:
		m.ResetAdminID()
		return nil
	case aiemployee.FieldUserID:
		m.ResetUserID()
		return nil
	case aiemployee.FieldName:
		m.ResetName()
		return nil
	case aiemployee.FieldPosition:
		m.ResetPosition()
		return nil
	case aiemployee.FieldRepositoryURL:
		m.ResetRepositoryURL()
		return nil
	case aiemployee.FieldRepositoryUser:
		m.ResetRepositoryUser()
		return nil
	case aiemployee.FieldPlatform:
		m.ResetPlatform()
		return nil
	case aiemployee.FieldToken:
		m.ResetToken()
		return nil
	case aiemployee.FieldWebhookSecret:
		m.ResetWebhookSecret()
		return nil
	case aiemployee.FieldWebhookURL:
		m.ResetWebhookURL()
		return nil
	case aiemployee.FieldCreatedBy:
		m.ResetCreatedBy()
		return nil
	case aiemployee.FieldParameters:
		m.ResetParameters()
		return nil
	case aiemployee.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case aiemployee.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown AIEmployee field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *AIEmployeeMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.admin != nil {
		edges = append(edges, aiemployee.EdgeAdmin)
	}
	if m.user != nil {
		edges = append(edges, aiemployee.EdgeUser)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *AIEmployeeMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case aiemployee.EdgeAdmin:
		if id := m.admin; id != nil {
			return []ent.Value{*id}
		}
	case aiemployee.EdgeUser:
		if id := m.user; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *AIEmployeeMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *AIEmployeeMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *AIEmployeeMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedadmin {
		edges = append(edges, aiemployee.EdgeAdmin)
	}
	if m.cleareduser {
		edges = append(edges, aiemployee.EdgeUser)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *AIEmployeeMutation) EdgeCleared(name string) bool {
	switch name {
	case aiemployee.EdgeAdmin:
		return m.clearedadmin
	case aiemployee.EdgeUser:
		return m.cleareduser
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *AIEmployeeMutation) ClearEdge(name string) error {
	switch name {
	case aiemployee.EdgeAdmin:
		m.ClearAdmin()
		return nil
	case aiemployee.EdgeUser:
		m.ClearUser()
		return nil
	}
	return fmt.Errorf("unknown AIEmployee unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *AIEmployeeMutation) ResetEdge(name string) error {
	switch name {
	case aiemployee.EdgeAdmin:
		m.ResetAdmin()
		return nil
	case aiemployee.EdgeUser:
		m.ResetUser()
		return nil
	}
	return fmt.Errorf("unknown AIEmployee edge %s", name)
}

// AITaskMutation represents an operation that mutates the AITask nodes in the graph.
type AITaskMutation struct {
	config
	op            Op
	typ           string
	id            *uuid.UUID
	employee_id   *uuid.UUID
	status        *string
	output        *string
	logs          *string
	error_message *string
	created_at    *time.Time
	updated_at    *time.Time
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*AITask, error)
	predicates    []predicate.AITask
}

var _ ent.Mutation = (*AITaskMutation)(nil)

// aitaskOption allows management of the mutation configuration using functional options.
type aitaskOption func(*AITaskMutation)

// newAITaskMutation creates new mutation for the AITask entity.
func newAITaskMutation(c config, op Op, opts ...aitaskOption) *AITaskMutation {
	m := &AITaskMutation{
		config:        c,
		op:            op,
		typ:           TypeAITask,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withAITaskID sets the ID field of the mutation.
func withAITaskID(id uuid.UUID) aitaskOption {
	return func(m *AITaskMutation) {
		var (
			err   error
			once  sync.Once
			value *AITask
		)
		m.oldValue = func(ctx context.Context) (*AITask, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().AITask.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withAITask sets the old AITask of the mutation.
func withAITask(node *AITask) aitaskOption {
	return func(m *AITaskMutation) {
		m.oldValue = func(context.Context) (*AITask, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m AITaskMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m AITaskMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of AITask entities.
func (m *AITaskMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *AITaskMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *AITaskMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().AITask.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetEmployeeID sets the "employee_id" field.
func (m *AITaskMutation) SetEmployeeID(u uuid.UUID) {
	m.employee_id = &u
}

// EmployeeID returns the value of the "employee_id" field in the mutation.
func (m *AITaskMutation) EmployeeID() (r uuid.UUID, exists bool) {
	v := m.employee_id
	if v == nil {
		return
	}
	return *v, true
}

// OldEmployeeID returns the old "employee_id" field's value of the AITask entity.
// If the AITask object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AITaskMutation) OldEmployeeID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEmployeeID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEmployeeID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEmployeeID: %w", err)
	}
	return oldValue.EmployeeID, nil
}

// ResetEmployeeID resets all changes to the "employee_id" field.
func (m *AITaskMutation) ResetEmployeeID() {
	m.employee_id = nil
}

// SetStatus sets the "status" field.
func (m *AITaskMutation) SetStatus(s string) {
	m.status = &s
}

// Status returns the value of the "status" field in the mutation.
func (m *AITaskMutation) Status() (r string, exists bool) {
	v := m.status
	if v == nil {
		return
	}
	return *v, true
}

// OldStatus returns the old "status" field's value of the AITask entity.
// If the AITask object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AITaskMutation) OldStatus(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStatus is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStatus requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStatus: %w", err)
	}
	return oldValue.Status, nil
}

// ResetStatus resets all changes to the "status" field.
func (m *AITaskMutation) ResetStatus() {
	m.status = nil
}

// SetOutput sets the "output" field.
func (m *AITaskMutation) SetOutput(s string) {
	m.output = &s
}

// Output returns the value of the "output" field in the mutation.
func (m *AITaskMutation) Output() (r string, exists bool) {
	v := m.output
	if v == nil {
		return
	}
	return *v, true
}

// OldOutput returns the old "output" field's value of the AITask entity.
// If the AITask object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AITaskMutation) OldOutput(ctx context.Context) (v *string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOutput is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOutput requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOutput: %w", err)
	}
	return oldValue.Output, nil
}

// ClearOutput clears the value of the "output" field.
func (m *AITaskMutation) ClearOutput() {
	m.output = nil
	m.clearedFields[aitask.FieldOutput] = struct{}{}
}

// OutputCleared returns if the "output" field was cleared in this mutation.
func (m *AITaskMutation) OutputCleared() bool {
	_, ok := m.clearedFields[aitask.FieldOutput]
	return ok
}

// ResetOutput resets all changes to the "output" field.
func (m *AITaskMutation) ResetOutput() {
	m.output = nil
	delete(m.clearedFields, aitask.FieldOutput)
}

// SetLogs sets the "logs" field.
func (m *AITaskMutation) SetLogs(s string) {
	m.logs = &s
}

// Logs returns the value of the "logs" field in the mutation.
func (m *AITaskMutation) Logs() (r string, exists bool) {
	v := m.logs
	if v == nil {
		return
	}
	return *v, true
}

// OldLogs returns the old "logs" field's value of the AITask entity.
// If the AITask object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AITaskMutation) OldLogs(ctx context.Context) (v *string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldLogs is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldLogs requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLogs: %w", err)
	}
	return oldValue.Logs, nil
}

// ClearLogs clears the value of the "logs" field.
func (m *AITaskMutation) ClearLogs() {
	m.logs = nil
	m.clearedFields[aitask.FieldLogs] = struct{}{}
}

// LogsCleared returns if the "logs" field was cleared in this mutation.
func (m *AITaskMutation) LogsCleared() bool {
	_, ok := m.clearedFields[aitask.FieldLogs]
	return ok
}

// ResetLogs resets all changes to the "logs" field.
func (m *AITaskMutation) ResetLogs() {
	m.logs = nil
	delete(m.clearedFields, aitask.FieldLogs)
}

// SetErrorMessage sets the "error_message" field.
func (m *AITaskMutation) SetErrorMessage(s string) {
	m.error_message = &s
}

// ErrorMessage returns the value of the "error_message" field in the mutation.
func (m *AITaskMutation) ErrorMessage() (r string, exists bool) {
	v := m.error_message
	if v == nil {
		return
	}
	return *v, true
}

// OldErrorMessage returns the old "error_message" field's value of the AITask entity.
// If the AITask object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AITaskMutation) OldErrorMessage(ctx context.Context) (v *string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldErrorMessage is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldErrorMessage requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldErrorMessage: %w", err)
	}
	return oldValue.ErrorMessage, nil
}

// ClearErrorMessage clears the value of the "error_message" field.
func (m *AITaskMutation) ClearErrorMessage() {
	m.error_message = nil
	m.clearedFields[aitask.FieldErrorMessage] = struct{}{}
}

// ErrorMessageCleared returns if the "error_message" field was cleared in this mutation.
func (m *AITaskMutation) ErrorMessageCleared() bool {
	_, ok := m.clearedFields[aitask.FieldErrorMessage]
	return ok
}

// ResetErrorMessage resets all changes to the "error_message" field.
func (m *AITaskMutation) ResetErrorMessage() {
	m.error_message = nil
	delete(m.clearedFields, aitask.FieldErrorMessage)
}

// SetCreatedAt sets the "created_at" field.
func (m *AITaskMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *AITaskMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the AITask entity.
// If the AITask object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AITaskMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *AITaskMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *AITaskMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *AITaskMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the AITask entity.
// If the AITask object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AITaskMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *AITaskMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// Where appends a list predicates to the AITaskMutation builder.
func (m *AITaskMutation) Where(ps ...predicate.AITask) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the AITaskMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *AITaskMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.AITask, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *AITaskMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *AITaskMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (AITask).
func (m *AITaskMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *AITaskMutation) Fields() []string {
	fields := make([]string, 0, 7)
	if m.employee_id != nil {
		fields = append(fields, aitask.FieldEmployeeID)
	}
	if m.status != nil {
		fields = append(fields, aitask.FieldStatus)
	}
	if m.output != nil {
		fields = append(fields, aitask.FieldOutput)
	}
	if m.logs != nil {
		fields = append(fields, aitask.FieldLogs)
	}
	if m.error_message != nil {
		fields = append(fields, aitask.FieldErrorMessage)
	}
	if m.created_at != nil {
		fields = append(fields, aitask.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, aitask.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *AITaskMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case aitask.FieldEmployeeID:
		return m.EmployeeID()
	case aitask.FieldStatus:
		return m.Status()
	case aitask.FieldOutput:
		return m.Output()
	case aitask.FieldLogs:
		return m.Logs()
	case aitask.FieldErrorMessage:
		return m.ErrorMessage()
	case aitask.FieldCreatedAt:
		return m.CreatedAt()
	case aitask.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *AITaskMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case aitask.FieldEmployeeID:
		return m.OldEmployeeID(ctx)
	case aitask.FieldStatus:
		return m.OldStatus(ctx)
	case aitask.FieldOutput:
		return m.OldOutput(ctx)
	case aitask.FieldLogs:
		return m.OldLogs(ctx)
	case aitask.FieldErrorMessage:
		return m.OldErrorMessage(ctx)
	case aitask.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case aitask.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown AITask field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AITaskMutation) SetField(name string, value ent.Value) error {
	switch name {
	case aitask.FieldEmployeeID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEmployeeID(v)
		return nil
	case aitask.FieldStatus:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStatus(v)
		return nil
	case aitask.FieldOutput:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOutput(v)
		return nil
	case aitask.FieldLogs:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLogs(v)
		return nil
	case aitask.FieldErrorMessage:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetErrorMessage(v)
		return nil
	case aitask.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case aitask.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown AITask field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *AITaskMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *AITaskMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AITaskMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown AITask numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *AITaskMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(aitask.FieldOutput) {
		fields = append(fields, aitask.FieldOutput)
	}
	if m.FieldCleared(aitask.FieldLogs) {
		fields = append(fields, aitask.FieldLogs)
	}
	if m.FieldCleared(aitask.FieldErrorMessage) {
		fields = append(fields, aitask.FieldErrorMessage)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *AITaskMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *AITaskMutation) ClearField(name string) error {
	switch name {
	case aitask.FieldOutput:
		m.ClearOutput()
		return nil
	case aitask.FieldLogs:
		m.ClearLogs()
		return nil
	case aitask.FieldErrorMessage:
		m.ClearErrorMessage()
		return nil
	}
	return fmt.Errorf("unknown AITask nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *AITaskMutation) ResetField(name string) error {
	switch name {
	case aitask.FieldEmployeeID:
		m.ResetEmployeeID()
		return nil
	case aitask.FieldStatus:
		m.ResetStatus()
		return nil
	case aitask.FieldOutput:
		m.ResetOutput()
		return nil
	case aitask.FieldLogs:
		m.ResetLogs()
		return nil
	case aitask.FieldErrorMessage:
		m.ResetErrorMessage()
		return nil
	case aitask.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case aitask.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown AITask field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *AITaskMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *AITaskMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *AITaskMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *AITaskMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *AITaskMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *AITaskMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *AITaskMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown AITask unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *AITaskMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown AITask edge %s", name)
}

// AdminMutation represents an operation that mutates the Admin nodes in the graph.
type AdminMutation struct {
	config
	op                       Op
	typ                      string
	id                       *uuid.UUID
	username                 *string
	password                 *string
	status                   *consts.AdminStatus
	last_active_at           *time.Time
	created_at               *time.Time
	updated_at               *time.Time
	clearedFields            map[string]struct{}
	login_histories          map[uuid.UUID]struct{}
	removedlogin_histories   map[uuid.UUID]struct{}
	clearedlogin_histories   bool
	myusergroups             map[uuid.UUID]struct{}
	removedmyusergroups      map[uuid.UUID]struct{}
	clearedmyusergroups      bool
	aiemployees              map[uuid.UUID]struct{}
	removedaiemployees       map[uuid.UUID]struct{}
	clearedaiemployees       bool
	usergroups               map[uuid.UUID]struct{}
	removedusergroups        map[uuid.UUID]struct{}
	clearedusergroups        bool
	roles                    map[int64]struct{}
	removedroles             map[int64]struct{}
	clearedroles             bool
	user_group_admins        map[uuid.UUID]struct{}
	removeduser_group_admins map[uuid.UUID]struct{}
	cleareduser_group_admins bool
	admin_roles              map[uuid.UUID]struct{}
	removedadmin_roles       map[uuid.UUID]struct{}
	clearedadmin_roles       bool
	done                     bool
	oldValue                 func(context.Context) (*Admin, error)
	predicates               []predicate.Admin
}

var _ ent.Mutation = (*AdminMutation)(nil)

// adminOption allows management of the mutation configuration using functional options.
type adminOption func(*AdminMutation)

// newAdminMutation creates new mutation for the Admin entity.
func newAdminMutation(c config, op Op, opts ...adminOption) *AdminMutation {
	m := &AdminMutation{
		config:        c,
		op:            op,
		typ:           TypeAdmin,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withAdminID sets the ID field of the mutation.
func withAdminID(id uuid.UUID) adminOption {
	return func(m *AdminMutation) {
		var (
			err   error
			once  sync.Once
			value *Admin
		)
		m.oldValue = func(ctx context.Context) (*Admin, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Admin.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withAdmin sets the old Admin of the mutation.
func withAdmin(node *Admin) adminOption {
	return func(m *AdminMutation) {
		m.oldValue = func(context.Context) (*Admin, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m AdminMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m AdminMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Admin entities.
func (m *AdminMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *AdminMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *AdminMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Admin.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetUsername sets the "username" field.
func (m *AdminMutation) SetUsername(s string) {
	m.username = &s
}

// Username returns the value of the "username" field in the mutation.
func (m *AdminMutation) Username() (r string, exists bool) {
	v := m.username
	if v == nil {
		return
	}
	return *v, true
}

// OldUsername returns the old "username" field's value of the Admin entity.
// If the Admin object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminMutation) OldUsername(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUsername is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUsername requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUsername: %w", err)
	}
	return oldValue.Username, nil
}

// ResetUsername resets all changes to the "username" field.
func (m *AdminMutation) ResetUsername() {
	m.username = nil
}

// SetPassword sets the "password" field.
func (m *AdminMutation) SetPassword(s string) {
	m.password = &s
}

// Password returns the value of the "password" field in the mutation.
func (m *AdminMutation) Password() (r string, exists bool) {
	v := m.password
	if v == nil {
		return
	}
	return *v, true
}

// OldPassword returns the old "password" field's value of the Admin entity.
// If the Admin object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminMutation) OldPassword(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPassword is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPassword requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPassword: %w", err)
	}
	return oldValue.Password, nil
}

// ResetPassword resets all changes to the "password" field.
func (m *AdminMutation) ResetPassword() {
	m.password = nil
}

// SetStatus sets the "status" field.
func (m *AdminMutation) SetStatus(cs consts.AdminStatus) {
	m.status = &cs
}

// Status returns the value of the "status" field in the mutation.
func (m *AdminMutation) Status() (r consts.AdminStatus, exists bool) {
	v := m.status
	if v == nil {
		return
	}
	return *v, true
}

// OldStatus returns the old "status" field's value of the Admin entity.
// If the Admin object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminMutation) OldStatus(ctx context.Context) (v consts.AdminStatus, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStatus is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStatus requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStatus: %w", err)
	}
	return oldValue.Status, nil
}

// ResetStatus resets all changes to the "status" field.
func (m *AdminMutation) ResetStatus() {
	m.status = nil
}

// SetLastActiveAt sets the "last_active_at" field.
func (m *AdminMutation) SetLastActiveAt(t time.Time) {
	m.last_active_at = &t
}

// LastActiveAt returns the value of the "last_active_at" field in the mutation.
func (m *AdminMutation) LastActiveAt() (r time.Time, exists bool) {
	v := m.last_active_at
	if v == nil {
		return
	}
	return *v, true
}

// OldLastActiveAt returns the old "last_active_at" field's value of the Admin entity.
// If the Admin object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminMutation) OldLastActiveAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldLastActiveAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldLastActiveAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLastActiveAt: %w", err)
	}
	return oldValue.LastActiveAt, nil
}

// ResetLastActiveAt resets all changes to the "last_active_at" field.
func (m *AdminMutation) ResetLastActiveAt() {
	m.last_active_at = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *AdminMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *AdminMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Admin entity.
// If the Admin object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *AdminMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *AdminMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *AdminMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Admin entity.
// If the Admin object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *AdminMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// AddLoginHistoryIDs adds the "login_histories" edge to the AdminLoginHistory entity by ids.
func (m *AdminMutation) AddLoginHistoryIDs(ids ...uuid.UUID) {
	if m.login_histories == nil {
		m.login_histories = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.login_histories[ids[i]] = struct{}{}
	}
}

// ClearLoginHistories clears the "login_histories" edge to the AdminLoginHistory entity.
func (m *AdminMutation) ClearLoginHistories() {
	m.clearedlogin_histories = true
}

// LoginHistoriesCleared reports if the "login_histories" edge to the AdminLoginHistory entity was cleared.
func (m *AdminMutation) LoginHistoriesCleared() bool {
	return m.clearedlogin_histories
}

// RemoveLoginHistoryIDs removes the "login_histories" edge to the AdminLoginHistory entity by IDs.
func (m *AdminMutation) RemoveLoginHistoryIDs(ids ...uuid.UUID) {
	if m.removedlogin_histories == nil {
		m.removedlogin_histories = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.login_histories, ids[i])
		m.removedlogin_histories[ids[i]] = struct{}{}
	}
}

// RemovedLoginHistories returns the removed IDs of the "login_histories" edge to the AdminLoginHistory entity.
func (m *AdminMutation) RemovedLoginHistoriesIDs() (ids []uuid.UUID) {
	for id := range m.removedlogin_histories {
		ids = append(ids, id)
	}
	return
}

// LoginHistoriesIDs returns the "login_histories" edge IDs in the mutation.
func (m *AdminMutation) LoginHistoriesIDs() (ids []uuid.UUID) {
	for id := range m.login_histories {
		ids = append(ids, id)
	}
	return
}

// ResetLoginHistories resets all changes to the "login_histories" edge.
func (m *AdminMutation) ResetLoginHistories() {
	m.login_histories = nil
	m.clearedlogin_histories = false
	m.removedlogin_histories = nil
}

// AddMyusergroupIDs adds the "myusergroups" edge to the UserGroup entity by ids.
func (m *AdminMutation) AddMyusergroupIDs(ids ...uuid.UUID) {
	if m.myusergroups == nil {
		m.myusergroups = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.myusergroups[ids[i]] = struct{}{}
	}
}

// ClearMyusergroups clears the "myusergroups" edge to the UserGroup entity.
func (m *AdminMutation) ClearMyusergroups() {
	m.clearedmyusergroups = true
}

// MyusergroupsCleared reports if the "myusergroups" edge to the UserGroup entity was cleared.
func (m *AdminMutation) MyusergroupsCleared() bool {
	return m.clearedmyusergroups
}

// RemoveMyusergroupIDs removes the "myusergroups" edge to the UserGroup entity by IDs.
func (m *AdminMutation) RemoveMyusergroupIDs(ids ...uuid.UUID) {
	if m.removedmyusergroups == nil {
		m.removedmyusergroups = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.myusergroups, ids[i])
		m.removedmyusergroups[ids[i]] = struct{}{}
	}
}

// RemovedMyusergroups returns the removed IDs of the "myusergroups" edge to the UserGroup entity.
func (m *AdminMutation) RemovedMyusergroupsIDs() (ids []uuid.UUID) {
	for id := range m.removedmyusergroups {
		ids = append(ids, id)
	}
	return
}

// MyusergroupsIDs returns the "myusergroups" edge IDs in the mutation.
func (m *AdminMutation) MyusergroupsIDs() (ids []uuid.UUID) {
	for id := range m.myusergroups {
		ids = append(ids, id)
	}
	return
}

// ResetMyusergroups resets all changes to the "myusergroups" edge.
func (m *AdminMutation) ResetMyusergroups() {
	m.myusergroups = nil
	m.clearedmyusergroups = false
	m.removedmyusergroups = nil
}

// AddAiemployeeIDs adds the "aiemployees" edge to the AIEmployee entity by ids.
func (m *AdminMutation) AddAiemployeeIDs(ids ...uuid.UUID) {
	if m.aiemployees == nil {
		m.aiemployees = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.aiemployees[ids[i]] = struct{}{}
	}
}

// ClearAiemployees clears the "aiemployees" edge to the AIEmployee entity.
func (m *AdminMutation) ClearAiemployees() {
	m.clearedaiemployees = true
}

// AiemployeesCleared reports if the "aiemployees" edge to the AIEmployee entity was cleared.
func (m *AdminMutation) AiemployeesCleared() bool {
	return m.clearedaiemployees
}

// RemoveAiemployeeIDs removes the "aiemployees" edge to the AIEmployee entity by IDs.
func (m *AdminMutation) RemoveAiemployeeIDs(ids ...uuid.UUID) {
	if m.removedaiemployees == nil {
		m.removedaiemployees = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.aiemployees, ids[i])
		m.removedaiemployees[ids[i]] = struct{}{}
	}
}

// RemovedAiemployees returns the removed IDs of the "aiemployees" edge to the AIEmployee entity.
func (m *AdminMutation) RemovedAiemployeesIDs() (ids []uuid.UUID) {
	for id := range m.removedaiemployees {
		ids = append(ids, id)
	}
	return
}

// AiemployeesIDs returns the "aiemployees" edge IDs in the mutation.
func (m *AdminMutation) AiemployeesIDs() (ids []uuid.UUID) {
	for id := range m.aiemployees {
		ids = append(ids, id)
	}
	return
}

// ResetAiemployees resets all changes to the "aiemployees" edge.
func (m *AdminMutation) ResetAiemployees() {
	m.aiemployees = nil
	m.clearedaiemployees = false
	m.removedaiemployees = nil
}

// AddUsergroupIDs adds the "usergroups" edge to the UserGroup entity by ids.
func (m *AdminMutation) AddUsergroupIDs(ids ...uuid.UUID) {
	if m.usergroups == nil {
		m.usergroups = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.usergroups[ids[i]] = struct{}{}
	}
}

// ClearUsergroups clears the "usergroups" edge to the UserGroup entity.
func (m *AdminMutation) ClearUsergroups() {
	m.clearedusergroups = true
}

// UsergroupsCleared reports if the "usergroups" edge to the UserGroup entity was cleared.
func (m *AdminMutation) UsergroupsCleared() bool {
	return m.clearedusergroups
}

// RemoveUsergroupIDs removes the "usergroups" edge to the UserGroup entity by IDs.
func (m *AdminMutation) RemoveUsergroupIDs(ids ...uuid.UUID) {
	if m.removedusergroups == nil {
		m.removedusergroups = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.usergroups, ids[i])
		m.removedusergroups[ids[i]] = struct{}{}
	}
}

// RemovedUsergroups returns the removed IDs of the "usergroups" edge to the UserGroup entity.
func (m *AdminMutation) RemovedUsergroupsIDs() (ids []uuid.UUID) {
	for id := range m.removedusergroups {
		ids = append(ids, id)
	}
	return
}

// UsergroupsIDs returns the "usergroups" edge IDs in the mutation.
func (m *AdminMutation) UsergroupsIDs() (ids []uuid.UUID) {
	for id := range m.usergroups {
		ids = append(ids, id)
	}
	return
}

// ResetUsergroups resets all changes to the "usergroups" edge.
func (m *AdminMutation) ResetUsergroups() {
	m.usergroups = nil
	m.clearedusergroups = false
	m.removedusergroups = nil
}

// AddRoleIDs adds the "roles" edge to the Role entity by ids.
func (m *AdminMutation) AddRoleIDs(ids ...int64) {
	if m.roles == nil {
		m.roles = make(map[int64]struct{})
	}
	for i := range ids {
		m.roles[ids[i]] = struct{}{}
	}
}

// ClearRoles clears the "roles" edge to the Role entity.
func (m *AdminMutation) ClearRoles() {
	m.clearedroles = true
}

// RolesCleared reports if the "roles" edge to the Role entity was cleared.
func (m *AdminMutation) RolesCleared() bool {
	return m.clearedroles
}

// RemoveRoleIDs removes the "roles" edge to the Role entity by IDs.
func (m *AdminMutation) RemoveRoleIDs(ids ...int64) {
	if m.removedroles == nil {
		m.removedroles = make(map[int64]struct{})
	}
	for i := range ids {
		delete(m.roles, ids[i])
		m.removedroles[ids[i]] = struct{}{}
	}
}

// RemovedRoles returns the removed IDs of the "roles" edge to the Role entity.
func (m *AdminMutation) RemovedRolesIDs() (ids []int64) {
	for id := range m.removedroles {
		ids = append(ids, id)
	}
	return
}

// RolesIDs returns the "roles" edge IDs in the mutation.
func (m *AdminMutation) RolesIDs() (ids []int64) {
	for id := range m.roles {
		ids = append(ids, id)
	}
	return
}

// ResetRoles resets all changes to the "roles" edge.
func (m *AdminMutation) ResetRoles() {
	m.roles = nil
	m.clearedroles = false
	m.removedroles = nil
}

// AddUserGroupAdminIDs adds the "user_group_admins" edge to the UserGroupAdmin entity by ids.
func (m *AdminMutation) AddUserGroupAdminIDs(ids ...uuid.UUID) {
	if m.user_group_admins == nil {
		m.user_group_admins = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.user_group_admins[ids[i]] = struct{}{}
	}
}

// ClearUserGroupAdmins clears the "user_group_admins" edge to the UserGroupAdmin entity.
func (m *AdminMutation) ClearUserGroupAdmins() {
	m.cleareduser_group_admins = true
}

// UserGroupAdminsCleared reports if the "user_group_admins" edge to the UserGroupAdmin entity was cleared.
func (m *AdminMutation) UserGroupAdminsCleared() bool {
	return m.cleareduser_group_admins
}

// RemoveUserGroupAdminIDs removes the "user_group_admins" edge to the UserGroupAdmin entity by IDs.
func (m *AdminMutation) RemoveUserGroupAdminIDs(ids ...uuid.UUID) {
	if m.removeduser_group_admins == nil {
		m.removeduser_group_admins = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.user_group_admins, ids[i])
		m.removeduser_group_admins[ids[i]] = struct{}{}
	}
}

// RemovedUserGroupAdmins returns the removed IDs of the "user_group_admins" edge to the UserGroupAdmin entity.
func (m *AdminMutation) RemovedUserGroupAdminsIDs() (ids []uuid.UUID) {
	for id := range m.removeduser_group_admins {
		ids = append(ids, id)
	}
	return
}

// UserGroupAdminsIDs returns the "user_group_admins" edge IDs in the mutation.
func (m *AdminMutation) UserGroupAdminsIDs() (ids []uuid.UUID) {
	for id := range m.user_group_admins {
		ids = append(ids, id)
	}
	return
}

// ResetUserGroupAdmins resets all changes to the "user_group_admins" edge.
func (m *AdminMutation) ResetUserGroupAdmins() {
	m.user_group_admins = nil
	m.cleareduser_group_admins = false
	m.removeduser_group_admins = nil
}

// AddAdminRoleIDs adds the "admin_roles" edge to the AdminRole entity by ids.
func (m *AdminMutation) AddAdminRoleIDs(ids ...uuid.UUID) {
	if m.admin_roles == nil {
		m.admin_roles = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.admin_roles[ids[i]] = struct{}{}
	}
}

// ClearAdminRoles clears the "admin_roles" edge to the AdminRole entity.
func (m *AdminMutation) ClearAdminRoles() {
	m.clearedadmin_roles = true
}

// AdminRolesCleared reports if the "admin_roles" edge to the AdminRole entity was cleared.
func (m *AdminMutation) AdminRolesCleared() bool {
	return m.clearedadmin_roles
}

// RemoveAdminRoleIDs removes the "admin_roles" edge to the AdminRole entity by IDs.
func (m *AdminMutation) RemoveAdminRoleIDs(ids ...uuid.UUID) {
	if m.removedadmin_roles == nil {
		m.removedadmin_roles = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.admin_roles, ids[i])
		m.removedadmin_roles[ids[i]] = struct{}{}
	}
}

// RemovedAdminRoles returns the removed IDs of the "admin_roles" edge to the AdminRole entity.
func (m *AdminMutation) RemovedAdminRolesIDs() (ids []uuid.UUID) {
	for id := range m.removedadmin_roles {
		ids = append(ids, id)
	}
	return
}

// AdminRolesIDs returns the "admin_roles" edge IDs in the mutation.
func (m *AdminMutation) AdminRolesIDs() (ids []uuid.UUID) {
	for id := range m.admin_roles {
		ids = append(ids, id)
	}
	return
}

// ResetAdminRoles resets all changes to the "admin_roles" edge.
func (m *AdminMutation) ResetAdminRoles() {
	m.admin_roles = nil
	m.clearedadmin_roles = false
	m.removedadmin_roles = nil
}

// Where appends a list predicates to the AdminMutation builder.
func (m *AdminMutation) Where(ps ...predicate.Admin) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the AdminMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *AdminMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Admin, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *AdminMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *AdminMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Admin).
func (m *AdminMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *AdminMutation) Fields() []string {
	fields := make([]string, 0, 6)
	if m.username != nil {
		fields = append(fields, admin.FieldUsername)
	}
	if m.password != nil {
		fields = append(fields, admin.FieldPassword)
	}
	if m.status != nil {
		fields = append(fields, admin.FieldStatus)
	}
	if m.last_active_at != nil {
		fields = append(fields, admin.FieldLastActiveAt)
	}
	if m.created_at != nil {
		fields = append(fields, admin.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, admin.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *AdminMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case admin.FieldUsername:
		return m.Username()
	case admin.FieldPassword:
		return m.Password()
	case admin.FieldStatus:
		return m.Status()
	case admin.FieldLastActiveAt:
		return m.LastActiveAt()
	case admin.FieldCreatedAt:
		return m.CreatedAt()
	case admin.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *AdminMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case admin.FieldUsername:
		return m.OldUsername(ctx)
	case admin.FieldPassword:
		return m.OldPassword(ctx)
	case admin.FieldStatus:
		return m.OldStatus(ctx)
	case admin.FieldLastActiveAt:
		return m.OldLastActiveAt(ctx)
	case admin.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case admin.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Admin field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AdminMutation) SetField(name string, value ent.Value) error {
	switch name {
	case admin.FieldUsername:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUsername(v)
		return nil
	case admin.FieldPassword:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPassword(v)
		return nil
	case admin.FieldStatus:
		v, ok := value.(consts.AdminStatus)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStatus(v)
		return nil
	case admin.FieldLastActiveAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLastActiveAt(v)
		return nil
	case admin.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case admin.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Admin field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *AdminMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *AdminMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AdminMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Admin numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *AdminMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *AdminMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *AdminMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Admin nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *AdminMutation) ResetField(name string) error {
	switch name {
	case admin.FieldUsername:
		m.ResetUsername()
		return nil
	case admin.FieldPassword:
		m.ResetPassword()
		return nil
	case admin.FieldStatus:
		m.ResetStatus()
		return nil
	case admin.FieldLastActiveAt:
		m.ResetLastActiveAt()
		return nil
	case admin.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case admin.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown Admin field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *AdminMutation) AddedEdges() []string {
	edges := make([]string, 0, 7)
	if m.login_histories != nil {
		edges = append(edges, admin.EdgeLoginHistories)
	}
	if m.myusergroups != nil {
		edges = append(edges, admin.EdgeMyusergroups)
	}
	if m.aiemployees != nil {
		edges = append(edges, admin.EdgeAiemployees)
	}
	if m.usergroups != nil {
		edges = append(edges, admin.EdgeUsergroups)
	}
	if m.roles != nil {
		edges = append(edges, admin.EdgeRoles)
	}
	if m.user_group_admins != nil {
		edges = append(edges, admin.EdgeUserGroupAdmins)
	}
	if m.admin_roles != nil {
		edges = append(edges, admin.EdgeAdminRoles)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *AdminMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case admin.EdgeLoginHistories:
		ids := make([]ent.Value, 0, len(m.login_histories))
		for id := range m.login_histories {
			ids = append(ids, id)
		}
		return ids
	case admin.EdgeMyusergroups:
		ids := make([]ent.Value, 0, len(m.myusergroups))
		for id := range m.myusergroups {
			ids = append(ids, id)
		}
		return ids
	case admin.EdgeAiemployees:
		ids := make([]ent.Value, 0, len(m.aiemployees))
		for id := range m.aiemployees {
			ids = append(ids, id)
		}
		return ids
	case admin.EdgeUsergroups:
		ids := make([]ent.Value, 0, len(m.usergroups))
		for id := range m.usergroups {
			ids = append(ids, id)
		}
		return ids
	case admin.EdgeRoles:
		ids := make([]ent.Value, 0, len(m.roles))
		for id := range m.roles {
			ids = append(ids, id)
		}
		return ids
	case admin.EdgeUserGroupAdmins:
		ids := make([]ent.Value, 0, len(m.user_group_admins))
		for id := range m.user_group_admins {
			ids = append(ids, id)
		}
		return ids
	case admin.EdgeAdminRoles:
		ids := make([]ent.Value, 0, len(m.admin_roles))
		for id := range m.admin_roles {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *AdminMutation) RemovedEdges() []string {
	edges := make([]string, 0, 7)
	if m.removedlogin_histories != nil {
		edges = append(edges, admin.EdgeLoginHistories)
	}
	if m.removedmyusergroups != nil {
		edges = append(edges, admin.EdgeMyusergroups)
	}
	if m.removedaiemployees != nil {
		edges = append(edges, admin.EdgeAiemployees)
	}
	if m.removedusergroups != nil {
		edges = append(edges, admin.EdgeUsergroups)
	}
	if m.removedroles != nil {
		edges = append(edges, admin.EdgeRoles)
	}
	if m.removeduser_group_admins != nil {
		edges = append(edges, admin.EdgeUserGroupAdmins)
	}
	if m.removedadmin_roles != nil {
		edges = append(edges, admin.EdgeAdminRoles)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *AdminMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case admin.EdgeLoginHistories:
		ids := make([]ent.Value, 0, len(m.removedlogin_histories))
		for id := range m.removedlogin_histories {
			ids = append(ids, id)
		}
		return ids
	case admin.EdgeMyusergroups:
		ids := make([]ent.Value, 0, len(m.removedmyusergroups))
		for id := range m.removedmyusergroups {
			ids = append(ids, id)
		}
		return ids
	case admin.EdgeAiemployees:
		ids := make([]ent.Value, 0, len(m.removedaiemployees))
		for id := range m.removedaiemployees {
			ids = append(ids, id)
		}
		return ids
	case admin.EdgeUsergroups:
		ids := make([]ent.Value, 0, len(m.removedusergroups))
		for id := range m.removedusergroups {
			ids = append(ids, id)
		}
		return ids
	case admin.EdgeRoles:
		ids := make([]ent.Value, 0, len(m.removedroles))
		for id := range m.removedroles {
			ids = append(ids, id)
		}
		return ids
	case admin.EdgeUserGroupAdmins:
		ids := make([]ent.Value, 0, len(m.removeduser_group_admins))
		for id := range m.removeduser_group_admins {
			ids = append(ids, id)
		}
		return ids
	case admin.EdgeAdminRoles:
		ids := make([]ent.Value, 0, len(m.removedadmin_roles))
		for id := range m.removedadmin_roles {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *AdminMutation) ClearedEdges() []string {
	edges := make([]string, 0, 7)
	if m.clearedlogin_histories {
		edges = append(edges, admin.EdgeLoginHistories)
	}
	if m.clearedmyusergroups {
		edges = append(edges, admin.EdgeMyusergroups)
	}
	if m.clearedaiemployees {
		edges = append(edges, admin.EdgeAiemployees)
	}
	if m.clearedusergroups {
		edges = append(edges, admin.EdgeUsergroups)
	}
	if m.clearedroles {
		edges = append(edges, admin.EdgeRoles)
	}
	if m.cleareduser_group_admins {
		edges = append(edges, admin.EdgeUserGroupAdmins)
	}
	if m.clearedadmin_roles {
		edges = append(edges, admin.EdgeAdminRoles)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *AdminMutation) EdgeCleared(name string) bool {
	switch name {
	case admin.EdgeLoginHistories:
		return m.clearedlogin_histories
	case admin.EdgeMyusergroups:
		return m.clearedmyusergroups
	case admin.EdgeAiemployees:
		return m.clearedaiemployees
	case admin.EdgeUsergroups:
		return m.clearedusergroups
	case admin.EdgeRoles:
		return m.clearedroles
	case admin.EdgeUserGroupAdmins:
		return m.cleareduser_group_admins
	case admin.EdgeAdminRoles:
		return m.clearedadmin_roles
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *AdminMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown Admin unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *AdminMutation) ResetEdge(name string) error {
	switch name {
	case admin.EdgeLoginHistories:
		m.ResetLoginHistories()
		return nil
	case admin.EdgeMyusergroups:
		m.ResetMyusergroups()
		return nil
	case admin.EdgeAiemployees:
		m.ResetAiemployees()
		return nil
	case admin.EdgeUsergroups:
		m.ResetUsergroups()
		return nil
	case admin.EdgeRoles:
		m.ResetRoles()
		return nil
	case admin.EdgeUserGroupAdmins:
		m.ResetUserGroupAdmins()
		return nil
	case admin.EdgeAdminRoles:
		m.ResetAdminRoles()
		return nil
	}
	return fmt.Errorf("unknown Admin edge %s", name)
}

// AdminLoginHistoryMutation represents an operation that mutates the AdminLoginHistory nodes in the graph.
type AdminLoginHistoryMutation struct {
	config
	op             Op
	typ            string
	id             *uuid.UUID
	ip             *string
	country        *string
	province       *string
	city           *string
	isp            *string
	asn            *string
	client_version *string
	device         *string
	created_at     *time.Time
	clearedFields  map[string]struct{}
	owner          *uuid.UUID
	clearedowner   bool
	done           bool
	oldValue       func(context.Context) (*AdminLoginHistory, error)
	predicates     []predicate.AdminLoginHistory
}

var _ ent.Mutation = (*AdminLoginHistoryMutation)(nil)

// adminloginhistoryOption allows management of the mutation configuration using functional options.
type adminloginhistoryOption func(*AdminLoginHistoryMutation)

// newAdminLoginHistoryMutation creates new mutation for the AdminLoginHistory entity.
func newAdminLoginHistoryMutation(c config, op Op, opts ...adminloginhistoryOption) *AdminLoginHistoryMutation {
	m := &AdminLoginHistoryMutation{
		config:        c,
		op:            op,
		typ:           TypeAdminLoginHistory,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withAdminLoginHistoryID sets the ID field of the mutation.
func withAdminLoginHistoryID(id uuid.UUID) adminloginhistoryOption {
	return func(m *AdminLoginHistoryMutation) {
		var (
			err   error
			once  sync.Once
			value *AdminLoginHistory
		)
		m.oldValue = func(ctx context.Context) (*AdminLoginHistory, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().AdminLoginHistory.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withAdminLoginHistory sets the old AdminLoginHistory of the mutation.
func withAdminLoginHistory(node *AdminLoginHistory) adminloginhistoryOption {
	return func(m *AdminLoginHistoryMutation) {
		m.oldValue = func(context.Context) (*AdminLoginHistory, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m AdminLoginHistoryMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m AdminLoginHistoryMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of AdminLoginHistory entities.
func (m *AdminLoginHistoryMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *AdminLoginHistoryMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *AdminLoginHistoryMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().AdminLoginHistory.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetAdminID sets the "admin_id" field.
func (m *AdminLoginHistoryMutation) SetAdminID(u uuid.UUID) {
	m.owner = &u
}

// AdminID returns the value of the "admin_id" field in the mutation.
func (m *AdminLoginHistoryMutation) AdminID() (r uuid.UUID, exists bool) {
	v := m.owner
	if v == nil {
		return
	}
	return *v, true
}

// OldAdminID returns the old "admin_id" field's value of the AdminLoginHistory entity.
// If the AdminLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminLoginHistoryMutation) OldAdminID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAdminID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAdminID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAdminID: %w", err)
	}
	return oldValue.AdminID, nil
}

// ClearAdminID clears the value of the "admin_id" field.
func (m *AdminLoginHistoryMutation) ClearAdminID() {
	m.owner = nil
	m.clearedFields[adminloginhistory.FieldAdminID] = struct{}{}
}

// AdminIDCleared returns if the "admin_id" field was cleared in this mutation.
func (m *AdminLoginHistoryMutation) AdminIDCleared() bool {
	_, ok := m.clearedFields[adminloginhistory.FieldAdminID]
	return ok
}

// ResetAdminID resets all changes to the "admin_id" field.
func (m *AdminLoginHistoryMutation) ResetAdminID() {
	m.owner = nil
	delete(m.clearedFields, adminloginhistory.FieldAdminID)
}

// SetIP sets the "ip" field.
func (m *AdminLoginHistoryMutation) SetIP(s string) {
	m.ip = &s
}

// IP returns the value of the "ip" field in the mutation.
func (m *AdminLoginHistoryMutation) IP() (r string, exists bool) {
	v := m.ip
	if v == nil {
		return
	}
	return *v, true
}

// OldIP returns the old "ip" field's value of the AdminLoginHistory entity.
// If the AdminLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminLoginHistoryMutation) OldIP(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldIP is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldIP requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldIP: %w", err)
	}
	return oldValue.IP, nil
}

// ResetIP resets all changes to the "ip" field.
func (m *AdminLoginHistoryMutation) ResetIP() {
	m.ip = nil
}

// SetCountry sets the "country" field.
func (m *AdminLoginHistoryMutation) SetCountry(s string) {
	m.country = &s
}

// Country returns the value of the "country" field in the mutation.
func (m *AdminLoginHistoryMutation) Country() (r string, exists bool) {
	v := m.country
	if v == nil {
		return
	}
	return *v, true
}

// OldCountry returns the old "country" field's value of the AdminLoginHistory entity.
// If the AdminLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminLoginHistoryMutation) OldCountry(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCountry is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCountry requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCountry: %w", err)
	}
	return oldValue.Country, nil
}

// ResetCountry resets all changes to the "country" field.
func (m *AdminLoginHistoryMutation) ResetCountry() {
	m.country = nil
}

// SetProvince sets the "province" field.
func (m *AdminLoginHistoryMutation) SetProvince(s string) {
	m.province = &s
}

// Province returns the value of the "province" field in the mutation.
func (m *AdminLoginHistoryMutation) Province() (r string, exists bool) {
	v := m.province
	if v == nil {
		return
	}
	return *v, true
}

// OldProvince returns the old "province" field's value of the AdminLoginHistory entity.
// If the AdminLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminLoginHistoryMutation) OldProvince(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldProvince is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldProvince requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldProvince: %w", err)
	}
	return oldValue.Province, nil
}

// ResetProvince resets all changes to the "province" field.
func (m *AdminLoginHistoryMutation) ResetProvince() {
	m.province = nil
}

// SetCity sets the "city" field.
func (m *AdminLoginHistoryMutation) SetCity(s string) {
	m.city = &s
}

// City returns the value of the "city" field in the mutation.
func (m *AdminLoginHistoryMutation) City() (r string, exists bool) {
	v := m.city
	if v == nil {
		return
	}
	return *v, true
}

// OldCity returns the old "city" field's value of the AdminLoginHistory entity.
// If the AdminLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminLoginHistoryMutation) OldCity(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCity is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCity requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCity: %w", err)
	}
	return oldValue.City, nil
}

// ResetCity resets all changes to the "city" field.
func (m *AdminLoginHistoryMutation) ResetCity() {
	m.city = nil
}

// SetIsp sets the "isp" field.
func (m *AdminLoginHistoryMutation) SetIsp(s string) {
	m.isp = &s
}

// Isp returns the value of the "isp" field in the mutation.
func (m *AdminLoginHistoryMutation) Isp() (r string, exists bool) {
	v := m.isp
	if v == nil {
		return
	}
	return *v, true
}

// OldIsp returns the old "isp" field's value of the AdminLoginHistory entity.
// If the AdminLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminLoginHistoryMutation) OldIsp(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldIsp is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldIsp requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldIsp: %w", err)
	}
	return oldValue.Isp, nil
}

// ClearIsp clears the value of the "isp" field.
func (m *AdminLoginHistoryMutation) ClearIsp() {
	m.isp = nil
	m.clearedFields[adminloginhistory.FieldIsp] = struct{}{}
}

// IspCleared returns if the "isp" field was cleared in this mutation.
func (m *AdminLoginHistoryMutation) IspCleared() bool {
	_, ok := m.clearedFields[adminloginhistory.FieldIsp]
	return ok
}

// ResetIsp resets all changes to the "isp" field.
func (m *AdminLoginHistoryMutation) ResetIsp() {
	m.isp = nil
	delete(m.clearedFields, adminloginhistory.FieldIsp)
}

// SetAsn sets the "asn" field.
func (m *AdminLoginHistoryMutation) SetAsn(s string) {
	m.asn = &s
}

// Asn returns the value of the "asn" field in the mutation.
func (m *AdminLoginHistoryMutation) Asn() (r string, exists bool) {
	v := m.asn
	if v == nil {
		return
	}
	return *v, true
}

// OldAsn returns the old "asn" field's value of the AdminLoginHistory entity.
// If the AdminLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminLoginHistoryMutation) OldAsn(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAsn is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAsn requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAsn: %w", err)
	}
	return oldValue.Asn, nil
}

// ClearAsn clears the value of the "asn" field.
func (m *AdminLoginHistoryMutation) ClearAsn() {
	m.asn = nil
	m.clearedFields[adminloginhistory.FieldAsn] = struct{}{}
}

// AsnCleared returns if the "asn" field was cleared in this mutation.
func (m *AdminLoginHistoryMutation) AsnCleared() bool {
	_, ok := m.clearedFields[adminloginhistory.FieldAsn]
	return ok
}

// ResetAsn resets all changes to the "asn" field.
func (m *AdminLoginHistoryMutation) ResetAsn() {
	m.asn = nil
	delete(m.clearedFields, adminloginhistory.FieldAsn)
}

// SetClientVersion sets the "client_version" field.
func (m *AdminLoginHistoryMutation) SetClientVersion(s string) {
	m.client_version = &s
}

// ClientVersion returns the value of the "client_version" field in the mutation.
func (m *AdminLoginHistoryMutation) ClientVersion() (r string, exists bool) {
	v := m.client_version
	if v == nil {
		return
	}
	return *v, true
}

// OldClientVersion returns the old "client_version" field's value of the AdminLoginHistory entity.
// If the AdminLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminLoginHistoryMutation) OldClientVersion(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldClientVersion is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldClientVersion requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClientVersion: %w", err)
	}
	return oldValue.ClientVersion, nil
}

// ClearClientVersion clears the value of the "client_version" field.
func (m *AdminLoginHistoryMutation) ClearClientVersion() {
	m.client_version = nil
	m.clearedFields[adminloginhistory.FieldClientVersion] = struct{}{}
}

// ClientVersionCleared returns if the "client_version" field was cleared in this mutation.
func (m *AdminLoginHistoryMutation) ClientVersionCleared() bool {
	_, ok := m.clearedFields[adminloginhistory.FieldClientVersion]
	return ok
}

// ResetClientVersion resets all changes to the "client_version" field.
func (m *AdminLoginHistoryMutation) ResetClientVersion() {
	m.client_version = nil
	delete(m.clearedFields, adminloginhistory.FieldClientVersion)
}

// SetDevice sets the "device" field.
func (m *AdminLoginHistoryMutation) SetDevice(s string) {
	m.device = &s
}

// Device returns the value of the "device" field in the mutation.
func (m *AdminLoginHistoryMutation) Device() (r string, exists bool) {
	v := m.device
	if v == nil {
		return
	}
	return *v, true
}

// OldDevice returns the old "device" field's value of the AdminLoginHistory entity.
// If the AdminLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminLoginHistoryMutation) OldDevice(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDevice is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDevice requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDevice: %w", err)
	}
	return oldValue.Device, nil
}

// ClearDevice clears the value of the "device" field.
func (m *AdminLoginHistoryMutation) ClearDevice() {
	m.device = nil
	m.clearedFields[adminloginhistory.FieldDevice] = struct{}{}
}

// DeviceCleared returns if the "device" field was cleared in this mutation.
func (m *AdminLoginHistoryMutation) DeviceCleared() bool {
	_, ok := m.clearedFields[adminloginhistory.FieldDevice]
	return ok
}

// ResetDevice resets all changes to the "device" field.
func (m *AdminLoginHistoryMutation) ResetDevice() {
	m.device = nil
	delete(m.clearedFields, adminloginhistory.FieldDevice)
}

// SetCreatedAt sets the "created_at" field.
func (m *AdminLoginHistoryMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *AdminLoginHistoryMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the AdminLoginHistory entity.
// If the AdminLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminLoginHistoryMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *AdminLoginHistoryMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetOwnerID sets the "owner" edge to the Admin entity by id.
func (m *AdminLoginHistoryMutation) SetOwnerID(id uuid.UUID) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the Admin entity.
func (m *AdminLoginHistoryMutation) ClearOwner() {
	m.clearedowner = true
	m.clearedFields[adminloginhistory.FieldAdminID] = struct{}{}
}

// OwnerCleared reports if the "owner" edge to the Admin entity was cleared.
func (m *AdminLoginHistoryMutation) OwnerCleared() bool {
	return m.AdminIDCleared() || m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *AdminLoginHistoryMutation) OwnerID() (id uuid.UUID, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *AdminLoginHistoryMutation) OwnerIDs() (ids []uuid.UUID) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *AdminLoginHistoryMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// Where appends a list predicates to the AdminLoginHistoryMutation builder.
func (m *AdminLoginHistoryMutation) Where(ps ...predicate.AdminLoginHistory) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the AdminLoginHistoryMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *AdminLoginHistoryMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.AdminLoginHistory, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *AdminLoginHistoryMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *AdminLoginHistoryMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (AdminLoginHistory).
func (m *AdminLoginHistoryMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *AdminLoginHistoryMutation) Fields() []string {
	fields := make([]string, 0, 10)
	if m.owner != nil {
		fields = append(fields, adminloginhistory.FieldAdminID)
	}
	if m.ip != nil {
		fields = append(fields, adminloginhistory.FieldIP)
	}
	if m.country != nil {
		fields = append(fields, adminloginhistory.FieldCountry)
	}
	if m.province != nil {
		fields = append(fields, adminloginhistory.FieldProvince)
	}
	if m.city != nil {
		fields = append(fields, adminloginhistory.FieldCity)
	}
	if m.isp != nil {
		fields = append(fields, adminloginhistory.FieldIsp)
	}
	if m.asn != nil {
		fields = append(fields, adminloginhistory.FieldAsn)
	}
	if m.client_version != nil {
		fields = append(fields, adminloginhistory.FieldClientVersion)
	}
	if m.device != nil {
		fields = append(fields, adminloginhistory.FieldDevice)
	}
	if m.created_at != nil {
		fields = append(fields, adminloginhistory.FieldCreatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *AdminLoginHistoryMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case adminloginhistory.FieldAdminID:
		return m.AdminID()
	case adminloginhistory.FieldIP:
		return m.IP()
	case adminloginhistory.FieldCountry:
		return m.Country()
	case adminloginhistory.FieldProvince:
		return m.Province()
	case adminloginhistory.FieldCity:
		return m.City()
	case adminloginhistory.FieldIsp:
		return m.Isp()
	case adminloginhistory.FieldAsn:
		return m.Asn()
	case adminloginhistory.FieldClientVersion:
		return m.ClientVersion()
	case adminloginhistory.FieldDevice:
		return m.Device()
	case adminloginhistory.FieldCreatedAt:
		return m.CreatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *AdminLoginHistoryMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case adminloginhistory.FieldAdminID:
		return m.OldAdminID(ctx)
	case adminloginhistory.FieldIP:
		return m.OldIP(ctx)
	case adminloginhistory.FieldCountry:
		return m.OldCountry(ctx)
	case adminloginhistory.FieldProvince:
		return m.OldProvince(ctx)
	case adminloginhistory.FieldCity:
		return m.OldCity(ctx)
	case adminloginhistory.FieldIsp:
		return m.OldIsp(ctx)
	case adminloginhistory.FieldAsn:
		return m.OldAsn(ctx)
	case adminloginhistory.FieldClientVersion:
		return m.OldClientVersion(ctx)
	case adminloginhistory.FieldDevice:
		return m.OldDevice(ctx)
	case adminloginhistory.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown AdminLoginHistory field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AdminLoginHistoryMutation) SetField(name string, value ent.Value) error {
	switch name {
	case adminloginhistory.FieldAdminID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAdminID(v)
		return nil
	case adminloginhistory.FieldIP:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetIP(v)
		return nil
	case adminloginhistory.FieldCountry:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCountry(v)
		return nil
	case adminloginhistory.FieldProvince:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetProvince(v)
		return nil
	case adminloginhistory.FieldCity:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCity(v)
		return nil
	case adminloginhistory.FieldIsp:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetIsp(v)
		return nil
	case adminloginhistory.FieldAsn:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAsn(v)
		return nil
	case adminloginhistory.FieldClientVersion:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClientVersion(v)
		return nil
	case adminloginhistory.FieldDevice:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDevice(v)
		return nil
	case adminloginhistory.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown AdminLoginHistory field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *AdminLoginHistoryMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *AdminLoginHistoryMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AdminLoginHistoryMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown AdminLoginHistory numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *AdminLoginHistoryMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(adminloginhistory.FieldAdminID) {
		fields = append(fields, adminloginhistory.FieldAdminID)
	}
	if m.FieldCleared(adminloginhistory.FieldIsp) {
		fields = append(fields, adminloginhistory.FieldIsp)
	}
	if m.FieldCleared(adminloginhistory.FieldAsn) {
		fields = append(fields, adminloginhistory.FieldAsn)
	}
	if m.FieldCleared(adminloginhistory.FieldClientVersion) {
		fields = append(fields, adminloginhistory.FieldClientVersion)
	}
	if m.FieldCleared(adminloginhistory.FieldDevice) {
		fields = append(fields, adminloginhistory.FieldDevice)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *AdminLoginHistoryMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *AdminLoginHistoryMutation) ClearField(name string) error {
	switch name {
	case adminloginhistory.FieldAdminID:
		m.ClearAdminID()
		return nil
	case adminloginhistory.FieldIsp:
		m.ClearIsp()
		return nil
	case adminloginhistory.FieldAsn:
		m.ClearAsn()
		return nil
	case adminloginhistory.FieldClientVersion:
		m.ClearClientVersion()
		return nil
	case adminloginhistory.FieldDevice:
		m.ClearDevice()
		return nil
	}
	return fmt.Errorf("unknown AdminLoginHistory nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *AdminLoginHistoryMutation) ResetField(name string) error {
	switch name {
	case adminloginhistory.FieldAdminID:
		m.ResetAdminID()
		return nil
	case adminloginhistory.FieldIP:
		m.ResetIP()
		return nil
	case adminloginhistory.FieldCountry:
		m.ResetCountry()
		return nil
	case adminloginhistory.FieldProvince:
		m.ResetProvince()
		return nil
	case adminloginhistory.FieldCity:
		m.ResetCity()
		return nil
	case adminloginhistory.FieldIsp:
		m.ResetIsp()
		return nil
	case adminloginhistory.FieldAsn:
		m.ResetAsn()
		return nil
	case adminloginhistory.FieldClientVersion:
		m.ResetClientVersion()
		return nil
	case adminloginhistory.FieldDevice:
		m.ResetDevice()
		return nil
	case adminloginhistory.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	}
	return fmt.Errorf("unknown AdminLoginHistory field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *AdminLoginHistoryMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.owner != nil {
		edges = append(edges, adminloginhistory.EdgeOwner)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *AdminLoginHistoryMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case adminloginhistory.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *AdminLoginHistoryMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *AdminLoginHistoryMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *AdminLoginHistoryMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedowner {
		edges = append(edges, adminloginhistory.EdgeOwner)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *AdminLoginHistoryMutation) EdgeCleared(name string) bool {
	switch name {
	case adminloginhistory.EdgeOwner:
		return m.clearedowner
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *AdminLoginHistoryMutation) ClearEdge(name string) error {
	switch name {
	case adminloginhistory.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown AdminLoginHistory unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *AdminLoginHistoryMutation) ResetEdge(name string) error {
	switch name {
	case adminloginhistory.EdgeOwner:
		m.ResetOwner()
		return nil
	}
	return fmt.Errorf("unknown AdminLoginHistory edge %s", name)
}

// AdminRoleMutation represents an operation that mutates the AdminRole nodes in the graph.
type AdminRoleMutation struct {
	config
	op            Op
	typ           string
	id            *uuid.UUID
	clearedFields map[string]struct{}
	admin         *uuid.UUID
	clearedadmin  bool
	role          *int64
	clearedrole   bool
	done          bool
	oldValue      func(context.Context) (*AdminRole, error)
	predicates    []predicate.AdminRole
}

var _ ent.Mutation = (*AdminRoleMutation)(nil)

// adminroleOption allows management of the mutation configuration using functional options.
type adminroleOption func(*AdminRoleMutation)

// newAdminRoleMutation creates new mutation for the AdminRole entity.
func newAdminRoleMutation(c config, op Op, opts ...adminroleOption) *AdminRoleMutation {
	m := &AdminRoleMutation{
		config:        c,
		op:            op,
		typ:           TypeAdminRole,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withAdminRoleID sets the ID field of the mutation.
func withAdminRoleID(id uuid.UUID) adminroleOption {
	return func(m *AdminRoleMutation) {
		var (
			err   error
			once  sync.Once
			value *AdminRole
		)
		m.oldValue = func(ctx context.Context) (*AdminRole, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().AdminRole.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withAdminRole sets the old AdminRole of the mutation.
func withAdminRole(node *AdminRole) adminroleOption {
	return func(m *AdminRoleMutation) {
		m.oldValue = func(context.Context) (*AdminRole, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m AdminRoleMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m AdminRoleMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of AdminRole entities.
func (m *AdminRoleMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *AdminRoleMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *AdminRoleMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().AdminRole.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetAdminID sets the "admin_id" field.
func (m *AdminRoleMutation) SetAdminID(u uuid.UUID) {
	m.admin = &u
}

// AdminID returns the value of the "admin_id" field in the mutation.
func (m *AdminRoleMutation) AdminID() (r uuid.UUID, exists bool) {
	v := m.admin
	if v == nil {
		return
	}
	return *v, true
}

// OldAdminID returns the old "admin_id" field's value of the AdminRole entity.
// If the AdminRole object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminRoleMutation) OldAdminID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAdminID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAdminID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAdminID: %w", err)
	}
	return oldValue.AdminID, nil
}

// ResetAdminID resets all changes to the "admin_id" field.
func (m *AdminRoleMutation) ResetAdminID() {
	m.admin = nil
}

// SetRoleID sets the "role_id" field.
func (m *AdminRoleMutation) SetRoleID(i int64) {
	m.role = &i
}

// RoleID returns the value of the "role_id" field in the mutation.
func (m *AdminRoleMutation) RoleID() (r int64, exists bool) {
	v := m.role
	if v == nil {
		return
	}
	return *v, true
}

// OldRoleID returns the old "role_id" field's value of the AdminRole entity.
// If the AdminRole object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AdminRoleMutation) OldRoleID(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRoleID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRoleID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRoleID: %w", err)
	}
	return oldValue.RoleID, nil
}

// ResetRoleID resets all changes to the "role_id" field.
func (m *AdminRoleMutation) ResetRoleID() {
	m.role = nil
}

// ClearAdmin clears the "admin" edge to the Admin entity.
func (m *AdminRoleMutation) ClearAdmin() {
	m.clearedadmin = true
	m.clearedFields[adminrole.FieldAdminID] = struct{}{}
}

// AdminCleared reports if the "admin" edge to the Admin entity was cleared.
func (m *AdminRoleMutation) AdminCleared() bool {
	return m.clearedadmin
}

// AdminIDs returns the "admin" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// AdminID instead. It exists only for internal usage by the builders.
func (m *AdminRoleMutation) AdminIDs() (ids []uuid.UUID) {
	if id := m.admin; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetAdmin resets all changes to the "admin" edge.
func (m *AdminRoleMutation) ResetAdmin() {
	m.admin = nil
	m.clearedadmin = false
}

// ClearRole clears the "role" edge to the Role entity.
func (m *AdminRoleMutation) ClearRole() {
	m.clearedrole = true
	m.clearedFields[adminrole.FieldRoleID] = struct{}{}
}

// RoleCleared reports if the "role" edge to the Role entity was cleared.
func (m *AdminRoleMutation) RoleCleared() bool {
	return m.clearedrole
}

// RoleIDs returns the "role" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// RoleID instead. It exists only for internal usage by the builders.
func (m *AdminRoleMutation) RoleIDs() (ids []int64) {
	if id := m.role; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetRole resets all changes to the "role" edge.
func (m *AdminRoleMutation) ResetRole() {
	m.role = nil
	m.clearedrole = false
}

// Where appends a list predicates to the AdminRoleMutation builder.
func (m *AdminRoleMutation) Where(ps ...predicate.AdminRole) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the AdminRoleMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *AdminRoleMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.AdminRole, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *AdminRoleMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *AdminRoleMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (AdminRole).
func (m *AdminRoleMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *AdminRoleMutation) Fields() []string {
	fields := make([]string, 0, 2)
	if m.admin != nil {
		fields = append(fields, adminrole.FieldAdminID)
	}
	if m.role != nil {
		fields = append(fields, adminrole.FieldRoleID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *AdminRoleMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case adminrole.FieldAdminID:
		return m.AdminID()
	case adminrole.FieldRoleID:
		return m.RoleID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *AdminRoleMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case adminrole.FieldAdminID:
		return m.OldAdminID(ctx)
	case adminrole.FieldRoleID:
		return m.OldRoleID(ctx)
	}
	return nil, fmt.Errorf("unknown AdminRole field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AdminRoleMutation) SetField(name string, value ent.Value) error {
	switch name {
	case adminrole.FieldAdminID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAdminID(v)
		return nil
	case adminrole.FieldRoleID:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRoleID(v)
		return nil
	}
	return fmt.Errorf("unknown AdminRole field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *AdminRoleMutation) AddedFields() []string {
	var fields []string
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *AdminRoleMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AdminRoleMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown AdminRole numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *AdminRoleMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *AdminRoleMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *AdminRoleMutation) ClearField(name string) error {
	return fmt.Errorf("unknown AdminRole nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *AdminRoleMutation) ResetField(name string) error {
	switch name {
	case adminrole.FieldAdminID:
		m.ResetAdminID()
		return nil
	case adminrole.FieldRoleID:
		m.ResetRoleID()
		return nil
	}
	return fmt.Errorf("unknown AdminRole field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *AdminRoleMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.admin != nil {
		edges = append(edges, adminrole.EdgeAdmin)
	}
	if m.role != nil {
		edges = append(edges, adminrole.EdgeRole)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *AdminRoleMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case adminrole.EdgeAdmin:
		if id := m.admin; id != nil {
			return []ent.Value{*id}
		}
	case adminrole.EdgeRole:
		if id := m.role; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *AdminRoleMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *AdminRoleMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *AdminRoleMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedadmin {
		edges = append(edges, adminrole.EdgeAdmin)
	}
	if m.clearedrole {
		edges = append(edges, adminrole.EdgeRole)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *AdminRoleMutation) EdgeCleared(name string) bool {
	switch name {
	case adminrole.EdgeAdmin:
		return m.clearedadmin
	case adminrole.EdgeRole:
		return m.clearedrole
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *AdminRoleMutation) ClearEdge(name string) error {
	switch name {
	case adminrole.EdgeAdmin:
		m.ClearAdmin()
		return nil
	case adminrole.EdgeRole:
		m.ClearRole()
		return nil
	}
	return fmt.Errorf("unknown AdminRole unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *AdminRoleMutation) ResetEdge(name string) error {
	switch name {
	case adminrole.EdgeAdmin:
		m.ResetAdmin()
		return nil
	case adminrole.EdgeRole:
		m.ResetRole()
		return nil
	}
	return fmt.Errorf("unknown AdminRole edge %s", name)
}

// ApiKeyMutation represents an operation that mutates the ApiKey nodes in the graph.
type ApiKeyMutation struct {
	config
	op            Op
	typ           string
	id            *uuid.UUID
	key           *string
	name          *string
	status        *consts.ApiKeyStatus
	last_used     *time.Time
	created_at    *time.Time
	updated_at    *time.Time
	clearedFields map[string]struct{}
	user          *uuid.UUID
	cleareduser   bool
	done          bool
	oldValue      func(context.Context) (*ApiKey, error)
	predicates    []predicate.ApiKey
}

var _ ent.Mutation = (*ApiKeyMutation)(nil)

// apikeyOption allows management of the mutation configuration using functional options.
type apikeyOption func(*ApiKeyMutation)

// newApiKeyMutation creates new mutation for the ApiKey entity.
func newApiKeyMutation(c config, op Op, opts ...apikeyOption) *ApiKeyMutation {
	m := &ApiKeyMutation{
		config:        c,
		op:            op,
		typ:           TypeApiKey,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withApiKeyID sets the ID field of the mutation.
func withApiKeyID(id uuid.UUID) apikeyOption {
	return func(m *ApiKeyMutation) {
		var (
			err   error
			once  sync.Once
			value *ApiKey
		)
		m.oldValue = func(ctx context.Context) (*ApiKey, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().ApiKey.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withApiKey sets the old ApiKey of the mutation.
func withApiKey(node *ApiKey) apikeyOption {
	return func(m *ApiKeyMutation) {
		m.oldValue = func(context.Context) (*ApiKey, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m ApiKeyMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m ApiKeyMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of ApiKey entities.
func (m *ApiKeyMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *ApiKeyMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *ApiKeyMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().ApiKey.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetUserID sets the "user_id" field.
func (m *ApiKeyMutation) SetUserID(u uuid.UUID) {
	m.user = &u
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *ApiKeyMutation) UserID() (r uuid.UUID, exists bool) {
	v := m.user
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the ApiKey entity.
// If the ApiKey object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ApiKeyMutation) OldUserID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ResetUserID resets all changes to the "user_id" field.
func (m *ApiKeyMutation) ResetUserID() {
	m.user = nil
}

// SetKey sets the "key" field.
func (m *ApiKeyMutation) SetKey(s string) {
	m.key = &s
}

// Key returns the value of the "key" field in the mutation.
func (m *ApiKeyMutation) Key() (r string, exists bool) {
	v := m.key
	if v == nil {
		return
	}
	return *v, true
}

// OldKey returns the old "key" field's value of the ApiKey entity.
// If the ApiKey object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ApiKeyMutation) OldKey(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldKey is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldKey requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldKey: %w", err)
	}
	return oldValue.Key, nil
}

// ResetKey resets all changes to the "key" field.
func (m *ApiKeyMutation) ResetKey() {
	m.key = nil
}

// SetName sets the "name" field.
func (m *ApiKeyMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *ApiKeyMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the ApiKey entity.
// If the ApiKey object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ApiKeyMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *ApiKeyMutation) ResetName() {
	m.name = nil
}

// SetStatus sets the "status" field.
func (m *ApiKeyMutation) SetStatus(cks consts.ApiKeyStatus) {
	m.status = &cks
}

// Status returns the value of the "status" field in the mutation.
func (m *ApiKeyMutation) Status() (r consts.ApiKeyStatus, exists bool) {
	v := m.status
	if v == nil {
		return
	}
	return *v, true
}

// OldStatus returns the old "status" field's value of the ApiKey entity.
// If the ApiKey object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ApiKeyMutation) OldStatus(ctx context.Context) (v consts.ApiKeyStatus, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStatus is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStatus requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStatus: %w", err)
	}
	return oldValue.Status, nil
}

// ResetStatus resets all changes to the "status" field.
func (m *ApiKeyMutation) ResetStatus() {
	m.status = nil
}

// SetLastUsed sets the "last_used" field.
func (m *ApiKeyMutation) SetLastUsed(t time.Time) {
	m.last_used = &t
}

// LastUsed returns the value of the "last_used" field in the mutation.
func (m *ApiKeyMutation) LastUsed() (r time.Time, exists bool) {
	v := m.last_used
	if v == nil {
		return
	}
	return *v, true
}

// OldLastUsed returns the old "last_used" field's value of the ApiKey entity.
// If the ApiKey object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ApiKeyMutation) OldLastUsed(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldLastUsed is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldLastUsed requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLastUsed: %w", err)
	}
	return oldValue.LastUsed, nil
}

// ClearLastUsed clears the value of the "last_used" field.
func (m *ApiKeyMutation) ClearLastUsed() {
	m.last_used = nil
	m.clearedFields[apikey.FieldLastUsed] = struct{}{}
}

// LastUsedCleared returns if the "last_used" field was cleared in this mutation.
func (m *ApiKeyMutation) LastUsedCleared() bool {
	_, ok := m.clearedFields[apikey.FieldLastUsed]
	return ok
}

// ResetLastUsed resets all changes to the "last_used" field.
func (m *ApiKeyMutation) ResetLastUsed() {
	m.last_used = nil
	delete(m.clearedFields, apikey.FieldLastUsed)
}

// SetCreatedAt sets the "created_at" field.
func (m *ApiKeyMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *ApiKeyMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the ApiKey entity.
// If the ApiKey object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ApiKeyMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *ApiKeyMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *ApiKeyMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *ApiKeyMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the ApiKey entity.
// If the ApiKey object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ApiKeyMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *ApiKeyMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// ClearUser clears the "user" edge to the User entity.
func (m *ApiKeyMutation) ClearUser() {
	m.cleareduser = true
	m.clearedFields[apikey.FieldUserID] = struct{}{}
}

// UserCleared reports if the "user" edge to the User entity was cleared.
func (m *ApiKeyMutation) UserCleared() bool {
	return m.cleareduser
}

// UserIDs returns the "user" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserID instead. It exists only for internal usage by the builders.
func (m *ApiKeyMutation) UserIDs() (ids []uuid.UUID) {
	if id := m.user; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUser resets all changes to the "user" edge.
func (m *ApiKeyMutation) ResetUser() {
	m.user = nil
	m.cleareduser = false
}

// Where appends a list predicates to the ApiKeyMutation builder.
func (m *ApiKeyMutation) Where(ps ...predicate.ApiKey) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the ApiKeyMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *ApiKeyMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.ApiKey, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *ApiKeyMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *ApiKeyMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (ApiKey).
func (m *ApiKeyMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *ApiKeyMutation) Fields() []string {
	fields := make([]string, 0, 7)
	if m.user != nil {
		fields = append(fields, apikey.FieldUserID)
	}
	if m.key != nil {
		fields = append(fields, apikey.FieldKey)
	}
	if m.name != nil {
		fields = append(fields, apikey.FieldName)
	}
	if m.status != nil {
		fields = append(fields, apikey.FieldStatus)
	}
	if m.last_used != nil {
		fields = append(fields, apikey.FieldLastUsed)
	}
	if m.created_at != nil {
		fields = append(fields, apikey.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, apikey.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *ApiKeyMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case apikey.FieldUserID:
		return m.UserID()
	case apikey.FieldKey:
		return m.Key()
	case apikey.FieldName:
		return m.Name()
	case apikey.FieldStatus:
		return m.Status()
	case apikey.FieldLastUsed:
		return m.LastUsed()
	case apikey.FieldCreatedAt:
		return m.CreatedAt()
	case apikey.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *ApiKeyMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case apikey.FieldUserID:
		return m.OldUserID(ctx)
	case apikey.FieldKey:
		return m.OldKey(ctx)
	case apikey.FieldName:
		return m.OldName(ctx)
	case apikey.FieldStatus:
		return m.OldStatus(ctx)
	case apikey.FieldLastUsed:
		return m.OldLastUsed(ctx)
	case apikey.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case apikey.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown ApiKey field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ApiKeyMutation) SetField(name string, value ent.Value) error {
	switch name {
	case apikey.FieldUserID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case apikey.FieldKey:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetKey(v)
		return nil
	case apikey.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case apikey.FieldStatus:
		v, ok := value.(consts.ApiKeyStatus)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStatus(v)
		return nil
	case apikey.FieldLastUsed:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLastUsed(v)
		return nil
	case apikey.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case apikey.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown ApiKey field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *ApiKeyMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *ApiKeyMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ApiKeyMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown ApiKey numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *ApiKeyMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(apikey.FieldLastUsed) {
		fields = append(fields, apikey.FieldLastUsed)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *ApiKeyMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *ApiKeyMutation) ClearField(name string) error {
	switch name {
	case apikey.FieldLastUsed:
		m.ClearLastUsed()
		return nil
	}
	return fmt.Errorf("unknown ApiKey nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *ApiKeyMutation) ResetField(name string) error {
	switch name {
	case apikey.FieldUserID:
		m.ResetUserID()
		return nil
	case apikey.FieldKey:
		m.ResetKey()
		return nil
	case apikey.FieldName:
		m.ResetName()
		return nil
	case apikey.FieldStatus:
		m.ResetStatus()
		return nil
	case apikey.FieldLastUsed:
		m.ResetLastUsed()
		return nil
	case apikey.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case apikey.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown ApiKey field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *ApiKeyMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.user != nil {
		edges = append(edges, apikey.EdgeUser)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *ApiKeyMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case apikey.EdgeUser:
		if id := m.user; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *ApiKeyMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *ApiKeyMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *ApiKeyMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.cleareduser {
		edges = append(edges, apikey.EdgeUser)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *ApiKeyMutation) EdgeCleared(name string) bool {
	switch name {
	case apikey.EdgeUser:
		return m.cleareduser
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *ApiKeyMutation) ClearEdge(name string) error {
	switch name {
	case apikey.EdgeUser:
		m.ClearUser()
		return nil
	}
	return fmt.Errorf("unknown ApiKey unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *ApiKeyMutation) ResetEdge(name string) error {
	switch name {
	case apikey.EdgeUser:
		m.ResetUser()
		return nil
	}
	return fmt.Errorf("unknown ApiKey edge %s", name)
}

// BillingPlanMutation represents an operation that mutates the BillingPlan nodes in the graph.
type BillingPlanMutation struct {
	config
	op            Op
	typ           string
	id            *string
	name          *string
	description   *string
	rules         *map[string]interface{}
	created_at    *time.Time
	updated_at    *time.Time
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*BillingPlan, error)
	predicates    []predicate.BillingPlan
}

var _ ent.Mutation = (*BillingPlanMutation)(nil)

// billingplanOption allows management of the mutation configuration using functional options.
type billingplanOption func(*BillingPlanMutation)

// newBillingPlanMutation creates new mutation for the BillingPlan entity.
func newBillingPlanMutation(c config, op Op, opts ...billingplanOption) *BillingPlanMutation {
	m := &BillingPlanMutation{
		config:        c,
		op:            op,
		typ:           TypeBillingPlan,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withBillingPlanID sets the ID field of the mutation.
func withBillingPlanID(id string) billingplanOption {
	return func(m *BillingPlanMutation) {
		var (
			err   error
			once  sync.Once
			value *BillingPlan
		)
		m.oldValue = func(ctx context.Context) (*BillingPlan, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().BillingPlan.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withBillingPlan sets the old BillingPlan of the mutation.
func withBillingPlan(node *BillingPlan) billingplanOption {
	return func(m *BillingPlanMutation) {
		m.oldValue = func(context.Context) (*BillingPlan, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m BillingPlanMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m BillingPlanMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of BillingPlan entities.
func (m *BillingPlanMutation) SetID(id string) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *BillingPlanMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *BillingPlanMutation) IDs(ctx context.Context) ([]string, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []string{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().BillingPlan.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetName sets the "name" field.
func (m *BillingPlanMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *BillingPlanMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the BillingPlan entity.
// If the BillingPlan object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingPlanMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *BillingPlanMutation) ResetName() {
	m.name = nil
}

// SetDescription sets the "description" field.
func (m *BillingPlanMutation) SetDescription(s string) {
	m.description = &s
}

// Description returns the value of the "description" field in the mutation.
func (m *BillingPlanMutation) Description() (r string, exists bool) {
	v := m.description
	if v == nil {
		return
	}
	return *v, true
}

// OldDescription returns the old "description" field's value of the BillingPlan entity.
// If the BillingPlan object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingPlanMutation) OldDescription(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDescription is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDescription requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDescription: %w", err)
	}
	return oldValue.Description, nil
}

// ResetDescription resets all changes to the "description" field.
func (m *BillingPlanMutation) ResetDescription() {
	m.description = nil
}

// SetRules sets the "rules" field.
func (m *BillingPlanMutation) SetRules(value map[string]interface{}) {
	m.rules = &value
}

// Rules returns the value of the "rules" field in the mutation.
func (m *BillingPlanMutation) Rules() (r map[string]interface{}, exists bool) {
	v := m.rules
	if v == nil {
		return
	}
	return *v, true
}

// OldRules returns the old "rules" field's value of the BillingPlan entity.
// If the BillingPlan object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingPlanMutation) OldRules(ctx context.Context) (v map[string]interface{}, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRules is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRules requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRules: %w", err)
	}
	return oldValue.Rules, nil
}

// ResetRules resets all changes to the "rules" field.
func (m *BillingPlanMutation) ResetRules() {
	m.rules = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *BillingPlanMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *BillingPlanMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the BillingPlan entity.
// If the BillingPlan object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingPlanMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *BillingPlanMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *BillingPlanMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *BillingPlanMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the BillingPlan entity.
// If the BillingPlan object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingPlanMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *BillingPlanMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// Where appends a list predicates to the BillingPlanMutation builder.
func (m *BillingPlanMutation) Where(ps ...predicate.BillingPlan) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the BillingPlanMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *BillingPlanMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.BillingPlan, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *BillingPlanMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *BillingPlanMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (BillingPlan).
func (m *BillingPlanMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *BillingPlanMutation) Fields() []string {
	fields := make([]string, 0, 5)
	if m.name != nil {
		fields = append(fields, billingplan.FieldName)
	}
	if m.description != nil {
		fields = append(fields, billingplan.FieldDescription)
	}
	if m.rules != nil {
		fields = append(fields, billingplan.FieldRules)
	}
	if m.created_at != nil {
		fields = append(fields, billingplan.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, billingplan.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *BillingPlanMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case billingplan.FieldName:
		return m.Name()
	case billingplan.FieldDescription:
		return m.Description()
	case billingplan.FieldRules:
		return m.Rules()
	case billingplan.FieldCreatedAt:
		return m.CreatedAt()
	case billingplan.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *BillingPlanMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case billingplan.FieldName:
		return m.OldName(ctx)
	case billingplan.FieldDescription:
		return m.OldDescription(ctx)
	case billingplan.FieldRules:
		return m.OldRules(ctx)
	case billingplan.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case billingplan.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown BillingPlan field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *BillingPlanMutation) SetField(name string, value ent.Value) error {
	switch name {
	case billingplan.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case billingplan.FieldDescription:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDescription(v)
		return nil
	case billingplan.FieldRules:
		v, ok := value.(map[string]interface{})
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRules(v)
		return nil
	case billingplan.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case billingplan.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown BillingPlan field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *BillingPlanMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *BillingPlanMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *BillingPlanMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown BillingPlan numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *BillingPlanMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *BillingPlanMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *BillingPlanMutation) ClearField(name string) error {
	return fmt.Errorf("unknown BillingPlan nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *BillingPlanMutation) ResetField(name string) error {
	switch name {
	case billingplan.FieldName:
		m.ResetName()
		return nil
	case billingplan.FieldDescription:
		m.ResetDescription()
		return nil
	case billingplan.FieldRules:
		m.ResetRules()
		return nil
	case billingplan.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case billingplan.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown BillingPlan field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *BillingPlanMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *BillingPlanMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *BillingPlanMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *BillingPlanMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *BillingPlanMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *BillingPlanMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *BillingPlanMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown BillingPlan unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *BillingPlanMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown BillingPlan edge %s", name)
}

// BillingQuotaMutation represents an operation that mutates the BillingQuota nodes in the graph.
type BillingQuotaMutation struct {
	config
	op            Op
	typ           string
	id            *string
	deleted_at    *time.Time
	user_id       *string
	total         *int64
	addtotal      *int64
	used          *int64
	addused       *int64
	remain        *int64
	addremain     *int64
	created_at    *time.Time
	updated_at    *time.Time
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*BillingQuota, error)
	predicates    []predicate.BillingQuota
}

var _ ent.Mutation = (*BillingQuotaMutation)(nil)

// billingquotaOption allows management of the mutation configuration using functional options.
type billingquotaOption func(*BillingQuotaMutation)

// newBillingQuotaMutation creates new mutation for the BillingQuota entity.
func newBillingQuotaMutation(c config, op Op, opts ...billingquotaOption) *BillingQuotaMutation {
	m := &BillingQuotaMutation{
		config:        c,
		op:            op,
		typ:           TypeBillingQuota,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withBillingQuotaID sets the ID field of the mutation.
func withBillingQuotaID(id string) billingquotaOption {
	return func(m *BillingQuotaMutation) {
		var (
			err   error
			once  sync.Once
			value *BillingQuota
		)
		m.oldValue = func(ctx context.Context) (*BillingQuota, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().BillingQuota.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withBillingQuota sets the old BillingQuota of the mutation.
func withBillingQuota(node *BillingQuota) billingquotaOption {
	return func(m *BillingQuotaMutation) {
		m.oldValue = func(context.Context) (*BillingQuota, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m BillingQuotaMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m BillingQuotaMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of BillingQuota entities.
func (m *BillingQuotaMutation) SetID(id string) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *BillingQuotaMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *BillingQuotaMutation) IDs(ctx context.Context) ([]string, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []string{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().BillingQuota.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetDeletedAt sets the "deleted_at" field.
func (m *BillingQuotaMutation) SetDeletedAt(t time.Time) {
	m.deleted_at = &t
}

// DeletedAt returns the value of the "deleted_at" field in the mutation.
func (m *BillingQuotaMutation) DeletedAt() (r time.Time, exists bool) {
	v := m.deleted_at
	if v == nil {
		return
	}
	return *v, true
}

// OldDeletedAt returns the old "deleted_at" field's value of the BillingQuota entity.
// If the BillingQuota object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingQuotaMutation) OldDeletedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDeletedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDeletedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDeletedAt: %w", err)
	}
	return oldValue.DeletedAt, nil
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (m *BillingQuotaMutation) ClearDeletedAt() {
	m.deleted_at = nil
	m.clearedFields[billingquota.FieldDeletedAt] = struct{}{}
}

// DeletedAtCleared returns if the "deleted_at" field was cleared in this mutation.
func (m *BillingQuotaMutation) DeletedAtCleared() bool {
	_, ok := m.clearedFields[billingquota.FieldDeletedAt]
	return ok
}

// ResetDeletedAt resets all changes to the "deleted_at" field.
func (m *BillingQuotaMutation) ResetDeletedAt() {
	m.deleted_at = nil
	delete(m.clearedFields, billingquota.FieldDeletedAt)
}

// SetUserID sets the "user_id" field.
func (m *BillingQuotaMutation) SetUserID(s string) {
	m.user_id = &s
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *BillingQuotaMutation) UserID() (r string, exists bool) {
	v := m.user_id
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the BillingQuota entity.
// If the BillingQuota object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingQuotaMutation) OldUserID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ResetUserID resets all changes to the "user_id" field.
func (m *BillingQuotaMutation) ResetUserID() {
	m.user_id = nil
}

// SetTotal sets the "total" field.
func (m *BillingQuotaMutation) SetTotal(i int64) {
	m.total = &i
	m.addtotal = nil
}

// Total returns the value of the "total" field in the mutation.
func (m *BillingQuotaMutation) Total() (r int64, exists bool) {
	v := m.total
	if v == nil {
		return
	}
	return *v, true
}

// OldTotal returns the old "total" field's value of the BillingQuota entity.
// If the BillingQuota object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingQuotaMutation) OldTotal(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldTotal is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldTotal requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldTotal: %w", err)
	}
	return oldValue.Total, nil
}

// AddTotal adds i to the "total" field.
func (m *BillingQuotaMutation) AddTotal(i int64) {
	if m.addtotal != nil {
		*m.addtotal += i
	} else {
		m.addtotal = &i
	}
}

// AddedTotal returns the value that was added to the "total" field in this mutation.
func (m *BillingQuotaMutation) AddedTotal() (r int64, exists bool) {
	v := m.addtotal
	if v == nil {
		return
	}
	return *v, true
}

// ResetTotal resets all changes to the "total" field.
func (m *BillingQuotaMutation) ResetTotal() {
	m.total = nil
	m.addtotal = nil
}

// SetUsed sets the "used" field.
func (m *BillingQuotaMutation) SetUsed(i int64) {
	m.used = &i
	m.addused = nil
}

// Used returns the value of the "used" field in the mutation.
func (m *BillingQuotaMutation) Used() (r int64, exists bool) {
	v := m.used
	if v == nil {
		return
	}
	return *v, true
}

// OldUsed returns the old "used" field's value of the BillingQuota entity.
// If the BillingQuota object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingQuotaMutation) OldUsed(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUsed is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUsed requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUsed: %w", err)
	}
	return oldValue.Used, nil
}

// AddUsed adds i to the "used" field.
func (m *BillingQuotaMutation) AddUsed(i int64) {
	if m.addused != nil {
		*m.addused += i
	} else {
		m.addused = &i
	}
}

// AddedUsed returns the value that was added to the "used" field in this mutation.
func (m *BillingQuotaMutation) AddedUsed() (r int64, exists bool) {
	v := m.addused
	if v == nil {
		return
	}
	return *v, true
}

// ResetUsed resets all changes to the "used" field.
func (m *BillingQuotaMutation) ResetUsed() {
	m.used = nil
	m.addused = nil
}

// SetRemain sets the "remain" field.
func (m *BillingQuotaMutation) SetRemain(i int64) {
	m.remain = &i
	m.addremain = nil
}

// Remain returns the value of the "remain" field in the mutation.
func (m *BillingQuotaMutation) Remain() (r int64, exists bool) {
	v := m.remain
	if v == nil {
		return
	}
	return *v, true
}

// OldRemain returns the old "remain" field's value of the BillingQuota entity.
// If the BillingQuota object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingQuotaMutation) OldRemain(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRemain is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRemain requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRemain: %w", err)
	}
	return oldValue.Remain, nil
}

// AddRemain adds i to the "remain" field.
func (m *BillingQuotaMutation) AddRemain(i int64) {
	if m.addremain != nil {
		*m.addremain += i
	} else {
		m.addremain = &i
	}
}

// AddedRemain returns the value that was added to the "remain" field in this mutation.
func (m *BillingQuotaMutation) AddedRemain() (r int64, exists bool) {
	v := m.addremain
	if v == nil {
		return
	}
	return *v, true
}

// ResetRemain resets all changes to the "remain" field.
func (m *BillingQuotaMutation) ResetRemain() {
	m.remain = nil
	m.addremain = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *BillingQuotaMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *BillingQuotaMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the BillingQuota entity.
// If the BillingQuota object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingQuotaMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *BillingQuotaMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *BillingQuotaMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *BillingQuotaMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the BillingQuota entity.
// If the BillingQuota object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingQuotaMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *BillingQuotaMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// Where appends a list predicates to the BillingQuotaMutation builder.
func (m *BillingQuotaMutation) Where(ps ...predicate.BillingQuota) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the BillingQuotaMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *BillingQuotaMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.BillingQuota, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *BillingQuotaMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *BillingQuotaMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (BillingQuota).
func (m *BillingQuotaMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *BillingQuotaMutation) Fields() []string {
	fields := make([]string, 0, 7)
	if m.deleted_at != nil {
		fields = append(fields, billingquota.FieldDeletedAt)
	}
	if m.user_id != nil {
		fields = append(fields, billingquota.FieldUserID)
	}
	if m.total != nil {
		fields = append(fields, billingquota.FieldTotal)
	}
	if m.used != nil {
		fields = append(fields, billingquota.FieldUsed)
	}
	if m.remain != nil {
		fields = append(fields, billingquota.FieldRemain)
	}
	if m.created_at != nil {
		fields = append(fields, billingquota.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, billingquota.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *BillingQuotaMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case billingquota.FieldDeletedAt:
		return m.DeletedAt()
	case billingquota.FieldUserID:
		return m.UserID()
	case billingquota.FieldTotal:
		return m.Total()
	case billingquota.FieldUsed:
		return m.Used()
	case billingquota.FieldRemain:
		return m.Remain()
	case billingquota.FieldCreatedAt:
		return m.CreatedAt()
	case billingquota.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *BillingQuotaMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case billingquota.FieldDeletedAt:
		return m.OldDeletedAt(ctx)
	case billingquota.FieldUserID:
		return m.OldUserID(ctx)
	case billingquota.FieldTotal:
		return m.OldTotal(ctx)
	case billingquota.FieldUsed:
		return m.OldUsed(ctx)
	case billingquota.FieldRemain:
		return m.OldRemain(ctx)
	case billingquota.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case billingquota.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown BillingQuota field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *BillingQuotaMutation) SetField(name string, value ent.Value) error {
	switch name {
	case billingquota.FieldDeletedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDeletedAt(v)
		return nil
	case billingquota.FieldUserID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case billingquota.FieldTotal:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetTotal(v)
		return nil
	case billingquota.FieldUsed:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUsed(v)
		return nil
	case billingquota.FieldRemain:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRemain(v)
		return nil
	case billingquota.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case billingquota.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown BillingQuota field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *BillingQuotaMutation) AddedFields() []string {
	var fields []string
	if m.addtotal != nil {
		fields = append(fields, billingquota.FieldTotal)
	}
	if m.addused != nil {
		fields = append(fields, billingquota.FieldUsed)
	}
	if m.addremain != nil {
		fields = append(fields, billingquota.FieldRemain)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *BillingQuotaMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case billingquota.FieldTotal:
		return m.AddedTotal()
	case billingquota.FieldUsed:
		return m.AddedUsed()
	case billingquota.FieldRemain:
		return m.AddedRemain()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *BillingQuotaMutation) AddField(name string, value ent.Value) error {
	switch name {
	case billingquota.FieldTotal:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddTotal(v)
		return nil
	case billingquota.FieldUsed:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddUsed(v)
		return nil
	case billingquota.FieldRemain:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddRemain(v)
		return nil
	}
	return fmt.Errorf("unknown BillingQuota numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *BillingQuotaMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(billingquota.FieldDeletedAt) {
		fields = append(fields, billingquota.FieldDeletedAt)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *BillingQuotaMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *BillingQuotaMutation) ClearField(name string) error {
	switch name {
	case billingquota.FieldDeletedAt:
		m.ClearDeletedAt()
		return nil
	}
	return fmt.Errorf("unknown BillingQuota nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *BillingQuotaMutation) ResetField(name string) error {
	switch name {
	case billingquota.FieldDeletedAt:
		m.ResetDeletedAt()
		return nil
	case billingquota.FieldUserID:
		m.ResetUserID()
		return nil
	case billingquota.FieldTotal:
		m.ResetTotal()
		return nil
	case billingquota.FieldUsed:
		m.ResetUsed()
		return nil
	case billingquota.FieldRemain:
		m.ResetRemain()
		return nil
	case billingquota.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case billingquota.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown BillingQuota field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *BillingQuotaMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *BillingQuotaMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *BillingQuotaMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *BillingQuotaMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *BillingQuotaMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *BillingQuotaMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *BillingQuotaMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown BillingQuota unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *BillingQuotaMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown BillingQuota edge %s", name)
}

// BillingRecordMutation represents an operation that mutates the BillingRecord nodes in the graph.
type BillingRecordMutation struct {
	config
	op               Op
	typ              string
	id               *string
	tenant_id        *string
	user_id          *string
	model            *string
	operation        *string
	input_tokens     *int64
	addinput_tokens  *int64
	output_tokens    *int64
	addoutput_tokens *int64
	cost             *int64
	addcost          *int64
	request_time     *time.Time
	metadata         *map[string]interface{}
	created_at       *time.Time
	updated_at       *time.Time
	clearedFields    map[string]struct{}
	done             bool
	oldValue         func(context.Context) (*BillingRecord, error)
	predicates       []predicate.BillingRecord
}

var _ ent.Mutation = (*BillingRecordMutation)(nil)

// billingrecordOption allows management of the mutation configuration using functional options.
type billingrecordOption func(*BillingRecordMutation)

// newBillingRecordMutation creates new mutation for the BillingRecord entity.
func newBillingRecordMutation(c config, op Op, opts ...billingrecordOption) *BillingRecordMutation {
	m := &BillingRecordMutation{
		config:        c,
		op:            op,
		typ:           TypeBillingRecord,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withBillingRecordID sets the ID field of the mutation.
func withBillingRecordID(id string) billingrecordOption {
	return func(m *BillingRecordMutation) {
		var (
			err   error
			once  sync.Once
			value *BillingRecord
		)
		m.oldValue = func(ctx context.Context) (*BillingRecord, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().BillingRecord.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withBillingRecord sets the old BillingRecord of the mutation.
func withBillingRecord(node *BillingRecord) billingrecordOption {
	return func(m *BillingRecordMutation) {
		m.oldValue = func(context.Context) (*BillingRecord, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m BillingRecordMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m BillingRecordMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of BillingRecord entities.
func (m *BillingRecordMutation) SetID(id string) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *BillingRecordMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *BillingRecordMutation) IDs(ctx context.Context) ([]string, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []string{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().BillingRecord.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetTenantID sets the "tenant_id" field.
func (m *BillingRecordMutation) SetTenantID(s string) {
	m.tenant_id = &s
}

// TenantID returns the value of the "tenant_id" field in the mutation.
func (m *BillingRecordMutation) TenantID() (r string, exists bool) {
	v := m.tenant_id
	if v == nil {
		return
	}
	return *v, true
}

// OldTenantID returns the old "tenant_id" field's value of the BillingRecord entity.
// If the BillingRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingRecordMutation) OldTenantID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldTenantID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldTenantID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldTenantID: %w", err)
	}
	return oldValue.TenantID, nil
}

// ResetTenantID resets all changes to the "tenant_id" field.
func (m *BillingRecordMutation) ResetTenantID() {
	m.tenant_id = nil
}

// SetUserID sets the "user_id" field.
func (m *BillingRecordMutation) SetUserID(s string) {
	m.user_id = &s
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *BillingRecordMutation) UserID() (r string, exists bool) {
	v := m.user_id
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the BillingRecord entity.
// If the BillingRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingRecordMutation) OldUserID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ResetUserID resets all changes to the "user_id" field.
func (m *BillingRecordMutation) ResetUserID() {
	m.user_id = nil
}

// SetModel sets the "model" field.
func (m *BillingRecordMutation) SetModel(s string) {
	m.model = &s
}

// Model returns the value of the "model" field in the mutation.
func (m *BillingRecordMutation) Model() (r string, exists bool) {
	v := m.model
	if v == nil {
		return
	}
	return *v, true
}

// OldModel returns the old "model" field's value of the BillingRecord entity.
// If the BillingRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingRecordMutation) OldModel(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldModel is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldModel requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldModel: %w", err)
	}
	return oldValue.Model, nil
}

// ResetModel resets all changes to the "model" field.
func (m *BillingRecordMutation) ResetModel() {
	m.model = nil
}

// SetOperation sets the "operation" field.
func (m *BillingRecordMutation) SetOperation(s string) {
	m.operation = &s
}

// Operation returns the value of the "operation" field in the mutation.
func (m *BillingRecordMutation) Operation() (r string, exists bool) {
	v := m.operation
	if v == nil {
		return
	}
	return *v, true
}

// OldOperation returns the old "operation" field's value of the BillingRecord entity.
// If the BillingRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingRecordMutation) OldOperation(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOperation is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOperation requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOperation: %w", err)
	}
	return oldValue.Operation, nil
}

// ResetOperation resets all changes to the "operation" field.
func (m *BillingRecordMutation) ResetOperation() {
	m.operation = nil
}

// SetInputTokens sets the "input_tokens" field.
func (m *BillingRecordMutation) SetInputTokens(i int64) {
	m.input_tokens = &i
	m.addinput_tokens = nil
}

// InputTokens returns the value of the "input_tokens" field in the mutation.
func (m *BillingRecordMutation) InputTokens() (r int64, exists bool) {
	v := m.input_tokens
	if v == nil {
		return
	}
	return *v, true
}

// OldInputTokens returns the old "input_tokens" field's value of the BillingRecord entity.
// If the BillingRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingRecordMutation) OldInputTokens(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldInputTokens is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldInputTokens requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldInputTokens: %w", err)
	}
	return oldValue.InputTokens, nil
}

// AddInputTokens adds i to the "input_tokens" field.
func (m *BillingRecordMutation) AddInputTokens(i int64) {
	if m.addinput_tokens != nil {
		*m.addinput_tokens += i
	} else {
		m.addinput_tokens = &i
	}
}

// AddedInputTokens returns the value that was added to the "input_tokens" field in this mutation.
func (m *BillingRecordMutation) AddedInputTokens() (r int64, exists bool) {
	v := m.addinput_tokens
	if v == nil {
		return
	}
	return *v, true
}

// ResetInputTokens resets all changes to the "input_tokens" field.
func (m *BillingRecordMutation) ResetInputTokens() {
	m.input_tokens = nil
	m.addinput_tokens = nil
}

// SetOutputTokens sets the "output_tokens" field.
func (m *BillingRecordMutation) SetOutputTokens(i int64) {
	m.output_tokens = &i
	m.addoutput_tokens = nil
}

// OutputTokens returns the value of the "output_tokens" field in the mutation.
func (m *BillingRecordMutation) OutputTokens() (r int64, exists bool) {
	v := m.output_tokens
	if v == nil {
		return
	}
	return *v, true
}

// OldOutputTokens returns the old "output_tokens" field's value of the BillingRecord entity.
// If the BillingRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingRecordMutation) OldOutputTokens(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOutputTokens is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOutputTokens requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOutputTokens: %w", err)
	}
	return oldValue.OutputTokens, nil
}

// AddOutputTokens adds i to the "output_tokens" field.
func (m *BillingRecordMutation) AddOutputTokens(i int64) {
	if m.addoutput_tokens != nil {
		*m.addoutput_tokens += i
	} else {
		m.addoutput_tokens = &i
	}
}

// AddedOutputTokens returns the value that was added to the "output_tokens" field in this mutation.
func (m *BillingRecordMutation) AddedOutputTokens() (r int64, exists bool) {
	v := m.addoutput_tokens
	if v == nil {
		return
	}
	return *v, true
}

// ResetOutputTokens resets all changes to the "output_tokens" field.
func (m *BillingRecordMutation) ResetOutputTokens() {
	m.output_tokens = nil
	m.addoutput_tokens = nil
}

// SetCost sets the "cost" field.
func (m *BillingRecordMutation) SetCost(i int64) {
	m.cost = &i
	m.addcost = nil
}

// Cost returns the value of the "cost" field in the mutation.
func (m *BillingRecordMutation) Cost() (r int64, exists bool) {
	v := m.cost
	if v == nil {
		return
	}
	return *v, true
}

// OldCost returns the old "cost" field's value of the BillingRecord entity.
// If the BillingRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingRecordMutation) OldCost(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCost is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCost requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCost: %w", err)
	}
	return oldValue.Cost, nil
}

// AddCost adds i to the "cost" field.
func (m *BillingRecordMutation) AddCost(i int64) {
	if m.addcost != nil {
		*m.addcost += i
	} else {
		m.addcost = &i
	}
}

// AddedCost returns the value that was added to the "cost" field in this mutation.
func (m *BillingRecordMutation) AddedCost() (r int64, exists bool) {
	v := m.addcost
	if v == nil {
		return
	}
	return *v, true
}

// ResetCost resets all changes to the "cost" field.
func (m *BillingRecordMutation) ResetCost() {
	m.cost = nil
	m.addcost = nil
}

// SetRequestTime sets the "request_time" field.
func (m *BillingRecordMutation) SetRequestTime(t time.Time) {
	m.request_time = &t
}

// RequestTime returns the value of the "request_time" field in the mutation.
func (m *BillingRecordMutation) RequestTime() (r time.Time, exists bool) {
	v := m.request_time
	if v == nil {
		return
	}
	return *v, true
}

// OldRequestTime returns the old "request_time" field's value of the BillingRecord entity.
// If the BillingRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingRecordMutation) OldRequestTime(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRequestTime is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRequestTime requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRequestTime: %w", err)
	}
	return oldValue.RequestTime, nil
}

// ResetRequestTime resets all changes to the "request_time" field.
func (m *BillingRecordMutation) ResetRequestTime() {
	m.request_time = nil
}

// SetMetadata sets the "metadata" field.
func (m *BillingRecordMutation) SetMetadata(value map[string]interface{}) {
	m.metadata = &value
}

// Metadata returns the value of the "metadata" field in the mutation.
func (m *BillingRecordMutation) Metadata() (r map[string]interface{}, exists bool) {
	v := m.metadata
	if v == nil {
		return
	}
	return *v, true
}

// OldMetadata returns the old "metadata" field's value of the BillingRecord entity.
// If the BillingRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingRecordMutation) OldMetadata(ctx context.Context) (v map[string]interface{}, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldMetadata is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldMetadata requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldMetadata: %w", err)
	}
	return oldValue.Metadata, nil
}

// ResetMetadata resets all changes to the "metadata" field.
func (m *BillingRecordMutation) ResetMetadata() {
	m.metadata = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *BillingRecordMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *BillingRecordMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the BillingRecord entity.
// If the BillingRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingRecordMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *BillingRecordMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *BillingRecordMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *BillingRecordMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the BillingRecord entity.
// If the BillingRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingRecordMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *BillingRecordMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// Where appends a list predicates to the BillingRecordMutation builder.
func (m *BillingRecordMutation) Where(ps ...predicate.BillingRecord) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the BillingRecordMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *BillingRecordMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.BillingRecord, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *BillingRecordMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *BillingRecordMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (BillingRecord).
func (m *BillingRecordMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *BillingRecordMutation) Fields() []string {
	fields := make([]string, 0, 11)
	if m.tenant_id != nil {
		fields = append(fields, billingrecord.FieldTenantID)
	}
	if m.user_id != nil {
		fields = append(fields, billingrecord.FieldUserID)
	}
	if m.model != nil {
		fields = append(fields, billingrecord.FieldModel)
	}
	if m.operation != nil {
		fields = append(fields, billingrecord.FieldOperation)
	}
	if m.input_tokens != nil {
		fields = append(fields, billingrecord.FieldInputTokens)
	}
	if m.output_tokens != nil {
		fields = append(fields, billingrecord.FieldOutputTokens)
	}
	if m.cost != nil {
		fields = append(fields, billingrecord.FieldCost)
	}
	if m.request_time != nil {
		fields = append(fields, billingrecord.FieldRequestTime)
	}
	if m.metadata != nil {
		fields = append(fields, billingrecord.FieldMetadata)
	}
	if m.created_at != nil {
		fields = append(fields, billingrecord.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, billingrecord.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *BillingRecordMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case billingrecord.FieldTenantID:
		return m.TenantID()
	case billingrecord.FieldUserID:
		return m.UserID()
	case billingrecord.FieldModel:
		return m.Model()
	case billingrecord.FieldOperation:
		return m.Operation()
	case billingrecord.FieldInputTokens:
		return m.InputTokens()
	case billingrecord.FieldOutputTokens:
		return m.OutputTokens()
	case billingrecord.FieldCost:
		return m.Cost()
	case billingrecord.FieldRequestTime:
		return m.RequestTime()
	case billingrecord.FieldMetadata:
		return m.Metadata()
	case billingrecord.FieldCreatedAt:
		return m.CreatedAt()
	case billingrecord.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *BillingRecordMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case billingrecord.FieldTenantID:
		return m.OldTenantID(ctx)
	case billingrecord.FieldUserID:
		return m.OldUserID(ctx)
	case billingrecord.FieldModel:
		return m.OldModel(ctx)
	case billingrecord.FieldOperation:
		return m.OldOperation(ctx)
	case billingrecord.FieldInputTokens:
		return m.OldInputTokens(ctx)
	case billingrecord.FieldOutputTokens:
		return m.OldOutputTokens(ctx)
	case billingrecord.FieldCost:
		return m.OldCost(ctx)
	case billingrecord.FieldRequestTime:
		return m.OldRequestTime(ctx)
	case billingrecord.FieldMetadata:
		return m.OldMetadata(ctx)
	case billingrecord.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case billingrecord.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown BillingRecord field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *BillingRecordMutation) SetField(name string, value ent.Value) error {
	switch name {
	case billingrecord.FieldTenantID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetTenantID(v)
		return nil
	case billingrecord.FieldUserID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case billingrecord.FieldModel:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetModel(v)
		return nil
	case billingrecord.FieldOperation:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOperation(v)
		return nil
	case billingrecord.FieldInputTokens:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetInputTokens(v)
		return nil
	case billingrecord.FieldOutputTokens:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOutputTokens(v)
		return nil
	case billingrecord.FieldCost:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCost(v)
		return nil
	case billingrecord.FieldRequestTime:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRequestTime(v)
		return nil
	case billingrecord.FieldMetadata:
		v, ok := value.(map[string]interface{})
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetMetadata(v)
		return nil
	case billingrecord.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case billingrecord.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown BillingRecord field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *BillingRecordMutation) AddedFields() []string {
	var fields []string
	if m.addinput_tokens != nil {
		fields = append(fields, billingrecord.FieldInputTokens)
	}
	if m.addoutput_tokens != nil {
		fields = append(fields, billingrecord.FieldOutputTokens)
	}
	if m.addcost != nil {
		fields = append(fields, billingrecord.FieldCost)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *BillingRecordMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case billingrecord.FieldInputTokens:
		return m.AddedInputTokens()
	case billingrecord.FieldOutputTokens:
		return m.AddedOutputTokens()
	case billingrecord.FieldCost:
		return m.AddedCost()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *BillingRecordMutation) AddField(name string, value ent.Value) error {
	switch name {
	case billingrecord.FieldInputTokens:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddInputTokens(v)
		return nil
	case billingrecord.FieldOutputTokens:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOutputTokens(v)
		return nil
	case billingrecord.FieldCost:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddCost(v)
		return nil
	}
	return fmt.Errorf("unknown BillingRecord numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *BillingRecordMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *BillingRecordMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *BillingRecordMutation) ClearField(name string) error {
	return fmt.Errorf("unknown BillingRecord nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *BillingRecordMutation) ResetField(name string) error {
	switch name {
	case billingrecord.FieldTenantID:
		m.ResetTenantID()
		return nil
	case billingrecord.FieldUserID:
		m.ResetUserID()
		return nil
	case billingrecord.FieldModel:
		m.ResetModel()
		return nil
	case billingrecord.FieldOperation:
		m.ResetOperation()
		return nil
	case billingrecord.FieldInputTokens:
		m.ResetInputTokens()
		return nil
	case billingrecord.FieldOutputTokens:
		m.ResetOutputTokens()
		return nil
	case billingrecord.FieldCost:
		m.ResetCost()
		return nil
	case billingrecord.FieldRequestTime:
		m.ResetRequestTime()
		return nil
	case billingrecord.FieldMetadata:
		m.ResetMetadata()
		return nil
	case billingrecord.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case billingrecord.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown BillingRecord field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *BillingRecordMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *BillingRecordMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *BillingRecordMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *BillingRecordMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *BillingRecordMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *BillingRecordMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *BillingRecordMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown BillingRecord unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *BillingRecordMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown BillingRecord edge %s", name)
}

// BillingUsageMutation represents an operation that mutates the BillingUsage nodes in the graph.
type BillingUsageMutation struct {
	config
	op            Op
	typ           string
	id            *string
	deleted_at    *time.Time
	user_id       *string
	model_name    *string
	tokens        *int64
	addtokens     *int64
	operation     *string
	created_at    *time.Time
	updated_at    *time.Time
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*BillingUsage, error)
	predicates    []predicate.BillingUsage
}

var _ ent.Mutation = (*BillingUsageMutation)(nil)

// billingusageOption allows management of the mutation configuration using functional options.
type billingusageOption func(*BillingUsageMutation)

// newBillingUsageMutation creates new mutation for the BillingUsage entity.
func newBillingUsageMutation(c config, op Op, opts ...billingusageOption) *BillingUsageMutation {
	m := &BillingUsageMutation{
		config:        c,
		op:            op,
		typ:           TypeBillingUsage,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withBillingUsageID sets the ID field of the mutation.
func withBillingUsageID(id string) billingusageOption {
	return func(m *BillingUsageMutation) {
		var (
			err   error
			once  sync.Once
			value *BillingUsage
		)
		m.oldValue = func(ctx context.Context) (*BillingUsage, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().BillingUsage.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withBillingUsage sets the old BillingUsage of the mutation.
func withBillingUsage(node *BillingUsage) billingusageOption {
	return func(m *BillingUsageMutation) {
		m.oldValue = func(context.Context) (*BillingUsage, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m BillingUsageMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m BillingUsageMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of BillingUsage entities.
func (m *BillingUsageMutation) SetID(id string) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *BillingUsageMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *BillingUsageMutation) IDs(ctx context.Context) ([]string, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []string{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().BillingUsage.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetDeletedAt sets the "deleted_at" field.
func (m *BillingUsageMutation) SetDeletedAt(t time.Time) {
	m.deleted_at = &t
}

// DeletedAt returns the value of the "deleted_at" field in the mutation.
func (m *BillingUsageMutation) DeletedAt() (r time.Time, exists bool) {
	v := m.deleted_at
	if v == nil {
		return
	}
	return *v, true
}

// OldDeletedAt returns the old "deleted_at" field's value of the BillingUsage entity.
// If the BillingUsage object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingUsageMutation) OldDeletedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDeletedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDeletedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDeletedAt: %w", err)
	}
	return oldValue.DeletedAt, nil
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (m *BillingUsageMutation) ClearDeletedAt() {
	m.deleted_at = nil
	m.clearedFields[billingusage.FieldDeletedAt] = struct{}{}
}

// DeletedAtCleared returns if the "deleted_at" field was cleared in this mutation.
func (m *BillingUsageMutation) DeletedAtCleared() bool {
	_, ok := m.clearedFields[billingusage.FieldDeletedAt]
	return ok
}

// ResetDeletedAt resets all changes to the "deleted_at" field.
func (m *BillingUsageMutation) ResetDeletedAt() {
	m.deleted_at = nil
	delete(m.clearedFields, billingusage.FieldDeletedAt)
}

// SetUserID sets the "user_id" field.
func (m *BillingUsageMutation) SetUserID(s string) {
	m.user_id = &s
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *BillingUsageMutation) UserID() (r string, exists bool) {
	v := m.user_id
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the BillingUsage entity.
// If the BillingUsage object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingUsageMutation) OldUserID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ResetUserID resets all changes to the "user_id" field.
func (m *BillingUsageMutation) ResetUserID() {
	m.user_id = nil
}

// SetModelName sets the "model_name" field.
func (m *BillingUsageMutation) SetModelName(s string) {
	m.model_name = &s
}

// ModelName returns the value of the "model_name" field in the mutation.
func (m *BillingUsageMutation) ModelName() (r string, exists bool) {
	v := m.model_name
	if v == nil {
		return
	}
	return *v, true
}

// OldModelName returns the old "model_name" field's value of the BillingUsage entity.
// If the BillingUsage object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingUsageMutation) OldModelName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldModelName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldModelName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldModelName: %w", err)
	}
	return oldValue.ModelName, nil
}

// ResetModelName resets all changes to the "model_name" field.
func (m *BillingUsageMutation) ResetModelName() {
	m.model_name = nil
}

// SetTokens sets the "tokens" field.
func (m *BillingUsageMutation) SetTokens(i int64) {
	m.tokens = &i
	m.addtokens = nil
}

// Tokens returns the value of the "tokens" field in the mutation.
func (m *BillingUsageMutation) Tokens() (r int64, exists bool) {
	v := m.tokens
	if v == nil {
		return
	}
	return *v, true
}

// OldTokens returns the old "tokens" field's value of the BillingUsage entity.
// If the BillingUsage object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingUsageMutation) OldTokens(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldTokens is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldTokens requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldTokens: %w", err)
	}
	return oldValue.Tokens, nil
}

// AddTokens adds i to the "tokens" field.
func (m *BillingUsageMutation) AddTokens(i int64) {
	if m.addtokens != nil {
		*m.addtokens += i
	} else {
		m.addtokens = &i
	}
}

// AddedTokens returns the value that was added to the "tokens" field in this mutation.
func (m *BillingUsageMutation) AddedTokens() (r int64, exists bool) {
	v := m.addtokens
	if v == nil {
		return
	}
	return *v, true
}

// ResetTokens resets all changes to the "tokens" field.
func (m *BillingUsageMutation) ResetTokens() {
	m.tokens = nil
	m.addtokens = nil
}

// SetOperation sets the "operation" field.
func (m *BillingUsageMutation) SetOperation(s string) {
	m.operation = &s
}

// Operation returns the value of the "operation" field in the mutation.
func (m *BillingUsageMutation) Operation() (r string, exists bool) {
	v := m.operation
	if v == nil {
		return
	}
	return *v, true
}

// OldOperation returns the old "operation" field's value of the BillingUsage entity.
// If the BillingUsage object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingUsageMutation) OldOperation(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOperation is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOperation requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOperation: %w", err)
	}
	return oldValue.Operation, nil
}

// ResetOperation resets all changes to the "operation" field.
func (m *BillingUsageMutation) ResetOperation() {
	m.operation = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *BillingUsageMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *BillingUsageMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the BillingUsage entity.
// If the BillingUsage object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingUsageMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *BillingUsageMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *BillingUsageMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *BillingUsageMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the BillingUsage entity.
// If the BillingUsage object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BillingUsageMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *BillingUsageMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// Where appends a list predicates to the BillingUsageMutation builder.
func (m *BillingUsageMutation) Where(ps ...predicate.BillingUsage) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the BillingUsageMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *BillingUsageMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.BillingUsage, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *BillingUsageMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *BillingUsageMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (BillingUsage).
func (m *BillingUsageMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *BillingUsageMutation) Fields() []string {
	fields := make([]string, 0, 7)
	if m.deleted_at != nil {
		fields = append(fields, billingusage.FieldDeletedAt)
	}
	if m.user_id != nil {
		fields = append(fields, billingusage.FieldUserID)
	}
	if m.model_name != nil {
		fields = append(fields, billingusage.FieldModelName)
	}
	if m.tokens != nil {
		fields = append(fields, billingusage.FieldTokens)
	}
	if m.operation != nil {
		fields = append(fields, billingusage.FieldOperation)
	}
	if m.created_at != nil {
		fields = append(fields, billingusage.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, billingusage.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *BillingUsageMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case billingusage.FieldDeletedAt:
		return m.DeletedAt()
	case billingusage.FieldUserID:
		return m.UserID()
	case billingusage.FieldModelName:
		return m.ModelName()
	case billingusage.FieldTokens:
		return m.Tokens()
	case billingusage.FieldOperation:
		return m.Operation()
	case billingusage.FieldCreatedAt:
		return m.CreatedAt()
	case billingusage.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *BillingUsageMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case billingusage.FieldDeletedAt:
		return m.OldDeletedAt(ctx)
	case billingusage.FieldUserID:
		return m.OldUserID(ctx)
	case billingusage.FieldModelName:
		return m.OldModelName(ctx)
	case billingusage.FieldTokens:
		return m.OldTokens(ctx)
	case billingusage.FieldOperation:
		return m.OldOperation(ctx)
	case billingusage.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case billingusage.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown BillingUsage field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *BillingUsageMutation) SetField(name string, value ent.Value) error {
	switch name {
	case billingusage.FieldDeletedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDeletedAt(v)
		return nil
	case billingusage.FieldUserID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case billingusage.FieldModelName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetModelName(v)
		return nil
	case billingusage.FieldTokens:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetTokens(v)
		return nil
	case billingusage.FieldOperation:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOperation(v)
		return nil
	case billingusage.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case billingusage.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown BillingUsage field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *BillingUsageMutation) AddedFields() []string {
	var fields []string
	if m.addtokens != nil {
		fields = append(fields, billingusage.FieldTokens)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *BillingUsageMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case billingusage.FieldTokens:
		return m.AddedTokens()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *BillingUsageMutation) AddField(name string, value ent.Value) error {
	switch name {
	case billingusage.FieldTokens:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddTokens(v)
		return nil
	}
	return fmt.Errorf("unknown BillingUsage numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *BillingUsageMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(billingusage.FieldDeletedAt) {
		fields = append(fields, billingusage.FieldDeletedAt)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *BillingUsageMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *BillingUsageMutation) ClearField(name string) error {
	switch name {
	case billingusage.FieldDeletedAt:
		m.ClearDeletedAt()
		return nil
	}
	return fmt.Errorf("unknown BillingUsage nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *BillingUsageMutation) ResetField(name string) error {
	switch name {
	case billingusage.FieldDeletedAt:
		m.ResetDeletedAt()
		return nil
	case billingusage.FieldUserID:
		m.ResetUserID()
		return nil
	case billingusage.FieldModelName:
		m.ResetModelName()
		return nil
	case billingusage.FieldTokens:
		m.ResetTokens()
		return nil
	case billingusage.FieldOperation:
		m.ResetOperation()
		return nil
	case billingusage.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case billingusage.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown BillingUsage field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *BillingUsageMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *BillingUsageMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *BillingUsageMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *BillingUsageMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *BillingUsageMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *BillingUsageMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *BillingUsageMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown BillingUsage unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *BillingUsageMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown BillingUsage edge %s", name)
}

// CodeSnippetMutation represents an operation that mutates the CodeSnippet nodes in the graph.
type CodeSnippetMutation struct {
	config
	op                 Op
	typ                string
	id                 *uuid.UUID
	name               *string
	snippet_type       *string
	language           *string
	content            *string
	hash               *string
	start_line         *int
	addstart_line      *int
	end_line           *int
	addend_line        *int
	start_column       *int
	addstart_column    *int
	end_column         *int
	addend_column      *int
	namespace          *string
	container_name     *string
	scope              *[]string
	appendscope        []string
	dependencies       *[]string
	appenddependencies []string
	parameters         *[]map[string]interface{}
	appendparameters   []map[string]interface{}
	signature          *string
	definition_text    *string
	structured_info    *map[string]interface{}
	embedding          *pgvector.Vector
	workspacePath      *string
	clearedFields      map[string]struct{}
	source_file        *uuid.UUID
	clearedsource_file bool
	done               bool
	oldValue           func(context.Context) (*CodeSnippet, error)
	predicates         []predicate.CodeSnippet
}

var _ ent.Mutation = (*CodeSnippetMutation)(nil)

// codesnippetOption allows management of the mutation configuration using functional options.
type codesnippetOption func(*CodeSnippetMutation)

// newCodeSnippetMutation creates new mutation for the CodeSnippet entity.
func newCodeSnippetMutation(c config, op Op, opts ...codesnippetOption) *CodeSnippetMutation {
	m := &CodeSnippetMutation{
		config:        c,
		op:            op,
		typ:           TypeCodeSnippet,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withCodeSnippetID sets the ID field of the mutation.
func withCodeSnippetID(id uuid.UUID) codesnippetOption {
	return func(m *CodeSnippetMutation) {
		var (
			err   error
			once  sync.Once
			value *CodeSnippet
		)
		m.oldValue = func(ctx context.Context) (*CodeSnippet, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().CodeSnippet.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withCodeSnippet sets the old CodeSnippet of the mutation.
func withCodeSnippet(node *CodeSnippet) codesnippetOption {
	return func(m *CodeSnippetMutation) {
		m.oldValue = func(context.Context) (*CodeSnippet, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m CodeSnippetMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m CodeSnippetMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of CodeSnippet entities.
func (m *CodeSnippetMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *CodeSnippetMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *CodeSnippetMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().CodeSnippet.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetWorkspaceFileID sets the "workspace_file_id" field.
func (m *CodeSnippetMutation) SetWorkspaceFileID(u uuid.UUID) {
	m.source_file = &u
}

// WorkspaceFileID returns the value of the "workspace_file_id" field in the mutation.
func (m *CodeSnippetMutation) WorkspaceFileID() (r uuid.UUID, exists bool) {
	v := m.source_file
	if v == nil {
		return
	}
	return *v, true
}

// OldWorkspaceFileID returns the old "workspace_file_id" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldWorkspaceFileID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldWorkspaceFileID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldWorkspaceFileID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldWorkspaceFileID: %w", err)
	}
	return oldValue.WorkspaceFileID, nil
}

// ResetWorkspaceFileID resets all changes to the "workspace_file_id" field.
func (m *CodeSnippetMutation) ResetWorkspaceFileID() {
	m.source_file = nil
}

// SetName sets the "name" field.
func (m *CodeSnippetMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *CodeSnippetMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *CodeSnippetMutation) ResetName() {
	m.name = nil
}

// SetSnippetType sets the "snippet_type" field.
func (m *CodeSnippetMutation) SetSnippetType(s string) {
	m.snippet_type = &s
}

// SnippetType returns the value of the "snippet_type" field in the mutation.
func (m *CodeSnippetMutation) SnippetType() (r string, exists bool) {
	v := m.snippet_type
	if v == nil {
		return
	}
	return *v, true
}

// OldSnippetType returns the old "snippet_type" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldSnippetType(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSnippetType is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSnippetType requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSnippetType: %w", err)
	}
	return oldValue.SnippetType, nil
}

// ResetSnippetType resets all changes to the "snippet_type" field.
func (m *CodeSnippetMutation) ResetSnippetType() {
	m.snippet_type = nil
}

// SetLanguage sets the "language" field.
func (m *CodeSnippetMutation) SetLanguage(s string) {
	m.language = &s
}

// Language returns the value of the "language" field in the mutation.
func (m *CodeSnippetMutation) Language() (r string, exists bool) {
	v := m.language
	if v == nil {
		return
	}
	return *v, true
}

// OldLanguage returns the old "language" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldLanguage(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldLanguage is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldLanguage requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLanguage: %w", err)
	}
	return oldValue.Language, nil
}

// ResetLanguage resets all changes to the "language" field.
func (m *CodeSnippetMutation) ResetLanguage() {
	m.language = nil
}

// SetContent sets the "content" field.
func (m *CodeSnippetMutation) SetContent(s string) {
	m.content = &s
}

// Content returns the value of the "content" field in the mutation.
func (m *CodeSnippetMutation) Content() (r string, exists bool) {
	v := m.content
	if v == nil {
		return
	}
	return *v, true
}

// OldContent returns the old "content" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldContent(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldContent is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldContent requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldContent: %w", err)
	}
	return oldValue.Content, nil
}

// ResetContent resets all changes to the "content" field.
func (m *CodeSnippetMutation) ResetContent() {
	m.content = nil
}

// SetHash sets the "hash" field.
func (m *CodeSnippetMutation) SetHash(s string) {
	m.hash = &s
}

// Hash returns the value of the "hash" field in the mutation.
func (m *CodeSnippetMutation) Hash() (r string, exists bool) {
	v := m.hash
	if v == nil {
		return
	}
	return *v, true
}

// OldHash returns the old "hash" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldHash(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldHash is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldHash requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldHash: %w", err)
	}
	return oldValue.Hash, nil
}

// ResetHash resets all changes to the "hash" field.
func (m *CodeSnippetMutation) ResetHash() {
	m.hash = nil
}

// SetStartLine sets the "start_line" field.
func (m *CodeSnippetMutation) SetStartLine(i int) {
	m.start_line = &i
	m.addstart_line = nil
}

// StartLine returns the value of the "start_line" field in the mutation.
func (m *CodeSnippetMutation) StartLine() (r int, exists bool) {
	v := m.start_line
	if v == nil {
		return
	}
	return *v, true
}

// OldStartLine returns the old "start_line" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldStartLine(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStartLine is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStartLine requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStartLine: %w", err)
	}
	return oldValue.StartLine, nil
}

// AddStartLine adds i to the "start_line" field.
func (m *CodeSnippetMutation) AddStartLine(i int) {
	if m.addstart_line != nil {
		*m.addstart_line += i
	} else {
		m.addstart_line = &i
	}
}

// AddedStartLine returns the value that was added to the "start_line" field in this mutation.
func (m *CodeSnippetMutation) AddedStartLine() (r int, exists bool) {
	v := m.addstart_line
	if v == nil {
		return
	}
	return *v, true
}

// ResetStartLine resets all changes to the "start_line" field.
func (m *CodeSnippetMutation) ResetStartLine() {
	m.start_line = nil
	m.addstart_line = nil
}

// SetEndLine sets the "end_line" field.
func (m *CodeSnippetMutation) SetEndLine(i int) {
	m.end_line = &i
	m.addend_line = nil
}

// EndLine returns the value of the "end_line" field in the mutation.
func (m *CodeSnippetMutation) EndLine() (r int, exists bool) {
	v := m.end_line
	if v == nil {
		return
	}
	return *v, true
}

// OldEndLine returns the old "end_line" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldEndLine(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEndLine is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEndLine requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEndLine: %w", err)
	}
	return oldValue.EndLine, nil
}

// AddEndLine adds i to the "end_line" field.
func (m *CodeSnippetMutation) AddEndLine(i int) {
	if m.addend_line != nil {
		*m.addend_line += i
	} else {
		m.addend_line = &i
	}
}

// AddedEndLine returns the value that was added to the "end_line" field in this mutation.
func (m *CodeSnippetMutation) AddedEndLine() (r int, exists bool) {
	v := m.addend_line
	if v == nil {
		return
	}
	return *v, true
}

// ResetEndLine resets all changes to the "end_line" field.
func (m *CodeSnippetMutation) ResetEndLine() {
	m.end_line = nil
	m.addend_line = nil
}

// SetStartColumn sets the "start_column" field.
func (m *CodeSnippetMutation) SetStartColumn(i int) {
	m.start_column = &i
	m.addstart_column = nil
}

// StartColumn returns the value of the "start_column" field in the mutation.
func (m *CodeSnippetMutation) StartColumn() (r int, exists bool) {
	v := m.start_column
	if v == nil {
		return
	}
	return *v, true
}

// OldStartColumn returns the old "start_column" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldStartColumn(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStartColumn is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStartColumn requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStartColumn: %w", err)
	}
	return oldValue.StartColumn, nil
}

// AddStartColumn adds i to the "start_column" field.
func (m *CodeSnippetMutation) AddStartColumn(i int) {
	if m.addstart_column != nil {
		*m.addstart_column += i
	} else {
		m.addstart_column = &i
	}
}

// AddedStartColumn returns the value that was added to the "start_column" field in this mutation.
func (m *CodeSnippetMutation) AddedStartColumn() (r int, exists bool) {
	v := m.addstart_column
	if v == nil {
		return
	}
	return *v, true
}

// ResetStartColumn resets all changes to the "start_column" field.
func (m *CodeSnippetMutation) ResetStartColumn() {
	m.start_column = nil
	m.addstart_column = nil
}

// SetEndColumn sets the "end_column" field.
func (m *CodeSnippetMutation) SetEndColumn(i int) {
	m.end_column = &i
	m.addend_column = nil
}

// EndColumn returns the value of the "end_column" field in the mutation.
func (m *CodeSnippetMutation) EndColumn() (r int, exists bool) {
	v := m.end_column
	if v == nil {
		return
	}
	return *v, true
}

// OldEndColumn returns the old "end_column" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldEndColumn(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEndColumn is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEndColumn requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEndColumn: %w", err)
	}
	return oldValue.EndColumn, nil
}

// AddEndColumn adds i to the "end_column" field.
func (m *CodeSnippetMutation) AddEndColumn(i int) {
	if m.addend_column != nil {
		*m.addend_column += i
	} else {
		m.addend_column = &i
	}
}

// AddedEndColumn returns the value that was added to the "end_column" field in this mutation.
func (m *CodeSnippetMutation) AddedEndColumn() (r int, exists bool) {
	v := m.addend_column
	if v == nil {
		return
	}
	return *v, true
}

// ResetEndColumn resets all changes to the "end_column" field.
func (m *CodeSnippetMutation) ResetEndColumn() {
	m.end_column = nil
	m.addend_column = nil
}

// SetNamespace sets the "namespace" field.
func (m *CodeSnippetMutation) SetNamespace(s string) {
	m.namespace = &s
}

// Namespace returns the value of the "namespace" field in the mutation.
func (m *CodeSnippetMutation) Namespace() (r string, exists bool) {
	v := m.namespace
	if v == nil {
		return
	}
	return *v, true
}

// OldNamespace returns the old "namespace" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldNamespace(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldNamespace is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldNamespace requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNamespace: %w", err)
	}
	return oldValue.Namespace, nil
}

// ClearNamespace clears the value of the "namespace" field.
func (m *CodeSnippetMutation) ClearNamespace() {
	m.namespace = nil
	m.clearedFields[codesnippet.FieldNamespace] = struct{}{}
}

// NamespaceCleared returns if the "namespace" field was cleared in this mutation.
func (m *CodeSnippetMutation) NamespaceCleared() bool {
	_, ok := m.clearedFields[codesnippet.FieldNamespace]
	return ok
}

// ResetNamespace resets all changes to the "namespace" field.
func (m *CodeSnippetMutation) ResetNamespace() {
	m.namespace = nil
	delete(m.clearedFields, codesnippet.FieldNamespace)
}

// SetContainerName sets the "container_name" field.
func (m *CodeSnippetMutation) SetContainerName(s string) {
	m.container_name = &s
}

// ContainerName returns the value of the "container_name" field in the mutation.
func (m *CodeSnippetMutation) ContainerName() (r string, exists bool) {
	v := m.container_name
	if v == nil {
		return
	}
	return *v, true
}

// OldContainerName returns the old "container_name" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldContainerName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldContainerName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldContainerName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldContainerName: %w", err)
	}
	return oldValue.ContainerName, nil
}

// ClearContainerName clears the value of the "container_name" field.
func (m *CodeSnippetMutation) ClearContainerName() {
	m.container_name = nil
	m.clearedFields[codesnippet.FieldContainerName] = struct{}{}
}

// ContainerNameCleared returns if the "container_name" field was cleared in this mutation.
func (m *CodeSnippetMutation) ContainerNameCleared() bool {
	_, ok := m.clearedFields[codesnippet.FieldContainerName]
	return ok
}

// ResetContainerName resets all changes to the "container_name" field.
func (m *CodeSnippetMutation) ResetContainerName() {
	m.container_name = nil
	delete(m.clearedFields, codesnippet.FieldContainerName)
}

// SetScope sets the "scope" field.
func (m *CodeSnippetMutation) SetScope(s []string) {
	m.scope = &s
	m.appendscope = nil
}

// Scope returns the value of the "scope" field in the mutation.
func (m *CodeSnippetMutation) Scope() (r []string, exists bool) {
	v := m.scope
	if v == nil {
		return
	}
	return *v, true
}

// OldScope returns the old "scope" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldScope(ctx context.Context) (v []string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldScope is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldScope requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldScope: %w", err)
	}
	return oldValue.Scope, nil
}

// AppendScope adds s to the "scope" field.
func (m *CodeSnippetMutation) AppendScope(s []string) {
	m.appendscope = append(m.appendscope, s...)
}

// AppendedScope returns the list of values that were appended to the "scope" field in this mutation.
func (m *CodeSnippetMutation) AppendedScope() ([]string, bool) {
	if len(m.appendscope) == 0 {
		return nil, false
	}
	return m.appendscope, true
}

// ClearScope clears the value of the "scope" field.
func (m *CodeSnippetMutation) ClearScope() {
	m.scope = nil
	m.appendscope = nil
	m.clearedFields[codesnippet.FieldScope] = struct{}{}
}

// ScopeCleared returns if the "scope" field was cleared in this mutation.
func (m *CodeSnippetMutation) ScopeCleared() bool {
	_, ok := m.clearedFields[codesnippet.FieldScope]
	return ok
}

// ResetScope resets all changes to the "scope" field.
func (m *CodeSnippetMutation) ResetScope() {
	m.scope = nil
	m.appendscope = nil
	delete(m.clearedFields, codesnippet.FieldScope)
}

// SetDependencies sets the "dependencies" field.
func (m *CodeSnippetMutation) SetDependencies(s []string) {
	m.dependencies = &s
	m.appenddependencies = nil
}

// Dependencies returns the value of the "dependencies" field in the mutation.
func (m *CodeSnippetMutation) Dependencies() (r []string, exists bool) {
	v := m.dependencies
	if v == nil {
		return
	}
	return *v, true
}

// OldDependencies returns the old "dependencies" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldDependencies(ctx context.Context) (v []string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDependencies is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDependencies requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDependencies: %w", err)
	}
	return oldValue.Dependencies, nil
}

// AppendDependencies adds s to the "dependencies" field.
func (m *CodeSnippetMutation) AppendDependencies(s []string) {
	m.appenddependencies = append(m.appenddependencies, s...)
}

// AppendedDependencies returns the list of values that were appended to the "dependencies" field in this mutation.
func (m *CodeSnippetMutation) AppendedDependencies() ([]string, bool) {
	if len(m.appenddependencies) == 0 {
		return nil, false
	}
	return m.appenddependencies, true
}

// ClearDependencies clears the value of the "dependencies" field.
func (m *CodeSnippetMutation) ClearDependencies() {
	m.dependencies = nil
	m.appenddependencies = nil
	m.clearedFields[codesnippet.FieldDependencies] = struct{}{}
}

// DependenciesCleared returns if the "dependencies" field was cleared in this mutation.
func (m *CodeSnippetMutation) DependenciesCleared() bool {
	_, ok := m.clearedFields[codesnippet.FieldDependencies]
	return ok
}

// ResetDependencies resets all changes to the "dependencies" field.
func (m *CodeSnippetMutation) ResetDependencies() {
	m.dependencies = nil
	m.appenddependencies = nil
	delete(m.clearedFields, codesnippet.FieldDependencies)
}

// SetParameters sets the "parameters" field.
func (m *CodeSnippetMutation) SetParameters(value []map[string]interface{}) {
	m.parameters = &value
	m.appendparameters = nil
}

// Parameters returns the value of the "parameters" field in the mutation.
func (m *CodeSnippetMutation) Parameters() (r []map[string]interface{}, exists bool) {
	v := m.parameters
	if v == nil {
		return
	}
	return *v, true
}

// OldParameters returns the old "parameters" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldParameters(ctx context.Context) (v []map[string]interface{}, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldParameters is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldParameters requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldParameters: %w", err)
	}
	return oldValue.Parameters, nil
}

// AppendParameters adds value to the "parameters" field.
func (m *CodeSnippetMutation) AppendParameters(value []map[string]interface{}) {
	m.appendparameters = append(m.appendparameters, value...)
}

// AppendedParameters returns the list of values that were appended to the "parameters" field in this mutation.
func (m *CodeSnippetMutation) AppendedParameters() ([]map[string]interface{}, bool) {
	if len(m.appendparameters) == 0 {
		return nil, false
	}
	return m.appendparameters, true
}

// ClearParameters clears the value of the "parameters" field.
func (m *CodeSnippetMutation) ClearParameters() {
	m.parameters = nil
	m.appendparameters = nil
	m.clearedFields[codesnippet.FieldParameters] = struct{}{}
}

// ParametersCleared returns if the "parameters" field was cleared in this mutation.
func (m *CodeSnippetMutation) ParametersCleared() bool {
	_, ok := m.clearedFields[codesnippet.FieldParameters]
	return ok
}

// ResetParameters resets all changes to the "parameters" field.
func (m *CodeSnippetMutation) ResetParameters() {
	m.parameters = nil
	m.appendparameters = nil
	delete(m.clearedFields, codesnippet.FieldParameters)
}

// SetSignature sets the "signature" field.
func (m *CodeSnippetMutation) SetSignature(s string) {
	m.signature = &s
}

// Signature returns the value of the "signature" field in the mutation.
func (m *CodeSnippetMutation) Signature() (r string, exists bool) {
	v := m.signature
	if v == nil {
		return
	}
	return *v, true
}

// OldSignature returns the old "signature" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldSignature(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSignature is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSignature requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSignature: %w", err)
	}
	return oldValue.Signature, nil
}

// ClearSignature clears the value of the "signature" field.
func (m *CodeSnippetMutation) ClearSignature() {
	m.signature = nil
	m.clearedFields[codesnippet.FieldSignature] = struct{}{}
}

// SignatureCleared returns if the "signature" field was cleared in this mutation.
func (m *CodeSnippetMutation) SignatureCleared() bool {
	_, ok := m.clearedFields[codesnippet.FieldSignature]
	return ok
}

// ResetSignature resets all changes to the "signature" field.
func (m *CodeSnippetMutation) ResetSignature() {
	m.signature = nil
	delete(m.clearedFields, codesnippet.FieldSignature)
}

// SetDefinitionText sets the "definition_text" field.
func (m *CodeSnippetMutation) SetDefinitionText(s string) {
	m.definition_text = &s
}

// DefinitionText returns the value of the "definition_text" field in the mutation.
func (m *CodeSnippetMutation) DefinitionText() (r string, exists bool) {
	v := m.definition_text
	if v == nil {
		return
	}
	return *v, true
}

// OldDefinitionText returns the old "definition_text" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldDefinitionText(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDefinitionText is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDefinitionText requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDefinitionText: %w", err)
	}
	return oldValue.DefinitionText, nil
}

// ClearDefinitionText clears the value of the "definition_text" field.
func (m *CodeSnippetMutation) ClearDefinitionText() {
	m.definition_text = nil
	m.clearedFields[codesnippet.FieldDefinitionText] = struct{}{}
}

// DefinitionTextCleared returns if the "definition_text" field was cleared in this mutation.
func (m *CodeSnippetMutation) DefinitionTextCleared() bool {
	_, ok := m.clearedFields[codesnippet.FieldDefinitionText]
	return ok
}

// ResetDefinitionText resets all changes to the "definition_text" field.
func (m *CodeSnippetMutation) ResetDefinitionText() {
	m.definition_text = nil
	delete(m.clearedFields, codesnippet.FieldDefinitionText)
}

// SetStructuredInfo sets the "structured_info" field.
func (m *CodeSnippetMutation) SetStructuredInfo(value map[string]interface{}) {
	m.structured_info = &value
}

// StructuredInfo returns the value of the "structured_info" field in the mutation.
func (m *CodeSnippetMutation) StructuredInfo() (r map[string]interface{}, exists bool) {
	v := m.structured_info
	if v == nil {
		return
	}
	return *v, true
}

// OldStructuredInfo returns the old "structured_info" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldStructuredInfo(ctx context.Context) (v map[string]interface{}, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStructuredInfo is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStructuredInfo requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStructuredInfo: %w", err)
	}
	return oldValue.StructuredInfo, nil
}

// ClearStructuredInfo clears the value of the "structured_info" field.
func (m *CodeSnippetMutation) ClearStructuredInfo() {
	m.structured_info = nil
	m.clearedFields[codesnippet.FieldStructuredInfo] = struct{}{}
}

// StructuredInfoCleared returns if the "structured_info" field was cleared in this mutation.
func (m *CodeSnippetMutation) StructuredInfoCleared() bool {
	_, ok := m.clearedFields[codesnippet.FieldStructuredInfo]
	return ok
}

// ResetStructuredInfo resets all changes to the "structured_info" field.
func (m *CodeSnippetMutation) ResetStructuredInfo() {
	m.structured_info = nil
	delete(m.clearedFields, codesnippet.FieldStructuredInfo)
}

// SetEmbedding sets the "embedding" field.
func (m *CodeSnippetMutation) SetEmbedding(pg pgvector.Vector) {
	m.embedding = &pg
}

// Embedding returns the value of the "embedding" field in the mutation.
func (m *CodeSnippetMutation) Embedding() (r pgvector.Vector, exists bool) {
	v := m.embedding
	if v == nil {
		return
	}
	return *v, true
}

// OldEmbedding returns the old "embedding" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldEmbedding(ctx context.Context) (v pgvector.Vector, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEmbedding is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEmbedding requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEmbedding: %w", err)
	}
	return oldValue.Embedding, nil
}

// ClearEmbedding clears the value of the "embedding" field.
func (m *CodeSnippetMutation) ClearEmbedding() {
	m.embedding = nil
	m.clearedFields[codesnippet.FieldEmbedding] = struct{}{}
}

// EmbeddingCleared returns if the "embedding" field was cleared in this mutation.
func (m *CodeSnippetMutation) EmbeddingCleared() bool {
	_, ok := m.clearedFields[codesnippet.FieldEmbedding]
	return ok
}

// ResetEmbedding resets all changes to the "embedding" field.
func (m *CodeSnippetMutation) ResetEmbedding() {
	m.embedding = nil
	delete(m.clearedFields, codesnippet.FieldEmbedding)
}

// SetWorkspacePath sets the "workspacePath" field.
func (m *CodeSnippetMutation) SetWorkspacePath(s string) {
	m.workspacePath = &s
}

// WorkspacePath returns the value of the "workspacePath" field in the mutation.
func (m *CodeSnippetMutation) WorkspacePath() (r string, exists bool) {
	v := m.workspacePath
	if v == nil {
		return
	}
	return *v, true
}

// OldWorkspacePath returns the old "workspacePath" field's value of the CodeSnippet entity.
// If the CodeSnippet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CodeSnippetMutation) OldWorkspacePath(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldWorkspacePath is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldWorkspacePath requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldWorkspacePath: %w", err)
	}
	return oldValue.WorkspacePath, nil
}

// ClearWorkspacePath clears the value of the "workspacePath" field.
func (m *CodeSnippetMutation) ClearWorkspacePath() {
	m.workspacePath = nil
	m.clearedFields[codesnippet.FieldWorkspacePath] = struct{}{}
}

// WorkspacePathCleared returns if the "workspacePath" field was cleared in this mutation.
func (m *CodeSnippetMutation) WorkspacePathCleared() bool {
	_, ok := m.clearedFields[codesnippet.FieldWorkspacePath]
	return ok
}

// ResetWorkspacePath resets all changes to the "workspacePath" field.
func (m *CodeSnippetMutation) ResetWorkspacePath() {
	m.workspacePath = nil
	delete(m.clearedFields, codesnippet.FieldWorkspacePath)
}

// SetSourceFileID sets the "source_file" edge to the WorkspaceFile entity by id.
func (m *CodeSnippetMutation) SetSourceFileID(id uuid.UUID) {
	m.source_file = &id
}

// ClearSourceFile clears the "source_file" edge to the WorkspaceFile entity.
func (m *CodeSnippetMutation) ClearSourceFile() {
	m.clearedsource_file = true
	m.clearedFields[codesnippet.FieldWorkspaceFileID] = struct{}{}
}

// SourceFileCleared reports if the "source_file" edge to the WorkspaceFile entity was cleared.
func (m *CodeSnippetMutation) SourceFileCleared() bool {
	return m.clearedsource_file
}

// SourceFileID returns the "source_file" edge ID in the mutation.
func (m *CodeSnippetMutation) SourceFileID() (id uuid.UUID, exists bool) {
	if m.source_file != nil {
		return *m.source_file, true
	}
	return
}

// SourceFileIDs returns the "source_file" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// SourceFileID instead. It exists only for internal usage by the builders.
func (m *CodeSnippetMutation) SourceFileIDs() (ids []uuid.UUID) {
	if id := m.source_file; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetSourceFile resets all changes to the "source_file" edge.
func (m *CodeSnippetMutation) ResetSourceFile() {
	m.source_file = nil
	m.clearedsource_file = false
}

// Where appends a list predicates to the CodeSnippetMutation builder.
func (m *CodeSnippetMutation) Where(ps ...predicate.CodeSnippet) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the CodeSnippetMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *CodeSnippetMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.CodeSnippet, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *CodeSnippetMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *CodeSnippetMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (CodeSnippet).
func (m *CodeSnippetMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *CodeSnippetMutation) Fields() []string {
	fields := make([]string, 0, 20)
	if m.source_file != nil {
		fields = append(fields, codesnippet.FieldWorkspaceFileID)
	}
	if m.name != nil {
		fields = append(fields, codesnippet.FieldName)
	}
	if m.snippet_type != nil {
		fields = append(fields, codesnippet.FieldSnippetType)
	}
	if m.language != nil {
		fields = append(fields, codesnippet.FieldLanguage)
	}
	if m.content != nil {
		fields = append(fields, codesnippet.FieldContent)
	}
	if m.hash != nil {
		fields = append(fields, codesnippet.FieldHash)
	}
	if m.start_line != nil {
		fields = append(fields, codesnippet.FieldStartLine)
	}
	if m.end_line != nil {
		fields = append(fields, codesnippet.FieldEndLine)
	}
	if m.start_column != nil {
		fields = append(fields, codesnippet.FieldStartColumn)
	}
	if m.end_column != nil {
		fields = append(fields, codesnippet.FieldEndColumn)
	}
	if m.namespace != nil {
		fields = append(fields, codesnippet.FieldNamespace)
	}
	if m.container_name != nil {
		fields = append(fields, codesnippet.FieldContainerName)
	}
	if m.scope != nil {
		fields = append(fields, codesnippet.FieldScope)
	}
	if m.dependencies != nil {
		fields = append(fields, codesnippet.FieldDependencies)
	}
	if m.parameters != nil {
		fields = append(fields, codesnippet.FieldParameters)
	}
	if m.signature != nil {
		fields = append(fields, codesnippet.FieldSignature)
	}
	if m.definition_text != nil {
		fields = append(fields, codesnippet.FieldDefinitionText)
	}
	if m.structured_info != nil {
		fields = append(fields, codesnippet.FieldStructuredInfo)
	}
	if m.embedding != nil {
		fields = append(fields, codesnippet.FieldEmbedding)
	}
	if m.workspacePath != nil {
		fields = append(fields, codesnippet.FieldWorkspacePath)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *CodeSnippetMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case codesnippet.FieldWorkspaceFileID:
		return m.WorkspaceFileID()
	case codesnippet.FieldName:
		return m.Name()
	case codesnippet.FieldSnippetType:
		return m.SnippetType()
	case codesnippet.FieldLanguage:
		return m.Language()
	case codesnippet.FieldContent:
		return m.Content()
	case codesnippet.FieldHash:
		return m.Hash()
	case codesnippet.FieldStartLine:
		return m.StartLine()
	case codesnippet.FieldEndLine:
		return m.EndLine()
	case codesnippet.FieldStartColumn:
		return m.StartColumn()
	case codesnippet.FieldEndColumn:
		return m.EndColumn()
	case codesnippet.FieldNamespace:
		return m.Namespace()
	case codesnippet.FieldContainerName:
		return m.ContainerName()
	case codesnippet.FieldScope:
		return m.Scope()
	case codesnippet.FieldDependencies:
		return m.Dependencies()
	case codesnippet.FieldParameters:
		return m.Parameters()
	case codesnippet.FieldSignature:
		return m.Signature()
	case codesnippet.FieldDefinitionText:
		return m.DefinitionText()
	case codesnippet.FieldStructuredInfo:
		return m.StructuredInfo()
	case codesnippet.FieldEmbedding:
		return m.Embedding()
	case codesnippet.FieldWorkspacePath:
		return m.WorkspacePath()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *CodeSnippetMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case codesnippet.FieldWorkspaceFileID:
		return m.OldWorkspaceFileID(ctx)
	case codesnippet.FieldName:
		return m.OldName(ctx)
	case codesnippet.FieldSnippetType:
		return m.OldSnippetType(ctx)
	case codesnippet.FieldLanguage:
		return m.OldLanguage(ctx)
	case codesnippet.FieldContent:
		return m.OldContent(ctx)
	case codesnippet.FieldHash:
		return m.OldHash(ctx)
	case codesnippet.FieldStartLine:
		return m.OldStartLine(ctx)
	case codesnippet.FieldEndLine:
		return m.OldEndLine(ctx)
	case codesnippet.FieldStartColumn:
		return m.OldStartColumn(ctx)
	case codesnippet.FieldEndColumn:
		return m.OldEndColumn(ctx)
	case codesnippet.FieldNamespace:
		return m.OldNamespace(ctx)
	case codesnippet.FieldContainerName:
		return m.OldContainerName(ctx)
	case codesnippet.FieldScope:
		return m.OldScope(ctx)
	case codesnippet.FieldDependencies:
		return m.OldDependencies(ctx)
	case codesnippet.FieldParameters:
		return m.OldParameters(ctx)
	case codesnippet.FieldSignature:
		return m.OldSignature(ctx)
	case codesnippet.FieldDefinitionText:
		return m.OldDefinitionText(ctx)
	case codesnippet.FieldStructuredInfo:
		return m.OldStructuredInfo(ctx)
	case codesnippet.FieldEmbedding:
		return m.OldEmbedding(ctx)
	case codesnippet.FieldWorkspacePath:
		return m.OldWorkspacePath(ctx)
	}
	return nil, fmt.Errorf("unknown CodeSnippet field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CodeSnippetMutation) SetField(name string, value ent.Value) error {
	switch name {
	case codesnippet.FieldWorkspaceFileID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetWorkspaceFileID(v)
		return nil
	case codesnippet.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case codesnippet.FieldSnippetType:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSnippetType(v)
		return nil
	case codesnippet.FieldLanguage:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLanguage(v)
		return nil
	case codesnippet.FieldContent:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetContent(v)
		return nil
	case codesnippet.FieldHash:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetHash(v)
		return nil
	case codesnippet.FieldStartLine:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStartLine(v)
		return nil
	case codesnippet.FieldEndLine:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEndLine(v)
		return nil
	case codesnippet.FieldStartColumn:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStartColumn(v)
		return nil
	case codesnippet.FieldEndColumn:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEndColumn(v)
		return nil
	case codesnippet.FieldNamespace:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNamespace(v)
		return nil
	case codesnippet.FieldContainerName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetContainerName(v)
		return nil
	case codesnippet.FieldScope:
		v, ok := value.([]string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetScope(v)
		return nil
	case codesnippet.FieldDependencies:
		v, ok := value.([]string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDependencies(v)
		return nil
	case codesnippet.FieldParameters:
		v, ok := value.([]map[string]interface{})
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetParameters(v)
		return nil
	case codesnippet.FieldSignature:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSignature(v)
		return nil
	case codesnippet.FieldDefinitionText:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDefinitionText(v)
		return nil
	case codesnippet.FieldStructuredInfo:
		v, ok := value.(map[string]interface{})
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStructuredInfo(v)
		return nil
	case codesnippet.FieldEmbedding:
		v, ok := value.(pgvector.Vector)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEmbedding(v)
		return nil
	case codesnippet.FieldWorkspacePath:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetWorkspacePath(v)
		return nil
	}
	return fmt.Errorf("unknown CodeSnippet field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *CodeSnippetMutation) AddedFields() []string {
	var fields []string
	if m.addstart_line != nil {
		fields = append(fields, codesnippet.FieldStartLine)
	}
	if m.addend_line != nil {
		fields = append(fields, codesnippet.FieldEndLine)
	}
	if m.addstart_column != nil {
		fields = append(fields, codesnippet.FieldStartColumn)
	}
	if m.addend_column != nil {
		fields = append(fields, codesnippet.FieldEndColumn)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *CodeSnippetMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case codesnippet.FieldStartLine:
		return m.AddedStartLine()
	case codesnippet.FieldEndLine:
		return m.AddedEndLine()
	case codesnippet.FieldStartColumn:
		return m.AddedStartColumn()
	case codesnippet.FieldEndColumn:
		return m.AddedEndColumn()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CodeSnippetMutation) AddField(name string, value ent.Value) error {
	switch name {
	case codesnippet.FieldStartLine:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddStartLine(v)
		return nil
	case codesnippet.FieldEndLine:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddEndLine(v)
		return nil
	case codesnippet.FieldStartColumn:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddStartColumn(v)
		return nil
	case codesnippet.FieldEndColumn:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddEndColumn(v)
		return nil
	}
	return fmt.Errorf("unknown CodeSnippet numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *CodeSnippetMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(codesnippet.FieldNamespace) {
		fields = append(fields, codesnippet.FieldNamespace)
	}
	if m.FieldCleared(codesnippet.FieldContainerName) {
		fields = append(fields, codesnippet.FieldContainerName)
	}
	if m.FieldCleared(codesnippet.FieldScope) {
		fields = append(fields, codesnippet.FieldScope)
	}
	if m.FieldCleared(codesnippet.FieldDependencies) {
		fields = append(fields, codesnippet.FieldDependencies)
	}
	if m.FieldCleared(codesnippet.FieldParameters) {
		fields = append(fields, codesnippet.FieldParameters)
	}
	if m.FieldCleared(codesnippet.FieldSignature) {
		fields = append(fields, codesnippet.FieldSignature)
	}
	if m.FieldCleared(codesnippet.FieldDefinitionText) {
		fields = append(fields, codesnippet.FieldDefinitionText)
	}
	if m.FieldCleared(codesnippet.FieldStructuredInfo) {
		fields = append(fields, codesnippet.FieldStructuredInfo)
	}
	if m.FieldCleared(codesnippet.FieldEmbedding) {
		fields = append(fields, codesnippet.FieldEmbedding)
	}
	if m.FieldCleared(codesnippet.FieldWorkspacePath) {
		fields = append(fields, codesnippet.FieldWorkspacePath)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *CodeSnippetMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *CodeSnippetMutation) ClearField(name string) error {
	switch name {
	case codesnippet.FieldNamespace:
		m.ClearNamespace()
		return nil
	case codesnippet.FieldContainerName:
		m.ClearContainerName()
		return nil
	case codesnippet.FieldScope:
		m.ClearScope()
		return nil
	case codesnippet.FieldDependencies:
		m.ClearDependencies()
		return nil
	case codesnippet.FieldParameters:
		m.ClearParameters()
		return nil
	case codesnippet.FieldSignature:
		m.ClearSignature()
		return nil
	case codesnippet.FieldDefinitionText:
		m.ClearDefinitionText()
		return nil
	case codesnippet.FieldStructuredInfo:
		m.ClearStructuredInfo()
		return nil
	case codesnippet.FieldEmbedding:
		m.ClearEmbedding()
		return nil
	case codesnippet.FieldWorkspacePath:
		m.ClearWorkspacePath()
		return nil
	}
	return fmt.Errorf("unknown CodeSnippet nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *CodeSnippetMutation) ResetField(name string) error {
	switch name {
	case codesnippet.FieldWorkspaceFileID:
		m.ResetWorkspaceFileID()
		return nil
	case codesnippet.FieldName:
		m.ResetName()
		return nil
	case codesnippet.FieldSnippetType:
		m.ResetSnippetType()
		return nil
	case codesnippet.FieldLanguage:
		m.ResetLanguage()
		return nil
	case codesnippet.FieldContent:
		m.ResetContent()
		return nil
	case codesnippet.FieldHash:
		m.ResetHash()
		return nil
	case codesnippet.FieldStartLine:
		m.ResetStartLine()
		return nil
	case codesnippet.FieldEndLine:
		m.ResetEndLine()
		return nil
	case codesnippet.FieldStartColumn:
		m.ResetStartColumn()
		return nil
	case codesnippet.FieldEndColumn:
		m.ResetEndColumn()
		return nil
	case codesnippet.FieldNamespace:
		m.ResetNamespace()
		return nil
	case codesnippet.FieldContainerName:
		m.ResetContainerName()
		return nil
	case codesnippet.FieldScope:
		m.ResetScope()
		return nil
	case codesnippet.FieldDependencies:
		m.ResetDependencies()
		return nil
	case codesnippet.FieldParameters:
		m.ResetParameters()
		return nil
	case codesnippet.FieldSignature:
		m.ResetSignature()
		return nil
	case codesnippet.FieldDefinitionText:
		m.ResetDefinitionText()
		return nil
	case codesnippet.FieldStructuredInfo:
		m.ResetStructuredInfo()
		return nil
	case codesnippet.FieldEmbedding:
		m.ResetEmbedding()
		return nil
	case codesnippet.FieldWorkspacePath:
		m.ResetWorkspacePath()
		return nil
	}
	return fmt.Errorf("unknown CodeSnippet field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *CodeSnippetMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.source_file != nil {
		edges = append(edges, codesnippet.EdgeSourceFile)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *CodeSnippetMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case codesnippet.EdgeSourceFile:
		if id := m.source_file; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *CodeSnippetMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *CodeSnippetMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *CodeSnippetMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedsource_file {
		edges = append(edges, codesnippet.EdgeSourceFile)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *CodeSnippetMutation) EdgeCleared(name string) bool {
	switch name {
	case codesnippet.EdgeSourceFile:
		return m.clearedsource_file
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *CodeSnippetMutation) ClearEdge(name string) error {
	switch name {
	case codesnippet.EdgeSourceFile:
		m.ClearSourceFile()
		return nil
	}
	return fmt.Errorf("unknown CodeSnippet unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *CodeSnippetMutation) ResetEdge(name string) error {
	switch name {
	case codesnippet.EdgeSourceFile:
		m.ResetSourceFile()
		return nil
	}
	return fmt.Errorf("unknown CodeSnippet edge %s", name)
}

// ExtensionMutation represents an operation that mutates the Extension nodes in the graph.
type ExtensionMutation struct {
	config
	op            Op
	typ           string
	id            *uuid.UUID
	version       *string
	_path         *string
	created_at    *time.Time
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*Extension, error)
	predicates    []predicate.Extension
}

var _ ent.Mutation = (*ExtensionMutation)(nil)

// extensionOption allows management of the mutation configuration using functional options.
type extensionOption func(*ExtensionMutation)

// newExtensionMutation creates new mutation for the Extension entity.
func newExtensionMutation(c config, op Op, opts ...extensionOption) *ExtensionMutation {
	m := &ExtensionMutation{
		config:        c,
		op:            op,
		typ:           TypeExtension,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withExtensionID sets the ID field of the mutation.
func withExtensionID(id uuid.UUID) extensionOption {
	return func(m *ExtensionMutation) {
		var (
			err   error
			once  sync.Once
			value *Extension
		)
		m.oldValue = func(ctx context.Context) (*Extension, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Extension.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withExtension sets the old Extension of the mutation.
func withExtension(node *Extension) extensionOption {
	return func(m *ExtensionMutation) {
		m.oldValue = func(context.Context) (*Extension, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m ExtensionMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m ExtensionMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Extension entities.
func (m *ExtensionMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *ExtensionMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *ExtensionMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Extension.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetVersion sets the "version" field.
func (m *ExtensionMutation) SetVersion(s string) {
	m.version = &s
}

// Version returns the value of the "version" field in the mutation.
func (m *ExtensionMutation) Version() (r string, exists bool) {
	v := m.version
	if v == nil {
		return
	}
	return *v, true
}

// OldVersion returns the old "version" field's value of the Extension entity.
// If the Extension object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ExtensionMutation) OldVersion(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldVersion is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldVersion requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldVersion: %w", err)
	}
	return oldValue.Version, nil
}

// ResetVersion resets all changes to the "version" field.
func (m *ExtensionMutation) ResetVersion() {
	m.version = nil
}

// SetPath sets the "path" field.
func (m *ExtensionMutation) SetPath(s string) {
	m._path = &s
}

// Path returns the value of the "path" field in the mutation.
func (m *ExtensionMutation) Path() (r string, exists bool) {
	v := m._path
	if v == nil {
		return
	}
	return *v, true
}

// OldPath returns the old "path" field's value of the Extension entity.
// If the Extension object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ExtensionMutation) OldPath(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPath is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPath requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPath: %w", err)
	}
	return oldValue.Path, nil
}

// ResetPath resets all changes to the "path" field.
func (m *ExtensionMutation) ResetPath() {
	m._path = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *ExtensionMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *ExtensionMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Extension entity.
// If the Extension object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ExtensionMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *ExtensionMutation) ResetCreatedAt() {
	m.created_at = nil
}

// Where appends a list predicates to the ExtensionMutation builder.
func (m *ExtensionMutation) Where(ps ...predicate.Extension) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the ExtensionMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *ExtensionMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Extension, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *ExtensionMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *ExtensionMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Extension).
func (m *ExtensionMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *ExtensionMutation) Fields() []string {
	fields := make([]string, 0, 3)
	if m.version != nil {
		fields = append(fields, extension.FieldVersion)
	}
	if m._path != nil {
		fields = append(fields, extension.FieldPath)
	}
	if m.created_at != nil {
		fields = append(fields, extension.FieldCreatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *ExtensionMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case extension.FieldVersion:
		return m.Version()
	case extension.FieldPath:
		return m.Path()
	case extension.FieldCreatedAt:
		return m.CreatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *ExtensionMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case extension.FieldVersion:
		return m.OldVersion(ctx)
	case extension.FieldPath:
		return m.OldPath(ctx)
	case extension.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Extension field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ExtensionMutation) SetField(name string, value ent.Value) error {
	switch name {
	case extension.FieldVersion:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetVersion(v)
		return nil
	case extension.FieldPath:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPath(v)
		return nil
	case extension.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Extension field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *ExtensionMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *ExtensionMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ExtensionMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Extension numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *ExtensionMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *ExtensionMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *ExtensionMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Extension nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *ExtensionMutation) ResetField(name string) error {
	switch name {
	case extension.FieldVersion:
		m.ResetVersion()
		return nil
	case extension.FieldPath:
		m.ResetPath()
		return nil
	case extension.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	}
	return fmt.Errorf("unknown Extension field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *ExtensionMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *ExtensionMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *ExtensionMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *ExtensionMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *ExtensionMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *ExtensionMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *ExtensionMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Extension unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *ExtensionMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Extension edge %s", name)
}

// InviteCodeMutation represents an operation that mutates the InviteCode nodes in the graph.
type InviteCodeMutation struct {
	config
	op            Op
	typ           string
	id            *uuid.UUID
	admin_id      *uuid.UUID
	code          *string
	status        *consts.InviteCodeStatus
	created_at    *time.Time
	updated_at    *time.Time
	expired_at    *time.Time
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*InviteCode, error)
	predicates    []predicate.InviteCode
}

var _ ent.Mutation = (*InviteCodeMutation)(nil)

// invitecodeOption allows management of the mutation configuration using functional options.
type invitecodeOption func(*InviteCodeMutation)

// newInviteCodeMutation creates new mutation for the InviteCode entity.
func newInviteCodeMutation(c config, op Op, opts ...invitecodeOption) *InviteCodeMutation {
	m := &InviteCodeMutation{
		config:        c,
		op:            op,
		typ:           TypeInviteCode,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withInviteCodeID sets the ID field of the mutation.
func withInviteCodeID(id uuid.UUID) invitecodeOption {
	return func(m *InviteCodeMutation) {
		var (
			err   error
			once  sync.Once
			value *InviteCode
		)
		m.oldValue = func(ctx context.Context) (*InviteCode, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().InviteCode.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withInviteCode sets the old InviteCode of the mutation.
func withInviteCode(node *InviteCode) invitecodeOption {
	return func(m *InviteCodeMutation) {
		m.oldValue = func(context.Context) (*InviteCode, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m InviteCodeMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m InviteCodeMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of InviteCode entities.
func (m *InviteCodeMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *InviteCodeMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *InviteCodeMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().InviteCode.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetAdminID sets the "admin_id" field.
func (m *InviteCodeMutation) SetAdminID(u uuid.UUID) {
	m.admin_id = &u
}

// AdminID returns the value of the "admin_id" field in the mutation.
func (m *InviteCodeMutation) AdminID() (r uuid.UUID, exists bool) {
	v := m.admin_id
	if v == nil {
		return
	}
	return *v, true
}

// OldAdminID returns the old "admin_id" field's value of the InviteCode entity.
// If the InviteCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *InviteCodeMutation) OldAdminID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAdminID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAdminID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAdminID: %w", err)
	}
	return oldValue.AdminID, nil
}

// ResetAdminID resets all changes to the "admin_id" field.
func (m *InviteCodeMutation) ResetAdminID() {
	m.admin_id = nil
}

// SetCode sets the "code" field.
func (m *InviteCodeMutation) SetCode(s string) {
	m.code = &s
}

// Code returns the value of the "code" field in the mutation.
func (m *InviteCodeMutation) Code() (r string, exists bool) {
	v := m.code
	if v == nil {
		return
	}
	return *v, true
}

// OldCode returns the old "code" field's value of the InviteCode entity.
// If the InviteCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *InviteCodeMutation) OldCode(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCode is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCode requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCode: %w", err)
	}
	return oldValue.Code, nil
}

// ResetCode resets all changes to the "code" field.
func (m *InviteCodeMutation) ResetCode() {
	m.code = nil
}

// SetStatus sets the "status" field.
func (m *InviteCodeMutation) SetStatus(ccs consts.InviteCodeStatus) {
	m.status = &ccs
}

// Status returns the value of the "status" field in the mutation.
func (m *InviteCodeMutation) Status() (r consts.InviteCodeStatus, exists bool) {
	v := m.status
	if v == nil {
		return
	}
	return *v, true
}

// OldStatus returns the old "status" field's value of the InviteCode entity.
// If the InviteCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *InviteCodeMutation) OldStatus(ctx context.Context) (v consts.InviteCodeStatus, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStatus is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStatus requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStatus: %w", err)
	}
	return oldValue.Status, nil
}

// ResetStatus resets all changes to the "status" field.
func (m *InviteCodeMutation) ResetStatus() {
	m.status = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *InviteCodeMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *InviteCodeMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the InviteCode entity.
// If the InviteCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *InviteCodeMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *InviteCodeMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *InviteCodeMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *InviteCodeMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the InviteCode entity.
// If the InviteCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *InviteCodeMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *InviteCodeMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetExpiredAt sets the "expired_at" field.
func (m *InviteCodeMutation) SetExpiredAt(t time.Time) {
	m.expired_at = &t
}

// ExpiredAt returns the value of the "expired_at" field in the mutation.
func (m *InviteCodeMutation) ExpiredAt() (r time.Time, exists bool) {
	v := m.expired_at
	if v == nil {
		return
	}
	return *v, true
}

// OldExpiredAt returns the old "expired_at" field's value of the InviteCode entity.
// If the InviteCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *InviteCodeMutation) OldExpiredAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldExpiredAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldExpiredAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldExpiredAt: %w", err)
	}
	return oldValue.ExpiredAt, nil
}

// ResetExpiredAt resets all changes to the "expired_at" field.
func (m *InviteCodeMutation) ResetExpiredAt() {
	m.expired_at = nil
}

// Where appends a list predicates to the InviteCodeMutation builder.
func (m *InviteCodeMutation) Where(ps ...predicate.InviteCode) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the InviteCodeMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *InviteCodeMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.InviteCode, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *InviteCodeMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *InviteCodeMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (InviteCode).
func (m *InviteCodeMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *InviteCodeMutation) Fields() []string {
	fields := make([]string, 0, 6)
	if m.admin_id != nil {
		fields = append(fields, invitecode.FieldAdminID)
	}
	if m.code != nil {
		fields = append(fields, invitecode.FieldCode)
	}
	if m.status != nil {
		fields = append(fields, invitecode.FieldStatus)
	}
	if m.created_at != nil {
		fields = append(fields, invitecode.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, invitecode.FieldUpdatedAt)
	}
	if m.expired_at != nil {
		fields = append(fields, invitecode.FieldExpiredAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *InviteCodeMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case invitecode.FieldAdminID:
		return m.AdminID()
	case invitecode.FieldCode:
		return m.Code()
	case invitecode.FieldStatus:
		return m.Status()
	case invitecode.FieldCreatedAt:
		return m.CreatedAt()
	case invitecode.FieldUpdatedAt:
		return m.UpdatedAt()
	case invitecode.FieldExpiredAt:
		return m.ExpiredAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *InviteCodeMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case invitecode.FieldAdminID:
		return m.OldAdminID(ctx)
	case invitecode.FieldCode:
		return m.OldCode(ctx)
	case invitecode.FieldStatus:
		return m.OldStatus(ctx)
	case invitecode.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case invitecode.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	case invitecode.FieldExpiredAt:
		return m.OldExpiredAt(ctx)
	}
	return nil, fmt.Errorf("unknown InviteCode field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *InviteCodeMutation) SetField(name string, value ent.Value) error {
	switch name {
	case invitecode.FieldAdminID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAdminID(v)
		return nil
	case invitecode.FieldCode:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCode(v)
		return nil
	case invitecode.FieldStatus:
		v, ok := value.(consts.InviteCodeStatus)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStatus(v)
		return nil
	case invitecode.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case invitecode.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	case invitecode.FieldExpiredAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetExpiredAt(v)
		return nil
	}
	return fmt.Errorf("unknown InviteCode field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *InviteCodeMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *InviteCodeMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *InviteCodeMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown InviteCode numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *InviteCodeMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *InviteCodeMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *InviteCodeMutation) ClearField(name string) error {
	return fmt.Errorf("unknown InviteCode nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *InviteCodeMutation) ResetField(name string) error {
	switch name {
	case invitecode.FieldAdminID:
		m.ResetAdminID()
		return nil
	case invitecode.FieldCode:
		m.ResetCode()
		return nil
	case invitecode.FieldStatus:
		m.ResetStatus()
		return nil
	case invitecode.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case invitecode.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	case invitecode.FieldExpiredAt:
		m.ResetExpiredAt()
		return nil
	}
	return fmt.Errorf("unknown InviteCode field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *InviteCodeMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *InviteCodeMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *InviteCodeMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *InviteCodeMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *InviteCodeMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *InviteCodeMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *InviteCodeMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown InviteCode unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *InviteCodeMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown InviteCode edge %s", name)
}

// LicenseMutation represents an operation that mutates the License nodes in the graph.
type LicenseMutation struct {
	config
	op            Op
	typ           string
	id            *int
	_type         *consts.LicenseType
	data          *[]byte
	code          *string
	created_at    *time.Time
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*License, error)
	predicates    []predicate.License
}

var _ ent.Mutation = (*LicenseMutation)(nil)

// licenseOption allows management of the mutation configuration using functional options.
type licenseOption func(*LicenseMutation)

// newLicenseMutation creates new mutation for the License entity.
func newLicenseMutation(c config, op Op, opts ...licenseOption) *LicenseMutation {
	m := &LicenseMutation{
		config:        c,
		op:            op,
		typ:           TypeLicense,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withLicenseID sets the ID field of the mutation.
func withLicenseID(id int) licenseOption {
	return func(m *LicenseMutation) {
		var (
			err   error
			once  sync.Once
			value *License
		)
		m.oldValue = func(ctx context.Context) (*License, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().License.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withLicense sets the old License of the mutation.
func withLicense(node *License) licenseOption {
	return func(m *LicenseMutation) {
		m.oldValue = func(context.Context) (*License, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m LicenseMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m LicenseMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of License entities.
func (m *LicenseMutation) SetID(id int) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *LicenseMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *LicenseMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().License.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetType sets the "type" field.
func (m *LicenseMutation) SetType(ct consts.LicenseType) {
	m._type = &ct
}

// GetType returns the value of the "type" field in the mutation.
func (m *LicenseMutation) GetType() (r consts.LicenseType, exists bool) {
	v := m._type
	if v == nil {
		return
	}
	return *v, true
}

// OldType returns the old "type" field's value of the License entity.
// If the License object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *LicenseMutation) OldType(ctx context.Context) (v consts.LicenseType, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldType is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldType requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldType: %w", err)
	}
	return oldValue.Type, nil
}

// ResetType resets all changes to the "type" field.
func (m *LicenseMutation) ResetType() {
	m._type = nil
}

// SetData sets the "data" field.
func (m *LicenseMutation) SetData(b []byte) {
	m.data = &b
}

// Data returns the value of the "data" field in the mutation.
func (m *LicenseMutation) Data() (r []byte, exists bool) {
	v := m.data
	if v == nil {
		return
	}
	return *v, true
}

// OldData returns the old "data" field's value of the License entity.
// If the License object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *LicenseMutation) OldData(ctx context.Context) (v []byte, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldData is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldData requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldData: %w", err)
	}
	return oldValue.Data, nil
}

// ClearData clears the value of the "data" field.
func (m *LicenseMutation) ClearData() {
	m.data = nil
	m.clearedFields[license.FieldData] = struct{}{}
}

// DataCleared returns if the "data" field was cleared in this mutation.
func (m *LicenseMutation) DataCleared() bool {
	_, ok := m.clearedFields[license.FieldData]
	return ok
}

// ResetData resets all changes to the "data" field.
func (m *LicenseMutation) ResetData() {
	m.data = nil
	delete(m.clearedFields, license.FieldData)
}

// SetCode sets the "code" field.
func (m *LicenseMutation) SetCode(s string) {
	m.code = &s
}

// Code returns the value of the "code" field in the mutation.
func (m *LicenseMutation) Code() (r string, exists bool) {
	v := m.code
	if v == nil {
		return
	}
	return *v, true
}

// OldCode returns the old "code" field's value of the License entity.
// If the License object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *LicenseMutation) OldCode(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCode is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCode requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCode: %w", err)
	}
	return oldValue.Code, nil
}

// ClearCode clears the value of the "code" field.
func (m *LicenseMutation) ClearCode() {
	m.code = nil
	m.clearedFields[license.FieldCode] = struct{}{}
}

// CodeCleared returns if the "code" field was cleared in this mutation.
func (m *LicenseMutation) CodeCleared() bool {
	_, ok := m.clearedFields[license.FieldCode]
	return ok
}

// ResetCode resets all changes to the "code" field.
func (m *LicenseMutation) ResetCode() {
	m.code = nil
	delete(m.clearedFields, license.FieldCode)
}

// SetCreatedAt sets the "created_at" field.
func (m *LicenseMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *LicenseMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the License entity.
// If the License object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *LicenseMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *LicenseMutation) ResetCreatedAt() {
	m.created_at = nil
}

// Where appends a list predicates to the LicenseMutation builder.
func (m *LicenseMutation) Where(ps ...predicate.License) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the LicenseMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *LicenseMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.License, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *LicenseMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *LicenseMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (License).
func (m *LicenseMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *LicenseMutation) Fields() []string {
	fields := make([]string, 0, 4)
	if m._type != nil {
		fields = append(fields, license.FieldType)
	}
	if m.data != nil {
		fields = append(fields, license.FieldData)
	}
	if m.code != nil {
		fields = append(fields, license.FieldCode)
	}
	if m.created_at != nil {
		fields = append(fields, license.FieldCreatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *LicenseMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case license.FieldType:
		return m.GetType()
	case license.FieldData:
		return m.Data()
	case license.FieldCode:
		return m.Code()
	case license.FieldCreatedAt:
		return m.CreatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *LicenseMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case license.FieldType:
		return m.OldType(ctx)
	case license.FieldData:
		return m.OldData(ctx)
	case license.FieldCode:
		return m.OldCode(ctx)
	case license.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown License field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *LicenseMutation) SetField(name string, value ent.Value) error {
	switch name {
	case license.FieldType:
		v, ok := value.(consts.LicenseType)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetType(v)
		return nil
	case license.FieldData:
		v, ok := value.([]byte)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetData(v)
		return nil
	case license.FieldCode:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCode(v)
		return nil
	case license.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown License field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *LicenseMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *LicenseMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *LicenseMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown License numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *LicenseMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(license.FieldData) {
		fields = append(fields, license.FieldData)
	}
	if m.FieldCleared(license.FieldCode) {
		fields = append(fields, license.FieldCode)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *LicenseMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *LicenseMutation) ClearField(name string) error {
	switch name {
	case license.FieldData:
		m.ClearData()
		return nil
	case license.FieldCode:
		m.ClearCode()
		return nil
	}
	return fmt.Errorf("unknown License nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *LicenseMutation) ResetField(name string) error {
	switch name {
	case license.FieldType:
		m.ResetType()
		return nil
	case license.FieldData:
		m.ResetData()
		return nil
	case license.FieldCode:
		m.ResetCode()
		return nil
	case license.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	}
	return fmt.Errorf("unknown License field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *LicenseMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *LicenseMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *LicenseMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *LicenseMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *LicenseMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *LicenseMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *LicenseMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown License unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *LicenseMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown License edge %s", name)
}

// ModelMutation represents an operation that mutates the Model nodes in the graph.
type ModelMutation struct {
	config
	op                Op
	typ               string
	id                *uuid.UUID
	model_name        *string
	model_type        *consts.ModelType
	show_name         *string
	api_base          *string
	api_key           *string
	api_version       *string
	api_header        *string
	description       *string
	is_internal       *bool
	provider          *consts.ModelProvider
	status            *consts.ModelStatus
	parameters        **types.ModelParam
	context_length    *int
	addcontext_length *int
	created_at        *time.Time
	updated_at        *time.Time
	clearedFields     map[string]struct{}
	tasks             map[uuid.UUID]struct{}
	removedtasks      map[uuid.UUID]struct{}
	clearedtasks      bool
	user              *uuid.UUID
	cleareduser       bool
	done              bool
	oldValue          func(context.Context) (*Model, error)
	predicates        []predicate.Model
}

var _ ent.Mutation = (*ModelMutation)(nil)

// modelOption allows management of the mutation configuration using functional options.
type modelOption func(*ModelMutation)

// newModelMutation creates new mutation for the Model entity.
func newModelMutation(c config, op Op, opts ...modelOption) *ModelMutation {
	m := &ModelMutation{
		config:        c,
		op:            op,
		typ:           TypeModel,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withModelID sets the ID field of the mutation.
func withModelID(id uuid.UUID) modelOption {
	return func(m *ModelMutation) {
		var (
			err   error
			once  sync.Once
			value *Model
		)
		m.oldValue = func(ctx context.Context) (*Model, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Model.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withModel sets the old Model of the mutation.
func withModel(node *Model) modelOption {
	return func(m *ModelMutation) {
		m.oldValue = func(context.Context) (*Model, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m ModelMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m ModelMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Model entities.
func (m *ModelMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *ModelMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *ModelMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Model.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetUserID sets the "user_id" field.
func (m *ModelMutation) SetUserID(u uuid.UUID) {
	m.user = &u
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *ModelMutation) UserID() (r uuid.UUID, exists bool) {
	v := m.user
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldUserID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ClearUserID clears the value of the "user_id" field.
func (m *ModelMutation) ClearUserID() {
	m.user = nil
	m.clearedFields[model.FieldUserID] = struct{}{}
}

// UserIDCleared returns if the "user_id" field was cleared in this mutation.
func (m *ModelMutation) UserIDCleared() bool {
	_, ok := m.clearedFields[model.FieldUserID]
	return ok
}

// ResetUserID resets all changes to the "user_id" field.
func (m *ModelMutation) ResetUserID() {
	m.user = nil
	delete(m.clearedFields, model.FieldUserID)
}

// SetModelName sets the "model_name" field.
func (m *ModelMutation) SetModelName(s string) {
	m.model_name = &s
}

// ModelName returns the value of the "model_name" field in the mutation.
func (m *ModelMutation) ModelName() (r string, exists bool) {
	v := m.model_name
	if v == nil {
		return
	}
	return *v, true
}

// OldModelName returns the old "model_name" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldModelName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldModelName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldModelName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldModelName: %w", err)
	}
	return oldValue.ModelName, nil
}

// ResetModelName resets all changes to the "model_name" field.
func (m *ModelMutation) ResetModelName() {
	m.model_name = nil
}

// SetModelType sets the "model_type" field.
func (m *ModelMutation) SetModelType(ct consts.ModelType) {
	m.model_type = &ct
}

// ModelType returns the value of the "model_type" field in the mutation.
func (m *ModelMutation) ModelType() (r consts.ModelType, exists bool) {
	v := m.model_type
	if v == nil {
		return
	}
	return *v, true
}

// OldModelType returns the old "model_type" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldModelType(ctx context.Context) (v consts.ModelType, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldModelType is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldModelType requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldModelType: %w", err)
	}
	return oldValue.ModelType, nil
}

// ResetModelType resets all changes to the "model_type" field.
func (m *ModelMutation) ResetModelType() {
	m.model_type = nil
}

// SetShowName sets the "show_name" field.
func (m *ModelMutation) SetShowName(s string) {
	m.show_name = &s
}

// ShowName returns the value of the "show_name" field in the mutation.
func (m *ModelMutation) ShowName() (r string, exists bool) {
	v := m.show_name
	if v == nil {
		return
	}
	return *v, true
}

// OldShowName returns the old "show_name" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldShowName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldShowName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldShowName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldShowName: %w", err)
	}
	return oldValue.ShowName, nil
}

// ClearShowName clears the value of the "show_name" field.
func (m *ModelMutation) ClearShowName() {
	m.show_name = nil
	m.clearedFields[model.FieldShowName] = struct{}{}
}

// ShowNameCleared returns if the "show_name" field was cleared in this mutation.
func (m *ModelMutation) ShowNameCleared() bool {
	_, ok := m.clearedFields[model.FieldShowName]
	return ok
}

// ResetShowName resets all changes to the "show_name" field.
func (m *ModelMutation) ResetShowName() {
	m.show_name = nil
	delete(m.clearedFields, model.FieldShowName)
}

// SetAPIBase sets the "api_base" field.
func (m *ModelMutation) SetAPIBase(s string) {
	m.api_base = &s
}

// APIBase returns the value of the "api_base" field in the mutation.
func (m *ModelMutation) APIBase() (r string, exists bool) {
	v := m.api_base
	if v == nil {
		return
	}
	return *v, true
}

// OldAPIBase returns the old "api_base" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldAPIBase(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAPIBase is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAPIBase requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAPIBase: %w", err)
	}
	return oldValue.APIBase, nil
}

// ResetAPIBase resets all changes to the "api_base" field.
func (m *ModelMutation) ResetAPIBase() {
	m.api_base = nil
}

// SetAPIKey sets the "api_key" field.
func (m *ModelMutation) SetAPIKey(s string) {
	m.api_key = &s
}

// APIKey returns the value of the "api_key" field in the mutation.
func (m *ModelMutation) APIKey() (r string, exists bool) {
	v := m.api_key
	if v == nil {
		return
	}
	return *v, true
}

// OldAPIKey returns the old "api_key" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldAPIKey(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAPIKey is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAPIKey requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAPIKey: %w", err)
	}
	return oldValue.APIKey, nil
}

// ClearAPIKey clears the value of the "api_key" field.
func (m *ModelMutation) ClearAPIKey() {
	m.api_key = nil
	m.clearedFields[model.FieldAPIKey] = struct{}{}
}

// APIKeyCleared returns if the "api_key" field was cleared in this mutation.
func (m *ModelMutation) APIKeyCleared() bool {
	_, ok := m.clearedFields[model.FieldAPIKey]
	return ok
}

// ResetAPIKey resets all changes to the "api_key" field.
func (m *ModelMutation) ResetAPIKey() {
	m.api_key = nil
	delete(m.clearedFields, model.FieldAPIKey)
}

// SetAPIVersion sets the "api_version" field.
func (m *ModelMutation) SetAPIVersion(s string) {
	m.api_version = &s
}

// APIVersion returns the value of the "api_version" field in the mutation.
func (m *ModelMutation) APIVersion() (r string, exists bool) {
	v := m.api_version
	if v == nil {
		return
	}
	return *v, true
}

// OldAPIVersion returns the old "api_version" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldAPIVersion(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAPIVersion is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAPIVersion requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAPIVersion: %w", err)
	}
	return oldValue.APIVersion, nil
}

// ClearAPIVersion clears the value of the "api_version" field.
func (m *ModelMutation) ClearAPIVersion() {
	m.api_version = nil
	m.clearedFields[model.FieldAPIVersion] = struct{}{}
}

// APIVersionCleared returns if the "api_version" field was cleared in this mutation.
func (m *ModelMutation) APIVersionCleared() bool {
	_, ok := m.clearedFields[model.FieldAPIVersion]
	return ok
}

// ResetAPIVersion resets all changes to the "api_version" field.
func (m *ModelMutation) ResetAPIVersion() {
	m.api_version = nil
	delete(m.clearedFields, model.FieldAPIVersion)
}

// SetAPIHeader sets the "api_header" field.
func (m *ModelMutation) SetAPIHeader(s string) {
	m.api_header = &s
}

// APIHeader returns the value of the "api_header" field in the mutation.
func (m *ModelMutation) APIHeader() (r string, exists bool) {
	v := m.api_header
	if v == nil {
		return
	}
	return *v, true
}

// OldAPIHeader returns the old "api_header" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldAPIHeader(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAPIHeader is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAPIHeader requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAPIHeader: %w", err)
	}
	return oldValue.APIHeader, nil
}

// ClearAPIHeader clears the value of the "api_header" field.
func (m *ModelMutation) ClearAPIHeader() {
	m.api_header = nil
	m.clearedFields[model.FieldAPIHeader] = struct{}{}
}

// APIHeaderCleared returns if the "api_header" field was cleared in this mutation.
func (m *ModelMutation) APIHeaderCleared() bool {
	_, ok := m.clearedFields[model.FieldAPIHeader]
	return ok
}

// ResetAPIHeader resets all changes to the "api_header" field.
func (m *ModelMutation) ResetAPIHeader() {
	m.api_header = nil
	delete(m.clearedFields, model.FieldAPIHeader)
}

// SetDescription sets the "description" field.
func (m *ModelMutation) SetDescription(s string) {
	m.description = &s
}

// Description returns the value of the "description" field in the mutation.
func (m *ModelMutation) Description() (r string, exists bool) {
	v := m.description
	if v == nil {
		return
	}
	return *v, true
}

// OldDescription returns the old "description" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldDescription(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDescription is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDescription requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDescription: %w", err)
	}
	return oldValue.Description, nil
}

// ClearDescription clears the value of the "description" field.
func (m *ModelMutation) ClearDescription() {
	m.description = nil
	m.clearedFields[model.FieldDescription] = struct{}{}
}

// DescriptionCleared returns if the "description" field was cleared in this mutation.
func (m *ModelMutation) DescriptionCleared() bool {
	_, ok := m.clearedFields[model.FieldDescription]
	return ok
}

// ResetDescription resets all changes to the "description" field.
func (m *ModelMutation) ResetDescription() {
	m.description = nil
	delete(m.clearedFields, model.FieldDescription)
}

// SetIsInternal sets the "is_internal" field.
func (m *ModelMutation) SetIsInternal(b bool) {
	m.is_internal = &b
}

// IsInternal returns the value of the "is_internal" field in the mutation.
func (m *ModelMutation) IsInternal() (r bool, exists bool) {
	v := m.is_internal
	if v == nil {
		return
	}
	return *v, true
}

// OldIsInternal returns the old "is_internal" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldIsInternal(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldIsInternal is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldIsInternal requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldIsInternal: %w", err)
	}
	return oldValue.IsInternal, nil
}

// ResetIsInternal resets all changes to the "is_internal" field.
func (m *ModelMutation) ResetIsInternal() {
	m.is_internal = nil
}

// SetProvider sets the "provider" field.
func (m *ModelMutation) SetProvider(cp consts.ModelProvider) {
	m.provider = &cp
}

// Provider returns the value of the "provider" field in the mutation.
func (m *ModelMutation) Provider() (r consts.ModelProvider, exists bool) {
	v := m.provider
	if v == nil {
		return
	}
	return *v, true
}

// OldProvider returns the old "provider" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldProvider(ctx context.Context) (v consts.ModelProvider, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldProvider is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldProvider requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldProvider: %w", err)
	}
	return oldValue.Provider, nil
}

// ResetProvider resets all changes to the "provider" field.
func (m *ModelMutation) ResetProvider() {
	m.provider = nil
}

// SetStatus sets the "status" field.
func (m *ModelMutation) SetStatus(cs consts.ModelStatus) {
	m.status = &cs
}

// Status returns the value of the "status" field in the mutation.
func (m *ModelMutation) Status() (r consts.ModelStatus, exists bool) {
	v := m.status
	if v == nil {
		return
	}
	return *v, true
}

// OldStatus returns the old "status" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldStatus(ctx context.Context) (v consts.ModelStatus, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStatus is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStatus requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStatus: %w", err)
	}
	return oldValue.Status, nil
}

// ResetStatus resets all changes to the "status" field.
func (m *ModelMutation) ResetStatus() {
	m.status = nil
}

// SetParameters sets the "parameters" field.
func (m *ModelMutation) SetParameters(tp *types.ModelParam) {
	m.parameters = &tp
}

// Parameters returns the value of the "parameters" field in the mutation.
func (m *ModelMutation) Parameters() (r *types.ModelParam, exists bool) {
	v := m.parameters
	if v == nil {
		return
	}
	return *v, true
}

// OldParameters returns the old "parameters" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldParameters(ctx context.Context) (v *types.ModelParam, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldParameters is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldParameters requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldParameters: %w", err)
	}
	return oldValue.Parameters, nil
}

// ClearParameters clears the value of the "parameters" field.
func (m *ModelMutation) ClearParameters() {
	m.parameters = nil
	m.clearedFields[model.FieldParameters] = struct{}{}
}

// ParametersCleared returns if the "parameters" field was cleared in this mutation.
func (m *ModelMutation) ParametersCleared() bool {
	_, ok := m.clearedFields[model.FieldParameters]
	return ok
}

// ResetParameters resets all changes to the "parameters" field.
func (m *ModelMutation) ResetParameters() {
	m.parameters = nil
	delete(m.clearedFields, model.FieldParameters)
}

// SetContextLength sets the "context_length" field.
func (m *ModelMutation) SetContextLength(i int) {
	m.context_length = &i
	m.addcontext_length = nil
}

// ContextLength returns the value of the "context_length" field in the mutation.
func (m *ModelMutation) ContextLength() (r int, exists bool) {
	v := m.context_length
	if v == nil {
		return
	}
	return *v, true
}

// OldContextLength returns the old "context_length" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldContextLength(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldContextLength is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldContextLength requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldContextLength: %w", err)
	}
	return oldValue.ContextLength, nil
}

// AddContextLength adds i to the "context_length" field.
func (m *ModelMutation) AddContextLength(i int) {
	if m.addcontext_length != nil {
		*m.addcontext_length += i
	} else {
		m.addcontext_length = &i
	}
}

// AddedContextLength returns the value that was added to the "context_length" field in this mutation.
func (m *ModelMutation) AddedContextLength() (r int, exists bool) {
	v := m.addcontext_length
	if v == nil {
		return
	}
	return *v, true
}

// ClearContextLength clears the value of the "context_length" field.
func (m *ModelMutation) ClearContextLength() {
	m.context_length = nil
	m.addcontext_length = nil
	m.clearedFields[model.FieldContextLength] = struct{}{}
}

// ContextLengthCleared returns if the "context_length" field was cleared in this mutation.
func (m *ModelMutation) ContextLengthCleared() bool {
	_, ok := m.clearedFields[model.FieldContextLength]
	return ok
}

// ResetContextLength resets all changes to the "context_length" field.
func (m *ModelMutation) ResetContextLength() {
	m.context_length = nil
	m.addcontext_length = nil
	delete(m.clearedFields, model.FieldContextLength)
}

// SetCreatedAt sets the "created_at" field.
func (m *ModelMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *ModelMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *ModelMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *ModelMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *ModelMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Model entity.
// If the Model object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *ModelMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// AddTaskIDs adds the "tasks" edge to the Task entity by ids.
func (m *ModelMutation) AddTaskIDs(ids ...uuid.UUID) {
	if m.tasks == nil {
		m.tasks = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.tasks[ids[i]] = struct{}{}
	}
}

// ClearTasks clears the "tasks" edge to the Task entity.
func (m *ModelMutation) ClearTasks() {
	m.clearedtasks = true
}

// TasksCleared reports if the "tasks" edge to the Task entity was cleared.
func (m *ModelMutation) TasksCleared() bool {
	return m.clearedtasks
}

// RemoveTaskIDs removes the "tasks" edge to the Task entity by IDs.
func (m *ModelMutation) RemoveTaskIDs(ids ...uuid.UUID) {
	if m.removedtasks == nil {
		m.removedtasks = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.tasks, ids[i])
		m.removedtasks[ids[i]] = struct{}{}
	}
}

// RemovedTasks returns the removed IDs of the "tasks" edge to the Task entity.
func (m *ModelMutation) RemovedTasksIDs() (ids []uuid.UUID) {
	for id := range m.removedtasks {
		ids = append(ids, id)
	}
	return
}

// TasksIDs returns the "tasks" edge IDs in the mutation.
func (m *ModelMutation) TasksIDs() (ids []uuid.UUID) {
	for id := range m.tasks {
		ids = append(ids, id)
	}
	return
}

// ResetTasks resets all changes to the "tasks" edge.
func (m *ModelMutation) ResetTasks() {
	m.tasks = nil
	m.clearedtasks = false
	m.removedtasks = nil
}

// ClearUser clears the "user" edge to the User entity.
func (m *ModelMutation) ClearUser() {
	m.cleareduser = true
	m.clearedFields[model.FieldUserID] = struct{}{}
}

// UserCleared reports if the "user" edge to the User entity was cleared.
func (m *ModelMutation) UserCleared() bool {
	return m.UserIDCleared() || m.cleareduser
}

// UserIDs returns the "user" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserID instead. It exists only for internal usage by the builders.
func (m *ModelMutation) UserIDs() (ids []uuid.UUID) {
	if id := m.user; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUser resets all changes to the "user" edge.
func (m *ModelMutation) ResetUser() {
	m.user = nil
	m.cleareduser = false
}

// Where appends a list predicates to the ModelMutation builder.
func (m *ModelMutation) Where(ps ...predicate.Model) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the ModelMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *ModelMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Model, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *ModelMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *ModelMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Model).
func (m *ModelMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *ModelMutation) Fields() []string {
	fields := make([]string, 0, 16)
	if m.user != nil {
		fields = append(fields, model.FieldUserID)
	}
	if m.model_name != nil {
		fields = append(fields, model.FieldModelName)
	}
	if m.model_type != nil {
		fields = append(fields, model.FieldModelType)
	}
	if m.show_name != nil {
		fields = append(fields, model.FieldShowName)
	}
	if m.api_base != nil {
		fields = append(fields, model.FieldAPIBase)
	}
	if m.api_key != nil {
		fields = append(fields, model.FieldAPIKey)
	}
	if m.api_version != nil {
		fields = append(fields, model.FieldAPIVersion)
	}
	if m.api_header != nil {
		fields = append(fields, model.FieldAPIHeader)
	}
	if m.description != nil {
		fields = append(fields, model.FieldDescription)
	}
	if m.is_internal != nil {
		fields = append(fields, model.FieldIsInternal)
	}
	if m.provider != nil {
		fields = append(fields, model.FieldProvider)
	}
	if m.status != nil {
		fields = append(fields, model.FieldStatus)
	}
	if m.parameters != nil {
		fields = append(fields, model.FieldParameters)
	}
	if m.context_length != nil {
		fields = append(fields, model.FieldContextLength)
	}
	if m.created_at != nil {
		fields = append(fields, model.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, model.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *ModelMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case model.FieldUserID:
		return m.UserID()
	case model.FieldModelName:
		return m.ModelName()
	case model.FieldModelType:
		return m.ModelType()
	case model.FieldShowName:
		return m.ShowName()
	case model.FieldAPIBase:
		return m.APIBase()
	case model.FieldAPIKey:
		return m.APIKey()
	case model.FieldAPIVersion:
		return m.APIVersion()
	case model.FieldAPIHeader:
		return m.APIHeader()
	case model.FieldDescription:
		return m.Description()
	case model.FieldIsInternal:
		return m.IsInternal()
	case model.FieldProvider:
		return m.Provider()
	case model.FieldStatus:
		return m.Status()
	case model.FieldParameters:
		return m.Parameters()
	case model.FieldContextLength:
		return m.ContextLength()
	case model.FieldCreatedAt:
		return m.CreatedAt()
	case model.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *ModelMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case model.FieldUserID:
		return m.OldUserID(ctx)
	case model.FieldModelName:
		return m.OldModelName(ctx)
	case model.FieldModelType:
		return m.OldModelType(ctx)
	case model.FieldShowName:
		return m.OldShowName(ctx)
	case model.FieldAPIBase:
		return m.OldAPIBase(ctx)
	case model.FieldAPIKey:
		return m.OldAPIKey(ctx)
	case model.FieldAPIVersion:
		return m.OldAPIVersion(ctx)
	case model.FieldAPIHeader:
		return m.OldAPIHeader(ctx)
	case model.FieldDescription:
		return m.OldDescription(ctx)
	case model.FieldIsInternal:
		return m.OldIsInternal(ctx)
	case model.FieldProvider:
		return m.OldProvider(ctx)
	case model.FieldStatus:
		return m.OldStatus(ctx)
	case model.FieldParameters:
		return m.OldParameters(ctx)
	case model.FieldContextLength:
		return m.OldContextLength(ctx)
	case model.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case model.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Model field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ModelMutation) SetField(name string, value ent.Value) error {
	switch name {
	case model.FieldUserID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case model.FieldModelName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetModelName(v)
		return nil
	case model.FieldModelType:
		v, ok := value.(consts.ModelType)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetModelType(v)
		return nil
	case model.FieldShowName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetShowName(v)
		return nil
	case model.FieldAPIBase:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAPIBase(v)
		return nil
	case model.FieldAPIKey:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAPIKey(v)
		return nil
	case model.FieldAPIVersion:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAPIVersion(v)
		return nil
	case model.FieldAPIHeader:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAPIHeader(v)
		return nil
	case model.FieldDescription:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDescription(v)
		return nil
	case model.FieldIsInternal:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetIsInternal(v)
		return nil
	case model.FieldProvider:
		v, ok := value.(consts.ModelProvider)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetProvider(v)
		return nil
	case model.FieldStatus:
		v, ok := value.(consts.ModelStatus)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStatus(v)
		return nil
	case model.FieldParameters:
		v, ok := value.(*types.ModelParam)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetParameters(v)
		return nil
	case model.FieldContextLength:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetContextLength(v)
		return nil
	case model.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case model.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Model field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *ModelMutation) AddedFields() []string {
	var fields []string
	if m.addcontext_length != nil {
		fields = append(fields, model.FieldContextLength)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *ModelMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case model.FieldContextLength:
		return m.AddedContextLength()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ModelMutation) AddField(name string, value ent.Value) error {
	switch name {
	case model.FieldContextLength:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddContextLength(v)
		return nil
	}
	return fmt.Errorf("unknown Model numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *ModelMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(model.FieldUserID) {
		fields = append(fields, model.FieldUserID)
	}
	if m.FieldCleared(model.FieldShowName) {
		fields = append(fields, model.FieldShowName)
	}
	if m.FieldCleared(model.FieldAPIKey) {
		fields = append(fields, model.FieldAPIKey)
	}
	if m.FieldCleared(model.FieldAPIVersion) {
		fields = append(fields, model.FieldAPIVersion)
	}
	if m.FieldCleared(model.FieldAPIHeader) {
		fields = append(fields, model.FieldAPIHeader)
	}
	if m.FieldCleared(model.FieldDescription) {
		fields = append(fields, model.FieldDescription)
	}
	if m.FieldCleared(model.FieldParameters) {
		fields = append(fields, model.FieldParameters)
	}
	if m.FieldCleared(model.FieldContextLength) {
		fields = append(fields, model.FieldContextLength)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *ModelMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *ModelMutation) ClearField(name string) error {
	switch name {
	case model.FieldUserID:
		m.ClearUserID()
		return nil
	case model.FieldShowName:
		m.ClearShowName()
		return nil
	case model.FieldAPIKey:
		m.ClearAPIKey()
		return nil
	case model.FieldAPIVersion:
		m.ClearAPIVersion()
		return nil
	case model.FieldAPIHeader:
		m.ClearAPIHeader()
		return nil
	case model.FieldDescription:
		m.ClearDescription()
		return nil
	case model.FieldParameters:
		m.ClearParameters()
		return nil
	case model.FieldContextLength:
		m.ClearContextLength()
		return nil
	}
	return fmt.Errorf("unknown Model nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *ModelMutation) ResetField(name string) error {
	switch name {
	case model.FieldUserID:
		m.ResetUserID()
		return nil
	case model.FieldModelName:
		m.ResetModelName()
		return nil
	case model.FieldModelType:
		m.ResetModelType()
		return nil
	case model.FieldShowName:
		m.ResetShowName()
		return nil
	case model.FieldAPIBase:
		m.ResetAPIBase()
		return nil
	case model.FieldAPIKey:
		m.ResetAPIKey()
		return nil
	case model.FieldAPIVersion:
		m.ResetAPIVersion()
		return nil
	case model.FieldAPIHeader:
		m.ResetAPIHeader()
		return nil
	case model.FieldDescription:
		m.ResetDescription()
		return nil
	case model.FieldIsInternal:
		m.ResetIsInternal()
		return nil
	case model.FieldProvider:
		m.ResetProvider()
		return nil
	case model.FieldStatus:
		m.ResetStatus()
		return nil
	case model.FieldParameters:
		m.ResetParameters()
		return nil
	case model.FieldContextLength:
		m.ResetContextLength()
		return nil
	case model.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case model.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown Model field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *ModelMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.tasks != nil {
		edges = append(edges, model.EdgeTasks)
	}
	if m.user != nil {
		edges = append(edges, model.EdgeUser)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *ModelMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case model.EdgeTasks:
		ids := make([]ent.Value, 0, len(m.tasks))
		for id := range m.tasks {
			ids = append(ids, id)
		}
		return ids
	case model.EdgeUser:
		if id := m.user; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *ModelMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	if m.removedtasks != nil {
		edges = append(edges, model.EdgeTasks)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *ModelMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case model.EdgeTasks:
		ids := make([]ent.Value, 0, len(m.removedtasks))
		for id := range m.removedtasks {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *ModelMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedtasks {
		edges = append(edges, model.EdgeTasks)
	}
	if m.cleareduser {
		edges = append(edges, model.EdgeUser)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *ModelMutation) EdgeCleared(name string) bool {
	switch name {
	case model.EdgeTasks:
		return m.clearedtasks
	case model.EdgeUser:
		return m.cleareduser
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *ModelMutation) ClearEdge(name string) error {
	switch name {
	case model.EdgeUser:
		m.ClearUser()
		return nil
	}
	return fmt.Errorf("unknown Model unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *ModelMutation) ResetEdge(name string) error {
	switch name {
	case model.EdgeTasks:
		m.ResetTasks()
		return nil
	case model.EdgeUser:
		m.ResetUser()
		return nil
	}
	return fmt.Errorf("unknown Model edge %s", name)
}

// ModelProviderMutation represents an operation that mutates the ModelProvider nodes in the graph.
type ModelProviderMutation struct {
	config
	op            Op
	typ           string
	id            *string
	name          *string
	api_base      *string
	priority      *int
	addpriority   *int
	created_at    *time.Time
	updated_at    *time.Time
	clearedFields map[string]struct{}
	models        map[uuid.UUID]struct{}
	removedmodels map[uuid.UUID]struct{}
	clearedmodels bool
	done          bool
	oldValue      func(context.Context) (*ModelProvider, error)
	predicates    []predicate.ModelProvider
}

var _ ent.Mutation = (*ModelProviderMutation)(nil)

// modelproviderOption allows management of the mutation configuration using functional options.
type modelproviderOption func(*ModelProviderMutation)

// newModelProviderMutation creates new mutation for the ModelProvider entity.
func newModelProviderMutation(c config, op Op, opts ...modelproviderOption) *ModelProviderMutation {
	m := &ModelProviderMutation{
		config:        c,
		op:            op,
		typ:           TypeModelProvider,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withModelProviderID sets the ID field of the mutation.
func withModelProviderID(id string) modelproviderOption {
	return func(m *ModelProviderMutation) {
		var (
			err   error
			once  sync.Once
			value *ModelProvider
		)
		m.oldValue = func(ctx context.Context) (*ModelProvider, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().ModelProvider.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withModelProvider sets the old ModelProvider of the mutation.
func withModelProvider(node *ModelProvider) modelproviderOption {
	return func(m *ModelProviderMutation) {
		m.oldValue = func(context.Context) (*ModelProvider, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m ModelProviderMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m ModelProviderMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of ModelProvider entities.
func (m *ModelProviderMutation) SetID(id string) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *ModelProviderMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *ModelProviderMutation) IDs(ctx context.Context) ([]string, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []string{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().ModelProvider.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetName sets the "name" field.
func (m *ModelProviderMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *ModelProviderMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the ModelProvider entity.
// If the ModelProvider object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelProviderMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *ModelProviderMutation) ResetName() {
	m.name = nil
}

// SetAPIBase sets the "api_base" field.
func (m *ModelProviderMutation) SetAPIBase(s string) {
	m.api_base = &s
}

// APIBase returns the value of the "api_base" field in the mutation.
func (m *ModelProviderMutation) APIBase() (r string, exists bool) {
	v := m.api_base
	if v == nil {
		return
	}
	return *v, true
}

// OldAPIBase returns the old "api_base" field's value of the ModelProvider entity.
// If the ModelProvider object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelProviderMutation) OldAPIBase(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAPIBase is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAPIBase requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAPIBase: %w", err)
	}
	return oldValue.APIBase, nil
}

// ResetAPIBase resets all changes to the "api_base" field.
func (m *ModelProviderMutation) ResetAPIBase() {
	m.api_base = nil
}

// SetPriority sets the "priority" field.
func (m *ModelProviderMutation) SetPriority(i int) {
	m.priority = &i
	m.addpriority = nil
}

// Priority returns the value of the "priority" field in the mutation.
func (m *ModelProviderMutation) Priority() (r int, exists bool) {
	v := m.priority
	if v == nil {
		return
	}
	return *v, true
}

// OldPriority returns the old "priority" field's value of the ModelProvider entity.
// If the ModelProvider object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelProviderMutation) OldPriority(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPriority is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPriority requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPriority: %w", err)
	}
	return oldValue.Priority, nil
}

// AddPriority adds i to the "priority" field.
func (m *ModelProviderMutation) AddPriority(i int) {
	if m.addpriority != nil {
		*m.addpriority += i
	} else {
		m.addpriority = &i
	}
}

// AddedPriority returns the value that was added to the "priority" field in this mutation.
func (m *ModelProviderMutation) AddedPriority() (r int, exists bool) {
	v := m.addpriority
	if v == nil {
		return
	}
	return *v, true
}

// ResetPriority resets all changes to the "priority" field.
func (m *ModelProviderMutation) ResetPriority() {
	m.priority = nil
	m.addpriority = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *ModelProviderMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *ModelProviderMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the ModelProvider entity.
// If the ModelProvider object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelProviderMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *ModelProviderMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *ModelProviderMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *ModelProviderMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the ModelProvider entity.
// If the ModelProvider object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelProviderMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *ModelProviderMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// AddModelIDs adds the "models" edge to the ModelProviderModel entity by ids.
func (m *ModelProviderMutation) AddModelIDs(ids ...uuid.UUID) {
	if m.models == nil {
		m.models = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.models[ids[i]] = struct{}{}
	}
}

// ClearModels clears the "models" edge to the ModelProviderModel entity.
func (m *ModelProviderMutation) ClearModels() {
	m.clearedmodels = true
}

// ModelsCleared reports if the "models" edge to the ModelProviderModel entity was cleared.
func (m *ModelProviderMutation) ModelsCleared() bool {
	return m.clearedmodels
}

// RemoveModelIDs removes the "models" edge to the ModelProviderModel entity by IDs.
func (m *ModelProviderMutation) RemoveModelIDs(ids ...uuid.UUID) {
	if m.removedmodels == nil {
		m.removedmodels = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.models, ids[i])
		m.removedmodels[ids[i]] = struct{}{}
	}
}

// RemovedModels returns the removed IDs of the "models" edge to the ModelProviderModel entity.
func (m *ModelProviderMutation) RemovedModelsIDs() (ids []uuid.UUID) {
	for id := range m.removedmodels {
		ids = append(ids, id)
	}
	return
}

// ModelsIDs returns the "models" edge IDs in the mutation.
func (m *ModelProviderMutation) ModelsIDs() (ids []uuid.UUID) {
	for id := range m.models {
		ids = append(ids, id)
	}
	return
}

// ResetModels resets all changes to the "models" edge.
func (m *ModelProviderMutation) ResetModels() {
	m.models = nil
	m.clearedmodels = false
	m.removedmodels = nil
}

// Where appends a list predicates to the ModelProviderMutation builder.
func (m *ModelProviderMutation) Where(ps ...predicate.ModelProvider) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the ModelProviderMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *ModelProviderMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.ModelProvider, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *ModelProviderMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *ModelProviderMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (ModelProvider).
func (m *ModelProviderMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *ModelProviderMutation) Fields() []string {
	fields := make([]string, 0, 5)
	if m.name != nil {
		fields = append(fields, modelprovider.FieldName)
	}
	if m.api_base != nil {
		fields = append(fields, modelprovider.FieldAPIBase)
	}
	if m.priority != nil {
		fields = append(fields, modelprovider.FieldPriority)
	}
	if m.created_at != nil {
		fields = append(fields, modelprovider.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, modelprovider.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *ModelProviderMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case modelprovider.FieldName:
		return m.Name()
	case modelprovider.FieldAPIBase:
		return m.APIBase()
	case modelprovider.FieldPriority:
		return m.Priority()
	case modelprovider.FieldCreatedAt:
		return m.CreatedAt()
	case modelprovider.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *ModelProviderMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case modelprovider.FieldName:
		return m.OldName(ctx)
	case modelprovider.FieldAPIBase:
		return m.OldAPIBase(ctx)
	case modelprovider.FieldPriority:
		return m.OldPriority(ctx)
	case modelprovider.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case modelprovider.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown ModelProvider field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ModelProviderMutation) SetField(name string, value ent.Value) error {
	switch name {
	case modelprovider.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case modelprovider.FieldAPIBase:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAPIBase(v)
		return nil
	case modelprovider.FieldPriority:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPriority(v)
		return nil
	case modelprovider.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case modelprovider.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown ModelProvider field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *ModelProviderMutation) AddedFields() []string {
	var fields []string
	if m.addpriority != nil {
		fields = append(fields, modelprovider.FieldPriority)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *ModelProviderMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case modelprovider.FieldPriority:
		return m.AddedPriority()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ModelProviderMutation) AddField(name string, value ent.Value) error {
	switch name {
	case modelprovider.FieldPriority:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddPriority(v)
		return nil
	}
	return fmt.Errorf("unknown ModelProvider numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *ModelProviderMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *ModelProviderMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *ModelProviderMutation) ClearField(name string) error {
	return fmt.Errorf("unknown ModelProvider nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *ModelProviderMutation) ResetField(name string) error {
	switch name {
	case modelprovider.FieldName:
		m.ResetName()
		return nil
	case modelprovider.FieldAPIBase:
		m.ResetAPIBase()
		return nil
	case modelprovider.FieldPriority:
		m.ResetPriority()
		return nil
	case modelprovider.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case modelprovider.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown ModelProvider field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *ModelProviderMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.models != nil {
		edges = append(edges, modelprovider.EdgeModels)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *ModelProviderMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case modelprovider.EdgeModels:
		ids := make([]ent.Value, 0, len(m.models))
		for id := range m.models {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *ModelProviderMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	if m.removedmodels != nil {
		edges = append(edges, modelprovider.EdgeModels)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *ModelProviderMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case modelprovider.EdgeModels:
		ids := make([]ent.Value, 0, len(m.removedmodels))
		for id := range m.removedmodels {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *ModelProviderMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedmodels {
		edges = append(edges, modelprovider.EdgeModels)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *ModelProviderMutation) EdgeCleared(name string) bool {
	switch name {
	case modelprovider.EdgeModels:
		return m.clearedmodels
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *ModelProviderMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown ModelProvider unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *ModelProviderMutation) ResetEdge(name string) error {
	switch name {
	case modelprovider.EdgeModels:
		m.ResetModels()
		return nil
	}
	return fmt.Errorf("unknown ModelProvider edge %s", name)
}

// ModelProviderModelMutation represents an operation that mutates the ModelProviderModel nodes in the graph.
type ModelProviderModelMutation struct {
	config
	op              Op
	typ             string
	id              *uuid.UUID
	name            *string
	created_at      *time.Time
	updated_at      *time.Time
	clearedFields   map[string]struct{}
	provider        *string
	clearedprovider bool
	done            bool
	oldValue        func(context.Context) (*ModelProviderModel, error)
	predicates      []predicate.ModelProviderModel
}

var _ ent.Mutation = (*ModelProviderModelMutation)(nil)

// modelprovidermodelOption allows management of the mutation configuration using functional options.
type modelprovidermodelOption func(*ModelProviderModelMutation)

// newModelProviderModelMutation creates new mutation for the ModelProviderModel entity.
func newModelProviderModelMutation(c config, op Op, opts ...modelprovidermodelOption) *ModelProviderModelMutation {
	m := &ModelProviderModelMutation{
		config:        c,
		op:            op,
		typ:           TypeModelProviderModel,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withModelProviderModelID sets the ID field of the mutation.
func withModelProviderModelID(id uuid.UUID) modelprovidermodelOption {
	return func(m *ModelProviderModelMutation) {
		var (
			err   error
			once  sync.Once
			value *ModelProviderModel
		)
		m.oldValue = func(ctx context.Context) (*ModelProviderModel, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().ModelProviderModel.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withModelProviderModel sets the old ModelProviderModel of the mutation.
func withModelProviderModel(node *ModelProviderModel) modelprovidermodelOption {
	return func(m *ModelProviderModelMutation) {
		m.oldValue = func(context.Context) (*ModelProviderModel, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m ModelProviderModelMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m ModelProviderModelMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of ModelProviderModel entities.
func (m *ModelProviderModelMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *ModelProviderModelMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *ModelProviderModelMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().ModelProviderModel.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetName sets the "name" field.
func (m *ModelProviderModelMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *ModelProviderModelMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the ModelProviderModel entity.
// If the ModelProviderModel object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelProviderModelMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *ModelProviderModelMutation) ResetName() {
	m.name = nil
}

// SetProviderID sets the "provider_id" field.
func (m *ModelProviderModelMutation) SetProviderID(s string) {
	m.provider = &s
}

// ProviderID returns the value of the "provider_id" field in the mutation.
func (m *ModelProviderModelMutation) ProviderID() (r string, exists bool) {
	v := m.provider
	if v == nil {
		return
	}
	return *v, true
}

// OldProviderID returns the old "provider_id" field's value of the ModelProviderModel entity.
// If the ModelProviderModel object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelProviderModelMutation) OldProviderID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldProviderID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldProviderID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldProviderID: %w", err)
	}
	return oldValue.ProviderID, nil
}

// ClearProviderID clears the value of the "provider_id" field.
func (m *ModelProviderModelMutation) ClearProviderID() {
	m.provider = nil
	m.clearedFields[modelprovidermodel.FieldProviderID] = struct{}{}
}

// ProviderIDCleared returns if the "provider_id" field was cleared in this mutation.
func (m *ModelProviderModelMutation) ProviderIDCleared() bool {
	_, ok := m.clearedFields[modelprovidermodel.FieldProviderID]
	return ok
}

// ResetProviderID resets all changes to the "provider_id" field.
func (m *ModelProviderModelMutation) ResetProviderID() {
	m.provider = nil
	delete(m.clearedFields, modelprovidermodel.FieldProviderID)
}

// SetCreatedAt sets the "created_at" field.
func (m *ModelProviderModelMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *ModelProviderModelMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the ModelProviderModel entity.
// If the ModelProviderModel object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelProviderModelMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *ModelProviderModelMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *ModelProviderModelMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *ModelProviderModelMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the ModelProviderModel entity.
// If the ModelProviderModel object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ModelProviderModelMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *ModelProviderModelMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// ClearProvider clears the "provider" edge to the ModelProvider entity.
func (m *ModelProviderModelMutation) ClearProvider() {
	m.clearedprovider = true
	m.clearedFields[modelprovidermodel.FieldProviderID] = struct{}{}
}

// ProviderCleared reports if the "provider" edge to the ModelProvider entity was cleared.
func (m *ModelProviderModelMutation) ProviderCleared() bool {
	return m.ProviderIDCleared() || m.clearedprovider
}

// ProviderIDs returns the "provider" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// ProviderID instead. It exists only for internal usage by the builders.
func (m *ModelProviderModelMutation) ProviderIDs() (ids []string) {
	if id := m.provider; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetProvider resets all changes to the "provider" edge.
func (m *ModelProviderModelMutation) ResetProvider() {
	m.provider = nil
	m.clearedprovider = false
}

// Where appends a list predicates to the ModelProviderModelMutation builder.
func (m *ModelProviderModelMutation) Where(ps ...predicate.ModelProviderModel) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the ModelProviderModelMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *ModelProviderModelMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.ModelProviderModel, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *ModelProviderModelMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *ModelProviderModelMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (ModelProviderModel).
func (m *ModelProviderModelMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *ModelProviderModelMutation) Fields() []string {
	fields := make([]string, 0, 4)
	if m.name != nil {
		fields = append(fields, modelprovidermodel.FieldName)
	}
	if m.provider != nil {
		fields = append(fields, modelprovidermodel.FieldProviderID)
	}
	if m.created_at != nil {
		fields = append(fields, modelprovidermodel.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, modelprovidermodel.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *ModelProviderModelMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case modelprovidermodel.FieldName:
		return m.Name()
	case modelprovidermodel.FieldProviderID:
		return m.ProviderID()
	case modelprovidermodel.FieldCreatedAt:
		return m.CreatedAt()
	case modelprovidermodel.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *ModelProviderModelMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case modelprovidermodel.FieldName:
		return m.OldName(ctx)
	case modelprovidermodel.FieldProviderID:
		return m.OldProviderID(ctx)
	case modelprovidermodel.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case modelprovidermodel.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown ModelProviderModel field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ModelProviderModelMutation) SetField(name string, value ent.Value) error {
	switch name {
	case modelprovidermodel.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case modelprovidermodel.FieldProviderID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetProviderID(v)
		return nil
	case modelprovidermodel.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case modelprovidermodel.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown ModelProviderModel field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *ModelProviderModelMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *ModelProviderModelMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ModelProviderModelMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown ModelProviderModel numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *ModelProviderModelMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(modelprovidermodel.FieldProviderID) {
		fields = append(fields, modelprovidermodel.FieldProviderID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *ModelProviderModelMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *ModelProviderModelMutation) ClearField(name string) error {
	switch name {
	case modelprovidermodel.FieldProviderID:
		m.ClearProviderID()
		return nil
	}
	return fmt.Errorf("unknown ModelProviderModel nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *ModelProviderModelMutation) ResetField(name string) error {
	switch name {
	case modelprovidermodel.FieldName:
		m.ResetName()
		return nil
	case modelprovidermodel.FieldProviderID:
		m.ResetProviderID()
		return nil
	case modelprovidermodel.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case modelprovidermodel.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown ModelProviderModel field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *ModelProviderModelMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.provider != nil {
		edges = append(edges, modelprovidermodel.EdgeProvider)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *ModelProviderModelMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case modelprovidermodel.EdgeProvider:
		if id := m.provider; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *ModelProviderModelMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *ModelProviderModelMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *ModelProviderModelMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedprovider {
		edges = append(edges, modelprovidermodel.EdgeProvider)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *ModelProviderModelMutation) EdgeCleared(name string) bool {
	switch name {
	case modelprovidermodel.EdgeProvider:
		return m.clearedprovider
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *ModelProviderModelMutation) ClearEdge(name string) error {
	switch name {
	case modelprovidermodel.EdgeProvider:
		m.ClearProvider()
		return nil
	}
	return fmt.Errorf("unknown ModelProviderModel unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *ModelProviderModelMutation) ResetEdge(name string) error {
	switch name {
	case modelprovidermodel.EdgeProvider:
		m.ResetProvider()
		return nil
	}
	return fmt.Errorf("unknown ModelProviderModel edge %s", name)
}

// RoleMutation represents an operation that mutates the Role nodes in the graph.
type RoleMutation struct {
	config
	op                 Op
	typ                string
	id                 *int64
	name               *string
	description        *string
	created_at         *time.Time
	clearedFields      map[string]struct{}
	admins             map[uuid.UUID]struct{}
	removedadmins      map[uuid.UUID]struct{}
	clearedadmins      bool
	admin_roles        map[uuid.UUID]struct{}
	removedadmin_roles map[uuid.UUID]struct{}
	clearedadmin_roles bool
	done               bool
	oldValue           func(context.Context) (*Role, error)
	predicates         []predicate.Role
}

var _ ent.Mutation = (*RoleMutation)(nil)

// roleOption allows management of the mutation configuration using functional options.
type roleOption func(*RoleMutation)

// newRoleMutation creates new mutation for the Role entity.
func newRoleMutation(c config, op Op, opts ...roleOption) *RoleMutation {
	m := &RoleMutation{
		config:        c,
		op:            op,
		typ:           TypeRole,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withRoleID sets the ID field of the mutation.
func withRoleID(id int64) roleOption {
	return func(m *RoleMutation) {
		var (
			err   error
			once  sync.Once
			value *Role
		)
		m.oldValue = func(ctx context.Context) (*Role, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Role.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withRole sets the old Role of the mutation.
func withRole(node *Role) roleOption {
	return func(m *RoleMutation) {
		m.oldValue = func(context.Context) (*Role, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m RoleMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m RoleMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Role entities.
func (m *RoleMutation) SetID(id int64) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *RoleMutation) ID() (id int64, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *RoleMutation) IDs(ctx context.Context) ([]int64, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int64{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Role.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetName sets the "name" field.
func (m *RoleMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *RoleMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the Role entity.
// If the Role object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RoleMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *RoleMutation) ResetName() {
	m.name = nil
}

// SetDescription sets the "description" field.
func (m *RoleMutation) SetDescription(s string) {
	m.description = &s
}

// Description returns the value of the "description" field in the mutation.
func (m *RoleMutation) Description() (r string, exists bool) {
	v := m.description
	if v == nil {
		return
	}
	return *v, true
}

// OldDescription returns the old "description" field's value of the Role entity.
// If the Role object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RoleMutation) OldDescription(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDescription is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDescription requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDescription: %w", err)
	}
	return oldValue.Description, nil
}

// ResetDescription resets all changes to the "description" field.
func (m *RoleMutation) ResetDescription() {
	m.description = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *RoleMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *RoleMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Role entity.
// If the Role object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RoleMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *RoleMutation) ResetCreatedAt() {
	m.created_at = nil
}

// AddAdminIDs adds the "admins" edge to the Admin entity by ids.
func (m *RoleMutation) AddAdminIDs(ids ...uuid.UUID) {
	if m.admins == nil {
		m.admins = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.admins[ids[i]] = struct{}{}
	}
}

// ClearAdmins clears the "admins" edge to the Admin entity.
func (m *RoleMutation) ClearAdmins() {
	m.clearedadmins = true
}

// AdminsCleared reports if the "admins" edge to the Admin entity was cleared.
func (m *RoleMutation) AdminsCleared() bool {
	return m.clearedadmins
}

// RemoveAdminIDs removes the "admins" edge to the Admin entity by IDs.
func (m *RoleMutation) RemoveAdminIDs(ids ...uuid.UUID) {
	if m.removedadmins == nil {
		m.removedadmins = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.admins, ids[i])
		m.removedadmins[ids[i]] = struct{}{}
	}
}

// RemovedAdmins returns the removed IDs of the "admins" edge to the Admin entity.
func (m *RoleMutation) RemovedAdminsIDs() (ids []uuid.UUID) {
	for id := range m.removedadmins {
		ids = append(ids, id)
	}
	return
}

// AdminsIDs returns the "admins" edge IDs in the mutation.
func (m *RoleMutation) AdminsIDs() (ids []uuid.UUID) {
	for id := range m.admins {
		ids = append(ids, id)
	}
	return
}

// ResetAdmins resets all changes to the "admins" edge.
func (m *RoleMutation) ResetAdmins() {
	m.admins = nil
	m.clearedadmins = false
	m.removedadmins = nil
}

// AddAdminRoleIDs adds the "admin_roles" edge to the AdminRole entity by ids.
func (m *RoleMutation) AddAdminRoleIDs(ids ...uuid.UUID) {
	if m.admin_roles == nil {
		m.admin_roles = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.admin_roles[ids[i]] = struct{}{}
	}
}

// ClearAdminRoles clears the "admin_roles" edge to the AdminRole entity.
func (m *RoleMutation) ClearAdminRoles() {
	m.clearedadmin_roles = true
}

// AdminRolesCleared reports if the "admin_roles" edge to the AdminRole entity was cleared.
func (m *RoleMutation) AdminRolesCleared() bool {
	return m.clearedadmin_roles
}

// RemoveAdminRoleIDs removes the "admin_roles" edge to the AdminRole entity by IDs.
func (m *RoleMutation) RemoveAdminRoleIDs(ids ...uuid.UUID) {
	if m.removedadmin_roles == nil {
		m.removedadmin_roles = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.admin_roles, ids[i])
		m.removedadmin_roles[ids[i]] = struct{}{}
	}
}

// RemovedAdminRoles returns the removed IDs of the "admin_roles" edge to the AdminRole entity.
func (m *RoleMutation) RemovedAdminRolesIDs() (ids []uuid.UUID) {
	for id := range m.removedadmin_roles {
		ids = append(ids, id)
	}
	return
}

// AdminRolesIDs returns the "admin_roles" edge IDs in the mutation.
func (m *RoleMutation) AdminRolesIDs() (ids []uuid.UUID) {
	for id := range m.admin_roles {
		ids = append(ids, id)
	}
	return
}

// ResetAdminRoles resets all changes to the "admin_roles" edge.
func (m *RoleMutation) ResetAdminRoles() {
	m.admin_roles = nil
	m.clearedadmin_roles = false
	m.removedadmin_roles = nil
}

// Where appends a list predicates to the RoleMutation builder.
func (m *RoleMutation) Where(ps ...predicate.Role) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the RoleMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *RoleMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Role, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *RoleMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *RoleMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Role).
func (m *RoleMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *RoleMutation) Fields() []string {
	fields := make([]string, 0, 3)
	if m.name != nil {
		fields = append(fields, role.FieldName)
	}
	if m.description != nil {
		fields = append(fields, role.FieldDescription)
	}
	if m.created_at != nil {
		fields = append(fields, role.FieldCreatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *RoleMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case role.FieldName:
		return m.Name()
	case role.FieldDescription:
		return m.Description()
	case role.FieldCreatedAt:
		return m.CreatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *RoleMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case role.FieldName:
		return m.OldName(ctx)
	case role.FieldDescription:
		return m.OldDescription(ctx)
	case role.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Role field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *RoleMutation) SetField(name string, value ent.Value) error {
	switch name {
	case role.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case role.FieldDescription:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDescription(v)
		return nil
	case role.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Role field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *RoleMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *RoleMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *RoleMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Role numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *RoleMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *RoleMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *RoleMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Role nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *RoleMutation) ResetField(name string) error {
	switch name {
	case role.FieldName:
		m.ResetName()
		return nil
	case role.FieldDescription:
		m.ResetDescription()
		return nil
	case role.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	}
	return fmt.Errorf("unknown Role field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *RoleMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.admins != nil {
		edges = append(edges, role.EdgeAdmins)
	}
	if m.admin_roles != nil {
		edges = append(edges, role.EdgeAdminRoles)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *RoleMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case role.EdgeAdmins:
		ids := make([]ent.Value, 0, len(m.admins))
		for id := range m.admins {
			ids = append(ids, id)
		}
		return ids
	case role.EdgeAdminRoles:
		ids := make([]ent.Value, 0, len(m.admin_roles))
		for id := range m.admin_roles {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *RoleMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	if m.removedadmins != nil {
		edges = append(edges, role.EdgeAdmins)
	}
	if m.removedadmin_roles != nil {
		edges = append(edges, role.EdgeAdminRoles)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *RoleMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case role.EdgeAdmins:
		ids := make([]ent.Value, 0, len(m.removedadmins))
		for id := range m.removedadmins {
			ids = append(ids, id)
		}
		return ids
	case role.EdgeAdminRoles:
		ids := make([]ent.Value, 0, len(m.removedadmin_roles))
		for id := range m.removedadmin_roles {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *RoleMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedadmins {
		edges = append(edges, role.EdgeAdmins)
	}
	if m.clearedadmin_roles {
		edges = append(edges, role.EdgeAdminRoles)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *RoleMutation) EdgeCleared(name string) bool {
	switch name {
	case role.EdgeAdmins:
		return m.clearedadmins
	case role.EdgeAdminRoles:
		return m.clearedadmin_roles
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *RoleMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown Role unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *RoleMutation) ResetEdge(name string) error {
	switch name {
	case role.EdgeAdmins:
		m.ResetAdmins()
		return nil
	case role.EdgeAdminRoles:
		m.ResetAdminRoles()
		return nil
	}
	return fmt.Errorf("unknown Role edge %s", name)
}

// SecurityScanningMutation represents an operation that mutates the SecurityScanning nodes in the graph.
type SecurityScanningMutation struct {
	config
	op                    Op
	typ                   string
	id                    *uuid.UUID
	status                *consts.SecurityScanningStatus
	workspace             *string
	language              *consts.SecurityScanningLanguage
	rule                  *string
	error_message         *string
	created_at            *time.Time
	updated_at            *time.Time
	clearedFields         map[string]struct{}
	user                  *uuid.UUID
	cleareduser           bool
	results               map[uuid.UUID]struct{}
	removedresults        map[uuid.UUID]struct{}
	clearedresults        bool
	workspace_edge        *uuid.UUID
	clearedworkspace_edge bool
	done                  bool
	oldValue              func(context.Context) (*SecurityScanning, error)
	predicates            []predicate.SecurityScanning
}

var _ ent.Mutation = (*SecurityScanningMutation)(nil)

// securityscanningOption allows management of the mutation configuration using functional options.
type securityscanningOption func(*SecurityScanningMutation)

// newSecurityScanningMutation creates new mutation for the SecurityScanning entity.
func newSecurityScanningMutation(c config, op Op, opts ...securityscanningOption) *SecurityScanningMutation {
	m := &SecurityScanningMutation{
		config:        c,
		op:            op,
		typ:           TypeSecurityScanning,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withSecurityScanningID sets the ID field of the mutation.
func withSecurityScanningID(id uuid.UUID) securityscanningOption {
	return func(m *SecurityScanningMutation) {
		var (
			err   error
			once  sync.Once
			value *SecurityScanning
		)
		m.oldValue = func(ctx context.Context) (*SecurityScanning, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().SecurityScanning.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withSecurityScanning sets the old SecurityScanning of the mutation.
func withSecurityScanning(node *SecurityScanning) securityscanningOption {
	return func(m *SecurityScanningMutation) {
		m.oldValue = func(context.Context) (*SecurityScanning, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m SecurityScanningMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m SecurityScanningMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of SecurityScanning entities.
func (m *SecurityScanningMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *SecurityScanningMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *SecurityScanningMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().SecurityScanning.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetUserID sets the "user_id" field.
func (m *SecurityScanningMutation) SetUserID(u uuid.UUID) {
	m.user = &u
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *SecurityScanningMutation) UserID() (r uuid.UUID, exists bool) {
	v := m.user
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the SecurityScanning entity.
// If the SecurityScanning object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningMutation) OldUserID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ResetUserID resets all changes to the "user_id" field.
func (m *SecurityScanningMutation) ResetUserID() {
	m.user = nil
}

// SetWorkspaceID sets the "workspace_id" field.
func (m *SecurityScanningMutation) SetWorkspaceID(u uuid.UUID) {
	m.workspace_edge = &u
}

// WorkspaceID returns the value of the "workspace_id" field in the mutation.
func (m *SecurityScanningMutation) WorkspaceID() (r uuid.UUID, exists bool) {
	v := m.workspace_edge
	if v == nil {
		return
	}
	return *v, true
}

// OldWorkspaceID returns the old "workspace_id" field's value of the SecurityScanning entity.
// If the SecurityScanning object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningMutation) OldWorkspaceID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldWorkspaceID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldWorkspaceID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldWorkspaceID: %w", err)
	}
	return oldValue.WorkspaceID, nil
}

// ResetWorkspaceID resets all changes to the "workspace_id" field.
func (m *SecurityScanningMutation) ResetWorkspaceID() {
	m.workspace_edge = nil
}

// SetStatus sets the "status" field.
func (m *SecurityScanningMutation) SetStatus(css consts.SecurityScanningStatus) {
	m.status = &css
}

// Status returns the value of the "status" field in the mutation.
func (m *SecurityScanningMutation) Status() (r consts.SecurityScanningStatus, exists bool) {
	v := m.status
	if v == nil {
		return
	}
	return *v, true
}

// OldStatus returns the old "status" field's value of the SecurityScanning entity.
// If the SecurityScanning object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningMutation) OldStatus(ctx context.Context) (v consts.SecurityScanningStatus, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStatus is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStatus requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStatus: %w", err)
	}
	return oldValue.Status, nil
}

// ResetStatus resets all changes to the "status" field.
func (m *SecurityScanningMutation) ResetStatus() {
	m.status = nil
}

// SetWorkspace sets the "workspace" field.
func (m *SecurityScanningMutation) SetWorkspace(s string) {
	m.workspace = &s
}

// Workspace returns the value of the "workspace" field in the mutation.
func (m *SecurityScanningMutation) Workspace() (r string, exists bool) {
	v := m.workspace
	if v == nil {
		return
	}
	return *v, true
}

// OldWorkspace returns the old "workspace" field's value of the SecurityScanning entity.
// If the SecurityScanning object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningMutation) OldWorkspace(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldWorkspace is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldWorkspace requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldWorkspace: %w", err)
	}
	return oldValue.Workspace, nil
}

// ResetWorkspace resets all changes to the "workspace" field.
func (m *SecurityScanningMutation) ResetWorkspace() {
	m.workspace = nil
}

// SetLanguage sets the "language" field.
func (m *SecurityScanningMutation) SetLanguage(csl consts.SecurityScanningLanguage) {
	m.language = &csl
}

// Language returns the value of the "language" field in the mutation.
func (m *SecurityScanningMutation) Language() (r consts.SecurityScanningLanguage, exists bool) {
	v := m.language
	if v == nil {
		return
	}
	return *v, true
}

// OldLanguage returns the old "language" field's value of the SecurityScanning entity.
// If the SecurityScanning object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningMutation) OldLanguage(ctx context.Context) (v consts.SecurityScanningLanguage, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldLanguage is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldLanguage requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLanguage: %w", err)
	}
	return oldValue.Language, nil
}

// ResetLanguage resets all changes to the "language" field.
func (m *SecurityScanningMutation) ResetLanguage() {
	m.language = nil
}

// SetRule sets the "rule" field.
func (m *SecurityScanningMutation) SetRule(s string) {
	m.rule = &s
}

// Rule returns the value of the "rule" field in the mutation.
func (m *SecurityScanningMutation) Rule() (r string, exists bool) {
	v := m.rule
	if v == nil {
		return
	}
	return *v, true
}

// OldRule returns the old "rule" field's value of the SecurityScanning entity.
// If the SecurityScanning object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningMutation) OldRule(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRule is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRule requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRule: %w", err)
	}
	return oldValue.Rule, nil
}

// ClearRule clears the value of the "rule" field.
func (m *SecurityScanningMutation) ClearRule() {
	m.rule = nil
	m.clearedFields[securityscanning.FieldRule] = struct{}{}
}

// RuleCleared returns if the "rule" field was cleared in this mutation.
func (m *SecurityScanningMutation) RuleCleared() bool {
	_, ok := m.clearedFields[securityscanning.FieldRule]
	return ok
}

// ResetRule resets all changes to the "rule" field.
func (m *SecurityScanningMutation) ResetRule() {
	m.rule = nil
	delete(m.clearedFields, securityscanning.FieldRule)
}

// SetErrorMessage sets the "error_message" field.
func (m *SecurityScanningMutation) SetErrorMessage(s string) {
	m.error_message = &s
}

// ErrorMessage returns the value of the "error_message" field in the mutation.
func (m *SecurityScanningMutation) ErrorMessage() (r string, exists bool) {
	v := m.error_message
	if v == nil {
		return
	}
	return *v, true
}

// OldErrorMessage returns the old "error_message" field's value of the SecurityScanning entity.
// If the SecurityScanning object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningMutation) OldErrorMessage(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldErrorMessage is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldErrorMessage requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldErrorMessage: %w", err)
	}
	return oldValue.ErrorMessage, nil
}

// ClearErrorMessage clears the value of the "error_message" field.
func (m *SecurityScanningMutation) ClearErrorMessage() {
	m.error_message = nil
	m.clearedFields[securityscanning.FieldErrorMessage] = struct{}{}
}

// ErrorMessageCleared returns if the "error_message" field was cleared in this mutation.
func (m *SecurityScanningMutation) ErrorMessageCleared() bool {
	_, ok := m.clearedFields[securityscanning.FieldErrorMessage]
	return ok
}

// ResetErrorMessage resets all changes to the "error_message" field.
func (m *SecurityScanningMutation) ResetErrorMessage() {
	m.error_message = nil
	delete(m.clearedFields, securityscanning.FieldErrorMessage)
}

// SetCreatedAt sets the "created_at" field.
func (m *SecurityScanningMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *SecurityScanningMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the SecurityScanning entity.
// If the SecurityScanning object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *SecurityScanningMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *SecurityScanningMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *SecurityScanningMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the SecurityScanning entity.
// If the SecurityScanning object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *SecurityScanningMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// ClearUser clears the "user" edge to the User entity.
func (m *SecurityScanningMutation) ClearUser() {
	m.cleareduser = true
	m.clearedFields[securityscanning.FieldUserID] = struct{}{}
}

// UserCleared reports if the "user" edge to the User entity was cleared.
func (m *SecurityScanningMutation) UserCleared() bool {
	return m.cleareduser
}

// UserIDs returns the "user" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserID instead. It exists only for internal usage by the builders.
func (m *SecurityScanningMutation) UserIDs() (ids []uuid.UUID) {
	if id := m.user; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUser resets all changes to the "user" edge.
func (m *SecurityScanningMutation) ResetUser() {
	m.user = nil
	m.cleareduser = false
}

// AddResultIDs adds the "results" edge to the SecurityScanningResult entity by ids.
func (m *SecurityScanningMutation) AddResultIDs(ids ...uuid.UUID) {
	if m.results == nil {
		m.results = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.results[ids[i]] = struct{}{}
	}
}

// ClearResults clears the "results" edge to the SecurityScanningResult entity.
func (m *SecurityScanningMutation) ClearResults() {
	m.clearedresults = true
}

// ResultsCleared reports if the "results" edge to the SecurityScanningResult entity was cleared.
func (m *SecurityScanningMutation) ResultsCleared() bool {
	return m.clearedresults
}

// RemoveResultIDs removes the "results" edge to the SecurityScanningResult entity by IDs.
func (m *SecurityScanningMutation) RemoveResultIDs(ids ...uuid.UUID) {
	if m.removedresults == nil {
		m.removedresults = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.results, ids[i])
		m.removedresults[ids[i]] = struct{}{}
	}
}

// RemovedResults returns the removed IDs of the "results" edge to the SecurityScanningResult entity.
func (m *SecurityScanningMutation) RemovedResultsIDs() (ids []uuid.UUID) {
	for id := range m.removedresults {
		ids = append(ids, id)
	}
	return
}

// ResultsIDs returns the "results" edge IDs in the mutation.
func (m *SecurityScanningMutation) ResultsIDs() (ids []uuid.UUID) {
	for id := range m.results {
		ids = append(ids, id)
	}
	return
}

// ResetResults resets all changes to the "results" edge.
func (m *SecurityScanningMutation) ResetResults() {
	m.results = nil
	m.clearedresults = false
	m.removedresults = nil
}

// SetWorkspaceEdgeID sets the "workspace_edge" edge to the Workspace entity by id.
func (m *SecurityScanningMutation) SetWorkspaceEdgeID(id uuid.UUID) {
	m.workspace_edge = &id
}

// ClearWorkspaceEdge clears the "workspace_edge" edge to the Workspace entity.
func (m *SecurityScanningMutation) ClearWorkspaceEdge() {
	m.clearedworkspace_edge = true
	m.clearedFields[securityscanning.FieldWorkspaceID] = struct{}{}
}

// WorkspaceEdgeCleared reports if the "workspace_edge" edge to the Workspace entity was cleared.
func (m *SecurityScanningMutation) WorkspaceEdgeCleared() bool {
	return m.clearedworkspace_edge
}

// WorkspaceEdgeID returns the "workspace_edge" edge ID in the mutation.
func (m *SecurityScanningMutation) WorkspaceEdgeID() (id uuid.UUID, exists bool) {
	if m.workspace_edge != nil {
		return *m.workspace_edge, true
	}
	return
}

// WorkspaceEdgeIDs returns the "workspace_edge" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// WorkspaceEdgeID instead. It exists only for internal usage by the builders.
func (m *SecurityScanningMutation) WorkspaceEdgeIDs() (ids []uuid.UUID) {
	if id := m.workspace_edge; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetWorkspaceEdge resets all changes to the "workspace_edge" edge.
func (m *SecurityScanningMutation) ResetWorkspaceEdge() {
	m.workspace_edge = nil
	m.clearedworkspace_edge = false
}

// Where appends a list predicates to the SecurityScanningMutation builder.
func (m *SecurityScanningMutation) Where(ps ...predicate.SecurityScanning) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the SecurityScanningMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *SecurityScanningMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.SecurityScanning, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *SecurityScanningMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *SecurityScanningMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (SecurityScanning).
func (m *SecurityScanningMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *SecurityScanningMutation) Fields() []string {
	fields := make([]string, 0, 9)
	if m.user != nil {
		fields = append(fields, securityscanning.FieldUserID)
	}
	if m.workspace_edge != nil {
		fields = append(fields, securityscanning.FieldWorkspaceID)
	}
	if m.status != nil {
		fields = append(fields, securityscanning.FieldStatus)
	}
	if m.workspace != nil {
		fields = append(fields, securityscanning.FieldWorkspace)
	}
	if m.language != nil {
		fields = append(fields, securityscanning.FieldLanguage)
	}
	if m.rule != nil {
		fields = append(fields, securityscanning.FieldRule)
	}
	if m.error_message != nil {
		fields = append(fields, securityscanning.FieldErrorMessage)
	}
	if m.created_at != nil {
		fields = append(fields, securityscanning.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, securityscanning.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *SecurityScanningMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case securityscanning.FieldUserID:
		return m.UserID()
	case securityscanning.FieldWorkspaceID:
		return m.WorkspaceID()
	case securityscanning.FieldStatus:
		return m.Status()
	case securityscanning.FieldWorkspace:
		return m.Workspace()
	case securityscanning.FieldLanguage:
		return m.Language()
	case securityscanning.FieldRule:
		return m.Rule()
	case securityscanning.FieldErrorMessage:
		return m.ErrorMessage()
	case securityscanning.FieldCreatedAt:
		return m.CreatedAt()
	case securityscanning.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *SecurityScanningMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case securityscanning.FieldUserID:
		return m.OldUserID(ctx)
	case securityscanning.FieldWorkspaceID:
		return m.OldWorkspaceID(ctx)
	case securityscanning.FieldStatus:
		return m.OldStatus(ctx)
	case securityscanning.FieldWorkspace:
		return m.OldWorkspace(ctx)
	case securityscanning.FieldLanguage:
		return m.OldLanguage(ctx)
	case securityscanning.FieldRule:
		return m.OldRule(ctx)
	case securityscanning.FieldErrorMessage:
		return m.OldErrorMessage(ctx)
	case securityscanning.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case securityscanning.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown SecurityScanning field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *SecurityScanningMutation) SetField(name string, value ent.Value) error {
	switch name {
	case securityscanning.FieldUserID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case securityscanning.FieldWorkspaceID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetWorkspaceID(v)
		return nil
	case securityscanning.FieldStatus:
		v, ok := value.(consts.SecurityScanningStatus)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStatus(v)
		return nil
	case securityscanning.FieldWorkspace:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetWorkspace(v)
		return nil
	case securityscanning.FieldLanguage:
		v, ok := value.(consts.SecurityScanningLanguage)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLanguage(v)
		return nil
	case securityscanning.FieldRule:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRule(v)
		return nil
	case securityscanning.FieldErrorMessage:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetErrorMessage(v)
		return nil
	case securityscanning.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case securityscanning.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown SecurityScanning field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *SecurityScanningMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *SecurityScanningMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *SecurityScanningMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown SecurityScanning numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *SecurityScanningMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(securityscanning.FieldRule) {
		fields = append(fields, securityscanning.FieldRule)
	}
	if m.FieldCleared(securityscanning.FieldErrorMessage) {
		fields = append(fields, securityscanning.FieldErrorMessage)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *SecurityScanningMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *SecurityScanningMutation) ClearField(name string) error {
	switch name {
	case securityscanning.FieldRule:
		m.ClearRule()
		return nil
	case securityscanning.FieldErrorMessage:
		m.ClearErrorMessage()
		return nil
	}
	return fmt.Errorf("unknown SecurityScanning nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *SecurityScanningMutation) ResetField(name string) error {
	switch name {
	case securityscanning.FieldUserID:
		m.ResetUserID()
		return nil
	case securityscanning.FieldWorkspaceID:
		m.ResetWorkspaceID()
		return nil
	case securityscanning.FieldStatus:
		m.ResetStatus()
		return nil
	case securityscanning.FieldWorkspace:
		m.ResetWorkspace()
		return nil
	case securityscanning.FieldLanguage:
		m.ResetLanguage()
		return nil
	case securityscanning.FieldRule:
		m.ResetRule()
		return nil
	case securityscanning.FieldErrorMessage:
		m.ResetErrorMessage()
		return nil
	case securityscanning.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case securityscanning.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown SecurityScanning field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *SecurityScanningMutation) AddedEdges() []string {
	edges := make([]string, 0, 3)
	if m.user != nil {
		edges = append(edges, securityscanning.EdgeUser)
	}
	if m.results != nil {
		edges = append(edges, securityscanning.EdgeResults)
	}
	if m.workspace_edge != nil {
		edges = append(edges, securityscanning.EdgeWorkspaceEdge)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *SecurityScanningMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case securityscanning.EdgeUser:
		if id := m.user; id != nil {
			return []ent.Value{*id}
		}
	case securityscanning.EdgeResults:
		ids := make([]ent.Value, 0, len(m.results))
		for id := range m.results {
			ids = append(ids, id)
		}
		return ids
	case securityscanning.EdgeWorkspaceEdge:
		if id := m.workspace_edge; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *SecurityScanningMutation) RemovedEdges() []string {
	edges := make([]string, 0, 3)
	if m.removedresults != nil {
		edges = append(edges, securityscanning.EdgeResults)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *SecurityScanningMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case securityscanning.EdgeResults:
		ids := make([]ent.Value, 0, len(m.removedresults))
		for id := range m.removedresults {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *SecurityScanningMutation) ClearedEdges() []string {
	edges := make([]string, 0, 3)
	if m.cleareduser {
		edges = append(edges, securityscanning.EdgeUser)
	}
	if m.clearedresults {
		edges = append(edges, securityscanning.EdgeResults)
	}
	if m.clearedworkspace_edge {
		edges = append(edges, securityscanning.EdgeWorkspaceEdge)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *SecurityScanningMutation) EdgeCleared(name string) bool {
	switch name {
	case securityscanning.EdgeUser:
		return m.cleareduser
	case securityscanning.EdgeResults:
		return m.clearedresults
	case securityscanning.EdgeWorkspaceEdge:
		return m.clearedworkspace_edge
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *SecurityScanningMutation) ClearEdge(name string) error {
	switch name {
	case securityscanning.EdgeUser:
		m.ClearUser()
		return nil
	case securityscanning.EdgeWorkspaceEdge:
		m.ClearWorkspaceEdge()
		return nil
	}
	return fmt.Errorf("unknown SecurityScanning unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *SecurityScanningMutation) ResetEdge(name string) error {
	switch name {
	case securityscanning.EdgeUser:
		m.ResetUser()
		return nil
	case securityscanning.EdgeResults:
		m.ResetResults()
		return nil
	case securityscanning.EdgeWorkspaceEdge:
		m.ResetWorkspaceEdge()
		return nil
	}
	return fmt.Errorf("unknown SecurityScanning edge %s", name)
}

// SecurityScanningResultMutation represents an operation that mutates the SecurityScanningResult nodes in the graph.
type SecurityScanningResultMutation struct {
	config
	op                       Op
	typ                      string
	id                       *uuid.UUID
	check_id                 *string
	engine_kind              *string
	lines                    *string
	_path                    *string
	message                  *string
	message_zh               *string
	severity                 *string
	abstract_en              *string
	abstract_zh              *string
	category_en              *string
	category_zh              *string
	confidence               *string
	cwe                      *[]interface{}
	appendcwe                []interface{}
	impact                   *string
	owasp                    *[]interface{}
	appendowasp              []interface{}
	file_content             *string
	start_position           **types.Position
	end_position             **types.Position
	created_at               *time.Time
	clearedFields            map[string]struct{}
	security_scanning        *uuid.UUID
	clearedsecurity_scanning bool
	done                     bool
	oldValue                 func(context.Context) (*SecurityScanningResult, error)
	predicates               []predicate.SecurityScanningResult
}

var _ ent.Mutation = (*SecurityScanningResultMutation)(nil)

// securityscanningresultOption allows management of the mutation configuration using functional options.
type securityscanningresultOption func(*SecurityScanningResultMutation)

// newSecurityScanningResultMutation creates new mutation for the SecurityScanningResult entity.
func newSecurityScanningResultMutation(c config, op Op, opts ...securityscanningresultOption) *SecurityScanningResultMutation {
	m := &SecurityScanningResultMutation{
		config:        c,
		op:            op,
		typ:           TypeSecurityScanningResult,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withSecurityScanningResultID sets the ID field of the mutation.
func withSecurityScanningResultID(id uuid.UUID) securityscanningresultOption {
	return func(m *SecurityScanningResultMutation) {
		var (
			err   error
			once  sync.Once
			value *SecurityScanningResult
		)
		m.oldValue = func(ctx context.Context) (*SecurityScanningResult, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().SecurityScanningResult.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withSecurityScanningResult sets the old SecurityScanningResult of the mutation.
func withSecurityScanningResult(node *SecurityScanningResult) securityscanningresultOption {
	return func(m *SecurityScanningResultMutation) {
		m.oldValue = func(context.Context) (*SecurityScanningResult, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m SecurityScanningResultMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m SecurityScanningResultMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of SecurityScanningResult entities.
func (m *SecurityScanningResultMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *SecurityScanningResultMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *SecurityScanningResultMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().SecurityScanningResult.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetSecurityScanningID sets the "security_scanning_id" field.
func (m *SecurityScanningResultMutation) SetSecurityScanningID(u uuid.UUID) {
	m.security_scanning = &u
}

// SecurityScanningID returns the value of the "security_scanning_id" field in the mutation.
func (m *SecurityScanningResultMutation) SecurityScanningID() (r uuid.UUID, exists bool) {
	v := m.security_scanning
	if v == nil {
		return
	}
	return *v, true
}

// OldSecurityScanningID returns the old "security_scanning_id" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldSecurityScanningID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSecurityScanningID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSecurityScanningID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSecurityScanningID: %w", err)
	}
	return oldValue.SecurityScanningID, nil
}

// ResetSecurityScanningID resets all changes to the "security_scanning_id" field.
func (m *SecurityScanningResultMutation) ResetSecurityScanningID() {
	m.security_scanning = nil
}

// SetCheckID sets the "check_id" field.
func (m *SecurityScanningResultMutation) SetCheckID(s string) {
	m.check_id = &s
}

// CheckID returns the value of the "check_id" field in the mutation.
func (m *SecurityScanningResultMutation) CheckID() (r string, exists bool) {
	v := m.check_id
	if v == nil {
		return
	}
	return *v, true
}

// OldCheckID returns the old "check_id" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldCheckID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCheckID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCheckID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCheckID: %w", err)
	}
	return oldValue.CheckID, nil
}

// ResetCheckID resets all changes to the "check_id" field.
func (m *SecurityScanningResultMutation) ResetCheckID() {
	m.check_id = nil
}

// SetEngineKind sets the "engine_kind" field.
func (m *SecurityScanningResultMutation) SetEngineKind(s string) {
	m.engine_kind = &s
}

// EngineKind returns the value of the "engine_kind" field in the mutation.
func (m *SecurityScanningResultMutation) EngineKind() (r string, exists bool) {
	v := m.engine_kind
	if v == nil {
		return
	}
	return *v, true
}

// OldEngineKind returns the old "engine_kind" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldEngineKind(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEngineKind is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEngineKind requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEngineKind: %w", err)
	}
	return oldValue.EngineKind, nil
}

// ResetEngineKind resets all changes to the "engine_kind" field.
func (m *SecurityScanningResultMutation) ResetEngineKind() {
	m.engine_kind = nil
}

// SetLines sets the "lines" field.
func (m *SecurityScanningResultMutation) SetLines(s string) {
	m.lines = &s
}

// Lines returns the value of the "lines" field in the mutation.
func (m *SecurityScanningResultMutation) Lines() (r string, exists bool) {
	v := m.lines
	if v == nil {
		return
	}
	return *v, true
}

// OldLines returns the old "lines" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldLines(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldLines is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldLines requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLines: %w", err)
	}
	return oldValue.Lines, nil
}

// ResetLines resets all changes to the "lines" field.
func (m *SecurityScanningResultMutation) ResetLines() {
	m.lines = nil
}

// SetPath sets the "path" field.
func (m *SecurityScanningResultMutation) SetPath(s string) {
	m._path = &s
}

// Path returns the value of the "path" field in the mutation.
func (m *SecurityScanningResultMutation) Path() (r string, exists bool) {
	v := m._path
	if v == nil {
		return
	}
	return *v, true
}

// OldPath returns the old "path" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldPath(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPath is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPath requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPath: %w", err)
	}
	return oldValue.Path, nil
}

// ResetPath resets all changes to the "path" field.
func (m *SecurityScanningResultMutation) ResetPath() {
	m._path = nil
}

// SetMessage sets the "message" field.
func (m *SecurityScanningResultMutation) SetMessage(s string) {
	m.message = &s
}

// Message returns the value of the "message" field in the mutation.
func (m *SecurityScanningResultMutation) Message() (r string, exists bool) {
	v := m.message
	if v == nil {
		return
	}
	return *v, true
}

// OldMessage returns the old "message" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldMessage(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldMessage is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldMessage requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldMessage: %w", err)
	}
	return oldValue.Message, nil
}

// ResetMessage resets all changes to the "message" field.
func (m *SecurityScanningResultMutation) ResetMessage() {
	m.message = nil
}

// SetMessageZh sets the "message_zh" field.
func (m *SecurityScanningResultMutation) SetMessageZh(s string) {
	m.message_zh = &s
}

// MessageZh returns the value of the "message_zh" field in the mutation.
func (m *SecurityScanningResultMutation) MessageZh() (r string, exists bool) {
	v := m.message_zh
	if v == nil {
		return
	}
	return *v, true
}

// OldMessageZh returns the old "message_zh" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldMessageZh(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldMessageZh is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldMessageZh requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldMessageZh: %w", err)
	}
	return oldValue.MessageZh, nil
}

// ResetMessageZh resets all changes to the "message_zh" field.
func (m *SecurityScanningResultMutation) ResetMessageZh() {
	m.message_zh = nil
}

// SetSeverity sets the "severity" field.
func (m *SecurityScanningResultMutation) SetSeverity(s string) {
	m.severity = &s
}

// Severity returns the value of the "severity" field in the mutation.
func (m *SecurityScanningResultMutation) Severity() (r string, exists bool) {
	v := m.severity
	if v == nil {
		return
	}
	return *v, true
}

// OldSeverity returns the old "severity" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldSeverity(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSeverity is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSeverity requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSeverity: %w", err)
	}
	return oldValue.Severity, nil
}

// ResetSeverity resets all changes to the "severity" field.
func (m *SecurityScanningResultMutation) ResetSeverity() {
	m.severity = nil
}

// SetAbstractEn sets the "abstract_en" field.
func (m *SecurityScanningResultMutation) SetAbstractEn(s string) {
	m.abstract_en = &s
}

// AbstractEn returns the value of the "abstract_en" field in the mutation.
func (m *SecurityScanningResultMutation) AbstractEn() (r string, exists bool) {
	v := m.abstract_en
	if v == nil {
		return
	}
	return *v, true
}

// OldAbstractEn returns the old "abstract_en" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldAbstractEn(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAbstractEn is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAbstractEn requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAbstractEn: %w", err)
	}
	return oldValue.AbstractEn, nil
}

// ResetAbstractEn resets all changes to the "abstract_en" field.
func (m *SecurityScanningResultMutation) ResetAbstractEn() {
	m.abstract_en = nil
}

// SetAbstractZh sets the "abstract_zh" field.
func (m *SecurityScanningResultMutation) SetAbstractZh(s string) {
	m.abstract_zh = &s
}

// AbstractZh returns the value of the "abstract_zh" field in the mutation.
func (m *SecurityScanningResultMutation) AbstractZh() (r string, exists bool) {
	v := m.abstract_zh
	if v == nil {
		return
	}
	return *v, true
}

// OldAbstractZh returns the old "abstract_zh" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldAbstractZh(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAbstractZh is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAbstractZh requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAbstractZh: %w", err)
	}
	return oldValue.AbstractZh, nil
}

// ResetAbstractZh resets all changes to the "abstract_zh" field.
func (m *SecurityScanningResultMutation) ResetAbstractZh() {
	m.abstract_zh = nil
}

// SetCategoryEn sets the "category_en" field.
func (m *SecurityScanningResultMutation) SetCategoryEn(s string) {
	m.category_en = &s
}

// CategoryEn returns the value of the "category_en" field in the mutation.
func (m *SecurityScanningResultMutation) CategoryEn() (r string, exists bool) {
	v := m.category_en
	if v == nil {
		return
	}
	return *v, true
}

// OldCategoryEn returns the old "category_en" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldCategoryEn(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCategoryEn is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCategoryEn requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCategoryEn: %w", err)
	}
	return oldValue.CategoryEn, nil
}

// ResetCategoryEn resets all changes to the "category_en" field.
func (m *SecurityScanningResultMutation) ResetCategoryEn() {
	m.category_en = nil
}

// SetCategoryZh sets the "category_zh" field.
func (m *SecurityScanningResultMutation) SetCategoryZh(s string) {
	m.category_zh = &s
}

// CategoryZh returns the value of the "category_zh" field in the mutation.
func (m *SecurityScanningResultMutation) CategoryZh() (r string, exists bool) {
	v := m.category_zh
	if v == nil {
		return
	}
	return *v, true
}

// OldCategoryZh returns the old "category_zh" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldCategoryZh(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCategoryZh is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCategoryZh requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCategoryZh: %w", err)
	}
	return oldValue.CategoryZh, nil
}

// ResetCategoryZh resets all changes to the "category_zh" field.
func (m *SecurityScanningResultMutation) ResetCategoryZh() {
	m.category_zh = nil
}

// SetConfidence sets the "confidence" field.
func (m *SecurityScanningResultMutation) SetConfidence(s string) {
	m.confidence = &s
}

// Confidence returns the value of the "confidence" field in the mutation.
func (m *SecurityScanningResultMutation) Confidence() (r string, exists bool) {
	v := m.confidence
	if v == nil {
		return
	}
	return *v, true
}

// OldConfidence returns the old "confidence" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldConfidence(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldConfidence is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldConfidence requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldConfidence: %w", err)
	}
	return oldValue.Confidence, nil
}

// ResetConfidence resets all changes to the "confidence" field.
func (m *SecurityScanningResultMutation) ResetConfidence() {
	m.confidence = nil
}

// SetCwe sets the "cwe" field.
func (m *SecurityScanningResultMutation) SetCwe(i []interface{}) {
	m.cwe = &i
	m.appendcwe = nil
}

// Cwe returns the value of the "cwe" field in the mutation.
func (m *SecurityScanningResultMutation) Cwe() (r []interface{}, exists bool) {
	v := m.cwe
	if v == nil {
		return
	}
	return *v, true
}

// OldCwe returns the old "cwe" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldCwe(ctx context.Context) (v []interface{}, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCwe is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCwe requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCwe: %w", err)
	}
	return oldValue.Cwe, nil
}

// AppendCwe adds i to the "cwe" field.
func (m *SecurityScanningResultMutation) AppendCwe(i []interface{}) {
	m.appendcwe = append(m.appendcwe, i...)
}

// AppendedCwe returns the list of values that were appended to the "cwe" field in this mutation.
func (m *SecurityScanningResultMutation) AppendedCwe() ([]interface{}, bool) {
	if len(m.appendcwe) == 0 {
		return nil, false
	}
	return m.appendcwe, true
}

// ResetCwe resets all changes to the "cwe" field.
func (m *SecurityScanningResultMutation) ResetCwe() {
	m.cwe = nil
	m.appendcwe = nil
}

// SetImpact sets the "impact" field.
func (m *SecurityScanningResultMutation) SetImpact(s string) {
	m.impact = &s
}

// Impact returns the value of the "impact" field in the mutation.
func (m *SecurityScanningResultMutation) Impact() (r string, exists bool) {
	v := m.impact
	if v == nil {
		return
	}
	return *v, true
}

// OldImpact returns the old "impact" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldImpact(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldImpact is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldImpact requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldImpact: %w", err)
	}
	return oldValue.Impact, nil
}

// ResetImpact resets all changes to the "impact" field.
func (m *SecurityScanningResultMutation) ResetImpact() {
	m.impact = nil
}

// SetOwasp sets the "owasp" field.
func (m *SecurityScanningResultMutation) SetOwasp(i []interface{}) {
	m.owasp = &i
	m.appendowasp = nil
}

// Owasp returns the value of the "owasp" field in the mutation.
func (m *SecurityScanningResultMutation) Owasp() (r []interface{}, exists bool) {
	v := m.owasp
	if v == nil {
		return
	}
	return *v, true
}

// OldOwasp returns the old "owasp" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldOwasp(ctx context.Context) (v []interface{}, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOwasp is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOwasp requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOwasp: %w", err)
	}
	return oldValue.Owasp, nil
}

// AppendOwasp adds i to the "owasp" field.
func (m *SecurityScanningResultMutation) AppendOwasp(i []interface{}) {
	m.appendowasp = append(m.appendowasp, i...)
}

// AppendedOwasp returns the list of values that were appended to the "owasp" field in this mutation.
func (m *SecurityScanningResultMutation) AppendedOwasp() ([]interface{}, bool) {
	if len(m.appendowasp) == 0 {
		return nil, false
	}
	return m.appendowasp, true
}

// ResetOwasp resets all changes to the "owasp" field.
func (m *SecurityScanningResultMutation) ResetOwasp() {
	m.owasp = nil
	m.appendowasp = nil
}

// SetFileContent sets the "file_content" field.
func (m *SecurityScanningResultMutation) SetFileContent(s string) {
	m.file_content = &s
}

// FileContent returns the value of the "file_content" field in the mutation.
func (m *SecurityScanningResultMutation) FileContent() (r string, exists bool) {
	v := m.file_content
	if v == nil {
		return
	}
	return *v, true
}

// OldFileContent returns the old "file_content" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldFileContent(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFileContent is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFileContent requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFileContent: %w", err)
	}
	return oldValue.FileContent, nil
}

// ResetFileContent resets all changes to the "file_content" field.
func (m *SecurityScanningResultMutation) ResetFileContent() {
	m.file_content = nil
}

// SetStartPosition sets the "start_position" field.
func (m *SecurityScanningResultMutation) SetStartPosition(t *types.Position) {
	m.start_position = &t
}

// StartPosition returns the value of the "start_position" field in the mutation.
func (m *SecurityScanningResultMutation) StartPosition() (r *types.Position, exists bool) {
	v := m.start_position
	if v == nil {
		return
	}
	return *v, true
}

// OldStartPosition returns the old "start_position" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldStartPosition(ctx context.Context) (v *types.Position, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStartPosition is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStartPosition requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStartPosition: %w", err)
	}
	return oldValue.StartPosition, nil
}

// ResetStartPosition resets all changes to the "start_position" field.
func (m *SecurityScanningResultMutation) ResetStartPosition() {
	m.start_position = nil
}

// SetEndPosition sets the "end_position" field.
func (m *SecurityScanningResultMutation) SetEndPosition(t *types.Position) {
	m.end_position = &t
}

// EndPosition returns the value of the "end_position" field in the mutation.
func (m *SecurityScanningResultMutation) EndPosition() (r *types.Position, exists bool) {
	v := m.end_position
	if v == nil {
		return
	}
	return *v, true
}

// OldEndPosition returns the old "end_position" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldEndPosition(ctx context.Context) (v *types.Position, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEndPosition is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEndPosition requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEndPosition: %w", err)
	}
	return oldValue.EndPosition, nil
}

// ResetEndPosition resets all changes to the "end_position" field.
func (m *SecurityScanningResultMutation) ResetEndPosition() {
	m.end_position = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *SecurityScanningResultMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *SecurityScanningResultMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the SecurityScanningResult entity.
// If the SecurityScanningResult object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SecurityScanningResultMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *SecurityScanningResultMutation) ResetCreatedAt() {
	m.created_at = nil
}

// ClearSecurityScanning clears the "security_scanning" edge to the SecurityScanning entity.
func (m *SecurityScanningResultMutation) ClearSecurityScanning() {
	m.clearedsecurity_scanning = true
	m.clearedFields[securityscanningresult.FieldSecurityScanningID] = struct{}{}
}

// SecurityScanningCleared reports if the "security_scanning" edge to the SecurityScanning entity was cleared.
func (m *SecurityScanningResultMutation) SecurityScanningCleared() bool {
	return m.clearedsecurity_scanning
}

// SecurityScanningIDs returns the "security_scanning" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// SecurityScanningID instead. It exists only for internal usage by the builders.
func (m *SecurityScanningResultMutation) SecurityScanningIDs() (ids []uuid.UUID) {
	if id := m.security_scanning; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetSecurityScanning resets all changes to the "security_scanning" edge.
func (m *SecurityScanningResultMutation) ResetSecurityScanning() {
	m.security_scanning = nil
	m.clearedsecurity_scanning = false
}

// Where appends a list predicates to the SecurityScanningResultMutation builder.
func (m *SecurityScanningResultMutation) Where(ps ...predicate.SecurityScanningResult) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the SecurityScanningResultMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *SecurityScanningResultMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.SecurityScanningResult, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *SecurityScanningResultMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *SecurityScanningResultMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (SecurityScanningResult).
func (m *SecurityScanningResultMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *SecurityScanningResultMutation) Fields() []string {
	fields := make([]string, 0, 20)
	if m.security_scanning != nil {
		fields = append(fields, securityscanningresult.FieldSecurityScanningID)
	}
	if m.check_id != nil {
		fields = append(fields, securityscanningresult.FieldCheckID)
	}
	if m.engine_kind != nil {
		fields = append(fields, securityscanningresult.FieldEngineKind)
	}
	if m.lines != nil {
		fields = append(fields, securityscanningresult.FieldLines)
	}
	if m._path != nil {
		fields = append(fields, securityscanningresult.FieldPath)
	}
	if m.message != nil {
		fields = append(fields, securityscanningresult.FieldMessage)
	}
	if m.message_zh != nil {
		fields = append(fields, securityscanningresult.FieldMessageZh)
	}
	if m.severity != nil {
		fields = append(fields, securityscanningresult.FieldSeverity)
	}
	if m.abstract_en != nil {
		fields = append(fields, securityscanningresult.FieldAbstractEn)
	}
	if m.abstract_zh != nil {
		fields = append(fields, securityscanningresult.FieldAbstractZh)
	}
	if m.category_en != nil {
		fields = append(fields, securityscanningresult.FieldCategoryEn)
	}
	if m.category_zh != nil {
		fields = append(fields, securityscanningresult.FieldCategoryZh)
	}
	if m.confidence != nil {
		fields = append(fields, securityscanningresult.FieldConfidence)
	}
	if m.cwe != nil {
		fields = append(fields, securityscanningresult.FieldCwe)
	}
	if m.impact != nil {
		fields = append(fields, securityscanningresult.FieldImpact)
	}
	if m.owasp != nil {
		fields = append(fields, securityscanningresult.FieldOwasp)
	}
	if m.file_content != nil {
		fields = append(fields, securityscanningresult.FieldFileContent)
	}
	if m.start_position != nil {
		fields = append(fields, securityscanningresult.FieldStartPosition)
	}
	if m.end_position != nil {
		fields = append(fields, securityscanningresult.FieldEndPosition)
	}
	if m.created_at != nil {
		fields = append(fields, securityscanningresult.FieldCreatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *SecurityScanningResultMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case securityscanningresult.FieldSecurityScanningID:
		return m.SecurityScanningID()
	case securityscanningresult.FieldCheckID:
		return m.CheckID()
	case securityscanningresult.FieldEngineKind:
		return m.EngineKind()
	case securityscanningresult.FieldLines:
		return m.Lines()
	case securityscanningresult.FieldPath:
		return m.Path()
	case securityscanningresult.FieldMessage:
		return m.Message()
	case securityscanningresult.FieldMessageZh:
		return m.MessageZh()
	case securityscanningresult.FieldSeverity:
		return m.Severity()
	case securityscanningresult.FieldAbstractEn:
		return m.AbstractEn()
	case securityscanningresult.FieldAbstractZh:
		return m.AbstractZh()
	case securityscanningresult.FieldCategoryEn:
		return m.CategoryEn()
	case securityscanningresult.FieldCategoryZh:
		return m.CategoryZh()
	case securityscanningresult.FieldConfidence:
		return m.Confidence()
	case securityscanningresult.FieldCwe:
		return m.Cwe()
	case securityscanningresult.FieldImpact:
		return m.Impact()
	case securityscanningresult.FieldOwasp:
		return m.Owasp()
	case securityscanningresult.FieldFileContent:
		return m.FileContent()
	case securityscanningresult.FieldStartPosition:
		return m.StartPosition()
	case securityscanningresult.FieldEndPosition:
		return m.EndPosition()
	case securityscanningresult.FieldCreatedAt:
		return m.CreatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *SecurityScanningResultMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case securityscanningresult.FieldSecurityScanningID:
		return m.OldSecurityScanningID(ctx)
	case securityscanningresult.FieldCheckID:
		return m.OldCheckID(ctx)
	case securityscanningresult.FieldEngineKind:
		return m.OldEngineKind(ctx)
	case securityscanningresult.FieldLines:
		return m.OldLines(ctx)
	case securityscanningresult.FieldPath:
		return m.OldPath(ctx)
	case securityscanningresult.FieldMessage:
		return m.OldMessage(ctx)
	case securityscanningresult.FieldMessageZh:
		return m.OldMessageZh(ctx)
	case securityscanningresult.FieldSeverity:
		return m.OldSeverity(ctx)
	case securityscanningresult.FieldAbstractEn:
		return m.OldAbstractEn(ctx)
	case securityscanningresult.FieldAbstractZh:
		return m.OldAbstractZh(ctx)
	case securityscanningresult.FieldCategoryEn:
		return m.OldCategoryEn(ctx)
	case securityscanningresult.FieldCategoryZh:
		return m.OldCategoryZh(ctx)
	case securityscanningresult.FieldConfidence:
		return m.OldConfidence(ctx)
	case securityscanningresult.FieldCwe:
		return m.OldCwe(ctx)
	case securityscanningresult.FieldImpact:
		return m.OldImpact(ctx)
	case securityscanningresult.FieldOwasp:
		return m.OldOwasp(ctx)
	case securityscanningresult.FieldFileContent:
		return m.OldFileContent(ctx)
	case securityscanningresult.FieldStartPosition:
		return m.OldStartPosition(ctx)
	case securityscanningresult.FieldEndPosition:
		return m.OldEndPosition(ctx)
	case securityscanningresult.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown SecurityScanningResult field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *SecurityScanningResultMutation) SetField(name string, value ent.Value) error {
	switch name {
	case securityscanningresult.FieldSecurityScanningID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSecurityScanningID(v)
		return nil
	case securityscanningresult.FieldCheckID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCheckID(v)
		return nil
	case securityscanningresult.FieldEngineKind:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEngineKind(v)
		return nil
	case securityscanningresult.FieldLines:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLines(v)
		return nil
	case securityscanningresult.FieldPath:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPath(v)
		return nil
	case securityscanningresult.FieldMessage:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetMessage(v)
		return nil
	case securityscanningresult.FieldMessageZh:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetMessageZh(v)
		return nil
	case securityscanningresult.FieldSeverity:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSeverity(v)
		return nil
	case securityscanningresult.FieldAbstractEn:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAbstractEn(v)
		return nil
	case securityscanningresult.FieldAbstractZh:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAbstractZh(v)
		return nil
	case securityscanningresult.FieldCategoryEn:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCategoryEn(v)
		return nil
	case securityscanningresult.FieldCategoryZh:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCategoryZh(v)
		return nil
	case securityscanningresult.FieldConfidence:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetConfidence(v)
		return nil
	case securityscanningresult.FieldCwe:
		v, ok := value.([]interface{})
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCwe(v)
		return nil
	case securityscanningresult.FieldImpact:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetImpact(v)
		return nil
	case securityscanningresult.FieldOwasp:
		v, ok := value.([]interface{})
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOwasp(v)
		return nil
	case securityscanningresult.FieldFileContent:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFileContent(v)
		return nil
	case securityscanningresult.FieldStartPosition:
		v, ok := value.(*types.Position)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStartPosition(v)
		return nil
	case securityscanningresult.FieldEndPosition:
		v, ok := value.(*types.Position)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEndPosition(v)
		return nil
	case securityscanningresult.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown SecurityScanningResult field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *SecurityScanningResultMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *SecurityScanningResultMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *SecurityScanningResultMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown SecurityScanningResult numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *SecurityScanningResultMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *SecurityScanningResultMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *SecurityScanningResultMutation) ClearField(name string) error {
	return fmt.Errorf("unknown SecurityScanningResult nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *SecurityScanningResultMutation) ResetField(name string) error {
	switch name {
	case securityscanningresult.FieldSecurityScanningID:
		m.ResetSecurityScanningID()
		return nil
	case securityscanningresult.FieldCheckID:
		m.ResetCheckID()
		return nil
	case securityscanningresult.FieldEngineKind:
		m.ResetEngineKind()
		return nil
	case securityscanningresult.FieldLines:
		m.ResetLines()
		return nil
	case securityscanningresult.FieldPath:
		m.ResetPath()
		return nil
	case securityscanningresult.FieldMessage:
		m.ResetMessage()
		return nil
	case securityscanningresult.FieldMessageZh:
		m.ResetMessageZh()
		return nil
	case securityscanningresult.FieldSeverity:
		m.ResetSeverity()
		return nil
	case securityscanningresult.FieldAbstractEn:
		m.ResetAbstractEn()
		return nil
	case securityscanningresult.FieldAbstractZh:
		m.ResetAbstractZh()
		return nil
	case securityscanningresult.FieldCategoryEn:
		m.ResetCategoryEn()
		return nil
	case securityscanningresult.FieldCategoryZh:
		m.ResetCategoryZh()
		return nil
	case securityscanningresult.FieldConfidence:
		m.ResetConfidence()
		return nil
	case securityscanningresult.FieldCwe:
		m.ResetCwe()
		return nil
	case securityscanningresult.FieldImpact:
		m.ResetImpact()
		return nil
	case securityscanningresult.FieldOwasp:
		m.ResetOwasp()
		return nil
	case securityscanningresult.FieldFileContent:
		m.ResetFileContent()
		return nil
	case securityscanningresult.FieldStartPosition:
		m.ResetStartPosition()
		return nil
	case securityscanningresult.FieldEndPosition:
		m.ResetEndPosition()
		return nil
	case securityscanningresult.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	}
	return fmt.Errorf("unknown SecurityScanningResult field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *SecurityScanningResultMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.security_scanning != nil {
		edges = append(edges, securityscanningresult.EdgeSecurityScanning)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *SecurityScanningResultMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case securityscanningresult.EdgeSecurityScanning:
		if id := m.security_scanning; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *SecurityScanningResultMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *SecurityScanningResultMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *SecurityScanningResultMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedsecurity_scanning {
		edges = append(edges, securityscanningresult.EdgeSecurityScanning)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *SecurityScanningResultMutation) EdgeCleared(name string) bool {
	switch name {
	case securityscanningresult.EdgeSecurityScanning:
		return m.clearedsecurity_scanning
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *SecurityScanningResultMutation) ClearEdge(name string) error {
	switch name {
	case securityscanningresult.EdgeSecurityScanning:
		m.ClearSecurityScanning()
		return nil
	}
	return fmt.Errorf("unknown SecurityScanningResult unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *SecurityScanningResultMutation) ResetEdge(name string) error {
	switch name {
	case securityscanningresult.EdgeSecurityScanning:
		m.ResetSecurityScanning()
		return nil
	}
	return fmt.Errorf("unknown SecurityScanningResult edge %s", name)
}

// SettingMutation represents an operation that mutates the Setting nodes in the graph.
type SettingMutation struct {
	config
	op                     Op
	typ                    string
	id                     *uuid.UUID
	enable_sso             *bool
	force_two_factor_auth  *bool
	disable_password_login *bool
	enable_auto_login      *bool
	dingtalk_oauth         **types.DingtalkOAuth
	custom_oauth           **types.CustomOAuth
	base_url               *string
	created_at             *time.Time
	updated_at             *time.Time
	clearedFields          map[string]struct{}
	done                   bool
	oldValue               func(context.Context) (*Setting, error)
	predicates             []predicate.Setting
}

var _ ent.Mutation = (*SettingMutation)(nil)

// settingOption allows management of the mutation configuration using functional options.
type settingOption func(*SettingMutation)

// newSettingMutation creates new mutation for the Setting entity.
func newSettingMutation(c config, op Op, opts ...settingOption) *SettingMutation {
	m := &SettingMutation{
		config:        c,
		op:            op,
		typ:           TypeSetting,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withSettingID sets the ID field of the mutation.
func withSettingID(id uuid.UUID) settingOption {
	return func(m *SettingMutation) {
		var (
			err   error
			once  sync.Once
			value *Setting
		)
		m.oldValue = func(ctx context.Context) (*Setting, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Setting.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withSetting sets the old Setting of the mutation.
func withSetting(node *Setting) settingOption {
	return func(m *SettingMutation) {
		m.oldValue = func(context.Context) (*Setting, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m SettingMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m SettingMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Setting entities.
func (m *SettingMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *SettingMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *SettingMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Setting.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetEnableSSO sets the "enable_sso" field.
func (m *SettingMutation) SetEnableSSO(b bool) {
	m.enable_sso = &b
}

// EnableSSO returns the value of the "enable_sso" field in the mutation.
func (m *SettingMutation) EnableSSO() (r bool, exists bool) {
	v := m.enable_sso
	if v == nil {
		return
	}
	return *v, true
}

// OldEnableSSO returns the old "enable_sso" field's value of the Setting entity.
// If the Setting object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SettingMutation) OldEnableSSO(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEnableSSO is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEnableSSO requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEnableSSO: %w", err)
	}
	return oldValue.EnableSSO, nil
}

// ResetEnableSSO resets all changes to the "enable_sso" field.
func (m *SettingMutation) ResetEnableSSO() {
	m.enable_sso = nil
}

// SetForceTwoFactorAuth sets the "force_two_factor_auth" field.
func (m *SettingMutation) SetForceTwoFactorAuth(b bool) {
	m.force_two_factor_auth = &b
}

// ForceTwoFactorAuth returns the value of the "force_two_factor_auth" field in the mutation.
func (m *SettingMutation) ForceTwoFactorAuth() (r bool, exists bool) {
	v := m.force_two_factor_auth
	if v == nil {
		return
	}
	return *v, true
}

// OldForceTwoFactorAuth returns the old "force_two_factor_auth" field's value of the Setting entity.
// If the Setting object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SettingMutation) OldForceTwoFactorAuth(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldForceTwoFactorAuth is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldForceTwoFactorAuth requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldForceTwoFactorAuth: %w", err)
	}
	return oldValue.ForceTwoFactorAuth, nil
}

// ResetForceTwoFactorAuth resets all changes to the "force_two_factor_auth" field.
func (m *SettingMutation) ResetForceTwoFactorAuth() {
	m.force_two_factor_auth = nil
}

// SetDisablePasswordLogin sets the "disable_password_login" field.
func (m *SettingMutation) SetDisablePasswordLogin(b bool) {
	m.disable_password_login = &b
}

// DisablePasswordLogin returns the value of the "disable_password_login" field in the mutation.
func (m *SettingMutation) DisablePasswordLogin() (r bool, exists bool) {
	v := m.disable_password_login
	if v == nil {
		return
	}
	return *v, true
}

// OldDisablePasswordLogin returns the old "disable_password_login" field's value of the Setting entity.
// If the Setting object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SettingMutation) OldDisablePasswordLogin(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDisablePasswordLogin is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDisablePasswordLogin requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDisablePasswordLogin: %w", err)
	}
	return oldValue.DisablePasswordLogin, nil
}

// ResetDisablePasswordLogin resets all changes to the "disable_password_login" field.
func (m *SettingMutation) ResetDisablePasswordLogin() {
	m.disable_password_login = nil
}

// SetEnableAutoLogin sets the "enable_auto_login" field.
func (m *SettingMutation) SetEnableAutoLogin(b bool) {
	m.enable_auto_login = &b
}

// EnableAutoLogin returns the value of the "enable_auto_login" field in the mutation.
func (m *SettingMutation) EnableAutoLogin() (r bool, exists bool) {
	v := m.enable_auto_login
	if v == nil {
		return
	}
	return *v, true
}

// OldEnableAutoLogin returns the old "enable_auto_login" field's value of the Setting entity.
// If the Setting object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SettingMutation) OldEnableAutoLogin(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEnableAutoLogin is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEnableAutoLogin requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEnableAutoLogin: %w", err)
	}
	return oldValue.EnableAutoLogin, nil
}

// ResetEnableAutoLogin resets all changes to the "enable_auto_login" field.
func (m *SettingMutation) ResetEnableAutoLogin() {
	m.enable_auto_login = nil
}

// SetDingtalkOauth sets the "dingtalk_oauth" field.
func (m *SettingMutation) SetDingtalkOauth(to *types.DingtalkOAuth) {
	m.dingtalk_oauth = &to
}

// DingtalkOauth returns the value of the "dingtalk_oauth" field in the mutation.
func (m *SettingMutation) DingtalkOauth() (r *types.DingtalkOAuth, exists bool) {
	v := m.dingtalk_oauth
	if v == nil {
		return
	}
	return *v, true
}

// OldDingtalkOauth returns the old "dingtalk_oauth" field's value of the Setting entity.
// If the Setting object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SettingMutation) OldDingtalkOauth(ctx context.Context) (v *types.DingtalkOAuth, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDingtalkOauth is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDingtalkOauth requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDingtalkOauth: %w", err)
	}
	return oldValue.DingtalkOauth, nil
}

// ClearDingtalkOauth clears the value of the "dingtalk_oauth" field.
func (m *SettingMutation) ClearDingtalkOauth() {
	m.dingtalk_oauth = nil
	m.clearedFields[setting.FieldDingtalkOauth] = struct{}{}
}

// DingtalkOauthCleared returns if the "dingtalk_oauth" field was cleared in this mutation.
func (m *SettingMutation) DingtalkOauthCleared() bool {
	_, ok := m.clearedFields[setting.FieldDingtalkOauth]
	return ok
}

// ResetDingtalkOauth resets all changes to the "dingtalk_oauth" field.
func (m *SettingMutation) ResetDingtalkOauth() {
	m.dingtalk_oauth = nil
	delete(m.clearedFields, setting.FieldDingtalkOauth)
}

// SetCustomOauth sets the "custom_oauth" field.
func (m *SettingMutation) SetCustomOauth(to *types.CustomOAuth) {
	m.custom_oauth = &to
}

// CustomOauth returns the value of the "custom_oauth" field in the mutation.
func (m *SettingMutation) CustomOauth() (r *types.CustomOAuth, exists bool) {
	v := m.custom_oauth
	if v == nil {
		return
	}
	return *v, true
}

// OldCustomOauth returns the old "custom_oauth" field's value of the Setting entity.
// If the Setting object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SettingMutation) OldCustomOauth(ctx context.Context) (v *types.CustomOAuth, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCustomOauth is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCustomOauth requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCustomOauth: %w", err)
	}
	return oldValue.CustomOauth, nil
}

// ClearCustomOauth clears the value of the "custom_oauth" field.
func (m *SettingMutation) ClearCustomOauth() {
	m.custom_oauth = nil
	m.clearedFields[setting.FieldCustomOauth] = struct{}{}
}

// CustomOauthCleared returns if the "custom_oauth" field was cleared in this mutation.
func (m *SettingMutation) CustomOauthCleared() bool {
	_, ok := m.clearedFields[setting.FieldCustomOauth]
	return ok
}

// ResetCustomOauth resets all changes to the "custom_oauth" field.
func (m *SettingMutation) ResetCustomOauth() {
	m.custom_oauth = nil
	delete(m.clearedFields, setting.FieldCustomOauth)
}

// SetBaseURL sets the "base_url" field.
func (m *SettingMutation) SetBaseURL(s string) {
	m.base_url = &s
}

// BaseURL returns the value of the "base_url" field in the mutation.
func (m *SettingMutation) BaseURL() (r string, exists bool) {
	v := m.base_url
	if v == nil {
		return
	}
	return *v, true
}

// OldBaseURL returns the old "base_url" field's value of the Setting entity.
// If the Setting object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SettingMutation) OldBaseURL(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldBaseURL is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldBaseURL requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldBaseURL: %w", err)
	}
	return oldValue.BaseURL, nil
}

// ClearBaseURL clears the value of the "base_url" field.
func (m *SettingMutation) ClearBaseURL() {
	m.base_url = nil
	m.clearedFields[setting.FieldBaseURL] = struct{}{}
}

// BaseURLCleared returns if the "base_url" field was cleared in this mutation.
func (m *SettingMutation) BaseURLCleared() bool {
	_, ok := m.clearedFields[setting.FieldBaseURL]
	return ok
}

// ResetBaseURL resets all changes to the "base_url" field.
func (m *SettingMutation) ResetBaseURL() {
	m.base_url = nil
	delete(m.clearedFields, setting.FieldBaseURL)
}

// SetCreatedAt sets the "created_at" field.
func (m *SettingMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *SettingMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Setting entity.
// If the Setting object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SettingMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *SettingMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *SettingMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *SettingMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Setting entity.
// If the Setting object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SettingMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *SettingMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// Where appends a list predicates to the SettingMutation builder.
func (m *SettingMutation) Where(ps ...predicate.Setting) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the SettingMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *SettingMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Setting, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *SettingMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *SettingMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Setting).
func (m *SettingMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *SettingMutation) Fields() []string {
	fields := make([]string, 0, 9)
	if m.enable_sso != nil {
		fields = append(fields, setting.FieldEnableSSO)
	}
	if m.force_two_factor_auth != nil {
		fields = append(fields, setting.FieldForceTwoFactorAuth)
	}
	if m.disable_password_login != nil {
		fields = append(fields, setting.FieldDisablePasswordLogin)
	}
	if m.enable_auto_login != nil {
		fields = append(fields, setting.FieldEnableAutoLogin)
	}
	if m.dingtalk_oauth != nil {
		fields = append(fields, setting.FieldDingtalkOauth)
	}
	if m.custom_oauth != nil {
		fields = append(fields, setting.FieldCustomOauth)
	}
	if m.base_url != nil {
		fields = append(fields, setting.FieldBaseURL)
	}
	if m.created_at != nil {
		fields = append(fields, setting.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, setting.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *SettingMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case setting.FieldEnableSSO:
		return m.EnableSSO()
	case setting.FieldForceTwoFactorAuth:
		return m.ForceTwoFactorAuth()
	case setting.FieldDisablePasswordLogin:
		return m.DisablePasswordLogin()
	case setting.FieldEnableAutoLogin:
		return m.EnableAutoLogin()
	case setting.FieldDingtalkOauth:
		return m.DingtalkOauth()
	case setting.FieldCustomOauth:
		return m.CustomOauth()
	case setting.FieldBaseURL:
		return m.BaseURL()
	case setting.FieldCreatedAt:
		return m.CreatedAt()
	case setting.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *SettingMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case setting.FieldEnableSSO:
		return m.OldEnableSSO(ctx)
	case setting.FieldForceTwoFactorAuth:
		return m.OldForceTwoFactorAuth(ctx)
	case setting.FieldDisablePasswordLogin:
		return m.OldDisablePasswordLogin(ctx)
	case setting.FieldEnableAutoLogin:
		return m.OldEnableAutoLogin(ctx)
	case setting.FieldDingtalkOauth:
		return m.OldDingtalkOauth(ctx)
	case setting.FieldCustomOauth:
		return m.OldCustomOauth(ctx)
	case setting.FieldBaseURL:
		return m.OldBaseURL(ctx)
	case setting.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case setting.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Setting field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *SettingMutation) SetField(name string, value ent.Value) error {
	switch name {
	case setting.FieldEnableSSO:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEnableSSO(v)
		return nil
	case setting.FieldForceTwoFactorAuth:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetForceTwoFactorAuth(v)
		return nil
	case setting.FieldDisablePasswordLogin:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDisablePasswordLogin(v)
		return nil
	case setting.FieldEnableAutoLogin:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEnableAutoLogin(v)
		return nil
	case setting.FieldDingtalkOauth:
		v, ok := value.(*types.DingtalkOAuth)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDingtalkOauth(v)
		return nil
	case setting.FieldCustomOauth:
		v, ok := value.(*types.CustomOAuth)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCustomOauth(v)
		return nil
	case setting.FieldBaseURL:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetBaseURL(v)
		return nil
	case setting.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case setting.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Setting field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *SettingMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *SettingMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *SettingMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Setting numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *SettingMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(setting.FieldDingtalkOauth) {
		fields = append(fields, setting.FieldDingtalkOauth)
	}
	if m.FieldCleared(setting.FieldCustomOauth) {
		fields = append(fields, setting.FieldCustomOauth)
	}
	if m.FieldCleared(setting.FieldBaseURL) {
		fields = append(fields, setting.FieldBaseURL)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *SettingMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *SettingMutation) ClearField(name string) error {
	switch name {
	case setting.FieldDingtalkOauth:
		m.ClearDingtalkOauth()
		return nil
	case setting.FieldCustomOauth:
		m.ClearCustomOauth()
		return nil
	case setting.FieldBaseURL:
		m.ClearBaseURL()
		return nil
	}
	return fmt.Errorf("unknown Setting nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *SettingMutation) ResetField(name string) error {
	switch name {
	case setting.FieldEnableSSO:
		m.ResetEnableSSO()
		return nil
	case setting.FieldForceTwoFactorAuth:
		m.ResetForceTwoFactorAuth()
		return nil
	case setting.FieldDisablePasswordLogin:
		m.ResetDisablePasswordLogin()
		return nil
	case setting.FieldEnableAutoLogin:
		m.ResetEnableAutoLogin()
		return nil
	case setting.FieldDingtalkOauth:
		m.ResetDingtalkOauth()
		return nil
	case setting.FieldCustomOauth:
		m.ResetCustomOauth()
		return nil
	case setting.FieldBaseURL:
		m.ResetBaseURL()
		return nil
	case setting.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case setting.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown Setting field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *SettingMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *SettingMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *SettingMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *SettingMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *SettingMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *SettingMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *SettingMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Setting unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *SettingMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Setting edge %s", name)
}

// TaskMutation represents an operation that mutates the Task nodes in the graph.
type TaskMutation struct {
	config
	op                  Op
	typ                 string
	id                  *uuid.UUID
	task_id             *string
	request_id          *string
	model_type          *consts.ModelType
	is_accept           *bool
	program_language    *string
	work_mode           *string
	prompt              *string
	completion          *string
	code_lines          *int64
	addcode_lines       *int64
	input_tokens        *int64
	addinput_tokens     *int64
	output_tokens       *int64
	addoutput_tokens    *int64
	is_suggested        *bool
	source_code         *string
	cursor_position     *map[string]interface{}
	user_input          *string
	created_at          *time.Time
	updated_at          *time.Time
	clearedFields       map[string]struct{}
	task_records        map[uuid.UUID]struct{}
	removedtask_records map[uuid.UUID]struct{}
	clearedtask_records bool
	user                *uuid.UUID
	cleareduser         bool
	model               *uuid.UUID
	clearedmodel        bool
	done                bool
	oldValue            func(context.Context) (*Task, error)
	predicates          []predicate.Task
}

var _ ent.Mutation = (*TaskMutation)(nil)

// taskOption allows management of the mutation configuration using functional options.
type taskOption func(*TaskMutation)

// newTaskMutation creates new mutation for the Task entity.
func newTaskMutation(c config, op Op, opts ...taskOption) *TaskMutation {
	m := &TaskMutation{
		config:        c,
		op:            op,
		typ:           TypeTask,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withTaskID sets the ID field of the mutation.
func withTaskID(id uuid.UUID) taskOption {
	return func(m *TaskMutation) {
		var (
			err   error
			once  sync.Once
			value *Task
		)
		m.oldValue = func(ctx context.Context) (*Task, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Task.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withTask sets the old Task of the mutation.
func withTask(node *Task) taskOption {
	return func(m *TaskMutation) {
		m.oldValue = func(context.Context) (*Task, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m TaskMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m TaskMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Task entities.
func (m *TaskMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *TaskMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *TaskMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Task.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetTaskID sets the "task_id" field.
func (m *TaskMutation) SetTaskID(s string) {
	m.task_id = &s
}

// TaskID returns the value of the "task_id" field in the mutation.
func (m *TaskMutation) TaskID() (r string, exists bool) {
	v := m.task_id
	if v == nil {
		return
	}
	return *v, true
}

// OldTaskID returns the old "task_id" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldTaskID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldTaskID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldTaskID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldTaskID: %w", err)
	}
	return oldValue.TaskID, nil
}

// ResetTaskID resets all changes to the "task_id" field.
func (m *TaskMutation) ResetTaskID() {
	m.task_id = nil
}

// SetUserID sets the "user_id" field.
func (m *TaskMutation) SetUserID(u uuid.UUID) {
	m.user = &u
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *TaskMutation) UserID() (r uuid.UUID, exists bool) {
	v := m.user
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldUserID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ClearUserID clears the value of the "user_id" field.
func (m *TaskMutation) ClearUserID() {
	m.user = nil
	m.clearedFields[task.FieldUserID] = struct{}{}
}

// UserIDCleared returns if the "user_id" field was cleared in this mutation.
func (m *TaskMutation) UserIDCleared() bool {
	_, ok := m.clearedFields[task.FieldUserID]
	return ok
}

// ResetUserID resets all changes to the "user_id" field.
func (m *TaskMutation) ResetUserID() {
	m.user = nil
	delete(m.clearedFields, task.FieldUserID)
}

// SetModelID sets the "model_id" field.
func (m *TaskMutation) SetModelID(u uuid.UUID) {
	m.model = &u
}

// ModelID returns the value of the "model_id" field in the mutation.
func (m *TaskMutation) ModelID() (r uuid.UUID, exists bool) {
	v := m.model
	if v == nil {
		return
	}
	return *v, true
}

// OldModelID returns the old "model_id" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldModelID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldModelID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldModelID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldModelID: %w", err)
	}
	return oldValue.ModelID, nil
}

// ClearModelID clears the value of the "model_id" field.
func (m *TaskMutation) ClearModelID() {
	m.model = nil
	m.clearedFields[task.FieldModelID] = struct{}{}
}

// ModelIDCleared returns if the "model_id" field was cleared in this mutation.
func (m *TaskMutation) ModelIDCleared() bool {
	_, ok := m.clearedFields[task.FieldModelID]
	return ok
}

// ResetModelID resets all changes to the "model_id" field.
func (m *TaskMutation) ResetModelID() {
	m.model = nil
	delete(m.clearedFields, task.FieldModelID)
}

// SetRequestID sets the "request_id" field.
func (m *TaskMutation) SetRequestID(s string) {
	m.request_id = &s
}

// RequestID returns the value of the "request_id" field in the mutation.
func (m *TaskMutation) RequestID() (r string, exists bool) {
	v := m.request_id
	if v == nil {
		return
	}
	return *v, true
}

// OldRequestID returns the old "request_id" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldRequestID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRequestID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRequestID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRequestID: %w", err)
	}
	return oldValue.RequestID, nil
}

// ClearRequestID clears the value of the "request_id" field.
func (m *TaskMutation) ClearRequestID() {
	m.request_id = nil
	m.clearedFields[task.FieldRequestID] = struct{}{}
}

// RequestIDCleared returns if the "request_id" field was cleared in this mutation.
func (m *TaskMutation) RequestIDCleared() bool {
	_, ok := m.clearedFields[task.FieldRequestID]
	return ok
}

// ResetRequestID resets all changes to the "request_id" field.
func (m *TaskMutation) ResetRequestID() {
	m.request_id = nil
	delete(m.clearedFields, task.FieldRequestID)
}

// SetModelType sets the "model_type" field.
func (m *TaskMutation) SetModelType(ct consts.ModelType) {
	m.model_type = &ct
}

// ModelType returns the value of the "model_type" field in the mutation.
func (m *TaskMutation) ModelType() (r consts.ModelType, exists bool) {
	v := m.model_type
	if v == nil {
		return
	}
	return *v, true
}

// OldModelType returns the old "model_type" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldModelType(ctx context.Context) (v consts.ModelType, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldModelType is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldModelType requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldModelType: %w", err)
	}
	return oldValue.ModelType, nil
}

// ResetModelType resets all changes to the "model_type" field.
func (m *TaskMutation) ResetModelType() {
	m.model_type = nil
}

// SetIsAccept sets the "is_accept" field.
func (m *TaskMutation) SetIsAccept(b bool) {
	m.is_accept = &b
}

// IsAccept returns the value of the "is_accept" field in the mutation.
func (m *TaskMutation) IsAccept() (r bool, exists bool) {
	v := m.is_accept
	if v == nil {
		return
	}
	return *v, true
}

// OldIsAccept returns the old "is_accept" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldIsAccept(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldIsAccept is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldIsAccept requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldIsAccept: %w", err)
	}
	return oldValue.IsAccept, nil
}

// ResetIsAccept resets all changes to the "is_accept" field.
func (m *TaskMutation) ResetIsAccept() {
	m.is_accept = nil
}

// SetProgramLanguage sets the "program_language" field.
func (m *TaskMutation) SetProgramLanguage(s string) {
	m.program_language = &s
}

// ProgramLanguage returns the value of the "program_language" field in the mutation.
func (m *TaskMutation) ProgramLanguage() (r string, exists bool) {
	v := m.program_language
	if v == nil {
		return
	}
	return *v, true
}

// OldProgramLanguage returns the old "program_language" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldProgramLanguage(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldProgramLanguage is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldProgramLanguage requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldProgramLanguage: %w", err)
	}
	return oldValue.ProgramLanguage, nil
}

// ClearProgramLanguage clears the value of the "program_language" field.
func (m *TaskMutation) ClearProgramLanguage() {
	m.program_language = nil
	m.clearedFields[task.FieldProgramLanguage] = struct{}{}
}

// ProgramLanguageCleared returns if the "program_language" field was cleared in this mutation.
func (m *TaskMutation) ProgramLanguageCleared() bool {
	_, ok := m.clearedFields[task.FieldProgramLanguage]
	return ok
}

// ResetProgramLanguage resets all changes to the "program_language" field.
func (m *TaskMutation) ResetProgramLanguage() {
	m.program_language = nil
	delete(m.clearedFields, task.FieldProgramLanguage)
}

// SetWorkMode sets the "work_mode" field.
func (m *TaskMutation) SetWorkMode(s string) {
	m.work_mode = &s
}

// WorkMode returns the value of the "work_mode" field in the mutation.
func (m *TaskMutation) WorkMode() (r string, exists bool) {
	v := m.work_mode
	if v == nil {
		return
	}
	return *v, true
}

// OldWorkMode returns the old "work_mode" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldWorkMode(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldWorkMode is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldWorkMode requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldWorkMode: %w", err)
	}
	return oldValue.WorkMode, nil
}

// ClearWorkMode clears the value of the "work_mode" field.
func (m *TaskMutation) ClearWorkMode() {
	m.work_mode = nil
	m.clearedFields[task.FieldWorkMode] = struct{}{}
}

// WorkModeCleared returns if the "work_mode" field was cleared in this mutation.
func (m *TaskMutation) WorkModeCleared() bool {
	_, ok := m.clearedFields[task.FieldWorkMode]
	return ok
}

// ResetWorkMode resets all changes to the "work_mode" field.
func (m *TaskMutation) ResetWorkMode() {
	m.work_mode = nil
	delete(m.clearedFields, task.FieldWorkMode)
}

// SetPrompt sets the "prompt" field.
func (m *TaskMutation) SetPrompt(s string) {
	m.prompt = &s
}

// Prompt returns the value of the "prompt" field in the mutation.
func (m *TaskMutation) Prompt() (r string, exists bool) {
	v := m.prompt
	if v == nil {
		return
	}
	return *v, true
}

// OldPrompt returns the old "prompt" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldPrompt(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPrompt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPrompt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPrompt: %w", err)
	}
	return oldValue.Prompt, nil
}

// ClearPrompt clears the value of the "prompt" field.
func (m *TaskMutation) ClearPrompt() {
	m.prompt = nil
	m.clearedFields[task.FieldPrompt] = struct{}{}
}

// PromptCleared returns if the "prompt" field was cleared in this mutation.
func (m *TaskMutation) PromptCleared() bool {
	_, ok := m.clearedFields[task.FieldPrompt]
	return ok
}

// ResetPrompt resets all changes to the "prompt" field.
func (m *TaskMutation) ResetPrompt() {
	m.prompt = nil
	delete(m.clearedFields, task.FieldPrompt)
}

// SetCompletion sets the "completion" field.
func (m *TaskMutation) SetCompletion(s string) {
	m.completion = &s
}

// Completion returns the value of the "completion" field in the mutation.
func (m *TaskMutation) Completion() (r string, exists bool) {
	v := m.completion
	if v == nil {
		return
	}
	return *v, true
}

// OldCompletion returns the old "completion" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldCompletion(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCompletion is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCompletion requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCompletion: %w", err)
	}
	return oldValue.Completion, nil
}

// ClearCompletion clears the value of the "completion" field.
func (m *TaskMutation) ClearCompletion() {
	m.completion = nil
	m.clearedFields[task.FieldCompletion] = struct{}{}
}

// CompletionCleared returns if the "completion" field was cleared in this mutation.
func (m *TaskMutation) CompletionCleared() bool {
	_, ok := m.clearedFields[task.FieldCompletion]
	return ok
}

// ResetCompletion resets all changes to the "completion" field.
func (m *TaskMutation) ResetCompletion() {
	m.completion = nil
	delete(m.clearedFields, task.FieldCompletion)
}

// SetCodeLines sets the "code_lines" field.
func (m *TaskMutation) SetCodeLines(i int64) {
	m.code_lines = &i
	m.addcode_lines = nil
}

// CodeLines returns the value of the "code_lines" field in the mutation.
func (m *TaskMutation) CodeLines() (r int64, exists bool) {
	v := m.code_lines
	if v == nil {
		return
	}
	return *v, true
}

// OldCodeLines returns the old "code_lines" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldCodeLines(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCodeLines is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCodeLines requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCodeLines: %w", err)
	}
	return oldValue.CodeLines, nil
}

// AddCodeLines adds i to the "code_lines" field.
func (m *TaskMutation) AddCodeLines(i int64) {
	if m.addcode_lines != nil {
		*m.addcode_lines += i
	} else {
		m.addcode_lines = &i
	}
}

// AddedCodeLines returns the value that was added to the "code_lines" field in this mutation.
func (m *TaskMutation) AddedCodeLines() (r int64, exists bool) {
	v := m.addcode_lines
	if v == nil {
		return
	}
	return *v, true
}

// ClearCodeLines clears the value of the "code_lines" field.
func (m *TaskMutation) ClearCodeLines() {
	m.code_lines = nil
	m.addcode_lines = nil
	m.clearedFields[task.FieldCodeLines] = struct{}{}
}

// CodeLinesCleared returns if the "code_lines" field was cleared in this mutation.
func (m *TaskMutation) CodeLinesCleared() bool {
	_, ok := m.clearedFields[task.FieldCodeLines]
	return ok
}

// ResetCodeLines resets all changes to the "code_lines" field.
func (m *TaskMutation) ResetCodeLines() {
	m.code_lines = nil
	m.addcode_lines = nil
	delete(m.clearedFields, task.FieldCodeLines)
}

// SetInputTokens sets the "input_tokens" field.
func (m *TaskMutation) SetInputTokens(i int64) {
	m.input_tokens = &i
	m.addinput_tokens = nil
}

// InputTokens returns the value of the "input_tokens" field in the mutation.
func (m *TaskMutation) InputTokens() (r int64, exists bool) {
	v := m.input_tokens
	if v == nil {
		return
	}
	return *v, true
}

// OldInputTokens returns the old "input_tokens" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldInputTokens(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldInputTokens is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldInputTokens requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldInputTokens: %w", err)
	}
	return oldValue.InputTokens, nil
}

// AddInputTokens adds i to the "input_tokens" field.
func (m *TaskMutation) AddInputTokens(i int64) {
	if m.addinput_tokens != nil {
		*m.addinput_tokens += i
	} else {
		m.addinput_tokens = &i
	}
}

// AddedInputTokens returns the value that was added to the "input_tokens" field in this mutation.
func (m *TaskMutation) AddedInputTokens() (r int64, exists bool) {
	v := m.addinput_tokens
	if v == nil {
		return
	}
	return *v, true
}

// ClearInputTokens clears the value of the "input_tokens" field.
func (m *TaskMutation) ClearInputTokens() {
	m.input_tokens = nil
	m.addinput_tokens = nil
	m.clearedFields[task.FieldInputTokens] = struct{}{}
}

// InputTokensCleared returns if the "input_tokens" field was cleared in this mutation.
func (m *TaskMutation) InputTokensCleared() bool {
	_, ok := m.clearedFields[task.FieldInputTokens]
	return ok
}

// ResetInputTokens resets all changes to the "input_tokens" field.
func (m *TaskMutation) ResetInputTokens() {
	m.input_tokens = nil
	m.addinput_tokens = nil
	delete(m.clearedFields, task.FieldInputTokens)
}

// SetOutputTokens sets the "output_tokens" field.
func (m *TaskMutation) SetOutputTokens(i int64) {
	m.output_tokens = &i
	m.addoutput_tokens = nil
}

// OutputTokens returns the value of the "output_tokens" field in the mutation.
func (m *TaskMutation) OutputTokens() (r int64, exists bool) {
	v := m.output_tokens
	if v == nil {
		return
	}
	return *v, true
}

// OldOutputTokens returns the old "output_tokens" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldOutputTokens(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOutputTokens is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOutputTokens requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOutputTokens: %w", err)
	}
	return oldValue.OutputTokens, nil
}

// AddOutputTokens adds i to the "output_tokens" field.
func (m *TaskMutation) AddOutputTokens(i int64) {
	if m.addoutput_tokens != nil {
		*m.addoutput_tokens += i
	} else {
		m.addoutput_tokens = &i
	}
}

// AddedOutputTokens returns the value that was added to the "output_tokens" field in this mutation.
func (m *TaskMutation) AddedOutputTokens() (r int64, exists bool) {
	v := m.addoutput_tokens
	if v == nil {
		return
	}
	return *v, true
}

// ClearOutputTokens clears the value of the "output_tokens" field.
func (m *TaskMutation) ClearOutputTokens() {
	m.output_tokens = nil
	m.addoutput_tokens = nil
	m.clearedFields[task.FieldOutputTokens] = struct{}{}
}

// OutputTokensCleared returns if the "output_tokens" field was cleared in this mutation.
func (m *TaskMutation) OutputTokensCleared() bool {
	_, ok := m.clearedFields[task.FieldOutputTokens]
	return ok
}

// ResetOutputTokens resets all changes to the "output_tokens" field.
func (m *TaskMutation) ResetOutputTokens() {
	m.output_tokens = nil
	m.addoutput_tokens = nil
	delete(m.clearedFields, task.FieldOutputTokens)
}

// SetIsSuggested sets the "is_suggested" field.
func (m *TaskMutation) SetIsSuggested(b bool) {
	m.is_suggested = &b
}

// IsSuggested returns the value of the "is_suggested" field in the mutation.
func (m *TaskMutation) IsSuggested() (r bool, exists bool) {
	v := m.is_suggested
	if v == nil {
		return
	}
	return *v, true
}

// OldIsSuggested returns the old "is_suggested" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldIsSuggested(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldIsSuggested is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldIsSuggested requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldIsSuggested: %w", err)
	}
	return oldValue.IsSuggested, nil
}

// ResetIsSuggested resets all changes to the "is_suggested" field.
func (m *TaskMutation) ResetIsSuggested() {
	m.is_suggested = nil
}

// SetSourceCode sets the "source_code" field.
func (m *TaskMutation) SetSourceCode(s string) {
	m.source_code = &s
}

// SourceCode returns the value of the "source_code" field in the mutation.
func (m *TaskMutation) SourceCode() (r string, exists bool) {
	v := m.source_code
	if v == nil {
		return
	}
	return *v, true
}

// OldSourceCode returns the old "source_code" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldSourceCode(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSourceCode is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSourceCode requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSourceCode: %w", err)
	}
	return oldValue.SourceCode, nil
}

// ClearSourceCode clears the value of the "source_code" field.
func (m *TaskMutation) ClearSourceCode() {
	m.source_code = nil
	m.clearedFields[task.FieldSourceCode] = struct{}{}
}

// SourceCodeCleared returns if the "source_code" field was cleared in this mutation.
func (m *TaskMutation) SourceCodeCleared() bool {
	_, ok := m.clearedFields[task.FieldSourceCode]
	return ok
}

// ResetSourceCode resets all changes to the "source_code" field.
func (m *TaskMutation) ResetSourceCode() {
	m.source_code = nil
	delete(m.clearedFields, task.FieldSourceCode)
}

// SetCursorPosition sets the "cursor_position" field.
func (m *TaskMutation) SetCursorPosition(value map[string]interface{}) {
	m.cursor_position = &value
}

// CursorPosition returns the value of the "cursor_position" field in the mutation.
func (m *TaskMutation) CursorPosition() (r map[string]interface{}, exists bool) {
	v := m.cursor_position
	if v == nil {
		return
	}
	return *v, true
}

// OldCursorPosition returns the old "cursor_position" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldCursorPosition(ctx context.Context) (v map[string]interface{}, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCursorPosition is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCursorPosition requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCursorPosition: %w", err)
	}
	return oldValue.CursorPosition, nil
}

// ClearCursorPosition clears the value of the "cursor_position" field.
func (m *TaskMutation) ClearCursorPosition() {
	m.cursor_position = nil
	m.clearedFields[task.FieldCursorPosition] = struct{}{}
}

// CursorPositionCleared returns if the "cursor_position" field was cleared in this mutation.
func (m *TaskMutation) CursorPositionCleared() bool {
	_, ok := m.clearedFields[task.FieldCursorPosition]
	return ok
}

// ResetCursorPosition resets all changes to the "cursor_position" field.
func (m *TaskMutation) ResetCursorPosition() {
	m.cursor_position = nil
	delete(m.clearedFields, task.FieldCursorPosition)
}

// SetUserInput sets the "user_input" field.
func (m *TaskMutation) SetUserInput(s string) {
	m.user_input = &s
}

// UserInput returns the value of the "user_input" field in the mutation.
func (m *TaskMutation) UserInput() (r string, exists bool) {
	v := m.user_input
	if v == nil {
		return
	}
	return *v, true
}

// OldUserInput returns the old "user_input" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldUserInput(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserInput is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserInput requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserInput: %w", err)
	}
	return oldValue.UserInput, nil
}

// ClearUserInput clears the value of the "user_input" field.
func (m *TaskMutation) ClearUserInput() {
	m.user_input = nil
	m.clearedFields[task.FieldUserInput] = struct{}{}
}

// UserInputCleared returns if the "user_input" field was cleared in this mutation.
func (m *TaskMutation) UserInputCleared() bool {
	_, ok := m.clearedFields[task.FieldUserInput]
	return ok
}

// ResetUserInput resets all changes to the "user_input" field.
func (m *TaskMutation) ResetUserInput() {
	m.user_input = nil
	delete(m.clearedFields, task.FieldUserInput)
}

// SetCreatedAt sets the "created_at" field.
func (m *TaskMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *TaskMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *TaskMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *TaskMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *TaskMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *TaskMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// AddTaskRecordIDs adds the "task_records" edge to the TaskRecord entity by ids.
func (m *TaskMutation) AddTaskRecordIDs(ids ...uuid.UUID) {
	if m.task_records == nil {
		m.task_records = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.task_records[ids[i]] = struct{}{}
	}
}

// ClearTaskRecords clears the "task_records" edge to the TaskRecord entity.
func (m *TaskMutation) ClearTaskRecords() {
	m.clearedtask_records = true
}

// TaskRecordsCleared reports if the "task_records" edge to the TaskRecord entity was cleared.
func (m *TaskMutation) TaskRecordsCleared() bool {
	return m.clearedtask_records
}

// RemoveTaskRecordIDs removes the "task_records" edge to the TaskRecord entity by IDs.
func (m *TaskMutation) RemoveTaskRecordIDs(ids ...uuid.UUID) {
	if m.removedtask_records == nil {
		m.removedtask_records = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.task_records, ids[i])
		m.removedtask_records[ids[i]] = struct{}{}
	}
}

// RemovedTaskRecords returns the removed IDs of the "task_records" edge to the TaskRecord entity.
func (m *TaskMutation) RemovedTaskRecordsIDs() (ids []uuid.UUID) {
	for id := range m.removedtask_records {
		ids = append(ids, id)
	}
	return
}

// TaskRecordsIDs returns the "task_records" edge IDs in the mutation.
func (m *TaskMutation) TaskRecordsIDs() (ids []uuid.UUID) {
	for id := range m.task_records {
		ids = append(ids, id)
	}
	return
}

// ResetTaskRecords resets all changes to the "task_records" edge.
func (m *TaskMutation) ResetTaskRecords() {
	m.task_records = nil
	m.clearedtask_records = false
	m.removedtask_records = nil
}

// ClearUser clears the "user" edge to the User entity.
func (m *TaskMutation) ClearUser() {
	m.cleareduser = true
	m.clearedFields[task.FieldUserID] = struct{}{}
}

// UserCleared reports if the "user" edge to the User entity was cleared.
func (m *TaskMutation) UserCleared() bool {
	return m.UserIDCleared() || m.cleareduser
}

// UserIDs returns the "user" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserID instead. It exists only for internal usage by the builders.
func (m *TaskMutation) UserIDs() (ids []uuid.UUID) {
	if id := m.user; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUser resets all changes to the "user" edge.
func (m *TaskMutation) ResetUser() {
	m.user = nil
	m.cleareduser = false
}

// ClearModel clears the "model" edge to the Model entity.
func (m *TaskMutation) ClearModel() {
	m.clearedmodel = true
	m.clearedFields[task.FieldModelID] = struct{}{}
}

// ModelCleared reports if the "model" edge to the Model entity was cleared.
func (m *TaskMutation) ModelCleared() bool {
	return m.ModelIDCleared() || m.clearedmodel
}

// ModelIDs returns the "model" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// ModelID instead. It exists only for internal usage by the builders.
func (m *TaskMutation) ModelIDs() (ids []uuid.UUID) {
	if id := m.model; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetModel resets all changes to the "model" edge.
func (m *TaskMutation) ResetModel() {
	m.model = nil
	m.clearedmodel = false
}

// Where appends a list predicates to the TaskMutation builder.
func (m *TaskMutation) Where(ps ...predicate.Task) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the TaskMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *TaskMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Task, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *TaskMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *TaskMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Task).
func (m *TaskMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *TaskMutation) Fields() []string {
	fields := make([]string, 0, 19)
	if m.task_id != nil {
		fields = append(fields, task.FieldTaskID)
	}
	if m.user != nil {
		fields = append(fields, task.FieldUserID)
	}
	if m.model != nil {
		fields = append(fields, task.FieldModelID)
	}
	if m.request_id != nil {
		fields = append(fields, task.FieldRequestID)
	}
	if m.model_type != nil {
		fields = append(fields, task.FieldModelType)
	}
	if m.is_accept != nil {
		fields = append(fields, task.FieldIsAccept)
	}
	if m.program_language != nil {
		fields = append(fields, task.FieldProgramLanguage)
	}
	if m.work_mode != nil {
		fields = append(fields, task.FieldWorkMode)
	}
	if m.prompt != nil {
		fields = append(fields, task.FieldPrompt)
	}
	if m.completion != nil {
		fields = append(fields, task.FieldCompletion)
	}
	if m.code_lines != nil {
		fields = append(fields, task.FieldCodeLines)
	}
	if m.input_tokens != nil {
		fields = append(fields, task.FieldInputTokens)
	}
	if m.output_tokens != nil {
		fields = append(fields, task.FieldOutputTokens)
	}
	if m.is_suggested != nil {
		fields = append(fields, task.FieldIsSuggested)
	}
	if m.source_code != nil {
		fields = append(fields, task.FieldSourceCode)
	}
	if m.cursor_position != nil {
		fields = append(fields, task.FieldCursorPosition)
	}
	if m.user_input != nil {
		fields = append(fields, task.FieldUserInput)
	}
	if m.created_at != nil {
		fields = append(fields, task.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, task.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *TaskMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case task.FieldTaskID:
		return m.TaskID()
	case task.FieldUserID:
		return m.UserID()
	case task.FieldModelID:
		return m.ModelID()
	case task.FieldRequestID:
		return m.RequestID()
	case task.FieldModelType:
		return m.ModelType()
	case task.FieldIsAccept:
		return m.IsAccept()
	case task.FieldProgramLanguage:
		return m.ProgramLanguage()
	case task.FieldWorkMode:
		return m.WorkMode()
	case task.FieldPrompt:
		return m.Prompt()
	case task.FieldCompletion:
		return m.Completion()
	case task.FieldCodeLines:
		return m.CodeLines()
	case task.FieldInputTokens:
		return m.InputTokens()
	case task.FieldOutputTokens:
		return m.OutputTokens()
	case task.FieldIsSuggested:
		return m.IsSuggested()
	case task.FieldSourceCode:
		return m.SourceCode()
	case task.FieldCursorPosition:
		return m.CursorPosition()
	case task.FieldUserInput:
		return m.UserInput()
	case task.FieldCreatedAt:
		return m.CreatedAt()
	case task.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *TaskMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case task.FieldTaskID:
		return m.OldTaskID(ctx)
	case task.FieldUserID:
		return m.OldUserID(ctx)
	case task.FieldModelID:
		return m.OldModelID(ctx)
	case task.FieldRequestID:
		return m.OldRequestID(ctx)
	case task.FieldModelType:
		return m.OldModelType(ctx)
	case task.FieldIsAccept:
		return m.OldIsAccept(ctx)
	case task.FieldProgramLanguage:
		return m.OldProgramLanguage(ctx)
	case task.FieldWorkMode:
		return m.OldWorkMode(ctx)
	case task.FieldPrompt:
		return m.OldPrompt(ctx)
	case task.FieldCompletion:
		return m.OldCompletion(ctx)
	case task.FieldCodeLines:
		return m.OldCodeLines(ctx)
	case task.FieldInputTokens:
		return m.OldInputTokens(ctx)
	case task.FieldOutputTokens:
		return m.OldOutputTokens(ctx)
	case task.FieldIsSuggested:
		return m.OldIsSuggested(ctx)
	case task.FieldSourceCode:
		return m.OldSourceCode(ctx)
	case task.FieldCursorPosition:
		return m.OldCursorPosition(ctx)
	case task.FieldUserInput:
		return m.OldUserInput(ctx)
	case task.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case task.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Task field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *TaskMutation) SetField(name string, value ent.Value) error {
	switch name {
	case task.FieldTaskID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetTaskID(v)
		return nil
	case task.FieldUserID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case task.FieldModelID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetModelID(v)
		return nil
	case task.FieldRequestID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRequestID(v)
		return nil
	case task.FieldModelType:
		v, ok := value.(consts.ModelType)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetModelType(v)
		return nil
	case task.FieldIsAccept:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetIsAccept(v)
		return nil
	case task.FieldProgramLanguage:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetProgramLanguage(v)
		return nil
	case task.FieldWorkMode:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetWorkMode(v)
		return nil
	case task.FieldPrompt:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPrompt(v)
		return nil
	case task.FieldCompletion:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCompletion(v)
		return nil
	case task.FieldCodeLines:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCodeLines(v)
		return nil
	case task.FieldInputTokens:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetInputTokens(v)
		return nil
	case task.FieldOutputTokens:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOutputTokens(v)
		return nil
	case task.FieldIsSuggested:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetIsSuggested(v)
		return nil
	case task.FieldSourceCode:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSourceCode(v)
		return nil
	case task.FieldCursorPosition:
		v, ok := value.(map[string]interface{})
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCursorPosition(v)
		return nil
	case task.FieldUserInput:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserInput(v)
		return nil
	case task.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case task.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Task field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *TaskMutation) AddedFields() []string {
	var fields []string
	if m.addcode_lines != nil {
		fields = append(fields, task.FieldCodeLines)
	}
	if m.addinput_tokens != nil {
		fields = append(fields, task.FieldInputTokens)
	}
	if m.addoutput_tokens != nil {
		fields = append(fields, task.FieldOutputTokens)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *TaskMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case task.FieldCodeLines:
		return m.AddedCodeLines()
	case task.FieldInputTokens:
		return m.AddedInputTokens()
	case task.FieldOutputTokens:
		return m.AddedOutputTokens()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *TaskMutation) AddField(name string, value ent.Value) error {
	switch name {
	case task.FieldCodeLines:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddCodeLines(v)
		return nil
	case task.FieldInputTokens:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddInputTokens(v)
		return nil
	case task.FieldOutputTokens:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOutputTokens(v)
		return nil
	}
	return fmt.Errorf("unknown Task numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *TaskMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(task.FieldUserID) {
		fields = append(fields, task.FieldUserID)
	}
	if m.FieldCleared(task.FieldModelID) {
		fields = append(fields, task.FieldModelID)
	}
	if m.FieldCleared(task.FieldRequestID) {
		fields = append(fields, task.FieldRequestID)
	}
	if m.FieldCleared(task.FieldProgramLanguage) {
		fields = append(fields, task.FieldProgramLanguage)
	}
	if m.FieldCleared(task.FieldWorkMode) {
		fields = append(fields, task.FieldWorkMode)
	}
	if m.FieldCleared(task.FieldPrompt) {
		fields = append(fields, task.FieldPrompt)
	}
	if m.FieldCleared(task.FieldCompletion) {
		fields = append(fields, task.FieldCompletion)
	}
	if m.FieldCleared(task.FieldCodeLines) {
		fields = append(fields, task.FieldCodeLines)
	}
	if m.FieldCleared(task.FieldInputTokens) {
		fields = append(fields, task.FieldInputTokens)
	}
	if m.FieldCleared(task.FieldOutputTokens) {
		fields = append(fields, task.FieldOutputTokens)
	}
	if m.FieldCleared(task.FieldSourceCode) {
		fields = append(fields, task.FieldSourceCode)
	}
	if m.FieldCleared(task.FieldCursorPosition) {
		fields = append(fields, task.FieldCursorPosition)
	}
	if m.FieldCleared(task.FieldUserInput) {
		fields = append(fields, task.FieldUserInput)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *TaskMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *TaskMutation) ClearField(name string) error {
	switch name {
	case task.FieldUserID:
		m.ClearUserID()
		return nil
	case task.FieldModelID:
		m.ClearModelID()
		return nil
	case task.FieldRequestID:
		m.ClearRequestID()
		return nil
	case task.FieldProgramLanguage:
		m.ClearProgramLanguage()
		return nil
	case task.FieldWorkMode:
		m.ClearWorkMode()
		return nil
	case task.FieldPrompt:
		m.ClearPrompt()
		return nil
	case task.FieldCompletion:
		m.ClearCompletion()
		return nil
	case task.FieldCodeLines:
		m.ClearCodeLines()
		return nil
	case task.FieldInputTokens:
		m.ClearInputTokens()
		return nil
	case task.FieldOutputTokens:
		m.ClearOutputTokens()
		return nil
	case task.FieldSourceCode:
		m.ClearSourceCode()
		return nil
	case task.FieldCursorPosition:
		m.ClearCursorPosition()
		return nil
	case task.FieldUserInput:
		m.ClearUserInput()
		return nil
	}
	return fmt.Errorf("unknown Task nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *TaskMutation) ResetField(name string) error {
	switch name {
	case task.FieldTaskID:
		m.ResetTaskID()
		return nil
	case task.FieldUserID:
		m.ResetUserID()
		return nil
	case task.FieldModelID:
		m.ResetModelID()
		return nil
	case task.FieldRequestID:
		m.ResetRequestID()
		return nil
	case task.FieldModelType:
		m.ResetModelType()
		return nil
	case task.FieldIsAccept:
		m.ResetIsAccept()
		return nil
	case task.FieldProgramLanguage:
		m.ResetProgramLanguage()
		return nil
	case task.FieldWorkMode:
		m.ResetWorkMode()
		return nil
	case task.FieldPrompt:
		m.ResetPrompt()
		return nil
	case task.FieldCompletion:
		m.ResetCompletion()
		return nil
	case task.FieldCodeLines:
		m.ResetCodeLines()
		return nil
	case task.FieldInputTokens:
		m.ResetInputTokens()
		return nil
	case task.FieldOutputTokens:
		m.ResetOutputTokens()
		return nil
	case task.FieldIsSuggested:
		m.ResetIsSuggested()
		return nil
	case task.FieldSourceCode:
		m.ResetSourceCode()
		return nil
	case task.FieldCursorPosition:
		m.ResetCursorPosition()
		return nil
	case task.FieldUserInput:
		m.ResetUserInput()
		return nil
	case task.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case task.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown Task field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *TaskMutation) AddedEdges() []string {
	edges := make([]string, 0, 3)
	if m.task_records != nil {
		edges = append(edges, task.EdgeTaskRecords)
	}
	if m.user != nil {
		edges = append(edges, task.EdgeUser)
	}
	if m.model != nil {
		edges = append(edges, task.EdgeModel)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *TaskMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case task.EdgeTaskRecords:
		ids := make([]ent.Value, 0, len(m.task_records))
		for id := range m.task_records {
			ids = append(ids, id)
		}
		return ids
	case task.EdgeUser:
		if id := m.user; id != nil {
			return []ent.Value{*id}
		}
	case task.EdgeModel:
		if id := m.model; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *TaskMutation) RemovedEdges() []string {
	edges := make([]string, 0, 3)
	if m.removedtask_records != nil {
		edges = append(edges, task.EdgeTaskRecords)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *TaskMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case task.EdgeTaskRecords:
		ids := make([]ent.Value, 0, len(m.removedtask_records))
		for id := range m.removedtask_records {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *TaskMutation) ClearedEdges() []string {
	edges := make([]string, 0, 3)
	if m.clearedtask_records {
		edges = append(edges, task.EdgeTaskRecords)
	}
	if m.cleareduser {
		edges = append(edges, task.EdgeUser)
	}
	if m.clearedmodel {
		edges = append(edges, task.EdgeModel)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *TaskMutation) EdgeCleared(name string) bool {
	switch name {
	case task.EdgeTaskRecords:
		return m.clearedtask_records
	case task.EdgeUser:
		return m.cleareduser
	case task.EdgeModel:
		return m.clearedmodel
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *TaskMutation) ClearEdge(name string) error {
	switch name {
	case task.EdgeUser:
		m.ClearUser()
		return nil
	case task.EdgeModel:
		m.ClearModel()
		return nil
	}
	return fmt.Errorf("unknown Task unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *TaskMutation) ResetEdge(name string) error {
	switch name {
	case task.EdgeTaskRecords:
		m.ResetTaskRecords()
		return nil
	case task.EdgeUser:
		m.ResetUser()
		return nil
	case task.EdgeModel:
		m.ResetModel()
		return nil
	}
	return fmt.Errorf("unknown Task edge %s", name)
}

// TaskRecordMutation represents an operation that mutates the TaskRecord nodes in the graph.
type TaskRecordMutation struct {
	config
	op               Op
	typ              string
	id               *uuid.UUID
	prompt           *string
	role             *consts.ChatRole
	completion       *string
	output_tokens    *int64
	addoutput_tokens *int64
	code_lines       *int64
	addcode_lines    *int64
	code             *string
	created_at       *time.Time
	updated_at       *time.Time
	clearedFields    map[string]struct{}
	task             *uuid.UUID
	clearedtask      bool
	done             bool
	oldValue         func(context.Context) (*TaskRecord, error)
	predicates       []predicate.TaskRecord
}

var _ ent.Mutation = (*TaskRecordMutation)(nil)

// taskrecordOption allows management of the mutation configuration using functional options.
type taskrecordOption func(*TaskRecordMutation)

// newTaskRecordMutation creates new mutation for the TaskRecord entity.
func newTaskRecordMutation(c config, op Op, opts ...taskrecordOption) *TaskRecordMutation {
	m := &TaskRecordMutation{
		config:        c,
		op:            op,
		typ:           TypeTaskRecord,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withTaskRecordID sets the ID field of the mutation.
func withTaskRecordID(id uuid.UUID) taskrecordOption {
	return func(m *TaskRecordMutation) {
		var (
			err   error
			once  sync.Once
			value *TaskRecord
		)
		m.oldValue = func(ctx context.Context) (*TaskRecord, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().TaskRecord.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withTaskRecord sets the old TaskRecord of the mutation.
func withTaskRecord(node *TaskRecord) taskrecordOption {
	return func(m *TaskRecordMutation) {
		m.oldValue = func(context.Context) (*TaskRecord, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m TaskRecordMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m TaskRecordMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of TaskRecord entities.
func (m *TaskRecordMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *TaskRecordMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *TaskRecordMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().TaskRecord.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetTaskID sets the "task_id" field.
func (m *TaskRecordMutation) SetTaskID(u uuid.UUID) {
	m.task = &u
}

// TaskID returns the value of the "task_id" field in the mutation.
func (m *TaskRecordMutation) TaskID() (r uuid.UUID, exists bool) {
	v := m.task
	if v == nil {
		return
	}
	return *v, true
}

// OldTaskID returns the old "task_id" field's value of the TaskRecord entity.
// If the TaskRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskRecordMutation) OldTaskID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldTaskID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldTaskID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldTaskID: %w", err)
	}
	return oldValue.TaskID, nil
}

// ClearTaskID clears the value of the "task_id" field.
func (m *TaskRecordMutation) ClearTaskID() {
	m.task = nil
	m.clearedFields[taskrecord.FieldTaskID] = struct{}{}
}

// TaskIDCleared returns if the "task_id" field was cleared in this mutation.
func (m *TaskRecordMutation) TaskIDCleared() bool {
	_, ok := m.clearedFields[taskrecord.FieldTaskID]
	return ok
}

// ResetTaskID resets all changes to the "task_id" field.
func (m *TaskRecordMutation) ResetTaskID() {
	m.task = nil
	delete(m.clearedFields, taskrecord.FieldTaskID)
}

// SetPrompt sets the "prompt" field.
func (m *TaskRecordMutation) SetPrompt(s string) {
	m.prompt = &s
}

// Prompt returns the value of the "prompt" field in the mutation.
func (m *TaskRecordMutation) Prompt() (r string, exists bool) {
	v := m.prompt
	if v == nil {
		return
	}
	return *v, true
}

// OldPrompt returns the old "prompt" field's value of the TaskRecord entity.
// If the TaskRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskRecordMutation) OldPrompt(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPrompt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPrompt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPrompt: %w", err)
	}
	return oldValue.Prompt, nil
}

// ClearPrompt clears the value of the "prompt" field.
func (m *TaskRecordMutation) ClearPrompt() {
	m.prompt = nil
	m.clearedFields[taskrecord.FieldPrompt] = struct{}{}
}

// PromptCleared returns if the "prompt" field was cleared in this mutation.
func (m *TaskRecordMutation) PromptCleared() bool {
	_, ok := m.clearedFields[taskrecord.FieldPrompt]
	return ok
}

// ResetPrompt resets all changes to the "prompt" field.
func (m *TaskRecordMutation) ResetPrompt() {
	m.prompt = nil
	delete(m.clearedFields, taskrecord.FieldPrompt)
}

// SetRole sets the "role" field.
func (m *TaskRecordMutation) SetRole(cr consts.ChatRole) {
	m.role = &cr
}

// Role returns the value of the "role" field in the mutation.
func (m *TaskRecordMutation) Role() (r consts.ChatRole, exists bool) {
	v := m.role
	if v == nil {
		return
	}
	return *v, true
}

// OldRole returns the old "role" field's value of the TaskRecord entity.
// If the TaskRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskRecordMutation) OldRole(ctx context.Context) (v consts.ChatRole, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRole is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRole requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRole: %w", err)
	}
	return oldValue.Role, nil
}

// ResetRole resets all changes to the "role" field.
func (m *TaskRecordMutation) ResetRole() {
	m.role = nil
}

// SetCompletion sets the "completion" field.
func (m *TaskRecordMutation) SetCompletion(s string) {
	m.completion = &s
}

// Completion returns the value of the "completion" field in the mutation.
func (m *TaskRecordMutation) Completion() (r string, exists bool) {
	v := m.completion
	if v == nil {
		return
	}
	return *v, true
}

// OldCompletion returns the old "completion" field's value of the TaskRecord entity.
// If the TaskRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskRecordMutation) OldCompletion(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCompletion is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCompletion requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCompletion: %w", err)
	}
	return oldValue.Completion, nil
}

// ClearCompletion clears the value of the "completion" field.
func (m *TaskRecordMutation) ClearCompletion() {
	m.completion = nil
	m.clearedFields[taskrecord.FieldCompletion] = struct{}{}
}

// CompletionCleared returns if the "completion" field was cleared in this mutation.
func (m *TaskRecordMutation) CompletionCleared() bool {
	_, ok := m.clearedFields[taskrecord.FieldCompletion]
	return ok
}

// ResetCompletion resets all changes to the "completion" field.
func (m *TaskRecordMutation) ResetCompletion() {
	m.completion = nil
	delete(m.clearedFields, taskrecord.FieldCompletion)
}

// SetOutputTokens sets the "output_tokens" field.
func (m *TaskRecordMutation) SetOutputTokens(i int64) {
	m.output_tokens = &i
	m.addoutput_tokens = nil
}

// OutputTokens returns the value of the "output_tokens" field in the mutation.
func (m *TaskRecordMutation) OutputTokens() (r int64, exists bool) {
	v := m.output_tokens
	if v == nil {
		return
	}
	return *v, true
}

// OldOutputTokens returns the old "output_tokens" field's value of the TaskRecord entity.
// If the TaskRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskRecordMutation) OldOutputTokens(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOutputTokens is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOutputTokens requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOutputTokens: %w", err)
	}
	return oldValue.OutputTokens, nil
}

// AddOutputTokens adds i to the "output_tokens" field.
func (m *TaskRecordMutation) AddOutputTokens(i int64) {
	if m.addoutput_tokens != nil {
		*m.addoutput_tokens += i
	} else {
		m.addoutput_tokens = &i
	}
}

// AddedOutputTokens returns the value that was added to the "output_tokens" field in this mutation.
func (m *TaskRecordMutation) AddedOutputTokens() (r int64, exists bool) {
	v := m.addoutput_tokens
	if v == nil {
		return
	}
	return *v, true
}

// ResetOutputTokens resets all changes to the "output_tokens" field.
func (m *TaskRecordMutation) ResetOutputTokens() {
	m.output_tokens = nil
	m.addoutput_tokens = nil
}

// SetCodeLines sets the "code_lines" field.
func (m *TaskRecordMutation) SetCodeLines(i int64) {
	m.code_lines = &i
	m.addcode_lines = nil
}

// CodeLines returns the value of the "code_lines" field in the mutation.
func (m *TaskRecordMutation) CodeLines() (r int64, exists bool) {
	v := m.code_lines
	if v == nil {
		return
	}
	return *v, true
}

// OldCodeLines returns the old "code_lines" field's value of the TaskRecord entity.
// If the TaskRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskRecordMutation) OldCodeLines(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCodeLines is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCodeLines requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCodeLines: %w", err)
	}
	return oldValue.CodeLines, nil
}

// AddCodeLines adds i to the "code_lines" field.
func (m *TaskRecordMutation) AddCodeLines(i int64) {
	if m.addcode_lines != nil {
		*m.addcode_lines += i
	} else {
		m.addcode_lines = &i
	}
}

// AddedCodeLines returns the value that was added to the "code_lines" field in this mutation.
func (m *TaskRecordMutation) AddedCodeLines() (r int64, exists bool) {
	v := m.addcode_lines
	if v == nil {
		return
	}
	return *v, true
}

// ResetCodeLines resets all changes to the "code_lines" field.
func (m *TaskRecordMutation) ResetCodeLines() {
	m.code_lines = nil
	m.addcode_lines = nil
}

// SetCode sets the "code" field.
func (m *TaskRecordMutation) SetCode(s string) {
	m.code = &s
}

// Code returns the value of the "code" field in the mutation.
func (m *TaskRecordMutation) Code() (r string, exists bool) {
	v := m.code
	if v == nil {
		return
	}
	return *v, true
}

// OldCode returns the old "code" field's value of the TaskRecord entity.
// If the TaskRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskRecordMutation) OldCode(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCode is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCode requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCode: %w", err)
	}
	return oldValue.Code, nil
}

// ClearCode clears the value of the "code" field.
func (m *TaskRecordMutation) ClearCode() {
	m.code = nil
	m.clearedFields[taskrecord.FieldCode] = struct{}{}
}

// CodeCleared returns if the "code" field was cleared in this mutation.
func (m *TaskRecordMutation) CodeCleared() bool {
	_, ok := m.clearedFields[taskrecord.FieldCode]
	return ok
}

// ResetCode resets all changes to the "code" field.
func (m *TaskRecordMutation) ResetCode() {
	m.code = nil
	delete(m.clearedFields, taskrecord.FieldCode)
}

// SetCreatedAt sets the "created_at" field.
func (m *TaskRecordMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *TaskRecordMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the TaskRecord entity.
// If the TaskRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskRecordMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *TaskRecordMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *TaskRecordMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *TaskRecordMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the TaskRecord entity.
// If the TaskRecord object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskRecordMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *TaskRecordMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// ClearTask clears the "task" edge to the Task entity.
func (m *TaskRecordMutation) ClearTask() {
	m.clearedtask = true
	m.clearedFields[taskrecord.FieldTaskID] = struct{}{}
}

// TaskCleared reports if the "task" edge to the Task entity was cleared.
func (m *TaskRecordMutation) TaskCleared() bool {
	return m.TaskIDCleared() || m.clearedtask
}

// TaskIDs returns the "task" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// TaskID instead. It exists only for internal usage by the builders.
func (m *TaskRecordMutation) TaskIDs() (ids []uuid.UUID) {
	if id := m.task; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetTask resets all changes to the "task" edge.
func (m *TaskRecordMutation) ResetTask() {
	m.task = nil
	m.clearedtask = false
}

// Where appends a list predicates to the TaskRecordMutation builder.
func (m *TaskRecordMutation) Where(ps ...predicate.TaskRecord) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the TaskRecordMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *TaskRecordMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.TaskRecord, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *TaskRecordMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *TaskRecordMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (TaskRecord).
func (m *TaskRecordMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *TaskRecordMutation) Fields() []string {
	fields := make([]string, 0, 9)
	if m.task != nil {
		fields = append(fields, taskrecord.FieldTaskID)
	}
	if m.prompt != nil {
		fields = append(fields, taskrecord.FieldPrompt)
	}
	if m.role != nil {
		fields = append(fields, taskrecord.FieldRole)
	}
	if m.completion != nil {
		fields = append(fields, taskrecord.FieldCompletion)
	}
	if m.output_tokens != nil {
		fields = append(fields, taskrecord.FieldOutputTokens)
	}
	if m.code_lines != nil {
		fields = append(fields, taskrecord.FieldCodeLines)
	}
	if m.code != nil {
		fields = append(fields, taskrecord.FieldCode)
	}
	if m.created_at != nil {
		fields = append(fields, taskrecord.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, taskrecord.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *TaskRecordMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case taskrecord.FieldTaskID:
		return m.TaskID()
	case taskrecord.FieldPrompt:
		return m.Prompt()
	case taskrecord.FieldRole:
		return m.Role()
	case taskrecord.FieldCompletion:
		return m.Completion()
	case taskrecord.FieldOutputTokens:
		return m.OutputTokens()
	case taskrecord.FieldCodeLines:
		return m.CodeLines()
	case taskrecord.FieldCode:
		return m.Code()
	case taskrecord.FieldCreatedAt:
		return m.CreatedAt()
	case taskrecord.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *TaskRecordMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case taskrecord.FieldTaskID:
		return m.OldTaskID(ctx)
	case taskrecord.FieldPrompt:
		return m.OldPrompt(ctx)
	case taskrecord.FieldRole:
		return m.OldRole(ctx)
	case taskrecord.FieldCompletion:
		return m.OldCompletion(ctx)
	case taskrecord.FieldOutputTokens:
		return m.OldOutputTokens(ctx)
	case taskrecord.FieldCodeLines:
		return m.OldCodeLines(ctx)
	case taskrecord.FieldCode:
		return m.OldCode(ctx)
	case taskrecord.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case taskrecord.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown TaskRecord field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *TaskRecordMutation) SetField(name string, value ent.Value) error {
	switch name {
	case taskrecord.FieldTaskID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetTaskID(v)
		return nil
	case taskrecord.FieldPrompt:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPrompt(v)
		return nil
	case taskrecord.FieldRole:
		v, ok := value.(consts.ChatRole)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRole(v)
		return nil
	case taskrecord.FieldCompletion:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCompletion(v)
		return nil
	case taskrecord.FieldOutputTokens:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOutputTokens(v)
		return nil
	case taskrecord.FieldCodeLines:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCodeLines(v)
		return nil
	case taskrecord.FieldCode:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCode(v)
		return nil
	case taskrecord.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case taskrecord.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown TaskRecord field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *TaskRecordMutation) AddedFields() []string {
	var fields []string
	if m.addoutput_tokens != nil {
		fields = append(fields, taskrecord.FieldOutputTokens)
	}
	if m.addcode_lines != nil {
		fields = append(fields, taskrecord.FieldCodeLines)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *TaskRecordMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case taskrecord.FieldOutputTokens:
		return m.AddedOutputTokens()
	case taskrecord.FieldCodeLines:
		return m.AddedCodeLines()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *TaskRecordMutation) AddField(name string, value ent.Value) error {
	switch name {
	case taskrecord.FieldOutputTokens:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOutputTokens(v)
		return nil
	case taskrecord.FieldCodeLines:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddCodeLines(v)
		return nil
	}
	return fmt.Errorf("unknown TaskRecord numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *TaskRecordMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(taskrecord.FieldTaskID) {
		fields = append(fields, taskrecord.FieldTaskID)
	}
	if m.FieldCleared(taskrecord.FieldPrompt) {
		fields = append(fields, taskrecord.FieldPrompt)
	}
	if m.FieldCleared(taskrecord.FieldCompletion) {
		fields = append(fields, taskrecord.FieldCompletion)
	}
	if m.FieldCleared(taskrecord.FieldCode) {
		fields = append(fields, taskrecord.FieldCode)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *TaskRecordMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *TaskRecordMutation) ClearField(name string) error {
	switch name {
	case taskrecord.FieldTaskID:
		m.ClearTaskID()
		return nil
	case taskrecord.FieldPrompt:
		m.ClearPrompt()
		return nil
	case taskrecord.FieldCompletion:
		m.ClearCompletion()
		return nil
	case taskrecord.FieldCode:
		m.ClearCode()
		return nil
	}
	return fmt.Errorf("unknown TaskRecord nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *TaskRecordMutation) ResetField(name string) error {
	switch name {
	case taskrecord.FieldTaskID:
		m.ResetTaskID()
		return nil
	case taskrecord.FieldPrompt:
		m.ResetPrompt()
		return nil
	case taskrecord.FieldRole:
		m.ResetRole()
		return nil
	case taskrecord.FieldCompletion:
		m.ResetCompletion()
		return nil
	case taskrecord.FieldOutputTokens:
		m.ResetOutputTokens()
		return nil
	case taskrecord.FieldCodeLines:
		m.ResetCodeLines()
		return nil
	case taskrecord.FieldCode:
		m.ResetCode()
		return nil
	case taskrecord.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case taskrecord.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown TaskRecord field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *TaskRecordMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.task != nil {
		edges = append(edges, taskrecord.EdgeTask)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *TaskRecordMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case taskrecord.EdgeTask:
		if id := m.task; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *TaskRecordMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *TaskRecordMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *TaskRecordMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedtask {
		edges = append(edges, taskrecord.EdgeTask)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *TaskRecordMutation) EdgeCleared(name string) bool {
	switch name {
	case taskrecord.EdgeTask:
		return m.clearedtask
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *TaskRecordMutation) ClearEdge(name string) error {
	switch name {
	case taskrecord.EdgeTask:
		m.ClearTask()
		return nil
	}
	return fmt.Errorf("unknown TaskRecord unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *TaskRecordMutation) ResetEdge(name string) error {
	switch name {
	case taskrecord.EdgeTask:
		m.ResetTask()
		return nil
	}
	return fmt.Errorf("unknown TaskRecord edge %s", name)
}

// UserMutation represents an operation that mutates the User nodes in the graph.
type UserMutation struct {
	config
	op                        Op
	typ                       string
	id                        *uuid.UUID
	deleted_at                *time.Time
	username                  *string
	password                  *string
	email                     *string
	avatar_url                *string
	platform                  *consts.UserPlatform
	status                    *consts.UserStatus
	created_at                *time.Time
	updated_at                *time.Time
	clearedFields             map[string]struct{}
	login_histories           map[uuid.UUID]struct{}
	removedlogin_histories    map[uuid.UUID]struct{}
	clearedlogin_histories    bool
	models                    map[uuid.UUID]struct{}
	removedmodels             map[uuid.UUID]struct{}
	clearedmodels             bool
	tasks                     map[uuid.UUID]struct{}
	removedtasks              map[uuid.UUID]struct{}
	clearedtasks              bool
	identities                map[uuid.UUID]struct{}
	removedidentities         map[uuid.UUID]struct{}
	clearedidentities         bool
	workspaces                map[uuid.UUID]struct{}
	removedworkspaces         map[uuid.UUID]struct{}
	clearedworkspaces         bool
	workspace_files           map[uuid.UUID]struct{}
	removedworkspace_files    map[uuid.UUID]struct{}
	clearedworkspace_files    bool
	api_keys                  map[uuid.UUID]struct{}
	removedapi_keys           map[uuid.UUID]struct{}
	clearedapi_keys           bool
	security_scannings        map[uuid.UUID]struct{}
	removedsecurity_scannings map[uuid.UUID]struct{}
	clearedsecurity_scannings bool
	aiemployees               map[uuid.UUID]struct{}
	removedaiemployees        map[uuid.UUID]struct{}
	clearedaiemployees        bool
	groups                    map[uuid.UUID]struct{}
	removedgroups             map[uuid.UUID]struct{}
	clearedgroups             bool
	user_groups               map[uuid.UUID]struct{}
	removeduser_groups        map[uuid.UUID]struct{}
	cleareduser_groups        bool
	done                      bool
	oldValue                  func(context.Context) (*User, error)
	predicates                []predicate.User
}

var _ ent.Mutation = (*UserMutation)(nil)

// userOption allows management of the mutation configuration using functional options.
type userOption func(*UserMutation)

// newUserMutation creates new mutation for the User entity.
func newUserMutation(c config, op Op, opts ...userOption) *UserMutation {
	m := &UserMutation{
		config:        c,
		op:            op,
		typ:           TypeUser,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withUserID sets the ID field of the mutation.
func withUserID(id uuid.UUID) userOption {
	return func(m *UserMutation) {
		var (
			err   error
			once  sync.Once
			value *User
		)
		m.oldValue = func(ctx context.Context) (*User, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().User.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withUser sets the old User of the mutation.
func withUser(node *User) userOption {
	return func(m *UserMutation) {
		m.oldValue = func(context.Context) (*User, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m UserMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m UserMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of User entities.
func (m *UserMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *UserMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *UserMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().User.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetDeletedAt sets the "deleted_at" field.
func (m *UserMutation) SetDeletedAt(t time.Time) {
	m.deleted_at = &t
}

// DeletedAt returns the value of the "deleted_at" field in the mutation.
func (m *UserMutation) DeletedAt() (r time.Time, exists bool) {
	v := m.deleted_at
	if v == nil {
		return
	}
	return *v, true
}

// OldDeletedAt returns the old "deleted_at" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldDeletedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDeletedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDeletedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDeletedAt: %w", err)
	}
	return oldValue.DeletedAt, nil
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (m *UserMutation) ClearDeletedAt() {
	m.deleted_at = nil
	m.clearedFields[user.FieldDeletedAt] = struct{}{}
}

// DeletedAtCleared returns if the "deleted_at" field was cleared in this mutation.
func (m *UserMutation) DeletedAtCleared() bool {
	_, ok := m.clearedFields[user.FieldDeletedAt]
	return ok
}

// ResetDeletedAt resets all changes to the "deleted_at" field.
func (m *UserMutation) ResetDeletedAt() {
	m.deleted_at = nil
	delete(m.clearedFields, user.FieldDeletedAt)
}

// SetUsername sets the "username" field.
func (m *UserMutation) SetUsername(s string) {
	m.username = &s
}

// Username returns the value of the "username" field in the mutation.
func (m *UserMutation) Username() (r string, exists bool) {
	v := m.username
	if v == nil {
		return
	}
	return *v, true
}

// OldUsername returns the old "username" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldUsername(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUsername is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUsername requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUsername: %w", err)
	}
	return oldValue.Username, nil
}

// ClearUsername clears the value of the "username" field.
func (m *UserMutation) ClearUsername() {
	m.username = nil
	m.clearedFields[user.FieldUsername] = struct{}{}
}

// UsernameCleared returns if the "username" field was cleared in this mutation.
func (m *UserMutation) UsernameCleared() bool {
	_, ok := m.clearedFields[user.FieldUsername]
	return ok
}

// ResetUsername resets all changes to the "username" field.
func (m *UserMutation) ResetUsername() {
	m.username = nil
	delete(m.clearedFields, user.FieldUsername)
}

// SetPassword sets the "password" field.
func (m *UserMutation) SetPassword(s string) {
	m.password = &s
}

// Password returns the value of the "password" field in the mutation.
func (m *UserMutation) Password() (r string, exists bool) {
	v := m.password
	if v == nil {
		return
	}
	return *v, true
}

// OldPassword returns the old "password" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldPassword(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPassword is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPassword requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPassword: %w", err)
	}
	return oldValue.Password, nil
}

// ClearPassword clears the value of the "password" field.
func (m *UserMutation) ClearPassword() {
	m.password = nil
	m.clearedFields[user.FieldPassword] = struct{}{}
}

// PasswordCleared returns if the "password" field was cleared in this mutation.
func (m *UserMutation) PasswordCleared() bool {
	_, ok := m.clearedFields[user.FieldPassword]
	return ok
}

// ResetPassword resets all changes to the "password" field.
func (m *UserMutation) ResetPassword() {
	m.password = nil
	delete(m.clearedFields, user.FieldPassword)
}

// SetEmail sets the "email" field.
func (m *UserMutation) SetEmail(s string) {
	m.email = &s
}

// Email returns the value of the "email" field in the mutation.
func (m *UserMutation) Email() (r string, exists bool) {
	v := m.email
	if v == nil {
		return
	}
	return *v, true
}

// OldEmail returns the old "email" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldEmail(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEmail is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEmail requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEmail: %w", err)
	}
	return oldValue.Email, nil
}

// ClearEmail clears the value of the "email" field.
func (m *UserMutation) ClearEmail() {
	m.email = nil
	m.clearedFields[user.FieldEmail] = struct{}{}
}

// EmailCleared returns if the "email" field was cleared in this mutation.
func (m *UserMutation) EmailCleared() bool {
	_, ok := m.clearedFields[user.FieldEmail]
	return ok
}

// ResetEmail resets all changes to the "email" field.
func (m *UserMutation) ResetEmail() {
	m.email = nil
	delete(m.clearedFields, user.FieldEmail)
}

// SetAvatarURL sets the "avatar_url" field.
func (m *UserMutation) SetAvatarURL(s string) {
	m.avatar_url = &s
}

// AvatarURL returns the value of the "avatar_url" field in the mutation.
func (m *UserMutation) AvatarURL() (r string, exists bool) {
	v := m.avatar_url
	if v == nil {
		return
	}
	return *v, true
}

// OldAvatarURL returns the old "avatar_url" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldAvatarURL(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAvatarURL is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAvatarURL requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAvatarURL: %w", err)
	}
	return oldValue.AvatarURL, nil
}

// ClearAvatarURL clears the value of the "avatar_url" field.
func (m *UserMutation) ClearAvatarURL() {
	m.avatar_url = nil
	m.clearedFields[user.FieldAvatarURL] = struct{}{}
}

// AvatarURLCleared returns if the "avatar_url" field was cleared in this mutation.
func (m *UserMutation) AvatarURLCleared() bool {
	_, ok := m.clearedFields[user.FieldAvatarURL]
	return ok
}

// ResetAvatarURL resets all changes to the "avatar_url" field.
func (m *UserMutation) ResetAvatarURL() {
	m.avatar_url = nil
	delete(m.clearedFields, user.FieldAvatarURL)
}

// SetPlatform sets the "platform" field.
func (m *UserMutation) SetPlatform(cp consts.UserPlatform) {
	m.platform = &cp
}

// Platform returns the value of the "platform" field in the mutation.
func (m *UserMutation) Platform() (r consts.UserPlatform, exists bool) {
	v := m.platform
	if v == nil {
		return
	}
	return *v, true
}

// OldPlatform returns the old "platform" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldPlatform(ctx context.Context) (v consts.UserPlatform, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPlatform is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPlatform requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPlatform: %w", err)
	}
	return oldValue.Platform, nil
}

// ResetPlatform resets all changes to the "platform" field.
func (m *UserMutation) ResetPlatform() {
	m.platform = nil
}

// SetStatus sets the "status" field.
func (m *UserMutation) SetStatus(cs consts.UserStatus) {
	m.status = &cs
}

// Status returns the value of the "status" field in the mutation.
func (m *UserMutation) Status() (r consts.UserStatus, exists bool) {
	v := m.status
	if v == nil {
		return
	}
	return *v, true
}

// OldStatus returns the old "status" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldStatus(ctx context.Context) (v consts.UserStatus, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStatus is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStatus requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStatus: %w", err)
	}
	return oldValue.Status, nil
}

// ResetStatus resets all changes to the "status" field.
func (m *UserMutation) ResetStatus() {
	m.status = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *UserMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *UserMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *UserMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *UserMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *UserMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *UserMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// AddLoginHistoryIDs adds the "login_histories" edge to the UserLoginHistory entity by ids.
func (m *UserMutation) AddLoginHistoryIDs(ids ...uuid.UUID) {
	if m.login_histories == nil {
		m.login_histories = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.login_histories[ids[i]] = struct{}{}
	}
}

// ClearLoginHistories clears the "login_histories" edge to the UserLoginHistory entity.
func (m *UserMutation) ClearLoginHistories() {
	m.clearedlogin_histories = true
}

// LoginHistoriesCleared reports if the "login_histories" edge to the UserLoginHistory entity was cleared.
func (m *UserMutation) LoginHistoriesCleared() bool {
	return m.clearedlogin_histories
}

// RemoveLoginHistoryIDs removes the "login_histories" edge to the UserLoginHistory entity by IDs.
func (m *UserMutation) RemoveLoginHistoryIDs(ids ...uuid.UUID) {
	if m.removedlogin_histories == nil {
		m.removedlogin_histories = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.login_histories, ids[i])
		m.removedlogin_histories[ids[i]] = struct{}{}
	}
}

// RemovedLoginHistories returns the removed IDs of the "login_histories" edge to the UserLoginHistory entity.
func (m *UserMutation) RemovedLoginHistoriesIDs() (ids []uuid.UUID) {
	for id := range m.removedlogin_histories {
		ids = append(ids, id)
	}
	return
}

// LoginHistoriesIDs returns the "login_histories" edge IDs in the mutation.
func (m *UserMutation) LoginHistoriesIDs() (ids []uuid.UUID) {
	for id := range m.login_histories {
		ids = append(ids, id)
	}
	return
}

// ResetLoginHistories resets all changes to the "login_histories" edge.
func (m *UserMutation) ResetLoginHistories() {
	m.login_histories = nil
	m.clearedlogin_histories = false
	m.removedlogin_histories = nil
}

// AddModelIDs adds the "models" edge to the Model entity by ids.
func (m *UserMutation) AddModelIDs(ids ...uuid.UUID) {
	if m.models == nil {
		m.models = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.models[ids[i]] = struct{}{}
	}
}

// ClearModels clears the "models" edge to the Model entity.
func (m *UserMutation) ClearModels() {
	m.clearedmodels = true
}

// ModelsCleared reports if the "models" edge to the Model entity was cleared.
func (m *UserMutation) ModelsCleared() bool {
	return m.clearedmodels
}

// RemoveModelIDs removes the "models" edge to the Model entity by IDs.
func (m *UserMutation) RemoveModelIDs(ids ...uuid.UUID) {
	if m.removedmodels == nil {
		m.removedmodels = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.models, ids[i])
		m.removedmodels[ids[i]] = struct{}{}
	}
}

// RemovedModels returns the removed IDs of the "models" edge to the Model entity.
func (m *UserMutation) RemovedModelsIDs() (ids []uuid.UUID) {
	for id := range m.removedmodels {
		ids = append(ids, id)
	}
	return
}

// ModelsIDs returns the "models" edge IDs in the mutation.
func (m *UserMutation) ModelsIDs() (ids []uuid.UUID) {
	for id := range m.models {
		ids = append(ids, id)
	}
	return
}

// ResetModels resets all changes to the "models" edge.
func (m *UserMutation) ResetModels() {
	m.models = nil
	m.clearedmodels = false
	m.removedmodels = nil
}

// AddTaskIDs adds the "tasks" edge to the Task entity by ids.
func (m *UserMutation) AddTaskIDs(ids ...uuid.UUID) {
	if m.tasks == nil {
		m.tasks = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.tasks[ids[i]] = struct{}{}
	}
}

// ClearTasks clears the "tasks" edge to the Task entity.
func (m *UserMutation) ClearTasks() {
	m.clearedtasks = true
}

// TasksCleared reports if the "tasks" edge to the Task entity was cleared.
func (m *UserMutation) TasksCleared() bool {
	return m.clearedtasks
}

// RemoveTaskIDs removes the "tasks" edge to the Task entity by IDs.
func (m *UserMutation) RemoveTaskIDs(ids ...uuid.UUID) {
	if m.removedtasks == nil {
		m.removedtasks = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.tasks, ids[i])
		m.removedtasks[ids[i]] = struct{}{}
	}
}

// RemovedTasks returns the removed IDs of the "tasks" edge to the Task entity.
func (m *UserMutation) RemovedTasksIDs() (ids []uuid.UUID) {
	for id := range m.removedtasks {
		ids = append(ids, id)
	}
	return
}

// TasksIDs returns the "tasks" edge IDs in the mutation.
func (m *UserMutation) TasksIDs() (ids []uuid.UUID) {
	for id := range m.tasks {
		ids = append(ids, id)
	}
	return
}

// ResetTasks resets all changes to the "tasks" edge.
func (m *UserMutation) ResetTasks() {
	m.tasks = nil
	m.clearedtasks = false
	m.removedtasks = nil
}

// AddIdentityIDs adds the "identities" edge to the UserIdentity entity by ids.
func (m *UserMutation) AddIdentityIDs(ids ...uuid.UUID) {
	if m.identities == nil {
		m.identities = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.identities[ids[i]] = struct{}{}
	}
}

// ClearIdentities clears the "identities" edge to the UserIdentity entity.
func (m *UserMutation) ClearIdentities() {
	m.clearedidentities = true
}

// IdentitiesCleared reports if the "identities" edge to the UserIdentity entity was cleared.
func (m *UserMutation) IdentitiesCleared() bool {
	return m.clearedidentities
}

// RemoveIdentityIDs removes the "identities" edge to the UserIdentity entity by IDs.
func (m *UserMutation) RemoveIdentityIDs(ids ...uuid.UUID) {
	if m.removedidentities == nil {
		m.removedidentities = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.identities, ids[i])
		m.removedidentities[ids[i]] = struct{}{}
	}
}

// RemovedIdentities returns the removed IDs of the "identities" edge to the UserIdentity entity.
func (m *UserMutation) RemovedIdentitiesIDs() (ids []uuid.UUID) {
	for id := range m.removedidentities {
		ids = append(ids, id)
	}
	return
}

// IdentitiesIDs returns the "identities" edge IDs in the mutation.
func (m *UserMutation) IdentitiesIDs() (ids []uuid.UUID) {
	for id := range m.identities {
		ids = append(ids, id)
	}
	return
}

// ResetIdentities resets all changes to the "identities" edge.
func (m *UserMutation) ResetIdentities() {
	m.identities = nil
	m.clearedidentities = false
	m.removedidentities = nil
}

// AddWorkspaceIDs adds the "workspaces" edge to the Workspace entity by ids.
func (m *UserMutation) AddWorkspaceIDs(ids ...uuid.UUID) {
	if m.workspaces == nil {
		m.workspaces = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.workspaces[ids[i]] = struct{}{}
	}
}

// ClearWorkspaces clears the "workspaces" edge to the Workspace entity.
func (m *UserMutation) ClearWorkspaces() {
	m.clearedworkspaces = true
}

// WorkspacesCleared reports if the "workspaces" edge to the Workspace entity was cleared.
func (m *UserMutation) WorkspacesCleared() bool {
	return m.clearedworkspaces
}

// RemoveWorkspaceIDs removes the "workspaces" edge to the Workspace entity by IDs.
func (m *UserMutation) RemoveWorkspaceIDs(ids ...uuid.UUID) {
	if m.removedworkspaces == nil {
		m.removedworkspaces = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.workspaces, ids[i])
		m.removedworkspaces[ids[i]] = struct{}{}
	}
}

// RemovedWorkspaces returns the removed IDs of the "workspaces" edge to the Workspace entity.
func (m *UserMutation) RemovedWorkspacesIDs() (ids []uuid.UUID) {
	for id := range m.removedworkspaces {
		ids = append(ids, id)
	}
	return
}

// WorkspacesIDs returns the "workspaces" edge IDs in the mutation.
func (m *UserMutation) WorkspacesIDs() (ids []uuid.UUID) {
	for id := range m.workspaces {
		ids = append(ids, id)
	}
	return
}

// ResetWorkspaces resets all changes to the "workspaces" edge.
func (m *UserMutation) ResetWorkspaces() {
	m.workspaces = nil
	m.clearedworkspaces = false
	m.removedworkspaces = nil
}

// AddWorkspaceFileIDs adds the "workspace_files" edge to the WorkspaceFile entity by ids.
func (m *UserMutation) AddWorkspaceFileIDs(ids ...uuid.UUID) {
	if m.workspace_files == nil {
		m.workspace_files = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.workspace_files[ids[i]] = struct{}{}
	}
}

// ClearWorkspaceFiles clears the "workspace_files" edge to the WorkspaceFile entity.
func (m *UserMutation) ClearWorkspaceFiles() {
	m.clearedworkspace_files = true
}

// WorkspaceFilesCleared reports if the "workspace_files" edge to the WorkspaceFile entity was cleared.
func (m *UserMutation) WorkspaceFilesCleared() bool {
	return m.clearedworkspace_files
}

// RemoveWorkspaceFileIDs removes the "workspace_files" edge to the WorkspaceFile entity by IDs.
func (m *UserMutation) RemoveWorkspaceFileIDs(ids ...uuid.UUID) {
	if m.removedworkspace_files == nil {
		m.removedworkspace_files = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.workspace_files, ids[i])
		m.removedworkspace_files[ids[i]] = struct{}{}
	}
}

// RemovedWorkspaceFiles returns the removed IDs of the "workspace_files" edge to the WorkspaceFile entity.
func (m *UserMutation) RemovedWorkspaceFilesIDs() (ids []uuid.UUID) {
	for id := range m.removedworkspace_files {
		ids = append(ids, id)
	}
	return
}

// WorkspaceFilesIDs returns the "workspace_files" edge IDs in the mutation.
func (m *UserMutation) WorkspaceFilesIDs() (ids []uuid.UUID) {
	for id := range m.workspace_files {
		ids = append(ids, id)
	}
	return
}

// ResetWorkspaceFiles resets all changes to the "workspace_files" edge.
func (m *UserMutation) ResetWorkspaceFiles() {
	m.workspace_files = nil
	m.clearedworkspace_files = false
	m.removedworkspace_files = nil
}

// AddAPIKeyIDs adds the "api_keys" edge to the ApiKey entity by ids.
func (m *UserMutation) AddAPIKeyIDs(ids ...uuid.UUID) {
	if m.api_keys == nil {
		m.api_keys = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.api_keys[ids[i]] = struct{}{}
	}
}

// ClearAPIKeys clears the "api_keys" edge to the ApiKey entity.
func (m *UserMutation) ClearAPIKeys() {
	m.clearedapi_keys = true
}

// APIKeysCleared reports if the "api_keys" edge to the ApiKey entity was cleared.
func (m *UserMutation) APIKeysCleared() bool {
	return m.clearedapi_keys
}

// RemoveAPIKeyIDs removes the "api_keys" edge to the ApiKey entity by IDs.
func (m *UserMutation) RemoveAPIKeyIDs(ids ...uuid.UUID) {
	if m.removedapi_keys == nil {
		m.removedapi_keys = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.api_keys, ids[i])
		m.removedapi_keys[ids[i]] = struct{}{}
	}
}

// RemovedAPIKeys returns the removed IDs of the "api_keys" edge to the ApiKey entity.
func (m *UserMutation) RemovedAPIKeysIDs() (ids []uuid.UUID) {
	for id := range m.removedapi_keys {
		ids = append(ids, id)
	}
	return
}

// APIKeysIDs returns the "api_keys" edge IDs in the mutation.
func (m *UserMutation) APIKeysIDs() (ids []uuid.UUID) {
	for id := range m.api_keys {
		ids = append(ids, id)
	}
	return
}

// ResetAPIKeys resets all changes to the "api_keys" edge.
func (m *UserMutation) ResetAPIKeys() {
	m.api_keys = nil
	m.clearedapi_keys = false
	m.removedapi_keys = nil
}

// AddSecurityScanningIDs adds the "security_scannings" edge to the SecurityScanning entity by ids.
func (m *UserMutation) AddSecurityScanningIDs(ids ...uuid.UUID) {
	if m.security_scannings == nil {
		m.security_scannings = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.security_scannings[ids[i]] = struct{}{}
	}
}

// ClearSecurityScannings clears the "security_scannings" edge to the SecurityScanning entity.
func (m *UserMutation) ClearSecurityScannings() {
	m.clearedsecurity_scannings = true
}

// SecurityScanningsCleared reports if the "security_scannings" edge to the SecurityScanning entity was cleared.
func (m *UserMutation) SecurityScanningsCleared() bool {
	return m.clearedsecurity_scannings
}

// RemoveSecurityScanningIDs removes the "security_scannings" edge to the SecurityScanning entity by IDs.
func (m *UserMutation) RemoveSecurityScanningIDs(ids ...uuid.UUID) {
	if m.removedsecurity_scannings == nil {
		m.removedsecurity_scannings = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.security_scannings, ids[i])
		m.removedsecurity_scannings[ids[i]] = struct{}{}
	}
}

// RemovedSecurityScannings returns the removed IDs of the "security_scannings" edge to the SecurityScanning entity.
func (m *UserMutation) RemovedSecurityScanningsIDs() (ids []uuid.UUID) {
	for id := range m.removedsecurity_scannings {
		ids = append(ids, id)
	}
	return
}

// SecurityScanningsIDs returns the "security_scannings" edge IDs in the mutation.
func (m *UserMutation) SecurityScanningsIDs() (ids []uuid.UUID) {
	for id := range m.security_scannings {
		ids = append(ids, id)
	}
	return
}

// ResetSecurityScannings resets all changes to the "security_scannings" edge.
func (m *UserMutation) ResetSecurityScannings() {
	m.security_scannings = nil
	m.clearedsecurity_scannings = false
	m.removedsecurity_scannings = nil
}

// AddAiemployeeIDs adds the "aiemployees" edge to the AIEmployee entity by ids.
func (m *UserMutation) AddAiemployeeIDs(ids ...uuid.UUID) {
	if m.aiemployees == nil {
		m.aiemployees = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.aiemployees[ids[i]] = struct{}{}
	}
}

// ClearAiemployees clears the "aiemployees" edge to the AIEmployee entity.
func (m *UserMutation) ClearAiemployees() {
	m.clearedaiemployees = true
}

// AiemployeesCleared reports if the "aiemployees" edge to the AIEmployee entity was cleared.
func (m *UserMutation) AiemployeesCleared() bool {
	return m.clearedaiemployees
}

// RemoveAiemployeeIDs removes the "aiemployees" edge to the AIEmployee entity by IDs.
func (m *UserMutation) RemoveAiemployeeIDs(ids ...uuid.UUID) {
	if m.removedaiemployees == nil {
		m.removedaiemployees = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.aiemployees, ids[i])
		m.removedaiemployees[ids[i]] = struct{}{}
	}
}

// RemovedAiemployees returns the removed IDs of the "aiemployees" edge to the AIEmployee entity.
func (m *UserMutation) RemovedAiemployeesIDs() (ids []uuid.UUID) {
	for id := range m.removedaiemployees {
		ids = append(ids, id)
	}
	return
}

// AiemployeesIDs returns the "aiemployees" edge IDs in the mutation.
func (m *UserMutation) AiemployeesIDs() (ids []uuid.UUID) {
	for id := range m.aiemployees {
		ids = append(ids, id)
	}
	return
}

// ResetAiemployees resets all changes to the "aiemployees" edge.
func (m *UserMutation) ResetAiemployees() {
	m.aiemployees = nil
	m.clearedaiemployees = false
	m.removedaiemployees = nil
}

// AddGroupIDs adds the "groups" edge to the UserGroup entity by ids.
func (m *UserMutation) AddGroupIDs(ids ...uuid.UUID) {
	if m.groups == nil {
		m.groups = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.groups[ids[i]] = struct{}{}
	}
}

// ClearGroups clears the "groups" edge to the UserGroup entity.
func (m *UserMutation) ClearGroups() {
	m.clearedgroups = true
}

// GroupsCleared reports if the "groups" edge to the UserGroup entity was cleared.
func (m *UserMutation) GroupsCleared() bool {
	return m.clearedgroups
}

// RemoveGroupIDs removes the "groups" edge to the UserGroup entity by IDs.
func (m *UserMutation) RemoveGroupIDs(ids ...uuid.UUID) {
	if m.removedgroups == nil {
		m.removedgroups = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.groups, ids[i])
		m.removedgroups[ids[i]] = struct{}{}
	}
}

// RemovedGroups returns the removed IDs of the "groups" edge to the UserGroup entity.
func (m *UserMutation) RemovedGroupsIDs() (ids []uuid.UUID) {
	for id := range m.removedgroups {
		ids = append(ids, id)
	}
	return
}

// GroupsIDs returns the "groups" edge IDs in the mutation.
func (m *UserMutation) GroupsIDs() (ids []uuid.UUID) {
	for id := range m.groups {
		ids = append(ids, id)
	}
	return
}

// ResetGroups resets all changes to the "groups" edge.
func (m *UserMutation) ResetGroups() {
	m.groups = nil
	m.clearedgroups = false
	m.removedgroups = nil
}

// AddUserGroupIDs adds the "user_groups" edge to the UserGroupUser entity by ids.
func (m *UserMutation) AddUserGroupIDs(ids ...uuid.UUID) {
	if m.user_groups == nil {
		m.user_groups = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.user_groups[ids[i]] = struct{}{}
	}
}

// ClearUserGroups clears the "user_groups" edge to the UserGroupUser entity.
func (m *UserMutation) ClearUserGroups() {
	m.cleareduser_groups = true
}

// UserGroupsCleared reports if the "user_groups" edge to the UserGroupUser entity was cleared.
func (m *UserMutation) UserGroupsCleared() bool {
	return m.cleareduser_groups
}

// RemoveUserGroupIDs removes the "user_groups" edge to the UserGroupUser entity by IDs.
func (m *UserMutation) RemoveUserGroupIDs(ids ...uuid.UUID) {
	if m.removeduser_groups == nil {
		m.removeduser_groups = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.user_groups, ids[i])
		m.removeduser_groups[ids[i]] = struct{}{}
	}
}

// RemovedUserGroups returns the removed IDs of the "user_groups" edge to the UserGroupUser entity.
func (m *UserMutation) RemovedUserGroupsIDs() (ids []uuid.UUID) {
	for id := range m.removeduser_groups {
		ids = append(ids, id)
	}
	return
}

// UserGroupsIDs returns the "user_groups" edge IDs in the mutation.
func (m *UserMutation) UserGroupsIDs() (ids []uuid.UUID) {
	for id := range m.user_groups {
		ids = append(ids, id)
	}
	return
}

// ResetUserGroups resets all changes to the "user_groups" edge.
func (m *UserMutation) ResetUserGroups() {
	m.user_groups = nil
	m.cleareduser_groups = false
	m.removeduser_groups = nil
}

// Where appends a list predicates to the UserMutation builder.
func (m *UserMutation) Where(ps ...predicate.User) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the UserMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *UserMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.User, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *UserMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *UserMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (User).
func (m *UserMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *UserMutation) Fields() []string {
	fields := make([]string, 0, 9)
	if m.deleted_at != nil {
		fields = append(fields, user.FieldDeletedAt)
	}
	if m.username != nil {
		fields = append(fields, user.FieldUsername)
	}
	if m.password != nil {
		fields = append(fields, user.FieldPassword)
	}
	if m.email != nil {
		fields = append(fields, user.FieldEmail)
	}
	if m.avatar_url != nil {
		fields = append(fields, user.FieldAvatarURL)
	}
	if m.platform != nil {
		fields = append(fields, user.FieldPlatform)
	}
	if m.status != nil {
		fields = append(fields, user.FieldStatus)
	}
	if m.created_at != nil {
		fields = append(fields, user.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, user.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *UserMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case user.FieldDeletedAt:
		return m.DeletedAt()
	case user.FieldUsername:
		return m.Username()
	case user.FieldPassword:
		return m.Password()
	case user.FieldEmail:
		return m.Email()
	case user.FieldAvatarURL:
		return m.AvatarURL()
	case user.FieldPlatform:
		return m.Platform()
	case user.FieldStatus:
		return m.Status()
	case user.FieldCreatedAt:
		return m.CreatedAt()
	case user.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *UserMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case user.FieldDeletedAt:
		return m.OldDeletedAt(ctx)
	case user.FieldUsername:
		return m.OldUsername(ctx)
	case user.FieldPassword:
		return m.OldPassword(ctx)
	case user.FieldEmail:
		return m.OldEmail(ctx)
	case user.FieldAvatarURL:
		return m.OldAvatarURL(ctx)
	case user.FieldPlatform:
		return m.OldPlatform(ctx)
	case user.FieldStatus:
		return m.OldStatus(ctx)
	case user.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case user.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown User field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) SetField(name string, value ent.Value) error {
	switch name {
	case user.FieldDeletedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDeletedAt(v)
		return nil
	case user.FieldUsername:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUsername(v)
		return nil
	case user.FieldPassword:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPassword(v)
		return nil
	case user.FieldEmail:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEmail(v)
		return nil
	case user.FieldAvatarURL:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAvatarURL(v)
		return nil
	case user.FieldPlatform:
		v, ok := value.(consts.UserPlatform)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPlatform(v)
		return nil
	case user.FieldStatus:
		v, ok := value.(consts.UserStatus)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStatus(v)
		return nil
	case user.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case user.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *UserMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *UserMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown User numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *UserMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(user.FieldDeletedAt) {
		fields = append(fields, user.FieldDeletedAt)
	}
	if m.FieldCleared(user.FieldUsername) {
		fields = append(fields, user.FieldUsername)
	}
	if m.FieldCleared(user.FieldPassword) {
		fields = append(fields, user.FieldPassword)
	}
	if m.FieldCleared(user.FieldEmail) {
		fields = append(fields, user.FieldEmail)
	}
	if m.FieldCleared(user.FieldAvatarURL) {
		fields = append(fields, user.FieldAvatarURL)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *UserMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *UserMutation) ClearField(name string) error {
	switch name {
	case user.FieldDeletedAt:
		m.ClearDeletedAt()
		return nil
	case user.FieldUsername:
		m.ClearUsername()
		return nil
	case user.FieldPassword:
		m.ClearPassword()
		return nil
	case user.FieldEmail:
		m.ClearEmail()
		return nil
	case user.FieldAvatarURL:
		m.ClearAvatarURL()
		return nil
	}
	return fmt.Errorf("unknown User nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *UserMutation) ResetField(name string) error {
	switch name {
	case user.FieldDeletedAt:
		m.ResetDeletedAt()
		return nil
	case user.FieldUsername:
		m.ResetUsername()
		return nil
	case user.FieldPassword:
		m.ResetPassword()
		return nil
	case user.FieldEmail:
		m.ResetEmail()
		return nil
	case user.FieldAvatarURL:
		m.ResetAvatarURL()
		return nil
	case user.FieldPlatform:
		m.ResetPlatform()
		return nil
	case user.FieldStatus:
		m.ResetStatus()
		return nil
	case user.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case user.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *UserMutation) AddedEdges() []string {
	edges := make([]string, 0, 11)
	if m.login_histories != nil {
		edges = append(edges, user.EdgeLoginHistories)
	}
	if m.models != nil {
		edges = append(edges, user.EdgeModels)
	}
	if m.tasks != nil {
		edges = append(edges, user.EdgeTasks)
	}
	if m.identities != nil {
		edges = append(edges, user.EdgeIdentities)
	}
	if m.workspaces != nil {
		edges = append(edges, user.EdgeWorkspaces)
	}
	if m.workspace_files != nil {
		edges = append(edges, user.EdgeWorkspaceFiles)
	}
	if m.api_keys != nil {
		edges = append(edges, user.EdgeAPIKeys)
	}
	if m.security_scannings != nil {
		edges = append(edges, user.EdgeSecurityScannings)
	}
	if m.aiemployees != nil {
		edges = append(edges, user.EdgeAiemployees)
	}
	if m.groups != nil {
		edges = append(edges, user.EdgeGroups)
	}
	if m.user_groups != nil {
		edges = append(edges, user.EdgeUserGroups)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *UserMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case user.EdgeLoginHistories:
		ids := make([]ent.Value, 0, len(m.login_histories))
		for id := range m.login_histories {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeModels:
		ids := make([]ent.Value, 0, len(m.models))
		for id := range m.models {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeTasks:
		ids := make([]ent.Value, 0, len(m.tasks))
		for id := range m.tasks {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeIdentities:
		ids := make([]ent.Value, 0, len(m.identities))
		for id := range m.identities {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeWorkspaces:
		ids := make([]ent.Value, 0, len(m.workspaces))
		for id := range m.workspaces {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeWorkspaceFiles:
		ids := make([]ent.Value, 0, len(m.workspace_files))
		for id := range m.workspace_files {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeAPIKeys:
		ids := make([]ent.Value, 0, len(m.api_keys))
		for id := range m.api_keys {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeSecurityScannings:
		ids := make([]ent.Value, 0, len(m.security_scannings))
		for id := range m.security_scannings {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeAiemployees:
		ids := make([]ent.Value, 0, len(m.aiemployees))
		for id := range m.aiemployees {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeGroups:
		ids := make([]ent.Value, 0, len(m.groups))
		for id := range m.groups {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeUserGroups:
		ids := make([]ent.Value, 0, len(m.user_groups))
		for id := range m.user_groups {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *UserMutation) RemovedEdges() []string {
	edges := make([]string, 0, 11)
	if m.removedlogin_histories != nil {
		edges = append(edges, user.EdgeLoginHistories)
	}
	if m.removedmodels != nil {
		edges = append(edges, user.EdgeModels)
	}
	if m.removedtasks != nil {
		edges = append(edges, user.EdgeTasks)
	}
	if m.removedidentities != nil {
		edges = append(edges, user.EdgeIdentities)
	}
	if m.removedworkspaces != nil {
		edges = append(edges, user.EdgeWorkspaces)
	}
	if m.removedworkspace_files != nil {
		edges = append(edges, user.EdgeWorkspaceFiles)
	}
	if m.removedapi_keys != nil {
		edges = append(edges, user.EdgeAPIKeys)
	}
	if m.removedsecurity_scannings != nil {
		edges = append(edges, user.EdgeSecurityScannings)
	}
	if m.removedaiemployees != nil {
		edges = append(edges, user.EdgeAiemployees)
	}
	if m.removedgroups != nil {
		edges = append(edges, user.EdgeGroups)
	}
	if m.removeduser_groups != nil {
		edges = append(edges, user.EdgeUserGroups)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *UserMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case user.EdgeLoginHistories:
		ids := make([]ent.Value, 0, len(m.removedlogin_histories))
		for id := range m.removedlogin_histories {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeModels:
		ids := make([]ent.Value, 0, len(m.removedmodels))
		for id := range m.removedmodels {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeTasks:
		ids := make([]ent.Value, 0, len(m.removedtasks))
		for id := range m.removedtasks {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeIdentities:
		ids := make([]ent.Value, 0, len(m.removedidentities))
		for id := range m.removedidentities {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeWorkspaces:
		ids := make([]ent.Value, 0, len(m.removedworkspaces))
		for id := range m.removedworkspaces {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeWorkspaceFiles:
		ids := make([]ent.Value, 0, len(m.removedworkspace_files))
		for id := range m.removedworkspace_files {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeAPIKeys:
		ids := make([]ent.Value, 0, len(m.removedapi_keys))
		for id := range m.removedapi_keys {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeSecurityScannings:
		ids := make([]ent.Value, 0, len(m.removedsecurity_scannings))
		for id := range m.removedsecurity_scannings {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeAiemployees:
		ids := make([]ent.Value, 0, len(m.removedaiemployees))
		for id := range m.removedaiemployees {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeGroups:
		ids := make([]ent.Value, 0, len(m.removedgroups))
		for id := range m.removedgroups {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeUserGroups:
		ids := make([]ent.Value, 0, len(m.removeduser_groups))
		for id := range m.removeduser_groups {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *UserMutation) ClearedEdges() []string {
	edges := make([]string, 0, 11)
	if m.clearedlogin_histories {
		edges = append(edges, user.EdgeLoginHistories)
	}
	if m.clearedmodels {
		edges = append(edges, user.EdgeModels)
	}
	if m.clearedtasks {
		edges = append(edges, user.EdgeTasks)
	}
	if m.clearedidentities {
		edges = append(edges, user.EdgeIdentities)
	}
	if m.clearedworkspaces {
		edges = append(edges, user.EdgeWorkspaces)
	}
	if m.clearedworkspace_files {
		edges = append(edges, user.EdgeWorkspaceFiles)
	}
	if m.clearedapi_keys {
		edges = append(edges, user.EdgeAPIKeys)
	}
	if m.clearedsecurity_scannings {
		edges = append(edges, user.EdgeSecurityScannings)
	}
	if m.clearedaiemployees {
		edges = append(edges, user.EdgeAiemployees)
	}
	if m.clearedgroups {
		edges = append(edges, user.EdgeGroups)
	}
	if m.cleareduser_groups {
		edges = append(edges, user.EdgeUserGroups)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *UserMutation) EdgeCleared(name string) bool {
	switch name {
	case user.EdgeLoginHistories:
		return m.clearedlogin_histories
	case user.EdgeModels:
		return m.clearedmodels
	case user.EdgeTasks:
		return m.clearedtasks
	case user.EdgeIdentities:
		return m.clearedidentities
	case user.EdgeWorkspaces:
		return m.clearedworkspaces
	case user.EdgeWorkspaceFiles:
		return m.clearedworkspace_files
	case user.EdgeAPIKeys:
		return m.clearedapi_keys
	case user.EdgeSecurityScannings:
		return m.clearedsecurity_scannings
	case user.EdgeAiemployees:
		return m.clearedaiemployees
	case user.EdgeGroups:
		return m.clearedgroups
	case user.EdgeUserGroups:
		return m.cleareduser_groups
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *UserMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown User unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *UserMutation) ResetEdge(name string) error {
	switch name {
	case user.EdgeLoginHistories:
		m.ResetLoginHistories()
		return nil
	case user.EdgeModels:
		m.ResetModels()
		return nil
	case user.EdgeTasks:
		m.ResetTasks()
		return nil
	case user.EdgeIdentities:
		m.ResetIdentities()
		return nil
	case user.EdgeWorkspaces:
		m.ResetWorkspaces()
		return nil
	case user.EdgeWorkspaceFiles:
		m.ResetWorkspaceFiles()
		return nil
	case user.EdgeAPIKeys:
		m.ResetAPIKeys()
		return nil
	case user.EdgeSecurityScannings:
		m.ResetSecurityScannings()
		return nil
	case user.EdgeAiemployees:
		m.ResetAiemployees()
		return nil
	case user.EdgeGroups:
		m.ResetGroups()
		return nil
	case user.EdgeUserGroups:
		m.ResetUserGroups()
		return nil
	}
	return fmt.Errorf("unknown User edge %s", name)
}

// UserGroupMutation represents an operation that mutates the UserGroup nodes in the graph.
type UserGroupMutation struct {
	config
	op                       Op
	typ                      string
	id                       *uuid.UUID
	name                     *string
	created_at               *time.Time
	clearedFields            map[string]struct{}
	owner                    *uuid.UUID
	clearedowner             bool
	users                    map[uuid.UUID]struct{}
	removedusers             map[uuid.UUID]struct{}
	clearedusers             bool
	admins                   map[uuid.UUID]struct{}
	removedadmins            map[uuid.UUID]struct{}
	clearedadmins            bool
	user_groups              map[uuid.UUID]struct{}
	removeduser_groups       map[uuid.UUID]struct{}
	cleareduser_groups       bool
	user_group_admins        map[uuid.UUID]struct{}
	removeduser_group_admins map[uuid.UUID]struct{}
	cleareduser_group_admins bool
	done                     bool
	oldValue                 func(context.Context) (*UserGroup, error)
	predicates               []predicate.UserGroup
}

var _ ent.Mutation = (*UserGroupMutation)(nil)

// usergroupOption allows management of the mutation configuration using functional options.
type usergroupOption func(*UserGroupMutation)

// newUserGroupMutation creates new mutation for the UserGroup entity.
func newUserGroupMutation(c config, op Op, opts ...usergroupOption) *UserGroupMutation {
	m := &UserGroupMutation{
		config:        c,
		op:            op,
		typ:           TypeUserGroup,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withUserGroupID sets the ID field of the mutation.
func withUserGroupID(id uuid.UUID) usergroupOption {
	return func(m *UserGroupMutation) {
		var (
			err   error
			once  sync.Once
			value *UserGroup
		)
		m.oldValue = func(ctx context.Context) (*UserGroup, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().UserGroup.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withUserGroup sets the old UserGroup of the mutation.
func withUserGroup(node *UserGroup) usergroupOption {
	return func(m *UserGroupMutation) {
		m.oldValue = func(context.Context) (*UserGroup, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m UserGroupMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m UserGroupMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of UserGroup entities.
func (m *UserGroupMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *UserGroupMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *UserGroupMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().UserGroup.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetAdminID sets the "admin_id" field.
func (m *UserGroupMutation) SetAdminID(u uuid.UUID) {
	m.owner = &u
}

// AdminID returns the value of the "admin_id" field in the mutation.
func (m *UserGroupMutation) AdminID() (r uuid.UUID, exists bool) {
	v := m.owner
	if v == nil {
		return
	}
	return *v, true
}

// OldAdminID returns the old "admin_id" field's value of the UserGroup entity.
// If the UserGroup object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserGroupMutation) OldAdminID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAdminID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAdminID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAdminID: %w", err)
	}
	return oldValue.AdminID, nil
}

// ResetAdminID resets all changes to the "admin_id" field.
func (m *UserGroupMutation) ResetAdminID() {
	m.owner = nil
}

// SetName sets the "name" field.
func (m *UserGroupMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *UserGroupMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the UserGroup entity.
// If the UserGroup object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserGroupMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *UserGroupMutation) ResetName() {
	m.name = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *UserGroupMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *UserGroupMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the UserGroup entity.
// If the UserGroup object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserGroupMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *UserGroupMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetOwnerID sets the "owner" edge to the Admin entity by id.
func (m *UserGroupMutation) SetOwnerID(id uuid.UUID) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the Admin entity.
func (m *UserGroupMutation) ClearOwner() {
	m.clearedowner = true
	m.clearedFields[usergroup.FieldAdminID] = struct{}{}
}

// OwnerCleared reports if the "owner" edge to the Admin entity was cleared.
func (m *UserGroupMutation) OwnerCleared() bool {
	return m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *UserGroupMutation) OwnerID() (id uuid.UUID, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *UserGroupMutation) OwnerIDs() (ids []uuid.UUID) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *UserGroupMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// AddUserIDs adds the "users" edge to the User entity by ids.
func (m *UserGroupMutation) AddUserIDs(ids ...uuid.UUID) {
	if m.users == nil {
		m.users = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.users[ids[i]] = struct{}{}
	}
}

// ClearUsers clears the "users" edge to the User entity.
func (m *UserGroupMutation) ClearUsers() {
	m.clearedusers = true
}

// UsersCleared reports if the "users" edge to the User entity was cleared.
func (m *UserGroupMutation) UsersCleared() bool {
	return m.clearedusers
}

// RemoveUserIDs removes the "users" edge to the User entity by IDs.
func (m *UserGroupMutation) RemoveUserIDs(ids ...uuid.UUID) {
	if m.removedusers == nil {
		m.removedusers = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.users, ids[i])
		m.removedusers[ids[i]] = struct{}{}
	}
}

// RemovedUsers returns the removed IDs of the "users" edge to the User entity.
func (m *UserGroupMutation) RemovedUsersIDs() (ids []uuid.UUID) {
	for id := range m.removedusers {
		ids = append(ids, id)
	}
	return
}

// UsersIDs returns the "users" edge IDs in the mutation.
func (m *UserGroupMutation) UsersIDs() (ids []uuid.UUID) {
	for id := range m.users {
		ids = append(ids, id)
	}
	return
}

// ResetUsers resets all changes to the "users" edge.
func (m *UserGroupMutation) ResetUsers() {
	m.users = nil
	m.clearedusers = false
	m.removedusers = nil
}

// AddAdminIDs adds the "admins" edge to the Admin entity by ids.
func (m *UserGroupMutation) AddAdminIDs(ids ...uuid.UUID) {
	if m.admins == nil {
		m.admins = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.admins[ids[i]] = struct{}{}
	}
}

// ClearAdmins clears the "admins" edge to the Admin entity.
func (m *UserGroupMutation) ClearAdmins() {
	m.clearedadmins = true
}

// AdminsCleared reports if the "admins" edge to the Admin entity was cleared.
func (m *UserGroupMutation) AdminsCleared() bool {
	return m.clearedadmins
}

// RemoveAdminIDs removes the "admins" edge to the Admin entity by IDs.
func (m *UserGroupMutation) RemoveAdminIDs(ids ...uuid.UUID) {
	if m.removedadmins == nil {
		m.removedadmins = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.admins, ids[i])
		m.removedadmins[ids[i]] = struct{}{}
	}
}

// RemovedAdmins returns the removed IDs of the "admins" edge to the Admin entity.
func (m *UserGroupMutation) RemovedAdminsIDs() (ids []uuid.UUID) {
	for id := range m.removedadmins {
		ids = append(ids, id)
	}
	return
}

// AdminsIDs returns the "admins" edge IDs in the mutation.
func (m *UserGroupMutation) AdminsIDs() (ids []uuid.UUID) {
	for id := range m.admins {
		ids = append(ids, id)
	}
	return
}

// ResetAdmins resets all changes to the "admins" edge.
func (m *UserGroupMutation) ResetAdmins() {
	m.admins = nil
	m.clearedadmins = false
	m.removedadmins = nil
}

// AddUserGroupIDs adds the "user_groups" edge to the UserGroupUser entity by ids.
func (m *UserGroupMutation) AddUserGroupIDs(ids ...uuid.UUID) {
	if m.user_groups == nil {
		m.user_groups = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.user_groups[ids[i]] = struct{}{}
	}
}

// ClearUserGroups clears the "user_groups" edge to the UserGroupUser entity.
func (m *UserGroupMutation) ClearUserGroups() {
	m.cleareduser_groups = true
}

// UserGroupsCleared reports if the "user_groups" edge to the UserGroupUser entity was cleared.
func (m *UserGroupMutation) UserGroupsCleared() bool {
	return m.cleareduser_groups
}

// RemoveUserGroupIDs removes the "user_groups" edge to the UserGroupUser entity by IDs.
func (m *UserGroupMutation) RemoveUserGroupIDs(ids ...uuid.UUID) {
	if m.removeduser_groups == nil {
		m.removeduser_groups = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.user_groups, ids[i])
		m.removeduser_groups[ids[i]] = struct{}{}
	}
}

// RemovedUserGroups returns the removed IDs of the "user_groups" edge to the UserGroupUser entity.
func (m *UserGroupMutation) RemovedUserGroupsIDs() (ids []uuid.UUID) {
	for id := range m.removeduser_groups {
		ids = append(ids, id)
	}
	return
}

// UserGroupsIDs returns the "user_groups" edge IDs in the mutation.
func (m *UserGroupMutation) UserGroupsIDs() (ids []uuid.UUID) {
	for id := range m.user_groups {
		ids = append(ids, id)
	}
	return
}

// ResetUserGroups resets all changes to the "user_groups" edge.
func (m *UserGroupMutation) ResetUserGroups() {
	m.user_groups = nil
	m.cleareduser_groups = false
	m.removeduser_groups = nil
}

// AddUserGroupAdminIDs adds the "user_group_admins" edge to the UserGroupAdmin entity by ids.
func (m *UserGroupMutation) AddUserGroupAdminIDs(ids ...uuid.UUID) {
	if m.user_group_admins == nil {
		m.user_group_admins = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.user_group_admins[ids[i]] = struct{}{}
	}
}

// ClearUserGroupAdmins clears the "user_group_admins" edge to the UserGroupAdmin entity.
func (m *UserGroupMutation) ClearUserGroupAdmins() {
	m.cleareduser_group_admins = true
}

// UserGroupAdminsCleared reports if the "user_group_admins" edge to the UserGroupAdmin entity was cleared.
func (m *UserGroupMutation) UserGroupAdminsCleared() bool {
	return m.cleareduser_group_admins
}

// RemoveUserGroupAdminIDs removes the "user_group_admins" edge to the UserGroupAdmin entity by IDs.
func (m *UserGroupMutation) RemoveUserGroupAdminIDs(ids ...uuid.UUID) {
	if m.removeduser_group_admins == nil {
		m.removeduser_group_admins = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.user_group_admins, ids[i])
		m.removeduser_group_admins[ids[i]] = struct{}{}
	}
}

// RemovedUserGroupAdmins returns the removed IDs of the "user_group_admins" edge to the UserGroupAdmin entity.
func (m *UserGroupMutation) RemovedUserGroupAdminsIDs() (ids []uuid.UUID) {
	for id := range m.removeduser_group_admins {
		ids = append(ids, id)
	}
	return
}

// UserGroupAdminsIDs returns the "user_group_admins" edge IDs in the mutation.
func (m *UserGroupMutation) UserGroupAdminsIDs() (ids []uuid.UUID) {
	for id := range m.user_group_admins {
		ids = append(ids, id)
	}
	return
}

// ResetUserGroupAdmins resets all changes to the "user_group_admins" edge.
func (m *UserGroupMutation) ResetUserGroupAdmins() {
	m.user_group_admins = nil
	m.cleareduser_group_admins = false
	m.removeduser_group_admins = nil
}

// Where appends a list predicates to the UserGroupMutation builder.
func (m *UserGroupMutation) Where(ps ...predicate.UserGroup) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the UserGroupMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *UserGroupMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.UserGroup, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *UserGroupMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *UserGroupMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (UserGroup).
func (m *UserGroupMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *UserGroupMutation) Fields() []string {
	fields := make([]string, 0, 3)
	if m.owner != nil {
		fields = append(fields, usergroup.FieldAdminID)
	}
	if m.name != nil {
		fields = append(fields, usergroup.FieldName)
	}
	if m.created_at != nil {
		fields = append(fields, usergroup.FieldCreatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *UserGroupMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case usergroup.FieldAdminID:
		return m.AdminID()
	case usergroup.FieldName:
		return m.Name()
	case usergroup.FieldCreatedAt:
		return m.CreatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *UserGroupMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case usergroup.FieldAdminID:
		return m.OldAdminID(ctx)
	case usergroup.FieldName:
		return m.OldName(ctx)
	case usergroup.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown UserGroup field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserGroupMutation) SetField(name string, value ent.Value) error {
	switch name {
	case usergroup.FieldAdminID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAdminID(v)
		return nil
	case usergroup.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case usergroup.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown UserGroup field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *UserGroupMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *UserGroupMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserGroupMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown UserGroup numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *UserGroupMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *UserGroupMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *UserGroupMutation) ClearField(name string) error {
	return fmt.Errorf("unknown UserGroup nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *UserGroupMutation) ResetField(name string) error {
	switch name {
	case usergroup.FieldAdminID:
		m.ResetAdminID()
		return nil
	case usergroup.FieldName:
		m.ResetName()
		return nil
	case usergroup.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	}
	return fmt.Errorf("unknown UserGroup field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *UserGroupMutation) AddedEdges() []string {
	edges := make([]string, 0, 5)
	if m.owner != nil {
		edges = append(edges, usergroup.EdgeOwner)
	}
	if m.users != nil {
		edges = append(edges, usergroup.EdgeUsers)
	}
	if m.admins != nil {
		edges = append(edges, usergroup.EdgeAdmins)
	}
	if m.user_groups != nil {
		edges = append(edges, usergroup.EdgeUserGroups)
	}
	if m.user_group_admins != nil {
		edges = append(edges, usergroup.EdgeUserGroupAdmins)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *UserGroupMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case usergroup.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	case usergroup.EdgeUsers:
		ids := make([]ent.Value, 0, len(m.users))
		for id := range m.users {
			ids = append(ids, id)
		}
		return ids
	case usergroup.EdgeAdmins:
		ids := make([]ent.Value, 0, len(m.admins))
		for id := range m.admins {
			ids = append(ids, id)
		}
		return ids
	case usergroup.EdgeUserGroups:
		ids := make([]ent.Value, 0, len(m.user_groups))
		for id := range m.user_groups {
			ids = append(ids, id)
		}
		return ids
	case usergroup.EdgeUserGroupAdmins:
		ids := make([]ent.Value, 0, len(m.user_group_admins))
		for id := range m.user_group_admins {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *UserGroupMutation) RemovedEdges() []string {
	edges := make([]string, 0, 5)
	if m.removedusers != nil {
		edges = append(edges, usergroup.EdgeUsers)
	}
	if m.removedadmins != nil {
		edges = append(edges, usergroup.EdgeAdmins)
	}
	if m.removeduser_groups != nil {
		edges = append(edges, usergroup.EdgeUserGroups)
	}
	if m.removeduser_group_admins != nil {
		edges = append(edges, usergroup.EdgeUserGroupAdmins)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *UserGroupMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case usergroup.EdgeUsers:
		ids := make([]ent.Value, 0, len(m.removedusers))
		for id := range m.removedusers {
			ids = append(ids, id)
		}
		return ids
	case usergroup.EdgeAdmins:
		ids := make([]ent.Value, 0, len(m.removedadmins))
		for id := range m.removedadmins {
			ids = append(ids, id)
		}
		return ids
	case usergroup.EdgeUserGroups:
		ids := make([]ent.Value, 0, len(m.removeduser_groups))
		for id := range m.removeduser_groups {
			ids = append(ids, id)
		}
		return ids
	case usergroup.EdgeUserGroupAdmins:
		ids := make([]ent.Value, 0, len(m.removeduser_group_admins))
		for id := range m.removeduser_group_admins {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *UserGroupMutation) ClearedEdges() []string {
	edges := make([]string, 0, 5)
	if m.clearedowner {
		edges = append(edges, usergroup.EdgeOwner)
	}
	if m.clearedusers {
		edges = append(edges, usergroup.EdgeUsers)
	}
	if m.clearedadmins {
		edges = append(edges, usergroup.EdgeAdmins)
	}
	if m.cleareduser_groups {
		edges = append(edges, usergroup.EdgeUserGroups)
	}
	if m.cleareduser_group_admins {
		edges = append(edges, usergroup.EdgeUserGroupAdmins)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *UserGroupMutation) EdgeCleared(name string) bool {
	switch name {
	case usergroup.EdgeOwner:
		return m.clearedowner
	case usergroup.EdgeUsers:
		return m.clearedusers
	case usergroup.EdgeAdmins:
		return m.clearedadmins
	case usergroup.EdgeUserGroups:
		return m.cleareduser_groups
	case usergroup.EdgeUserGroupAdmins:
		return m.cleareduser_group_admins
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *UserGroupMutation) ClearEdge(name string) error {
	switch name {
	case usergroup.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown UserGroup unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *UserGroupMutation) ResetEdge(name string) error {
	switch name {
	case usergroup.EdgeOwner:
		m.ResetOwner()
		return nil
	case usergroup.EdgeUsers:
		m.ResetUsers()
		return nil
	case usergroup.EdgeAdmins:
		m.ResetAdmins()
		return nil
	case usergroup.EdgeUserGroups:
		m.ResetUserGroups()
		return nil
	case usergroup.EdgeUserGroupAdmins:
		m.ResetUserGroupAdmins()
		return nil
	}
	return fmt.Errorf("unknown UserGroup edge %s", name)
}

// UserGroupAdminMutation represents an operation that mutates the UserGroupAdmin nodes in the graph.
type UserGroupAdminMutation struct {
	config
	op                Op
	typ               string
	id                *uuid.UUID
	clearedFields     map[string]struct{}
	user_group        *uuid.UUID
	cleareduser_group bool
	admin             *uuid.UUID
	clearedadmin      bool
	done              bool
	oldValue          func(context.Context) (*UserGroupAdmin, error)
	predicates        []predicate.UserGroupAdmin
}

var _ ent.Mutation = (*UserGroupAdminMutation)(nil)

// usergroupadminOption allows management of the mutation configuration using functional options.
type usergroupadminOption func(*UserGroupAdminMutation)

// newUserGroupAdminMutation creates new mutation for the UserGroupAdmin entity.
func newUserGroupAdminMutation(c config, op Op, opts ...usergroupadminOption) *UserGroupAdminMutation {
	m := &UserGroupAdminMutation{
		config:        c,
		op:            op,
		typ:           TypeUserGroupAdmin,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withUserGroupAdminID sets the ID field of the mutation.
func withUserGroupAdminID(id uuid.UUID) usergroupadminOption {
	return func(m *UserGroupAdminMutation) {
		var (
			err   error
			once  sync.Once
			value *UserGroupAdmin
		)
		m.oldValue = func(ctx context.Context) (*UserGroupAdmin, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().UserGroupAdmin.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withUserGroupAdmin sets the old UserGroupAdmin of the mutation.
func withUserGroupAdmin(node *UserGroupAdmin) usergroupadminOption {
	return func(m *UserGroupAdminMutation) {
		m.oldValue = func(context.Context) (*UserGroupAdmin, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m UserGroupAdminMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m UserGroupAdminMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of UserGroupAdmin entities.
func (m *UserGroupAdminMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *UserGroupAdminMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *UserGroupAdminMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().UserGroupAdmin.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetUserGroupID sets the "user_group_id" field.
func (m *UserGroupAdminMutation) SetUserGroupID(u uuid.UUID) {
	m.user_group = &u
}

// UserGroupID returns the value of the "user_group_id" field in the mutation.
func (m *UserGroupAdminMutation) UserGroupID() (r uuid.UUID, exists bool) {
	v := m.user_group
	if v == nil {
		return
	}
	return *v, true
}

// OldUserGroupID returns the old "user_group_id" field's value of the UserGroupAdmin entity.
// If the UserGroupAdmin object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserGroupAdminMutation) OldUserGroupID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserGroupID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserGroupID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserGroupID: %w", err)
	}
	return oldValue.UserGroupID, nil
}

// ResetUserGroupID resets all changes to the "user_group_id" field.
func (m *UserGroupAdminMutation) ResetUserGroupID() {
	m.user_group = nil
}

// SetAdminID sets the "admin_id" field.
func (m *UserGroupAdminMutation) SetAdminID(u uuid.UUID) {
	m.admin = &u
}

// AdminID returns the value of the "admin_id" field in the mutation.
func (m *UserGroupAdminMutation) AdminID() (r uuid.UUID, exists bool) {
	v := m.admin
	if v == nil {
		return
	}
	return *v, true
}

// OldAdminID returns the old "admin_id" field's value of the UserGroupAdmin entity.
// If the UserGroupAdmin object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserGroupAdminMutation) OldAdminID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAdminID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAdminID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAdminID: %w", err)
	}
	return oldValue.AdminID, nil
}

// ResetAdminID resets all changes to the "admin_id" field.
func (m *UserGroupAdminMutation) ResetAdminID() {
	m.admin = nil
}

// ClearUserGroup clears the "user_group" edge to the UserGroup entity.
func (m *UserGroupAdminMutation) ClearUserGroup() {
	m.cleareduser_group = true
	m.clearedFields[usergroupadmin.FieldUserGroupID] = struct{}{}
}

// UserGroupCleared reports if the "user_group" edge to the UserGroup entity was cleared.
func (m *UserGroupAdminMutation) UserGroupCleared() bool {
	return m.cleareduser_group
}

// UserGroupIDs returns the "user_group" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserGroupID instead. It exists only for internal usage by the builders.
func (m *UserGroupAdminMutation) UserGroupIDs() (ids []uuid.UUID) {
	if id := m.user_group; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUserGroup resets all changes to the "user_group" edge.
func (m *UserGroupAdminMutation) ResetUserGroup() {
	m.user_group = nil
	m.cleareduser_group = false
}

// ClearAdmin clears the "admin" edge to the Admin entity.
func (m *UserGroupAdminMutation) ClearAdmin() {
	m.clearedadmin = true
	m.clearedFields[usergroupadmin.FieldAdminID] = struct{}{}
}

// AdminCleared reports if the "admin" edge to the Admin entity was cleared.
func (m *UserGroupAdminMutation) AdminCleared() bool {
	return m.clearedadmin
}

// AdminIDs returns the "admin" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// AdminID instead. It exists only for internal usage by the builders.
func (m *UserGroupAdminMutation) AdminIDs() (ids []uuid.UUID) {
	if id := m.admin; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetAdmin resets all changes to the "admin" edge.
func (m *UserGroupAdminMutation) ResetAdmin() {
	m.admin = nil
	m.clearedadmin = false
}

// Where appends a list predicates to the UserGroupAdminMutation builder.
func (m *UserGroupAdminMutation) Where(ps ...predicate.UserGroupAdmin) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the UserGroupAdminMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *UserGroupAdminMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.UserGroupAdmin, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *UserGroupAdminMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *UserGroupAdminMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (UserGroupAdmin).
func (m *UserGroupAdminMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *UserGroupAdminMutation) Fields() []string {
	fields := make([]string, 0, 2)
	if m.user_group != nil {
		fields = append(fields, usergroupadmin.FieldUserGroupID)
	}
	if m.admin != nil {
		fields = append(fields, usergroupadmin.FieldAdminID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *UserGroupAdminMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case usergroupadmin.FieldUserGroupID:
		return m.UserGroupID()
	case usergroupadmin.FieldAdminID:
		return m.AdminID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *UserGroupAdminMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case usergroupadmin.FieldUserGroupID:
		return m.OldUserGroupID(ctx)
	case usergroupadmin.FieldAdminID:
		return m.OldAdminID(ctx)
	}
	return nil, fmt.Errorf("unknown UserGroupAdmin field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserGroupAdminMutation) SetField(name string, value ent.Value) error {
	switch name {
	case usergroupadmin.FieldUserGroupID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserGroupID(v)
		return nil
	case usergroupadmin.FieldAdminID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAdminID(v)
		return nil
	}
	return fmt.Errorf("unknown UserGroupAdmin field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *UserGroupAdminMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *UserGroupAdminMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserGroupAdminMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown UserGroupAdmin numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *UserGroupAdminMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *UserGroupAdminMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *UserGroupAdminMutation) ClearField(name string) error {
	return fmt.Errorf("unknown UserGroupAdmin nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *UserGroupAdminMutation) ResetField(name string) error {
	switch name {
	case usergroupadmin.FieldUserGroupID:
		m.ResetUserGroupID()
		return nil
	case usergroupadmin.FieldAdminID:
		m.ResetAdminID()
		return nil
	}
	return fmt.Errorf("unknown UserGroupAdmin field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *UserGroupAdminMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.user_group != nil {
		edges = append(edges, usergroupadmin.EdgeUserGroup)
	}
	if m.admin != nil {
		edges = append(edges, usergroupadmin.EdgeAdmin)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *UserGroupAdminMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case usergroupadmin.EdgeUserGroup:
		if id := m.user_group; id != nil {
			return []ent.Value{*id}
		}
	case usergroupadmin.EdgeAdmin:
		if id := m.admin; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *UserGroupAdminMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *UserGroupAdminMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *UserGroupAdminMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.cleareduser_group {
		edges = append(edges, usergroupadmin.EdgeUserGroup)
	}
	if m.clearedadmin {
		edges = append(edges, usergroupadmin.EdgeAdmin)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *UserGroupAdminMutation) EdgeCleared(name string) bool {
	switch name {
	case usergroupadmin.EdgeUserGroup:
		return m.cleareduser_group
	case usergroupadmin.EdgeAdmin:
		return m.clearedadmin
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *UserGroupAdminMutation) ClearEdge(name string) error {
	switch name {
	case usergroupadmin.EdgeUserGroup:
		m.ClearUserGroup()
		return nil
	case usergroupadmin.EdgeAdmin:
		m.ClearAdmin()
		return nil
	}
	return fmt.Errorf("unknown UserGroupAdmin unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *UserGroupAdminMutation) ResetEdge(name string) error {
	switch name {
	case usergroupadmin.EdgeUserGroup:
		m.ResetUserGroup()
		return nil
	case usergroupadmin.EdgeAdmin:
		m.ResetAdmin()
		return nil
	}
	return fmt.Errorf("unknown UserGroupAdmin edge %s", name)
}

// UserGroupUserMutation represents an operation that mutates the UserGroupUser nodes in the graph.
type UserGroupUserMutation struct {
	config
	op                Op
	typ               string
	id                *uuid.UUID
	clearedFields     map[string]struct{}
	user_group        *uuid.UUID
	cleareduser_group bool
	user              *uuid.UUID
	cleareduser       bool
	done              bool
	oldValue          func(context.Context) (*UserGroupUser, error)
	predicates        []predicate.UserGroupUser
}

var _ ent.Mutation = (*UserGroupUserMutation)(nil)

// usergroupuserOption allows management of the mutation configuration using functional options.
type usergroupuserOption func(*UserGroupUserMutation)

// newUserGroupUserMutation creates new mutation for the UserGroupUser entity.
func newUserGroupUserMutation(c config, op Op, opts ...usergroupuserOption) *UserGroupUserMutation {
	m := &UserGroupUserMutation{
		config:        c,
		op:            op,
		typ:           TypeUserGroupUser,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withUserGroupUserID sets the ID field of the mutation.
func withUserGroupUserID(id uuid.UUID) usergroupuserOption {
	return func(m *UserGroupUserMutation) {
		var (
			err   error
			once  sync.Once
			value *UserGroupUser
		)
		m.oldValue = func(ctx context.Context) (*UserGroupUser, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().UserGroupUser.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withUserGroupUser sets the old UserGroupUser of the mutation.
func withUserGroupUser(node *UserGroupUser) usergroupuserOption {
	return func(m *UserGroupUserMutation) {
		m.oldValue = func(context.Context) (*UserGroupUser, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m UserGroupUserMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m UserGroupUserMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of UserGroupUser entities.
func (m *UserGroupUserMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *UserGroupUserMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *UserGroupUserMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().UserGroupUser.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetUserGroupID sets the "user_group_id" field.
func (m *UserGroupUserMutation) SetUserGroupID(u uuid.UUID) {
	m.user_group = &u
}

// UserGroupID returns the value of the "user_group_id" field in the mutation.
func (m *UserGroupUserMutation) UserGroupID() (r uuid.UUID, exists bool) {
	v := m.user_group
	if v == nil {
		return
	}
	return *v, true
}

// OldUserGroupID returns the old "user_group_id" field's value of the UserGroupUser entity.
// If the UserGroupUser object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserGroupUserMutation) OldUserGroupID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserGroupID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserGroupID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserGroupID: %w", err)
	}
	return oldValue.UserGroupID, nil
}

// ResetUserGroupID resets all changes to the "user_group_id" field.
func (m *UserGroupUserMutation) ResetUserGroupID() {
	m.user_group = nil
}

// SetUserID sets the "user_id" field.
func (m *UserGroupUserMutation) SetUserID(u uuid.UUID) {
	m.user = &u
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *UserGroupUserMutation) UserID() (r uuid.UUID, exists bool) {
	v := m.user
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the UserGroupUser entity.
// If the UserGroupUser object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserGroupUserMutation) OldUserID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ResetUserID resets all changes to the "user_id" field.
func (m *UserGroupUserMutation) ResetUserID() {
	m.user = nil
}

// ClearUserGroup clears the "user_group" edge to the UserGroup entity.
func (m *UserGroupUserMutation) ClearUserGroup() {
	m.cleareduser_group = true
	m.clearedFields[usergroupuser.FieldUserGroupID] = struct{}{}
}

// UserGroupCleared reports if the "user_group" edge to the UserGroup entity was cleared.
func (m *UserGroupUserMutation) UserGroupCleared() bool {
	return m.cleareduser_group
}

// UserGroupIDs returns the "user_group" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserGroupID instead. It exists only for internal usage by the builders.
func (m *UserGroupUserMutation) UserGroupIDs() (ids []uuid.UUID) {
	if id := m.user_group; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUserGroup resets all changes to the "user_group" edge.
func (m *UserGroupUserMutation) ResetUserGroup() {
	m.user_group = nil
	m.cleareduser_group = false
}

// ClearUser clears the "user" edge to the User entity.
func (m *UserGroupUserMutation) ClearUser() {
	m.cleareduser = true
	m.clearedFields[usergroupuser.FieldUserID] = struct{}{}
}

// UserCleared reports if the "user" edge to the User entity was cleared.
func (m *UserGroupUserMutation) UserCleared() bool {
	return m.cleareduser
}

// UserIDs returns the "user" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserID instead. It exists only for internal usage by the builders.
func (m *UserGroupUserMutation) UserIDs() (ids []uuid.UUID) {
	if id := m.user; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUser resets all changes to the "user" edge.
func (m *UserGroupUserMutation) ResetUser() {
	m.user = nil
	m.cleareduser = false
}

// Where appends a list predicates to the UserGroupUserMutation builder.
func (m *UserGroupUserMutation) Where(ps ...predicate.UserGroupUser) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the UserGroupUserMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *UserGroupUserMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.UserGroupUser, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *UserGroupUserMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *UserGroupUserMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (UserGroupUser).
func (m *UserGroupUserMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *UserGroupUserMutation) Fields() []string {
	fields := make([]string, 0, 2)
	if m.user_group != nil {
		fields = append(fields, usergroupuser.FieldUserGroupID)
	}
	if m.user != nil {
		fields = append(fields, usergroupuser.FieldUserID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *UserGroupUserMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case usergroupuser.FieldUserGroupID:
		return m.UserGroupID()
	case usergroupuser.FieldUserID:
		return m.UserID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *UserGroupUserMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case usergroupuser.FieldUserGroupID:
		return m.OldUserGroupID(ctx)
	case usergroupuser.FieldUserID:
		return m.OldUserID(ctx)
	}
	return nil, fmt.Errorf("unknown UserGroupUser field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserGroupUserMutation) SetField(name string, value ent.Value) error {
	switch name {
	case usergroupuser.FieldUserGroupID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserGroupID(v)
		return nil
	case usergroupuser.FieldUserID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	}
	return fmt.Errorf("unknown UserGroupUser field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *UserGroupUserMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *UserGroupUserMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserGroupUserMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown UserGroupUser numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *UserGroupUserMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *UserGroupUserMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *UserGroupUserMutation) ClearField(name string) error {
	return fmt.Errorf("unknown UserGroupUser nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *UserGroupUserMutation) ResetField(name string) error {
	switch name {
	case usergroupuser.FieldUserGroupID:
		m.ResetUserGroupID()
		return nil
	case usergroupuser.FieldUserID:
		m.ResetUserID()
		return nil
	}
	return fmt.Errorf("unknown UserGroupUser field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *UserGroupUserMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.user_group != nil {
		edges = append(edges, usergroupuser.EdgeUserGroup)
	}
	if m.user != nil {
		edges = append(edges, usergroupuser.EdgeUser)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *UserGroupUserMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case usergroupuser.EdgeUserGroup:
		if id := m.user_group; id != nil {
			return []ent.Value{*id}
		}
	case usergroupuser.EdgeUser:
		if id := m.user; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *UserGroupUserMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *UserGroupUserMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *UserGroupUserMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.cleareduser_group {
		edges = append(edges, usergroupuser.EdgeUserGroup)
	}
	if m.cleareduser {
		edges = append(edges, usergroupuser.EdgeUser)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *UserGroupUserMutation) EdgeCleared(name string) bool {
	switch name {
	case usergroupuser.EdgeUserGroup:
		return m.cleareduser_group
	case usergroupuser.EdgeUser:
		return m.cleareduser
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *UserGroupUserMutation) ClearEdge(name string) error {
	switch name {
	case usergroupuser.EdgeUserGroup:
		m.ClearUserGroup()
		return nil
	case usergroupuser.EdgeUser:
		m.ClearUser()
		return nil
	}
	return fmt.Errorf("unknown UserGroupUser unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *UserGroupUserMutation) ResetEdge(name string) error {
	switch name {
	case usergroupuser.EdgeUserGroup:
		m.ResetUserGroup()
		return nil
	case usergroupuser.EdgeUser:
		m.ResetUser()
		return nil
	}
	return fmt.Errorf("unknown UserGroupUser edge %s", name)
}

// UserIdentityMutation represents an operation that mutates the UserIdentity nodes in the graph.
type UserIdentityMutation struct {
	config
	op            Op
	typ           string
	id            *uuid.UUID
	deleted_at    *time.Time
	platform      *consts.UserPlatform
	identity_id   *string
	union_id      *string
	nickname      *string
	email         *string
	avatar_url    *string
	created_at    *time.Time
	clearedFields map[string]struct{}
	user          *uuid.UUID
	cleareduser   bool
	done          bool
	oldValue      func(context.Context) (*UserIdentity, error)
	predicates    []predicate.UserIdentity
}

var _ ent.Mutation = (*UserIdentityMutation)(nil)

// useridentityOption allows management of the mutation configuration using functional options.
type useridentityOption func(*UserIdentityMutation)

// newUserIdentityMutation creates new mutation for the UserIdentity entity.
func newUserIdentityMutation(c config, op Op, opts ...useridentityOption) *UserIdentityMutation {
	m := &UserIdentityMutation{
		config:        c,
		op:            op,
		typ:           TypeUserIdentity,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withUserIdentityID sets the ID field of the mutation.
func withUserIdentityID(id uuid.UUID) useridentityOption {
	return func(m *UserIdentityMutation) {
		var (
			err   error
			once  sync.Once
			value *UserIdentity
		)
		m.oldValue = func(ctx context.Context) (*UserIdentity, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().UserIdentity.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withUserIdentity sets the old UserIdentity of the mutation.
func withUserIdentity(node *UserIdentity) useridentityOption {
	return func(m *UserIdentityMutation) {
		m.oldValue = func(context.Context) (*UserIdentity, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m UserIdentityMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m UserIdentityMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of UserIdentity entities.
func (m *UserIdentityMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *UserIdentityMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *UserIdentityMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().UserIdentity.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetDeletedAt sets the "deleted_at" field.
func (m *UserIdentityMutation) SetDeletedAt(t time.Time) {
	m.deleted_at = &t
}

// DeletedAt returns the value of the "deleted_at" field in the mutation.
func (m *UserIdentityMutation) DeletedAt() (r time.Time, exists bool) {
	v := m.deleted_at
	if v == nil {
		return
	}
	return *v, true
}

// OldDeletedAt returns the old "deleted_at" field's value of the UserIdentity entity.
// If the UserIdentity object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserIdentityMutation) OldDeletedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDeletedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDeletedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDeletedAt: %w", err)
	}
	return oldValue.DeletedAt, nil
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (m *UserIdentityMutation) ClearDeletedAt() {
	m.deleted_at = nil
	m.clearedFields[useridentity.FieldDeletedAt] = struct{}{}
}

// DeletedAtCleared returns if the "deleted_at" field was cleared in this mutation.
func (m *UserIdentityMutation) DeletedAtCleared() bool {
	_, ok := m.clearedFields[useridentity.FieldDeletedAt]
	return ok
}

// ResetDeletedAt resets all changes to the "deleted_at" field.
func (m *UserIdentityMutation) ResetDeletedAt() {
	m.deleted_at = nil
	delete(m.clearedFields, useridentity.FieldDeletedAt)
}

// SetUserID sets the "user_id" field.
func (m *UserIdentityMutation) SetUserID(u uuid.UUID) {
	m.user = &u
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *UserIdentityMutation) UserID() (r uuid.UUID, exists bool) {
	v := m.user
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the UserIdentity entity.
// If the UserIdentity object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserIdentityMutation) OldUserID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ClearUserID clears the value of the "user_id" field.
func (m *UserIdentityMutation) ClearUserID() {
	m.user = nil
	m.clearedFields[useridentity.FieldUserID] = struct{}{}
}

// UserIDCleared returns if the "user_id" field was cleared in this mutation.
func (m *UserIdentityMutation) UserIDCleared() bool {
	_, ok := m.clearedFields[useridentity.FieldUserID]
	return ok
}

// ResetUserID resets all changes to the "user_id" field.
func (m *UserIdentityMutation) ResetUserID() {
	m.user = nil
	delete(m.clearedFields, useridentity.FieldUserID)
}

// SetPlatform sets the "platform" field.
func (m *UserIdentityMutation) SetPlatform(cp consts.UserPlatform) {
	m.platform = &cp
}

// Platform returns the value of the "platform" field in the mutation.
func (m *UserIdentityMutation) Platform() (r consts.UserPlatform, exists bool) {
	v := m.platform
	if v == nil {
		return
	}
	return *v, true
}

// OldPlatform returns the old "platform" field's value of the UserIdentity entity.
// If the UserIdentity object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserIdentityMutation) OldPlatform(ctx context.Context) (v consts.UserPlatform, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPlatform is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPlatform requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPlatform: %w", err)
	}
	return oldValue.Platform, nil
}

// ResetPlatform resets all changes to the "platform" field.
func (m *UserIdentityMutation) ResetPlatform() {
	m.platform = nil
}

// SetIdentityID sets the "identity_id" field.
func (m *UserIdentityMutation) SetIdentityID(s string) {
	m.identity_id = &s
}

// IdentityID returns the value of the "identity_id" field in the mutation.
func (m *UserIdentityMutation) IdentityID() (r string, exists bool) {
	v := m.identity_id
	if v == nil {
		return
	}
	return *v, true
}

// OldIdentityID returns the old "identity_id" field's value of the UserIdentity entity.
// If the UserIdentity object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserIdentityMutation) OldIdentityID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldIdentityID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldIdentityID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldIdentityID: %w", err)
	}
	return oldValue.IdentityID, nil
}

// ResetIdentityID resets all changes to the "identity_id" field.
func (m *UserIdentityMutation) ResetIdentityID() {
	m.identity_id = nil
}

// SetUnionID sets the "union_id" field.
func (m *UserIdentityMutation) SetUnionID(s string) {
	m.union_id = &s
}

// UnionID returns the value of the "union_id" field in the mutation.
func (m *UserIdentityMutation) UnionID() (r string, exists bool) {
	v := m.union_id
	if v == nil {
		return
	}
	return *v, true
}

// OldUnionID returns the old "union_id" field's value of the UserIdentity entity.
// If the UserIdentity object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserIdentityMutation) OldUnionID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUnionID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUnionID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUnionID: %w", err)
	}
	return oldValue.UnionID, nil
}

// ClearUnionID clears the value of the "union_id" field.
func (m *UserIdentityMutation) ClearUnionID() {
	m.union_id = nil
	m.clearedFields[useridentity.FieldUnionID] = struct{}{}
}

// UnionIDCleared returns if the "union_id" field was cleared in this mutation.
func (m *UserIdentityMutation) UnionIDCleared() bool {
	_, ok := m.clearedFields[useridentity.FieldUnionID]
	return ok
}

// ResetUnionID resets all changes to the "union_id" field.
func (m *UserIdentityMutation) ResetUnionID() {
	m.union_id = nil
	delete(m.clearedFields, useridentity.FieldUnionID)
}

// SetNickname sets the "nickname" field.
func (m *UserIdentityMutation) SetNickname(s string) {
	m.nickname = &s
}

// Nickname returns the value of the "nickname" field in the mutation.
func (m *UserIdentityMutation) Nickname() (r string, exists bool) {
	v := m.nickname
	if v == nil {
		return
	}
	return *v, true
}

// OldNickname returns the old "nickname" field's value of the UserIdentity entity.
// If the UserIdentity object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserIdentityMutation) OldNickname(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldNickname is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldNickname requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNickname: %w", err)
	}
	return oldValue.Nickname, nil
}

// ClearNickname clears the value of the "nickname" field.
func (m *UserIdentityMutation) ClearNickname() {
	m.nickname = nil
	m.clearedFields[useridentity.FieldNickname] = struct{}{}
}

// NicknameCleared returns if the "nickname" field was cleared in this mutation.
func (m *UserIdentityMutation) NicknameCleared() bool {
	_, ok := m.clearedFields[useridentity.FieldNickname]
	return ok
}

// ResetNickname resets all changes to the "nickname" field.
func (m *UserIdentityMutation) ResetNickname() {
	m.nickname = nil
	delete(m.clearedFields, useridentity.FieldNickname)
}

// SetEmail sets the "email" field.
func (m *UserIdentityMutation) SetEmail(s string) {
	m.email = &s
}

// Email returns the value of the "email" field in the mutation.
func (m *UserIdentityMutation) Email() (r string, exists bool) {
	v := m.email
	if v == nil {
		return
	}
	return *v, true
}

// OldEmail returns the old "email" field's value of the UserIdentity entity.
// If the UserIdentity object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserIdentityMutation) OldEmail(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEmail is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEmail requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEmail: %w", err)
	}
	return oldValue.Email, nil
}

// ClearEmail clears the value of the "email" field.
func (m *UserIdentityMutation) ClearEmail() {
	m.email = nil
	m.clearedFields[useridentity.FieldEmail] = struct{}{}
}

// EmailCleared returns if the "email" field was cleared in this mutation.
func (m *UserIdentityMutation) EmailCleared() bool {
	_, ok := m.clearedFields[useridentity.FieldEmail]
	return ok
}

// ResetEmail resets all changes to the "email" field.
func (m *UserIdentityMutation) ResetEmail() {
	m.email = nil
	delete(m.clearedFields, useridentity.FieldEmail)
}

// SetAvatarURL sets the "avatar_url" field.
func (m *UserIdentityMutation) SetAvatarURL(s string) {
	m.avatar_url = &s
}

// AvatarURL returns the value of the "avatar_url" field in the mutation.
func (m *UserIdentityMutation) AvatarURL() (r string, exists bool) {
	v := m.avatar_url
	if v == nil {
		return
	}
	return *v, true
}

// OldAvatarURL returns the old "avatar_url" field's value of the UserIdentity entity.
// If the UserIdentity object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserIdentityMutation) OldAvatarURL(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAvatarURL is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAvatarURL requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAvatarURL: %w", err)
	}
	return oldValue.AvatarURL, nil
}

// ClearAvatarURL clears the value of the "avatar_url" field.
func (m *UserIdentityMutation) ClearAvatarURL() {
	m.avatar_url = nil
	m.clearedFields[useridentity.FieldAvatarURL] = struct{}{}
}

// AvatarURLCleared returns if the "avatar_url" field was cleared in this mutation.
func (m *UserIdentityMutation) AvatarURLCleared() bool {
	_, ok := m.clearedFields[useridentity.FieldAvatarURL]
	return ok
}

// ResetAvatarURL resets all changes to the "avatar_url" field.
func (m *UserIdentityMutation) ResetAvatarURL() {
	m.avatar_url = nil
	delete(m.clearedFields, useridentity.FieldAvatarURL)
}

// SetCreatedAt sets the "created_at" field.
func (m *UserIdentityMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *UserIdentityMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the UserIdentity entity.
// If the UserIdentity object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserIdentityMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *UserIdentityMutation) ResetCreatedAt() {
	m.created_at = nil
}

// ClearUser clears the "user" edge to the User entity.
func (m *UserIdentityMutation) ClearUser() {
	m.cleareduser = true
	m.clearedFields[useridentity.FieldUserID] = struct{}{}
}

// UserCleared reports if the "user" edge to the User entity was cleared.
func (m *UserIdentityMutation) UserCleared() bool {
	return m.UserIDCleared() || m.cleareduser
}

// UserIDs returns the "user" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserID instead. It exists only for internal usage by the builders.
func (m *UserIdentityMutation) UserIDs() (ids []uuid.UUID) {
	if id := m.user; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUser resets all changes to the "user" edge.
func (m *UserIdentityMutation) ResetUser() {
	m.user = nil
	m.cleareduser = false
}

// Where appends a list predicates to the UserIdentityMutation builder.
func (m *UserIdentityMutation) Where(ps ...predicate.UserIdentity) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the UserIdentityMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *UserIdentityMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.UserIdentity, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *UserIdentityMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *UserIdentityMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (UserIdentity).
func (m *UserIdentityMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *UserIdentityMutation) Fields() []string {
	fields := make([]string, 0, 9)
	if m.deleted_at != nil {
		fields = append(fields, useridentity.FieldDeletedAt)
	}
	if m.user != nil {
		fields = append(fields, useridentity.FieldUserID)
	}
	if m.platform != nil {
		fields = append(fields, useridentity.FieldPlatform)
	}
	if m.identity_id != nil {
		fields = append(fields, useridentity.FieldIdentityID)
	}
	if m.union_id != nil {
		fields = append(fields, useridentity.FieldUnionID)
	}
	if m.nickname != nil {
		fields = append(fields, useridentity.FieldNickname)
	}
	if m.email != nil {
		fields = append(fields, useridentity.FieldEmail)
	}
	if m.avatar_url != nil {
		fields = append(fields, useridentity.FieldAvatarURL)
	}
	if m.created_at != nil {
		fields = append(fields, useridentity.FieldCreatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *UserIdentityMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case useridentity.FieldDeletedAt:
		return m.DeletedAt()
	case useridentity.FieldUserID:
		return m.UserID()
	case useridentity.FieldPlatform:
		return m.Platform()
	case useridentity.FieldIdentityID:
		return m.IdentityID()
	case useridentity.FieldUnionID:
		return m.UnionID()
	case useridentity.FieldNickname:
		return m.Nickname()
	case useridentity.FieldEmail:
		return m.Email()
	case useridentity.FieldAvatarURL:
		return m.AvatarURL()
	case useridentity.FieldCreatedAt:
		return m.CreatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *UserIdentityMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case useridentity.FieldDeletedAt:
		return m.OldDeletedAt(ctx)
	case useridentity.FieldUserID:
		return m.OldUserID(ctx)
	case useridentity.FieldPlatform:
		return m.OldPlatform(ctx)
	case useridentity.FieldIdentityID:
		return m.OldIdentityID(ctx)
	case useridentity.FieldUnionID:
		return m.OldUnionID(ctx)
	case useridentity.FieldNickname:
		return m.OldNickname(ctx)
	case useridentity.FieldEmail:
		return m.OldEmail(ctx)
	case useridentity.FieldAvatarURL:
		return m.OldAvatarURL(ctx)
	case useridentity.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown UserIdentity field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserIdentityMutation) SetField(name string, value ent.Value) error {
	switch name {
	case useridentity.FieldDeletedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDeletedAt(v)
		return nil
	case useridentity.FieldUserID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case useridentity.FieldPlatform:
		v, ok := value.(consts.UserPlatform)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPlatform(v)
		return nil
	case useridentity.FieldIdentityID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetIdentityID(v)
		return nil
	case useridentity.FieldUnionID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUnionID(v)
		return nil
	case useridentity.FieldNickname:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNickname(v)
		return nil
	case useridentity.FieldEmail:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEmail(v)
		return nil
	case useridentity.FieldAvatarURL:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAvatarURL(v)
		return nil
	case useridentity.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown UserIdentity field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *UserIdentityMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *UserIdentityMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserIdentityMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown UserIdentity numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *UserIdentityMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(useridentity.FieldDeletedAt) {
		fields = append(fields, useridentity.FieldDeletedAt)
	}
	if m.FieldCleared(useridentity.FieldUserID) {
		fields = append(fields, useridentity.FieldUserID)
	}
	if m.FieldCleared(useridentity.FieldUnionID) {
		fields = append(fields, useridentity.FieldUnionID)
	}
	if m.FieldCleared(useridentity.FieldNickname) {
		fields = append(fields, useridentity.FieldNickname)
	}
	if m.FieldCleared(useridentity.FieldEmail) {
		fields = append(fields, useridentity.FieldEmail)
	}
	if m.FieldCleared(useridentity.FieldAvatarURL) {
		fields = append(fields, useridentity.FieldAvatarURL)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *UserIdentityMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *UserIdentityMutation) ClearField(name string) error {
	switch name {
	case useridentity.FieldDeletedAt:
		m.ClearDeletedAt()
		return nil
	case useridentity.FieldUserID:
		m.ClearUserID()
		return nil
	case useridentity.FieldUnionID:
		m.ClearUnionID()
		return nil
	case useridentity.FieldNickname:
		m.ClearNickname()
		return nil
	case useridentity.FieldEmail:
		m.ClearEmail()
		return nil
	case useridentity.FieldAvatarURL:
		m.ClearAvatarURL()
		return nil
	}
	return fmt.Errorf("unknown UserIdentity nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *UserIdentityMutation) ResetField(name string) error {
	switch name {
	case useridentity.FieldDeletedAt:
		m.ResetDeletedAt()
		return nil
	case useridentity.FieldUserID:
		m.ResetUserID()
		return nil
	case useridentity.FieldPlatform:
		m.ResetPlatform()
		return nil
	case useridentity.FieldIdentityID:
		m.ResetIdentityID()
		return nil
	case useridentity.FieldUnionID:
		m.ResetUnionID()
		return nil
	case useridentity.FieldNickname:
		m.ResetNickname()
		return nil
	case useridentity.FieldEmail:
		m.ResetEmail()
		return nil
	case useridentity.FieldAvatarURL:
		m.ResetAvatarURL()
		return nil
	case useridentity.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	}
	return fmt.Errorf("unknown UserIdentity field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *UserIdentityMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.user != nil {
		edges = append(edges, useridentity.EdgeUser)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *UserIdentityMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case useridentity.EdgeUser:
		if id := m.user; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *UserIdentityMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *UserIdentityMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *UserIdentityMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.cleareduser {
		edges = append(edges, useridentity.EdgeUser)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *UserIdentityMutation) EdgeCleared(name string) bool {
	switch name {
	case useridentity.EdgeUser:
		return m.cleareduser
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *UserIdentityMutation) ClearEdge(name string) error {
	switch name {
	case useridentity.EdgeUser:
		m.ClearUser()
		return nil
	}
	return fmt.Errorf("unknown UserIdentity unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *UserIdentityMutation) ResetEdge(name string) error {
	switch name {
	case useridentity.EdgeUser:
		m.ResetUser()
		return nil
	}
	return fmt.Errorf("unknown UserIdentity edge %s", name)
}

// UserLoginHistoryMutation represents an operation that mutates the UserLoginHistory nodes in the graph.
type UserLoginHistoryMutation struct {
	config
	op             Op
	typ            string
	id             *uuid.UUID
	ip             *string
	country        *string
	province       *string
	city           *string
	isp            *string
	asn            *string
	client_version *string
	os_type        *consts.OSType
	os_release     *consts.OSRelease
	hostname       *string
	client_id      *string
	created_at     *time.Time
	clearedFields  map[string]struct{}
	owner          *uuid.UUID
	clearedowner   bool
	done           bool
	oldValue       func(context.Context) (*UserLoginHistory, error)
	predicates     []predicate.UserLoginHistory
}

var _ ent.Mutation = (*UserLoginHistoryMutation)(nil)

// userloginhistoryOption allows management of the mutation configuration using functional options.
type userloginhistoryOption func(*UserLoginHistoryMutation)

// newUserLoginHistoryMutation creates new mutation for the UserLoginHistory entity.
func newUserLoginHistoryMutation(c config, op Op, opts ...userloginhistoryOption) *UserLoginHistoryMutation {
	m := &UserLoginHistoryMutation{
		config:        c,
		op:            op,
		typ:           TypeUserLoginHistory,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withUserLoginHistoryID sets the ID field of the mutation.
func withUserLoginHistoryID(id uuid.UUID) userloginhistoryOption {
	return func(m *UserLoginHistoryMutation) {
		var (
			err   error
			once  sync.Once
			value *UserLoginHistory
		)
		m.oldValue = func(ctx context.Context) (*UserLoginHistory, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().UserLoginHistory.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withUserLoginHistory sets the old UserLoginHistory of the mutation.
func withUserLoginHistory(node *UserLoginHistory) userloginhistoryOption {
	return func(m *UserLoginHistoryMutation) {
		m.oldValue = func(context.Context) (*UserLoginHistory, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m UserLoginHistoryMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m UserLoginHistoryMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of UserLoginHistory entities.
func (m *UserLoginHistoryMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *UserLoginHistoryMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *UserLoginHistoryMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().UserLoginHistory.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetUserID sets the "user_id" field.
func (m *UserLoginHistoryMutation) SetUserID(u uuid.UUID) {
	m.owner = &u
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *UserLoginHistoryMutation) UserID() (r uuid.UUID, exists bool) {
	v := m.owner
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the UserLoginHistory entity.
// If the UserLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserLoginHistoryMutation) OldUserID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ClearUserID clears the value of the "user_id" field.
func (m *UserLoginHistoryMutation) ClearUserID() {
	m.owner = nil
	m.clearedFields[userloginhistory.FieldUserID] = struct{}{}
}

// UserIDCleared returns if the "user_id" field was cleared in this mutation.
func (m *UserLoginHistoryMutation) UserIDCleared() bool {
	_, ok := m.clearedFields[userloginhistory.FieldUserID]
	return ok
}

// ResetUserID resets all changes to the "user_id" field.
func (m *UserLoginHistoryMutation) ResetUserID() {
	m.owner = nil
	delete(m.clearedFields, userloginhistory.FieldUserID)
}

// SetIP sets the "ip" field.
func (m *UserLoginHistoryMutation) SetIP(s string) {
	m.ip = &s
}

// IP returns the value of the "ip" field in the mutation.
func (m *UserLoginHistoryMutation) IP() (r string, exists bool) {
	v := m.ip
	if v == nil {
		return
	}
	return *v, true
}

// OldIP returns the old "ip" field's value of the UserLoginHistory entity.
// If the UserLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserLoginHistoryMutation) OldIP(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldIP is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldIP requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldIP: %w", err)
	}
	return oldValue.IP, nil
}

// ResetIP resets all changes to the "ip" field.
func (m *UserLoginHistoryMutation) ResetIP() {
	m.ip = nil
}

// SetCountry sets the "country" field.
func (m *UserLoginHistoryMutation) SetCountry(s string) {
	m.country = &s
}

// Country returns the value of the "country" field in the mutation.
func (m *UserLoginHistoryMutation) Country() (r string, exists bool) {
	v := m.country
	if v == nil {
		return
	}
	return *v, true
}

// OldCountry returns the old "country" field's value of the UserLoginHistory entity.
// If the UserLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserLoginHistoryMutation) OldCountry(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCountry is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCountry requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCountry: %w", err)
	}
	return oldValue.Country, nil
}

// ResetCountry resets all changes to the "country" field.
func (m *UserLoginHistoryMutation) ResetCountry() {
	m.country = nil
}

// SetProvince sets the "province" field.
func (m *UserLoginHistoryMutation) SetProvince(s string) {
	m.province = &s
}

// Province returns the value of the "province" field in the mutation.
func (m *UserLoginHistoryMutation) Province() (r string, exists bool) {
	v := m.province
	if v == nil {
		return
	}
	return *v, true
}

// OldProvince returns the old "province" field's value of the UserLoginHistory entity.
// If the UserLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserLoginHistoryMutation) OldProvince(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldProvince is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldProvince requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldProvince: %w", err)
	}
	return oldValue.Province, nil
}

// ResetProvince resets all changes to the "province" field.
func (m *UserLoginHistoryMutation) ResetProvince() {
	m.province = nil
}

// SetCity sets the "city" field.
func (m *UserLoginHistoryMutation) SetCity(s string) {
	m.city = &s
}

// City returns the value of the "city" field in the mutation.
func (m *UserLoginHistoryMutation) City() (r string, exists bool) {
	v := m.city
	if v == nil {
		return
	}
	return *v, true
}

// OldCity returns the old "city" field's value of the UserLoginHistory entity.
// If the UserLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserLoginHistoryMutation) OldCity(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCity is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCity requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCity: %w", err)
	}
	return oldValue.City, nil
}

// ResetCity resets all changes to the "city" field.
func (m *UserLoginHistoryMutation) ResetCity() {
	m.city = nil
}

// SetIsp sets the "isp" field.
func (m *UserLoginHistoryMutation) SetIsp(s string) {
	m.isp = &s
}

// Isp returns the value of the "isp" field in the mutation.
func (m *UserLoginHistoryMutation) Isp() (r string, exists bool) {
	v := m.isp
	if v == nil {
		return
	}
	return *v, true
}

// OldIsp returns the old "isp" field's value of the UserLoginHistory entity.
// If the UserLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserLoginHistoryMutation) OldIsp(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldIsp is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldIsp requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldIsp: %w", err)
	}
	return oldValue.Isp, nil
}

// ClearIsp clears the value of the "isp" field.
func (m *UserLoginHistoryMutation) ClearIsp() {
	m.isp = nil
	m.clearedFields[userloginhistory.FieldIsp] = struct{}{}
}

// IspCleared returns if the "isp" field was cleared in this mutation.
func (m *UserLoginHistoryMutation) IspCleared() bool {
	_, ok := m.clearedFields[userloginhistory.FieldIsp]
	return ok
}

// ResetIsp resets all changes to the "isp" field.
func (m *UserLoginHistoryMutation) ResetIsp() {
	m.isp = nil
	delete(m.clearedFields, userloginhistory.FieldIsp)
}

// SetAsn sets the "asn" field.
func (m *UserLoginHistoryMutation) SetAsn(s string) {
	m.asn = &s
}

// Asn returns the value of the "asn" field in the mutation.
func (m *UserLoginHistoryMutation) Asn() (r string, exists bool) {
	v := m.asn
	if v == nil {
		return
	}
	return *v, true
}

// OldAsn returns the old "asn" field's value of the UserLoginHistory entity.
// If the UserLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserLoginHistoryMutation) OldAsn(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAsn is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAsn requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAsn: %w", err)
	}
	return oldValue.Asn, nil
}

// ClearAsn clears the value of the "asn" field.
func (m *UserLoginHistoryMutation) ClearAsn() {
	m.asn = nil
	m.clearedFields[userloginhistory.FieldAsn] = struct{}{}
}

// AsnCleared returns if the "asn" field was cleared in this mutation.
func (m *UserLoginHistoryMutation) AsnCleared() bool {
	_, ok := m.clearedFields[userloginhistory.FieldAsn]
	return ok
}

// ResetAsn resets all changes to the "asn" field.
func (m *UserLoginHistoryMutation) ResetAsn() {
	m.asn = nil
	delete(m.clearedFields, userloginhistory.FieldAsn)
}

// SetClientVersion sets the "client_version" field.
func (m *UserLoginHistoryMutation) SetClientVersion(s string) {
	m.client_version = &s
}

// ClientVersion returns the value of the "client_version" field in the mutation.
func (m *UserLoginHistoryMutation) ClientVersion() (r string, exists bool) {
	v := m.client_version
	if v == nil {
		return
	}
	return *v, true
}

// OldClientVersion returns the old "client_version" field's value of the UserLoginHistory entity.
// If the UserLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserLoginHistoryMutation) OldClientVersion(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldClientVersion is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldClientVersion requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClientVersion: %w", err)
	}
	return oldValue.ClientVersion, nil
}

// ClearClientVersion clears the value of the "client_version" field.
func (m *UserLoginHistoryMutation) ClearClientVersion() {
	m.client_version = nil
	m.clearedFields[userloginhistory.FieldClientVersion] = struct{}{}
}

// ClientVersionCleared returns if the "client_version" field was cleared in this mutation.
func (m *UserLoginHistoryMutation) ClientVersionCleared() bool {
	_, ok := m.clearedFields[userloginhistory.FieldClientVersion]
	return ok
}

// ResetClientVersion resets all changes to the "client_version" field.
func (m *UserLoginHistoryMutation) ResetClientVersion() {
	m.client_version = nil
	delete(m.clearedFields, userloginhistory.FieldClientVersion)
}

// SetOsType sets the "os_type" field.
func (m *UserLoginHistoryMutation) SetOsType(ct consts.OSType) {
	m.os_type = &ct
}

// OsType returns the value of the "os_type" field in the mutation.
func (m *UserLoginHistoryMutation) OsType() (r consts.OSType, exists bool) {
	v := m.os_type
	if v == nil {
		return
	}
	return *v, true
}

// OldOsType returns the old "os_type" field's value of the UserLoginHistory entity.
// If the UserLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserLoginHistoryMutation) OldOsType(ctx context.Context) (v consts.OSType, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOsType is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOsType requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOsType: %w", err)
	}
	return oldValue.OsType, nil
}

// ClearOsType clears the value of the "os_type" field.
func (m *UserLoginHistoryMutation) ClearOsType() {
	m.os_type = nil
	m.clearedFields[userloginhistory.FieldOsType] = struct{}{}
}

// OsTypeCleared returns if the "os_type" field was cleared in this mutation.
func (m *UserLoginHistoryMutation) OsTypeCleared() bool {
	_, ok := m.clearedFields[userloginhistory.FieldOsType]
	return ok
}

// ResetOsType resets all changes to the "os_type" field.
func (m *UserLoginHistoryMutation) ResetOsType() {
	m.os_type = nil
	delete(m.clearedFields, userloginhistory.FieldOsType)
}

// SetOsRelease sets the "os_release" field.
func (m *UserLoginHistoryMutation) SetOsRelease(cr consts.OSRelease) {
	m.os_release = &cr
}

// OsRelease returns the value of the "os_release" field in the mutation.
func (m *UserLoginHistoryMutation) OsRelease() (r consts.OSRelease, exists bool) {
	v := m.os_release
	if v == nil {
		return
	}
	return *v, true
}

// OldOsRelease returns the old "os_release" field's value of the UserLoginHistory entity.
// If the UserLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserLoginHistoryMutation) OldOsRelease(ctx context.Context) (v consts.OSRelease, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOsRelease is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOsRelease requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOsRelease: %w", err)
	}
	return oldValue.OsRelease, nil
}

// ClearOsRelease clears the value of the "os_release" field.
func (m *UserLoginHistoryMutation) ClearOsRelease() {
	m.os_release = nil
	m.clearedFields[userloginhistory.FieldOsRelease] = struct{}{}
}

// OsReleaseCleared returns if the "os_release" field was cleared in this mutation.
func (m *UserLoginHistoryMutation) OsReleaseCleared() bool {
	_, ok := m.clearedFields[userloginhistory.FieldOsRelease]
	return ok
}

// ResetOsRelease resets all changes to the "os_release" field.
func (m *UserLoginHistoryMutation) ResetOsRelease() {
	m.os_release = nil
	delete(m.clearedFields, userloginhistory.FieldOsRelease)
}

// SetHostname sets the "hostname" field.
func (m *UserLoginHistoryMutation) SetHostname(s string) {
	m.hostname = &s
}

// Hostname returns the value of the "hostname" field in the mutation.
func (m *UserLoginHistoryMutation) Hostname() (r string, exists bool) {
	v := m.hostname
	if v == nil {
		return
	}
	return *v, true
}

// OldHostname returns the old "hostname" field's value of the UserLoginHistory entity.
// If the UserLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserLoginHistoryMutation) OldHostname(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldHostname is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldHostname requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldHostname: %w", err)
	}
	return oldValue.Hostname, nil
}

// ClearHostname clears the value of the "hostname" field.
func (m *UserLoginHistoryMutation) ClearHostname() {
	m.hostname = nil
	m.clearedFields[userloginhistory.FieldHostname] = struct{}{}
}

// HostnameCleared returns if the "hostname" field was cleared in this mutation.
func (m *UserLoginHistoryMutation) HostnameCleared() bool {
	_, ok := m.clearedFields[userloginhistory.FieldHostname]
	return ok
}

// ResetHostname resets all changes to the "hostname" field.
func (m *UserLoginHistoryMutation) ResetHostname() {
	m.hostname = nil
	delete(m.clearedFields, userloginhistory.FieldHostname)
}

// SetClientID sets the "client_id" field.
func (m *UserLoginHistoryMutation) SetClientID(s string) {
	m.client_id = &s
}

// ClientID returns the value of the "client_id" field in the mutation.
func (m *UserLoginHistoryMutation) ClientID() (r string, exists bool) {
	v := m.client_id
	if v == nil {
		return
	}
	return *v, true
}

// OldClientID returns the old "client_id" field's value of the UserLoginHistory entity.
// If the UserLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserLoginHistoryMutation) OldClientID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldClientID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldClientID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClientID: %w", err)
	}
	return oldValue.ClientID, nil
}

// ClearClientID clears the value of the "client_id" field.
func (m *UserLoginHistoryMutation) ClearClientID() {
	m.client_id = nil
	m.clearedFields[userloginhistory.FieldClientID] = struct{}{}
}

// ClientIDCleared returns if the "client_id" field was cleared in this mutation.
func (m *UserLoginHistoryMutation) ClientIDCleared() bool {
	_, ok := m.clearedFields[userloginhistory.FieldClientID]
	return ok
}

// ResetClientID resets all changes to the "client_id" field.
func (m *UserLoginHistoryMutation) ResetClientID() {
	m.client_id = nil
	delete(m.clearedFields, userloginhistory.FieldClientID)
}

// SetCreatedAt sets the "created_at" field.
func (m *UserLoginHistoryMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *UserLoginHistoryMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the UserLoginHistory entity.
// If the UserLoginHistory object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserLoginHistoryMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *UserLoginHistoryMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetOwnerID sets the "owner" edge to the User entity by id.
func (m *UserLoginHistoryMutation) SetOwnerID(id uuid.UUID) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the User entity.
func (m *UserLoginHistoryMutation) ClearOwner() {
	m.clearedowner = true
	m.clearedFields[userloginhistory.FieldUserID] = struct{}{}
}

// OwnerCleared reports if the "owner" edge to the User entity was cleared.
func (m *UserLoginHistoryMutation) OwnerCleared() bool {
	return m.UserIDCleared() || m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *UserLoginHistoryMutation) OwnerID() (id uuid.UUID, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *UserLoginHistoryMutation) OwnerIDs() (ids []uuid.UUID) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *UserLoginHistoryMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// Where appends a list predicates to the UserLoginHistoryMutation builder.
func (m *UserLoginHistoryMutation) Where(ps ...predicate.UserLoginHistory) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the UserLoginHistoryMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *UserLoginHistoryMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.UserLoginHistory, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *UserLoginHistoryMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *UserLoginHistoryMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (UserLoginHistory).
func (m *UserLoginHistoryMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *UserLoginHistoryMutation) Fields() []string {
	fields := make([]string, 0, 13)
	if m.owner != nil {
		fields = append(fields, userloginhistory.FieldUserID)
	}
	if m.ip != nil {
		fields = append(fields, userloginhistory.FieldIP)
	}
	if m.country != nil {
		fields = append(fields, userloginhistory.FieldCountry)
	}
	if m.province != nil {
		fields = append(fields, userloginhistory.FieldProvince)
	}
	if m.city != nil {
		fields = append(fields, userloginhistory.FieldCity)
	}
	if m.isp != nil {
		fields = append(fields, userloginhistory.FieldIsp)
	}
	if m.asn != nil {
		fields = append(fields, userloginhistory.FieldAsn)
	}
	if m.client_version != nil {
		fields = append(fields, userloginhistory.FieldClientVersion)
	}
	if m.os_type != nil {
		fields = append(fields, userloginhistory.FieldOsType)
	}
	if m.os_release != nil {
		fields = append(fields, userloginhistory.FieldOsRelease)
	}
	if m.hostname != nil {
		fields = append(fields, userloginhistory.FieldHostname)
	}
	if m.client_id != nil {
		fields = append(fields, userloginhistory.FieldClientID)
	}
	if m.created_at != nil {
		fields = append(fields, userloginhistory.FieldCreatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *UserLoginHistoryMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case userloginhistory.FieldUserID:
		return m.UserID()
	case userloginhistory.FieldIP:
		return m.IP()
	case userloginhistory.FieldCountry:
		return m.Country()
	case userloginhistory.FieldProvince:
		return m.Province()
	case userloginhistory.FieldCity:
		return m.City()
	case userloginhistory.FieldIsp:
		return m.Isp()
	case userloginhistory.FieldAsn:
		return m.Asn()
	case userloginhistory.FieldClientVersion:
		return m.ClientVersion()
	case userloginhistory.FieldOsType:
		return m.OsType()
	case userloginhistory.FieldOsRelease:
		return m.OsRelease()
	case userloginhistory.FieldHostname:
		return m.Hostname()
	case userloginhistory.FieldClientID:
		return m.ClientID()
	case userloginhistory.FieldCreatedAt:
		return m.CreatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *UserLoginHistoryMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case userloginhistory.FieldUserID:
		return m.OldUserID(ctx)
	case userloginhistory.FieldIP:
		return m.OldIP(ctx)
	case userloginhistory.FieldCountry:
		return m.OldCountry(ctx)
	case userloginhistory.FieldProvince:
		return m.OldProvince(ctx)
	case userloginhistory.FieldCity:
		return m.OldCity(ctx)
	case userloginhistory.FieldIsp:
		return m.OldIsp(ctx)
	case userloginhistory.FieldAsn:
		return m.OldAsn(ctx)
	case userloginhistory.FieldClientVersion:
		return m.OldClientVersion(ctx)
	case userloginhistory.FieldOsType:
		return m.OldOsType(ctx)
	case userloginhistory.FieldOsRelease:
		return m.OldOsRelease(ctx)
	case userloginhistory.FieldHostname:
		return m.OldHostname(ctx)
	case userloginhistory.FieldClientID:
		return m.OldClientID(ctx)
	case userloginhistory.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown UserLoginHistory field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserLoginHistoryMutation) SetField(name string, value ent.Value) error {
	switch name {
	case userloginhistory.FieldUserID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case userloginhistory.FieldIP:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetIP(v)
		return nil
	case userloginhistory.FieldCountry:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCountry(v)
		return nil
	case userloginhistory.FieldProvince:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetProvince(v)
		return nil
	case userloginhistory.FieldCity:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCity(v)
		return nil
	case userloginhistory.FieldIsp:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetIsp(v)
		return nil
	case userloginhistory.FieldAsn:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAsn(v)
		return nil
	case userloginhistory.FieldClientVersion:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClientVersion(v)
		return nil
	case userloginhistory.FieldOsType:
		v, ok := value.(consts.OSType)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOsType(v)
		return nil
	case userloginhistory.FieldOsRelease:
		v, ok := value.(consts.OSRelease)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOsRelease(v)
		return nil
	case userloginhistory.FieldHostname:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetHostname(v)
		return nil
	case userloginhistory.FieldClientID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClientID(v)
		return nil
	case userloginhistory.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown UserLoginHistory field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *UserLoginHistoryMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *UserLoginHistoryMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserLoginHistoryMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown UserLoginHistory numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *UserLoginHistoryMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(userloginhistory.FieldUserID) {
		fields = append(fields, userloginhistory.FieldUserID)
	}
	if m.FieldCleared(userloginhistory.FieldIsp) {
		fields = append(fields, userloginhistory.FieldIsp)
	}
	if m.FieldCleared(userloginhistory.FieldAsn) {
		fields = append(fields, userloginhistory.FieldAsn)
	}
	if m.FieldCleared(userloginhistory.FieldClientVersion) {
		fields = append(fields, userloginhistory.FieldClientVersion)
	}
	if m.FieldCleared(userloginhistory.FieldOsType) {
		fields = append(fields, userloginhistory.FieldOsType)
	}
	if m.FieldCleared(userloginhistory.FieldOsRelease) {
		fields = append(fields, userloginhistory.FieldOsRelease)
	}
	if m.FieldCleared(userloginhistory.FieldHostname) {
		fields = append(fields, userloginhistory.FieldHostname)
	}
	if m.FieldCleared(userloginhistory.FieldClientID) {
		fields = append(fields, userloginhistory.FieldClientID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *UserLoginHistoryMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *UserLoginHistoryMutation) ClearField(name string) error {
	switch name {
	case userloginhistory.FieldUserID:
		m.ClearUserID()
		return nil
	case userloginhistory.FieldIsp:
		m.ClearIsp()
		return nil
	case userloginhistory.FieldAsn:
		m.ClearAsn()
		return nil
	case userloginhistory.FieldClientVersion:
		m.ClearClientVersion()
		return nil
	case userloginhistory.FieldOsType:
		m.ClearOsType()
		return nil
	case userloginhistory.FieldOsRelease:
		m.ClearOsRelease()
		return nil
	case userloginhistory.FieldHostname:
		m.ClearHostname()
		return nil
	case userloginhistory.FieldClientID:
		m.ClearClientID()
		return nil
	}
	return fmt.Errorf("unknown UserLoginHistory nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *UserLoginHistoryMutation) ResetField(name string) error {
	switch name {
	case userloginhistory.FieldUserID:
		m.ResetUserID()
		return nil
	case userloginhistory.FieldIP:
		m.ResetIP()
		return nil
	case userloginhistory.FieldCountry:
		m.ResetCountry()
		return nil
	case userloginhistory.FieldProvince:
		m.ResetProvince()
		return nil
	case userloginhistory.FieldCity:
		m.ResetCity()
		return nil
	case userloginhistory.FieldIsp:
		m.ResetIsp()
		return nil
	case userloginhistory.FieldAsn:
		m.ResetAsn()
		return nil
	case userloginhistory.FieldClientVersion:
		m.ResetClientVersion()
		return nil
	case userloginhistory.FieldOsType:
		m.ResetOsType()
		return nil
	case userloginhistory.FieldOsRelease:
		m.ResetOsRelease()
		return nil
	case userloginhistory.FieldHostname:
		m.ResetHostname()
		return nil
	case userloginhistory.FieldClientID:
		m.ResetClientID()
		return nil
	case userloginhistory.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	}
	return fmt.Errorf("unknown UserLoginHistory field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *UserLoginHistoryMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.owner != nil {
		edges = append(edges, userloginhistory.EdgeOwner)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *UserLoginHistoryMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case userloginhistory.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *UserLoginHistoryMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *UserLoginHistoryMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *UserLoginHistoryMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedowner {
		edges = append(edges, userloginhistory.EdgeOwner)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *UserLoginHistoryMutation) EdgeCleared(name string) bool {
	switch name {
	case userloginhistory.EdgeOwner:
		return m.clearedowner
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *UserLoginHistoryMutation) ClearEdge(name string) error {
	switch name {
	case userloginhistory.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown UserLoginHistory unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *UserLoginHistoryMutation) ResetEdge(name string) error {
	switch name {
	case userloginhistory.EdgeOwner:
		m.ResetOwner()
		return nil
	}
	return fmt.Errorf("unknown UserLoginHistory edge %s", name)
}

// WorkspaceMutation represents an operation that mutates the Workspace nodes in the graph.
type WorkspaceMutation struct {
	config
	op                        Op
	typ                       string
	id                        *uuid.UUID
	name                      *string
	description               *string
	root_path                 *string
	settings                  *map[string]interface{}
	last_accessed_at          *time.Time
	created_at                *time.Time
	updated_at                *time.Time
	clearedFields             map[string]struct{}
	owner                     *uuid.UUID
	clearedowner              bool
	files                     map[uuid.UUID]struct{}
	removedfiles              map[uuid.UUID]struct{}
	clearedfiles              bool
	security_scannings        map[uuid.UUID]struct{}
	removedsecurity_scannings map[uuid.UUID]struct{}
	clearedsecurity_scannings bool
	done                      bool
	oldValue                  func(context.Context) (*Workspace, error)
	predicates                []predicate.Workspace
}

var _ ent.Mutation = (*WorkspaceMutation)(nil)

// workspaceOption allows management of the mutation configuration using functional options.
type workspaceOption func(*WorkspaceMutation)

// newWorkspaceMutation creates new mutation for the Workspace entity.
func newWorkspaceMutation(c config, op Op, opts ...workspaceOption) *WorkspaceMutation {
	m := &WorkspaceMutation{
		config:        c,
		op:            op,
		typ:           TypeWorkspace,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withWorkspaceID sets the ID field of the mutation.
func withWorkspaceID(id uuid.UUID) workspaceOption {
	return func(m *WorkspaceMutation) {
		var (
			err   error
			once  sync.Once
			value *Workspace
		)
		m.oldValue = func(ctx context.Context) (*Workspace, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Workspace.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withWorkspace sets the old Workspace of the mutation.
func withWorkspace(node *Workspace) workspaceOption {
	return func(m *WorkspaceMutation) {
		m.oldValue = func(context.Context) (*Workspace, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m WorkspaceMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m WorkspaceMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Workspace entities.
func (m *WorkspaceMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *WorkspaceMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *WorkspaceMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Workspace.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetUserID sets the "user_id" field.
func (m *WorkspaceMutation) SetUserID(u uuid.UUID) {
	m.owner = &u
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *WorkspaceMutation) UserID() (r uuid.UUID, exists bool) {
	v := m.owner
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the Workspace entity.
// If the Workspace object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceMutation) OldUserID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ResetUserID resets all changes to the "user_id" field.
func (m *WorkspaceMutation) ResetUserID() {
	m.owner = nil
}

// SetName sets the "name" field.
func (m *WorkspaceMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *WorkspaceMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the Workspace entity.
// If the Workspace object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ClearName clears the value of the "name" field.
func (m *WorkspaceMutation) ClearName() {
	m.name = nil
	m.clearedFields[workspace.FieldName] = struct{}{}
}

// NameCleared returns if the "name" field was cleared in this mutation.
func (m *WorkspaceMutation) NameCleared() bool {
	_, ok := m.clearedFields[workspace.FieldName]
	return ok
}

// ResetName resets all changes to the "name" field.
func (m *WorkspaceMutation) ResetName() {
	m.name = nil
	delete(m.clearedFields, workspace.FieldName)
}

// SetDescription sets the "description" field.
func (m *WorkspaceMutation) SetDescription(s string) {
	m.description = &s
}

// Description returns the value of the "description" field in the mutation.
func (m *WorkspaceMutation) Description() (r string, exists bool) {
	v := m.description
	if v == nil {
		return
	}
	return *v, true
}

// OldDescription returns the old "description" field's value of the Workspace entity.
// If the Workspace object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceMutation) OldDescription(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDescription is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDescription requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDescription: %w", err)
	}
	return oldValue.Description, nil
}

// ClearDescription clears the value of the "description" field.
func (m *WorkspaceMutation) ClearDescription() {
	m.description = nil
	m.clearedFields[workspace.FieldDescription] = struct{}{}
}

// DescriptionCleared returns if the "description" field was cleared in this mutation.
func (m *WorkspaceMutation) DescriptionCleared() bool {
	_, ok := m.clearedFields[workspace.FieldDescription]
	return ok
}

// ResetDescription resets all changes to the "description" field.
func (m *WorkspaceMutation) ResetDescription() {
	m.description = nil
	delete(m.clearedFields, workspace.FieldDescription)
}

// SetRootPath sets the "root_path" field.
func (m *WorkspaceMutation) SetRootPath(s string) {
	m.root_path = &s
}

// RootPath returns the value of the "root_path" field in the mutation.
func (m *WorkspaceMutation) RootPath() (r string, exists bool) {
	v := m.root_path
	if v == nil {
		return
	}
	return *v, true
}

// OldRootPath returns the old "root_path" field's value of the Workspace entity.
// If the Workspace object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceMutation) OldRootPath(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRootPath is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRootPath requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRootPath: %w", err)
	}
	return oldValue.RootPath, nil
}

// ResetRootPath resets all changes to the "root_path" field.
func (m *WorkspaceMutation) ResetRootPath() {
	m.root_path = nil
}

// SetSettings sets the "settings" field.
func (m *WorkspaceMutation) SetSettings(value map[string]interface{}) {
	m.settings = &value
}

// Settings returns the value of the "settings" field in the mutation.
func (m *WorkspaceMutation) Settings() (r map[string]interface{}, exists bool) {
	v := m.settings
	if v == nil {
		return
	}
	return *v, true
}

// OldSettings returns the old "settings" field's value of the Workspace entity.
// If the Workspace object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceMutation) OldSettings(ctx context.Context) (v map[string]interface{}, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSettings is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSettings requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSettings: %w", err)
	}
	return oldValue.Settings, nil
}

// ClearSettings clears the value of the "settings" field.
func (m *WorkspaceMutation) ClearSettings() {
	m.settings = nil
	m.clearedFields[workspace.FieldSettings] = struct{}{}
}

// SettingsCleared returns if the "settings" field was cleared in this mutation.
func (m *WorkspaceMutation) SettingsCleared() bool {
	_, ok := m.clearedFields[workspace.FieldSettings]
	return ok
}

// ResetSettings resets all changes to the "settings" field.
func (m *WorkspaceMutation) ResetSettings() {
	m.settings = nil
	delete(m.clearedFields, workspace.FieldSettings)
}

// SetLastAccessedAt sets the "last_accessed_at" field.
func (m *WorkspaceMutation) SetLastAccessedAt(t time.Time) {
	m.last_accessed_at = &t
}

// LastAccessedAt returns the value of the "last_accessed_at" field in the mutation.
func (m *WorkspaceMutation) LastAccessedAt() (r time.Time, exists bool) {
	v := m.last_accessed_at
	if v == nil {
		return
	}
	return *v, true
}

// OldLastAccessedAt returns the old "last_accessed_at" field's value of the Workspace entity.
// If the Workspace object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceMutation) OldLastAccessedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldLastAccessedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldLastAccessedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLastAccessedAt: %w", err)
	}
	return oldValue.LastAccessedAt, nil
}

// ResetLastAccessedAt resets all changes to the "last_accessed_at" field.
func (m *WorkspaceMutation) ResetLastAccessedAt() {
	m.last_accessed_at = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *WorkspaceMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *WorkspaceMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Workspace entity.
// If the Workspace object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *WorkspaceMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *WorkspaceMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *WorkspaceMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Workspace entity.
// If the Workspace object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *WorkspaceMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetOwnerID sets the "owner" edge to the User entity by id.
func (m *WorkspaceMutation) SetOwnerID(id uuid.UUID) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the User entity.
func (m *WorkspaceMutation) ClearOwner() {
	m.clearedowner = true
	m.clearedFields[workspace.FieldUserID] = struct{}{}
}

// OwnerCleared reports if the "owner" edge to the User entity was cleared.
func (m *WorkspaceMutation) OwnerCleared() bool {
	return m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *WorkspaceMutation) OwnerID() (id uuid.UUID, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *WorkspaceMutation) OwnerIDs() (ids []uuid.UUID) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *WorkspaceMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// AddFileIDs adds the "files" edge to the WorkspaceFile entity by ids.
func (m *WorkspaceMutation) AddFileIDs(ids ...uuid.UUID) {
	if m.files == nil {
		m.files = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.files[ids[i]] = struct{}{}
	}
}

// ClearFiles clears the "files" edge to the WorkspaceFile entity.
func (m *WorkspaceMutation) ClearFiles() {
	m.clearedfiles = true
}

// FilesCleared reports if the "files" edge to the WorkspaceFile entity was cleared.
func (m *WorkspaceMutation) FilesCleared() bool {
	return m.clearedfiles
}

// RemoveFileIDs removes the "files" edge to the WorkspaceFile entity by IDs.
func (m *WorkspaceMutation) RemoveFileIDs(ids ...uuid.UUID) {
	if m.removedfiles == nil {
		m.removedfiles = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.files, ids[i])
		m.removedfiles[ids[i]] = struct{}{}
	}
}

// RemovedFiles returns the removed IDs of the "files" edge to the WorkspaceFile entity.
func (m *WorkspaceMutation) RemovedFilesIDs() (ids []uuid.UUID) {
	for id := range m.removedfiles {
		ids = append(ids, id)
	}
	return
}

// FilesIDs returns the "files" edge IDs in the mutation.
func (m *WorkspaceMutation) FilesIDs() (ids []uuid.UUID) {
	for id := range m.files {
		ids = append(ids, id)
	}
	return
}

// ResetFiles resets all changes to the "files" edge.
func (m *WorkspaceMutation) ResetFiles() {
	m.files = nil
	m.clearedfiles = false
	m.removedfiles = nil
}

// AddSecurityScanningIDs adds the "security_scannings" edge to the SecurityScanning entity by ids.
func (m *WorkspaceMutation) AddSecurityScanningIDs(ids ...uuid.UUID) {
	if m.security_scannings == nil {
		m.security_scannings = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.security_scannings[ids[i]] = struct{}{}
	}
}

// ClearSecurityScannings clears the "security_scannings" edge to the SecurityScanning entity.
func (m *WorkspaceMutation) ClearSecurityScannings() {
	m.clearedsecurity_scannings = true
}

// SecurityScanningsCleared reports if the "security_scannings" edge to the SecurityScanning entity was cleared.
func (m *WorkspaceMutation) SecurityScanningsCleared() bool {
	return m.clearedsecurity_scannings
}

// RemoveSecurityScanningIDs removes the "security_scannings" edge to the SecurityScanning entity by IDs.
func (m *WorkspaceMutation) RemoveSecurityScanningIDs(ids ...uuid.UUID) {
	if m.removedsecurity_scannings == nil {
		m.removedsecurity_scannings = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.security_scannings, ids[i])
		m.removedsecurity_scannings[ids[i]] = struct{}{}
	}
}

// RemovedSecurityScannings returns the removed IDs of the "security_scannings" edge to the SecurityScanning entity.
func (m *WorkspaceMutation) RemovedSecurityScanningsIDs() (ids []uuid.UUID) {
	for id := range m.removedsecurity_scannings {
		ids = append(ids, id)
	}
	return
}

// SecurityScanningsIDs returns the "security_scannings" edge IDs in the mutation.
func (m *WorkspaceMutation) SecurityScanningsIDs() (ids []uuid.UUID) {
	for id := range m.security_scannings {
		ids = append(ids, id)
	}
	return
}

// ResetSecurityScannings resets all changes to the "security_scannings" edge.
func (m *WorkspaceMutation) ResetSecurityScannings() {
	m.security_scannings = nil
	m.clearedsecurity_scannings = false
	m.removedsecurity_scannings = nil
}

// Where appends a list predicates to the WorkspaceMutation builder.
func (m *WorkspaceMutation) Where(ps ...predicate.Workspace) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the WorkspaceMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *WorkspaceMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Workspace, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *WorkspaceMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *WorkspaceMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Workspace).
func (m *WorkspaceMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *WorkspaceMutation) Fields() []string {
	fields := make([]string, 0, 8)
	if m.owner != nil {
		fields = append(fields, workspace.FieldUserID)
	}
	if m.name != nil {
		fields = append(fields, workspace.FieldName)
	}
	if m.description != nil {
		fields = append(fields, workspace.FieldDescription)
	}
	if m.root_path != nil {
		fields = append(fields, workspace.FieldRootPath)
	}
	if m.settings != nil {
		fields = append(fields, workspace.FieldSettings)
	}
	if m.last_accessed_at != nil {
		fields = append(fields, workspace.FieldLastAccessedAt)
	}
	if m.created_at != nil {
		fields = append(fields, workspace.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, workspace.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *WorkspaceMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case workspace.FieldUserID:
		return m.UserID()
	case workspace.FieldName:
		return m.Name()
	case workspace.FieldDescription:
		return m.Description()
	case workspace.FieldRootPath:
		return m.RootPath()
	case workspace.FieldSettings:
		return m.Settings()
	case workspace.FieldLastAccessedAt:
		return m.LastAccessedAt()
	case workspace.FieldCreatedAt:
		return m.CreatedAt()
	case workspace.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *WorkspaceMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case workspace.FieldUserID:
		return m.OldUserID(ctx)
	case workspace.FieldName:
		return m.OldName(ctx)
	case workspace.FieldDescription:
		return m.OldDescription(ctx)
	case workspace.FieldRootPath:
		return m.OldRootPath(ctx)
	case workspace.FieldSettings:
		return m.OldSettings(ctx)
	case workspace.FieldLastAccessedAt:
		return m.OldLastAccessedAt(ctx)
	case workspace.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case workspace.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Workspace field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *WorkspaceMutation) SetField(name string, value ent.Value) error {
	switch name {
	case workspace.FieldUserID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case workspace.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case workspace.FieldDescription:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDescription(v)
		return nil
	case workspace.FieldRootPath:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRootPath(v)
		return nil
	case workspace.FieldSettings:
		v, ok := value.(map[string]interface{})
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSettings(v)
		return nil
	case workspace.FieldLastAccessedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLastAccessedAt(v)
		return nil
	case workspace.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case workspace.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Workspace field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *WorkspaceMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *WorkspaceMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *WorkspaceMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Workspace numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *WorkspaceMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(workspace.FieldName) {
		fields = append(fields, workspace.FieldName)
	}
	if m.FieldCleared(workspace.FieldDescription) {
		fields = append(fields, workspace.FieldDescription)
	}
	if m.FieldCleared(workspace.FieldSettings) {
		fields = append(fields, workspace.FieldSettings)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *WorkspaceMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *WorkspaceMutation) ClearField(name string) error {
	switch name {
	case workspace.FieldName:
		m.ClearName()
		return nil
	case workspace.FieldDescription:
		m.ClearDescription()
		return nil
	case workspace.FieldSettings:
		m.ClearSettings()
		return nil
	}
	return fmt.Errorf("unknown Workspace nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *WorkspaceMutation) ResetField(name string) error {
	switch name {
	case workspace.FieldUserID:
		m.ResetUserID()
		return nil
	case workspace.FieldName:
		m.ResetName()
		return nil
	case workspace.FieldDescription:
		m.ResetDescription()
		return nil
	case workspace.FieldRootPath:
		m.ResetRootPath()
		return nil
	case workspace.FieldSettings:
		m.ResetSettings()
		return nil
	case workspace.FieldLastAccessedAt:
		m.ResetLastAccessedAt()
		return nil
	case workspace.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case workspace.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown Workspace field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *WorkspaceMutation) AddedEdges() []string {
	edges := make([]string, 0, 3)
	if m.owner != nil {
		edges = append(edges, workspace.EdgeOwner)
	}
	if m.files != nil {
		edges = append(edges, workspace.EdgeFiles)
	}
	if m.security_scannings != nil {
		edges = append(edges, workspace.EdgeSecurityScannings)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *WorkspaceMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case workspace.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	case workspace.EdgeFiles:
		ids := make([]ent.Value, 0, len(m.files))
		for id := range m.files {
			ids = append(ids, id)
		}
		return ids
	case workspace.EdgeSecurityScannings:
		ids := make([]ent.Value, 0, len(m.security_scannings))
		for id := range m.security_scannings {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *WorkspaceMutation) RemovedEdges() []string {
	edges := make([]string, 0, 3)
	if m.removedfiles != nil {
		edges = append(edges, workspace.EdgeFiles)
	}
	if m.removedsecurity_scannings != nil {
		edges = append(edges, workspace.EdgeSecurityScannings)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *WorkspaceMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case workspace.EdgeFiles:
		ids := make([]ent.Value, 0, len(m.removedfiles))
		for id := range m.removedfiles {
			ids = append(ids, id)
		}
		return ids
	case workspace.EdgeSecurityScannings:
		ids := make([]ent.Value, 0, len(m.removedsecurity_scannings))
		for id := range m.removedsecurity_scannings {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *WorkspaceMutation) ClearedEdges() []string {
	edges := make([]string, 0, 3)
	if m.clearedowner {
		edges = append(edges, workspace.EdgeOwner)
	}
	if m.clearedfiles {
		edges = append(edges, workspace.EdgeFiles)
	}
	if m.clearedsecurity_scannings {
		edges = append(edges, workspace.EdgeSecurityScannings)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *WorkspaceMutation) EdgeCleared(name string) bool {
	switch name {
	case workspace.EdgeOwner:
		return m.clearedowner
	case workspace.EdgeFiles:
		return m.clearedfiles
	case workspace.EdgeSecurityScannings:
		return m.clearedsecurity_scannings
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *WorkspaceMutation) ClearEdge(name string) error {
	switch name {
	case workspace.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown Workspace unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *WorkspaceMutation) ResetEdge(name string) error {
	switch name {
	case workspace.EdgeOwner:
		m.ResetOwner()
		return nil
	case workspace.EdgeFiles:
		m.ResetFiles()
		return nil
	case workspace.EdgeSecurityScannings:
		m.ResetSecurityScannings()
		return nil
	}
	return fmt.Errorf("unknown Workspace edge %s", name)
}

// WorkspaceFileMutation represents an operation that mutates the WorkspaceFile nodes in the graph.
type WorkspaceFileMutation struct {
	config
	op               Op
	typ              string
	id               *uuid.UUID
	_path            *string
	content          *string
	hash             *string
	language         *string
	size             *int64
	addsize          *int64
	created_at       *time.Time
	updated_at       *time.Time
	clearedFields    map[string]struct{}
	owner            *uuid.UUID
	clearedowner     bool
	workspace        *uuid.UUID
	clearedworkspace bool
	snippets         map[uuid.UUID]struct{}
	removedsnippets  map[uuid.UUID]struct{}
	clearedsnippets  bool
	done             bool
	oldValue         func(context.Context) (*WorkspaceFile, error)
	predicates       []predicate.WorkspaceFile
}

var _ ent.Mutation = (*WorkspaceFileMutation)(nil)

// workspacefileOption allows management of the mutation configuration using functional options.
type workspacefileOption func(*WorkspaceFileMutation)

// newWorkspaceFileMutation creates new mutation for the WorkspaceFile entity.
func newWorkspaceFileMutation(c config, op Op, opts ...workspacefileOption) *WorkspaceFileMutation {
	m := &WorkspaceFileMutation{
		config:        c,
		op:            op,
		typ:           TypeWorkspaceFile,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withWorkspaceFileID sets the ID field of the mutation.
func withWorkspaceFileID(id uuid.UUID) workspacefileOption {
	return func(m *WorkspaceFileMutation) {
		var (
			err   error
			once  sync.Once
			value *WorkspaceFile
		)
		m.oldValue = func(ctx context.Context) (*WorkspaceFile, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().WorkspaceFile.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withWorkspaceFile sets the old WorkspaceFile of the mutation.
func withWorkspaceFile(node *WorkspaceFile) workspacefileOption {
	return func(m *WorkspaceFileMutation) {
		m.oldValue = func(context.Context) (*WorkspaceFile, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m WorkspaceFileMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m WorkspaceFileMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of WorkspaceFile entities.
func (m *WorkspaceFileMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *WorkspaceFileMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *WorkspaceFileMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().WorkspaceFile.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetUserID sets the "user_id" field.
func (m *WorkspaceFileMutation) SetUserID(u uuid.UUID) {
	m.owner = &u
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *WorkspaceFileMutation) UserID() (r uuid.UUID, exists bool) {
	v := m.owner
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the WorkspaceFile entity.
// If the WorkspaceFile object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceFileMutation) OldUserID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ResetUserID resets all changes to the "user_id" field.
func (m *WorkspaceFileMutation) ResetUserID() {
	m.owner = nil
}

// SetWorkspaceID sets the "workspace_id" field.
func (m *WorkspaceFileMutation) SetWorkspaceID(u uuid.UUID) {
	m.workspace = &u
}

// WorkspaceID returns the value of the "workspace_id" field in the mutation.
func (m *WorkspaceFileMutation) WorkspaceID() (r uuid.UUID, exists bool) {
	v := m.workspace
	if v == nil {
		return
	}
	return *v, true
}

// OldWorkspaceID returns the old "workspace_id" field's value of the WorkspaceFile entity.
// If the WorkspaceFile object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceFileMutation) OldWorkspaceID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldWorkspaceID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldWorkspaceID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldWorkspaceID: %w", err)
	}
	return oldValue.WorkspaceID, nil
}

// ResetWorkspaceID resets all changes to the "workspace_id" field.
func (m *WorkspaceFileMutation) ResetWorkspaceID() {
	m.workspace = nil
}

// SetPath sets the "path" field.
func (m *WorkspaceFileMutation) SetPath(s string) {
	m._path = &s
}

// Path returns the value of the "path" field in the mutation.
func (m *WorkspaceFileMutation) Path() (r string, exists bool) {
	v := m._path
	if v == nil {
		return
	}
	return *v, true
}

// OldPath returns the old "path" field's value of the WorkspaceFile entity.
// If the WorkspaceFile object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceFileMutation) OldPath(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPath is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPath requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPath: %w", err)
	}
	return oldValue.Path, nil
}

// ResetPath resets all changes to the "path" field.
func (m *WorkspaceFileMutation) ResetPath() {
	m._path = nil
}

// SetContent sets the "content" field.
func (m *WorkspaceFileMutation) SetContent(s string) {
	m.content = &s
}

// Content returns the value of the "content" field in the mutation.
func (m *WorkspaceFileMutation) Content() (r string, exists bool) {
	v := m.content
	if v == nil {
		return
	}
	return *v, true
}

// OldContent returns the old "content" field's value of the WorkspaceFile entity.
// If the WorkspaceFile object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceFileMutation) OldContent(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldContent is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldContent requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldContent: %w", err)
	}
	return oldValue.Content, nil
}

// ClearContent clears the value of the "content" field.
func (m *WorkspaceFileMutation) ClearContent() {
	m.content = nil
	m.clearedFields[workspacefile.FieldContent] = struct{}{}
}

// ContentCleared returns if the "content" field was cleared in this mutation.
func (m *WorkspaceFileMutation) ContentCleared() bool {
	_, ok := m.clearedFields[workspacefile.FieldContent]
	return ok
}

// ResetContent resets all changes to the "content" field.
func (m *WorkspaceFileMutation) ResetContent() {
	m.content = nil
	delete(m.clearedFields, workspacefile.FieldContent)
}

// SetHash sets the "hash" field.
func (m *WorkspaceFileMutation) SetHash(s string) {
	m.hash = &s
}

// Hash returns the value of the "hash" field in the mutation.
func (m *WorkspaceFileMutation) Hash() (r string, exists bool) {
	v := m.hash
	if v == nil {
		return
	}
	return *v, true
}

// OldHash returns the old "hash" field's value of the WorkspaceFile entity.
// If the WorkspaceFile object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceFileMutation) OldHash(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldHash is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldHash requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldHash: %w", err)
	}
	return oldValue.Hash, nil
}

// ResetHash resets all changes to the "hash" field.
func (m *WorkspaceFileMutation) ResetHash() {
	m.hash = nil
}

// SetLanguage sets the "language" field.
func (m *WorkspaceFileMutation) SetLanguage(s string) {
	m.language = &s
}

// Language returns the value of the "language" field in the mutation.
func (m *WorkspaceFileMutation) Language() (r string, exists bool) {
	v := m.language
	if v == nil {
		return
	}
	return *v, true
}

// OldLanguage returns the old "language" field's value of the WorkspaceFile entity.
// If the WorkspaceFile object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceFileMutation) OldLanguage(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldLanguage is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldLanguage requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLanguage: %w", err)
	}
	return oldValue.Language, nil
}

// ClearLanguage clears the value of the "language" field.
func (m *WorkspaceFileMutation) ClearLanguage() {
	m.language = nil
	m.clearedFields[workspacefile.FieldLanguage] = struct{}{}
}

// LanguageCleared returns if the "language" field was cleared in this mutation.
func (m *WorkspaceFileMutation) LanguageCleared() bool {
	_, ok := m.clearedFields[workspacefile.FieldLanguage]
	return ok
}

// ResetLanguage resets all changes to the "language" field.
func (m *WorkspaceFileMutation) ResetLanguage() {
	m.language = nil
	delete(m.clearedFields, workspacefile.FieldLanguage)
}

// SetSize sets the "size" field.
func (m *WorkspaceFileMutation) SetSize(i int64) {
	m.size = &i
	m.addsize = nil
}

// Size returns the value of the "size" field in the mutation.
func (m *WorkspaceFileMutation) Size() (r int64, exists bool) {
	v := m.size
	if v == nil {
		return
	}
	return *v, true
}

// OldSize returns the old "size" field's value of the WorkspaceFile entity.
// If the WorkspaceFile object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceFileMutation) OldSize(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSize is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSize requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSize: %w", err)
	}
	return oldValue.Size, nil
}

// AddSize adds i to the "size" field.
func (m *WorkspaceFileMutation) AddSize(i int64) {
	if m.addsize != nil {
		*m.addsize += i
	} else {
		m.addsize = &i
	}
}

// AddedSize returns the value that was added to the "size" field in this mutation.
func (m *WorkspaceFileMutation) AddedSize() (r int64, exists bool) {
	v := m.addsize
	if v == nil {
		return
	}
	return *v, true
}

// ResetSize resets all changes to the "size" field.
func (m *WorkspaceFileMutation) ResetSize() {
	m.size = nil
	m.addsize = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *WorkspaceFileMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *WorkspaceFileMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the WorkspaceFile entity.
// If the WorkspaceFile object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceFileMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *WorkspaceFileMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *WorkspaceFileMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *WorkspaceFileMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the WorkspaceFile entity.
// If the WorkspaceFile object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *WorkspaceFileMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *WorkspaceFileMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetOwnerID sets the "owner" edge to the User entity by id.
func (m *WorkspaceFileMutation) SetOwnerID(id uuid.UUID) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the User entity.
func (m *WorkspaceFileMutation) ClearOwner() {
	m.clearedowner = true
	m.clearedFields[workspacefile.FieldUserID] = struct{}{}
}

// OwnerCleared reports if the "owner" edge to the User entity was cleared.
func (m *WorkspaceFileMutation) OwnerCleared() bool {
	return m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *WorkspaceFileMutation) OwnerID() (id uuid.UUID, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *WorkspaceFileMutation) OwnerIDs() (ids []uuid.UUID) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *WorkspaceFileMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// ClearWorkspace clears the "workspace" edge to the Workspace entity.
func (m *WorkspaceFileMutation) ClearWorkspace() {
	m.clearedworkspace = true
	m.clearedFields[workspacefile.FieldWorkspaceID] = struct{}{}
}

// WorkspaceCleared reports if the "workspace" edge to the Workspace entity was cleared.
func (m *WorkspaceFileMutation) WorkspaceCleared() bool {
	return m.clearedworkspace
}

// WorkspaceIDs returns the "workspace" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// WorkspaceID instead. It exists only for internal usage by the builders.
func (m *WorkspaceFileMutation) WorkspaceIDs() (ids []uuid.UUID) {
	if id := m.workspace; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetWorkspace resets all changes to the "workspace" edge.
func (m *WorkspaceFileMutation) ResetWorkspace() {
	m.workspace = nil
	m.clearedworkspace = false
}

// AddSnippetIDs adds the "snippets" edge to the CodeSnippet entity by ids.
func (m *WorkspaceFileMutation) AddSnippetIDs(ids ...uuid.UUID) {
	if m.snippets == nil {
		m.snippets = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.snippets[ids[i]] = struct{}{}
	}
}

// ClearSnippets clears the "snippets" edge to the CodeSnippet entity.
func (m *WorkspaceFileMutation) ClearSnippets() {
	m.clearedsnippets = true
}

// SnippetsCleared reports if the "snippets" edge to the CodeSnippet entity was cleared.
func (m *WorkspaceFileMutation) SnippetsCleared() bool {
	return m.clearedsnippets
}

// RemoveSnippetIDs removes the "snippets" edge to the CodeSnippet entity by IDs.
func (m *WorkspaceFileMutation) RemoveSnippetIDs(ids ...uuid.UUID) {
	if m.removedsnippets == nil {
		m.removedsnippets = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.snippets, ids[i])
		m.removedsnippets[ids[i]] = struct{}{}
	}
}

// RemovedSnippets returns the removed IDs of the "snippets" edge to the CodeSnippet entity.
func (m *WorkspaceFileMutation) RemovedSnippetsIDs() (ids []uuid.UUID) {
	for id := range m.removedsnippets {
		ids = append(ids, id)
	}
	return
}

// SnippetsIDs returns the "snippets" edge IDs in the mutation.
func (m *WorkspaceFileMutation) SnippetsIDs() (ids []uuid.UUID) {
	for id := range m.snippets {
		ids = append(ids, id)
	}
	return
}

// ResetSnippets resets all changes to the "snippets" edge.
func (m *WorkspaceFileMutation) ResetSnippets() {
	m.snippets = nil
	m.clearedsnippets = false
	m.removedsnippets = nil
}

// Where appends a list predicates to the WorkspaceFileMutation builder.
func (m *WorkspaceFileMutation) Where(ps ...predicate.WorkspaceFile) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the WorkspaceFileMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *WorkspaceFileMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.WorkspaceFile, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *WorkspaceFileMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *WorkspaceFileMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (WorkspaceFile).
func (m *WorkspaceFileMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *WorkspaceFileMutation) Fields() []string {
	fields := make([]string, 0, 9)
	if m.owner != nil {
		fields = append(fields, workspacefile.FieldUserID)
	}
	if m.workspace != nil {
		fields = append(fields, workspacefile.FieldWorkspaceID)
	}
	if m._path != nil {
		fields = append(fields, workspacefile.FieldPath)
	}
	if m.content != nil {
		fields = append(fields, workspacefile.FieldContent)
	}
	if m.hash != nil {
		fields = append(fields, workspacefile.FieldHash)
	}
	if m.language != nil {
		fields = append(fields, workspacefile.FieldLanguage)
	}
	if m.size != nil {
		fields = append(fields, workspacefile.FieldSize)
	}
	if m.created_at != nil {
		fields = append(fields, workspacefile.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, workspacefile.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *WorkspaceFileMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case workspacefile.FieldUserID:
		return m.UserID()
	case workspacefile.FieldWorkspaceID:
		return m.WorkspaceID()
	case workspacefile.FieldPath:
		return m.Path()
	case workspacefile.FieldContent:
		return m.Content()
	case workspacefile.FieldHash:
		return m.Hash()
	case workspacefile.FieldLanguage:
		return m.Language()
	case workspacefile.FieldSize:
		return m.Size()
	case workspacefile.FieldCreatedAt:
		return m.CreatedAt()
	case workspacefile.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *WorkspaceFileMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case workspacefile.FieldUserID:
		return m.OldUserID(ctx)
	case workspacefile.FieldWorkspaceID:
		return m.OldWorkspaceID(ctx)
	case workspacefile.FieldPath:
		return m.OldPath(ctx)
	case workspacefile.FieldContent:
		return m.OldContent(ctx)
	case workspacefile.FieldHash:
		return m.OldHash(ctx)
	case workspacefile.FieldLanguage:
		return m.OldLanguage(ctx)
	case workspacefile.FieldSize:
		return m.OldSize(ctx)
	case workspacefile.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case workspacefile.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown WorkspaceFile field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *WorkspaceFileMutation) SetField(name string, value ent.Value) error {
	switch name {
	case workspacefile.FieldUserID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case workspacefile.FieldWorkspaceID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetWorkspaceID(v)
		return nil
	case workspacefile.FieldPath:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPath(v)
		return nil
	case workspacefile.FieldContent:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetContent(v)
		return nil
	case workspacefile.FieldHash:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetHash(v)
		return nil
	case workspacefile.FieldLanguage:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLanguage(v)
		return nil
	case workspacefile.FieldSize:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSize(v)
		return nil
	case workspacefile.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case workspacefile.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown WorkspaceFile field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *WorkspaceFileMutation) AddedFields() []string {
	var fields []string
	if m.addsize != nil {
		fields = append(fields, workspacefile.FieldSize)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *WorkspaceFileMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case workspacefile.FieldSize:
		return m.AddedSize()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *WorkspaceFileMutation) AddField(name string, value ent.Value) error {
	switch name {
	case workspacefile.FieldSize:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddSize(v)
		return nil
	}
	return fmt.Errorf("unknown WorkspaceFile numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *WorkspaceFileMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(workspacefile.FieldContent) {
		fields = append(fields, workspacefile.FieldContent)
	}
	if m.FieldCleared(workspacefile.FieldLanguage) {
		fields = append(fields, workspacefile.FieldLanguage)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *WorkspaceFileMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *WorkspaceFileMutation) ClearField(name string) error {
	switch name {
	case workspacefile.FieldContent:
		m.ClearContent()
		return nil
	case workspacefile.FieldLanguage:
		m.ClearLanguage()
		return nil
	}
	return fmt.Errorf("unknown WorkspaceFile nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *WorkspaceFileMutation) ResetField(name string) error {
	switch name {
	case workspacefile.FieldUserID:
		m.ResetUserID()
		return nil
	case workspacefile.FieldWorkspaceID:
		m.ResetWorkspaceID()
		return nil
	case workspacefile.FieldPath:
		m.ResetPath()
		return nil
	case workspacefile.FieldContent:
		m.ResetContent()
		return nil
	case workspacefile.FieldHash:
		m.ResetHash()
		return nil
	case workspacefile.FieldLanguage:
		m.ResetLanguage()
		return nil
	case workspacefile.FieldSize:
		m.ResetSize()
		return nil
	case workspacefile.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case workspacefile.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown WorkspaceFile field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *WorkspaceFileMutation) AddedEdges() []string {
	edges := make([]string, 0, 3)
	if m.owner != nil {
		edges = append(edges, workspacefile.EdgeOwner)
	}
	if m.workspace != nil {
		edges = append(edges, workspacefile.EdgeWorkspace)
	}
	if m.snippets != nil {
		edges = append(edges, workspacefile.EdgeSnippets)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *WorkspaceFileMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case workspacefile.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	case workspacefile.EdgeWorkspace:
		if id := m.workspace; id != nil {
			return []ent.Value{*id}
		}
	case workspacefile.EdgeSnippets:
		ids := make([]ent.Value, 0, len(m.snippets))
		for id := range m.snippets {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *WorkspaceFileMutation) RemovedEdges() []string {
	edges := make([]string, 0, 3)
	if m.removedsnippets != nil {
		edges = append(edges, workspacefile.EdgeSnippets)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *WorkspaceFileMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case workspacefile.EdgeSnippets:
		ids := make([]ent.Value, 0, len(m.removedsnippets))
		for id := range m.removedsnippets {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *WorkspaceFileMutation) ClearedEdges() []string {
	edges := make([]string, 0, 3)
	if m.clearedowner {
		edges = append(edges, workspacefile.EdgeOwner)
	}
	if m.clearedworkspace {
		edges = append(edges, workspacefile.EdgeWorkspace)
	}
	if m.clearedsnippets {
		edges = append(edges, workspacefile.EdgeSnippets)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *WorkspaceFileMutation) EdgeCleared(name string) bool {
	switch name {
	case workspacefile.EdgeOwner:
		return m.clearedowner
	case workspacefile.EdgeWorkspace:
		return m.clearedworkspace
	case workspacefile.EdgeSnippets:
		return m.clearedsnippets
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *WorkspaceFileMutation) ClearEdge(name string) error {
	switch name {
	case workspacefile.EdgeOwner:
		m.ClearOwner()
		return nil
	case workspacefile.EdgeWorkspace:
		m.ClearWorkspace()
		return nil
	}
	return fmt.Errorf("unknown WorkspaceFile unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *WorkspaceFileMutation) ResetEdge(name string) error {
	switch name {
	case workspacefile.EdgeOwner:
		m.ResetOwner()
		return nil
	case workspacefile.EdgeWorkspace:
		m.ResetWorkspace()
		return nil
	case workspacefile.EdgeSnippets:
		m.ResetSnippets()
		return nil
	}
	return fmt.Errorf("unknown WorkspaceFile edge %s", name)
}
