// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovider"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovidermodel"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// ModelProviderModelUpdate is the builder for updating ModelProviderModel entities.
type ModelProviderModelUpdate struct {
	config
	hooks     []Hook
	mutation  *ModelProviderModelMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the ModelProviderModelUpdate builder.
func (mpmu *ModelProviderModelUpdate) Where(ps ...predicate.ModelProviderModel) *ModelProviderModelUpdate {
	mpmu.mutation.Where(ps...)
	return mpmu
}

// SetName sets the "name" field.
func (mpmu *ModelProviderModelUpdate) SetName(s string) *ModelProviderModelUpdate {
	mpmu.mutation.SetName(s)
	return mpmu
}

// SetNillableName sets the "name" field if the given value is not nil.
func (mpmu *ModelProviderModelUpdate) SetNillableName(s *string) *ModelProviderModelUpdate {
	if s != nil {
		mpmu.SetName(*s)
	}
	return mpmu
}

// SetProviderID sets the "provider_id" field.
func (mpmu *ModelProviderModelUpdate) SetProviderID(s string) *ModelProviderModelUpdate {
	mpmu.mutation.SetProviderID(s)
	return mpmu
}

// SetNillableProviderID sets the "provider_id" field if the given value is not nil.
func (mpmu *ModelProviderModelUpdate) SetNillableProviderID(s *string) *ModelProviderModelUpdate {
	if s != nil {
		mpmu.SetProviderID(*s)
	}
	return mpmu
}

// ClearProviderID clears the value of the "provider_id" field.
func (mpmu *ModelProviderModelUpdate) ClearProviderID() *ModelProviderModelUpdate {
	mpmu.mutation.ClearProviderID()
	return mpmu
}

// SetCreatedAt sets the "created_at" field.
func (mpmu *ModelProviderModelUpdate) SetCreatedAt(t time.Time) *ModelProviderModelUpdate {
	mpmu.mutation.SetCreatedAt(t)
	return mpmu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (mpmu *ModelProviderModelUpdate) SetNillableCreatedAt(t *time.Time) *ModelProviderModelUpdate {
	if t != nil {
		mpmu.SetCreatedAt(*t)
	}
	return mpmu
}

// SetUpdatedAt sets the "updated_at" field.
func (mpmu *ModelProviderModelUpdate) SetUpdatedAt(t time.Time) *ModelProviderModelUpdate {
	mpmu.mutation.SetUpdatedAt(t)
	return mpmu
}

// SetProvider sets the "provider" edge to the ModelProvider entity.
func (mpmu *ModelProviderModelUpdate) SetProvider(m *ModelProvider) *ModelProviderModelUpdate {
	return mpmu.SetProviderID(m.ID)
}

// Mutation returns the ModelProviderModelMutation object of the builder.
func (mpmu *ModelProviderModelUpdate) Mutation() *ModelProviderModelMutation {
	return mpmu.mutation
}

// ClearProvider clears the "provider" edge to the ModelProvider entity.
func (mpmu *ModelProviderModelUpdate) ClearProvider() *ModelProviderModelUpdate {
	mpmu.mutation.ClearProvider()
	return mpmu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (mpmu *ModelProviderModelUpdate) Save(ctx context.Context) (int, error) {
	mpmu.defaults()
	return withHooks(ctx, mpmu.sqlSave, mpmu.mutation, mpmu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (mpmu *ModelProviderModelUpdate) SaveX(ctx context.Context) int {
	affected, err := mpmu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (mpmu *ModelProviderModelUpdate) Exec(ctx context.Context) error {
	_, err := mpmu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mpmu *ModelProviderModelUpdate) ExecX(ctx context.Context) {
	if err := mpmu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (mpmu *ModelProviderModelUpdate) defaults() {
	if _, ok := mpmu.mutation.UpdatedAt(); !ok {
		v := modelprovidermodel.UpdateDefaultUpdatedAt()
		mpmu.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (mpmu *ModelProviderModelUpdate) check() error {
	if v, ok := mpmu.mutation.Name(); ok {
		if err := modelprovidermodel.NameValidator(v); err != nil {
			return &ValidationError{Name: "name", err: fmt.Errorf(`db: validator failed for field "ModelProviderModel.name": %w`, err)}
		}
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (mpmu *ModelProviderModelUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *ModelProviderModelUpdate {
	mpmu.modifiers = append(mpmu.modifiers, modifiers...)
	return mpmu
}

func (mpmu *ModelProviderModelUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := mpmu.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(modelprovidermodel.Table, modelprovidermodel.Columns, sqlgraph.NewFieldSpec(modelprovidermodel.FieldID, field.TypeUUID))
	if ps := mpmu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := mpmu.mutation.Name(); ok {
		_spec.SetField(modelprovidermodel.FieldName, field.TypeString, value)
	}
	if value, ok := mpmu.mutation.CreatedAt(); ok {
		_spec.SetField(modelprovidermodel.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := mpmu.mutation.UpdatedAt(); ok {
		_spec.SetField(modelprovidermodel.FieldUpdatedAt, field.TypeTime, value)
	}
	if mpmu.mutation.ProviderCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   modelprovidermodel.ProviderTable,
			Columns: []string{modelprovidermodel.ProviderColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(modelprovider.FieldID, field.TypeString),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := mpmu.mutation.ProviderIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   modelprovidermodel.ProviderTable,
			Columns: []string{modelprovidermodel.ProviderColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(modelprovider.FieldID, field.TypeString),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(mpmu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, mpmu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{modelprovidermodel.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	mpmu.mutation.done = true
	return n, nil
}

// ModelProviderModelUpdateOne is the builder for updating a single ModelProviderModel entity.
type ModelProviderModelUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *ModelProviderModelMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetName sets the "name" field.
func (mpmuo *ModelProviderModelUpdateOne) SetName(s string) *ModelProviderModelUpdateOne {
	mpmuo.mutation.SetName(s)
	return mpmuo
}

// SetNillableName sets the "name" field if the given value is not nil.
func (mpmuo *ModelProviderModelUpdateOne) SetNillableName(s *string) *ModelProviderModelUpdateOne {
	if s != nil {
		mpmuo.SetName(*s)
	}
	return mpmuo
}

// SetProviderID sets the "provider_id" field.
func (mpmuo *ModelProviderModelUpdateOne) SetProviderID(s string) *ModelProviderModelUpdateOne {
	mpmuo.mutation.SetProviderID(s)
	return mpmuo
}

// SetNillableProviderID sets the "provider_id" field if the given value is not nil.
func (mpmuo *ModelProviderModelUpdateOne) SetNillableProviderID(s *string) *ModelProviderModelUpdateOne {
	if s != nil {
		mpmuo.SetProviderID(*s)
	}
	return mpmuo
}

// ClearProviderID clears the value of the "provider_id" field.
func (mpmuo *ModelProviderModelUpdateOne) ClearProviderID() *ModelProviderModelUpdateOne {
	mpmuo.mutation.ClearProviderID()
	return mpmuo
}

// SetCreatedAt sets the "created_at" field.
func (mpmuo *ModelProviderModelUpdateOne) SetCreatedAt(t time.Time) *ModelProviderModelUpdateOne {
	mpmuo.mutation.SetCreatedAt(t)
	return mpmuo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (mpmuo *ModelProviderModelUpdateOne) SetNillableCreatedAt(t *time.Time) *ModelProviderModelUpdateOne {
	if t != nil {
		mpmuo.SetCreatedAt(*t)
	}
	return mpmuo
}

// SetUpdatedAt sets the "updated_at" field.
func (mpmuo *ModelProviderModelUpdateOne) SetUpdatedAt(t time.Time) *ModelProviderModelUpdateOne {
	mpmuo.mutation.SetUpdatedAt(t)
	return mpmuo
}

// SetProvider sets the "provider" edge to the ModelProvider entity.
func (mpmuo *ModelProviderModelUpdateOne) SetProvider(m *ModelProvider) *ModelProviderModelUpdateOne {
	return mpmuo.SetProviderID(m.ID)
}

// Mutation returns the ModelProviderModelMutation object of the builder.
func (mpmuo *ModelProviderModelUpdateOne) Mutation() *ModelProviderModelMutation {
	return mpmuo.mutation
}

// ClearProvider clears the "provider" edge to the ModelProvider entity.
func (mpmuo *ModelProviderModelUpdateOne) ClearProvider() *ModelProviderModelUpdateOne {
	mpmuo.mutation.ClearProvider()
	return mpmuo
}

// Where appends a list predicates to the ModelProviderModelUpdate builder.
func (mpmuo *ModelProviderModelUpdateOne) Where(ps ...predicate.ModelProviderModel) *ModelProviderModelUpdateOne {
	mpmuo.mutation.Where(ps...)
	return mpmuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (mpmuo *ModelProviderModelUpdateOne) Select(field string, fields ...string) *ModelProviderModelUpdateOne {
	mpmuo.fields = append([]string{field}, fields...)
	return mpmuo
}

// Save executes the query and returns the updated ModelProviderModel entity.
func (mpmuo *ModelProviderModelUpdateOne) Save(ctx context.Context) (*ModelProviderModel, error) {
	mpmuo.defaults()
	return withHooks(ctx, mpmuo.sqlSave, mpmuo.mutation, mpmuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (mpmuo *ModelProviderModelUpdateOne) SaveX(ctx context.Context) *ModelProviderModel {
	node, err := mpmuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (mpmuo *ModelProviderModelUpdateOne) Exec(ctx context.Context) error {
	_, err := mpmuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mpmuo *ModelProviderModelUpdateOne) ExecX(ctx context.Context) {
	if err := mpmuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (mpmuo *ModelProviderModelUpdateOne) defaults() {
	if _, ok := mpmuo.mutation.UpdatedAt(); !ok {
		v := modelprovidermodel.UpdateDefaultUpdatedAt()
		mpmuo.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (mpmuo *ModelProviderModelUpdateOne) check() error {
	if v, ok := mpmuo.mutation.Name(); ok {
		if err := modelprovidermodel.NameValidator(v); err != nil {
			return &ValidationError{Name: "name", err: fmt.Errorf(`db: validator failed for field "ModelProviderModel.name": %w`, err)}
		}
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (mpmuo *ModelProviderModelUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *ModelProviderModelUpdateOne {
	mpmuo.modifiers = append(mpmuo.modifiers, modifiers...)
	return mpmuo
}

func (mpmuo *ModelProviderModelUpdateOne) sqlSave(ctx context.Context) (_node *ModelProviderModel, err error) {
	if err := mpmuo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(modelprovidermodel.Table, modelprovidermodel.Columns, sqlgraph.NewFieldSpec(modelprovidermodel.FieldID, field.TypeUUID))
	id, ok := mpmuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "ModelProviderModel.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := mpmuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, modelprovidermodel.FieldID)
		for _, f := range fields {
			if !modelprovidermodel.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != modelprovidermodel.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := mpmuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := mpmuo.mutation.Name(); ok {
		_spec.SetField(modelprovidermodel.FieldName, field.TypeString, value)
	}
	if value, ok := mpmuo.mutation.CreatedAt(); ok {
		_spec.SetField(modelprovidermodel.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := mpmuo.mutation.UpdatedAt(); ok {
		_spec.SetField(modelprovidermodel.FieldUpdatedAt, field.TypeTime, value)
	}
	if mpmuo.mutation.ProviderCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   modelprovidermodel.ProviderTable,
			Columns: []string{modelprovidermodel.ProviderColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(modelprovider.FieldID, field.TypeString),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := mpmuo.mutation.ProviderIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   modelprovidermodel.ProviderTable,
			Columns: []string{modelprovidermodel.ProviderColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(modelprovider.FieldID, field.TypeString),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(mpmuo.modifiers...)
	_node = &ModelProviderModel{config: mpmuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, mpmuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{modelprovidermodel.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	mpmuo.mutation.done = true
	return _node, nil
}
