// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovidermodel"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// ModelProviderModelDelete is the builder for deleting a ModelProviderModel entity.
type ModelProviderModelDelete struct {
	config
	hooks    []Hook
	mutation *ModelProviderModelMutation
}

// Where appends a list predicates to the ModelProviderModelDelete builder.
func (mpmd *ModelProviderModelDelete) Where(ps ...predicate.ModelProviderModel) *ModelProviderModelDelete {
	mpmd.mutation.Where(ps...)
	return mpmd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (mpmd *ModelProviderModelDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, mpmd.sqlExec, mpmd.mutation, mpmd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (mpmd *ModelProviderModelDelete) ExecX(ctx context.Context) int {
	n, err := mpmd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (mpmd *ModelProviderModelDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(modelprovidermodel.Table, sqlgraph.NewFieldSpec(modelprovidermodel.FieldID, field.TypeUUID))
	if ps := mpmd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, mpmd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	mpmd.mutation.done = true
	return affected, err
}

// ModelProviderModelDeleteOne is the builder for deleting a single ModelProviderModel entity.
type ModelProviderModelDeleteOne struct {
	mpmd *ModelProviderModelDelete
}

// Where appends a list predicates to the ModelProviderModelDelete builder.
func (mpmdo *ModelProviderModelDeleteOne) Where(ps ...predicate.ModelProviderModel) *ModelProviderModelDeleteOne {
	mpmdo.mpmd.mutation.Where(ps...)
	return mpmdo
}

// Exec executes the deletion query.
func (mpmdo *ModelProviderModelDeleteOne) Exec(ctx context.Context) error {
	n, err := mpmdo.mpmd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{modelprovidermodel.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (mpmdo *ModelProviderModelDeleteOne) ExecX(ctx context.Context) {
	if err := mpmdo.Exec(ctx); err != nil {
		panic(err)
	}
}
