// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovider"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovidermodel"
	"github.com/google/uuid"
)

// ModelProviderModelCreate is the builder for creating a ModelProviderModel entity.
type ModelProviderModelCreate struct {
	config
	mutation *ModelProviderModelMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetName sets the "name" field.
func (mpmc *ModelProviderModelCreate) SetName(s string) *ModelProviderModelCreate {
	mpmc.mutation.SetName(s)
	return mpmc
}

// SetProviderID sets the "provider_id" field.
func (mpmc *ModelProviderModelCreate) SetProviderID(s string) *ModelProviderModelCreate {
	mpmc.mutation.SetProviderID(s)
	return mpmc
}

// SetNillableProviderID sets the "provider_id" field if the given value is not nil.
func (mpmc *ModelProviderModelCreate) SetNillableProviderID(s *string) *ModelProviderModelCreate {
	if s != nil {
		mpmc.SetProviderID(*s)
	}
	return mpmc
}

// SetCreatedAt sets the "created_at" field.
func (mpmc *ModelProviderModelCreate) SetCreatedAt(t time.Time) *ModelProviderModelCreate {
	mpmc.mutation.SetCreatedAt(t)
	return mpmc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (mpmc *ModelProviderModelCreate) SetNillableCreatedAt(t *time.Time) *ModelProviderModelCreate {
	if t != nil {
		mpmc.SetCreatedAt(*t)
	}
	return mpmc
}

// SetUpdatedAt sets the "updated_at" field.
func (mpmc *ModelProviderModelCreate) SetUpdatedAt(t time.Time) *ModelProviderModelCreate {
	mpmc.mutation.SetUpdatedAt(t)
	return mpmc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (mpmc *ModelProviderModelCreate) SetNillableUpdatedAt(t *time.Time) *ModelProviderModelCreate {
	if t != nil {
		mpmc.SetUpdatedAt(*t)
	}
	return mpmc
}

// SetID sets the "id" field.
func (mpmc *ModelProviderModelCreate) SetID(u uuid.UUID) *ModelProviderModelCreate {
	mpmc.mutation.SetID(u)
	return mpmc
}

// SetNillableID sets the "id" field if the given value is not nil.
func (mpmc *ModelProviderModelCreate) SetNillableID(u *uuid.UUID) *ModelProviderModelCreate {
	if u != nil {
		mpmc.SetID(*u)
	}
	return mpmc
}

// SetProvider sets the "provider" edge to the ModelProvider entity.
func (mpmc *ModelProviderModelCreate) SetProvider(m *ModelProvider) *ModelProviderModelCreate {
	return mpmc.SetProviderID(m.ID)
}

// Mutation returns the ModelProviderModelMutation object of the builder.
func (mpmc *ModelProviderModelCreate) Mutation() *ModelProviderModelMutation {
	return mpmc.mutation
}

// Save creates the ModelProviderModel in the database.
func (mpmc *ModelProviderModelCreate) Save(ctx context.Context) (*ModelProviderModel, error) {
	mpmc.defaults()
	return withHooks(ctx, mpmc.sqlSave, mpmc.mutation, mpmc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (mpmc *ModelProviderModelCreate) SaveX(ctx context.Context) *ModelProviderModel {
	v, err := mpmc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (mpmc *ModelProviderModelCreate) Exec(ctx context.Context) error {
	_, err := mpmc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mpmc *ModelProviderModelCreate) ExecX(ctx context.Context) {
	if err := mpmc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (mpmc *ModelProviderModelCreate) defaults() {
	if _, ok := mpmc.mutation.CreatedAt(); !ok {
		v := modelprovidermodel.DefaultCreatedAt()
		mpmc.mutation.SetCreatedAt(v)
	}
	if _, ok := mpmc.mutation.UpdatedAt(); !ok {
		v := modelprovidermodel.DefaultUpdatedAt()
		mpmc.mutation.SetUpdatedAt(v)
	}
	if _, ok := mpmc.mutation.ID(); !ok {
		v := modelprovidermodel.DefaultID()
		mpmc.mutation.SetID(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (mpmc *ModelProviderModelCreate) check() error {
	if _, ok := mpmc.mutation.Name(); !ok {
		return &ValidationError{Name: "name", err: errors.New(`db: missing required field "ModelProviderModel.name"`)}
	}
	if v, ok := mpmc.mutation.Name(); ok {
		if err := modelprovidermodel.NameValidator(v); err != nil {
			return &ValidationError{Name: "name", err: fmt.Errorf(`db: validator failed for field "ModelProviderModel.name": %w`, err)}
		}
	}
	if _, ok := mpmc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "ModelProviderModel.created_at"`)}
	}
	if _, ok := mpmc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "ModelProviderModel.updated_at"`)}
	}
	return nil
}

func (mpmc *ModelProviderModelCreate) sqlSave(ctx context.Context) (*ModelProviderModel, error) {
	if err := mpmc.check(); err != nil {
		return nil, err
	}
	_node, _spec := mpmc.createSpec()
	if err := sqlgraph.CreateNode(ctx, mpmc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	mpmc.mutation.id = &_node.ID
	mpmc.mutation.done = true
	return _node, nil
}

func (mpmc *ModelProviderModelCreate) createSpec() (*ModelProviderModel, *sqlgraph.CreateSpec) {
	var (
		_node = &ModelProviderModel{config: mpmc.config}
		_spec = sqlgraph.NewCreateSpec(modelprovidermodel.Table, sqlgraph.NewFieldSpec(modelprovidermodel.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = mpmc.conflict
	if id, ok := mpmc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := mpmc.mutation.Name(); ok {
		_spec.SetField(modelprovidermodel.FieldName, field.TypeString, value)
		_node.Name = value
	}
	if value, ok := mpmc.mutation.CreatedAt(); ok {
		_spec.SetField(modelprovidermodel.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := mpmc.mutation.UpdatedAt(); ok {
		_spec.SetField(modelprovidermodel.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if nodes := mpmc.mutation.ProviderIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   modelprovidermodel.ProviderTable,
			Columns: []string{modelprovidermodel.ProviderColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(modelprovider.FieldID, field.TypeString),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.ProviderID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.ModelProviderModel.Create().
//		SetName(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.ModelProviderModelUpsert) {
//			SetName(v+v).
//		}).
//		Exec(ctx)
func (mpmc *ModelProviderModelCreate) OnConflict(opts ...sql.ConflictOption) *ModelProviderModelUpsertOne {
	mpmc.conflict = opts
	return &ModelProviderModelUpsertOne{
		create: mpmc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.ModelProviderModel.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (mpmc *ModelProviderModelCreate) OnConflictColumns(columns ...string) *ModelProviderModelUpsertOne {
	mpmc.conflict = append(mpmc.conflict, sql.ConflictColumns(columns...))
	return &ModelProviderModelUpsertOne{
		create: mpmc,
	}
}

type (
	// ModelProviderModelUpsertOne is the builder for "upsert"-ing
	//  one ModelProviderModel node.
	ModelProviderModelUpsertOne struct {
		create *ModelProviderModelCreate
	}

	// ModelProviderModelUpsert is the "OnConflict" setter.
	ModelProviderModelUpsert struct {
		*sql.UpdateSet
	}
)

// SetName sets the "name" field.
func (u *ModelProviderModelUpsert) SetName(v string) *ModelProviderModelUpsert {
	u.Set(modelprovidermodel.FieldName, v)
	return u
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *ModelProviderModelUpsert) UpdateName() *ModelProviderModelUpsert {
	u.SetExcluded(modelprovidermodel.FieldName)
	return u
}

// SetProviderID sets the "provider_id" field.
func (u *ModelProviderModelUpsert) SetProviderID(v string) *ModelProviderModelUpsert {
	u.Set(modelprovidermodel.FieldProviderID, v)
	return u
}

// UpdateProviderID sets the "provider_id" field to the value that was provided on create.
func (u *ModelProviderModelUpsert) UpdateProviderID() *ModelProviderModelUpsert {
	u.SetExcluded(modelprovidermodel.FieldProviderID)
	return u
}

// ClearProviderID clears the value of the "provider_id" field.
func (u *ModelProviderModelUpsert) ClearProviderID() *ModelProviderModelUpsert {
	u.SetNull(modelprovidermodel.FieldProviderID)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *ModelProviderModelUpsert) SetCreatedAt(v time.Time) *ModelProviderModelUpsert {
	u.Set(modelprovidermodel.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ModelProviderModelUpsert) UpdateCreatedAt() *ModelProviderModelUpsert {
	u.SetExcluded(modelprovidermodel.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ModelProviderModelUpsert) SetUpdatedAt(v time.Time) *ModelProviderModelUpsert {
	u.Set(modelprovidermodel.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ModelProviderModelUpsert) UpdateUpdatedAt() *ModelProviderModelUpsert {
	u.SetExcluded(modelprovidermodel.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.ModelProviderModel.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(modelprovidermodel.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *ModelProviderModelUpsertOne) UpdateNewValues() *ModelProviderModelUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(modelprovidermodel.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.ModelProviderModel.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *ModelProviderModelUpsertOne) Ignore() *ModelProviderModelUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *ModelProviderModelUpsertOne) DoNothing() *ModelProviderModelUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the ModelProviderModelCreate.OnConflict
// documentation for more info.
func (u *ModelProviderModelUpsertOne) Update(set func(*ModelProviderModelUpsert)) *ModelProviderModelUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&ModelProviderModelUpsert{UpdateSet: update})
	}))
	return u
}

// SetName sets the "name" field.
func (u *ModelProviderModelUpsertOne) SetName(v string) *ModelProviderModelUpsertOne {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *ModelProviderModelUpsertOne) UpdateName() *ModelProviderModelUpsertOne {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.UpdateName()
	})
}

// SetProviderID sets the "provider_id" field.
func (u *ModelProviderModelUpsertOne) SetProviderID(v string) *ModelProviderModelUpsertOne {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.SetProviderID(v)
	})
}

// UpdateProviderID sets the "provider_id" field to the value that was provided on create.
func (u *ModelProviderModelUpsertOne) UpdateProviderID() *ModelProviderModelUpsertOne {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.UpdateProviderID()
	})
}

// ClearProviderID clears the value of the "provider_id" field.
func (u *ModelProviderModelUpsertOne) ClearProviderID() *ModelProviderModelUpsertOne {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.ClearProviderID()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *ModelProviderModelUpsertOne) SetCreatedAt(v time.Time) *ModelProviderModelUpsertOne {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ModelProviderModelUpsertOne) UpdateCreatedAt() *ModelProviderModelUpsertOne {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ModelProviderModelUpsertOne) SetUpdatedAt(v time.Time) *ModelProviderModelUpsertOne {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ModelProviderModelUpsertOne) UpdateUpdatedAt() *ModelProviderModelUpsertOne {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *ModelProviderModelUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for ModelProviderModelCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *ModelProviderModelUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *ModelProviderModelUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: ModelProviderModelUpsertOne.ID is not supported by MySQL driver. Use ModelProviderModelUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *ModelProviderModelUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// ModelProviderModelCreateBulk is the builder for creating many ModelProviderModel entities in bulk.
type ModelProviderModelCreateBulk struct {
	config
	err      error
	builders []*ModelProviderModelCreate
	conflict []sql.ConflictOption
}

// Save creates the ModelProviderModel entities in the database.
func (mpmcb *ModelProviderModelCreateBulk) Save(ctx context.Context) ([]*ModelProviderModel, error) {
	if mpmcb.err != nil {
		return nil, mpmcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(mpmcb.builders))
	nodes := make([]*ModelProviderModel, len(mpmcb.builders))
	mutators := make([]Mutator, len(mpmcb.builders))
	for i := range mpmcb.builders {
		func(i int, root context.Context) {
			builder := mpmcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*ModelProviderModelMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, mpmcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = mpmcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, mpmcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, mpmcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (mpmcb *ModelProviderModelCreateBulk) SaveX(ctx context.Context) []*ModelProviderModel {
	v, err := mpmcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (mpmcb *ModelProviderModelCreateBulk) Exec(ctx context.Context) error {
	_, err := mpmcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mpmcb *ModelProviderModelCreateBulk) ExecX(ctx context.Context) {
	if err := mpmcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.ModelProviderModel.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.ModelProviderModelUpsert) {
//			SetName(v+v).
//		}).
//		Exec(ctx)
func (mpmcb *ModelProviderModelCreateBulk) OnConflict(opts ...sql.ConflictOption) *ModelProviderModelUpsertBulk {
	mpmcb.conflict = opts
	return &ModelProviderModelUpsertBulk{
		create: mpmcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.ModelProviderModel.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (mpmcb *ModelProviderModelCreateBulk) OnConflictColumns(columns ...string) *ModelProviderModelUpsertBulk {
	mpmcb.conflict = append(mpmcb.conflict, sql.ConflictColumns(columns...))
	return &ModelProviderModelUpsertBulk{
		create: mpmcb,
	}
}

// ModelProviderModelUpsertBulk is the builder for "upsert"-ing
// a bulk of ModelProviderModel nodes.
type ModelProviderModelUpsertBulk struct {
	create *ModelProviderModelCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.ModelProviderModel.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(modelprovidermodel.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *ModelProviderModelUpsertBulk) UpdateNewValues() *ModelProviderModelUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(modelprovidermodel.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.ModelProviderModel.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *ModelProviderModelUpsertBulk) Ignore() *ModelProviderModelUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *ModelProviderModelUpsertBulk) DoNothing() *ModelProviderModelUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the ModelProviderModelCreateBulk.OnConflict
// documentation for more info.
func (u *ModelProviderModelUpsertBulk) Update(set func(*ModelProviderModelUpsert)) *ModelProviderModelUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&ModelProviderModelUpsert{UpdateSet: update})
	}))
	return u
}

// SetName sets the "name" field.
func (u *ModelProviderModelUpsertBulk) SetName(v string) *ModelProviderModelUpsertBulk {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *ModelProviderModelUpsertBulk) UpdateName() *ModelProviderModelUpsertBulk {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.UpdateName()
	})
}

// SetProviderID sets the "provider_id" field.
func (u *ModelProviderModelUpsertBulk) SetProviderID(v string) *ModelProviderModelUpsertBulk {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.SetProviderID(v)
	})
}

// UpdateProviderID sets the "provider_id" field to the value that was provided on create.
func (u *ModelProviderModelUpsertBulk) UpdateProviderID() *ModelProviderModelUpsertBulk {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.UpdateProviderID()
	})
}

// ClearProviderID clears the value of the "provider_id" field.
func (u *ModelProviderModelUpsertBulk) ClearProviderID() *ModelProviderModelUpsertBulk {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.ClearProviderID()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *ModelProviderModelUpsertBulk) SetCreatedAt(v time.Time) *ModelProviderModelUpsertBulk {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ModelProviderModelUpsertBulk) UpdateCreatedAt() *ModelProviderModelUpsertBulk {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ModelProviderModelUpsertBulk) SetUpdatedAt(v time.Time) *ModelProviderModelUpsertBulk {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ModelProviderModelUpsertBulk) UpdateUpdatedAt() *ModelProviderModelUpsertBulk {
	return u.Update(func(s *ModelProviderModelUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *ModelProviderModelUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the ModelProviderModelCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for ModelProviderModelCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *ModelProviderModelUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
