// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovider"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovidermodel"
	"github.com/google/uuid"
)

// ModelProviderModel is the model entity for the ModelProviderModel schema.
type ModelProviderModel struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// Name holds the value of the "name" field.
	Name string `json:"name,omitempty"`
	// ProviderID holds the value of the "provider_id" field.
	ProviderID string `json:"provider_id,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the ModelProviderModelQuery when eager-loading is set.
	Edges        ModelProviderModelEdges `json:"edges"`
	selectValues sql.SelectValues
}

// ModelProviderModelEdges holds the relations/edges for other nodes in the graph.
type ModelProviderModelEdges struct {
	// Provider holds the value of the provider edge.
	Provider *ModelProvider `json:"provider,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [1]bool
}

// ProviderOrErr returns the Provider value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e ModelProviderModelEdges) ProviderOrErr() (*ModelProvider, error) {
	if e.Provider != nil {
		return e.Provider, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: modelprovider.Label}
	}
	return nil, &NotLoadedError{edge: "provider"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*ModelProviderModel) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case modelprovidermodel.FieldName, modelprovidermodel.FieldProviderID:
			values[i] = new(sql.NullString)
		case modelprovidermodel.FieldCreatedAt, modelprovidermodel.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		case modelprovidermodel.FieldID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the ModelProviderModel fields.
func (mpm *ModelProviderModel) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case modelprovidermodel.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				mpm.ID = *value
			}
		case modelprovidermodel.FieldName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field name", values[i])
			} else if value.Valid {
				mpm.Name = value.String
			}
		case modelprovidermodel.FieldProviderID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field provider_id", values[i])
			} else if value.Valid {
				mpm.ProviderID = value.String
			}
		case modelprovidermodel.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				mpm.CreatedAt = value.Time
			}
		case modelprovidermodel.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				mpm.UpdatedAt = value.Time
			}
		default:
			mpm.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the ModelProviderModel.
// This includes values selected through modifiers, order, etc.
func (mpm *ModelProviderModel) Value(name string) (ent.Value, error) {
	return mpm.selectValues.Get(name)
}

// QueryProvider queries the "provider" edge of the ModelProviderModel entity.
func (mpm *ModelProviderModel) QueryProvider() *ModelProviderQuery {
	return NewModelProviderModelClient(mpm.config).QueryProvider(mpm)
}

// Update returns a builder for updating this ModelProviderModel.
// Note that you need to call ModelProviderModel.Unwrap() before calling this method if this ModelProviderModel
// was returned from a transaction, and the transaction was committed or rolled back.
func (mpm *ModelProviderModel) Update() *ModelProviderModelUpdateOne {
	return NewModelProviderModelClient(mpm.config).UpdateOne(mpm)
}

// Unwrap unwraps the ModelProviderModel entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (mpm *ModelProviderModel) Unwrap() *ModelProviderModel {
	_tx, ok := mpm.config.driver.(*txDriver)
	if !ok {
		panic("db: ModelProviderModel is not a transactional entity")
	}
	mpm.config.driver = _tx.drv
	return mpm
}

// String implements the fmt.Stringer.
func (mpm *ModelProviderModel) String() string {
	var builder strings.Builder
	builder.WriteString("ModelProviderModel(")
	builder.WriteString(fmt.Sprintf("id=%v, ", mpm.ID))
	builder.WriteString("name=")
	builder.WriteString(mpm.Name)
	builder.WriteString(", ")
	builder.WriteString("provider_id=")
	builder.WriteString(mpm.ProviderID)
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(mpm.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(mpm.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// ModelProviderModels is a parsable slice of ModelProviderModel.
type ModelProviderModels []*ModelProviderModel
