// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovider"
)

// ModelProvider is the model entity for the ModelProvider schema.
type ModelProvider struct {
	config `json:"-"`
	// ID of the ent.
	ID string `json:"id,omitempty"`
	// Name holds the value of the "name" field.
	Name string `json:"name,omitempty"`
	// APIBase holds the value of the "api_base" field.
	APIBase string `json:"api_base,omitempty"`
	// Priority holds the value of the "priority" field.
	Priority int `json:"priority,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the ModelProviderQuery when eager-loading is set.
	Edges        ModelProviderEdges `json:"edges"`
	selectValues sql.SelectValues
}

// ModelProviderEdges holds the relations/edges for other nodes in the graph.
type ModelProviderEdges struct {
	// Models holds the value of the models edge.
	Models []*ModelProviderModel `json:"models,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [1]bool
}

// ModelsOrErr returns the Models value or an error if the edge
// was not loaded in eager-loading.
func (e ModelProviderEdges) ModelsOrErr() ([]*ModelProviderModel, error) {
	if e.loadedTypes[0] {
		return e.Models, nil
	}
	return nil, &NotLoadedError{edge: "models"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*ModelProvider) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case modelprovider.FieldPriority:
			values[i] = new(sql.NullInt64)
		case modelprovider.FieldID, modelprovider.FieldName, modelprovider.FieldAPIBase:
			values[i] = new(sql.NullString)
		case modelprovider.FieldCreatedAt, modelprovider.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the ModelProvider fields.
func (mp *ModelProvider) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case modelprovider.FieldID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value.Valid {
				mp.ID = value.String
			}
		case modelprovider.FieldName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field name", values[i])
			} else if value.Valid {
				mp.Name = value.String
			}
		case modelprovider.FieldAPIBase:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field api_base", values[i])
			} else if value.Valid {
				mp.APIBase = value.String
			}
		case modelprovider.FieldPriority:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field priority", values[i])
			} else if value.Valid {
				mp.Priority = int(value.Int64)
			}
		case modelprovider.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				mp.CreatedAt = value.Time
			}
		case modelprovider.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				mp.UpdatedAt = value.Time
			}
		default:
			mp.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the ModelProvider.
// This includes values selected through modifiers, order, etc.
func (mp *ModelProvider) Value(name string) (ent.Value, error) {
	return mp.selectValues.Get(name)
}

// QueryModels queries the "models" edge of the ModelProvider entity.
func (mp *ModelProvider) QueryModels() *ModelProviderModelQuery {
	return NewModelProviderClient(mp.config).QueryModels(mp)
}

// Update returns a builder for updating this ModelProvider.
// Note that you need to call ModelProvider.Unwrap() before calling this method if this ModelProvider
// was returned from a transaction, and the transaction was committed or rolled back.
func (mp *ModelProvider) Update() *ModelProviderUpdateOne {
	return NewModelProviderClient(mp.config).UpdateOne(mp)
}

// Unwrap unwraps the ModelProvider entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (mp *ModelProvider) Unwrap() *ModelProvider {
	_tx, ok := mp.config.driver.(*txDriver)
	if !ok {
		panic("db: ModelProvider is not a transactional entity")
	}
	mp.config.driver = _tx.drv
	return mp
}

// String implements the fmt.Stringer.
func (mp *ModelProvider) String() string {
	var builder strings.Builder
	builder.WriteString("ModelProvider(")
	builder.WriteString(fmt.Sprintf("id=%v, ", mp.ID))
	builder.WriteString("name=")
	builder.WriteString(mp.Name)
	builder.WriteString(", ")
	builder.WriteString("api_base=")
	builder.WriteString(mp.APIBase)
	builder.WriteString(", ")
	builder.WriteString("priority=")
	builder.WriteString(fmt.Sprintf("%v", mp.Priority))
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(mp.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(mp.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// ModelProviders is a parsable slice of ModelProvider.
type ModelProviders []*ModelProvider
