// Code generated by ent, DO NOT EDIT.

package model

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"github.com/chaitin/MonkeyCode/backend/consts"
)

const (
	// Label holds the string label denoting the model type in the database.
	Label = "model"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldUserID holds the string denoting the user_id field in the database.
	FieldUserID = "user_id"
	// FieldModelName holds the string denoting the model_name field in the database.
	FieldModelName = "model_name"
	// FieldModelType holds the string denoting the model_type field in the database.
	FieldModelType = "model_type"
	// FieldShowName holds the string denoting the show_name field in the database.
	FieldShowName = "show_name"
	// FieldAPIBase holds the string denoting the api_base field in the database.
	FieldAPIBase = "api_base"
	// FieldAPIKey holds the string denoting the api_key field in the database.
	FieldAPIKey = "api_key"
	// FieldAPIVersion holds the string denoting the api_version field in the database.
	FieldAPIVersion = "api_version"
	// FieldAPIHeader holds the string denoting the api_header field in the database.
	FieldAPIHeader = "api_header"
	// FieldDescription holds the string denoting the description field in the database.
	FieldDescription = "description"
	// FieldIsInternal holds the string denoting the is_internal field in the database.
	FieldIsInternal = "is_internal"
	// FieldProvider holds the string denoting the provider field in the database.
	FieldProvider = "provider"
	// FieldStatus holds the string denoting the status field in the database.
	FieldStatus = "status"
	// FieldParameters holds the string denoting the parameters field in the database.
	FieldParameters = "parameters"
	// FieldContextLength holds the string denoting the context_length field in the database.
	FieldContextLength = "context_length"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// FieldUpdatedAt holds the string denoting the updated_at field in the database.
	FieldUpdatedAt = "updated_at"
	// EdgeTasks holds the string denoting the tasks edge name in mutations.
	EdgeTasks = "tasks"
	// EdgeUser holds the string denoting the user edge name in mutations.
	EdgeUser = "user"
	// Table holds the table name of the model in the database.
	Table = "models"
	// TasksTable is the table that holds the tasks relation/edge.
	TasksTable = "tasks"
	// TasksInverseTable is the table name for the Task entity.
	// It exists in this package in order to avoid circular dependency with the "task" package.
	TasksInverseTable = "tasks"
	// TasksColumn is the table column denoting the tasks relation/edge.
	TasksColumn = "model_id"
	// UserTable is the table that holds the user relation/edge.
	UserTable = "models"
	// UserInverseTable is the table name for the User entity.
	// It exists in this package in order to avoid circular dependency with the "user" package.
	UserInverseTable = "users"
	// UserColumn is the table column denoting the user relation/edge.
	UserColumn = "user_id"
)

// Columns holds all SQL columns for model fields.
var Columns = []string{
	FieldID,
	FieldUserID,
	FieldModelName,
	FieldModelType,
	FieldShowName,
	FieldAPIBase,
	FieldAPIKey,
	FieldAPIVersion,
	FieldAPIHeader,
	FieldDescription,
	FieldIsInternal,
	FieldProvider,
	FieldStatus,
	FieldParameters,
	FieldContextLength,
	FieldCreatedAt,
	FieldUpdatedAt,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultIsInternal holds the default value on creation for the "is_internal" field.
	DefaultIsInternal bool
	// DefaultStatus holds the default value on creation for the "status" field.
	DefaultStatus consts.ModelStatus
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
	// DefaultUpdatedAt holds the default value on creation for the "updated_at" field.
	DefaultUpdatedAt func() time.Time
	// UpdateDefaultUpdatedAt holds the default value on update for the "updated_at" field.
	UpdateDefaultUpdatedAt func() time.Time
)

// OrderOption defines the ordering options for the Model queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByUserID orders the results by the user_id field.
func ByUserID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUserID, opts...).ToFunc()
}

// ByModelName orders the results by the model_name field.
func ByModelName(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldModelName, opts...).ToFunc()
}

// ByModelType orders the results by the model_type field.
func ByModelType(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldModelType, opts...).ToFunc()
}

// ByShowName orders the results by the show_name field.
func ByShowName(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldShowName, opts...).ToFunc()
}

// ByAPIBase orders the results by the api_base field.
func ByAPIBase(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAPIBase, opts...).ToFunc()
}

// ByAPIKey orders the results by the api_key field.
func ByAPIKey(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAPIKey, opts...).ToFunc()
}

// ByAPIVersion orders the results by the api_version field.
func ByAPIVersion(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAPIVersion, opts...).ToFunc()
}

// ByAPIHeader orders the results by the api_header field.
func ByAPIHeader(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAPIHeader, opts...).ToFunc()
}

// ByDescription orders the results by the description field.
func ByDescription(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldDescription, opts...).ToFunc()
}

// ByIsInternal orders the results by the is_internal field.
func ByIsInternal(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldIsInternal, opts...).ToFunc()
}

// ByProvider orders the results by the provider field.
func ByProvider(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldProvider, opts...).ToFunc()
}

// ByStatus orders the results by the status field.
func ByStatus(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldStatus, opts...).ToFunc()
}

// ByContextLength orders the results by the context_length field.
func ByContextLength(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldContextLength, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByUpdatedAt orders the results by the updated_at field.
func ByUpdatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUpdatedAt, opts...).ToFunc()
}

// ByTasksCount orders the results by tasks count.
func ByTasksCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newTasksStep(), opts...)
	}
}

// ByTasks orders the results by tasks terms.
func ByTasks(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newTasksStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByUserField orders the results by user field.
func ByUserField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newUserStep(), sql.OrderByField(field, opts...))
	}
}
func newTasksStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(TasksInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, TasksTable, TasksColumn),
	)
}
func newUserStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(UserInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, UserTable, UserColumn),
	)
}
