// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/invitecode"
	"github.com/google/uuid"
)

// InviteCode is the model entity for the InviteCode schema.
type InviteCode struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// AdminID holds the value of the "admin_id" field.
	AdminID uuid.UUID `json:"admin_id,omitempty"`
	// Code holds the value of the "code" field.
	Code string `json:"code,omitempty"`
	// Status holds the value of the "status" field.
	Status consts.InviteCodeStatus `json:"status,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// ExpiredAt holds the value of the "expired_at" field.
	ExpiredAt    time.Time `json:"expired_at,omitempty"`
	selectValues sql.SelectValues
}

// scanValues returns the types for scanning values from sql.Rows.
func (*InviteCode) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case invitecode.FieldCode, invitecode.FieldStatus:
			values[i] = new(sql.NullString)
		case invitecode.FieldCreatedAt, invitecode.FieldUpdatedAt, invitecode.FieldExpiredAt:
			values[i] = new(sql.NullTime)
		case invitecode.FieldID, invitecode.FieldAdminID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the InviteCode fields.
func (ic *InviteCode) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case invitecode.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				ic.ID = *value
			}
		case invitecode.FieldAdminID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field admin_id", values[i])
			} else if value != nil {
				ic.AdminID = *value
			}
		case invitecode.FieldCode:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field code", values[i])
			} else if value.Valid {
				ic.Code = value.String
			}
		case invitecode.FieldStatus:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field status", values[i])
			} else if value.Valid {
				ic.Status = consts.InviteCodeStatus(value.String)
			}
		case invitecode.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				ic.CreatedAt = value.Time
			}
		case invitecode.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				ic.UpdatedAt = value.Time
			}
		case invitecode.FieldExpiredAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field expired_at", values[i])
			} else if value.Valid {
				ic.ExpiredAt = value.Time
			}
		default:
			ic.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the InviteCode.
// This includes values selected through modifiers, order, etc.
func (ic *InviteCode) Value(name string) (ent.Value, error) {
	return ic.selectValues.Get(name)
}

// Update returns a builder for updating this InviteCode.
// Note that you need to call InviteCode.Unwrap() before calling this method if this InviteCode
// was returned from a transaction, and the transaction was committed or rolled back.
func (ic *InviteCode) Update() *InviteCodeUpdateOne {
	return NewInviteCodeClient(ic.config).UpdateOne(ic)
}

// Unwrap unwraps the InviteCode entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (ic *InviteCode) Unwrap() *InviteCode {
	_tx, ok := ic.config.driver.(*txDriver)
	if !ok {
		panic("db: InviteCode is not a transactional entity")
	}
	ic.config.driver = _tx.drv
	return ic
}

// String implements the fmt.Stringer.
func (ic *InviteCode) String() string {
	var builder strings.Builder
	builder.WriteString("InviteCode(")
	builder.WriteString(fmt.Sprintf("id=%v, ", ic.ID))
	builder.WriteString("admin_id=")
	builder.WriteString(fmt.Sprintf("%v", ic.AdminID))
	builder.WriteString(", ")
	builder.WriteString("code=")
	builder.WriteString(ic.Code)
	builder.WriteString(", ")
	builder.WriteString("status=")
	builder.WriteString(fmt.Sprintf("%v", ic.Status))
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(ic.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(ic.UpdatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("expired_at=")
	builder.WriteString(ic.ExpiredAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// InviteCodes is a parsable slice of InviteCode.
type InviteCodes []*InviteCode
