// Code generated by ent, DO NOT EDIT.

package hook

import (
	"context"
	"fmt"

	"github.com/chaitin/MonkeyCode/backend/db"
)

// The AIEmployeeFunc type is an adapter to allow the use of ordinary
// function as AIEmployee mutator.
type AIEmployeeFunc func(context.Context, *db.AIEmployeeMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f AIEmployeeFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.AIEmployeeMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.AIEmployeeMutation", m)
}

// The AITaskFunc type is an adapter to allow the use of ordinary
// function as AITask mutator.
type AITaskFunc func(context.Context, *db.AITaskMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f AITaskFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.AITaskMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.AITaskMutation", m)
}

// The AdminFunc type is an adapter to allow the use of ordinary
// function as Admin mutator.
type AdminFunc func(context.Context, *db.AdminMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f AdminFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.AdminMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.AdminMutation", m)
}

// The AdminLoginHistoryFunc type is an adapter to allow the use of ordinary
// function as AdminLoginHistory mutator.
type AdminLoginHistoryFunc func(context.Context, *db.AdminLoginHistoryMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f AdminLoginHistoryFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.AdminLoginHistoryMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.AdminLoginHistoryMutation", m)
}

// The AdminRoleFunc type is an adapter to allow the use of ordinary
// function as AdminRole mutator.
type AdminRoleFunc func(context.Context, *db.AdminRoleMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f AdminRoleFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.AdminRoleMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.AdminRoleMutation", m)
}

// The ApiKeyFunc type is an adapter to allow the use of ordinary
// function as ApiKey mutator.
type ApiKeyFunc func(context.Context, *db.ApiKeyMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f ApiKeyFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.ApiKeyMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.ApiKeyMutation", m)
}

// The BillingPlanFunc type is an adapter to allow the use of ordinary
// function as BillingPlan mutator.
type BillingPlanFunc func(context.Context, *db.BillingPlanMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f BillingPlanFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.BillingPlanMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.BillingPlanMutation", m)
}

// The BillingQuotaFunc type is an adapter to allow the use of ordinary
// function as BillingQuota mutator.
type BillingQuotaFunc func(context.Context, *db.BillingQuotaMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f BillingQuotaFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.BillingQuotaMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.BillingQuotaMutation", m)
}

// The BillingRecordFunc type is an adapter to allow the use of ordinary
// function as BillingRecord mutator.
type BillingRecordFunc func(context.Context, *db.BillingRecordMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f BillingRecordFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.BillingRecordMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.BillingRecordMutation", m)
}

// The BillingUsageFunc type is an adapter to allow the use of ordinary
// function as BillingUsage mutator.
type BillingUsageFunc func(context.Context, *db.BillingUsageMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f BillingUsageFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.BillingUsageMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.BillingUsageMutation", m)
}

// The CodeSnippetFunc type is an adapter to allow the use of ordinary
// function as CodeSnippet mutator.
type CodeSnippetFunc func(context.Context, *db.CodeSnippetMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f CodeSnippetFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.CodeSnippetMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.CodeSnippetMutation", m)
}

// The ExtensionFunc type is an adapter to allow the use of ordinary
// function as Extension mutator.
type ExtensionFunc func(context.Context, *db.ExtensionMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f ExtensionFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.ExtensionMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.ExtensionMutation", m)
}

// The InviteCodeFunc type is an adapter to allow the use of ordinary
// function as InviteCode mutator.
type InviteCodeFunc func(context.Context, *db.InviteCodeMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f InviteCodeFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.InviteCodeMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.InviteCodeMutation", m)
}

// The LicenseFunc type is an adapter to allow the use of ordinary
// function as License mutator.
type LicenseFunc func(context.Context, *db.LicenseMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f LicenseFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.LicenseMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.LicenseMutation", m)
}

// The ModelFunc type is an adapter to allow the use of ordinary
// function as Model mutator.
type ModelFunc func(context.Context, *db.ModelMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f ModelFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.ModelMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.ModelMutation", m)
}

// The ModelProviderFunc type is an adapter to allow the use of ordinary
// function as ModelProvider mutator.
type ModelProviderFunc func(context.Context, *db.ModelProviderMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f ModelProviderFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.ModelProviderMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.ModelProviderMutation", m)
}

// The ModelProviderModelFunc type is an adapter to allow the use of ordinary
// function as ModelProviderModel mutator.
type ModelProviderModelFunc func(context.Context, *db.ModelProviderModelMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f ModelProviderModelFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.ModelProviderModelMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.ModelProviderModelMutation", m)
}

// The RoleFunc type is an adapter to allow the use of ordinary
// function as Role mutator.
type RoleFunc func(context.Context, *db.RoleMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f RoleFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.RoleMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.RoleMutation", m)
}

// The SecurityScanningFunc type is an adapter to allow the use of ordinary
// function as SecurityScanning mutator.
type SecurityScanningFunc func(context.Context, *db.SecurityScanningMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f SecurityScanningFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.SecurityScanningMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.SecurityScanningMutation", m)
}

// The SecurityScanningResultFunc type is an adapter to allow the use of ordinary
// function as SecurityScanningResult mutator.
type SecurityScanningResultFunc func(context.Context, *db.SecurityScanningResultMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f SecurityScanningResultFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.SecurityScanningResultMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.SecurityScanningResultMutation", m)
}

// The SettingFunc type is an adapter to allow the use of ordinary
// function as Setting mutator.
type SettingFunc func(context.Context, *db.SettingMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f SettingFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.SettingMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.SettingMutation", m)
}

// The TaskFunc type is an adapter to allow the use of ordinary
// function as Task mutator.
type TaskFunc func(context.Context, *db.TaskMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f TaskFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.TaskMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.TaskMutation", m)
}

// The TaskRecordFunc type is an adapter to allow the use of ordinary
// function as TaskRecord mutator.
type TaskRecordFunc func(context.Context, *db.TaskRecordMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f TaskRecordFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.TaskRecordMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.TaskRecordMutation", m)
}

// The UserFunc type is an adapter to allow the use of ordinary
// function as User mutator.
type UserFunc func(context.Context, *db.UserMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f UserFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.UserMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.UserMutation", m)
}

// The UserGroupFunc type is an adapter to allow the use of ordinary
// function as UserGroup mutator.
type UserGroupFunc func(context.Context, *db.UserGroupMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f UserGroupFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.UserGroupMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.UserGroupMutation", m)
}

// The UserGroupAdminFunc type is an adapter to allow the use of ordinary
// function as UserGroupAdmin mutator.
type UserGroupAdminFunc func(context.Context, *db.UserGroupAdminMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f UserGroupAdminFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.UserGroupAdminMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.UserGroupAdminMutation", m)
}

// The UserGroupUserFunc type is an adapter to allow the use of ordinary
// function as UserGroupUser mutator.
type UserGroupUserFunc func(context.Context, *db.UserGroupUserMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f UserGroupUserFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.UserGroupUserMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.UserGroupUserMutation", m)
}

// The UserIdentityFunc type is an adapter to allow the use of ordinary
// function as UserIdentity mutator.
type UserIdentityFunc func(context.Context, *db.UserIdentityMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f UserIdentityFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.UserIdentityMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.UserIdentityMutation", m)
}

// The UserLoginHistoryFunc type is an adapter to allow the use of ordinary
// function as UserLoginHistory mutator.
type UserLoginHistoryFunc func(context.Context, *db.UserLoginHistoryMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f UserLoginHistoryFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.UserLoginHistoryMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.UserLoginHistoryMutation", m)
}

// The WorkspaceFunc type is an adapter to allow the use of ordinary
// function as Workspace mutator.
type WorkspaceFunc func(context.Context, *db.WorkspaceMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f WorkspaceFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.WorkspaceMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.WorkspaceMutation", m)
}

// The WorkspaceFileFunc type is an adapter to allow the use of ordinary
// function as WorkspaceFile mutator.
type WorkspaceFileFunc func(context.Context, *db.WorkspaceFileMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f WorkspaceFileFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	if mv, ok := m.(*db.WorkspaceFileMutation); ok {
		return f(ctx, mv)
	}
	return nil, fmt.Errorf("unexpected mutation type %T. expect *db.WorkspaceFileMutation", m)
}

// Condition is a hook condition function.
type Condition func(context.Context, db.Mutation) bool

// And groups conditions with the AND operator.
func And(first, second Condition, rest ...Condition) Condition {
	return func(ctx context.Context, m db.Mutation) bool {
		if !first(ctx, m) || !second(ctx, m) {
			return false
		}
		for _, cond := range rest {
			if !cond(ctx, m) {
				return false
			}
		}
		return true
	}
}

// Or groups conditions with the OR operator.
func Or(first, second Condition, rest ...Condition) Condition {
	return func(ctx context.Context, m db.Mutation) bool {
		if first(ctx, m) || second(ctx, m) {
			return true
		}
		for _, cond := range rest {
			if cond(ctx, m) {
				return true
			}
		}
		return false
	}
}

// Not negates a given condition.
func Not(cond Condition) Condition {
	return func(ctx context.Context, m db.Mutation) bool {
		return !cond(ctx, m)
	}
}

// HasOp is a condition testing mutation operation.
func HasOp(op db.Op) Condition {
	return func(_ context.Context, m db.Mutation) bool {
		return m.Op().Is(op)
	}
}

// HasAddedFields is a condition validating `.AddedField` on fields.
func HasAddedFields(field string, fields ...string) Condition {
	return func(_ context.Context, m db.Mutation) bool {
		if _, exists := m.AddedField(field); !exists {
			return false
		}
		for _, field := range fields {
			if _, exists := m.AddedField(field); !exists {
				return false
			}
		}
		return true
	}
}

// HasClearedFields is a condition validating `.FieldCleared` on fields.
func HasClearedFields(field string, fields ...string) Condition {
	return func(_ context.Context, m db.Mutation) bool {
		if exists := m.FieldCleared(field); !exists {
			return false
		}
		for _, field := range fields {
			if exists := m.FieldCleared(field); !exists {
				return false
			}
		}
		return true
	}
}

// HasFields is a condition validating `.Field` on fields.
func HasFields(field string, fields ...string) Condition {
	return func(_ context.Context, m db.Mutation) bool {
		if _, exists := m.Field(field); !exists {
			return false
		}
		for _, field := range fields {
			if _, exists := m.Field(field); !exists {
				return false
			}
		}
		return true
	}
}

// If executes the given hook under condition.
//
//	hook.If(ComputeAverage, And(HasFields(...), HasAddedFields(...)))
func If(hk db.Hook, cond Condition) db.Hook {
	return func(next db.Mutator) db.Mutator {
		return db.MutateFunc(func(ctx context.Context, m db.Mutation) (db.Value, error) {
			if cond(ctx, m) {
				return hk(next).Mutate(ctx, m)
			}
			return next.Mutate(ctx, m)
		})
	}
}

// On executes the given hook only for the given operation.
//
//	hook.On(Log, db.Delete|db.Create)
func On(hk db.Hook, op db.Op) db.Hook {
	return If(hk, HasOp(op))
}

// Unless skips the given hook only for the given operation.
//
//	hook.Unless(Log, db.Update|db.UpdateOne)
func Unless(hk db.Hook, op db.Op) db.Hook {
	return If(hk, Not(HasOp(op)))
}

// FixedError is a hook returning a fixed error.
func FixedError(err error) db.Hook {
	return func(db.Mutator) db.Mutator {
		return db.MutateFunc(func(context.Context, db.Mutation) (db.Value, error) {
			return nil, err
		})
	}
}

// Reject returns a hook that rejects all operations that match op.
//
//	func (T) Hooks() []db.Hook {
//		return []db.Hook{
//			Reject(db.Delete|db.Update),
//		}
//	}
func Reject(op db.Op) db.Hook {
	hk := FixedError(fmt.Errorf("%s operation is not allowed", op))
	return On(hk, op)
}

// Chain acts as a list of hooks and is effectively immutable.
// Once created, it will always hold the same set of hooks in the same order.
type Chain struct {
	hooks []db.Hook
}

// NewChain creates a new chain of hooks.
func NewChain(hooks ...db.Hook) Chain {
	return Chain{append([]db.Hook(nil), hooks...)}
}

// Hook chains the list of hooks and returns the final hook.
func (c Chain) Hook() db.Hook {
	return func(mutator db.Mutator) db.Mutator {
		for i := len(c.hooks) - 1; i >= 0; i-- {
			mutator = c.hooks[i](mutator)
		}
		return mutator
	}
}

// Append extends a chain, adding the specified hook
// as the last ones in the mutation flow.
func (c Chain) Append(hooks ...db.Hook) Chain {
	newHooks := make([]db.Hook, 0, len(c.hooks)+len(hooks))
	newHooks = append(newHooks, c.hooks...)
	newHooks = append(newHooks, hooks...)
	return Chain{newHooks}
}

// Extend extends a chain, adding the specified chain
// as the last ones in the mutation flow.
func (c Chain) Extend(chain Chain) Chain {
	return c.Append(chain.hooks...)
}
