// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/codesnippet"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// CodeSnippetDelete is the builder for deleting a CodeSnippet entity.
type CodeSnippetDelete struct {
	config
	hooks    []Hook
	mutation *CodeSnippetMutation
}

// Where appends a list predicates to the CodeSnippetDelete builder.
func (csd *CodeSnippetDelete) Where(ps ...predicate.CodeSnippet) *CodeSnippetDelete {
	csd.mutation.Where(ps...)
	return csd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (csd *CodeSnippetDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, csd.sqlExec, csd.mutation, csd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (csd *CodeSnippetDelete) ExecX(ctx context.Context) int {
	n, err := csd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (csd *CodeSnippetDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(codesnippet.Table, sqlgraph.NewFieldSpec(codesnippet.FieldID, field.TypeUUID))
	if ps := csd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, csd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	csd.mutation.done = true
	return affected, err
}

// CodeSnippetDeleteOne is the builder for deleting a single CodeSnippet entity.
type CodeSnippetDeleteOne struct {
	csd *CodeSnippetDelete
}

// Where appends a list predicates to the CodeSnippetDelete builder.
func (csdo *CodeSnippetDeleteOne) Where(ps ...predicate.CodeSnippet) *CodeSnippetDeleteOne {
	csdo.csd.mutation.Where(ps...)
	return csdo
}

// Exec executes the deletion query.
func (csdo *CodeSnippetDeleteOne) Exec(ctx context.Context) error {
	n, err := csdo.csd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{codesnippet.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (csdo *CodeSnippetDeleteOne) ExecX(ctx context.Context) {
	if err := csdo.Exec(ctx); err != nil {
		panic(err)
	}
}
