// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/codesnippet"
	"github.com/chaitin/MonkeyCode/backend/db/workspacefile"
	"github.com/google/uuid"
	pgvector "github.com/pgvector/pgvector-go"
)

// CodeSnippetCreate is the builder for creating a CodeSnippet entity.
type CodeSnippetCreate struct {
	config
	mutation *CodeSnippetMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetWorkspaceFileID sets the "workspace_file_id" field.
func (csc *CodeSnippetCreate) SetWorkspaceFileID(u uuid.UUID) *CodeSnippetCreate {
	csc.mutation.SetWorkspaceFileID(u)
	return csc
}

// SetName sets the "name" field.
func (csc *CodeSnippetCreate) SetName(s string) *CodeSnippetCreate {
	csc.mutation.SetName(s)
	return csc
}

// SetSnippetType sets the "snippet_type" field.
func (csc *CodeSnippetCreate) SetSnippetType(s string) *CodeSnippetCreate {
	csc.mutation.SetSnippetType(s)
	return csc
}

// SetLanguage sets the "language" field.
func (csc *CodeSnippetCreate) SetLanguage(s string) *CodeSnippetCreate {
	csc.mutation.SetLanguage(s)
	return csc
}

// SetContent sets the "content" field.
func (csc *CodeSnippetCreate) SetContent(s string) *CodeSnippetCreate {
	csc.mutation.SetContent(s)
	return csc
}

// SetHash sets the "hash" field.
func (csc *CodeSnippetCreate) SetHash(s string) *CodeSnippetCreate {
	csc.mutation.SetHash(s)
	return csc
}

// SetStartLine sets the "start_line" field.
func (csc *CodeSnippetCreate) SetStartLine(i int) *CodeSnippetCreate {
	csc.mutation.SetStartLine(i)
	return csc
}

// SetEndLine sets the "end_line" field.
func (csc *CodeSnippetCreate) SetEndLine(i int) *CodeSnippetCreate {
	csc.mutation.SetEndLine(i)
	return csc
}

// SetStartColumn sets the "start_column" field.
func (csc *CodeSnippetCreate) SetStartColumn(i int) *CodeSnippetCreate {
	csc.mutation.SetStartColumn(i)
	return csc
}

// SetEndColumn sets the "end_column" field.
func (csc *CodeSnippetCreate) SetEndColumn(i int) *CodeSnippetCreate {
	csc.mutation.SetEndColumn(i)
	return csc
}

// SetNamespace sets the "namespace" field.
func (csc *CodeSnippetCreate) SetNamespace(s string) *CodeSnippetCreate {
	csc.mutation.SetNamespace(s)
	return csc
}

// SetNillableNamespace sets the "namespace" field if the given value is not nil.
func (csc *CodeSnippetCreate) SetNillableNamespace(s *string) *CodeSnippetCreate {
	if s != nil {
		csc.SetNamespace(*s)
	}
	return csc
}

// SetContainerName sets the "container_name" field.
func (csc *CodeSnippetCreate) SetContainerName(s string) *CodeSnippetCreate {
	csc.mutation.SetContainerName(s)
	return csc
}

// SetNillableContainerName sets the "container_name" field if the given value is not nil.
func (csc *CodeSnippetCreate) SetNillableContainerName(s *string) *CodeSnippetCreate {
	if s != nil {
		csc.SetContainerName(*s)
	}
	return csc
}

// SetScope sets the "scope" field.
func (csc *CodeSnippetCreate) SetScope(s []string) *CodeSnippetCreate {
	csc.mutation.SetScope(s)
	return csc
}

// SetDependencies sets the "dependencies" field.
func (csc *CodeSnippetCreate) SetDependencies(s []string) *CodeSnippetCreate {
	csc.mutation.SetDependencies(s)
	return csc
}

// SetParameters sets the "parameters" field.
func (csc *CodeSnippetCreate) SetParameters(m []map[string]interface{}) *CodeSnippetCreate {
	csc.mutation.SetParameters(m)
	return csc
}

// SetSignature sets the "signature" field.
func (csc *CodeSnippetCreate) SetSignature(s string) *CodeSnippetCreate {
	csc.mutation.SetSignature(s)
	return csc
}

// SetNillableSignature sets the "signature" field if the given value is not nil.
func (csc *CodeSnippetCreate) SetNillableSignature(s *string) *CodeSnippetCreate {
	if s != nil {
		csc.SetSignature(*s)
	}
	return csc
}

// SetDefinitionText sets the "definition_text" field.
func (csc *CodeSnippetCreate) SetDefinitionText(s string) *CodeSnippetCreate {
	csc.mutation.SetDefinitionText(s)
	return csc
}

// SetNillableDefinitionText sets the "definition_text" field if the given value is not nil.
func (csc *CodeSnippetCreate) SetNillableDefinitionText(s *string) *CodeSnippetCreate {
	if s != nil {
		csc.SetDefinitionText(*s)
	}
	return csc
}

// SetStructuredInfo sets the "structured_info" field.
func (csc *CodeSnippetCreate) SetStructuredInfo(m map[string]interface{}) *CodeSnippetCreate {
	csc.mutation.SetStructuredInfo(m)
	return csc
}

// SetEmbedding sets the "embedding" field.
func (csc *CodeSnippetCreate) SetEmbedding(pg pgvector.Vector) *CodeSnippetCreate {
	csc.mutation.SetEmbedding(pg)
	return csc
}

// SetNillableEmbedding sets the "embedding" field if the given value is not nil.
func (csc *CodeSnippetCreate) SetNillableEmbedding(pg *pgvector.Vector) *CodeSnippetCreate {
	if pg != nil {
		csc.SetEmbedding(*pg)
	}
	return csc
}

// SetWorkspacePath sets the "workspacePath" field.
func (csc *CodeSnippetCreate) SetWorkspacePath(s string) *CodeSnippetCreate {
	csc.mutation.SetWorkspacePath(s)
	return csc
}

// SetNillableWorkspacePath sets the "workspacePath" field if the given value is not nil.
func (csc *CodeSnippetCreate) SetNillableWorkspacePath(s *string) *CodeSnippetCreate {
	if s != nil {
		csc.SetWorkspacePath(*s)
	}
	return csc
}

// SetID sets the "id" field.
func (csc *CodeSnippetCreate) SetID(u uuid.UUID) *CodeSnippetCreate {
	csc.mutation.SetID(u)
	return csc
}

// SetSourceFileID sets the "source_file" edge to the WorkspaceFile entity by ID.
func (csc *CodeSnippetCreate) SetSourceFileID(id uuid.UUID) *CodeSnippetCreate {
	csc.mutation.SetSourceFileID(id)
	return csc
}

// SetSourceFile sets the "source_file" edge to the WorkspaceFile entity.
func (csc *CodeSnippetCreate) SetSourceFile(w *WorkspaceFile) *CodeSnippetCreate {
	return csc.SetSourceFileID(w.ID)
}

// Mutation returns the CodeSnippetMutation object of the builder.
func (csc *CodeSnippetCreate) Mutation() *CodeSnippetMutation {
	return csc.mutation
}

// Save creates the CodeSnippet in the database.
func (csc *CodeSnippetCreate) Save(ctx context.Context) (*CodeSnippet, error) {
	return withHooks(ctx, csc.sqlSave, csc.mutation, csc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (csc *CodeSnippetCreate) SaveX(ctx context.Context) *CodeSnippet {
	v, err := csc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (csc *CodeSnippetCreate) Exec(ctx context.Context) error {
	_, err := csc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (csc *CodeSnippetCreate) ExecX(ctx context.Context) {
	if err := csc.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (csc *CodeSnippetCreate) check() error {
	if _, ok := csc.mutation.WorkspaceFileID(); !ok {
		return &ValidationError{Name: "workspace_file_id", err: errors.New(`db: missing required field "CodeSnippet.workspace_file_id"`)}
	}
	if _, ok := csc.mutation.Name(); !ok {
		return &ValidationError{Name: "name", err: errors.New(`db: missing required field "CodeSnippet.name"`)}
	}
	if _, ok := csc.mutation.SnippetType(); !ok {
		return &ValidationError{Name: "snippet_type", err: errors.New(`db: missing required field "CodeSnippet.snippet_type"`)}
	}
	if _, ok := csc.mutation.Language(); !ok {
		return &ValidationError{Name: "language", err: errors.New(`db: missing required field "CodeSnippet.language"`)}
	}
	if _, ok := csc.mutation.Content(); !ok {
		return &ValidationError{Name: "content", err: errors.New(`db: missing required field "CodeSnippet.content"`)}
	}
	if _, ok := csc.mutation.Hash(); !ok {
		return &ValidationError{Name: "hash", err: errors.New(`db: missing required field "CodeSnippet.hash"`)}
	}
	if _, ok := csc.mutation.StartLine(); !ok {
		return &ValidationError{Name: "start_line", err: errors.New(`db: missing required field "CodeSnippet.start_line"`)}
	}
	if _, ok := csc.mutation.EndLine(); !ok {
		return &ValidationError{Name: "end_line", err: errors.New(`db: missing required field "CodeSnippet.end_line"`)}
	}
	if _, ok := csc.mutation.StartColumn(); !ok {
		return &ValidationError{Name: "start_column", err: errors.New(`db: missing required field "CodeSnippet.start_column"`)}
	}
	if _, ok := csc.mutation.EndColumn(); !ok {
		return &ValidationError{Name: "end_column", err: errors.New(`db: missing required field "CodeSnippet.end_column"`)}
	}
	if len(csc.mutation.SourceFileIDs()) == 0 {
		return &ValidationError{Name: "source_file", err: errors.New(`db: missing required edge "CodeSnippet.source_file"`)}
	}
	return nil
}

func (csc *CodeSnippetCreate) sqlSave(ctx context.Context) (*CodeSnippet, error) {
	if err := csc.check(); err != nil {
		return nil, err
	}
	_node, _spec := csc.createSpec()
	if err := sqlgraph.CreateNode(ctx, csc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	csc.mutation.id = &_node.ID
	csc.mutation.done = true
	return _node, nil
}

func (csc *CodeSnippetCreate) createSpec() (*CodeSnippet, *sqlgraph.CreateSpec) {
	var (
		_node = &CodeSnippet{config: csc.config}
		_spec = sqlgraph.NewCreateSpec(codesnippet.Table, sqlgraph.NewFieldSpec(codesnippet.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = csc.conflict
	if id, ok := csc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := csc.mutation.Name(); ok {
		_spec.SetField(codesnippet.FieldName, field.TypeString, value)
		_node.Name = value
	}
	if value, ok := csc.mutation.SnippetType(); ok {
		_spec.SetField(codesnippet.FieldSnippetType, field.TypeString, value)
		_node.SnippetType = value
	}
	if value, ok := csc.mutation.Language(); ok {
		_spec.SetField(codesnippet.FieldLanguage, field.TypeString, value)
		_node.Language = value
	}
	if value, ok := csc.mutation.Content(); ok {
		_spec.SetField(codesnippet.FieldContent, field.TypeString, value)
		_node.Content = value
	}
	if value, ok := csc.mutation.Hash(); ok {
		_spec.SetField(codesnippet.FieldHash, field.TypeString, value)
		_node.Hash = value
	}
	if value, ok := csc.mutation.StartLine(); ok {
		_spec.SetField(codesnippet.FieldStartLine, field.TypeInt, value)
		_node.StartLine = value
	}
	if value, ok := csc.mutation.EndLine(); ok {
		_spec.SetField(codesnippet.FieldEndLine, field.TypeInt, value)
		_node.EndLine = value
	}
	if value, ok := csc.mutation.StartColumn(); ok {
		_spec.SetField(codesnippet.FieldStartColumn, field.TypeInt, value)
		_node.StartColumn = value
	}
	if value, ok := csc.mutation.EndColumn(); ok {
		_spec.SetField(codesnippet.FieldEndColumn, field.TypeInt, value)
		_node.EndColumn = value
	}
	if value, ok := csc.mutation.Namespace(); ok {
		_spec.SetField(codesnippet.FieldNamespace, field.TypeString, value)
		_node.Namespace = value
	}
	if value, ok := csc.mutation.ContainerName(); ok {
		_spec.SetField(codesnippet.FieldContainerName, field.TypeString, value)
		_node.ContainerName = value
	}
	if value, ok := csc.mutation.Scope(); ok {
		_spec.SetField(codesnippet.FieldScope, field.TypeJSON, value)
		_node.Scope = value
	}
	if value, ok := csc.mutation.Dependencies(); ok {
		_spec.SetField(codesnippet.FieldDependencies, field.TypeJSON, value)
		_node.Dependencies = value
	}
	if value, ok := csc.mutation.Parameters(); ok {
		_spec.SetField(codesnippet.FieldParameters, field.TypeJSON, value)
		_node.Parameters = value
	}
	if value, ok := csc.mutation.Signature(); ok {
		_spec.SetField(codesnippet.FieldSignature, field.TypeString, value)
		_node.Signature = value
	}
	if value, ok := csc.mutation.DefinitionText(); ok {
		_spec.SetField(codesnippet.FieldDefinitionText, field.TypeString, value)
		_node.DefinitionText = value
	}
	if value, ok := csc.mutation.StructuredInfo(); ok {
		_spec.SetField(codesnippet.FieldStructuredInfo, field.TypeJSON, value)
		_node.StructuredInfo = value
	}
	if value, ok := csc.mutation.Embedding(); ok {
		_spec.SetField(codesnippet.FieldEmbedding, field.TypeOther, value)
		_node.Embedding = value
	}
	if value, ok := csc.mutation.WorkspacePath(); ok {
		_spec.SetField(codesnippet.FieldWorkspacePath, field.TypeString, value)
		_node.WorkspacePath = value
	}
	if nodes := csc.mutation.SourceFileIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   codesnippet.SourceFileTable,
			Columns: []string{codesnippet.SourceFileColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.WorkspaceFileID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.CodeSnippet.Create().
//		SetWorkspaceFileID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.CodeSnippetUpsert) {
//			SetWorkspaceFileID(v+v).
//		}).
//		Exec(ctx)
func (csc *CodeSnippetCreate) OnConflict(opts ...sql.ConflictOption) *CodeSnippetUpsertOne {
	csc.conflict = opts
	return &CodeSnippetUpsertOne{
		create: csc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.CodeSnippet.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (csc *CodeSnippetCreate) OnConflictColumns(columns ...string) *CodeSnippetUpsertOne {
	csc.conflict = append(csc.conflict, sql.ConflictColumns(columns...))
	return &CodeSnippetUpsertOne{
		create: csc,
	}
}

type (
	// CodeSnippetUpsertOne is the builder for "upsert"-ing
	//  one CodeSnippet node.
	CodeSnippetUpsertOne struct {
		create *CodeSnippetCreate
	}

	// CodeSnippetUpsert is the "OnConflict" setter.
	CodeSnippetUpsert struct {
		*sql.UpdateSet
	}
)

// SetWorkspaceFileID sets the "workspace_file_id" field.
func (u *CodeSnippetUpsert) SetWorkspaceFileID(v uuid.UUID) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldWorkspaceFileID, v)
	return u
}

// UpdateWorkspaceFileID sets the "workspace_file_id" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateWorkspaceFileID() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldWorkspaceFileID)
	return u
}

// SetName sets the "name" field.
func (u *CodeSnippetUpsert) SetName(v string) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldName, v)
	return u
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateName() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldName)
	return u
}

// SetSnippetType sets the "snippet_type" field.
func (u *CodeSnippetUpsert) SetSnippetType(v string) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldSnippetType, v)
	return u
}

// UpdateSnippetType sets the "snippet_type" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateSnippetType() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldSnippetType)
	return u
}

// SetLanguage sets the "language" field.
func (u *CodeSnippetUpsert) SetLanguage(v string) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldLanguage, v)
	return u
}

// UpdateLanguage sets the "language" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateLanguage() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldLanguage)
	return u
}

// SetContent sets the "content" field.
func (u *CodeSnippetUpsert) SetContent(v string) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldContent, v)
	return u
}

// UpdateContent sets the "content" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateContent() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldContent)
	return u
}

// SetHash sets the "hash" field.
func (u *CodeSnippetUpsert) SetHash(v string) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldHash, v)
	return u
}

// UpdateHash sets the "hash" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateHash() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldHash)
	return u
}

// SetStartLine sets the "start_line" field.
func (u *CodeSnippetUpsert) SetStartLine(v int) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldStartLine, v)
	return u
}

// UpdateStartLine sets the "start_line" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateStartLine() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldStartLine)
	return u
}

// AddStartLine adds v to the "start_line" field.
func (u *CodeSnippetUpsert) AddStartLine(v int) *CodeSnippetUpsert {
	u.Add(codesnippet.FieldStartLine, v)
	return u
}

// SetEndLine sets the "end_line" field.
func (u *CodeSnippetUpsert) SetEndLine(v int) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldEndLine, v)
	return u
}

// UpdateEndLine sets the "end_line" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateEndLine() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldEndLine)
	return u
}

// AddEndLine adds v to the "end_line" field.
func (u *CodeSnippetUpsert) AddEndLine(v int) *CodeSnippetUpsert {
	u.Add(codesnippet.FieldEndLine, v)
	return u
}

// SetStartColumn sets the "start_column" field.
func (u *CodeSnippetUpsert) SetStartColumn(v int) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldStartColumn, v)
	return u
}

// UpdateStartColumn sets the "start_column" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateStartColumn() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldStartColumn)
	return u
}

// AddStartColumn adds v to the "start_column" field.
func (u *CodeSnippetUpsert) AddStartColumn(v int) *CodeSnippetUpsert {
	u.Add(codesnippet.FieldStartColumn, v)
	return u
}

// SetEndColumn sets the "end_column" field.
func (u *CodeSnippetUpsert) SetEndColumn(v int) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldEndColumn, v)
	return u
}

// UpdateEndColumn sets the "end_column" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateEndColumn() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldEndColumn)
	return u
}

// AddEndColumn adds v to the "end_column" field.
func (u *CodeSnippetUpsert) AddEndColumn(v int) *CodeSnippetUpsert {
	u.Add(codesnippet.FieldEndColumn, v)
	return u
}

// SetNamespace sets the "namespace" field.
func (u *CodeSnippetUpsert) SetNamespace(v string) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldNamespace, v)
	return u
}

// UpdateNamespace sets the "namespace" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateNamespace() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldNamespace)
	return u
}

// ClearNamespace clears the value of the "namespace" field.
func (u *CodeSnippetUpsert) ClearNamespace() *CodeSnippetUpsert {
	u.SetNull(codesnippet.FieldNamespace)
	return u
}

// SetContainerName sets the "container_name" field.
func (u *CodeSnippetUpsert) SetContainerName(v string) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldContainerName, v)
	return u
}

// UpdateContainerName sets the "container_name" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateContainerName() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldContainerName)
	return u
}

// ClearContainerName clears the value of the "container_name" field.
func (u *CodeSnippetUpsert) ClearContainerName() *CodeSnippetUpsert {
	u.SetNull(codesnippet.FieldContainerName)
	return u
}

// SetScope sets the "scope" field.
func (u *CodeSnippetUpsert) SetScope(v []string) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldScope, v)
	return u
}

// UpdateScope sets the "scope" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateScope() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldScope)
	return u
}

// ClearScope clears the value of the "scope" field.
func (u *CodeSnippetUpsert) ClearScope() *CodeSnippetUpsert {
	u.SetNull(codesnippet.FieldScope)
	return u
}

// SetDependencies sets the "dependencies" field.
func (u *CodeSnippetUpsert) SetDependencies(v []string) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldDependencies, v)
	return u
}

// UpdateDependencies sets the "dependencies" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateDependencies() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldDependencies)
	return u
}

// ClearDependencies clears the value of the "dependencies" field.
func (u *CodeSnippetUpsert) ClearDependencies() *CodeSnippetUpsert {
	u.SetNull(codesnippet.FieldDependencies)
	return u
}

// SetParameters sets the "parameters" field.
func (u *CodeSnippetUpsert) SetParameters(v []map[string]interface{}) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldParameters, v)
	return u
}

// UpdateParameters sets the "parameters" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateParameters() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldParameters)
	return u
}

// ClearParameters clears the value of the "parameters" field.
func (u *CodeSnippetUpsert) ClearParameters() *CodeSnippetUpsert {
	u.SetNull(codesnippet.FieldParameters)
	return u
}

// SetSignature sets the "signature" field.
func (u *CodeSnippetUpsert) SetSignature(v string) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldSignature, v)
	return u
}

// UpdateSignature sets the "signature" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateSignature() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldSignature)
	return u
}

// ClearSignature clears the value of the "signature" field.
func (u *CodeSnippetUpsert) ClearSignature() *CodeSnippetUpsert {
	u.SetNull(codesnippet.FieldSignature)
	return u
}

// SetDefinitionText sets the "definition_text" field.
func (u *CodeSnippetUpsert) SetDefinitionText(v string) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldDefinitionText, v)
	return u
}

// UpdateDefinitionText sets the "definition_text" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateDefinitionText() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldDefinitionText)
	return u
}

// ClearDefinitionText clears the value of the "definition_text" field.
func (u *CodeSnippetUpsert) ClearDefinitionText() *CodeSnippetUpsert {
	u.SetNull(codesnippet.FieldDefinitionText)
	return u
}

// SetStructuredInfo sets the "structured_info" field.
func (u *CodeSnippetUpsert) SetStructuredInfo(v map[string]interface{}) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldStructuredInfo, v)
	return u
}

// UpdateStructuredInfo sets the "structured_info" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateStructuredInfo() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldStructuredInfo)
	return u
}

// ClearStructuredInfo clears the value of the "structured_info" field.
func (u *CodeSnippetUpsert) ClearStructuredInfo() *CodeSnippetUpsert {
	u.SetNull(codesnippet.FieldStructuredInfo)
	return u
}

// SetEmbedding sets the "embedding" field.
func (u *CodeSnippetUpsert) SetEmbedding(v pgvector.Vector) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldEmbedding, v)
	return u
}

// UpdateEmbedding sets the "embedding" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateEmbedding() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldEmbedding)
	return u
}

// ClearEmbedding clears the value of the "embedding" field.
func (u *CodeSnippetUpsert) ClearEmbedding() *CodeSnippetUpsert {
	u.SetNull(codesnippet.FieldEmbedding)
	return u
}

// SetWorkspacePath sets the "workspacePath" field.
func (u *CodeSnippetUpsert) SetWorkspacePath(v string) *CodeSnippetUpsert {
	u.Set(codesnippet.FieldWorkspacePath, v)
	return u
}

// UpdateWorkspacePath sets the "workspacePath" field to the value that was provided on create.
func (u *CodeSnippetUpsert) UpdateWorkspacePath() *CodeSnippetUpsert {
	u.SetExcluded(codesnippet.FieldWorkspacePath)
	return u
}

// ClearWorkspacePath clears the value of the "workspacePath" field.
func (u *CodeSnippetUpsert) ClearWorkspacePath() *CodeSnippetUpsert {
	u.SetNull(codesnippet.FieldWorkspacePath)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.CodeSnippet.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(codesnippet.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *CodeSnippetUpsertOne) UpdateNewValues() *CodeSnippetUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(codesnippet.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.CodeSnippet.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *CodeSnippetUpsertOne) Ignore() *CodeSnippetUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *CodeSnippetUpsertOne) DoNothing() *CodeSnippetUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the CodeSnippetCreate.OnConflict
// documentation for more info.
func (u *CodeSnippetUpsertOne) Update(set func(*CodeSnippetUpsert)) *CodeSnippetUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&CodeSnippetUpsert{UpdateSet: update})
	}))
	return u
}

// SetWorkspaceFileID sets the "workspace_file_id" field.
func (u *CodeSnippetUpsertOne) SetWorkspaceFileID(v uuid.UUID) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetWorkspaceFileID(v)
	})
}

// UpdateWorkspaceFileID sets the "workspace_file_id" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateWorkspaceFileID() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateWorkspaceFileID()
	})
}

// SetName sets the "name" field.
func (u *CodeSnippetUpsertOne) SetName(v string) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateName() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateName()
	})
}

// SetSnippetType sets the "snippet_type" field.
func (u *CodeSnippetUpsertOne) SetSnippetType(v string) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetSnippetType(v)
	})
}

// UpdateSnippetType sets the "snippet_type" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateSnippetType() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateSnippetType()
	})
}

// SetLanguage sets the "language" field.
func (u *CodeSnippetUpsertOne) SetLanguage(v string) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetLanguage(v)
	})
}

// UpdateLanguage sets the "language" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateLanguage() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateLanguage()
	})
}

// SetContent sets the "content" field.
func (u *CodeSnippetUpsertOne) SetContent(v string) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetContent(v)
	})
}

// UpdateContent sets the "content" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateContent() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateContent()
	})
}

// SetHash sets the "hash" field.
func (u *CodeSnippetUpsertOne) SetHash(v string) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetHash(v)
	})
}

// UpdateHash sets the "hash" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateHash() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateHash()
	})
}

// SetStartLine sets the "start_line" field.
func (u *CodeSnippetUpsertOne) SetStartLine(v int) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetStartLine(v)
	})
}

// AddStartLine adds v to the "start_line" field.
func (u *CodeSnippetUpsertOne) AddStartLine(v int) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.AddStartLine(v)
	})
}

// UpdateStartLine sets the "start_line" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateStartLine() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateStartLine()
	})
}

// SetEndLine sets the "end_line" field.
func (u *CodeSnippetUpsertOne) SetEndLine(v int) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetEndLine(v)
	})
}

// AddEndLine adds v to the "end_line" field.
func (u *CodeSnippetUpsertOne) AddEndLine(v int) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.AddEndLine(v)
	})
}

// UpdateEndLine sets the "end_line" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateEndLine() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateEndLine()
	})
}

// SetStartColumn sets the "start_column" field.
func (u *CodeSnippetUpsertOne) SetStartColumn(v int) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetStartColumn(v)
	})
}

// AddStartColumn adds v to the "start_column" field.
func (u *CodeSnippetUpsertOne) AddStartColumn(v int) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.AddStartColumn(v)
	})
}

// UpdateStartColumn sets the "start_column" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateStartColumn() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateStartColumn()
	})
}

// SetEndColumn sets the "end_column" field.
func (u *CodeSnippetUpsertOne) SetEndColumn(v int) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetEndColumn(v)
	})
}

// AddEndColumn adds v to the "end_column" field.
func (u *CodeSnippetUpsertOne) AddEndColumn(v int) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.AddEndColumn(v)
	})
}

// UpdateEndColumn sets the "end_column" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateEndColumn() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateEndColumn()
	})
}

// SetNamespace sets the "namespace" field.
func (u *CodeSnippetUpsertOne) SetNamespace(v string) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetNamespace(v)
	})
}

// UpdateNamespace sets the "namespace" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateNamespace() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateNamespace()
	})
}

// ClearNamespace clears the value of the "namespace" field.
func (u *CodeSnippetUpsertOne) ClearNamespace() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearNamespace()
	})
}

// SetContainerName sets the "container_name" field.
func (u *CodeSnippetUpsertOne) SetContainerName(v string) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetContainerName(v)
	})
}

// UpdateContainerName sets the "container_name" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateContainerName() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateContainerName()
	})
}

// ClearContainerName clears the value of the "container_name" field.
func (u *CodeSnippetUpsertOne) ClearContainerName() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearContainerName()
	})
}

// SetScope sets the "scope" field.
func (u *CodeSnippetUpsertOne) SetScope(v []string) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetScope(v)
	})
}

// UpdateScope sets the "scope" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateScope() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateScope()
	})
}

// ClearScope clears the value of the "scope" field.
func (u *CodeSnippetUpsertOne) ClearScope() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearScope()
	})
}

// SetDependencies sets the "dependencies" field.
func (u *CodeSnippetUpsertOne) SetDependencies(v []string) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetDependencies(v)
	})
}

// UpdateDependencies sets the "dependencies" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateDependencies() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateDependencies()
	})
}

// ClearDependencies clears the value of the "dependencies" field.
func (u *CodeSnippetUpsertOne) ClearDependencies() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearDependencies()
	})
}

// SetParameters sets the "parameters" field.
func (u *CodeSnippetUpsertOne) SetParameters(v []map[string]interface{}) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetParameters(v)
	})
}

// UpdateParameters sets the "parameters" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateParameters() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateParameters()
	})
}

// ClearParameters clears the value of the "parameters" field.
func (u *CodeSnippetUpsertOne) ClearParameters() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearParameters()
	})
}

// SetSignature sets the "signature" field.
func (u *CodeSnippetUpsertOne) SetSignature(v string) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetSignature(v)
	})
}

// UpdateSignature sets the "signature" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateSignature() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateSignature()
	})
}

// ClearSignature clears the value of the "signature" field.
func (u *CodeSnippetUpsertOne) ClearSignature() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearSignature()
	})
}

// SetDefinitionText sets the "definition_text" field.
func (u *CodeSnippetUpsertOne) SetDefinitionText(v string) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetDefinitionText(v)
	})
}

// UpdateDefinitionText sets the "definition_text" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateDefinitionText() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateDefinitionText()
	})
}

// ClearDefinitionText clears the value of the "definition_text" field.
func (u *CodeSnippetUpsertOne) ClearDefinitionText() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearDefinitionText()
	})
}

// SetStructuredInfo sets the "structured_info" field.
func (u *CodeSnippetUpsertOne) SetStructuredInfo(v map[string]interface{}) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetStructuredInfo(v)
	})
}

// UpdateStructuredInfo sets the "structured_info" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateStructuredInfo() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateStructuredInfo()
	})
}

// ClearStructuredInfo clears the value of the "structured_info" field.
func (u *CodeSnippetUpsertOne) ClearStructuredInfo() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearStructuredInfo()
	})
}

// SetEmbedding sets the "embedding" field.
func (u *CodeSnippetUpsertOne) SetEmbedding(v pgvector.Vector) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetEmbedding(v)
	})
}

// UpdateEmbedding sets the "embedding" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateEmbedding() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateEmbedding()
	})
}

// ClearEmbedding clears the value of the "embedding" field.
func (u *CodeSnippetUpsertOne) ClearEmbedding() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearEmbedding()
	})
}

// SetWorkspacePath sets the "workspacePath" field.
func (u *CodeSnippetUpsertOne) SetWorkspacePath(v string) *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetWorkspacePath(v)
	})
}

// UpdateWorkspacePath sets the "workspacePath" field to the value that was provided on create.
func (u *CodeSnippetUpsertOne) UpdateWorkspacePath() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateWorkspacePath()
	})
}

// ClearWorkspacePath clears the value of the "workspacePath" field.
func (u *CodeSnippetUpsertOne) ClearWorkspacePath() *CodeSnippetUpsertOne {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearWorkspacePath()
	})
}

// Exec executes the query.
func (u *CodeSnippetUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for CodeSnippetCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *CodeSnippetUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *CodeSnippetUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: CodeSnippetUpsertOne.ID is not supported by MySQL driver. Use CodeSnippetUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *CodeSnippetUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// CodeSnippetCreateBulk is the builder for creating many CodeSnippet entities in bulk.
type CodeSnippetCreateBulk struct {
	config
	err      error
	builders []*CodeSnippetCreate
	conflict []sql.ConflictOption
}

// Save creates the CodeSnippet entities in the database.
func (cscb *CodeSnippetCreateBulk) Save(ctx context.Context) ([]*CodeSnippet, error) {
	if cscb.err != nil {
		return nil, cscb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(cscb.builders))
	nodes := make([]*CodeSnippet, len(cscb.builders))
	mutators := make([]Mutator, len(cscb.builders))
	for i := range cscb.builders {
		func(i int, root context.Context) {
			builder := cscb.builders[i]
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*CodeSnippetMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, cscb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = cscb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, cscb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, cscb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (cscb *CodeSnippetCreateBulk) SaveX(ctx context.Context) []*CodeSnippet {
	v, err := cscb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (cscb *CodeSnippetCreateBulk) Exec(ctx context.Context) error {
	_, err := cscb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (cscb *CodeSnippetCreateBulk) ExecX(ctx context.Context) {
	if err := cscb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.CodeSnippet.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.CodeSnippetUpsert) {
//			SetWorkspaceFileID(v+v).
//		}).
//		Exec(ctx)
func (cscb *CodeSnippetCreateBulk) OnConflict(opts ...sql.ConflictOption) *CodeSnippetUpsertBulk {
	cscb.conflict = opts
	return &CodeSnippetUpsertBulk{
		create: cscb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.CodeSnippet.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (cscb *CodeSnippetCreateBulk) OnConflictColumns(columns ...string) *CodeSnippetUpsertBulk {
	cscb.conflict = append(cscb.conflict, sql.ConflictColumns(columns...))
	return &CodeSnippetUpsertBulk{
		create: cscb,
	}
}

// CodeSnippetUpsertBulk is the builder for "upsert"-ing
// a bulk of CodeSnippet nodes.
type CodeSnippetUpsertBulk struct {
	create *CodeSnippetCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.CodeSnippet.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(codesnippet.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *CodeSnippetUpsertBulk) UpdateNewValues() *CodeSnippetUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(codesnippet.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.CodeSnippet.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *CodeSnippetUpsertBulk) Ignore() *CodeSnippetUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *CodeSnippetUpsertBulk) DoNothing() *CodeSnippetUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the CodeSnippetCreateBulk.OnConflict
// documentation for more info.
func (u *CodeSnippetUpsertBulk) Update(set func(*CodeSnippetUpsert)) *CodeSnippetUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&CodeSnippetUpsert{UpdateSet: update})
	}))
	return u
}

// SetWorkspaceFileID sets the "workspace_file_id" field.
func (u *CodeSnippetUpsertBulk) SetWorkspaceFileID(v uuid.UUID) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetWorkspaceFileID(v)
	})
}

// UpdateWorkspaceFileID sets the "workspace_file_id" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateWorkspaceFileID() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateWorkspaceFileID()
	})
}

// SetName sets the "name" field.
func (u *CodeSnippetUpsertBulk) SetName(v string) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateName() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateName()
	})
}

// SetSnippetType sets the "snippet_type" field.
func (u *CodeSnippetUpsertBulk) SetSnippetType(v string) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetSnippetType(v)
	})
}

// UpdateSnippetType sets the "snippet_type" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateSnippetType() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateSnippetType()
	})
}

// SetLanguage sets the "language" field.
func (u *CodeSnippetUpsertBulk) SetLanguage(v string) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetLanguage(v)
	})
}

// UpdateLanguage sets the "language" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateLanguage() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateLanguage()
	})
}

// SetContent sets the "content" field.
func (u *CodeSnippetUpsertBulk) SetContent(v string) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetContent(v)
	})
}

// UpdateContent sets the "content" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateContent() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateContent()
	})
}

// SetHash sets the "hash" field.
func (u *CodeSnippetUpsertBulk) SetHash(v string) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetHash(v)
	})
}

// UpdateHash sets the "hash" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateHash() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateHash()
	})
}

// SetStartLine sets the "start_line" field.
func (u *CodeSnippetUpsertBulk) SetStartLine(v int) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetStartLine(v)
	})
}

// AddStartLine adds v to the "start_line" field.
func (u *CodeSnippetUpsertBulk) AddStartLine(v int) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.AddStartLine(v)
	})
}

// UpdateStartLine sets the "start_line" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateStartLine() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateStartLine()
	})
}

// SetEndLine sets the "end_line" field.
func (u *CodeSnippetUpsertBulk) SetEndLine(v int) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetEndLine(v)
	})
}

// AddEndLine adds v to the "end_line" field.
func (u *CodeSnippetUpsertBulk) AddEndLine(v int) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.AddEndLine(v)
	})
}

// UpdateEndLine sets the "end_line" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateEndLine() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateEndLine()
	})
}

// SetStartColumn sets the "start_column" field.
func (u *CodeSnippetUpsertBulk) SetStartColumn(v int) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetStartColumn(v)
	})
}

// AddStartColumn adds v to the "start_column" field.
func (u *CodeSnippetUpsertBulk) AddStartColumn(v int) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.AddStartColumn(v)
	})
}

// UpdateStartColumn sets the "start_column" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateStartColumn() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateStartColumn()
	})
}

// SetEndColumn sets the "end_column" field.
func (u *CodeSnippetUpsertBulk) SetEndColumn(v int) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetEndColumn(v)
	})
}

// AddEndColumn adds v to the "end_column" field.
func (u *CodeSnippetUpsertBulk) AddEndColumn(v int) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.AddEndColumn(v)
	})
}

// UpdateEndColumn sets the "end_column" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateEndColumn() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateEndColumn()
	})
}

// SetNamespace sets the "namespace" field.
func (u *CodeSnippetUpsertBulk) SetNamespace(v string) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetNamespace(v)
	})
}

// UpdateNamespace sets the "namespace" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateNamespace() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateNamespace()
	})
}

// ClearNamespace clears the value of the "namespace" field.
func (u *CodeSnippetUpsertBulk) ClearNamespace() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearNamespace()
	})
}

// SetContainerName sets the "container_name" field.
func (u *CodeSnippetUpsertBulk) SetContainerName(v string) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetContainerName(v)
	})
}

// UpdateContainerName sets the "container_name" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateContainerName() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateContainerName()
	})
}

// ClearContainerName clears the value of the "container_name" field.
func (u *CodeSnippetUpsertBulk) ClearContainerName() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearContainerName()
	})
}

// SetScope sets the "scope" field.
func (u *CodeSnippetUpsertBulk) SetScope(v []string) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetScope(v)
	})
}

// UpdateScope sets the "scope" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateScope() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateScope()
	})
}

// ClearScope clears the value of the "scope" field.
func (u *CodeSnippetUpsertBulk) ClearScope() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearScope()
	})
}

// SetDependencies sets the "dependencies" field.
func (u *CodeSnippetUpsertBulk) SetDependencies(v []string) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetDependencies(v)
	})
}

// UpdateDependencies sets the "dependencies" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateDependencies() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateDependencies()
	})
}

// ClearDependencies clears the value of the "dependencies" field.
func (u *CodeSnippetUpsertBulk) ClearDependencies() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearDependencies()
	})
}

// SetParameters sets the "parameters" field.
func (u *CodeSnippetUpsertBulk) SetParameters(v []map[string]interface{}) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetParameters(v)
	})
}

// UpdateParameters sets the "parameters" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateParameters() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateParameters()
	})
}

// ClearParameters clears the value of the "parameters" field.
func (u *CodeSnippetUpsertBulk) ClearParameters() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearParameters()
	})
}

// SetSignature sets the "signature" field.
func (u *CodeSnippetUpsertBulk) SetSignature(v string) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetSignature(v)
	})
}

// UpdateSignature sets the "signature" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateSignature() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateSignature()
	})
}

// ClearSignature clears the value of the "signature" field.
func (u *CodeSnippetUpsertBulk) ClearSignature() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearSignature()
	})
}

// SetDefinitionText sets the "definition_text" field.
func (u *CodeSnippetUpsertBulk) SetDefinitionText(v string) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetDefinitionText(v)
	})
}

// UpdateDefinitionText sets the "definition_text" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateDefinitionText() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateDefinitionText()
	})
}

// ClearDefinitionText clears the value of the "definition_text" field.
func (u *CodeSnippetUpsertBulk) ClearDefinitionText() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearDefinitionText()
	})
}

// SetStructuredInfo sets the "structured_info" field.
func (u *CodeSnippetUpsertBulk) SetStructuredInfo(v map[string]interface{}) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetStructuredInfo(v)
	})
}

// UpdateStructuredInfo sets the "structured_info" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateStructuredInfo() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateStructuredInfo()
	})
}

// ClearStructuredInfo clears the value of the "structured_info" field.
func (u *CodeSnippetUpsertBulk) ClearStructuredInfo() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearStructuredInfo()
	})
}

// SetEmbedding sets the "embedding" field.
func (u *CodeSnippetUpsertBulk) SetEmbedding(v pgvector.Vector) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetEmbedding(v)
	})
}

// UpdateEmbedding sets the "embedding" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateEmbedding() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateEmbedding()
	})
}

// ClearEmbedding clears the value of the "embedding" field.
func (u *CodeSnippetUpsertBulk) ClearEmbedding() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearEmbedding()
	})
}

// SetWorkspacePath sets the "workspacePath" field.
func (u *CodeSnippetUpsertBulk) SetWorkspacePath(v string) *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.SetWorkspacePath(v)
	})
}

// UpdateWorkspacePath sets the "workspacePath" field to the value that was provided on create.
func (u *CodeSnippetUpsertBulk) UpdateWorkspacePath() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.UpdateWorkspacePath()
	})
}

// ClearWorkspacePath clears the value of the "workspacePath" field.
func (u *CodeSnippetUpsertBulk) ClearWorkspacePath() *CodeSnippetUpsertBulk {
	return u.Update(func(s *CodeSnippetUpsert) {
		s.ClearWorkspacePath()
	})
}

// Exec executes the query.
func (u *CodeSnippetUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the CodeSnippetCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for CodeSnippetCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *CodeSnippetUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
