// Code generated by ent, DO NOT EDIT.

package codesnippet

import (
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/google/uuid"
	pgvector "github.com/pgvector/pgvector-go"
)

// ID filters vertices based on their ID field.
func ID(id uuid.UUID) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldID, id))
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id uuid.UUID) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldID, id))
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id uuid.UUID) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldID, id))
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...uuid.UUID) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldID, ids...))
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...uuid.UUID) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldID, ids...))
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id uuid.UUID) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldID, id))
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id uuid.UUID) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldID, id))
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id uuid.UUID) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldID, id))
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id uuid.UUID) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldID, id))
}

// WorkspaceFileID applies equality check predicate on the "workspace_file_id" field. It's identical to WorkspaceFileIDEQ.
func WorkspaceFileID(v uuid.UUID) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldWorkspaceFileID, v))
}

// Name applies equality check predicate on the "name" field. It's identical to NameEQ.
func Name(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldName, v))
}

// SnippetType applies equality check predicate on the "snippet_type" field. It's identical to SnippetTypeEQ.
func SnippetType(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldSnippetType, v))
}

// Language applies equality check predicate on the "language" field. It's identical to LanguageEQ.
func Language(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldLanguage, v))
}

// Content applies equality check predicate on the "content" field. It's identical to ContentEQ.
func Content(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldContent, v))
}

// Hash applies equality check predicate on the "hash" field. It's identical to HashEQ.
func Hash(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldHash, v))
}

// StartLine applies equality check predicate on the "start_line" field. It's identical to StartLineEQ.
func StartLine(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldStartLine, v))
}

// EndLine applies equality check predicate on the "end_line" field. It's identical to EndLineEQ.
func EndLine(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldEndLine, v))
}

// StartColumn applies equality check predicate on the "start_column" field. It's identical to StartColumnEQ.
func StartColumn(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldStartColumn, v))
}

// EndColumn applies equality check predicate on the "end_column" field. It's identical to EndColumnEQ.
func EndColumn(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldEndColumn, v))
}

// Namespace applies equality check predicate on the "namespace" field. It's identical to NamespaceEQ.
func Namespace(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldNamespace, v))
}

// ContainerName applies equality check predicate on the "container_name" field. It's identical to ContainerNameEQ.
func ContainerName(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldContainerName, v))
}

// Signature applies equality check predicate on the "signature" field. It's identical to SignatureEQ.
func Signature(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldSignature, v))
}

// DefinitionText applies equality check predicate on the "definition_text" field. It's identical to DefinitionTextEQ.
func DefinitionText(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldDefinitionText, v))
}

// Embedding applies equality check predicate on the "embedding" field. It's identical to EmbeddingEQ.
func Embedding(v pgvector.Vector) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldEmbedding, v))
}

// WorkspacePath applies equality check predicate on the "workspacePath" field. It's identical to WorkspacePathEQ.
func WorkspacePath(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldWorkspacePath, v))
}

// WorkspaceFileIDEQ applies the EQ predicate on the "workspace_file_id" field.
func WorkspaceFileIDEQ(v uuid.UUID) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldWorkspaceFileID, v))
}

// WorkspaceFileIDNEQ applies the NEQ predicate on the "workspace_file_id" field.
func WorkspaceFileIDNEQ(v uuid.UUID) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldWorkspaceFileID, v))
}

// WorkspaceFileIDIn applies the In predicate on the "workspace_file_id" field.
func WorkspaceFileIDIn(vs ...uuid.UUID) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldWorkspaceFileID, vs...))
}

// WorkspaceFileIDNotIn applies the NotIn predicate on the "workspace_file_id" field.
func WorkspaceFileIDNotIn(vs ...uuid.UUID) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldWorkspaceFileID, vs...))
}

// NameEQ applies the EQ predicate on the "name" field.
func NameEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldName, v))
}

// NameNEQ applies the NEQ predicate on the "name" field.
func NameNEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldName, v))
}

// NameIn applies the In predicate on the "name" field.
func NameIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldName, vs...))
}

// NameNotIn applies the NotIn predicate on the "name" field.
func NameNotIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldName, vs...))
}

// NameGT applies the GT predicate on the "name" field.
func NameGT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldName, v))
}

// NameGTE applies the GTE predicate on the "name" field.
func NameGTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldName, v))
}

// NameLT applies the LT predicate on the "name" field.
func NameLT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldName, v))
}

// NameLTE applies the LTE predicate on the "name" field.
func NameLTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldName, v))
}

// NameContains applies the Contains predicate on the "name" field.
func NameContains(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContains(FieldName, v))
}

// NameHasPrefix applies the HasPrefix predicate on the "name" field.
func NameHasPrefix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasPrefix(FieldName, v))
}

// NameHasSuffix applies the HasSuffix predicate on the "name" field.
func NameHasSuffix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasSuffix(FieldName, v))
}

// NameEqualFold applies the EqualFold predicate on the "name" field.
func NameEqualFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEqualFold(FieldName, v))
}

// NameContainsFold applies the ContainsFold predicate on the "name" field.
func NameContainsFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContainsFold(FieldName, v))
}

// SnippetTypeEQ applies the EQ predicate on the "snippet_type" field.
func SnippetTypeEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldSnippetType, v))
}

// SnippetTypeNEQ applies the NEQ predicate on the "snippet_type" field.
func SnippetTypeNEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldSnippetType, v))
}

// SnippetTypeIn applies the In predicate on the "snippet_type" field.
func SnippetTypeIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldSnippetType, vs...))
}

// SnippetTypeNotIn applies the NotIn predicate on the "snippet_type" field.
func SnippetTypeNotIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldSnippetType, vs...))
}

// SnippetTypeGT applies the GT predicate on the "snippet_type" field.
func SnippetTypeGT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldSnippetType, v))
}

// SnippetTypeGTE applies the GTE predicate on the "snippet_type" field.
func SnippetTypeGTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldSnippetType, v))
}

// SnippetTypeLT applies the LT predicate on the "snippet_type" field.
func SnippetTypeLT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldSnippetType, v))
}

// SnippetTypeLTE applies the LTE predicate on the "snippet_type" field.
func SnippetTypeLTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldSnippetType, v))
}

// SnippetTypeContains applies the Contains predicate on the "snippet_type" field.
func SnippetTypeContains(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContains(FieldSnippetType, v))
}

// SnippetTypeHasPrefix applies the HasPrefix predicate on the "snippet_type" field.
func SnippetTypeHasPrefix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasPrefix(FieldSnippetType, v))
}

// SnippetTypeHasSuffix applies the HasSuffix predicate on the "snippet_type" field.
func SnippetTypeHasSuffix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasSuffix(FieldSnippetType, v))
}

// SnippetTypeEqualFold applies the EqualFold predicate on the "snippet_type" field.
func SnippetTypeEqualFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEqualFold(FieldSnippetType, v))
}

// SnippetTypeContainsFold applies the ContainsFold predicate on the "snippet_type" field.
func SnippetTypeContainsFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContainsFold(FieldSnippetType, v))
}

// LanguageEQ applies the EQ predicate on the "language" field.
func LanguageEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldLanguage, v))
}

// LanguageNEQ applies the NEQ predicate on the "language" field.
func LanguageNEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldLanguage, v))
}

// LanguageIn applies the In predicate on the "language" field.
func LanguageIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldLanguage, vs...))
}

// LanguageNotIn applies the NotIn predicate on the "language" field.
func LanguageNotIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldLanguage, vs...))
}

// LanguageGT applies the GT predicate on the "language" field.
func LanguageGT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldLanguage, v))
}

// LanguageGTE applies the GTE predicate on the "language" field.
func LanguageGTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldLanguage, v))
}

// LanguageLT applies the LT predicate on the "language" field.
func LanguageLT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldLanguage, v))
}

// LanguageLTE applies the LTE predicate on the "language" field.
func LanguageLTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldLanguage, v))
}

// LanguageContains applies the Contains predicate on the "language" field.
func LanguageContains(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContains(FieldLanguage, v))
}

// LanguageHasPrefix applies the HasPrefix predicate on the "language" field.
func LanguageHasPrefix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasPrefix(FieldLanguage, v))
}

// LanguageHasSuffix applies the HasSuffix predicate on the "language" field.
func LanguageHasSuffix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasSuffix(FieldLanguage, v))
}

// LanguageEqualFold applies the EqualFold predicate on the "language" field.
func LanguageEqualFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEqualFold(FieldLanguage, v))
}

// LanguageContainsFold applies the ContainsFold predicate on the "language" field.
func LanguageContainsFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContainsFold(FieldLanguage, v))
}

// ContentEQ applies the EQ predicate on the "content" field.
func ContentEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldContent, v))
}

// ContentNEQ applies the NEQ predicate on the "content" field.
func ContentNEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldContent, v))
}

// ContentIn applies the In predicate on the "content" field.
func ContentIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldContent, vs...))
}

// ContentNotIn applies the NotIn predicate on the "content" field.
func ContentNotIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldContent, vs...))
}

// ContentGT applies the GT predicate on the "content" field.
func ContentGT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldContent, v))
}

// ContentGTE applies the GTE predicate on the "content" field.
func ContentGTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldContent, v))
}

// ContentLT applies the LT predicate on the "content" field.
func ContentLT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldContent, v))
}

// ContentLTE applies the LTE predicate on the "content" field.
func ContentLTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldContent, v))
}

// ContentContains applies the Contains predicate on the "content" field.
func ContentContains(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContains(FieldContent, v))
}

// ContentHasPrefix applies the HasPrefix predicate on the "content" field.
func ContentHasPrefix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasPrefix(FieldContent, v))
}

// ContentHasSuffix applies the HasSuffix predicate on the "content" field.
func ContentHasSuffix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasSuffix(FieldContent, v))
}

// ContentEqualFold applies the EqualFold predicate on the "content" field.
func ContentEqualFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEqualFold(FieldContent, v))
}

// ContentContainsFold applies the ContainsFold predicate on the "content" field.
func ContentContainsFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContainsFold(FieldContent, v))
}

// HashEQ applies the EQ predicate on the "hash" field.
func HashEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldHash, v))
}

// HashNEQ applies the NEQ predicate on the "hash" field.
func HashNEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldHash, v))
}

// HashIn applies the In predicate on the "hash" field.
func HashIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldHash, vs...))
}

// HashNotIn applies the NotIn predicate on the "hash" field.
func HashNotIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldHash, vs...))
}

// HashGT applies the GT predicate on the "hash" field.
func HashGT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldHash, v))
}

// HashGTE applies the GTE predicate on the "hash" field.
func HashGTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldHash, v))
}

// HashLT applies the LT predicate on the "hash" field.
func HashLT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldHash, v))
}

// HashLTE applies the LTE predicate on the "hash" field.
func HashLTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldHash, v))
}

// HashContains applies the Contains predicate on the "hash" field.
func HashContains(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContains(FieldHash, v))
}

// HashHasPrefix applies the HasPrefix predicate on the "hash" field.
func HashHasPrefix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasPrefix(FieldHash, v))
}

// HashHasSuffix applies the HasSuffix predicate on the "hash" field.
func HashHasSuffix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasSuffix(FieldHash, v))
}

// HashEqualFold applies the EqualFold predicate on the "hash" field.
func HashEqualFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEqualFold(FieldHash, v))
}

// HashContainsFold applies the ContainsFold predicate on the "hash" field.
func HashContainsFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContainsFold(FieldHash, v))
}

// StartLineEQ applies the EQ predicate on the "start_line" field.
func StartLineEQ(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldStartLine, v))
}

// StartLineNEQ applies the NEQ predicate on the "start_line" field.
func StartLineNEQ(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldStartLine, v))
}

// StartLineIn applies the In predicate on the "start_line" field.
func StartLineIn(vs ...int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldStartLine, vs...))
}

// StartLineNotIn applies the NotIn predicate on the "start_line" field.
func StartLineNotIn(vs ...int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldStartLine, vs...))
}

// StartLineGT applies the GT predicate on the "start_line" field.
func StartLineGT(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldStartLine, v))
}

// StartLineGTE applies the GTE predicate on the "start_line" field.
func StartLineGTE(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldStartLine, v))
}

// StartLineLT applies the LT predicate on the "start_line" field.
func StartLineLT(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldStartLine, v))
}

// StartLineLTE applies the LTE predicate on the "start_line" field.
func StartLineLTE(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldStartLine, v))
}

// EndLineEQ applies the EQ predicate on the "end_line" field.
func EndLineEQ(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldEndLine, v))
}

// EndLineNEQ applies the NEQ predicate on the "end_line" field.
func EndLineNEQ(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldEndLine, v))
}

// EndLineIn applies the In predicate on the "end_line" field.
func EndLineIn(vs ...int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldEndLine, vs...))
}

// EndLineNotIn applies the NotIn predicate on the "end_line" field.
func EndLineNotIn(vs ...int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldEndLine, vs...))
}

// EndLineGT applies the GT predicate on the "end_line" field.
func EndLineGT(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldEndLine, v))
}

// EndLineGTE applies the GTE predicate on the "end_line" field.
func EndLineGTE(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldEndLine, v))
}

// EndLineLT applies the LT predicate on the "end_line" field.
func EndLineLT(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldEndLine, v))
}

// EndLineLTE applies the LTE predicate on the "end_line" field.
func EndLineLTE(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldEndLine, v))
}

// StartColumnEQ applies the EQ predicate on the "start_column" field.
func StartColumnEQ(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldStartColumn, v))
}

// StartColumnNEQ applies the NEQ predicate on the "start_column" field.
func StartColumnNEQ(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldStartColumn, v))
}

// StartColumnIn applies the In predicate on the "start_column" field.
func StartColumnIn(vs ...int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldStartColumn, vs...))
}

// StartColumnNotIn applies the NotIn predicate on the "start_column" field.
func StartColumnNotIn(vs ...int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldStartColumn, vs...))
}

// StartColumnGT applies the GT predicate on the "start_column" field.
func StartColumnGT(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldStartColumn, v))
}

// StartColumnGTE applies the GTE predicate on the "start_column" field.
func StartColumnGTE(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldStartColumn, v))
}

// StartColumnLT applies the LT predicate on the "start_column" field.
func StartColumnLT(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldStartColumn, v))
}

// StartColumnLTE applies the LTE predicate on the "start_column" field.
func StartColumnLTE(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldStartColumn, v))
}

// EndColumnEQ applies the EQ predicate on the "end_column" field.
func EndColumnEQ(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldEndColumn, v))
}

// EndColumnNEQ applies the NEQ predicate on the "end_column" field.
func EndColumnNEQ(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldEndColumn, v))
}

// EndColumnIn applies the In predicate on the "end_column" field.
func EndColumnIn(vs ...int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldEndColumn, vs...))
}

// EndColumnNotIn applies the NotIn predicate on the "end_column" field.
func EndColumnNotIn(vs ...int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldEndColumn, vs...))
}

// EndColumnGT applies the GT predicate on the "end_column" field.
func EndColumnGT(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldEndColumn, v))
}

// EndColumnGTE applies the GTE predicate on the "end_column" field.
func EndColumnGTE(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldEndColumn, v))
}

// EndColumnLT applies the LT predicate on the "end_column" field.
func EndColumnLT(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldEndColumn, v))
}

// EndColumnLTE applies the LTE predicate on the "end_column" field.
func EndColumnLTE(v int) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldEndColumn, v))
}

// NamespaceEQ applies the EQ predicate on the "namespace" field.
func NamespaceEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldNamespace, v))
}

// NamespaceNEQ applies the NEQ predicate on the "namespace" field.
func NamespaceNEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldNamespace, v))
}

// NamespaceIn applies the In predicate on the "namespace" field.
func NamespaceIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldNamespace, vs...))
}

// NamespaceNotIn applies the NotIn predicate on the "namespace" field.
func NamespaceNotIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldNamespace, vs...))
}

// NamespaceGT applies the GT predicate on the "namespace" field.
func NamespaceGT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldNamespace, v))
}

// NamespaceGTE applies the GTE predicate on the "namespace" field.
func NamespaceGTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldNamespace, v))
}

// NamespaceLT applies the LT predicate on the "namespace" field.
func NamespaceLT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldNamespace, v))
}

// NamespaceLTE applies the LTE predicate on the "namespace" field.
func NamespaceLTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldNamespace, v))
}

// NamespaceContains applies the Contains predicate on the "namespace" field.
func NamespaceContains(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContains(FieldNamespace, v))
}

// NamespaceHasPrefix applies the HasPrefix predicate on the "namespace" field.
func NamespaceHasPrefix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasPrefix(FieldNamespace, v))
}

// NamespaceHasSuffix applies the HasSuffix predicate on the "namespace" field.
func NamespaceHasSuffix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasSuffix(FieldNamespace, v))
}

// NamespaceIsNil applies the IsNil predicate on the "namespace" field.
func NamespaceIsNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIsNull(FieldNamespace))
}

// NamespaceNotNil applies the NotNil predicate on the "namespace" field.
func NamespaceNotNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotNull(FieldNamespace))
}

// NamespaceEqualFold applies the EqualFold predicate on the "namespace" field.
func NamespaceEqualFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEqualFold(FieldNamespace, v))
}

// NamespaceContainsFold applies the ContainsFold predicate on the "namespace" field.
func NamespaceContainsFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContainsFold(FieldNamespace, v))
}

// ContainerNameEQ applies the EQ predicate on the "container_name" field.
func ContainerNameEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldContainerName, v))
}

// ContainerNameNEQ applies the NEQ predicate on the "container_name" field.
func ContainerNameNEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldContainerName, v))
}

// ContainerNameIn applies the In predicate on the "container_name" field.
func ContainerNameIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldContainerName, vs...))
}

// ContainerNameNotIn applies the NotIn predicate on the "container_name" field.
func ContainerNameNotIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldContainerName, vs...))
}

// ContainerNameGT applies the GT predicate on the "container_name" field.
func ContainerNameGT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldContainerName, v))
}

// ContainerNameGTE applies the GTE predicate on the "container_name" field.
func ContainerNameGTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldContainerName, v))
}

// ContainerNameLT applies the LT predicate on the "container_name" field.
func ContainerNameLT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldContainerName, v))
}

// ContainerNameLTE applies the LTE predicate on the "container_name" field.
func ContainerNameLTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldContainerName, v))
}

// ContainerNameContains applies the Contains predicate on the "container_name" field.
func ContainerNameContains(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContains(FieldContainerName, v))
}

// ContainerNameHasPrefix applies the HasPrefix predicate on the "container_name" field.
func ContainerNameHasPrefix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasPrefix(FieldContainerName, v))
}

// ContainerNameHasSuffix applies the HasSuffix predicate on the "container_name" field.
func ContainerNameHasSuffix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasSuffix(FieldContainerName, v))
}

// ContainerNameIsNil applies the IsNil predicate on the "container_name" field.
func ContainerNameIsNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIsNull(FieldContainerName))
}

// ContainerNameNotNil applies the NotNil predicate on the "container_name" field.
func ContainerNameNotNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotNull(FieldContainerName))
}

// ContainerNameEqualFold applies the EqualFold predicate on the "container_name" field.
func ContainerNameEqualFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEqualFold(FieldContainerName, v))
}

// ContainerNameContainsFold applies the ContainsFold predicate on the "container_name" field.
func ContainerNameContainsFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContainsFold(FieldContainerName, v))
}

// ScopeIsNil applies the IsNil predicate on the "scope" field.
func ScopeIsNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIsNull(FieldScope))
}

// ScopeNotNil applies the NotNil predicate on the "scope" field.
func ScopeNotNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotNull(FieldScope))
}

// DependenciesIsNil applies the IsNil predicate on the "dependencies" field.
func DependenciesIsNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIsNull(FieldDependencies))
}

// DependenciesNotNil applies the NotNil predicate on the "dependencies" field.
func DependenciesNotNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotNull(FieldDependencies))
}

// ParametersIsNil applies the IsNil predicate on the "parameters" field.
func ParametersIsNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIsNull(FieldParameters))
}

// ParametersNotNil applies the NotNil predicate on the "parameters" field.
func ParametersNotNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotNull(FieldParameters))
}

// SignatureEQ applies the EQ predicate on the "signature" field.
func SignatureEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldSignature, v))
}

// SignatureNEQ applies the NEQ predicate on the "signature" field.
func SignatureNEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldSignature, v))
}

// SignatureIn applies the In predicate on the "signature" field.
func SignatureIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldSignature, vs...))
}

// SignatureNotIn applies the NotIn predicate on the "signature" field.
func SignatureNotIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldSignature, vs...))
}

// SignatureGT applies the GT predicate on the "signature" field.
func SignatureGT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldSignature, v))
}

// SignatureGTE applies the GTE predicate on the "signature" field.
func SignatureGTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldSignature, v))
}

// SignatureLT applies the LT predicate on the "signature" field.
func SignatureLT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldSignature, v))
}

// SignatureLTE applies the LTE predicate on the "signature" field.
func SignatureLTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldSignature, v))
}

// SignatureContains applies the Contains predicate on the "signature" field.
func SignatureContains(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContains(FieldSignature, v))
}

// SignatureHasPrefix applies the HasPrefix predicate on the "signature" field.
func SignatureHasPrefix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasPrefix(FieldSignature, v))
}

// SignatureHasSuffix applies the HasSuffix predicate on the "signature" field.
func SignatureHasSuffix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasSuffix(FieldSignature, v))
}

// SignatureIsNil applies the IsNil predicate on the "signature" field.
func SignatureIsNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIsNull(FieldSignature))
}

// SignatureNotNil applies the NotNil predicate on the "signature" field.
func SignatureNotNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotNull(FieldSignature))
}

// SignatureEqualFold applies the EqualFold predicate on the "signature" field.
func SignatureEqualFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEqualFold(FieldSignature, v))
}

// SignatureContainsFold applies the ContainsFold predicate on the "signature" field.
func SignatureContainsFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContainsFold(FieldSignature, v))
}

// DefinitionTextEQ applies the EQ predicate on the "definition_text" field.
func DefinitionTextEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldDefinitionText, v))
}

// DefinitionTextNEQ applies the NEQ predicate on the "definition_text" field.
func DefinitionTextNEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldDefinitionText, v))
}

// DefinitionTextIn applies the In predicate on the "definition_text" field.
func DefinitionTextIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldDefinitionText, vs...))
}

// DefinitionTextNotIn applies the NotIn predicate on the "definition_text" field.
func DefinitionTextNotIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldDefinitionText, vs...))
}

// DefinitionTextGT applies the GT predicate on the "definition_text" field.
func DefinitionTextGT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldDefinitionText, v))
}

// DefinitionTextGTE applies the GTE predicate on the "definition_text" field.
func DefinitionTextGTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldDefinitionText, v))
}

// DefinitionTextLT applies the LT predicate on the "definition_text" field.
func DefinitionTextLT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldDefinitionText, v))
}

// DefinitionTextLTE applies the LTE predicate on the "definition_text" field.
func DefinitionTextLTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldDefinitionText, v))
}

// DefinitionTextContains applies the Contains predicate on the "definition_text" field.
func DefinitionTextContains(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContains(FieldDefinitionText, v))
}

// DefinitionTextHasPrefix applies the HasPrefix predicate on the "definition_text" field.
func DefinitionTextHasPrefix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasPrefix(FieldDefinitionText, v))
}

// DefinitionTextHasSuffix applies the HasSuffix predicate on the "definition_text" field.
func DefinitionTextHasSuffix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasSuffix(FieldDefinitionText, v))
}

// DefinitionTextIsNil applies the IsNil predicate on the "definition_text" field.
func DefinitionTextIsNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIsNull(FieldDefinitionText))
}

// DefinitionTextNotNil applies the NotNil predicate on the "definition_text" field.
func DefinitionTextNotNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotNull(FieldDefinitionText))
}

// DefinitionTextEqualFold applies the EqualFold predicate on the "definition_text" field.
func DefinitionTextEqualFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEqualFold(FieldDefinitionText, v))
}

// DefinitionTextContainsFold applies the ContainsFold predicate on the "definition_text" field.
func DefinitionTextContainsFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContainsFold(FieldDefinitionText, v))
}

// StructuredInfoIsNil applies the IsNil predicate on the "structured_info" field.
func StructuredInfoIsNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIsNull(FieldStructuredInfo))
}

// StructuredInfoNotNil applies the NotNil predicate on the "structured_info" field.
func StructuredInfoNotNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotNull(FieldStructuredInfo))
}

// EmbeddingEQ applies the EQ predicate on the "embedding" field.
func EmbeddingEQ(v pgvector.Vector) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldEmbedding, v))
}

// EmbeddingNEQ applies the NEQ predicate on the "embedding" field.
func EmbeddingNEQ(v pgvector.Vector) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldEmbedding, v))
}

// EmbeddingIn applies the In predicate on the "embedding" field.
func EmbeddingIn(vs ...pgvector.Vector) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldEmbedding, vs...))
}

// EmbeddingNotIn applies the NotIn predicate on the "embedding" field.
func EmbeddingNotIn(vs ...pgvector.Vector) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldEmbedding, vs...))
}

// EmbeddingGT applies the GT predicate on the "embedding" field.
func EmbeddingGT(v pgvector.Vector) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldEmbedding, v))
}

// EmbeddingGTE applies the GTE predicate on the "embedding" field.
func EmbeddingGTE(v pgvector.Vector) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldEmbedding, v))
}

// EmbeddingLT applies the LT predicate on the "embedding" field.
func EmbeddingLT(v pgvector.Vector) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldEmbedding, v))
}

// EmbeddingLTE applies the LTE predicate on the "embedding" field.
func EmbeddingLTE(v pgvector.Vector) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldEmbedding, v))
}

// EmbeddingIsNil applies the IsNil predicate on the "embedding" field.
func EmbeddingIsNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIsNull(FieldEmbedding))
}

// EmbeddingNotNil applies the NotNil predicate on the "embedding" field.
func EmbeddingNotNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotNull(FieldEmbedding))
}

// WorkspacePathEQ applies the EQ predicate on the "workspacePath" field.
func WorkspacePathEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEQ(FieldWorkspacePath, v))
}

// WorkspacePathNEQ applies the NEQ predicate on the "workspacePath" field.
func WorkspacePathNEQ(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNEQ(FieldWorkspacePath, v))
}

// WorkspacePathIn applies the In predicate on the "workspacePath" field.
func WorkspacePathIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIn(FieldWorkspacePath, vs...))
}

// WorkspacePathNotIn applies the NotIn predicate on the "workspacePath" field.
func WorkspacePathNotIn(vs ...string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotIn(FieldWorkspacePath, vs...))
}

// WorkspacePathGT applies the GT predicate on the "workspacePath" field.
func WorkspacePathGT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGT(FieldWorkspacePath, v))
}

// WorkspacePathGTE applies the GTE predicate on the "workspacePath" field.
func WorkspacePathGTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldGTE(FieldWorkspacePath, v))
}

// WorkspacePathLT applies the LT predicate on the "workspacePath" field.
func WorkspacePathLT(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLT(FieldWorkspacePath, v))
}

// WorkspacePathLTE applies the LTE predicate on the "workspacePath" field.
func WorkspacePathLTE(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldLTE(FieldWorkspacePath, v))
}

// WorkspacePathContains applies the Contains predicate on the "workspacePath" field.
func WorkspacePathContains(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContains(FieldWorkspacePath, v))
}

// WorkspacePathHasPrefix applies the HasPrefix predicate on the "workspacePath" field.
func WorkspacePathHasPrefix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasPrefix(FieldWorkspacePath, v))
}

// WorkspacePathHasSuffix applies the HasSuffix predicate on the "workspacePath" field.
func WorkspacePathHasSuffix(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldHasSuffix(FieldWorkspacePath, v))
}

// WorkspacePathIsNil applies the IsNil predicate on the "workspacePath" field.
func WorkspacePathIsNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldIsNull(FieldWorkspacePath))
}

// WorkspacePathNotNil applies the NotNil predicate on the "workspacePath" field.
func WorkspacePathNotNil() predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldNotNull(FieldWorkspacePath))
}

// WorkspacePathEqualFold applies the EqualFold predicate on the "workspacePath" field.
func WorkspacePathEqualFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldEqualFold(FieldWorkspacePath, v))
}

// WorkspacePathContainsFold applies the ContainsFold predicate on the "workspacePath" field.
func WorkspacePathContainsFold(v string) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.FieldContainsFold(FieldWorkspacePath, v))
}

// HasSourceFile applies the HasEdge predicate on the "source_file" edge.
func HasSourceFile() predicate.CodeSnippet {
	return predicate.CodeSnippet(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, SourceFileTable, SourceFileColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasSourceFileWith applies the HasEdge predicate on the "source_file" edge with a given conditions (other predicates).
func HasSourceFileWith(preds ...predicate.WorkspaceFile) predicate.CodeSnippet {
	return predicate.CodeSnippet(func(s *sql.Selector) {
		step := newSourceFileStep()
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.CodeSnippet) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.AndPredicates(predicates...))
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.CodeSnippet) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.OrPredicates(predicates...))
}

// Not applies the not operator on the given predicate.
func Not(p predicate.CodeSnippet) predicate.CodeSnippet {
	return predicate.CodeSnippet(sql.NotPredicates(p))
}
