// Code generated by ent, DO NOT EDIT.

package codesnippet

import (
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the codesnippet type in the database.
	Label = "code_snippet"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldWorkspaceFileID holds the string denoting the workspace_file_id field in the database.
	FieldWorkspaceFileID = "workspace_file_id"
	// FieldName holds the string denoting the name field in the database.
	FieldName = "name"
	// FieldSnippetType holds the string denoting the snippet_type field in the database.
	FieldSnippetType = "snippet_type"
	// FieldLanguage holds the string denoting the language field in the database.
	FieldLanguage = "language"
	// FieldContent holds the string denoting the content field in the database.
	FieldContent = "content"
	// FieldHash holds the string denoting the hash field in the database.
	FieldHash = "hash"
	// FieldStartLine holds the string denoting the start_line field in the database.
	FieldStartLine = "start_line"
	// FieldEndLine holds the string denoting the end_line field in the database.
	FieldEndLine = "end_line"
	// FieldStartColumn holds the string denoting the start_column field in the database.
	FieldStartColumn = "start_column"
	// FieldEndColumn holds the string denoting the end_column field in the database.
	FieldEndColumn = "end_column"
	// FieldNamespace holds the string denoting the namespace field in the database.
	FieldNamespace = "namespace"
	// FieldContainerName holds the string denoting the container_name field in the database.
	FieldContainerName = "container_name"
	// FieldScope holds the string denoting the scope field in the database.
	FieldScope = "scope"
	// FieldDependencies holds the string denoting the dependencies field in the database.
	FieldDependencies = "dependencies"
	// FieldParameters holds the string denoting the parameters field in the database.
	FieldParameters = "parameters"
	// FieldSignature holds the string denoting the signature field in the database.
	FieldSignature = "signature"
	// FieldDefinitionText holds the string denoting the definition_text field in the database.
	FieldDefinitionText = "definition_text"
	// FieldStructuredInfo holds the string denoting the structured_info field in the database.
	FieldStructuredInfo = "structured_info"
	// FieldEmbedding holds the string denoting the embedding field in the database.
	FieldEmbedding = "embedding"
	// FieldWorkspacePath holds the string denoting the workspacepath field in the database.
	FieldWorkspacePath = "workspace_path"
	// EdgeSourceFile holds the string denoting the source_file edge name in mutations.
	EdgeSourceFile = "source_file"
	// Table holds the table name of the codesnippet in the database.
	Table = "code_snippets"
	// SourceFileTable is the table that holds the source_file relation/edge.
	SourceFileTable = "code_snippets"
	// SourceFileInverseTable is the table name for the WorkspaceFile entity.
	// It exists in this package in order to avoid circular dependency with the "workspacefile" package.
	SourceFileInverseTable = "workspace_files"
	// SourceFileColumn is the table column denoting the source_file relation/edge.
	SourceFileColumn = "workspace_file_id"
)

// Columns holds all SQL columns for codesnippet fields.
var Columns = []string{
	FieldID,
	FieldWorkspaceFileID,
	FieldName,
	FieldSnippetType,
	FieldLanguage,
	FieldContent,
	FieldHash,
	FieldStartLine,
	FieldEndLine,
	FieldStartColumn,
	FieldEndColumn,
	FieldNamespace,
	FieldContainerName,
	FieldScope,
	FieldDependencies,
	FieldParameters,
	FieldSignature,
	FieldDefinitionText,
	FieldStructuredInfo,
	FieldEmbedding,
	FieldWorkspacePath,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

// OrderOption defines the ordering options for the CodeSnippet queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByWorkspaceFileID orders the results by the workspace_file_id field.
func ByWorkspaceFileID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldWorkspaceFileID, opts...).ToFunc()
}

// ByName orders the results by the name field.
func ByName(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldName, opts...).ToFunc()
}

// BySnippetType orders the results by the snippet_type field.
func BySnippetType(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSnippetType, opts...).ToFunc()
}

// ByLanguage orders the results by the language field.
func ByLanguage(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldLanguage, opts...).ToFunc()
}

// ByContent orders the results by the content field.
func ByContent(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldContent, opts...).ToFunc()
}

// ByHash orders the results by the hash field.
func ByHash(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldHash, opts...).ToFunc()
}

// ByStartLine orders the results by the start_line field.
func ByStartLine(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldStartLine, opts...).ToFunc()
}

// ByEndLine orders the results by the end_line field.
func ByEndLine(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldEndLine, opts...).ToFunc()
}

// ByStartColumn orders the results by the start_column field.
func ByStartColumn(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldStartColumn, opts...).ToFunc()
}

// ByEndColumn orders the results by the end_column field.
func ByEndColumn(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldEndColumn, opts...).ToFunc()
}

// ByNamespace orders the results by the namespace field.
func ByNamespace(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldNamespace, opts...).ToFunc()
}

// ByContainerName orders the results by the container_name field.
func ByContainerName(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldContainerName, opts...).ToFunc()
}

// BySignature orders the results by the signature field.
func BySignature(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSignature, opts...).ToFunc()
}

// ByDefinitionText orders the results by the definition_text field.
func ByDefinitionText(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldDefinitionText, opts...).ToFunc()
}

// ByEmbedding orders the results by the embedding field.
func ByEmbedding(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldEmbedding, opts...).ToFunc()
}

// ByWorkspacePath orders the results by the workspacePath field.
func ByWorkspacePath(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldWorkspacePath, opts...).ToFunc()
}

// BySourceFileField orders the results by source_file field.
func BySourceFileField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newSourceFileStep(), sql.OrderByField(field, opts...))
	}
}
func newSourceFileStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(SourceFileInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, SourceFileTable, SourceFileColumn),
	)
}
