// Code generated by ent, DO NOT EDIT.

package db

import (
	"encoding/json"
	"fmt"
	"strings"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/codesnippet"
	"github.com/chaitin/MonkeyCode/backend/db/workspacefile"
	"github.com/google/uuid"
	pgvector "github.com/pgvector/pgvector-go"
)

// CodeSnippet is the model entity for the CodeSnippet schema.
type CodeSnippet struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// 关联的源文件ID
	WorkspaceFileID uuid.UUID `json:"workspace_file_id,omitempty"`
	// 符号名称 (e.g., function name, class name)
	Name string `json:"name,omitempty"`
	// 片段类型 (e.g., import_or_include, function_or_method)
	SnippetType string `json:"snippet_type,omitempty"`
	// 代码语言
	Language string `json:"language,omitempty"`
	// 代码片段原文 (rangeText)
	Content string `json:"content,omitempty"`
	// 代码片段内容的哈希值，用于去重
	Hash string `json:"hash,omitempty"`
	// 在源文件中的起始行号
	StartLine int `json:"start_line,omitempty"`
	// 在源文件中的结束行号
	EndLine int `json:"end_line,omitempty"`
	// 在源文件中的起始列号
	StartColumn int `json:"start_column,omitempty"`
	// 在源文件中的结束列号
	EndColumn int `json:"end_column,omitempty"`
	// 所处的namespace名称
	Namespace string `json:"namespace,omitempty"`
	// 所处的class/struct/interface名称
	ContainerName string `json:"container_name,omitempty"`
	// 作用域链
	Scope []string `json:"scope,omitempty"`
	// 依赖项
	Dependencies []string `json:"dependencies,omitempty"`
	// 参数信息列表 (ParameterInfo[])
	Parameters []map[string]interface{} `json:"parameters,omitempty"`
	// 函数/方法签名
	Signature string `json:"signature,omitempty"`
	// 定义文本，用于提供定义参考
	DefinitionText string `json:"definition_text,omitempty"`
	// 结构化信息 (definition)
	StructuredInfo map[string]interface{} `json:"structured_info,omitempty"`
	// Vector embedding for semantic search
	Embedding pgvector.Vector `json:"embedding,omitempty"`
	// 工作区路径，用于快速查找
	WorkspacePath string `json:"workspacePath,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the CodeSnippetQuery when eager-loading is set.
	Edges        CodeSnippetEdges `json:"edges"`
	selectValues sql.SelectValues
}

// CodeSnippetEdges holds the relations/edges for other nodes in the graph.
type CodeSnippetEdges struct {
	// SourceFile holds the value of the source_file edge.
	SourceFile *WorkspaceFile `json:"source_file,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [1]bool
}

// SourceFileOrErr returns the SourceFile value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e CodeSnippetEdges) SourceFileOrErr() (*WorkspaceFile, error) {
	if e.SourceFile != nil {
		return e.SourceFile, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: workspacefile.Label}
	}
	return nil, &NotLoadedError{edge: "source_file"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*CodeSnippet) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case codesnippet.FieldScope, codesnippet.FieldDependencies, codesnippet.FieldParameters, codesnippet.FieldStructuredInfo:
			values[i] = new([]byte)
		case codesnippet.FieldEmbedding:
			values[i] = new(pgvector.Vector)
		case codesnippet.FieldStartLine, codesnippet.FieldEndLine, codesnippet.FieldStartColumn, codesnippet.FieldEndColumn:
			values[i] = new(sql.NullInt64)
		case codesnippet.FieldName, codesnippet.FieldSnippetType, codesnippet.FieldLanguage, codesnippet.FieldContent, codesnippet.FieldHash, codesnippet.FieldNamespace, codesnippet.FieldContainerName, codesnippet.FieldSignature, codesnippet.FieldDefinitionText, codesnippet.FieldWorkspacePath:
			values[i] = new(sql.NullString)
		case codesnippet.FieldID, codesnippet.FieldWorkspaceFileID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the CodeSnippet fields.
func (cs *CodeSnippet) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case codesnippet.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				cs.ID = *value
			}
		case codesnippet.FieldWorkspaceFileID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field workspace_file_id", values[i])
			} else if value != nil {
				cs.WorkspaceFileID = *value
			}
		case codesnippet.FieldName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field name", values[i])
			} else if value.Valid {
				cs.Name = value.String
			}
		case codesnippet.FieldSnippetType:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field snippet_type", values[i])
			} else if value.Valid {
				cs.SnippetType = value.String
			}
		case codesnippet.FieldLanguage:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field language", values[i])
			} else if value.Valid {
				cs.Language = value.String
			}
		case codesnippet.FieldContent:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field content", values[i])
			} else if value.Valid {
				cs.Content = value.String
			}
		case codesnippet.FieldHash:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field hash", values[i])
			} else if value.Valid {
				cs.Hash = value.String
			}
		case codesnippet.FieldStartLine:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field start_line", values[i])
			} else if value.Valid {
				cs.StartLine = int(value.Int64)
			}
		case codesnippet.FieldEndLine:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field end_line", values[i])
			} else if value.Valid {
				cs.EndLine = int(value.Int64)
			}
		case codesnippet.FieldStartColumn:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field start_column", values[i])
			} else if value.Valid {
				cs.StartColumn = int(value.Int64)
			}
		case codesnippet.FieldEndColumn:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field end_column", values[i])
			} else if value.Valid {
				cs.EndColumn = int(value.Int64)
			}
		case codesnippet.FieldNamespace:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field namespace", values[i])
			} else if value.Valid {
				cs.Namespace = value.String
			}
		case codesnippet.FieldContainerName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field container_name", values[i])
			} else if value.Valid {
				cs.ContainerName = value.String
			}
		case codesnippet.FieldScope:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field scope", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &cs.Scope); err != nil {
					return fmt.Errorf("unmarshal field scope: %w", err)
				}
			}
		case codesnippet.FieldDependencies:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field dependencies", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &cs.Dependencies); err != nil {
					return fmt.Errorf("unmarshal field dependencies: %w", err)
				}
			}
		case codesnippet.FieldParameters:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field parameters", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &cs.Parameters); err != nil {
					return fmt.Errorf("unmarshal field parameters: %w", err)
				}
			}
		case codesnippet.FieldSignature:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field signature", values[i])
			} else if value.Valid {
				cs.Signature = value.String
			}
		case codesnippet.FieldDefinitionText:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field definition_text", values[i])
			} else if value.Valid {
				cs.DefinitionText = value.String
			}
		case codesnippet.FieldStructuredInfo:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field structured_info", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &cs.StructuredInfo); err != nil {
					return fmt.Errorf("unmarshal field structured_info: %w", err)
				}
			}
		case codesnippet.FieldEmbedding:
			if value, ok := values[i].(*pgvector.Vector); !ok {
				return fmt.Errorf("unexpected type %T for field embedding", values[i])
			} else if value != nil {
				cs.Embedding = *value
			}
		case codesnippet.FieldWorkspacePath:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field workspacePath", values[i])
			} else if value.Valid {
				cs.WorkspacePath = value.String
			}
		default:
			cs.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the CodeSnippet.
// This includes values selected through modifiers, order, etc.
func (cs *CodeSnippet) Value(name string) (ent.Value, error) {
	return cs.selectValues.Get(name)
}

// QuerySourceFile queries the "source_file" edge of the CodeSnippet entity.
func (cs *CodeSnippet) QuerySourceFile() *WorkspaceFileQuery {
	return NewCodeSnippetClient(cs.config).QuerySourceFile(cs)
}

// Update returns a builder for updating this CodeSnippet.
// Note that you need to call CodeSnippet.Unwrap() before calling this method if this CodeSnippet
// was returned from a transaction, and the transaction was committed or rolled back.
func (cs *CodeSnippet) Update() *CodeSnippetUpdateOne {
	return NewCodeSnippetClient(cs.config).UpdateOne(cs)
}

// Unwrap unwraps the CodeSnippet entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (cs *CodeSnippet) Unwrap() *CodeSnippet {
	_tx, ok := cs.config.driver.(*txDriver)
	if !ok {
		panic("db: CodeSnippet is not a transactional entity")
	}
	cs.config.driver = _tx.drv
	return cs
}

// String implements the fmt.Stringer.
func (cs *CodeSnippet) String() string {
	var builder strings.Builder
	builder.WriteString("CodeSnippet(")
	builder.WriteString(fmt.Sprintf("id=%v, ", cs.ID))
	builder.WriteString("workspace_file_id=")
	builder.WriteString(fmt.Sprintf("%v", cs.WorkspaceFileID))
	builder.WriteString(", ")
	builder.WriteString("name=")
	builder.WriteString(cs.Name)
	builder.WriteString(", ")
	builder.WriteString("snippet_type=")
	builder.WriteString(cs.SnippetType)
	builder.WriteString(", ")
	builder.WriteString("language=")
	builder.WriteString(cs.Language)
	builder.WriteString(", ")
	builder.WriteString("content=")
	builder.WriteString(cs.Content)
	builder.WriteString(", ")
	builder.WriteString("hash=")
	builder.WriteString(cs.Hash)
	builder.WriteString(", ")
	builder.WriteString("start_line=")
	builder.WriteString(fmt.Sprintf("%v", cs.StartLine))
	builder.WriteString(", ")
	builder.WriteString("end_line=")
	builder.WriteString(fmt.Sprintf("%v", cs.EndLine))
	builder.WriteString(", ")
	builder.WriteString("start_column=")
	builder.WriteString(fmt.Sprintf("%v", cs.StartColumn))
	builder.WriteString(", ")
	builder.WriteString("end_column=")
	builder.WriteString(fmt.Sprintf("%v", cs.EndColumn))
	builder.WriteString(", ")
	builder.WriteString("namespace=")
	builder.WriteString(cs.Namespace)
	builder.WriteString(", ")
	builder.WriteString("container_name=")
	builder.WriteString(cs.ContainerName)
	builder.WriteString(", ")
	builder.WriteString("scope=")
	builder.WriteString(fmt.Sprintf("%v", cs.Scope))
	builder.WriteString(", ")
	builder.WriteString("dependencies=")
	builder.WriteString(fmt.Sprintf("%v", cs.Dependencies))
	builder.WriteString(", ")
	builder.WriteString("parameters=")
	builder.WriteString(fmt.Sprintf("%v", cs.Parameters))
	builder.WriteString(", ")
	builder.WriteString("signature=")
	builder.WriteString(cs.Signature)
	builder.WriteString(", ")
	builder.WriteString("definition_text=")
	builder.WriteString(cs.DefinitionText)
	builder.WriteString(", ")
	builder.WriteString("structured_info=")
	builder.WriteString(fmt.Sprintf("%v", cs.StructuredInfo))
	builder.WriteString(", ")
	builder.WriteString("embedding=")
	builder.WriteString(fmt.Sprintf("%v", cs.Embedding))
	builder.WriteString(", ")
	builder.WriteString("workspacePath=")
	builder.WriteString(cs.WorkspacePath)
	builder.WriteByte(')')
	return builder.String()
}

// CodeSnippets is a parsable slice of CodeSnippet.
type CodeSnippets []*CodeSnippet
