// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/billingusage"
)

// BillingUsage is the model entity for the BillingUsage schema.
type BillingUsage struct {
	config `json:"-"`
	// ID of the ent.
	ID string `json:"id,omitempty"`
	// DeletedAt holds the value of the "deleted_at" field.
	DeletedAt time.Time `json:"deleted_at,omitempty"`
	// UserID holds the value of the "user_id" field.
	UserID string `json:"user_id,omitempty"`
	// ModelName holds the value of the "model_name" field.
	ModelName string `json:"model_name,omitempty"`
	// Tokens holds the value of the "tokens" field.
	Tokens int64 `json:"tokens,omitempty"`
	// Operation holds the value of the "operation" field.
	Operation string `json:"operation,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt    time.Time `json:"updated_at,omitempty"`
	selectValues sql.SelectValues
}

// scanValues returns the types for scanning values from sql.Rows.
func (*BillingUsage) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case billingusage.FieldTokens:
			values[i] = new(sql.NullInt64)
		case billingusage.FieldID, billingusage.FieldUserID, billingusage.FieldModelName, billingusage.FieldOperation:
			values[i] = new(sql.NullString)
		case billingusage.FieldDeletedAt, billingusage.FieldCreatedAt, billingusage.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the BillingUsage fields.
func (bu *BillingUsage) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case billingusage.FieldID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value.Valid {
				bu.ID = value.String
			}
		case billingusage.FieldDeletedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field deleted_at", values[i])
			} else if value.Valid {
				bu.DeletedAt = value.Time
			}
		case billingusage.FieldUserID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field user_id", values[i])
			} else if value.Valid {
				bu.UserID = value.String
			}
		case billingusage.FieldModelName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field model_name", values[i])
			} else if value.Valid {
				bu.ModelName = value.String
			}
		case billingusage.FieldTokens:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field tokens", values[i])
			} else if value.Valid {
				bu.Tokens = value.Int64
			}
		case billingusage.FieldOperation:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field operation", values[i])
			} else if value.Valid {
				bu.Operation = value.String
			}
		case billingusage.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				bu.CreatedAt = value.Time
			}
		case billingusage.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				bu.UpdatedAt = value.Time
			}
		default:
			bu.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the BillingUsage.
// This includes values selected through modifiers, order, etc.
func (bu *BillingUsage) Value(name string) (ent.Value, error) {
	return bu.selectValues.Get(name)
}

// Update returns a builder for updating this BillingUsage.
// Note that you need to call BillingUsage.Unwrap() before calling this method if this BillingUsage
// was returned from a transaction, and the transaction was committed or rolled back.
func (bu *BillingUsage) Update() *BillingUsageUpdateOne {
	return NewBillingUsageClient(bu.config).UpdateOne(bu)
}

// Unwrap unwraps the BillingUsage entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (bu *BillingUsage) Unwrap() *BillingUsage {
	_tx, ok := bu.config.driver.(*txDriver)
	if !ok {
		panic("db: BillingUsage is not a transactional entity")
	}
	bu.config.driver = _tx.drv
	return bu
}

// String implements the fmt.Stringer.
func (bu *BillingUsage) String() string {
	var builder strings.Builder
	builder.WriteString("BillingUsage(")
	builder.WriteString(fmt.Sprintf("id=%v, ", bu.ID))
	builder.WriteString("deleted_at=")
	builder.WriteString(bu.DeletedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("user_id=")
	builder.WriteString(bu.UserID)
	builder.WriteString(", ")
	builder.WriteString("model_name=")
	builder.WriteString(bu.ModelName)
	builder.WriteString(", ")
	builder.WriteString("tokens=")
	builder.WriteString(fmt.Sprintf("%v", bu.Tokens))
	builder.WriteString(", ")
	builder.WriteString("operation=")
	builder.WriteString(bu.Operation)
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(bu.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(bu.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// BillingUsages is a parsable slice of BillingUsage.
type BillingUsages []*BillingUsage
