// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/billingrecord"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// BillingRecordDelete is the builder for deleting a BillingRecord entity.
type BillingRecordDelete struct {
	config
	hooks    []Hook
	mutation *BillingRecordMutation
}

// Where appends a list predicates to the BillingRecordDelete builder.
func (brd *BillingRecordDelete) Where(ps ...predicate.BillingRecord) *BillingRecordDelete {
	brd.mutation.Where(ps...)
	return brd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (brd *BillingRecordDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, brd.sqlExec, brd.mutation, brd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (brd *BillingRecordDelete) ExecX(ctx context.Context) int {
	n, err := brd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (brd *BillingRecordDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(billingrecord.Table, sqlgraph.NewFieldSpec(billingrecord.FieldID, field.TypeString))
	if ps := brd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, brd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	brd.mutation.done = true
	return affected, err
}

// BillingRecordDeleteOne is the builder for deleting a single BillingRecord entity.
type BillingRecordDeleteOne struct {
	brd *BillingRecordDelete
}

// Where appends a list predicates to the BillingRecordDelete builder.
func (brdo *BillingRecordDeleteOne) Where(ps ...predicate.BillingRecord) *BillingRecordDeleteOne {
	brdo.brd.mutation.Where(ps...)
	return brdo
}

// Exec executes the deletion query.
func (brdo *BillingRecordDeleteOne) Exec(ctx context.Context) error {
	n, err := brdo.brd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{billingrecord.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (brdo *BillingRecordDeleteOne) ExecX(ctx context.Context) {
	if err := brdo.Exec(ctx); err != nil {
		panic(err)
	}
}
