// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/billingquota"
)

// BillingQuotaCreate is the builder for creating a BillingQuota entity.
type BillingQuotaCreate struct {
	config
	mutation *BillingQuotaMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetDeletedAt sets the "deleted_at" field.
func (bqc *BillingQuotaCreate) SetDeletedAt(t time.Time) *BillingQuotaCreate {
	bqc.mutation.SetDeletedAt(t)
	return bqc
}

// SetNillableDeletedAt sets the "deleted_at" field if the given value is not nil.
func (bqc *BillingQuotaCreate) SetNillableDeletedAt(t *time.Time) *BillingQuotaCreate {
	if t != nil {
		bqc.SetDeletedAt(*t)
	}
	return bqc
}

// SetUserID sets the "user_id" field.
func (bqc *BillingQuotaCreate) SetUserID(s string) *BillingQuotaCreate {
	bqc.mutation.SetUserID(s)
	return bqc
}

// SetTotal sets the "total" field.
func (bqc *BillingQuotaCreate) SetTotal(i int64) *BillingQuotaCreate {
	bqc.mutation.SetTotal(i)
	return bqc
}

// SetUsed sets the "used" field.
func (bqc *BillingQuotaCreate) SetUsed(i int64) *BillingQuotaCreate {
	bqc.mutation.SetUsed(i)
	return bqc
}

// SetRemain sets the "remain" field.
func (bqc *BillingQuotaCreate) SetRemain(i int64) *BillingQuotaCreate {
	bqc.mutation.SetRemain(i)
	return bqc
}

// SetCreatedAt sets the "created_at" field.
func (bqc *BillingQuotaCreate) SetCreatedAt(t time.Time) *BillingQuotaCreate {
	bqc.mutation.SetCreatedAt(t)
	return bqc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (bqc *BillingQuotaCreate) SetNillableCreatedAt(t *time.Time) *BillingQuotaCreate {
	if t != nil {
		bqc.SetCreatedAt(*t)
	}
	return bqc
}

// SetUpdatedAt sets the "updated_at" field.
func (bqc *BillingQuotaCreate) SetUpdatedAt(t time.Time) *BillingQuotaCreate {
	bqc.mutation.SetUpdatedAt(t)
	return bqc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (bqc *BillingQuotaCreate) SetNillableUpdatedAt(t *time.Time) *BillingQuotaCreate {
	if t != nil {
		bqc.SetUpdatedAt(*t)
	}
	return bqc
}

// SetID sets the "id" field.
func (bqc *BillingQuotaCreate) SetID(s string) *BillingQuotaCreate {
	bqc.mutation.SetID(s)
	return bqc
}

// Mutation returns the BillingQuotaMutation object of the builder.
func (bqc *BillingQuotaCreate) Mutation() *BillingQuotaMutation {
	return bqc.mutation
}

// Save creates the BillingQuota in the database.
func (bqc *BillingQuotaCreate) Save(ctx context.Context) (*BillingQuota, error) {
	if err := bqc.defaults(); err != nil {
		return nil, err
	}
	return withHooks(ctx, bqc.sqlSave, bqc.mutation, bqc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (bqc *BillingQuotaCreate) SaveX(ctx context.Context) *BillingQuota {
	v, err := bqc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (bqc *BillingQuotaCreate) Exec(ctx context.Context) error {
	_, err := bqc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (bqc *BillingQuotaCreate) ExecX(ctx context.Context) {
	if err := bqc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (bqc *BillingQuotaCreate) defaults() error {
	if _, ok := bqc.mutation.CreatedAt(); !ok {
		if billingquota.DefaultCreatedAt == nil {
			return fmt.Errorf("db: uninitialized billingquota.DefaultCreatedAt (forgotten import db/runtime?)")
		}
		v := billingquota.DefaultCreatedAt()
		bqc.mutation.SetCreatedAt(v)
	}
	if _, ok := bqc.mutation.UpdatedAt(); !ok {
		if billingquota.DefaultUpdatedAt == nil {
			return fmt.Errorf("db: uninitialized billingquota.DefaultUpdatedAt (forgotten import db/runtime?)")
		}
		v := billingquota.DefaultUpdatedAt()
		bqc.mutation.SetUpdatedAt(v)
	}
	return nil
}

// check runs all checks and user-defined validators on the builder.
func (bqc *BillingQuotaCreate) check() error {
	if _, ok := bqc.mutation.UserID(); !ok {
		return &ValidationError{Name: "user_id", err: errors.New(`db: missing required field "BillingQuota.user_id"`)}
	}
	if _, ok := bqc.mutation.Total(); !ok {
		return &ValidationError{Name: "total", err: errors.New(`db: missing required field "BillingQuota.total"`)}
	}
	if _, ok := bqc.mutation.Used(); !ok {
		return &ValidationError{Name: "used", err: errors.New(`db: missing required field "BillingQuota.used"`)}
	}
	if _, ok := bqc.mutation.Remain(); !ok {
		return &ValidationError{Name: "remain", err: errors.New(`db: missing required field "BillingQuota.remain"`)}
	}
	if _, ok := bqc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "BillingQuota.created_at"`)}
	}
	if _, ok := bqc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "BillingQuota.updated_at"`)}
	}
	return nil
}

func (bqc *BillingQuotaCreate) sqlSave(ctx context.Context) (*BillingQuota, error) {
	if err := bqc.check(); err != nil {
		return nil, err
	}
	_node, _spec := bqc.createSpec()
	if err := sqlgraph.CreateNode(ctx, bqc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(string); ok {
			_node.ID = id
		} else {
			return nil, fmt.Errorf("unexpected BillingQuota.ID type: %T", _spec.ID.Value)
		}
	}
	bqc.mutation.id = &_node.ID
	bqc.mutation.done = true
	return _node, nil
}

func (bqc *BillingQuotaCreate) createSpec() (*BillingQuota, *sqlgraph.CreateSpec) {
	var (
		_node = &BillingQuota{config: bqc.config}
		_spec = sqlgraph.NewCreateSpec(billingquota.Table, sqlgraph.NewFieldSpec(billingquota.FieldID, field.TypeString))
	)
	_spec.OnConflict = bqc.conflict
	if id, ok := bqc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = id
	}
	if value, ok := bqc.mutation.DeletedAt(); ok {
		_spec.SetField(billingquota.FieldDeletedAt, field.TypeTime, value)
		_node.DeletedAt = value
	}
	if value, ok := bqc.mutation.UserID(); ok {
		_spec.SetField(billingquota.FieldUserID, field.TypeString, value)
		_node.UserID = value
	}
	if value, ok := bqc.mutation.Total(); ok {
		_spec.SetField(billingquota.FieldTotal, field.TypeInt64, value)
		_node.Total = value
	}
	if value, ok := bqc.mutation.Used(); ok {
		_spec.SetField(billingquota.FieldUsed, field.TypeInt64, value)
		_node.Used = value
	}
	if value, ok := bqc.mutation.Remain(); ok {
		_spec.SetField(billingquota.FieldRemain, field.TypeInt64, value)
		_node.Remain = value
	}
	if value, ok := bqc.mutation.CreatedAt(); ok {
		_spec.SetField(billingquota.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := bqc.mutation.UpdatedAt(); ok {
		_spec.SetField(billingquota.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.BillingQuota.Create().
//		SetDeletedAt(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.BillingQuotaUpsert) {
//			SetDeletedAt(v+v).
//		}).
//		Exec(ctx)
func (bqc *BillingQuotaCreate) OnConflict(opts ...sql.ConflictOption) *BillingQuotaUpsertOne {
	bqc.conflict = opts
	return &BillingQuotaUpsertOne{
		create: bqc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.BillingQuota.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (bqc *BillingQuotaCreate) OnConflictColumns(columns ...string) *BillingQuotaUpsertOne {
	bqc.conflict = append(bqc.conflict, sql.ConflictColumns(columns...))
	return &BillingQuotaUpsertOne{
		create: bqc,
	}
}

type (
	// BillingQuotaUpsertOne is the builder for "upsert"-ing
	//  one BillingQuota node.
	BillingQuotaUpsertOne struct {
		create *BillingQuotaCreate
	}

	// BillingQuotaUpsert is the "OnConflict" setter.
	BillingQuotaUpsert struct {
		*sql.UpdateSet
	}
)

// SetDeletedAt sets the "deleted_at" field.
func (u *BillingQuotaUpsert) SetDeletedAt(v time.Time) *BillingQuotaUpsert {
	u.Set(billingquota.FieldDeletedAt, v)
	return u
}

// UpdateDeletedAt sets the "deleted_at" field to the value that was provided on create.
func (u *BillingQuotaUpsert) UpdateDeletedAt() *BillingQuotaUpsert {
	u.SetExcluded(billingquota.FieldDeletedAt)
	return u
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (u *BillingQuotaUpsert) ClearDeletedAt() *BillingQuotaUpsert {
	u.SetNull(billingquota.FieldDeletedAt)
	return u
}

// SetUserID sets the "user_id" field.
func (u *BillingQuotaUpsert) SetUserID(v string) *BillingQuotaUpsert {
	u.Set(billingquota.FieldUserID, v)
	return u
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *BillingQuotaUpsert) UpdateUserID() *BillingQuotaUpsert {
	u.SetExcluded(billingquota.FieldUserID)
	return u
}

// SetTotal sets the "total" field.
func (u *BillingQuotaUpsert) SetTotal(v int64) *BillingQuotaUpsert {
	u.Set(billingquota.FieldTotal, v)
	return u
}

// UpdateTotal sets the "total" field to the value that was provided on create.
func (u *BillingQuotaUpsert) UpdateTotal() *BillingQuotaUpsert {
	u.SetExcluded(billingquota.FieldTotal)
	return u
}

// AddTotal adds v to the "total" field.
func (u *BillingQuotaUpsert) AddTotal(v int64) *BillingQuotaUpsert {
	u.Add(billingquota.FieldTotal, v)
	return u
}

// SetUsed sets the "used" field.
func (u *BillingQuotaUpsert) SetUsed(v int64) *BillingQuotaUpsert {
	u.Set(billingquota.FieldUsed, v)
	return u
}

// UpdateUsed sets the "used" field to the value that was provided on create.
func (u *BillingQuotaUpsert) UpdateUsed() *BillingQuotaUpsert {
	u.SetExcluded(billingquota.FieldUsed)
	return u
}

// AddUsed adds v to the "used" field.
func (u *BillingQuotaUpsert) AddUsed(v int64) *BillingQuotaUpsert {
	u.Add(billingquota.FieldUsed, v)
	return u
}

// SetRemain sets the "remain" field.
func (u *BillingQuotaUpsert) SetRemain(v int64) *BillingQuotaUpsert {
	u.Set(billingquota.FieldRemain, v)
	return u
}

// UpdateRemain sets the "remain" field to the value that was provided on create.
func (u *BillingQuotaUpsert) UpdateRemain() *BillingQuotaUpsert {
	u.SetExcluded(billingquota.FieldRemain)
	return u
}

// AddRemain adds v to the "remain" field.
func (u *BillingQuotaUpsert) AddRemain(v int64) *BillingQuotaUpsert {
	u.Add(billingquota.FieldRemain, v)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *BillingQuotaUpsert) SetCreatedAt(v time.Time) *BillingQuotaUpsert {
	u.Set(billingquota.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *BillingQuotaUpsert) UpdateCreatedAt() *BillingQuotaUpsert {
	u.SetExcluded(billingquota.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *BillingQuotaUpsert) SetUpdatedAt(v time.Time) *BillingQuotaUpsert {
	u.Set(billingquota.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *BillingQuotaUpsert) UpdateUpdatedAt() *BillingQuotaUpsert {
	u.SetExcluded(billingquota.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.BillingQuota.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(billingquota.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *BillingQuotaUpsertOne) UpdateNewValues() *BillingQuotaUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(billingquota.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.BillingQuota.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *BillingQuotaUpsertOne) Ignore() *BillingQuotaUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *BillingQuotaUpsertOne) DoNothing() *BillingQuotaUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the BillingQuotaCreate.OnConflict
// documentation for more info.
func (u *BillingQuotaUpsertOne) Update(set func(*BillingQuotaUpsert)) *BillingQuotaUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&BillingQuotaUpsert{UpdateSet: update})
	}))
	return u
}

// SetDeletedAt sets the "deleted_at" field.
func (u *BillingQuotaUpsertOne) SetDeletedAt(v time.Time) *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.SetDeletedAt(v)
	})
}

// UpdateDeletedAt sets the "deleted_at" field to the value that was provided on create.
func (u *BillingQuotaUpsertOne) UpdateDeletedAt() *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.UpdateDeletedAt()
	})
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (u *BillingQuotaUpsertOne) ClearDeletedAt() *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.ClearDeletedAt()
	})
}

// SetUserID sets the "user_id" field.
func (u *BillingQuotaUpsertOne) SetUserID(v string) *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *BillingQuotaUpsertOne) UpdateUserID() *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.UpdateUserID()
	})
}

// SetTotal sets the "total" field.
func (u *BillingQuotaUpsertOne) SetTotal(v int64) *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.SetTotal(v)
	})
}

// AddTotal adds v to the "total" field.
func (u *BillingQuotaUpsertOne) AddTotal(v int64) *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.AddTotal(v)
	})
}

// UpdateTotal sets the "total" field to the value that was provided on create.
func (u *BillingQuotaUpsertOne) UpdateTotal() *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.UpdateTotal()
	})
}

// SetUsed sets the "used" field.
func (u *BillingQuotaUpsertOne) SetUsed(v int64) *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.SetUsed(v)
	})
}

// AddUsed adds v to the "used" field.
func (u *BillingQuotaUpsertOne) AddUsed(v int64) *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.AddUsed(v)
	})
}

// UpdateUsed sets the "used" field to the value that was provided on create.
func (u *BillingQuotaUpsertOne) UpdateUsed() *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.UpdateUsed()
	})
}

// SetRemain sets the "remain" field.
func (u *BillingQuotaUpsertOne) SetRemain(v int64) *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.SetRemain(v)
	})
}

// AddRemain adds v to the "remain" field.
func (u *BillingQuotaUpsertOne) AddRemain(v int64) *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.AddRemain(v)
	})
}

// UpdateRemain sets the "remain" field to the value that was provided on create.
func (u *BillingQuotaUpsertOne) UpdateRemain() *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.UpdateRemain()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *BillingQuotaUpsertOne) SetCreatedAt(v time.Time) *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *BillingQuotaUpsertOne) UpdateCreatedAt() *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *BillingQuotaUpsertOne) SetUpdatedAt(v time.Time) *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *BillingQuotaUpsertOne) UpdateUpdatedAt() *BillingQuotaUpsertOne {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *BillingQuotaUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for BillingQuotaCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *BillingQuotaUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *BillingQuotaUpsertOne) ID(ctx context.Context) (id string, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: BillingQuotaUpsertOne.ID is not supported by MySQL driver. Use BillingQuotaUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *BillingQuotaUpsertOne) IDX(ctx context.Context) string {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// BillingQuotaCreateBulk is the builder for creating many BillingQuota entities in bulk.
type BillingQuotaCreateBulk struct {
	config
	err      error
	builders []*BillingQuotaCreate
	conflict []sql.ConflictOption
}

// Save creates the BillingQuota entities in the database.
func (bqcb *BillingQuotaCreateBulk) Save(ctx context.Context) ([]*BillingQuota, error) {
	if bqcb.err != nil {
		return nil, bqcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(bqcb.builders))
	nodes := make([]*BillingQuota, len(bqcb.builders))
	mutators := make([]Mutator, len(bqcb.builders))
	for i := range bqcb.builders {
		func(i int, root context.Context) {
			builder := bqcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*BillingQuotaMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, bqcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = bqcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, bqcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, bqcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (bqcb *BillingQuotaCreateBulk) SaveX(ctx context.Context) []*BillingQuota {
	v, err := bqcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (bqcb *BillingQuotaCreateBulk) Exec(ctx context.Context) error {
	_, err := bqcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (bqcb *BillingQuotaCreateBulk) ExecX(ctx context.Context) {
	if err := bqcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.BillingQuota.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.BillingQuotaUpsert) {
//			SetDeletedAt(v+v).
//		}).
//		Exec(ctx)
func (bqcb *BillingQuotaCreateBulk) OnConflict(opts ...sql.ConflictOption) *BillingQuotaUpsertBulk {
	bqcb.conflict = opts
	return &BillingQuotaUpsertBulk{
		create: bqcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.BillingQuota.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (bqcb *BillingQuotaCreateBulk) OnConflictColumns(columns ...string) *BillingQuotaUpsertBulk {
	bqcb.conflict = append(bqcb.conflict, sql.ConflictColumns(columns...))
	return &BillingQuotaUpsertBulk{
		create: bqcb,
	}
}

// BillingQuotaUpsertBulk is the builder for "upsert"-ing
// a bulk of BillingQuota nodes.
type BillingQuotaUpsertBulk struct {
	create *BillingQuotaCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.BillingQuota.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(billingquota.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *BillingQuotaUpsertBulk) UpdateNewValues() *BillingQuotaUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(billingquota.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.BillingQuota.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *BillingQuotaUpsertBulk) Ignore() *BillingQuotaUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *BillingQuotaUpsertBulk) DoNothing() *BillingQuotaUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the BillingQuotaCreateBulk.OnConflict
// documentation for more info.
func (u *BillingQuotaUpsertBulk) Update(set func(*BillingQuotaUpsert)) *BillingQuotaUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&BillingQuotaUpsert{UpdateSet: update})
	}))
	return u
}

// SetDeletedAt sets the "deleted_at" field.
func (u *BillingQuotaUpsertBulk) SetDeletedAt(v time.Time) *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.SetDeletedAt(v)
	})
}

// UpdateDeletedAt sets the "deleted_at" field to the value that was provided on create.
func (u *BillingQuotaUpsertBulk) UpdateDeletedAt() *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.UpdateDeletedAt()
	})
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (u *BillingQuotaUpsertBulk) ClearDeletedAt() *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.ClearDeletedAt()
	})
}

// SetUserID sets the "user_id" field.
func (u *BillingQuotaUpsertBulk) SetUserID(v string) *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *BillingQuotaUpsertBulk) UpdateUserID() *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.UpdateUserID()
	})
}

// SetTotal sets the "total" field.
func (u *BillingQuotaUpsertBulk) SetTotal(v int64) *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.SetTotal(v)
	})
}

// AddTotal adds v to the "total" field.
func (u *BillingQuotaUpsertBulk) AddTotal(v int64) *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.AddTotal(v)
	})
}

// UpdateTotal sets the "total" field to the value that was provided on create.
func (u *BillingQuotaUpsertBulk) UpdateTotal() *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.UpdateTotal()
	})
}

// SetUsed sets the "used" field.
func (u *BillingQuotaUpsertBulk) SetUsed(v int64) *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.SetUsed(v)
	})
}

// AddUsed adds v to the "used" field.
func (u *BillingQuotaUpsertBulk) AddUsed(v int64) *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.AddUsed(v)
	})
}

// UpdateUsed sets the "used" field to the value that was provided on create.
func (u *BillingQuotaUpsertBulk) UpdateUsed() *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.UpdateUsed()
	})
}

// SetRemain sets the "remain" field.
func (u *BillingQuotaUpsertBulk) SetRemain(v int64) *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.SetRemain(v)
	})
}

// AddRemain adds v to the "remain" field.
func (u *BillingQuotaUpsertBulk) AddRemain(v int64) *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.AddRemain(v)
	})
}

// UpdateRemain sets the "remain" field to the value that was provided on create.
func (u *BillingQuotaUpsertBulk) UpdateRemain() *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.UpdateRemain()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *BillingQuotaUpsertBulk) SetCreatedAt(v time.Time) *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *BillingQuotaUpsertBulk) UpdateCreatedAt() *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *BillingQuotaUpsertBulk) SetUpdatedAt(v time.Time) *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *BillingQuotaUpsertBulk) UpdateUpdatedAt() *BillingQuotaUpsertBulk {
	return u.Update(func(s *BillingQuotaUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *BillingQuotaUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the BillingQuotaCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for BillingQuotaCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *BillingQuotaUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
