// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/billingquota"
)

// BillingQuota is the model entity for the BillingQuota schema.
type BillingQuota struct {
	config `json:"-"`
	// ID of the ent.
	ID string `json:"id,omitempty"`
	// DeletedAt holds the value of the "deleted_at" field.
	DeletedAt time.Time `json:"deleted_at,omitempty"`
	// UserID holds the value of the "user_id" field.
	UserID string `json:"user_id,omitempty"`
	// Total holds the value of the "total" field.
	Total int64 `json:"total,omitempty"`
	// Used holds the value of the "used" field.
	Used int64 `json:"used,omitempty"`
	// Remain holds the value of the "remain" field.
	Remain int64 `json:"remain,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt    time.Time `json:"updated_at,omitempty"`
	selectValues sql.SelectValues
}

// scanValues returns the types for scanning values from sql.Rows.
func (*BillingQuota) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case billingquota.FieldTotal, billingquota.FieldUsed, billingquota.FieldRemain:
			values[i] = new(sql.NullInt64)
		case billingquota.FieldID, billingquota.FieldUserID:
			values[i] = new(sql.NullString)
		case billingquota.FieldDeletedAt, billingquota.FieldCreatedAt, billingquota.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the BillingQuota fields.
func (bq *BillingQuota) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case billingquota.FieldID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value.Valid {
				bq.ID = value.String
			}
		case billingquota.FieldDeletedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field deleted_at", values[i])
			} else if value.Valid {
				bq.DeletedAt = value.Time
			}
		case billingquota.FieldUserID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field user_id", values[i])
			} else if value.Valid {
				bq.UserID = value.String
			}
		case billingquota.FieldTotal:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field total", values[i])
			} else if value.Valid {
				bq.Total = value.Int64
			}
		case billingquota.FieldUsed:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field used", values[i])
			} else if value.Valid {
				bq.Used = value.Int64
			}
		case billingquota.FieldRemain:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field remain", values[i])
			} else if value.Valid {
				bq.Remain = value.Int64
			}
		case billingquota.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				bq.CreatedAt = value.Time
			}
		case billingquota.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				bq.UpdatedAt = value.Time
			}
		default:
			bq.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the BillingQuota.
// This includes values selected through modifiers, order, etc.
func (bq *BillingQuota) Value(name string) (ent.Value, error) {
	return bq.selectValues.Get(name)
}

// Update returns a builder for updating this BillingQuota.
// Note that you need to call BillingQuota.Unwrap() before calling this method if this BillingQuota
// was returned from a transaction, and the transaction was committed or rolled back.
func (bq *BillingQuota) Update() *BillingQuotaUpdateOne {
	return NewBillingQuotaClient(bq.config).UpdateOne(bq)
}

// Unwrap unwraps the BillingQuota entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (bq *BillingQuota) Unwrap() *BillingQuota {
	_tx, ok := bq.config.driver.(*txDriver)
	if !ok {
		panic("db: BillingQuota is not a transactional entity")
	}
	bq.config.driver = _tx.drv
	return bq
}

// String implements the fmt.Stringer.
func (bq *BillingQuota) String() string {
	var builder strings.Builder
	builder.WriteString("BillingQuota(")
	builder.WriteString(fmt.Sprintf("id=%v, ", bq.ID))
	builder.WriteString("deleted_at=")
	builder.WriteString(bq.DeletedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("user_id=")
	builder.WriteString(bq.UserID)
	builder.WriteString(", ")
	builder.WriteString("total=")
	builder.WriteString(fmt.Sprintf("%v", bq.Total))
	builder.WriteString(", ")
	builder.WriteString("used=")
	builder.WriteString(fmt.Sprintf("%v", bq.Used))
	builder.WriteString(", ")
	builder.WriteString("remain=")
	builder.WriteString(fmt.Sprintf("%v", bq.Remain))
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(bq.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(bq.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// BillingQuotaSlice is a parsable slice of BillingQuota.
type BillingQuotaSlice []*BillingQuota
