// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/billingplan"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// BillingPlanDelete is the builder for deleting a BillingPlan entity.
type BillingPlanDelete struct {
	config
	hooks    []Hook
	mutation *BillingPlanMutation
}

// Where appends a list predicates to the BillingPlanDelete builder.
func (bpd *BillingPlanDelete) Where(ps ...predicate.BillingPlan) *BillingPlanDelete {
	bpd.mutation.Where(ps...)
	return bpd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (bpd *BillingPlanDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, bpd.sqlExec, bpd.mutation, bpd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (bpd *BillingPlanDelete) ExecX(ctx context.Context) int {
	n, err := bpd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (bpd *BillingPlanDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(billingplan.Table, sqlgraph.NewFieldSpec(billingplan.FieldID, field.TypeString))
	if ps := bpd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, bpd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	bpd.mutation.done = true
	return affected, err
}

// BillingPlanDeleteOne is the builder for deleting a single BillingPlan entity.
type BillingPlanDeleteOne struct {
	bpd *BillingPlanDelete
}

// Where appends a list predicates to the BillingPlanDelete builder.
func (bpdo *BillingPlanDeleteOne) Where(ps ...predicate.BillingPlan) *BillingPlanDeleteOne {
	bpdo.bpd.mutation.Where(ps...)
	return bpdo
}

// Exec executes the deletion query.
func (bpdo *BillingPlanDeleteOne) Exec(ctx context.Context) error {
	n, err := bpdo.bpd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{billingplan.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (bpdo *BillingPlanDeleteOne) ExecX(ctx context.Context) {
	if err := bpdo.Exec(ctx); err != nil {
		panic(err)
	}
}
