// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/billingplan"
)

// BillingPlanCreate is the builder for creating a BillingPlan entity.
type BillingPlanCreate struct {
	config
	mutation *BillingPlanMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetName sets the "name" field.
func (bpc *BillingPlanCreate) SetName(s string) *BillingPlanCreate {
	bpc.mutation.SetName(s)
	return bpc
}

// SetDescription sets the "description" field.
func (bpc *BillingPlanCreate) SetDescription(s string) *BillingPlanCreate {
	bpc.mutation.SetDescription(s)
	return bpc
}

// SetRules sets the "rules" field.
func (bpc *BillingPlanCreate) SetRules(m map[string]interface{}) *BillingPlanCreate {
	bpc.mutation.SetRules(m)
	return bpc
}

// SetCreatedAt sets the "created_at" field.
func (bpc *BillingPlanCreate) SetCreatedAt(t time.Time) *BillingPlanCreate {
	bpc.mutation.SetCreatedAt(t)
	return bpc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (bpc *BillingPlanCreate) SetNillableCreatedAt(t *time.Time) *BillingPlanCreate {
	if t != nil {
		bpc.SetCreatedAt(*t)
	}
	return bpc
}

// SetUpdatedAt sets the "updated_at" field.
func (bpc *BillingPlanCreate) SetUpdatedAt(t time.Time) *BillingPlanCreate {
	bpc.mutation.SetUpdatedAt(t)
	return bpc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (bpc *BillingPlanCreate) SetNillableUpdatedAt(t *time.Time) *BillingPlanCreate {
	if t != nil {
		bpc.SetUpdatedAt(*t)
	}
	return bpc
}

// SetID sets the "id" field.
func (bpc *BillingPlanCreate) SetID(s string) *BillingPlanCreate {
	bpc.mutation.SetID(s)
	return bpc
}

// Mutation returns the BillingPlanMutation object of the builder.
func (bpc *BillingPlanCreate) Mutation() *BillingPlanMutation {
	return bpc.mutation
}

// Save creates the BillingPlan in the database.
func (bpc *BillingPlanCreate) Save(ctx context.Context) (*BillingPlan, error) {
	bpc.defaults()
	return withHooks(ctx, bpc.sqlSave, bpc.mutation, bpc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (bpc *BillingPlanCreate) SaveX(ctx context.Context) *BillingPlan {
	v, err := bpc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (bpc *BillingPlanCreate) Exec(ctx context.Context) error {
	_, err := bpc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (bpc *BillingPlanCreate) ExecX(ctx context.Context) {
	if err := bpc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (bpc *BillingPlanCreate) defaults() {
	if _, ok := bpc.mutation.CreatedAt(); !ok {
		v := billingplan.DefaultCreatedAt()
		bpc.mutation.SetCreatedAt(v)
	}
	if _, ok := bpc.mutation.UpdatedAt(); !ok {
		v := billingplan.DefaultUpdatedAt()
		bpc.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (bpc *BillingPlanCreate) check() error {
	if _, ok := bpc.mutation.Name(); !ok {
		return &ValidationError{Name: "name", err: errors.New(`db: missing required field "BillingPlan.name"`)}
	}
	if _, ok := bpc.mutation.Description(); !ok {
		return &ValidationError{Name: "description", err: errors.New(`db: missing required field "BillingPlan.description"`)}
	}
	if _, ok := bpc.mutation.Rules(); !ok {
		return &ValidationError{Name: "rules", err: errors.New(`db: missing required field "BillingPlan.rules"`)}
	}
	if _, ok := bpc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "BillingPlan.created_at"`)}
	}
	if _, ok := bpc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "BillingPlan.updated_at"`)}
	}
	return nil
}

func (bpc *BillingPlanCreate) sqlSave(ctx context.Context) (*BillingPlan, error) {
	if err := bpc.check(); err != nil {
		return nil, err
	}
	_node, _spec := bpc.createSpec()
	if err := sqlgraph.CreateNode(ctx, bpc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(string); ok {
			_node.ID = id
		} else {
			return nil, fmt.Errorf("unexpected BillingPlan.ID type: %T", _spec.ID.Value)
		}
	}
	bpc.mutation.id = &_node.ID
	bpc.mutation.done = true
	return _node, nil
}

func (bpc *BillingPlanCreate) createSpec() (*BillingPlan, *sqlgraph.CreateSpec) {
	var (
		_node = &BillingPlan{config: bpc.config}
		_spec = sqlgraph.NewCreateSpec(billingplan.Table, sqlgraph.NewFieldSpec(billingplan.FieldID, field.TypeString))
	)
	_spec.OnConflict = bpc.conflict
	if id, ok := bpc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = id
	}
	if value, ok := bpc.mutation.Name(); ok {
		_spec.SetField(billingplan.FieldName, field.TypeString, value)
		_node.Name = value
	}
	if value, ok := bpc.mutation.Description(); ok {
		_spec.SetField(billingplan.FieldDescription, field.TypeString, value)
		_node.Description = value
	}
	if value, ok := bpc.mutation.Rules(); ok {
		_spec.SetField(billingplan.FieldRules, field.TypeJSON, value)
		_node.Rules = value
	}
	if value, ok := bpc.mutation.CreatedAt(); ok {
		_spec.SetField(billingplan.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := bpc.mutation.UpdatedAt(); ok {
		_spec.SetField(billingplan.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.BillingPlan.Create().
//		SetName(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.BillingPlanUpsert) {
//			SetName(v+v).
//		}).
//		Exec(ctx)
func (bpc *BillingPlanCreate) OnConflict(opts ...sql.ConflictOption) *BillingPlanUpsertOne {
	bpc.conflict = opts
	return &BillingPlanUpsertOne{
		create: bpc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.BillingPlan.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (bpc *BillingPlanCreate) OnConflictColumns(columns ...string) *BillingPlanUpsertOne {
	bpc.conflict = append(bpc.conflict, sql.ConflictColumns(columns...))
	return &BillingPlanUpsertOne{
		create: bpc,
	}
}

type (
	// BillingPlanUpsertOne is the builder for "upsert"-ing
	//  one BillingPlan node.
	BillingPlanUpsertOne struct {
		create *BillingPlanCreate
	}

	// BillingPlanUpsert is the "OnConflict" setter.
	BillingPlanUpsert struct {
		*sql.UpdateSet
	}
)

// SetName sets the "name" field.
func (u *BillingPlanUpsert) SetName(v string) *BillingPlanUpsert {
	u.Set(billingplan.FieldName, v)
	return u
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *BillingPlanUpsert) UpdateName() *BillingPlanUpsert {
	u.SetExcluded(billingplan.FieldName)
	return u
}

// SetDescription sets the "description" field.
func (u *BillingPlanUpsert) SetDescription(v string) *BillingPlanUpsert {
	u.Set(billingplan.FieldDescription, v)
	return u
}

// UpdateDescription sets the "description" field to the value that was provided on create.
func (u *BillingPlanUpsert) UpdateDescription() *BillingPlanUpsert {
	u.SetExcluded(billingplan.FieldDescription)
	return u
}

// SetRules sets the "rules" field.
func (u *BillingPlanUpsert) SetRules(v map[string]interface{}) *BillingPlanUpsert {
	u.Set(billingplan.FieldRules, v)
	return u
}

// UpdateRules sets the "rules" field to the value that was provided on create.
func (u *BillingPlanUpsert) UpdateRules() *BillingPlanUpsert {
	u.SetExcluded(billingplan.FieldRules)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *BillingPlanUpsert) SetCreatedAt(v time.Time) *BillingPlanUpsert {
	u.Set(billingplan.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *BillingPlanUpsert) UpdateCreatedAt() *BillingPlanUpsert {
	u.SetExcluded(billingplan.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *BillingPlanUpsert) SetUpdatedAt(v time.Time) *BillingPlanUpsert {
	u.Set(billingplan.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *BillingPlanUpsert) UpdateUpdatedAt() *BillingPlanUpsert {
	u.SetExcluded(billingplan.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.BillingPlan.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(billingplan.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *BillingPlanUpsertOne) UpdateNewValues() *BillingPlanUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(billingplan.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.BillingPlan.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *BillingPlanUpsertOne) Ignore() *BillingPlanUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *BillingPlanUpsertOne) DoNothing() *BillingPlanUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the BillingPlanCreate.OnConflict
// documentation for more info.
func (u *BillingPlanUpsertOne) Update(set func(*BillingPlanUpsert)) *BillingPlanUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&BillingPlanUpsert{UpdateSet: update})
	}))
	return u
}

// SetName sets the "name" field.
func (u *BillingPlanUpsertOne) SetName(v string) *BillingPlanUpsertOne {
	return u.Update(func(s *BillingPlanUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *BillingPlanUpsertOne) UpdateName() *BillingPlanUpsertOne {
	return u.Update(func(s *BillingPlanUpsert) {
		s.UpdateName()
	})
}

// SetDescription sets the "description" field.
func (u *BillingPlanUpsertOne) SetDescription(v string) *BillingPlanUpsertOne {
	return u.Update(func(s *BillingPlanUpsert) {
		s.SetDescription(v)
	})
}

// UpdateDescription sets the "description" field to the value that was provided on create.
func (u *BillingPlanUpsertOne) UpdateDescription() *BillingPlanUpsertOne {
	return u.Update(func(s *BillingPlanUpsert) {
		s.UpdateDescription()
	})
}

// SetRules sets the "rules" field.
func (u *BillingPlanUpsertOne) SetRules(v map[string]interface{}) *BillingPlanUpsertOne {
	return u.Update(func(s *BillingPlanUpsert) {
		s.SetRules(v)
	})
}

// UpdateRules sets the "rules" field to the value that was provided on create.
func (u *BillingPlanUpsertOne) UpdateRules() *BillingPlanUpsertOne {
	return u.Update(func(s *BillingPlanUpsert) {
		s.UpdateRules()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *BillingPlanUpsertOne) SetCreatedAt(v time.Time) *BillingPlanUpsertOne {
	return u.Update(func(s *BillingPlanUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *BillingPlanUpsertOne) UpdateCreatedAt() *BillingPlanUpsertOne {
	return u.Update(func(s *BillingPlanUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *BillingPlanUpsertOne) SetUpdatedAt(v time.Time) *BillingPlanUpsertOne {
	return u.Update(func(s *BillingPlanUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *BillingPlanUpsertOne) UpdateUpdatedAt() *BillingPlanUpsertOne {
	return u.Update(func(s *BillingPlanUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *BillingPlanUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for BillingPlanCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *BillingPlanUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *BillingPlanUpsertOne) ID(ctx context.Context) (id string, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: BillingPlanUpsertOne.ID is not supported by MySQL driver. Use BillingPlanUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *BillingPlanUpsertOne) IDX(ctx context.Context) string {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// BillingPlanCreateBulk is the builder for creating many BillingPlan entities in bulk.
type BillingPlanCreateBulk struct {
	config
	err      error
	builders []*BillingPlanCreate
	conflict []sql.ConflictOption
}

// Save creates the BillingPlan entities in the database.
func (bpcb *BillingPlanCreateBulk) Save(ctx context.Context) ([]*BillingPlan, error) {
	if bpcb.err != nil {
		return nil, bpcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(bpcb.builders))
	nodes := make([]*BillingPlan, len(bpcb.builders))
	mutators := make([]Mutator, len(bpcb.builders))
	for i := range bpcb.builders {
		func(i int, root context.Context) {
			builder := bpcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*BillingPlanMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, bpcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = bpcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, bpcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, bpcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (bpcb *BillingPlanCreateBulk) SaveX(ctx context.Context) []*BillingPlan {
	v, err := bpcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (bpcb *BillingPlanCreateBulk) Exec(ctx context.Context) error {
	_, err := bpcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (bpcb *BillingPlanCreateBulk) ExecX(ctx context.Context) {
	if err := bpcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.BillingPlan.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.BillingPlanUpsert) {
//			SetName(v+v).
//		}).
//		Exec(ctx)
func (bpcb *BillingPlanCreateBulk) OnConflict(opts ...sql.ConflictOption) *BillingPlanUpsertBulk {
	bpcb.conflict = opts
	return &BillingPlanUpsertBulk{
		create: bpcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.BillingPlan.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (bpcb *BillingPlanCreateBulk) OnConflictColumns(columns ...string) *BillingPlanUpsertBulk {
	bpcb.conflict = append(bpcb.conflict, sql.ConflictColumns(columns...))
	return &BillingPlanUpsertBulk{
		create: bpcb,
	}
}

// BillingPlanUpsertBulk is the builder for "upsert"-ing
// a bulk of BillingPlan nodes.
type BillingPlanUpsertBulk struct {
	create *BillingPlanCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.BillingPlan.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(billingplan.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *BillingPlanUpsertBulk) UpdateNewValues() *BillingPlanUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(billingplan.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.BillingPlan.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *BillingPlanUpsertBulk) Ignore() *BillingPlanUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *BillingPlanUpsertBulk) DoNothing() *BillingPlanUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the BillingPlanCreateBulk.OnConflict
// documentation for more info.
func (u *BillingPlanUpsertBulk) Update(set func(*BillingPlanUpsert)) *BillingPlanUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&BillingPlanUpsert{UpdateSet: update})
	}))
	return u
}

// SetName sets the "name" field.
func (u *BillingPlanUpsertBulk) SetName(v string) *BillingPlanUpsertBulk {
	return u.Update(func(s *BillingPlanUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *BillingPlanUpsertBulk) UpdateName() *BillingPlanUpsertBulk {
	return u.Update(func(s *BillingPlanUpsert) {
		s.UpdateName()
	})
}

// SetDescription sets the "description" field.
func (u *BillingPlanUpsertBulk) SetDescription(v string) *BillingPlanUpsertBulk {
	return u.Update(func(s *BillingPlanUpsert) {
		s.SetDescription(v)
	})
}

// UpdateDescription sets the "description" field to the value that was provided on create.
func (u *BillingPlanUpsertBulk) UpdateDescription() *BillingPlanUpsertBulk {
	return u.Update(func(s *BillingPlanUpsert) {
		s.UpdateDescription()
	})
}

// SetRules sets the "rules" field.
func (u *BillingPlanUpsertBulk) SetRules(v map[string]interface{}) *BillingPlanUpsertBulk {
	return u.Update(func(s *BillingPlanUpsert) {
		s.SetRules(v)
	})
}

// UpdateRules sets the "rules" field to the value that was provided on create.
func (u *BillingPlanUpsertBulk) UpdateRules() *BillingPlanUpsertBulk {
	return u.Update(func(s *BillingPlanUpsert) {
		s.UpdateRules()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *BillingPlanUpsertBulk) SetCreatedAt(v time.Time) *BillingPlanUpsertBulk {
	return u.Update(func(s *BillingPlanUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *BillingPlanUpsertBulk) UpdateCreatedAt() *BillingPlanUpsertBulk {
	return u.Update(func(s *BillingPlanUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *BillingPlanUpsertBulk) SetUpdatedAt(v time.Time) *BillingPlanUpsertBulk {
	return u.Update(func(s *BillingPlanUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *BillingPlanUpsertBulk) UpdateUpdatedAt() *BillingPlanUpsertBulk {
	return u.Update(func(s *BillingPlanUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *BillingPlanUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the BillingPlanCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for BillingPlanCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *BillingPlanUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
